//----------------------------------------------------------------------------
//  Project Test_At3dx_Dll
//  MicroMouse Productions
//  Copyright  1999-2012. All Rights Reserved.                    
//  Author: Wayne Hogue
//
// these wrapper functions allow the use of either the original or
// the replacement safe C string functions
//
//----------------------------------------------------------------------------

// uncomment following line for VC++
//
#include "stdafx.h"

// uncomment following two lines for BCB
//
//#include <vcl.h>
//#pragma hdrstop

// uncomment following line to use C safe functions
//
#define USE_SAFE_C

#include <stdlib.h>
#include <stdio.h>

#include "at3dx_my_functions.h"

__int32 my_makepath(char* pathPtr, size_t pathSize, const char* drivePtr,
                    const char* dirPtr, const char* fnamePtr, const char* extPtr)
{
  __int32 result = 0;

  // any of drivePtr, dirPtr, fnamePtr, extPtr can be NULL
  //
  if ((pathPtr) && (pathSize > 0))
  {
    memset(pathPtr, 0, pathSize);

#ifdef USE_SAFE_C
    _makepath_s(pathPtr, pathSize, drivePtr, dirPtr, fnamePtr, extPtr);
#else
    _makepath(pathPtr, drivePtr, dirPtr, fnamePtr,extPtr);
#endif

    result = 1;
  }

  return(result);

} // end my_makepath()


__int32 my_splitpath(const char* pathPtr, char* drivePtr, size_t driveSize,
                     char* dirPtr, size_t dirSize,
                     char* fnamePtr, size_t fnameSize,
                     char* extPtr, size_t extSize)
{
  __int32 result = 0;

  // this implementation requires all pointers to be valid
  //
  if ((pathPtr) && (drivePtr) && (driveSize > 0) && (driveSize <= _MAX_DRIVE) &&
      (dirPtr) && (dirSize > 0) && (dirSize <= _MAX_DIR) &&
      (fnamePtr) && (fnameSize > 0) && (fnameSize <= _MAX_FNAME) &&
      (extPtr) && (extSize > 0) && (extSize <= _MAX_EXT))
  {
    memset(drivePtr, 0, driveSize);
    memset(dirPtr, 0, dirSize);
    memset(fnamePtr, 0, fnameSize);
    memset(extPtr, 0, extSize);

#ifdef USE_SAFE_C
    _splitpath_s(pathPtr, drivePtr, driveSize, dirPtr, dirSize, fnamePtr, fnameSize, extPtr, extSize);
#else
    _splitpath(pathPtr, drivePtr, dirPtr, fnamePtr, extPtr);
#endif

    result = 1;
  }

  return(result);

} // end my_splitpath()


__int32 my_sprintf(char* destPtr, size_t destSize, const char *format, ... )
{
  __int32 result = 0;

  if ((destPtr) && (destSize > 0) && (format))
  {
    va_list va;

    va_start(va, format);

#ifdef USE_SAFE_C
    vsprintf_s(destPtr, destSize, format, va);
#else
    vsprintf(destPtr, format, va);
#endif

    va_end(va);

    result = 1;
  }

  return(result);

} // end my_sprintf()


__int32 my_strcat(char* destPtr, size_t destSize, char* srcPtr)
{
  __int32 result = 0;

  // allow one byte for NULL
  //
  if ((destPtr) && (srcPtr) &&
      (strlen(destPtr) + strlen(srcPtr) + 1 <= destSize))
  {
#ifdef USE_SAFE_C
    strcat_s(destPtr, destSize, srcPtr);
#else
    strcat(destPtr, srcPtr);
#endif

    result = 1;
  }

  return(result);

} // end my_strcat()


__int32 my_strcpy(char* destPtr, size_t destSize, char* srcPtr)
{
  __int32 result = 0;

  // allow one byte for NULL
  //
  if ((destPtr) && (srcPtr) && (strlen(srcPtr) + 1 <= destSize))
  {
#ifdef USE_SAFE_C
    strcpy_s(destPtr, destSize, srcPtr);
#else
    strcpy(destPtr, srcPtr);
#endif

    result = 1;
  }

  return(result);

} // end my_strcpy()



__int32 my_wcscpy(wchar_t* destPtr, size_t destSize, wchar_t* srcPtr)
{
  __int32 result = 0;

  // allow one byte for NULL
  //
  if ((destPtr) && (srcPtr) && (wcslen(srcPtr) + 1 <= destSize))
  {
#ifdef USE_SAFE_C
    wcscpy_s(destPtr, destSize, srcPtr);
#else
    wcscpy(destPtr, srcPtr);
#endif

    result = 1;
  }

  return(result);

} // end my_wcscpy()



__int32 my_strncpy(char *destPtr, size_t destSize, const char *srcPtr, size_t count)
{
  __int32 result;

  // allow one byte for NULL
  //
  if ((destPtr) && (srcPtr) && (count > 0) && (count <= destSize))
  {
#ifdef USE_SAFE_C
    strncpy_s(destPtr, destSize, srcPtr, count);
#else
    strncpy(destPtr, srcPtr, count);
#endif

    result = 1;
  }
  else
  {
    result = 0;
  }

  return(result);

} // end my_strncpy()


__int32 my_stricmp(const char* strPtr1, const char* strPtr2)
{
  __int32 result = -1;

  if ((strPtr1) && (strPtr2))
  {
#ifdef USE_SAFE_C
    result = _stricmp(strPtr1, strPtr2);
#else
    result = stricmp(strPtr1, strPtr2);
#endif
  }

  return(result);

} // end my_stricmp()


FILE* my_fopen(const char* filename, const char* mode)
{
  FILE* result = 0;

  if ((filename) && (mode))
  {
#ifdef USE_SAFE_C
    if ((fopen_s(&result, filename, mode)) != 0) result = 0;
#else
    result = fopen(filename, mode);
#endif
  }

  return(result);

} // end my_fopen()


