//----------------------------------------------------------------------------
//  Project At3d DLL
//  MicroMouse Productions
//  Copyright  1993-2012. All Rights Reserved.
//  Author: Wayne Hogue
//---------------------------------------------------------------------------
#ifndef at3ddllH
#define at3ddllH

#ifdef __cplusplus         
extern "C" {
#endif

#ifdef dll_out
  // for the DLL
  //
  #define dll_in_out __declspec(dllexport)             
#else
  // for the Application using the DLL
  //
  #define dll_in_out __declspec(dllimport)
  #pragma comment(lib,"At3dx.lib")
#endif

// exported functions from DLL
//
dll_in_out __int32 __stdcall At3d_Start(void);
dll_in_out __int32 __stdcall At3d_Stop(void);
//
dll_in_out void __stdcall At3d_ShowSecurity(void);
dll_in_out void __stdcall At3d_Show(void);
dll_in_out void __stdcall At3d_Hide(void);
dll_in_out void __stdcall At3d_FormStyle(__int32 onTopFlag);
dll_in_out void __stdcall At3d_Size(__int32 width, __int32 height);
dll_in_out void __stdcall At3d_Position(__int32 left, __int32 top);
dll_in_out void __stdcall At3d_UseWireframe(__int32 type);
dll_in_out void __stdcall At3d_PlaneIndicator(__int32 showFlag);
dll_in_out void __stdcall At3d_ViewType(__int32 parallelFlag);
dll_in_out HWND __stdcall At3d_SetParent(HWND hWndNewParent);
dll_in_out void __stdcall At3d_SetCaption(char* name);
//
dll_in_out __int32 __stdcall At3d_GetCameraViewPoint(double* xPtr, double* yPtr, double* zPtr);
dll_in_out __int32 __stdcall At3d_SetCameraViewPoint(double x, double y, double z);
//
dll_in_out __int32 __stdcall At3d_GetCameraRotateSpeed(__int32* speedPtr);
dll_in_out __int32 __stdcall At3d_SetCameraRotateSpeed(__int32 speed);
dll_in_out void __stdcall At3d_GetCameraAngles(double* xAngle, double* yAngle,
                                               double* zAngle);
dll_in_out void __stdcall At3d_RotateCamera(__int32 relativeFlag, double xAngle,
                                            double yAngle, double zAngle);
//
dll_in_out __int32 __stdcall At3d_GetCameraInitialDistance(double* distancePtr);
dll_in_out __int32 __stdcall At3d_SetCameraInitialDistance(double distance);
dll_in_out __int32 __stdcall At3d_GetCameraDistance(double* distancePtr);
dll_in_out __int32 __stdcall At3d_SetCameraDistance(double distance);
dll_in_out __int32 __stdcall At3d_GetCameraZoomSpeed(__int32* speedPtr);
dll_in_out __int32 __stdcall At3d_SetCameraZoomSpeed(__int32 speed);
dll_in_out void __stdcall At3d_ZoomIn(void);
dll_in_out void __stdcall At3d_ZoomOut(void);
dll_in_out void __stdcall At3d_ZoomReset(void);
//
dll_in_out __int32 __stdcall At3d_GetCameraFieldOfView(double* fieldOfViewvPtr);
dll_in_out __int32 __stdcall At3d_SetCameraFieldOfView(__int32 relativeFlag, double fieldOfView);
//
dll_in_out void __stdcall At3d_GetCameraPan(__int32* xPan, __int32* zPan);
dll_in_out void __stdcall At3d_PanCamera(__int32 relativeFlag, __int32 xPan, __int32 zPan);
dll_in_out void __stdcall At3d_CenterX(void);
dll_in_out void __stdcall At3d_CenterZ(void);
//
dll_in_out void __stdcall At3d_PaintSolid(void);
dll_in_out void __stdcall At3d_PaintShaded(void);
//
dll_in_out void __stdcall At3d_ViewFront(void);
dll_in_out void __stdcall At3d_ViewBack(void);
dll_in_out void __stdcall At3d_ViewRight(void);
dll_in_out void __stdcall At3d_ViewLeft(void);
dll_in_out void __stdcall At3d_ViewTop(void);
dll_in_out void __stdcall At3d_ViewBottom(void);
//
dll_in_out void __stdcall At3d_DrawWireframe(void);
//
dll_in_out __int32 __stdcall At3d_Read(__int32 type, char* name, double scaleFactor);
dll_in_out __int32 __stdcall At3d_BufferRead(__int32 type, double scaleFactor,
                                   char* bufferPtr, __int32 bufferSize);
//
dll_in_out void __stdcall At3d_Write(__int32 type, char* name, double scaleFactor);
dll_in_out __int32 __stdcall At3d_PreBufferWrite(__int32 type);
dll_in_out void __stdcall At3d_BufferWrite(__int32 type, double scaleFactor,
                                 char* bufferPtr, __int32 bufferSize);
dll_in_out void __stdcall At3d_BufferName(char* name);
//
dll_in_out __int32 __stdcall At3d_GetMtlSize(void);
dll_in_out void __stdcall At3d_SetMtlBuffer(char* bufferPtr, __int32 bufferSize);
//
dll_in_out void __stdcall At3d_WriteDXF_3DAs2D(char* name, double scaleFactor);
//
dll_in_out void __stdcall At3d_Clear(void);
//
dll_in_out __int32 __stdcall At3d_ReadFlag(__int32 flagType);
dll_in_out void __stdcall At3d_WriteFlag(__int32 flagType, __int32 flagValue);
//
dll_in_out __int32 __stdcall At3d_CheckName(char* name);
dll_in_out void* __stdcall At3d_ChangeLayerName(char* oldName, char* newName);
//
dll_in_out __int32 __stdcall At3d_LayerCount(void);
dll_in_out void* __stdcall At3d_GetNextLayer(void* layer, char* layerName);
dll_in_out void* __stdcall At3d_CreateLayer(char* layerName);
dll_in_out __int32 __stdcall At3d_DeleteLayer(char* layerName);
dll_in_out __int32 __stdcall At3d_SetLayerTransform(char* layerName, float* arrayPtr);
dll_in_out __int32 __stdcall At3d_GetLayerOutputFlag(char* layerName);
dll_in_out void __stdcall At3d_SetLayerOutputFlag(char* layerName, __int32 flag);
//
dll_in_out __int32 __stdcall At3d_VertexCount(char* layerName);
dll_in_out void* __stdcall At3d_GetVertex(__int32 position, char* layerName,
                                          double* arrayPtr);
dll_in_out void* __stdcall At3d_GetAllVertices(char* layerName, __int32 count,
                                               double* arrayPtr);
//
dll_in_out void* __stdcall At3d_GetFloatVertex(__int32 position, char* layerName,
                                               float* arrayFloatPtr);
dll_in_out void* __stdcall At3d_GetAllFloatVertices(char* layerName, __int32 count,
                                                    float* arrayFloatPtr);
//
dll_in_out void* __stdcall At3d_AllocVertexs(char* layerName, __int32 count);
dll_in_out void* __stdcall At3d_SetVertex(__int32 position, char* layerName,
                                          double* arrayPtr);
dll_in_out void* __stdcall At3d_SetAllVertices(char* layerName, __int32 count,
                                               double* arrayPtr);
//
dll_in_out void* __stdcall At3d_SetFloatVertex(__int32 position, char* layerName,
                                               float* arrayFloatPtr);
dll_in_out void* __stdcall At3d_SetAllFloatVertices(char* layerName, __int32 count,
                                                    float* arrayFloatPtr);
//
dll_in_out __int32 __stdcall At3d_FaceCount(char* layerName);
dll_in_out void* __stdcall At3d_GetFace(__int32 position, char* layerName,
                                        __int32* arrayPtr);
dll_in_out void* __stdcall At3d_GetAllFaces(char* layerName, __int32 count,
                                            __int32* arrayPtr);
dll_in_out void* __stdcall At3d_AllocFaces(char* layerName, __int32 count);
dll_in_out void* __stdcall At3d_SetFace(__int32 position, char* layerName,
                                        __int32* arrayPtr);
dll_in_out void* __stdcall At3d_SetAllFaces(char* layerName, __int32 count,
                                            __int32* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_UVPresent(char* layerName);
dll_in_out void* __stdcall At3d_GetUV_Face(__int32 position, char* layerName,
                                           float* arrayPtr);
dll_in_out void* __stdcall At3d_GetUV_AllFaces(char* layerName, __int32 count,
                                               float* arrayPtr);
dll_in_out void* __stdcall At3d_SetUV_Face(__int32 position, char* layerName,
                                           float* arrayPtr);
dll_in_out void* __stdcall At3d_SetUV_AllFaces(char* layerName, __int32 count,
                                               float* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_VertNormPresent(char* layerName);
dll_in_out void __stdcall At3d_VertNormCalculate(char* layerName);
dll_in_out void __stdcall At3d_VertNormAllCalculate(void);
dll_in_out void __stdcall At3d_VertNormErase(char* layerName);
dll_in_out void __stdcall At3d_VertNormAllErase(void);
dll_in_out void* __stdcall At3d_GetVertNorm_Face(__int32 position, char* layerName,
                                                 float* arrayPtr, __int32 flipFlag);
dll_in_out void* __stdcall At3d_GetVertNorm_AllFaces(char* layerName, __int32 count,
                                                     float* arrayPtr, __int32 flipFlag);
dll_in_out void* __stdcall At3d_SetVertNorm_Face(__int32 position, char* layerName,
                                                 float* arrayPtr, __int32 flipFlag);
dll_in_out void* __stdcall At3d_SetVertNorm_AllFaces(char* layerName, __int32 count,
                                                     float* arrayPtr, __int32 flipFlag);
//
dll_in_out void* __stdcall At3d_GetSurfNorm_Face(__int32 position, char* layerName,
                                                 float* arrayPtr, __int32 flipFlag);
dll_in_out void* __stdcall At3d_GetSurfNorm_AllFaces(char* layerName, __int32 count,
                                                     float* arrayPtr, __int32 flipFlag);
//
dll_in_out __int32 __stdcall At3d_2DVertexCount(char* layerName);
dll_in_out void* __stdcall At3d_2DGetVertex(__int32 position, char* layerName,
                                            double* arrayPtr);
dll_in_out void* __stdcall At3d_2DGetAllVertices(char* layerName, __int32 count,
                                                 double* arrayPtr);
//
dll_in_out void* __stdcall At3d_2DGetFloatVertex(__int32 position, char* layerName,
                                                 float* arrayFloatPtr);
dll_in_out void* __stdcall At3d_2DGetAllFloatVertices(char* layerName, __int32 count,
                                                      float* arrayFloatPtr);
//
dll_in_out void* __stdcall At3d_2DAllocVertexs(char* layerName, __int32 count);
dll_in_out void* __stdcall At3d_2DSetVertex(__int32 position, char* layerName,
                                            double* arrayPtr);
dll_in_out void* __stdcall At3d_2DSetAllVertices(char* layerName, __int32 count,
                                                 double* arrayPtr);
//
dll_in_out void* __stdcall At3d_2DSetFloatVertex(__int32 position, char* layerName,
                                                 float* arrayFloatPtr);
dll_in_out void* __stdcall At3d_2DSetAllFloatVertices(char* layerName, __int32 count,
                                                      float* arrayFloatPtr);
//
dll_in_out __int32 __stdcall At3d_2DEdgeCount(char* layerName);
dll_in_out void* __stdcall At3d_2DGetEdge(__int32 position, char* layerName,
                                        __int32* arrayPtr);
dll_in_out void* __stdcall At3d_2DGetAllEdges(char* layerName, __int32 count,
                                            __int32* arrayPtr);
dll_in_out void* __stdcall At3d_2DAllocEdges(char* layerName, __int32 count);
dll_in_out void* __stdcall At3d_2DSetEdge(__int32 position, char* layerName,
                                        __int32* arrayPtr);
dll_in_out void* __stdcall At3d_2DSetAllEdges(char* layerName, __int32 count,
                                            __int32* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_CloudVertexCount(char* layerName);
dll_in_out void* __stdcall At3d_CloudGetVertex(__int32 position, char* layerName,
                                               double* arrayPtr);
dll_in_out void* __stdcall At3d_CloudGetAllVertices(char* layerName, __int32 count,
                                                    double* arrayPtr);
//
dll_in_out void* __stdcall At3d_CloudGetFloatVertex(__int32 position, char* layerName,
                                                    float* arrayFloatPtr);
dll_in_out void* __stdcall At3d_CloudGetAllFloatVertices(char* layerName, __int32 count,
                                                         float* arrayFloatPtr);
//
dll_in_out void* __stdcall At3d_CloudAllocVertexs(char* layerName, __int32 count);
dll_in_out void* __stdcall At3d_CloudSetVertex(__int32 position, char* layerName,
                                               double* arrayPtr);
dll_in_out void* __stdcall At3d_CloudSetAllVertices(char* layerName, __int32 count,
                                                    double* arrayPtr);
//
dll_in_out void* __stdcall At3d_CloudSetFloatVertex(__int32 position, char* layerName,
                                                    float* arrayFloatPtr);
dll_in_out void* __stdcall At3d_CloudSetAllFloatVertices(char* layerName, __int32 count,
                                                         float* arrayFloatPtr);
//
dll_in_out void __stdcall At3d_MarkObjectFaceColor(void);
dll_in_out void __stdcall At3d_MarkFaceColor(char* layerName);
dll_in_out void* __stdcall At3d_GetFaceColor(__int32 position, char* layerName,
                                             float* arrayPtr);
dll_in_out void* __stdcall At3d_GetAllFaceColors(char* layerName, __int32 count,
                                                 float* arrayPtr);
dll_in_out void* __stdcall At3d_SetFaceColor(__int32 position, char* layerName,
                                             float* arrayPtr);
dll_in_out void* __stdcall At3d_SetAllFaceColors(char* layerName, __int32 count,
                                                 float* arrayPtr);
dll_in_out void __stdcall At3d_DivideFaceColors(char* layerName);
//
dll_in_out void* __stdcall At3d_SetFaceLayerPointer(__int32 position, char* layerName,
                                                    __int32 layerPtr);
dll_in_out void* __stdcall At3d_SetAllFaceLayerPointers(char* layerName, __int32 count,
                                                        __int32* arrayPtr);
dll_in_out void __stdcall At3d_DivideFaceLayerPointers(char* layerName);
//
dll_in_out void __stdcall At3d_TransferDone(void);
//
dll_in_out void __stdcall At3d_MakeQuads(void);
dll_in_out void __stdcall At3d_DeleteQuads(void);
//
dll_in_out void __stdcall At3d_AlignActivate(void);
dll_in_out void __stdcall At3d_AlignPresetNormals(void);
dll_in_out void __stdcall At3d_AlignShowAll(void);
dll_in_out void __stdcall At3d_AlignFlipOne(void);
dll_in_out void __stdcall At3d_AlignSelectLayer(char* layerName);
dll_in_out void* __stdcall At3d_AlignDoLayerFlip(char* layerName);
dll_in_out void __stdcall At3d_EditDefaultRotations(void);
//
dll_in_out void __stdcall At3d_TTF_SetFaceName(char* faceName);
dll_in_out void __stdcall At3d_TTF_SetFontPath(char* path);
dll_in_out void __stdcall At3d_TTF_SetHeight(double height);
dll_in_out void __stdcall At3d_TTF_SetDepth(double depth);
dll_in_out void __stdcall At3d_TTF_SetBorder(double border);
dll_in_out __int32 __stdcall At3d_TTF_To3D(char* text);
dll_in_out __int32 __stdcall At3d_TTF_Unicode_To_3D(wchar_t* text);
//
dll_in_out void __stdcall At3d_SetDxfFontName(char* fontName);
//
dll_in_out void __stdcall At3d_MergeVertices(__int32 flag, double distance[3]);
dll_in_out void __stdcall At3d_MergeObjects(__int32 flag);
//
dll_in_out __int32 __stdcall At3d_GetDefaultMaterial_I1(__int32 flagType, __int32* valuePtr);
dll_in_out __int32 __stdcall At3d_GetDefaultMaterial_F1(__int32 flagType, float* valuePtr);
dll_in_out __int32 __stdcall At3d_GetDefaultMaterial_F3(__int32 flagType, float* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_SetDefaultMaterial_I1(__int32 flagType, __int32 flagValue);
dll_in_out __int32 __stdcall At3d_SetDefaultMaterial_F1(__int32 flagType, float flagValue);
dll_in_out __int32 __stdcall At3d_SetDefaultMaterial_F3(__int32 flagType, float* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_GetMaterial_I1(char* layerName, __int32 flagType,
                                                 __int32* valuePtr);
dll_in_out __int32 __stdcall At3d_SetMaterial_I1(char* layerName, __int32 flagType,
                                                 __int32 flagValue);
dll_in_out __int32 __stdcall At3d_GetMaterial_F1(char* layerName, __int32 flagType,
                                                 float* valuePtr);
dll_in_out __int32 __stdcall At3d_SetMaterial_F1(char* layerName, __int32 flagType,
                                                 float flagValue);
dll_in_out __int32 __stdcall At3d_GetMaterial_F3(char* layerName, __int32 flagType,
                                                 float* arrayPtr);
dll_in_out __int32 __stdcall At3d_SetMaterial_F3(char* layerName, __int32 flagType,
                                                 float* arrayPtr);
dll_in_out __int32 __stdcall At3d_GetTextureName(char* layerName, char* textureName);
dll_in_out __int32 __stdcall At3d_SetTextureName(char* layerName, char* textureName);
dll_in_out __int32 __stdcall At3d_GetMaskName(char* layerName, char* maskName);
dll_in_out __int32 __stdcall At3d_SetMaskName(char* layerName, char* maskName);
dll_in_out __int32 __stdcall At3d_Relocate_Textures(char* path, __int32 overwriteFlag, __int32 typeFlag);
//
dll_in_out void __stdcall At3d_OglLightsMaterials(void);
dll_in_out void __stdcall At3d_RenderOpenGLScene(void);
dll_in_out void __stdcall At3d_SetTriQuadAngle(double angle);
dll_in_out void __stdcall At3d_SetTriQuadEdgeAngle(double angle);
//
dll_in_out void __stdcall At3d_GetObjectMinMax(double* arrayPtr);
dll_in_out void __stdcall At3d_GetObjectCenter(double* arrayPtr);
dll_in_out void __stdcall At3d_SetObjectCenter(double* arrayPtr);
dll_in_out void __stdcall At3d_ScaleObject(double* arrayPtr);
dll_in_out void __stdcall At3d_SetObject_Min000(void);
dll_in_out void __stdcall At3d_SetObject_MinXYZ(double* arrayPtr);
dll_in_out void __stdcall At3d_SetObject_XYCenter_Z0(void);
dll_in_out void __stdcall At3d_MirrorObjectX(void);
dll_in_out void __stdcall At3d_MirrorObjectY(void);
dll_in_out void __stdcall At3d_MirrorObjectZ(void);
dll_in_out void __stdcall At3d_RotateObjectX_90Minus(void);
dll_in_out void __stdcall At3d_RotateObjectX_90Plus(void);
dll_in_out void __stdcall At3d_RotateObjectX_180(void);
dll_in_out void __stdcall At3d_RotateObjectY_90Minus(void);
dll_in_out void __stdcall At3d_RotateObjectY_90Plus(void);
dll_in_out void __stdcall At3d_RotateObjectY_180(void);
dll_in_out void __stdcall At3d_RotateObjectZ_90Minus(void);
dll_in_out void __stdcall At3d_RotateObjectZ_90Plus(void);
dll_in_out void __stdcall At3d_RotateObjectZ_180(void);
dll_in_out void __stdcall At3d_RotateObjectXYZ(void);
dll_in_out void __stdcall At3d_ZeroAll_Z(void);
//
dll_in_out __int32 __stdcall At3d_GetColorMap(__int32 index, float* arrayPtr);
dll_in_out __int32 __stdcall At3d_SetColorMap(__int32 index, float* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_GetDemColorMap(__int32 index, float* arrayPtr);
dll_in_out __int32 __stdcall At3d_SetDemColorMap(__int32 index, float* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_GetDrawPen(__int32 index);
dll_in_out __int32 __stdcall At3d_SetDrawPen(__int32 index, __int32 dxfPen);
//
dll_in_out void __stdcall At3d_SetProducedByName(char* name);
//
dll_in_out __int32 __stdcall At3d_FindDxfPen(float red, float green, float blue);
//
dll_in_out __int32 __stdcall At3d_TransferFrom_Start(__int32 typeFlag);
//
dll_in_out __int32 __stdcall At3d_UV_Array_Count(char* layerName);
dll_in_out void* __stdcall At3d_GetUV_Array(char* layerName, __int32 count,
                                            float* arrayPtr);
dll_in_out void* __stdcall At3d_GetUV_Array_Face(__int32 position, char* layerName,
                                                 __int32* arrayPtr);
dll_in_out void* __stdcall At3d_GetUV_Array_AllFaces(char* layerName, __int32 count,
                                                     __int32* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_VertNorm_Array_Count(char* layerName);
dll_in_out void* __stdcall At3d_GetVertNorm_Array(char* layerName, __int32 count,
                                                  float* arrayPtr, __int32 flipFlag);
dll_in_out void* __stdcall At3d_GetVertNorm_Array_Face(__int32 position, char* layerName,
                                                       __int32* arrayPtr);
dll_in_out void* __stdcall At3d_GetVertNorm_Array_AllFaces(char* layerName, __int32 count,
                                                           __int32* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_XYZ_UV_Array_Count(char* layerName);
dll_in_out void* __stdcall At3d_GetXYZ_UV_Array(__int32 position, char* layerName,
                                                double* xyzPtr, float* uvPtr);
//
dll_in_out void* __stdcall At3d_GetFloatXYZ_UV_Array(__int32 position, char* layerName,
                                                     float* xyzFloatPtr, float* uvPtr);
//
dll_in_out void* __stdcall At3d_GetXYZ_UV_Array_Face(__int32 position, char* layerName,
                                                     __int32* arrayPtr);
dll_in_out void* __stdcall At3d_GetXYZ_UV_Array_AllFaces(char* layerName, __int32 count,
                                                         __int32* arrayPtr);
//
dll_in_out void __stdcall At3d_TransferFrom_Stop(void);
//
dll_in_out void __stdcall At3d_SetDefaultLayerName(char* name);
//
dll_in_out void __stdcall At3d_SetPrimitiveCreaseAngle(__int32 type, float creaseAngle);
//
dll_in_out __int32 __stdcall At3d_Set_UV_Transform(char* layerName, float* centerPtr,
                              float rotation, float* scalePtr, float* translationPtr);
dll_in_out __int32 __stdcall At3d_Create_UV_Coordinates(char* layerName, __int32 type);
dll_in_out __int32 __stdcall At3d_Remove_UV_Coordinates(char* layerName);
dll_in_out void __stdcall At3d_Create_UV_Dialog(void);
//
dll_in_out void __stdcall At3d_DivideTriangles(char* layerName, __int32 typeFlag);
//
dll_in_out __int32 __stdcall At3d_GetDemSize(__int32* columns, __int32* rows);
dll_in_out __int32 __stdcall At3d_GetDemSpacing(double* xSpacing, double* ySpacing);
dll_in_out __int32 __stdcall At3d_GetDemMinMax(double* minHeight, double* maxHeight);
dll_in_out __int32 __stdcall At3d_CreateDemBitmap(__int32 bitsPerPixel, __int32 width, __int32 height);
dll_in_out void __stdcall At3d_DeleteDemBitmap(void);
dll_in_out __int32 __stdcall At3d_GetDemClip(HWND wdwHandle,
                                             __int32 xOffset, __int32 yOffset);
dll_in_out __int32 __stdcall At3d_GetDemHeight(__int32 x, __int32 y, float* height);
dll_in_out void __stdcall At3d_WriteDemContourMap(char* name, __int32 seaLevelFlag,
                                                  float belowFactor, float aboveFactor);
//
dll_in_out __int32 __stdcall At3d_VertColorPresent(char* layerName);
dll_in_out void* __stdcall At3d_GetVertColor_Face(__int32 position, char* layerName,
                                                  float* arrayPtr);
dll_in_out void* __stdcall At3d_GetVertColor_AllFaces(char* layerName, __int32 count,
                                                      float* arrayPtr);
dll_in_out void* __stdcall At3d_SetVertColor_Face(__int32 position, char* layerName,
                                                  float* arrayPtr);
dll_in_out void* __stdcall At3d_SetVertColor_AllFaces(char* layerName, __int32 count,
                                                      float* arrayPtr);
//
dll_in_out __int32 __stdcall At3d_VertColor_Array_Count(char* layerName);
dll_in_out void* __stdcall At3d_GetVertColor_Array(char* layerName, __int32 count,
                                                   float* arrayPtr);
dll_in_out void* __stdcall At3d_GetVertColor_Array_Face(__int32 position, char* layerName,
                                                        __int32* arrayPtr);
dll_in_out void* __stdcall At3d_GetVertColor_Array_AllFaces(char* layerName, __int32 count,
                                                            __int32* arrayPtr);
//
dll_in_out void* __stdcall At3d_GetLayerParent(char* layerName, char* parentName);
dll_in_out void* __stdcall At3d_SetLayerParent(char* layerName, char* parentName);
//
dll_in_out void* __stdcall At3d_GetLayerPivotPoint(char* layerName, double* arrayPtr);
dll_in_out void* __stdcall At3d_SetLayerPivotPoint(char* layerName, double* arrayPtr);

//
dll_in_out void __stdcall At3d_Erase_Lines(char* layerName);
dll_in_out void __stdcall At3d_Erase_All_Lines(void);
dll_in_out void __stdcall At3d_Erase_Clouds(char* layerName);
dll_in_out void __stdcall At3d_Erase_All_Clouds(void);
dll_in_out void __stdcall At3d_Erase_Empty_Layers(void);

//
dll_in_out __int32 __stdcall At3d_Check_For_Water_Tight_Meshes(void);  // obsolete
dll_in_out __int32 __stdcall At3d_Check_For_Watertight_Meshes(void);
dll_in_out void __stdcall At3d_Make_Edges_For_Holes_Layer(void);
dll_in_out void __stdcall At3d_Make_Edges_For_Shared_Edges_Layer(void);
dll_in_out void __stdcall At3d_Remove_Layers_Water_Tight_Check(void);  // obsolete
dll_in_out void __stdcall At3d_Remove_Layers_Watertight_Check(void);

//
dll_in_out __int32 __stdcall At3d_Start_Edit_Vertices(void);
dll_in_out __int32 __stdcall At3d_Stop_Edit_Vertices(void);
dll_in_out __int32 __stdcall At3d_Extrude_Mouse(void);
dll_in_out __int32 __stdcall At3d_Edit_Extrude_Now(void);
//
dll_in_out void* __stdcall At3d_Edit_Select_Layer(char* layerName);
//
dll_in_out __int32 __stdcall At3d_Edit_Drag_Box(void);
dll_in_out __int32 __stdcall At3d_Edit_Pick_Vertex(void);
dll_in_out __int32 __stdcall At3d_Edit_Get_Pick_Mode(void);
dll_in_out void __stdcall At3d_Edit_Set_Pick_Mode(__int32 flag);
dll_in_out void __stdcall At3d_Edit_Pick_All_Vertices(void);
dll_in_out void __stdcall At3d_Edit_Pick_Solid_Wire(__int32 flag);
dll_in_out void __stdcall At3d_Edit_Other_Solid_Wire(__int32 flag);
dll_in_out __int32 __stdcall At3d_Edit_Pick_Edge(void);
dll_in_out __int32 __stdcall At3d_Edit_New_Edge(void);
dll_in_out void __stdcall At3d_Edit_Delete_Vertex(void);
dll_in_out void __stdcall At3d_Edit_Divide_Edge(void);
dll_in_out __int32 __stdcall At3d_Edit_Drag_Vertex(void);
dll_in_out __int32 __stdcall At3d_Edit_Move_Vertex(double xFactor, double yFactor, double zFactor);
dll_in_out __int32 __stdcall At3d_Edit_Get_Vertex(double* xPtr, double* yPtr, double* zPtr);
dll_in_out __int32 __stdcall At3d_Edit_Set_Vertex(double x, double y, double z);
//
dll_in_out __int32 __stdcall At3d_Edit_Rotate_Group(void);
dll_in_out void __stdcall At3d_Edit_GetRotateAngles(double* xAnglePtr, double* yAnglePtr,
                                                    double* zAnglePtr);
dll_in_out void __stdcall At3d_Edit_SetRotateAngles(__int32 relativeFlag, double xAngle,
                                                    double yAngle, double zAngle);
dll_in_out __int32 __stdcall At3d_Edit_Rotate_Okay(void);
dll_in_out __int32 __stdcall At3d_Edit_Rotate_Cancel(void);
//
dll_in_out __int32 __stdcall At3d_Edit_Scale_Group(void);
dll_in_out void __stdcall At3d_Edit_GetScaleFactors(double* xFactorPtr, double* yFactorPtr,
                                                    double* zFactorPtr);
dll_in_out void __stdcall At3d_Edit_SetScaleFactors(__int32 relativeFlag, double xFactor,
                                                    double yFactor, double zFactor);
dll_in_out __int32 __stdcall At3d_Edit_Scale_Okay(void);
dll_in_out __int32 __stdcall At3d_Edit_Scale_Cancel(void);
//
dll_in_out __int32 __stdcall At3d_Edit_Vertex_Snap(void);
dll_in_out void __stdcall At3d_Edit_Snap_Show_Other(void);
dll_in_out __int32 __stdcall At3d_Edit_Snap_Okay(void);
dll_in_out __int32 __stdcall At3d_Edit_Snap_Cancel(void);
//
dll_in_out void __stdcall At3d_Edit_Reduce_Vertices(void);
dll_in_out void __stdcall At3d_Edit_Mirror_Image_Flip_X(void);
dll_in_out void __stdcall At3d_Edit_Mirror_Image_Flip_Y(void);
dll_in_out void __stdcall At3d_Edit_Mirror_Image_Flip_Z(void);
//
dll_in_out __int32 __stdcall At3d_Edit_Get_Extrude_Flag(__int32 flagType);
dll_in_out void __stdcall At3d_Edit_Set_Extrude_Flag(__int32 flagType, __int32 flagValue);
dll_in_out __int32 __stdcall At3d_Edit_Get_Divide_Flag(void);
dll_in_out void __stdcall At3d_Edit_Set_Divide_Flag(__int32 flagValue);
//
dll_in_out __int32 __stdcall At3d_Edit_Make_Bevel_Sets(void);
dll_in_out __int32 __stdcall At3d_Edit_Select_Bevel_Set(char* layerName);
//
dll_in_out __int32 __stdcall At3d_Edit_Clear_Bevels(__int32 typeFlag);
dll_in_out __int32 __stdcall At3d_Edit_Get_Bevel_Count(__int32 typeFlag);
dll_in_out __int32 __stdcall At3d_Edit_Get_Bevel(__int32 typeFlag, __int32 index,
                                                 double* widthPtr, double* heightPtr);
dll_in_out __int32 __stdcall At3d_Edit_Set_Bevel(__int32 typeFlag, __int32 index,
                                                 double width, double height);
//
dll_in_out void __stdcall At3d_Edit_Upper_Lower_Switch(__int32 flag);
dll_in_out void __stdcall At3d_Edit_Display_Grid(__int32 gridFlag, double gridSize);
dll_in_out void __stdcall At3d_Edit_Snap_To_Grid(__int32 flag);
dll_in_out void __stdcall At3d_Edit_Move_Bevel_Zero(void);
dll_in_out void __stdcall At3d_Edit_Switch_Bevels_Outlines(void);
dll_in_out void __stdcall At3d_Edit_Open_Outline(void);
dll_in_out void __stdcall At3d_Edit_Close_Outline(void);
dll_in_out __int32 __stdcall At3d_Edit_Pick_Ghost_Outline(void);
dll_in_out __int32 __stdcall At3d_Edit_Pick_Ghost_Okay(void);
dll_in_out __int32 __stdcall At3d_Edit_Pick_Ghost_Cancel(void);
dll_in_out void __stdcall At3d_Edit_Use_Ghost_Outline(__int32 flag);
//
dll_in_out void __stdcall At3d_Edit_Undo_Vertices_Selected(void);
dll_in_out void __stdcall At3d_Edit_Undo_Vertices_Layer(void);
dll_in_out void __stdcall At3d_Edit_Undo_Vertices_All_Layers(void);
dll_in_out void __stdcall At3d_Edit_Local_World_Axis_Switch(__int32 flag);

//
dll_in_out __int32 __stdcall At3d_Get_Mesh_To_Landscape_Size(double* arrayPtr);
dll_in_out __int32 __stdcall At3d_Calculate_Mesh_To_Landscape(
                                            double xSpacing, double ySpacing,
                                            __int32* countPtr, double* sizePtr);
dll_in_out void __stdcall At3d_Convert_Mesh_To_Landscape(char* xyzName,
                                    double dropElevation, double baseThickness);
//
dll_in_out __int32 __stdcall At3d_ExtrudePseudo2D_Start(void);
dll_in_out __int32 __stdcall At3d_ExtrudePseudo2D_Stop(void);
dll_in_out void* __stdcall At3d_ExtrudePseudo2D_SetLayer(char* layerName);
dll_in_out void __stdcall At3d_ExtrudePseudo2D_Get_Mesh_Size(double* arrayPtr);
dll_in_out void __stdcall At3d_ExtrudePseudo2D_GetRotateAngles(double* xAnglePtr,
                                          double* yAnglePtr, double* zAnglePtr);
dll_in_out void __stdcall At3d_ExtrudePseudo2D_SetRotateAngles(__int32 relativeFlag,
                                   double xAngle, double yAngle, double zAngle);
dll_in_out __int32 __stdcall At3d_ExtrudePseudo2D_GetTypeFlag(void);
dll_in_out double __stdcall At3d_ExtrudePseudo2D_GetThickness(void);
dll_in_out double __stdcall At3d_ExtrudePseudo2D_GetAdjustLocation(void);
dll_in_out void __stdcall At3d_ExtrudePseudo2D_Mark(void);
dll_in_out void __stdcall At3d_ExtrudePseudo2D_Clear(void);
dll_in_out void __stdcall At3d_ExtrudePseudo2D_Extrude(__int32 typeFlag,
                                               double thickness, double adjustLocation);
dll_in_out void __stdcall At3d_ExtrudePseudo2D_Redo(__int32 typeFlag,
                                               double thickness, double adjustLocation);
dll_in_out void __stdcall At3d_ExtrudePseudo2D_Undo(void);
//
dll_in_out void __stdcall At3d_Kerkythea_GetMultiplier(__int32 type, float* multiplierPtr);
dll_in_out void __stdcall At3d_Kerkythea_SetMultiplier(__int32 type, float multiplier);

dll_in_out void __stdcall At3d_Kerkythea_GetSpotFallOff(__int32 type, float* fallOffPtr);
dll_in_out void __stdcall At3d_Kerkythea_SetSpotFallOff(__int32 type, float fallOff);

dll_in_out void __stdcall At3d_Kerkythea_GetSpotHotSpot(__int32 type, float* hotSpotPtr);
dll_in_out void __stdcall At3d_Kerkythea_SetSpotHotSpot(__int32 type, float hotSpot);

dll_in_out void __stdcall At3d_Kerkythea_GetSpotHotFraction(float* fractionPtr);
dll_in_out void __stdcall At3d_Kerkythea_SetSpotHotFraction(float fraction);

dll_in_out void __stdcall At3d_Kerkythea_GetRadius(__int32 type, float* radiusPtr);
dll_in_out void __stdcall At3d_Kerkythea_SetRadius(__int32 type, float radius);
//
dll_in_out void __stdcall At3d_GetVrmlLightMergeDistance(double* distancePtr);
dll_in_out void __stdcall At3d_SetVrmlLightMergeDistance(double distance);
//
dll_in_out void __stdcall At3d_CalculateVertNorm(char* layerName, double smoothingAngle);
dll_in_out void __stdcall At3d_CalculateVertNormAll(double smoothingAngle);
//
dll_in_out void __stdcall At3d_XYZ_SetDelimiters(char* delimitersPtr);
dll_in_out void __stdcall At3d_XYZ_SetRowsColumns(__int32 rows, __int32 columns);
dll_in_out void __stdcall At3d_XYZ_SetClipRectangle(__int32 fromRow, __int32 toRow,
                                                    __int32 fromColumn, __int32 toColumn);
dll_in_out void __stdcall At3d_XYZ_SetNoDataValue(double noDataValue);
dll_in_out void __stdcall At3d_XYZ_SetNoDataReplaceValue(double noDataReplaceValue);
dll_in_out void __stdcall At3d_XYZ_SetScaleFactorZ(double scaleFactorZ);
dll_in_out void __stdcall At3d_XYZ_SetDxfOutFile(char* name, double scaleFactor);
//
dll_in_out void __stdcall At3d_SetVrmlSerifFontName(char* fontName);
dll_in_out void __stdcall At3d_SetVrmlSansFontName(char* fontName);
dll_in_out void __stdcall At3d_SetVrmlTypewriterFontName(char* fontName);
//
dll_in_out void __stdcall At3d_SetStageGrid(double spacing, double width, double depth, double originX, double originY);
dll_in_out void __stdcall At3d_SetStageImage(char* imageName);
//
dll_in_out void __stdcall At3d_StartReducePolygons(__int32 progressFlag);
dll_in_out void __stdcall At3d_GetReducePolygonsData(char* layerName,
                                                     __int32* vertexCount0Ptr, __int32* triangleCount0Ptr,
                                                     __int32* vertexCount1Ptr, __int32* triangleCount1Ptr);
dll_in_out void __stdcall At3d_SetReducePolygonsNumber(char* layerName, __int32 vertexCount);
dll_in_out void __stdcall At3d_StopReducePolygons(__int32 okFlag);
//
dll_in_out void __stdcall At3d_SetBackgroundImage(char* imageName);
//
dll_in_out void __stdcall At3d_SetBitmapTo3D_ExtrudeHeight(double extrudeHeight);
//
dll_in_out void __stdcall At3d_SetBitmapToLandscapeValues(double belowMultiplier, double aboveMultiplier,
                                                          double minHeight, double xySpacing);
//
dll_in_out __int32 __stdcall At3d_Get_OGL_Snapshot(unsigned __int8* rgbaArray, __int32 width, __int32 height);

//
dll_in_out void __stdcall At3d_Revolve_Camera_Start(double xAngle, double yAngle,
                                                    double zAngle, double seconds);
dll_in_out void __stdcall At3d_Revolve_Camera_Stop(void);

//
dll_in_out void __stdcall At3d_Show_Statusbar(void);
dll_in_out void __stdcall At3d_Hide_Statusbar(void);

//
dll_in_out __int32 __stdcall At3d_Get_Layer_MinMax(char* layerName, __int32* countsArrayPtr, double* minMaxArrayPtr);

//
dll_in_out __int32 __stdcall At3d_Get_OGL_Global_Ambient_Light(float* ambientPtr);
dll_in_out __int32 __stdcall At3d_Set_OGL_Global_Ambient_Light(float* ambientPtr);
dll_in_out __int32 __stdcall At3d_Get_OGL_Directional_Light(
                                           __int32 index, __int32* enabledFlagPtr,
                                           float* ambientPtr, float* diffusePtr,
                                           float* specularPtr, float* positionPtr);
dll_in_out __int32 __stdcall At3d_Set_OGL_Directional_Light(
                                           __int32 index, __int32 enabledFlag,
                                           float* ambientPtr, float* diffusePtr,
                                           float* specularPtr, float* positionPtr);

//
dll_in_out __int32 __stdcall At3d_Convert_3D_To_2D(void);

//
dll_in_out __int32 __stdcall At3d_Get_KML_Length_Folder(__int32* nameLengthPtr,
                                                        __int32* descriptionLengthPtr);
dll_in_out __int32 __stdcall At3d_Get_KML_Folder(char* namePtr, __int32 nameLength,
                                                 char* descriptionPtr, __int32 descriptionLength);
dll_in_out __int32 __stdcall At3d_Get_KML_Length_Placemark(__int32* nameLengthPtr,
                                                           __int32* descriptionLengthPtr);
dll_in_out __int32 __stdcall At3d_Get_KML_Placemark(char* namePtr, __int32 nameLength,
                                                    char* descriptionPtr, __int32 descriptionLength);
dll_in_out __int32 __stdcall At3d_Get_KML_LookAt(double* latitudePtr, double* longitudePtr,
                                             double* altitudePtr, __int32* altitudeModePtr,
                                             double* headingPtr, double* tiltPtr, double* rangePtr);
dll_in_out __int32 __stdcall At3d_Get_KML_Model(double* latitudePtr, double* longitudePtr,
                                             double* altitudePtr, __int32* altitudeModePtr,
                                             double* headingPtr, double* tiltPtr, double* rollPtr,
                                             double* scaleXPtr, double* scaleYPtr, double* scaleZPtr);
dll_in_out __int32 __stdcall At3d_Get_KML_ModelImage_Folders(
                                __int32* useModelsFlagPtr, char* modelsFolderNamePtr,
                                __int32* useImagesFlagPtr, char* imagesFolderNamePtr);
//
dll_in_out void __stdcall At3d_Set_KML_Folder(char* namePtr, char* descriptionPtr);
dll_in_out void __stdcall At3d_Set_KML_Placemark(char* namePtr, char* descriptionPtr);
dll_in_out void __stdcall At3d_Set_KML_LookAt(double latitude, double longitude,
                                              double altitude, __int32 altitudeMode,
                                              double heading, double tilt, double range);
dll_in_out void __stdcall At3d_Set_KML_Model(double latitude, double longitude,
                                             double altitude, __int32 altitudeMode,
                                             double heading, double tilt, double roll);
dll_in_out void __stdcall At3d_Set_KML_ModelEx(double latitude, double longitude,
                                               double altitude, __int32 altitudeMode,
                                               double heading, double tilt, double roll,
                                               double scaleX, double scaleY, double scaleZ);
dll_in_out void __stdcall At3d_Set_KML_ModelImage_Folders(
                                __int32 useModelsFlag, char* modelsFolderNamePtr,
                                __int32 useImagesFlag, char* imagesFolderNamePtr);

//
dll_in_out void __stdcall At3d_SetAppHandle(HWND hwndApp);

//
dll_in_out void __stdcall At3d_Rotate_Camera_Simulation_Start(__int32 mouseX,
                                                              __int32 mouseY,
                                                              double seconds);
dll_in_out void __stdcall At3d_Rotate_Camera_Simulation_Stop(void);

//
dll_in_out __int32 __stdcall At3d_Set_2D_Outline(char* layerName, __int32 count,
                                                 double* arrayPtr, __int32 closedFlag);

dll_in_out __int32 __stdcall At3d_Set_2D_FloatOutline(char* layerName, __int32 count,
                                                      float* arrayFloatPtr, __int32 closedFlag);
dll_in_out __int32 __stdcall At3d_Transfer_2D_Outline_Done(double extrusionHeight);

//
dll_in_out void __stdcall At3d_Set_White_For_UV_Layers(void);

//
dll_in_out void __stdcall At3d_Invert_All_Layer_Transparencies(void);
dll_in_out void __stdcall At3d_Make_All_Layers_Opaque(void);

//
dll_in_out __int32 __stdcall At3d_Set_Maya_Version(char* mayaVersion);

//
dll_in_out __int32 __stdcall At3d_Set_DirectX_Frame_Prefix(__int32 outFlag, char* prefixPtr);
dll_in_out __int32 __stdcall At3d_Set_DirectX_Material_Prefix(__int32 outFlag, char* prefixPtr);

//
dll_in_out __int32 __stdcall At3d_Rename_Embedded_Textures(char* textureName);

#ifdef __cplusplus
}
#endif

//---------------------------------------------------------------------------

// import file types
//
#define INTYPE_DXF                    0
#define INTYPE_DXF_SPECIAL            1
#define INTYPE_IMAGINE                2
#define INTYPE_LIGHTWAVE              3
#define INTYPE_VIDEOSCAPE             4
#define INTYPE_SCULPT                 5
#define INTYPE_3DSTUDIO               6
#define INTYPE_TRUESPACE              7
#define INTYPE_WAVEFRONT              8
#define INTYPE_STEREOLITHOGRAPHY      9
#define INTYPE_SCENERY_ANIMATOR      10
#define INTYPE_VISTAPRO              11
#define INTYPE_BINARY_DEM            12
#define INTYPE_USGS_DEM              13
#define INTYPE_IFF                   14
#define INTYPE_IFF_DEM               15
#define INTYPE_BMP                   16
#define INTYPE_BMP_DEM               17
#define INTYPE_VRML                  18
#define INTYPE_XYZ                   19
#define INTYPE_REALIMATION           20
#define INTYPE_LIGHTSCAPE            21
#define INTYPE_RENDERWARE            22
#define INTYPE_MAYA_RTG              23
#define INTYPE_DXF_POINTCLOUD        24
#define INTYPE_USGS_SDTS             25
#define INTYPE_XYZ_NO_MESH           26  // read vertices but do not create a mesh
                                         // use OpenGL viewer to display vertices
#define INTYPE_DIRECTX               27
#define INTYPE_SOFTIMAGE_XSI         28
#define INTYPE_3DMF                  29
#define INTYPE_XGL                   30
#define INTYPE_MICRODEM              31
#define INTYPE_USGS_GTOPO30          32
#define INTYPE_USGS_SRTM_1_3         33
#define INTYPE_CDED                  34
#define INTYPE_ASCII_DEM             35
#define INTYPE_X3D                   36
#define INTYPE_MAXNC                 37
#define INTYPE_SHOPBOT               38
#define INTYPE_OPEN_INVENTOR         39
#define INTYPE_ARCINFO_ASCII         40
#define INTYPE_NASTRAN               41
#define INTYPE_COLLADA               42
#define INTYPE_TECPLOT               43
#define INTYPE_SATELLITE_TOOLKIT     44   // obsolete
#define INTYPE_SATELLITE_TOOL_KIT    44
#define INTYPE_CABLEMOD              45
#define INTYPE_KERKYTHEA             46
#define INTYPE_MODO                  47
#define INTYPE_GOOGLE_EARTH          48
#define INTYPE_ORDNANCE_SURVEY_DTM   49

//---------------------------------------------------------------------------

// export file types
//
#define OUTTYPE_DXF                          0
#define OUTTYPE_IMAGINE1                     1
#define OUTTYPE_IMAGINE2                     2
#define OUTTYPE_TURBOSILVER                  3
#define OUTTYPE_LIGHTWAVE1                   4
#define OUTTYPE_LIGHTWAVE2                   5
#define OUTTYPE_VIDEOSCAPE                   6
#define OUTTYPE_SCULPT                       7
#define OUTTYPE_3DSTUDIO_BINARY              8
#define OUTTYPE_3DSTUDIO_ASCII               9
#define OUTTYPE_TRUESPACE_BINARY            10
#define OUTTYPE_TRUESPACE_ASCII             11
#define OUTTYPE_WAVEFRONT                   12
#define OUTTYPE_STL_ASCII                   13
#define OUTTYPE_STL_BINARY                  14
#define OUTTYPE_SCENERY_ANIMATOR            15
#define OUTTYPE_VISTAPRO                    16
#define OUTTYPE_BINARY_DEM                  17
#define OUTTYPE_BMP                         18
#define OUTTYPE_VRML1                       19
#define OUTTYPE_VRML2                       20
#define OUTTYPE_POVRAY                      21
#define OUTTYPE_REALIMATION                 22
#define OUTTYPE_LIGHTSCAPE                  23
#define OUTTYPE_RENDERWARE                  24
#define OUTTYPE_3DMETAFILE_ASCII            25
#define OUTTYPE_3DMETAFILE_BINARY           26
#define OUTTYPE_MAYA_MA                     27
#define OUTTYPE_VIEWPOINT                   28
#define OUTTYPE_DIRECTX_ASCII               29
#define OUTTYPE_DIRECTX_BINARY              30
#define OUTTYPE_SOFTIMAGE_XSI_ASCII         31
#define OUTTYPE_XGL                         32
#define OUTTYPE_X3D                         33
#define OUTTYPE_ZGL                         34
#define OUTTYPE_DEM_CONTOUR_MAP             35
#define OUTTYPE_OPEN_INVENTOR               36
#define OUTTYPE_ARCINFO_ASCII               37
#define OUTTYPE_DEM_CONTOUR_LINES           38
#define OUTTYPE_COLLADA                     39
#define OUTTYPE_SATELLITE_TOOLKIT           40   // obsolete
#define OUTTYPE_SATELLITE_TOOL_KIT          40
#define OUTTYPE_CABLEMOD                    41
#define OUTTYPE_KERKYTHEA                   42
#define OUTTYPE_MODO                        43
#define OUTTYPE_GOOGLE_EARTH                44

//---------------------------------------------------------------------------

// import flags
//
#define LIBFLAG_DXF_POLYLINE_CLOSE          0
#define LIBFLAG_EXTRUDE_MODE                1
#define LIBFLAG_NOCHECK_POLYLINE            2
#define LIBFLAG_CHANGE_PEN_COLOR            3
#define LIBFLAG_CREATE_QUADFACE             4    // obsolete
#define LIBFLAG_DXF_DIVIDE                  5
#define LIBFLAG_AUTO_ALIGN                  6


    // ask before dividing - flag = 0
    // never divide        - flag = 1
    // always divide       - flag = 2
#define LIBFLAG_OBJECT_DIVIDE               7


// export flags
//
#define LIBFLAG_MIN_MAX_USE_2D              8    // obsolete
#define LIBFLAG_USE_CENTER                  9
#define LIBFLAG_HOLD_CENTER                10
#define LIBFLAG_SAVEPARENT                 11
#define LIBFLAG_SAVE_2D                    12
#define LIBFLAG_GLOBAL_DOUBLE_SIDED        13


    // save layers only          - flag = 0
    // save as layers and blocks - flag = 1
    // save blocks only          - flag = 2
    //
#define LIBFLAG_SAVE_TYPE                  14


#define LIBFLAG_BY_LAYER                   15
#define LIBFLAG_OUTPUT_FLIPYZ              16   // obsolete
#define LIBFLAG_USE_QUADFACE               17
#define LIBFLAG_LIGHTSCAPE_OUT             18
#define LIBFLAG_USE_ORIGINAL_PARENT        19


// DXF output flags
//
#define LIBFLAG_DXF_PRECISION              20   // obsolete - use LIBFLAG_VERTEX_OUT_PRECISION

    // use carriage return and linefeed - flag = 0
    // use linefeed only                - flag = 1
    // use carriage return only         - flag = 2
    //
#define LIBFLAG_DXF_OUT1                   21

    // output entities only               - flag = 0
    // output tables, blocks and entities - flag = 1
    // output all sections                - flag = 2
    //
#define LIBFLAG_DXF_OUT2                   22

    // output SHAPE entity     - flag = 1
    // output TEXT entity      - flag = 2
    // output ATTDEF entity    - flag = 4
    // output ATTRIB entity    - flag = 8
    // output DIMENSION entity - flag = 16
    // OR flags to output more than one type of entity
    //
#define LIBFLAG_DXF_OUT3                   23

    // Revision 10 (Flatland = 1) - flag = 0
    // Revision 10 (Flatland = 0) - flag = 1
    // Revision 11 or 12          - flag = 2
    //
#define LIBFLAG_DXF_REV                    24

#define LIBFLAG_DXF_FONT_OUT               25
#define LIBFLAG_DXF_OUTPUT_3DFACE          26


// Lightscape output flags
//
    // save as LP file  - flag = 0
    // save as BLK file - flag = 1
    //
#define LIBFLAG_LIGHTSCAPE_SAVETYPE        27

    // do not center block at origin - flag = 0
    // center block at origin        - flag = 1
    //
#define LIBFLAG_LIGHTSCAPE_CENTERBLOCK     28

#define LIBFLAG_LIGHTSCAPE_LAYERDEFAULT    29

    // Millimeters - flag = 0
    // Centimeters - flag = 1
    // Meters      - flag = 2
    // Kilometers  - flag = 3
    // Inches      - flag = 4
    // Feet        - flag = 5
    // Miles       - flag = 6
    //
#define LIBFLAG_LIGHTSCAPE_LENGTH          30

    // International (SI) - flag = 0
    // American (AS)      - flag = 1
    //
#define LIBFLAG_LIGHTSCAPE_LIGHTING        31

    // Seconds - flag = 0
    // Minutes - flag = 1
    // Hours   - flag = 2
    //
#define LIBFLAG_LIGHTSCAPE_TIME            32


// RenderWare output flags
//
    // each layer becomes a clump        - flag = 0
    // all layers become one clump       - flag = 1
    // each layer becomes one prototype  - flag = 2
    // use layer hierarchy               - flag = 3
    //
#define LIBFLAG_RWX_OUTPUT                 33

#define LIBFLAG_RWX_VERTEX_LABEL           34

#define LIBFLAG_RWX_PRECISION              35  // obsolete - use LIBFLAG_VERTEX_OUT_PRECISION

#define LIBFLAG_RWX_PROTOCENTER            36
#define LIBFLAG_RWX_DEMCENTER              37
#define LIBFLAG_RWX_USEPROTOTYPES          38


// avatar output flag
// used with all file formats that support avatars
//
#define LIBFLAG_AVATAR_OUTPUT              39


// scale factor units flags
//
    // used for both input and output
    // MSFUNITS_MILLIMETERS  - flag = 0
    // MSFUNITS_CENTIMETERS  - flag = 1
    // MSFUNITS_METERS       - flag = 2
    // MSFUNITS_KILOMETERS   - flag = 3
    // MSFUNITS_INCHES       - flag = 4
    // MSFUNITS_FEET         - flag = 5
    // MSFUNITS_MILES        - flag = 6
    //
#define LIBFLAG_MSF_INUNITS                40
#define LIBFLAG_MSF_OUTUNITS               41


// viewer flags
//
#define LIBFLAG_COLOR_EDGE                 42
#define LIBFLAG_GREY_EDGE                  43
#define LIBFLAG_SHOW_QUADFACE              44
#define LIBFLAG_SURFACE_NORMAL             45
#define LIBFLAG_HIDDEN_WIREFRAME           46
#define LIBFLAG_WIREFRAME_REDRAW           47
#define LIBFLAG_DEM_WIREFRAME              48

    // use bounding box - flag = 1
    // use vertices     - flag = 2
    // use wireframe    - flag = 4
    // OR flags for combinations
    //
#define LIBFLAG_FAST_TYPE                  49

#define LIBFLAG_FAST_INDICATOR             50


// Axis system used by app calling dll
//
    // DXF axes       - flag = 0
    // LightWave axes - flag = 1
    // VRML axes      - flag = 2
    //
#define LIBFLAG_APP_AXES                   51


// TrueType Fonts
//
#define LIBFLAG_TT_POINTSPERCURVE          52
#define LIBFLAG_TT_BOLD                    53
#define LIBFLAG_TT_ITALIC                  54
#define LIBFLAG_TT_REDUCE                  55
#define LIBFLAG_TT_JOIN                    56
#define LIBFLAG_TT_FACE                    57
#define LIBFLAG_TT_EXTRUDE                 58
#define LIBFLAG_TT_LAYERS                  59
#define LIBFLAG_TT_STENCIL                 60
#define LIBFLAG_TT_PLUSCORE                61


// Convert VRML Text nodes to 3D
//
    // VRML_TEXT_NO     - flag = 0 - do not convert
    // VRML_TEXT_FLAT   - flag = 1 - flat - front faces only
    // VRML_TEXT_THICK  - flag = 2 - thick - extruded with thickness
//
#define LIBFLAG_VRML_TEXT_TO_3D            62


// Full Window Depth Buffer Flag
//
#define LIBFLAG_FULL_WDW_DEPTH_BUFFER      63


// RenderWare output format flags
//
    // RWX_NOINDENT     - flag = 1    // obsolete - use LIBFLAG_NOINDENT_OUT
    // RWX_DROPZEROS    - flag = 2    // obsolete - use DROPZERO_OUT_FLAG
    // RWX_NOLAYERNAME  - flag = 4
    //
#define LIBFLAG_RWX_NOFORMAT               64


// VRML flags
//
    // number of decimals
    //
#define LIBFLAG_VRML_PRECISION             65   // obsolete - use LIBFLAG_VERTEX_OUT_PRECISION

    // formatted VRML Output
    //
    // VRML_NOINDENT     - flag = 1   // obsolete - use LIBFLAG_NOINDENT_OUT
    // VRML_DROPZEROS    - flag = 2   // obsolete - use DROPZERO_OUT_FLAG
    //
#define LIBFLAG_VRML_NOFORMAT              66

#define LIBFLAG_VRML_SPHERE_DENSITY        67
#define LIBFLAG_VRML_CONE_NSIDES           68
#define LIBFLAG_VRML_CYLINDER_NSIDES       69
#define LIBFLAG_VRML_WARNING               70

    // VRML1_INFO    - flag = 1
    //
#define LIBFLAG_VRML1_WRITENODES           71

    // VRML2_WORLDINFO         - flag =   1
    // VRML2_NAVIGATIONINFO    - flag =   2
    // VRML2_VIEWPOINT_FRONT   - flag =   4
    // VRML2_VIEWPOINT_RIGHT   - flag =   8
    // VRML2_VIEWPOINT_BACK    - flag =  16
    // VRML2_VIEWPOINT_LEFT    - flag =  32
    // VRML2_VIEWPOINT_TOP     - flag =  64
    // VRML2_VIEWPOINT_BOTTOM  - flag = 128
    //
#define LIBFLAG_VRML2_WRITENODES           72

#define LIBFLAG_VRML_ELEVATIONGRID         73


// uv texture flag
// if set, write uv coordinates to file
//
#define LIBFLAG_UV_OUTPUT                  74


// mtl_fileFlag
// if set, save Wavefront Material file
//
#define LIBFLAG_MTL_FILE                   75


// RWX Use Grouping Clump Flag
// use parent grouping clump when
// writing each layer to a clump
//
#define LIBFLAG_RWX_GROUPCLUMP1            76

// remove duplicate faces when
// reading files and merging data
//
#define LIBFLAG_REMOVE_DUPLICATE_FACES     77

// use OpenGL viewer
//
#define LIBFLAG_USE_OPENGL                 78

// OpenGL Render Flags
//
#define OGL_RENDER_POINTCLOUD                   0
#define OGL_RENDER_BOUNDINGBOX                  1
#define OGL_RENDER_WIREFRAME_ONECOLOR           2
#define OGL_RENDER_HIDDEN_WIREFRAME_ONECOLOR    3
#define OGL_RENDER_WIREFRAME_MULTICOLOR         4
#define OGL_RENDER_HIDDEN_WIREFRAME_MULTICOLOR  5
#define OGL_RENDER_FLAT_EDGE                    6
#define OGL_RENDER_FLAT                         7
#define OGL_RENDER_SMOOTH                       8
#define OGL_RENDER_SMOOTH_EDGE                  9
//
#define LIBFLAG_OGL_RENDER                 79


// type of object to save to 3DMF file
//
#define SAVE_3DMF_MESH        0
#define SAVE_3DMF_TRIANGLE    1
#define SAVE_3DMF_QUAD        2
#define SAVE_3DMF_TRIMESH     3
//
#define LIBFLAG_SAVE_3DMF_TYPE             80


// OpenGL Compile and Execute Flag for display lists
// if flag is clear, mode is GL_COMPILE
// if flag is set,   mode is GL_COMPILE_AND_EXECUTE
//
#define LIBFLAG_OGL_COMPILE_EXECUTE        81

// if flag is set, display textures in OpenGL viewer
//
#define LIBFLAG_OGL_USE_TEXTURES           82


// if flag is set, search directories for texture files
// after reading the file
//
#define LIBFLAG_TEXTURE_DIRECTORIES        83


// a texture mode for OpenGL
// if flag is clear, mode is GL_MODULATE
// if flag is set,   mode is GL_REPLACE
//
#define LIBFLAG_OGL_REPLACE                84


// for OpenGL texture mode of GL_MODULATE
// if flag is clear, use diffuse RGB color of material
// if flag is set, use diffuse RGB color of 1,1,1
//
#define LIBFLAG_OGL_WHITE_BASE             85


// if set, write vertex normals to file
//
#define LIBFLAG_VERTNORM_OUTPUT            86

// if set, display texture search prompt message
//
#define LIBFLAG_TEXTURESEARCH_PROMPT       87

// if set, use two sided lighting
//
#define LIBFLAG_OGL_2SIDED_LIGHTING        88

// if set, cull back faces
//
#define LIBFLAG_OGL_CULL_BACKFACES         89

// Convert DXF TEXT entity to 3D 
//
    // DXF_TEXT_NO     - flag = 0 - do not convert
    // DXF_TEXT_FLAT   - flag = 1 - flat - front faces only
    // DXF_TEXT_THICK  - flag = 2 - thick - extruded with thickness
//
#define LIBFLAG_USE_DXF_TEXT               90

// if set, display messages in a window when reading a file
//
#define LIBFLAG_SHOW_READ_MESSAGES         91

// if set, display messages in a window when saving a file
//
#define LIBFLAG_SHOW_SAVE_MESSAGES         92     // discontinued at version 1.3.1

// if set, display prompt message before merging layers
//
#define LIBFLAG_MERGE_LAYERS_PROMPT        93


// MTX Precision - number of decimals for Viewpoint output
//
#define LIBFLAG_MTX_PRECISION              94   // obsolete - use LIBFLAG_VERTEX_OUT_PRECISION

// No formatted MTX Output
    //
    // #define MTX_NOINDENT     1     // obsolete - use LIBFLAG_NOINDENT_OUT
    // #define MTX_DROPZEROS    2     // obsolete - use DROPZERO_OUT_FLAG
    //
#define LIBFLAG_MTX_NOFORMAT               95

// MTX output flag
//
    // #define MTX_OUTPUT_SIMPLE        0
    // #define MTX_OUTPUT_HIERARCHY     1
    //
#define LIBFLAG_MTX_OUTPUT                 96    // obsolete - use LIBFLAG_HIERARCHY_OUTPUT


// Maya Precision - number of decimals for Maya MA output
//
#define LIBFLAG_MAYA_PRECISION             97   // obsolete - use LIBFLAG_VERTEX_OUT_PRECISION

// No formatted Maya MA Output
//
    // #define MAYA_NOINDENT     1     // obsolete - use LIBFLAG_NOINDENT_OUT
    // #define MAYA_DROPZEROS    2     // obsolete - use DROPZERO_OUT_FLAG
    //
#define LIBFLAG_MAYA_NOFORMAT              98

// Maya Linear flag for currentUnit
//
    // #define MAYA_LINEAR_MILLIMETER    0
    // #define MAYA_LINEAR_CENTIMETER    1
    // #define MAYA_LINEAR_METER         2
    // #define MAYA_LINEAR_KILOMETER     3
    // #define MAYA_LINEAR_INCH          4
    // #define MAYA_LINEAR_FOOT          5
    // #define MAYA_LINEAR_YARD          6
    // #define MAYA_LINEAR_MILE          7
    //
#define LIBFLAG_MAYA_LINEAR                99

// Maya Angle flag for currentUnit
//
    // #define MAYA_ANGULAR_DEGREE     0
    // #define MAYA_ANGULAR_RADIAN     1
    //
#define LIBFLAG_MAYA_ANGULAR              100

// Maya Time flag for currentUnit
//
    // #define MAYA_TIME_HOUR         0
    // #define MAYA_TIME_MIN          1
    // #define MAYA_TIME_SEC          2
    // #define MAYA_TIME_MILLISEC     3
    // #define MAYA_TIME_GAME         4
    // #define MAYA_TIME_FILM         5
    // #define MAYA_TIME_PAL          6
    // #define MAYA_TIME_NTSC         7
    // #define MAYA_TIME_SHOW         8
    // #define MAYA_TIME_PALF         9
    // #define MAYA_TIME_NTSCF       10
    //
#define LIBFLAG_MAYA_TIME                 101


// DirectX Precision - number of decimals for output
//
#define LIBFLAG_DIRECTX_PRECISION         102   // obsolete - use LIBFLAG_VERTEX_OUT_PRECISION

// No formatted DirectX Output
//
    // #define DIRECTX_NOINDENT     1    // obsolete - use LIBFLAG_NOINDENT_OUT
    // #define DIRECTX_DROPZEROS    2    // obsolete - use DROPZERO_OUT_FLAG
    //
#define LIBFLAG_DIRECTX_NOFORMAT          103

// DirectX output flag
//
    // #define DIRECTX_OUTPUT_SIMPLE        0
    // #define DIRECTX_OUTPUT_HIERARCHY     1
    //
#define LIBFLAG_DIRECTX_OUTPUT            104   // obsolete - use LIBFLAG_HIERARCHY_OUTPUT


// Softimage XSI Precision - number of decimals for output
//
#define LIBFLAG_XSI_PRECISION             105   // obsolete - use LIBFLAG_VERTEX_OUT_PRECISION

// No formatted Softimage XSI Output
//
    // #define XSI_NOINDENT     1     // obsolete - use LIBFLAG_NOINDENT_OUT
    // #define XSI_DROPZEROS    2     // obsolete - use DROPZERO_OUT_FLAG
    //
#define LIBFLAG_XSI_NOFORMAT              106

// Softimage XSI output flag
//
    // #define XSI_OUTPUT_SIMPLE        0
    // #define XSI_OUTPUT_HIERARCHY     1
    //
#define LIBFLAG_XSI_OUTPUT                107    // obsolete - use LIBFLAG_HIERARCHY_OUTPUT

// if set, save Softimage lights
//
#define LIBFLAG_XSI_SAVE_LIGHTS           108

// if set, save texture path
//
#define LIBFLAG_SAVE_TEXTUREPATH          109

// if set, search drives for a texture file
// that can be displayed which matches the texture name
// read from the file or transferred to the DLL
//
#define LIBFLAG_TEXTURENAME_MATCH         110

// if set, save as white base material for textures
//
#define LIBFLAG_SAVE_WHITE_BASE           111

// if set, give warning if coordinates are <= zero
// when saving a STL file
//
#define LIBFLAG_STL_ZERO_WARNING          112

// if set, give warning if more than one layer is
// written to a STL file
//
#define LIBFLAG_STL_LAYERS_WARNING        113

// if set, read inline files contained in the
// VRML WWWInline and Inline nodes
//
#define LIBFLAG_VRML_INLINE               114

// if set, divide layers that are too large
// to save to some file formats
//
#define LIBFLAG_DIVIDE_LAYER_SAVE         115
         
// if set, when there are too many vertices and faces
// to save to a LW1 file then save each layer to it's own file
//
#define LIBFLAG_LW1_MULTI_SAVE            116

// if set, save point clouds to file
//
#define LIBFLAG_SAVE_POINTCLOUD           117

// if set, display OpenGL error flag
//
#define LIBFLAG_OGL_ERROR                 118

// pixel size for 3DMF pixmap
//
#define PIXEL_3DMF_16          0
#define PIXEL_3DMF_24          1
#define PIXEL_3DMF_32          2
//
#define LIBFLAG_PIXEL_SIZE_3DMF           119

// if flag is set, do not draw to view window
//
#define LIBFLAG_NO_DRAW                   120

// if flag is set, display default texture
// when texture is missing or can not be read
//
#define LIBFLAG_OGL_USE_DEFAULT_TEXTURE   121

// if set, DEM color range is variable
//
#define LIBFLAG_DEM_VARIABLE_COLOR        122

// if set, display view/camera axes
//
#define LIBFLAG_VIEW_AXES                 123

// if set, write 'AddMaterialMode Double'
//
#define LIBFLAG_RWX_ADDMATERIALMODE_DOUBLE  124   // obsolete as of version 2.9.12 - always set

// if set, use BackfacingStyle
//
#define LIBFLAG_USE_3DMF_BACKFACINGSTYLE    125

// X3D Precision - number of decimals for X3D output
//
#define LIBFLAG_X3D_PRECISION               126   // obsolete - use LIBFLAG_VERTEX_OUT_PRECISION


// formatted X3D Output
//
    // X3D_NOINDENT     1     // obsolete - use LIBFLAG_NOINDENT_OUT
    // X3D_DROPZEROS    2     // obsolete - use DROPZERO_OUT_FLAG
//
#define LIBFLAG_X3D_NOFORMAT                127


// X3D ElevationGrid
// if set, write ElevationGrid node instead of IndexedFaceSet node
//
#define LIBFLAG_X3D_ELEVATIONGRID           128


// x3dWriteNodesFlag
//
    // X3D_WORLDINFO           1
    // X3D_NAVIGATIONINFO      2
    // X3D_VIEWPOINT_FRONT     4
    // X3D_VIEWPOINT_RIGHT     8
    // X3D_VIEWPOINT_BACK     16
    // X3D_VIEWPOINT_LEFT     32
    // X3D_VIEWPOINT_TOP      64
    // X3D_VIEWPOINT_BOTTOM  128
//
#define LIBFLAG_X3D_WRITENODES              129

// if set, use DisplayGroup
//
#define LIBFLAG_USE_3DMF_DISPLAYGROUP       130

// RWX Precision - number of decimals for Renderware Translation
//
#define LIBFLAG_RWX_TRANSPRECISION          131

// UV Precision - number of decimals for UV texture coordinates
//
#define LIBFLAG_UV_PRECISION                132

// if set, use 3DS key frame data to scale, rotate, position and clone
//
#define LIBFLAG_USE_3DS_KEYFRAME            133

// remove duplicate vertices when reading files and merging data
//
#define LIBFLAG_REMOVE_DUPLICATE_VERTICES   134

// if set, check if texture is AW filmstrip
//
#define LIBFLAG_USE_AW_FILMSTRIP            135

// frames per second for AW filmstrip
//
#define LIBFLAG_AW_FILMSTRIP_FPS            136

// if set, enable timer for AW filmstrip
//
#define LIBFLAG_AW_FILMSTRIP_TIMER          137

// Layer Attributes Precision - number of decimals for layer attributes
//
#define LIBFLAG_LAYER_ATTR_PRECISION        138

// if set, write global layer attributes at start of RWX file
//
#define LIBFLAG_RWX_GLOBAL_ATTR             139

// if set, write comment on first line of RWX file
//
#define LIBFLAG_RWX_TITLE_COMMENT           140

// if set, do not write ModelBegin and ModelEnd pair to RWX file
//
#define LIBFLAG_RWX_NO_MODELBEGIN          141

// if set, use RWX materials for OpenGL display
//
#define LIBFLAG_USE_RWX_MATERIALS          142

// if set, write emissive as RWX Prelight
//
#define LIBFLAG_RWX_PRELIGHT               143

// if set, do not write #! characters to RWX file
//
#define LIBFLAG_NO_RWX_SPECIAL_CHAR        144

// if set, use ambient1 instead of ambientRGB
//
#define LIBFLAG_USE_AMBIENT1               145

// if set, use diffuse1 instead of diffuseRGB
//
#define LIBFLAG_USE_DIFFUSE1               146

// if set, use specular1 instead of specularRGB
//
#define LIBFLAG_USE_SPECULAR1              147

// if set, use transparency1 instead of transparencyRGB
//
#define LIBFLAG_USE_TRANSPARENCY1          148

// if set, write vertex colors to file
//
#define LIBFLAG_VCOLOR_OUTPUT              149

// if set, RGB vertex colors
// if clear, RGBA vertex colors
//
#define LIBFLAG_VCOLOR_RGB                 150

// use in place of
// DIRECTX_PRECISION, DXF_PRECISION, MAYA_PRECISION
// RWX_PRECISION, XSI_PRECISION, MTX_PRECISION
// VRML_PRECISION, X3D_PRECISION
//
#define LIBFLAG_VERTEX_OUT_PRECISION       151

// Drop leading and trailing zeroes when writing files
//
#define LIBFLAG_DROPZERO_OUT               152

// number of decimals when writing normals
//
#define LIBFLAG_NORMAL_OUT_PRECISION       153

// if set, write POV camera, light, background nodes
//
#define LIBFLAG_WRITE_POV_NODES            154

// if set, save one object with multiple materials
//
#define LIBFLAG_SAVE_ONEOBJECT_MULTIMATERIAL  155

// if set, write "g" group name to Wavefront file
//
#define LIBFLAG_OBJ_G_GROUPNAME_OUT           156

// if set, merge identical materials when reading trueSpace mesh
//
#define LIBFLAG_MERGE_TS_MATERIALS_IN         157

// if set and LIBFLAG_SAVE_TEXTUREPATH is set, save partial texture path
//
#define LIBFLAG_PARTIAL_TEXTUREPATH           158

// if set, no indented Open Inventor Output
//
#define LIBFLAG_IV_NOINDENT                   159   // obsolete - use LIBFLAG_NOINDENT_OUT

// ivWriteNodesFlag
//
    // IV_INFO                     - flag =  1
    // IV_PERSPECTIVECAMERA_FRONT  - flag =  2
    // IV_PERSPECTIVECAMERA_RIGHT  - flag =  4
    // IV_PERSPECTIVECAMERA_BACK   - flag =  8
    // IV_PERSPECTIVECAMERA_LEFT   - flag = 16
    // IV_PERSPECTIVECAMERA_TOP    - flag = 32
    // IV_PERSPECTIVECAMERA_BOTTOM - flag = 64
//
#define LIBFLAG_IV_WRITENODES                 160

// if set, do not indent when writing files
//
#define LIBFLAG_NOINDENT_OUT                  161

// write DEM or 3D model to XYZ file
//
// out XYZ File Type
    // flag = 0, ASCII
    // flag = 1, Binary
//
#define LIBFLAG_OUT_XYZ_BINARY                162

// out XYZ Byte Order
    // flag = 0, Intel Byte Order
    // flag = 1, Motorola Byte Order
//
#define LIBFLAG_OUT_XYZ_MOTOROLA              163

// out XYZ float type
    // flag = 0, float
    // flag = 1, double
//
#define LIBFLAG_OUT_XYZ_DOUBLE                164

// out XYZ axis
    // XYZ_AXIS_CRHS - flag = 0
    // XYZ_AXIS_LHS  - flag = 1
    // XYZ_AXIS_RHS  - flag = 2
//
#define LIBFLAG_OUT_XYZ_AXIS                  165

// if set, write header to XYZ file
//
#define LIBFLAG_DEMOUT_XYZ_HEADER             166

// if set, remove duplicate vertices before writing XYZ file
//
#define LIBFLAG_OUT_XYZ_REMOVE_DUPLICATES     167

// out XYZ use tab
    // flag = 0, space
    // flag = 1, tab
//
#define LIBFLAG_OUT_XYZ_TAB                   168

// if set, add X, Y or Z prefix when writing XYZ file
//
#define LIBFLAG_OUT_XYZ_PREFIX                169

// convert mesh to landscape
//
#define LIBFLAG_MESH_TO_DEM_STRETCH_X         170
#define LIBFLAG_MESH_TO_DEM_STRETCH_Y         171

    // flag = 0, keep original meshes
    // flag = 1, convert to landscape
    // flag = 2, convert to new mesh
    //
#define LIBFLAG_MESH_TO_DEM_CONVERT           172

#define LIBFLAG_MESH_TO_DEM_ADD_CLOUD         173
#define LIBFLAG_MESH_TO_DEM_DROP_FACES        174
#define LIBFLAG_MESH_TO_DEM_ADD_BASE          175
#define LIBFLAG_MESH_TO_DEM_ADD_UV            176
#define LIBFLAG_MESH_TO_DEM_WRITE_XYZ         177

// if set, use TableOfContents
//
#define LIBFLAG_USE_3DMF_TABLEOFCONTENTS      178

// if set, keep relative position when doing
// snap to vertex
//
#define LIBFLAG_SNAP_KEEP_RELATIVE            179

// if set, write one layer to each file
//
#define LIBFLAG_WRITE_ONE_LAYER_PER_FILE      180

// if set, rotate object around origin
// this flag is cleared when a new file is read
//
#define LIBFLAG_ORIGIN_ROTATE                 181

// if this flag and ORIGIN_ROTATE_FLAG is set
// show the axes at the origin
//
#define LIBFLAG_DRAW_OBJECT_AXES              182

// if set, allow rotation or drag on axis
// flag value can be changed by DLL without user input
//
#define LIBFLAG_X_AXIS_CONTROL                183     // obsolete as of version 1.4.8
#define LIBFLAG_Y_AXIS_CONTROL                184     // obsolete as of version 1.4.8
#define LIBFLAG_Z_AXIS_CONTROL                185     // obsolete as of version 1.4.8


// if set, do not write carriage return and line feed to XGL files
//
#define LIBFLAG_XGL_NORETURN                  186

// XGL output flag
//
#define XGL_OUTPUT_SIMPLE        0
#define XGL_OUTPUT_HIERARCHY     1
//
#define LIBFLAG_XGL_OUTPUT                    187    // obsolete - use LIBFLAG_HIERARCHY_OUTPUT

// XGL pelvis location flag
  // flag = 0 - pelvis centered at origin
  // flag = 1 - feet on ground
  //
#define XGL_LOCATION_PELVIS   0
#define XGL_LOCATION_FEET     1
//
#define LIBFLAG_XGL_LOCATION                  188   // obsolete - use LIBFLAG_AV_LOCATION_OUTPUT


// if set, do not write carriage return and line feed to CableMode files
//
#define LIBFLAG_CABLEMOD_NORETURN             189


// CableMode output flag
//
#define CABLEMOD_OUTPUT_SIMPLE        0
#define CABLEMOD_OUTPUT_HIERARCHY     1
//
#define LIBFLAG_CABLEMOD_OUTPUT               190   // obsolete - use LIBFLAG_HIERARCHY_OUTPUT


// CableMod units flag
//
  // 0 = "um"
  // 1 = "mm"
  // 2 = "cm"
  // 3 = "m"
  // 4 = "mil"
  // 5 = "inch"
//
#define LIBFLAG_CABLEMOD_UNITS                191


// if set, all DXF layers will be turned on
//
#define LIBFLAG_DXF_ALL_LAYERS_ON             192


// if set, emissive is written as Kerkythea radiance
//
#define LIBFLAG_KERKYTHEA_USE_RADIANCE           193


// if set, Kerkythea radiance is an emitter
//
#define LIBFLAG_KERKYTHEA_RADIANCE_EMITTER       194


// if set, point lights are saved as spot lights to Kerkythea file
//
#define LIBFLAG_KERKYTHEA_POINT_AS_SPOT          195


// if set, directional lights are saved as omni, sun or spot lights to Kerkythea file
//
  // 0 = omni
  // 1 = sun
  // 2 = spot
  //
#define LIBFLAG_KERKYTHEA_DIRECTIONAL_AS_SPOT    196


// if set, a point light will point up when saved to a KERKYTHEA file
//
#define LIBFLAG_KERKYTHEA_POINT_UP               197


// Attenuation for Kerkythea lights
//
  // 0 = none
  // 1 = inverse
  // 2 = inverse square
  //
#define LIBFLAG_KERKYTHEA_DIRECTIONAL_ATTENUATION   198
#define LIBFLAG_KERKYTHEA_POINT_ATTENUATION         199
#define LIBFLAG_KERKYTHEA_SPOT_ATTENUATION          200


// if flag is set, spot light values for hot spot and falloff
// read from the import file are replaced with the same user specified values
//
#define LIBFLAG_KERKYTHEA_SPOT_REPLACE              201


// if set, make spot light hot spot a fraction of the falloff angle
//
#define LIBFLAG_KERKYTHEA_SPOT_USE_HOT_FRACTION     202


// if set, the VRML file was written by Chief Architect
// and the directiona and spot light direction vectors must be converted
//
#define LIBFLAG_VRML_BY_CHIEF_ARCHITECT             203


// used when reading XYZ files
//
// for DLL only, if set do not use XyzDlg
//
#define LIBFLAG_XYZ_SKIP_DLG                        204

// XYZ Type
  // 0 = row and column mesh
  // 1 = scan
  //
#define LIBFLAG_XYZ_SCAN                            205

// XYZ File Type
//
  // 0 = ASCII
  // 1 = binary
  //
#define LIBFLAG_XYZ_BINARY_FILE                     206

// XYZ Byte Order
//
  // 0 = Intel
  // 1 = Motorola
  //
#define LIBFLAG_XYZ_MOTOROLA                        207

// XYZ Binary Floating Point Type
//
  // 0 = float
  // 1 = double
  //
#define LIBFLAG_XYZ_DOUBLE                          208

// XYZ Data Stored
//
  // 0 = by row
  // 1 = by column
  //
#define LIBFLAG_XYZ_BY_COLUMN                       209

// if set, use rectangular area from XYZ file
//
#define LIBFLAG_XYZ_CLIP                            210

// XYZ axis system
  // XYZ_AXIS_CRHS - flag = 0
  // XYZ_AXIS_LHS  - flag = 1
  // XYZ_AXIS_RHS  - flag = 2
  //
#define LIBFLAG_XYZ_AXIS                            211

// if set, save XYZ mesh as DXF polyline mesh
//
#define LIBFLAG_XYZ_SAVE_DXF                        212

// set DXF file version
  // 0 = Release 10 (FLATLAND = 0)
  // 1 = Release 10 (FLATLAND = 1)
  // 2 = Release 11 and newer
  //
#define LIBFLAG_XYZ_DXF_RELEASE                     213

// if set, XYZ file contains NoData values for some Z coordinates
//
#define LIBFLAG_XYZ_NODATA                          214

// flag indicates how NoData values in XYZ file will be handled
//
  // 0 = delete NoData triangles
  // 1 = use minumum valid Z coordinate
  // 2 = use specified replacement value
  //
#define LIBFLAG_XYZ_NODATA_REPLACE                  215

// if set, scale the Z coordinate
//
#define LIBFLAG_XYZ_SCALE_Z                         216

// if set, there is a name or number after the XYZ coordinate
//
#define LIBFLAG_XYZ_HAS_ID                          217

// use XYZ ID as layer name
//
#define LIBFLAG_XYZ_USE_ID                          218

// if set, use .PNG Alpha Channel Masks for Kerkythea
//
#define LIBFLAG_KERKYTHEA_USE_PNG_ALPHA_MASKS       219

// if set, write Text as the original text rather than as 3D meshes
//
#define LIBFLAG_WRITE_TEXT_AS_TEXT                  220

//  if set, Shadow for Kerkythea lights
//
#define LIBFLAG_KERKYTHEA_DIRECTIONAL_SHADOW          221
#define LIBFLAG_KERKYTHEA_POINT_SHADOW                222
#define LIBFLAG_KERKYTHEA_SPOT_SHADOW                 223


//  if set, Soft Shadow for Kerkythea lights
//
#define LIBFLAG_KERKYTHEA_DIRECTIONAL_SOFT_SHADOW     224
#define LIBFLAG_KERKYTHEA_POINT_SOFT_SHADOW           225
#define LIBFLAG_KERKYTHEA_SPOT_SOFT_SHADOW            226


//  if set, Global Photons for Kerkythea lights
//
#define LIBFLAG_KERKYTHEA_DIRECTIONAL_GLOBAL_PHOTONS  227
#define LIBFLAG_KERKYTHEA_POINT_GLOBAL_PHOTONS        228
#define LIBFLAG_KERKYTHEA_SPOT_GLOBAL_PHOTONS         229


//  if set, Caustic Photons for Kerkythea lights
//
#define LIBFLAG_KERKYTHEA_DIRECTIONAL_CAUSTIC_PHOTONS 230
#define LIBFLAG_KERKYTHEA_POINT_CAUSTIC_PHOTONS       231
#define LIBFLAG_KERKYTHEA_SPOT_CAUSTIC_PHOTONS        232


//  if set, Negative Light for Kerkythea lights
//
#define LIBFLAG_KERKYTHEA_DIRECTIONAL_NEGATIVE        233
#define LIBFLAG_KERKYTHEA_POINT_NEGATIVE              234
#define LIBFLAG_KERKYTHEA_SPOT_NEGATIVE               235


// if set, display stage
//
#define LIBFLAG_STAGE_USE                             236

// type of stage to display
//
#define STAGE_TYPE_WIRES        0
#define STAGE_TYPE_SQUARES      1
//
#define LIBFLAG_STAGE_TYPE                            237

// if set, display texture on stage
//
#define LIBFLAG_STAGE_UV                              238

// if set, use origin settings to position texture image
//
#define LIBFLAG_STAGE_ORIGIN                          239

// if set, display background image
//
#define LIBFLAG_BACKGROUND_IMAGE_USE                  240


// used when reading Bitmap to 3D files
//
// for DLL only, if set do not use BitmapTo3dDlg
//
#define LIBFLAG_BITMAP_TO_3D_SKIP_DLG                 241

// if set, outlines will be created for palette index 0
//
#define LIBFLAG_BITMAP_TO_3D_DECODE_0                 242

// if set, save outlines as polylines to a DXF file
//
#define LIBFLAG_BITMAP_TO_3D_SAVE_OUTLINES            243

// if set, triangles will be added to the outline
//
#define LIBFLAG_BITMAP_TO_3D_ADD_FACES                244

// if set, the outlines with added faces will be extuded
//
#define LIBFLAG_BITMAP_TO_3D_EXTRUDE                  245


// used when reading Bitmap to Landscape files
//
// for DLL only, if set do not use BitmapMultDlg
//
#define LIBFLAG_BITMAP_TO_LANDSCAPE_SKIP_DLG          246

// if set, place sea level at color 4
//
#define LIBFLAG_BITMAP_TO_LANDSCAPE_SEA_LEVEL         247


// if set, save Camera and Sunlight to LXO file
//
#define LIBFLAG_SAVE_LXO_CAMERA_LIGHT                 248

// if set, save Heirarchy and Joints to LXO file
//
#define LIBFLAG_SAVE_LXO_HIERARCHY                    249   // obsolete - use LIBFLAG_HIERARCHY_OUTPUT
#define LIBFLAG_SAVE_LXO_JOINTS                       250

// if set, display OpenGL messages for debug purposes
//
#define LIBFLAG_DISPLAY_OGL_DEBUG_MSGS                251

// if set, reverse mouse wheel zoom directon
//
#define LIBFLAG_REVERSE_ZOOM_DIRECTION                252

// if set, holes will be added to the outer outline
//
#define LIBFLAG_BITMAP_TO_3D_JOIN_OUTLINES            253

// when picking DXF Pen that matches diffuse color
// use this pen for color black (RGB = 0,0,0)
// pen range: 1 to 255
//
#define LIBFLAG_DXF_PEN_MATCH_RGB_000                 254

// if set, reverse camera pan directon
//
#define LIBFLAG_REVERSE_PAN_DIRECTION                 255

// if set, focus will be set to the DLL during camera rotate, pan and zoom
// and returned to the control that had focus afterwards
//
#define LIBFLAG_GRAB_KEYBOARD_FOCUS                   256

// if set, always show cursor during camera rotate, pan and zoom
//
#define LIBFLAG_ALWAYS_SHOW_CAMERA_CURSOR             257

// if set, debug messages will be displayed in At3d_Stop() function
//
#define LIBFLAG_DEBUG_STOP_MESSAGES                   258


// if set, save Heirarchy to 3DS, CableMod, DirectX, LXO, MTX, XGL, XSI files
// use in place of
// LIBFLAG_MTX_OUTPUT, LIBFLAG_DIRECTX_OUTPUT, LIBFLAG_XSI_OUTPUT,
// LIBFLAG_XGL_OUTPUT, LIBFLAG_CABLEMOD_OUTPUT, LIBFLAG_SAVE_LXO_HIERARCHY
//
#define LIBFLAG_HIERARCHY_OUTPUT                      259


// Avatar pelvis location flag
// flag = 0 - pelvis centered at origin
// flag = 1 - feet on ground
//
#define AV_LOCATION_PELVIS   0
#define AV_LOCATION_FEET     1
//
// use in place of LIBFLAG_XGL_LOCATION
//
#define LIBFLAG_AV_LOCATION_OUTPUT                    260


// if set, display OpenGL Snapshot messages for debug purposes
// Note: LIBFLAG_DISPLAY_OGL_DEBUG_MSGS must also be set
//
#define LIBFLAG_DISPLAY_OGL_SNAPSHOT_DEBUG_MSGS       261


// UP Axis when writing Collada DAE files
//
#define COLLADA_UP_AXIS_X     0
#define COLLADA_UP_AXIS_Y     1
#define COLLADA_UP_AXIS_Z     2
//
#define LIBFLAG_COLLADA_OUTPUT_UP_AXIS                262


// if set, zoom speeds automatically change while zooming
//
#define LIBFLAG_CAMERA_ZOOM_SPEED_AUTOMATIC           263


// if set, after read invert transparencies if all layers are transparent
//
#define LIBFLAG_CHECK_AND_FIX_TRANSPARENCIES          264


// if set, after reading KMZ file apply the KMZ model factors
//
#define LIBFLAG_KMZ_INPUT_MODEL_FACTORS               265


// if set, always write transparency to Collada DAE files
//
#define LIBFLAG_ALWAYS_WRITE_COLLADA_TRANSPARENCY     266


// TrueType Fonts - continued
//
// if set, reverse points in outline
//
#define LIBFLAG_TT_REVERSE_OUTLINES                   267

// if set, make all vertices on the curve
//
#define LIBFLAG_TT_ON_CURVE                           268

// if set, keep original vertex coordinates
//
#define LIBFLAG_TT_ORIG_VERTS                         269

// if set, base height on all characters in the character set
//
#define LIBFLAG_TT_ALL_CHARS                          270

// if set, VRML extrusions will done with a miter joint
//
#define LIBFLAG_VRML_MITER_JOINT_EXTRUSION            271

// before a 3D model is exported to a 3D file format, any embedded textures
// are first relocated to a folder which will be a child of the folder
// to which the 3D file is exported.
// if the flag is set, a partial texture path will be written to the 3D file
// otherwise a full texture path will be written.
//
#define LIBFLAG_EMBEDDED_TEXTURES_PARTIAL_PATH        272

//---------------------------------------------------------------------------

// Material Flags
//
#define MATFLAG_F1_AMBIENT             0   // range: 0.0 to 1.0
#define MATFLAG_F3_AMBIENT             1   // range: 0.0 to 1.0
#define MATFLAG_F1_DIFFUSE             2   // range: 0.0 to 1.0
#define MATFLAG_F3_DIFFUSE             3   // range: 0.0 to 1.0
#define MATFLAG_F1_SPECULAR            4   // range: 0.0 to 1.0
#define MATFLAG_F3_SPECULAR            5   // range: 0.0 to 1.0
#define MATFLAG_F3_EMISSIVE            6   // range: 0.0 to 1.0
#define MATFLAG_F1_ROUGHNESS           7   // range: 0.0 to 1.0
#define MATFLAG_F1_SHININESS           8   // range: 0.0 to 1.0
#define MATFLAG_F1_TRANSPARENCY        9   // range: 0.0 to 1.0
#define MATFLAG_F3_TRANSPARENCY       10   // range: 0.0 to 1.0
#define MATFLAG_F1_INDEXREFRACTION    11
#define MATFLAG_F1_CREASEANGLE        12   // >= 0.0 radians
#define MATFLAG_F1_REFLECTION         13   // range: 0.0 to 1.0
#define MATFLAG_F3_REFLECTION         14   // range: 0.0 to 1.0
#define MATFLAG_F3_COLOR              15   // range: 0.0 to 1.0
                                           // use with ambient1, diffuse1, specular1

#define MATFLAG_I1_DXF_COLOR             100   // range: 1 to 255
#define MATFLAG_I1_DOUBLESIDED           101   // 0 or 1

// RWX_POINTCLOUD   0
// RWX_WIREFRAME    1
// RWX_SOLID        2
#define MATFLAG_I1_RWX_GEOMETRYSAMPLING  102

// RWX_FACET   0
// RWX_VERTEX  1
#define MATFLAG_I1_RWX_LIGHTSAMPLING     103

// RWX_NULL         0
// RWX_LIT          1
// RWX_FORESHORTEN  2
// RWX_FILTER       4
#define MATFLAG_I1_RWX_TEXTUREMODES      104

#define MATFLAG_I1_RWX_TAG               105   // obsolete
#define MATFLAG_I1_RWX_CLUMPTAG          105

#define MATFLAG_I1_RWX_FACETAG           106

//---------------------------------------------------------------------------

// Color Map
//
// Section 1:  DXF Pens
//
#define CMAP_DXF_PEN_0             0  // DXF Pen 0 is background color
#define CMAP_DXF_PEN_1             1  // DXF Pen 1 to DXF Pen 255 are
#define CMAP_DXF_PEN_255         255  // used to draw the entities
//
// Section 2: Backgrounds for original software viewer
//
#define CMAP_COLOR_BACKGROUND    256  // color shades background
#define CMAP_GREY_BACKGROUND     257  //grey shades background
//
// Section 3: Avatar module
//
#define CMAP_AV_SELECT           258  // avatar selected layer
#define CMAP_AV_OTHER            259  // avatar other layers
#define CMAP_AV_EDGE             260  // avatar edge on polygon
#define CMAP_AV_JOINT            261  // avatar joint
#define CMAP_AV_BACKGROUND1      262  // avatar background 1   - wireframe
#define CMAP_AV_BACKGROUND2      263  // avatar background 2   - solid painted
#define CMAP_STAGE_WIREFRAME     264  // stage wireframe
#define CMAP_STAGE_SQUARE1       265  // stage square 1
#define CMAP_STAGE_SQUARE2       266  // stage square 2
#define CMAP_OBJECT_BBOX         267  // object bounding box
//
// Section 4: OpenGL viewer
//
#define CMAP_OGL_WIRE_UNLIT_EDGE             268
#define CMAP_OGL_WIRE_UNLIT_FILL             269
#define CMAP_OGL_WIRE_LIT_FILL               270
#define CMAP_OGL_FLAT_EDGE                   271
#define CMAP_OGL_BACKGROUND                  272
#define CMAP_OGL_ALIGN_FRONT                 273
#define CMAP_OGL_ALIGN_BACK                  274
#define CMAP_OGL_ALIGN_OTHER                 275
#define CMAP_OGL_ALIGN_EDGE                  276
#define CMAP_OGL_EDIT_LINES                  277
#define CMAP_OGL_EDIT_POINTS                 278
#define CMAP_OGL_EDIT_PICK                   279  // obsolete - use CMAP_OGL_EDIT_PICK_POINT
#define CMAP_OGL_EDIT_PICK_POINT             279
#define CMAP_OGL_EDIT_MULTIPICK              280
#define CMAP_OGL_EDIT_OTHER                  281
#define CMAP_OGL_EDIT_GHOST                  282
#define CMAP_OGL_EDIT_GRID                   283
#define CMAP_OGL_EDIT_DRAG                   284
#define CMAP_OGL_JOIN_RED                    285
#define CMAP_OGL_JOIN_BLUE                   286
#define CMAP_OGL_JOIN_OTHER                  287
#define CMAP_OGL_LAYER_TARGET                288
#define CMAP_OGL_LAYER_MOVE                  289
#define CMAP_OGL_LAYER_OTHER                 290
#define CMAP_AV_GHOST_PAST                   291
#define CMAP_AV_GHOST_FUTURE                 292
#define CMAP_OGL_ARROW_X                     293
#define CMAP_OGL_ARROW_Y                     294
#define CMAP_OGL_ARROW_Z                     295
#define CMAP_OGL_TRIANGLE_OPS_STAY           296
#define CMAP_OGL_TRIANGLE_OPS_MOVE           297
#define CMAP_OGL_TRIANGLE_OPS_TARGET         298
#define CMAP_OGL_TRIANGLE_OPS_OTHER          299
#define CMAP_OGL_TRIANGLE_OPS_EDGE           300
#define CMAP_OGL_TRIANGLE_OPS_UNDO_STAY      301
#define CMAP_OGL_TRIANGLE_OPS_UNDO_MOVE      302
#define CMAP_OGL_EDIT_PICKED_LINES           303
#define CMAP_OGL_EDIT_FILL                   304
#define CMAP_OGL_EDIT_LASSO                  305
#define CMAP_OGL_ALIGN_LASSO                 306
#define CMAP_OGL_MODIFY_QUADS_PLANAR         307
#define CMAP_OGL_MODIFY_QUADS_NONPLANAR      308
#define CMAP_OGL_MODIFY_QUADS_TRIANGLE       309
#define CMAP_OGL_MODIFY_QUADS_PICK_TRIANGLE  310
#define CMAP_OGL_MODIFY_QUADS_PICK_QUAD      311
#define CMAP_OGL_MODIFY_QUADS_PICK_QUAD_BENT 312 
#define CMAP_OGL_MODIFY_QUADS_OTHER_FILL     313
#define CMAP_OGL_MODIFY_QUADS_LINES          314
#define CMAP_OGL_MODIFY_QUADS_PICK_LINES     315
#define CMAP_OGL_MODIFY_QUADS_OTHER_LINES    316
#define CMAP_OGL_MODIFY_QUADS_POINTS         317
#define CMAP_OGL_MODIFY_QUADS_PICK_POINT     318

//---------------------------------------------------------------------------

// DEM Color Map
//
#define DEM_CMAP_2D_0           0  // use indices 0 to 3 to draw 2D contour lines
                                   // below sea level
#define DEM_CMAP_2D_SEA_LEVEL   4
#define DEM_CMAP_2D_31        243  // 0 is the lowest elevation and 243 is the highest
//
#define DEM_CMAP_BACKGROUND   244  // background color for landscapes
//
#define DEM_CMAP_PEN_0        245  // use indices 245 to 254 for the pen colors to draw
#define DEM_CMAP_PEN_9        254  // new features on the 2D contour map
//
#define DEM_CMAP_LAKE         255  // color to draw the lakes

//---------------------------------------------------------------------------

// pens for drawing in original software viewer
//
#define DRAWPEN_POINTS         0
#define DRAWPEN_LINES          1
#define DRAWPEN_PICK           2
#define DRAWPEN_MULTI          3
#define DRAWPEN_SCALE          4
#define DRAWPEN_GRID           5
#define DRAWPEN_GHOST          6
#define DRAWPEN_EDGE           7
#define DRAWPEN_FRONT          8
#define DRAWPEN_BACK           9
#define DRAWPEN_OTHER         10
#define DRAWPEN_JOINRED       11
#define DRAWPEN_JOINBLUE      12
#define DRAWPEN_JOINOTHER     13
#define DRAWPEN_TARGETLAYER   14
#define DRAWPEN_MOVELAYER     15
#define DRAWPEN_OTHERLAYER    16
#define DRAWPEN_AVJOINT       17
#define DRAWPEN_AVBBOX        18
#define DRAWPEN_OBJECTBBOX    19

//---------------------------------------------------------------------------

// type of map to use to create UV coordinates
//
#define TEXTUREMAP_PLANAR         0
#define TEXTUREMAP_CYLINDRICAL    1
#define TEXTUREMAP_SPHERICAL      2

//---------------------------------------------------------------------------

// edit: pick vertex mode
//
#define EDIT_PICK_VERTEX_FIRST          0
#define EDIT_PICK_VERTEX_CONNECTED      1
#define EDIT_PICK_VERTEX_ANYWHERE       2
#define EDIT_PICK_VERTEX_ERASE          3
#define EDIT_PICK_VERTEX_DELETE_ALL     4
#define EDIT_PICK_VERTEX_SWITCH_FIRST   5

//---------------------------------------------------------------------------

// edit: upper or lower bevels
//
#define EDIT_BEVELS_UPPER   0
#define EDIT_BEVELS_LOWER   1

//---------------------------------------------------------------------------

// edit: extrude flags
//
#define EDIT_FLAG_UPPER_FACES     0
#define EDIT_FLAG_UPPER_BEVELS    1
#define EDIT_FLAG_LOWER_FACES     2
#define EDIT_FLAG_LOWER_BEVELS    3

//---------------------------------------------------------------------------

// camera rotation speed
//
#define CAMERA_ROTATE_SPEED_1   0
#define CAMERA_ROTATE_SPEED_2   1

//---------------------------------------------------------------------------

// camera zoom speed
//
#define CAMERA_ZOOM_SPEED_1     0
#define CAMERA_ZOOM_SPEED_2     1
#define CAMERA_ZOOM_SPEED_3     2
#define CAMERA_ZOOM_SPEED_4     3
#define CAMERA_ZOOM_SPEED_5     4
#define CAMERA_ZOOM_SPEED_6     5

//---------------------------------------------------------------------------

// extruce pseudo 2D surface
//
#define EXTRUDE_PSEUDO2D_NORMAL        0
#define EXTRUDE_PSEUDO2D_FLAT_TOP      1
#define EXTRUDE_PSEUDO2D_FLAT_BOTTOM   2

//---------------------------------------------------------------------------

// KML values for doc.kml for Google Earth
//
#define KML_CLAMP_TO_GROUND           0
#define KML_RELATIVE_TO_GROUND        1
#define KML_ABSOLUTE                  2
#define KML_RELATIVE_TO_SEA_FLOOR     3
#define KML_CLAMP_TO_SEA_FLOOR        4

#define KML_ALTITUDE_MODE_COUNT       5

//---------------------------------------------------------------------------

#endif
