//----------------------------------------------------------------------------
//  Project Test_At3dx_Viewer
//  MicroMouse Productions
//  Copyright  2010-2012. All Rights Reserved.
//  Author: Wayne Hogue
//
//----------------------------------------------------------------------------

// MSVC_Test_At3dx_ViewerDlg.cpp : implementation file
//

#include "stdafx.h"

#include "MSVC_Test_At3dx_Viewer.h"
#include "MSVC_Test_At3dx_ViewerDlg.h"
#include "..\at3dx_my_functions.h"
#include "..\at3ddll.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMSVC_Test_At3dx_ViewerDlg dialog

CMSVC_Test_At3dx_ViewerDlg::CMSVC_Test_At3dx_ViewerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMSVC_Test_At3dx_ViewerDlg::IDD, pParent)
  , m_UseTextures(FALSE)
  , m_ReversePan(FALSE)
  , m_ReverseZoom(FALSE)
  , m_AlwaysShowCameraCursor(FALSE)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

  dllOpen    = 0;
  fileLoaded = 0;

  memset(inName, 0, sizeof(char) * MAX_PATH);

  // Display textures
  //
  useTexturesFlag = 1;

  // Reverse direction of pan
  //
  reversePanFlag = 1;

  // Reverse direction of zoom
  //
  reverseZoomFlag = 1;

  // Default setting for camera cursor
  //
  alwaysShowCameraCursorFlag = 0;
}

void CMSVC_Test_At3dx_ViewerDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Check(pDX, IDC_USE_TEXTURES, m_UseTextures);
  DDX_Check(pDX, IDC_REVERSE_PAN, m_ReversePan);
  DDX_Check(pDX, IDC_REVERSE_ZOOM, m_ReverseZoom);
  DDX_Check(pDX, IDC_ALWAYS_SHOW_CAMERA_CURSOR, m_AlwaysShowCameraCursor);
}

BEGIN_MESSAGE_MAP(CMSVC_Test_At3dx_ViewerDlg, CDialog)
  ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
  ON_BN_CLICKED(IDC_READ_OBJ_FILE, &CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_ReadObjFile)
  ON_BN_CLICKED(IDC_USE_TEXTURES, &CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_UseTextures)
  ON_BN_CLICKED(IDC_REVERSE_PAN, &CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_ReversePan)
  ON_BN_CLICKED(IDC_REVERSE_ZOOM, &CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_ReverseZoom)
  ON_BN_CLICKED(IDC_ALWAYS_SHOW_CAMERA_CURSOR, &CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_AlwaysShowCameraCursor)
END_MESSAGE_MAP()


// CMSVC_Test_At3dx_ViewerDlg message handlers

BOOL CMSVC_Test_At3dx_ViewerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

  Start_DLL();	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMSVC_Test_At3dx_ViewerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// free all memory used by the DLL
	//
	if (dllOpen) At3d_Stop();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMSVC_Test_At3dx_ViewerDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMSVC_Test_At3dx_ViewerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CMSVC_Test_At3dx_ViewerDlg::Start_DLL(void)
{
  if (dllOpen) return;

  dllOpen = At3d_Start();

  if (!dllOpen) return;
	
  // To detect mouse scroll wheel messages the DLL has to know the
  // handle to the main window of the application which
  // receives all the messages from the Windows Operating System
  //
  At3d_SetAppHandle(GetSafeHwnd());

  // Set size of DLL window
  //
  At3d_Size(600, 500);

  // Set position of DLL window
  //
  At3d_Position(2, 2);

  // Make DLL window a child of a window in the application
  //
  At3d_SetParent(GetSafeHwnd());

  // If the DLL window does not have a parent
  // At3d_SetParent(0);
  // a button will appear on the Windows Taskbar
  // use this function to set the name that will appear
  //
  At3d_SetCaption("DLL (at3d)");

  // Use the OpenGL view window
  //
  At3d_WriteFlag(LIBFLAG_USE_OPENGL, 1);

  // Light both sides of the polygons
  //
  At3d_WriteFlag(LIBFLAG_OGL_2SIDED_LIGHTING, 1);

  // Cull back faces of the polygons
  //
  At3d_WriteFlag(LIBFLAG_OGL_CULL_BACKFACES,1);

  m_UseTextures = (useTexturesFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_OGL_USE_TEXTURES, useTexturesFlag);

  // Use default texture if there is no texture file assigned
  //
  At3d_WriteFlag(LIBFLAG_OGL_USE_DEFAULT_TEXTURE, 1);

  // Let texture colors be affected by the lighting
  //
  At3d_WriteFlag(LIBFLAG_OGL_REPLACE, 0);

  // Do not blend polygon color with the texture colors
  //
  At3d_WriteFlag(LIBFLAG_OGL_WHITE_BASE, 1);

  m_ReversePan = (reversePanFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_REVERSE_PAN_DIRECTION, reversePanFlag);

  m_ReverseZoom = (reverseZoomFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_REVERSE_ZOOM_DIRECTION, reverseZoomFlag);

  m_AlwaysShowCameraCursor = (alwaysShowCameraCursorFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_ALWAYS_SHOW_CAMERA_CURSOR, alwaysShowCameraCursorFlag);

  // Make DLL window visible
  //
  At3d_Show();

  UpdateData(FALSE);
}

void CMSVC_Test_At3dx_ViewerDlg::Stop_DLL(void)
{
  if (!dllOpen) return;

  // free all memory used by the DLL
	//
	At3d_Stop();
  dllOpen = 0;
}

void CMSVC_Test_At3dx_ViewerDlg::Read_3D_File(void)
{
  if (!dllOpen) return;

  char path[_MAX_PATH];
  char drive0[_MAX_DRIVE];
	char dir0[_MAX_DIR];
	char name0[_MAX_FNAME];
	char ext0[_MAX_EXT];
  
  if (inName[0] != 0)
  {
    my_splitpath(inName, drive0, _MAX_DRIVE, dir0, _MAX_DIR, name0, _MAX_FNAME,
                 ext0, _MAX_EXT);

    my_strcpy(path, _MAX_PATH, drive0);
    my_strcat(path, _MAX_PATH, dir0);

    my_strcat(name0, _MAX_FNAME, ext0);
  }
  else
  {
    path[0]  = '\0';
    name0[0] = '\0';
  }

  CString filter = "Wavefront";
  filter += "|*";
  filter += ".obj";
  filter += "|All|*.*|";

  CFileDialog dlg(TRUE, NULL, inName,
					OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST,
					filter, 0);

	if( dlg.DoModal() == IDOK )
  {
		my_strcpy(inName, MAX_PATH, (char*)LPCTSTR(dlg.GetPathName()));

    // before reading make sure flags are set properly
    // (note: flags maintain their setting until changed with this function)
    //
    At3d_WriteFlag(LIBFLAG_REMOVE_DUPLICATE_VERTICES, 1);
    At3d_WriteFlag(LIBFLAG_REMOVE_DUPLICATE_FACES, 1);
    At3d_WriteFlag(LIBFLAG_SHOW_READ_MESSAGES, 0);

    // read file
    //
    fileLoaded = At3d_Read(INTYPE_WAVEFRONT, inName, 1.0);
  }
}

void CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_ReadObjFile()
{
  Read_3D_File();
}

void CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_UseTextures()
{
  if (!dllOpen) return;

  UpdateData(TRUE);
  useTexturesFlag = (m_UseTextures) ? 1 : 0;

  At3d_WriteFlag(LIBFLAG_OGL_USE_TEXTURES, useTexturesFlag);
}

void CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_ReversePan()
{
  if (!dllOpen) return;
  
  UpdateData(TRUE);
  reversePanFlag = (m_ReversePan) ? 1 : 0;

  At3d_WriteFlag(LIBFLAG_REVERSE_PAN_DIRECTION, reversePanFlag);
}

void CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_ReverseZoom()
{
  if (!dllOpen) return;
  
  UpdateData(TRUE);
  reverseZoomFlag = (m_ReverseZoom) ? 1 : 0;
  
  At3d_WriteFlag(LIBFLAG_REVERSE_ZOOM_DIRECTION, reverseZoomFlag);
}

void CMSVC_Test_At3dx_ViewerDlg::OnBnClicked_AlwaysShowCameraCursor()
{
  if (!dllOpen) return;
  
  UpdateData(TRUE);
  alwaysShowCameraCursorFlag = (m_AlwaysShowCameraCursor) ? TRUE : FALSE;
    
  At3d_WriteFlag(LIBFLAG_ALWAYS_SHOW_CAMERA_CURSOR, alwaysShowCameraCursorFlag);
}
