// MSVC_Test_At3dx_Read_WriteDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MSVC_Test_At3dx_Read_Write.h"
#include "MSVC_Test_At3dx_Read_WriteDlg.h"
#include "..\at3dx_my_functions.h"
#include "..\at3ddll.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMSVC_Test_At3dx_Read_WriteDlg dialog

CMSVC_Test_At3dx_Read_WriteDlg::CMSVC_Test_At3dx_Read_WriteDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMSVC_Test_At3dx_Read_WriteDlg::IDD, pParent)
  , m_Save2dLines(FALSE)
  , m_SaveUV(FALSE)
  , m_SaveQuads(FALSE)
  , m_MakeQuads(FALSE)
  , m_AngleBetweenNormals(_T(""))
  , m_AngleBetweenEdges(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

  memset(inName, 0, sizeof(char) * MAX_PATH);

  // Save 2D lines if they exist in the file
  //
  save2D_Flag    = 1;

  // Save UV coordinates if they exist in the file
  //
  saveUV_Flag    = 1;

  // Save Quads if they exist in the file
  //
  saveQuads_Flag = 1;

  // Option to turn triangles into quads
  //
  makeQuads_Flag = 0;

  angleBetweenNormals = 5.0;
  angleBetweenEdges   = 130.0;
}

void CMSVC_Test_At3dx_Read_WriteDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Check(pDX, IDC_SAVE_2D_LINES, m_Save2dLines);
  DDX_Check(pDX, IDC_SAVE_UV, m_SaveUV);
  DDX_Check(pDX, IDC_SAVE_QUADS, m_SaveQuads);
  DDX_Check(pDX, IDC_MAKE_QUADS, m_MakeQuads);
  DDX_Text(pDX, IDC_ANGLE_BETWEEN_NORMALS, m_AngleBetweenNormals);
  DDX_Text(pDX, IDC_ANGLE_BETWEEN_EDGES, m_AngleBetweenEdges);
}

BEGIN_MESSAGE_MAP(CMSVC_Test_At3dx_Read_WriteDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
  ON_BN_CLICKED(IDC_SAVE_2D_LINES, &CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_Save2dLines)
  ON_BN_CLICKED(IDC_SAVE_UV, &CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_SaveUV)
  ON_BN_CLICKED(IDC_SAVE_QUADS, &CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_SaveQuads)
  ON_BN_CLICKED(IDC_MAKE_QUADS, &CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_MakeQuads)
  ON_BN_CLICKED(IDC_READ_WRITE_FILE, &CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_ReadWriteFile)
END_MESSAGE_MAP()


// CMSVC_Test_At3dx_Read_WriteDlg message handlers

BOOL CMSVC_Test_At3dx_Read_WriteDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

  m_Save2dLines = (save2D_Flag) ? TRUE : FALSE;

  m_SaveUV = (saveUV_Flag) ? TRUE : FALSE;

  m_SaveQuads = (saveQuads_Flag) ? TRUE : FALSE;

  m_MakeQuads = (makeQuads_Flag) ? TRUE : FALSE;

  m_AngleBetweenNormals.Format("%.2f", angleBetweenNormals);
  m_AngleBetweenEdges.Format("%.2f", angleBetweenEdges);

  UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMSVC_Test_At3dx_Read_WriteDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMSVC_Test_At3dx_Read_WriteDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_Save2dLines()
{
  UpdateData(TRUE);
  save2D_Flag = (m_Save2dLines) ? 1 : 0;
}

void CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_SaveUV()
{
  UpdateData(TRUE);
  saveUV_Flag = (m_SaveUV) ? 1 : 0;
}

void CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_SaveQuads()
{
  UpdateData(TRUE);
  saveQuads_Flag = (m_SaveQuads) ? 1 : 0;
}

void CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_MakeQuads()
{
  UpdateData(TRUE);
  makeQuads_Flag = (m_MakeQuads) ? 1 : 0;
}

void CMSVC_Test_At3dx_Read_WriteDlg::OnBnClicked_ReadWriteFile()
{
  Read_Write_3D_File();
}

void CMSVC_Test_At3dx_Read_WriteDlg::Read_Write_3D_File(void)
{
  // start the DLL
  //
  int dllOpen = At3d_Start();

  if (!dllOpen) return;

  // View window will not be used so do not draw to it
  //
  At3d_WriteFlag(LIBFLAG_NO_DRAW, 1);

  // Read OBJ file
  //
  char path[_MAX_PATH];
  char drive0[_MAX_DRIVE];
	char dir0[_MAX_DIR];
	char name0[_MAX_FNAME];
	char ext0[_MAX_EXT];

  if (inName[0] != 0)
  {
    my_splitpath(inName, drive0, _MAX_DRIVE, dir0, _MAX_DIR, name0, _MAX_FNAME,
                 ext0, _MAX_EXT);

    my_strcpy(path, _MAX_PATH, drive0);
    my_strcat(path, _MAX_PATH, dir0);

    my_strcat(name0, _MAX_FNAME, ext0);
  }
  else
  {
    path[0]  = '\0';
    name0[0] = '\0';
  }

  CString filter = "Wavefront";
  filter += "|*";
  filter += ".obj";
  filter += "|All|*.*|";

  CFileDialog dlg(TRUE, NULL, inName,
					OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST,
					filter, 0);

  int fileLoaded = 0;

	if( dlg.DoModal() == IDOK )
  {
    my_strcpy(inName, MAX_PATH, (char*)LPCTSTR(dlg.GetPathName()));
    
    // before reading make sure flags are set properly
    // (note: flags maintain their setting until changed with this function)
    //
    At3d_WriteFlag(LIBFLAG_REMOVE_DUPLICATE_VERTICES, 1);
    At3d_WriteFlag(LIBFLAG_REMOVE_DUPLICATE_FACES, 1);
    At3d_WriteFlag(LIBFLAG_SHOW_READ_MESSAGES, 0);

    // read file
    //
    fileLoaded = At3d_Read(INTYPE_WAVEFRONT, inName, 1.0);
  }

  // Write LXO file
  //
  if (fileLoaded)
  {
    my_splitpath(inName, drive0, _MAX_DRIVE, dir0, _MAX_DIR, name0, _MAX_FNAME,
                 ext0, _MAX_EXT);

    char outName[MAX_PATH];

    my_makepath(outName, MAX_PATH, drive0, dir0,  name0, ".lxo");

    UpdateData(TRUE);

    At3d_WriteFlag(LIBFLAG_SAVE_2D, save2D_Flag);

    At3d_WriteFlag(LIBFLAG_UV_OUTPUT, saveUV_Flag);

    At3d_WriteFlag(LIBFLAG_USE_QUADFACE, saveQuads_Flag);

    if ((saveQuads_Flag) && (makeQuads_Flag))
    {
      angleBetweenNormals = atof(m_AngleBetweenNormals);      
      angleBetweenEdges   = atof(m_AngleBetweenEdges);
      
      At3d_SetTriQuadAngle(angleBetweenNormals);
      At3d_SetTriQuadEdgeAngle(angleBetweenEdges);
      At3d_MakeQuads();
    }

    At3d_Write(OUTTYPE_MODO, outName, 1.0);
  }

  // free all memory used by the DLL
  //
  At3d_Stop();
}
