// MSVC_Test_At3dx_LoadLibraryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MSVC_Test_At3dx_LoadLibrary.h"
#include "MSVC_Test_At3dx_LoadLibraryDlg.h"
#include "..\at3dx_my_functions.h"
#include "..\at3ddll.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMSVC_Test_At3dx_LoadLibraryDlg dialog

CMSVC_Test_At3dx_LoadLibraryDlg::CMSVC_Test_At3dx_LoadLibraryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMSVC_Test_At3dx_LoadLibraryDlg::IDD, pParent)
  , m_UseOpenGL(FALSE)
  , m_LibraryLabel(_T(""))
  , m_DllLabel(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

  at3dLibHandle = 0;
  dllOpen       = 0;
  fileLoaded    = 0;

  memset(inName, 0, sizeof(char) * MAX_PATH);

  // Use OpenGL view window
  //
  useOglFlag = 1;
}

void CMSVC_Test_At3dx_LoadLibraryDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Check(pDX, IDC_USE_OPENGL, m_UseOpenGL);
  DDX_Text(pDX, IDC_LIBRARY_LABEL, m_LibraryLabel);
  DDX_Text(pDX, IDC_DLL_LABEL, m_DllLabel);
}

BEGIN_MESSAGE_MAP(CMSVC_Test_At3dx_LoadLibraryDlg, CDialog)
  ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
  ON_BN_CLICKED(IDC_DO_LOAD_LIBRARY, &CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_DoLoadLibrary)
  ON_BN_CLICKED(IDC_DO_FREE_LIBRARY, &CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_DoFreeLibrary)
  ON_BN_CLICKED(IDC_DO_START_DLL, &CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_DoStartDll)
  ON_BN_CLICKED(IDC_DO_STOP_DLL, &CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_DoStopDll)
  ON_BN_CLICKED(IDC_READ_OBJ_FILE, &CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_ReadObjFile)
  ON_BN_CLICKED(IDC_USE_OPENGL, &CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_UseOpengl)
END_MESSAGE_MAP()


// CMSVC_Test_At3dx_LoadLibraryDlg message handlers

BOOL CMSVC_Test_At3dx_LoadLibraryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

  Update_Labels();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMSVC_Test_At3dx_LoadLibraryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// free all memory used by the DLL
	//
	Stop_Library();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMSVC_Test_At3dx_LoadLibraryDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMSVC_Test_At3dx_LoadLibraryDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CMSVC_Test_At3dx_LoadLibraryDlg::Update_Labels(void)
{
  if (at3dLibHandle)
  {
    m_LibraryLabel = "Library Loaded.";
  }
  else
  {
    m_LibraryLabel = "Library NOT Loaded.";
  }

  if (dllOpen)
  {
    m_DllLabel = "DLL Running.";
  }
  else
  {
    m_DllLabel = "DLL Stopped.";
  }

  UpdateData(FALSE);
}

void CMSVC_Test_At3dx_LoadLibraryDlg::Start_Library(void)
{
  if (!at3dLibHandle) at3dLibHandle = LoadLibrary("at3dx.dll");
}

void CMSVC_Test_At3dx_LoadLibraryDlg::Stop_Library(void)
{
  if (at3dLibHandle)
  {
    if (dllOpen) Stop_DLL();

    if (FreeLibrary(at3dLibHandle) != 0) at3dLibHandle = 0;
  }
}

void CMSVC_Test_At3dx_LoadLibraryDlg::Start_DLL(void)
{
  if ((at3dLibHandle) && (!dllOpen))
  {
    dllOpen = At3d_Start();

    if (dllOpen)
    {
      int errorFlag = 0;

      // To detect mouse scroll wheel messages the DLL has to know the
      // handle to the main window of the application which
      // receives all the messages from the Windows Operating System
      //
      At3d_SetAppHandle(GetSafeHwnd());

      // Set size of DLL window
      //
      At3d_Size(600, 500);

      // Set position of DLL window
      //
      At3d_Position(2, 2);

      // Make DLL window a child of a window in the application
      //
      At3d_SetParent(GetSafeHwnd());

      // If the DLL window does not have a parent
      // At3d_SetParent(0);
      // a button will appear on the Windows Taskbar
      // use this function to set the name that will appear
      //
      At3d_SetCaption("DLL (at3d)");

      // Use the OpenGL view window
      //
      m_UseOpenGL = (useOglFlag) ? TRUE : FALSE;
      At3d_WriteFlag(LIBFLAG_USE_OPENGL, useOglFlag);

      // Light both sides of the polygons
      //
      At3d_WriteFlag(LIBFLAG_OGL_2SIDED_LIGHTING, 1);

      // Cull back faces of polygons
      //
      At3d_WriteFlag(LIBFLAG_OGL_CULL_BACKFACES,1);

      // Make DLL window visible
      //
      At3d_Show();

      if (errorFlag) Stop_DLL();

      UpdateData(FALSE);
    }
  }
}

void CMSVC_Test_At3dx_LoadLibraryDlg::Stop_DLL(void)
{
  if ((at3dLibHandle) && (dllOpen))
  {
    // free all memory used by the DLL
	  //
    At3d_Stop();
    dllOpen = 0;
  }
}

void CMSVC_Test_At3dx_LoadLibraryDlg::Read_3D_File(void)
{
  if (!dllOpen) return;

  char path[_MAX_PATH];
  char drive0[_MAX_DRIVE];
	char dir0[_MAX_DIR];
	char name0[_MAX_FNAME];
	char ext0[_MAX_EXT];
  
  if (inName[0] != 0)
  {
    my_splitpath(inName, drive0, _MAX_DRIVE, dir0, _MAX_DIR, name0, _MAX_FNAME,
                 ext0, _MAX_EXT);

    my_strcpy(path, _MAX_PATH, drive0);
    my_strcat(path, _MAX_PATH, dir0);

    my_strcat(name0, _MAX_FNAME, ext0);
  }
  else
  {
    path[0]  = '\0';
    name0[0] = '\0';
  }

  CString filter = "Wavefront";
  filter += "|*";
  filter += ".obj";
  filter += "|All|*.*|";

  CFileDialog dlg(TRUE, NULL, inName,
					OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST,
					filter, 0);

	if( dlg.DoModal() == IDOK )
  {
		my_strcpy(inName, MAX_PATH, (char*)LPCTSTR(dlg.GetPathName()));

    // before reading make sure flags are set properly
    // (note: flags maintain their setting until changed with this function)
    //
    At3d_WriteFlag(LIBFLAG_REMOVE_DUPLICATE_VERTICES, 1);
    At3d_WriteFlag(LIBFLAG_REMOVE_DUPLICATE_FACES, 1);
    At3d_WriteFlag(LIBFLAG_SHOW_READ_MESSAGES, 0);

    // read file
    //
    fileLoaded = At3d_Read(INTYPE_WAVEFRONT, inName, 1.0);
  }
}
void CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_DoLoadLibrary()
{
  Start_Library();
  Update_Labels();
}

void CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_DoFreeLibrary()
{  
  Stop_Library();
  Update_Labels();
}

void CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_DoStartDll()
{
  Start_DLL();
  Update_Labels();
}

void CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_DoStopDll()
{
  Stop_DLL();
  Update_Labels();
}

void CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_ReadObjFile()
{
  Read_3D_File();
}

void CMSVC_Test_At3dx_LoadLibraryDlg::OnBnClicked_UseOpengl()
{
  if (!dllOpen) return;

  UpdateData(TRUE);
  useOglFlag = (m_UseOpenGL) ? 1 : 0;

  At3d_WriteFlag(LIBFLAG_USE_OPENGL, useOglFlag);
}
