//----------------------------------------------------------------------------
//  Project Test_At3dx_Lights
//  MicroMouse Productions
//  Copyright  2011-2012. All Rights Reserved.
//  Author: Wayne Hogue
//
//----------------------------------------------------------------------------

// MSVC_Test_At3dx_LightsDlg.h : header file
//

#pragma once


// CMSVC_Test_At3dx_LightsDlg dialog
class CMSVC_Test_At3dx_LightsDlg : public CDialog
{
// Construction
public:
	CMSVC_Test_At3dx_LightsDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_MSVC_TEST_AT3DX_LIGHTS_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

  void Start_DLL(void);
  void Stop_DLL(void);
  void Read_3D_File(void);
  void SetLight0(void);
  void SetLight1(void);

  int dllOpen;
  int fileLoaded;
  char inName[MAX_PATH];
  int inputFileType;
  int useTexturesFlag;
  int oglReplaceFlag;
  int useWhiteBaseFlag;
  int reversePanFlag;
  int reverseZoomFlag;
  int alwaysShowCameraCursorFlag;

	// Generated message map functions
	virtual BOOL OnInitDialog();
  afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
  int m_InputFileType_Group;
  BOOL m_Light0;
  BOOL m_Light1;
  BOOL m_UseTextures;
  BOOL m_UseOglReplace;
  BOOL m_UseWhiteBase;
  BOOL m_AlwaysShowCameraCursor;
  BOOL m_ReversePan;
  BOOL m_ReverseZoom;
  afx_msg void OnBnClicked_DoStartDll();
  afx_msg void OnBnClicked_DoStopDll();
  afx_msg void OnBnClicked_TypeKmz();
  afx_msg void OnBnClicked_TypeObj();
  afx_msg void OnBnClicked_Read3dFile();
  afx_msg void OnBnClicked_Light0();
  afx_msg void OnBnClicked_Light1();
  afx_msg void OnBnClicked_UseTextures();
  afx_msg void OnBnClicked_UseOglReplace();
  afx_msg void OnBnClicked_UseWhiteBase();
  afx_msg void OnBnClicked_AlwaysShowCameraCursor();
  afx_msg void OnBnClicked_ReversePan();
  afx_msg void OnBnClicked_ReverseZoom();
};
