// WritePage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "WritePage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWritePage property page

IMPLEMENT_DYNCREATE(CWritePage, CPropertyPage)

CWritePage::CWritePage() : CPropertyPage(CWritePage::IDD)
, m_OutputHierarchy(FALSE)
, m_ColladaUpAxis_Group(0)
, m_AlwaysWriteColladaTransparency(FALSE)
, m_MayaVersion(_T(""))
, m_DirectxFramePrefix(_T(""))
, m_DirectxMaterialPrefix(_T(""))
, m_UseDirectxFramePrefix(FALSE)
, m_UseDirectxMaterialPrefix(FALSE)
, m_NewEmbeddedName(_T(""))
{
	//{{AFX_DATA_INIT(CWritePage)
	m_OutputQuads = FALSE;
	m_OutputUV = FALSE;
	m_OutputVNormals = FALSE;
	m_Save2DLines = FALSE;
	m_ShowSaveMessages = FALSE;
	m_SaveTexturePath = FALSE;
	m_SavePointClouds = FALSE;
	m_3DMF_Group = -1;
	m_Pixel_Group = -1;
	m_AutoDivideLayers = FALSE;
	m_DemAboveFactor = _T("");
	m_DemBelowFactor = _T("");
	m_DemSeaLevel_Group = -1;
	m_OutputVColors = FALSE;
	m_MultiMaterial = FALSE;
	m_RelocateTextures = FALSE;
	m_OutputAvatar = FALSE;
	m_PartialTexturePath = FALSE;
	m_NoIndent = FALSE;
	m_OneLayerPerFile = FALSE;
	m_TextAsText = FALSE;
	m_SaveTexturePath = FALSE;
	m_ModoCameraSunlight = FALSE;
	m_ModoHierarchy = FALSE;
	m_ModoWithJoints = FALSE;
	//}}AFX_DATA_INIT
}

CWritePage::~CWritePage()
{
}

void CWritePage::DoDataExchange(CDataExchange* pDX)
{
  CPropertyPage::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CWritePage)
  DDX_Control(pDX, IDC_OUTCOMBO, m_OutCombo);
  DDX_Check(pDX, IDC_OUTPUTQUADS, m_OutputQuads);
  DDX_Check(pDX, IDC_OUTPUTUV, m_OutputUV);
  DDX_Check(pDX, IDC_VNORMALS, m_OutputVNormals);
  DDX_Check(pDX, IDC_SAVE2DLINES, m_Save2DLines);
  DDX_Check(pDX, IDC_SHOWSAVEMESSAGES, m_ShowSaveMessages);
  DDX_Check(pDX, IDC_SAVETEXTUREPATH, m_SaveTexturePath);
  DDX_Check(pDX, IDC_SAVEPOINTCLOUDS, m_SavePointClouds);
  DDX_Radio(pDX, IDC_MESH3DMF, m_3DMF_Group);
  DDX_Radio(pDX, IDC_3DMFPIXEL16, m_Pixel_Group);
  DDX_Check(pDX, IDC_AUTODIVIDELAYERS, m_AutoDivideLayers);
  DDX_Text(pDX, IDC_DEMABOVEFACTOR, m_DemAboveFactor);
  DDX_Text(pDX, IDC_DEMBELOWFACTOR, m_DemBelowFactor);
  DDX_Radio(pDX, IDC_DEMSEALEVEL0, m_DemSeaLevel_Group);
  DDX_Check(pDX, IDC_VCOLORS, m_OutputVColors);
  DDX_Check(pDX, IDC_MULTIMATERIAL, m_MultiMaterial);
  DDX_Check(pDX, IDC_RELOCATE_TEXTURES, m_RelocateTextures);
  DDX_Check(pDX, IDC_OUTPUTAVATAR, m_OutputAvatar);
  DDX_Check(pDX, IDC_PARTIALTEXTUREPATH, m_PartialTexturePath);
  DDX_Check(pDX, IDC_NOINDENT, m_NoIndent);
  DDX_Check(pDX, IDC_ONELAYERPERFILE, m_OneLayerPerFile);
  DDX_Check(pDX, IDC_TEXTASTEXT, m_TextAsText);
  DDX_Check(pDX, IDC_MODOCAMERASUNLIGHT, m_ModoCameraSunlight);
  DDX_Check(pDX, IDC_MODOHIERARCHY, m_ModoHierarchy);
  DDX_Check(pDX, IDC_MODOWITHJOINTS, m_ModoWithJoints);
  //}}AFX_DATA_MAP
  DDX_Check(pDX, IDC_OUTPUTHIERARCHY, m_OutputHierarchy);
  DDX_Radio(pDX, IDC_COLLADAUPAXISX, m_ColladaUpAxis_Group);
  DDV_MinMaxInt(pDX, m_ColladaUpAxis_Group, 0, 2);
  DDX_Check(pDX, IDC_ALWAYSWRITECOLLADATRANSPARENCY, m_AlwaysWriteColladaTransparency);
  DDX_Text(pDX, IDC_MAYAVERSION, m_MayaVersion);
  DDX_Text(pDX, IDC_DIRECTXFRAMEPREFIX, m_DirectxFramePrefix);
  DDX_Text(pDX, IDC_DIRECTXMATERIALPREFIX, m_DirectxMaterialPrefix);
  DDX_Check(pDX, IDC_USEDIRECTXFRAMEPREFIX, m_UseDirectxFramePrefix);
  DDX_Check(pDX, IDC_USEDIRECTXMATERIALPREFIX, m_UseDirectxMaterialPrefix);
  DDX_Text(pDX, IDC_NEW_EMBEDDED_NAME, m_NewEmbeddedName);
}


BEGIN_MESSAGE_MAP(CWritePage, CPropertyPage)
	//{{AFX_MSG_MAP(CWritePage)
	ON_BN_CLICKED(IDC_OUTPUTQUADS, OnOutputquads)
	ON_BN_CLICKED(IDC_OUTPUTUV, OnOutputuv)
	ON_BN_CLICKED(IDC_WRITE, OnWrite)
	ON_BN_CLICKED(IDC_BUFFERWRITE, OnBufferwrite)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_DELETELAYER, OnDeletelayer)
	ON_BN_CLICKED(IDC_MERGEVERTICES, OnMergevertices)
	ON_BN_CLICKED(IDC_MERGEOBJECTS, OnMergeobjects)
	ON_BN_CLICKED(IDC_VNORMALS, OnVnormals)
	ON_CBN_SELCHANGE(IDC_OUTCOMBO, OnSelchangeOutcombo)
	ON_BN_CLICKED(IDC_SAVE2DLINES, OnSave2dlines)
	ON_BN_CLICKED(IDC_SHOWSAVEMESSAGES, OnShowsavemessages)
	ON_BN_CLICKED(IDC_SAVETEXTUREPATH, OnSavetexturepath)
	ON_BN_CLICKED(IDC_SAVEPOINTCLOUDS, OnSavepointclouds)
	ON_BN_CLICKED(IDC_MERGEMATERIALS, OnMergematerials)
	ON_BN_CLICKED(IDC_MESH3DMF, OnMesh3dmf)
	ON_BN_CLICKED(IDC_TRIMESH3DMF, OnTrimesh3dmf)
	ON_BN_CLICKED(IDC_TRIANGLE3DMF, OnTriangle3dmf)
	ON_BN_CLICKED(IDC_QUAD3DMF, OnQuad3dmf)
	ON_BN_CLICKED(IDC_3DMFPIXEL16, On3dmfpixel16)
	ON_BN_CLICKED(IDC_3DMFPIXEL24, On3dmfpixel24)
	ON_BN_CLICKED(IDC_3DMFPIXEL32, On3dmfpixel32)
	ON_BN_CLICKED(IDC_AUTODIVIDELAYERS, OnAutodividelayers)
	ON_BN_CLICKED(IDC_DEMSEALEVEL0, OnDemsealevel0)
	ON_BN_CLICKED(IDC_DEMSEALEVEL1, OnDemsealevel1)
	ON_BN_CLICKED(IDC_DEMSEALEVEL2, OnDemsealevel2)
	ON_BN_CLICKED(IDC_WRITEDEMCONTOURMAP, OnWritedemcontourmap)
	ON_BN_CLICKED(IDC_VCOLORS, OnVcolors)
	ON_BN_CLICKED(IDC_MULTIMATERIAL, OnMultimaterial)
	ON_BN_CLICKED(IDC_RELOCATE_TEXTURES, OnRelocateTextures)
	ON_BN_CLICKED(IDC_OUTPUTAVATAR, OnOutputavatar)
	ON_BN_CLICKED(IDC_PARTIALTEXTUREPATH, OnPartialtexturepath)
	ON_BN_CLICKED(IDC_NOINDENT, OnNoindent)
	ON_BN_CLICKED(IDC_ONELAYERPERFILE, OnOnelayerperfile)
	ON_BN_CLICKED(IDC_TEXTASTEXT, OnTextastext)
	ON_BN_CLICKED(IDC_MODOCAMERASUNLIGHT, OnModocamerasunlight)
	ON_BN_CLICKED(IDC_MODOHIERARCHY, OnModohierarchy)
	ON_BN_CLICKED(IDC_MODOWITHJOINTS, OnModowithjoints)
	ON_BN_CLICKED(IDC_CONVERT3DTO2D, OnConvert3dto2d)
	//}}AFX_MSG_MAP
  ON_BN_CLICKED(IDC_OUTPUTHIERARCHY, &CWritePage::OnBnClickedOutputhierarchy)
  ON_BN_CLICKED(IDC_SETWHITEFORUVLAYERS, &CWritePage::OnBnClickedSetwhiteforuvlayers)
  ON_BN_CLICKED(IDC_COLLADAUPAXISX, &CWritePage::OnBnClickedColladaupaxisx)
  ON_BN_CLICKED(IDC_COLLADAUPAXISY, &CWritePage::OnBnClickedColladaupaxisy)
  ON_BN_CLICKED(IDC_COLLADAUPAXISZ, &CWritePage::OnBnClickedColladaupaxisz)
  ON_BN_CLICKED(IDC_ALWAYSWRITECOLLADATRANSPARENCY, &CWritePage::OnBnClickedAlwayswritecolladatransparency)
  ON_BN_CLICKED(IDC_SETMAYAVERSION, &CWritePage::OnBnClickedSetmayaversion)
  ON_BN_CLICKED(IDC_USEDIRECTXFRAMEPREFIX, &CWritePage::OnBnClickedUsedirectxframeprefix)
  ON_BN_CLICKED(IDC_SETDIRECTXFRAMEPREFIX, &CWritePage::OnBnClickedSetdirectxframeprefix)
  ON_BN_CLICKED(IDC_USEDIRECTXMATERIALPREFIX, &CWritePage::OnBnClickedUsedirectxmaterialprefix)
  ON_BN_CLICKED(IDC_SETDIRECTXMATERIALPREFIX, &CWritePage::OnBnClickedSetdirectxmaterialprefix)
  ON_BN_CLICKED(IDC_RENAME_EMBEDDED_TEXTURES, &CWritePage::OnBnClicked_RenameEmbeddedTextures)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWritePage message handlers

BOOL CWritePage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	//
	m_OutputAvatar = (at3dData->outputAvatarFlag) ? TRUE : FALSE;
  m_OutputHierarchy = (at3dData->outputHierarchyFlag) ? TRUE : FALSE;
	m_OneLayerPerFile = (at3dData->oneLayerPerFileFlag) ? TRUE : FALSE;
	m_MultiMaterial = (at3dData->multiMaterialFlag) ? TRUE : FALSE;
	m_OutputQuads = (at3dData->quadFlag) ? TRUE : FALSE;
	m_OutputUV = (at3dData->uvFlag) ? TRUE : FALSE;
	m_OutputVNormals = (at3dData->vnormFlag) ? TRUE : FALSE;
	m_OutputVColors = (at3dData->vcolorFlag) ? TRUE : FALSE;
	m_Save2DLines = (at3dData->save2DFlag) ? TRUE : FALSE;
	m_SavePointClouds = (at3dData->savePointCloudFlag) ? TRUE : FALSE;
	m_AutoDivideLayers = (at3dData->autoDivideLayersFlag) ? TRUE : FALSE;
	for (int i=0; i<at3dData->outCount; i++)
	{
		m_OutCombo.AddString(at3dData->outLabel[i]);
	}
	m_OutCombo.SetCurSel(at3dData->outIndex);

	m_RelocateTextures = at3dData->relocateTexturesFlag;

	m_SaveTexturePath = at3dData->saveTexturePathFlag;
	At3d_WriteFlag(LIBFLAG_SAVE_TEXTUREPATH, at3dData->saveTexturePathFlag);

	m_PartialTexturePath = at3dData->partialTexturePathFlag;
	At3d_WriteFlag(LIBFLAG_PARTIAL_TEXTUREPATH, at3dData->partialTexturePathFlag);

	m_NoIndent = at3dData->noIndentFlag;
	At3d_WriteFlag(LIBFLAG_NOINDENT_OUT, at3dData->noIndentFlag);

	m_TextAsText = at3dData->textAsTextFlag;
  At3d_WriteFlag(LIBFLAG_WRITE_TEXT_AS_TEXT, at3dData->textAsTextFlag);

	m_3DMF_Group = at3dData->outType3dmf;
	m_Pixel_Group = at3dData->pixelFlag3dmf;
	m_DemSeaLevel_Group = at3dData->demSeaLevelFlag;

	m_DemBelowFactor.Format("%f", at3dData->demBelowFactor);
	m_DemAboveFactor.Format("%f", at3dData->demAboveFactor);

	m_ModoCameraSunlight = (at3dData->modoCameraSunlightFlag) ? TRUE : FALSE;
  m_ModoHierarchy = (at3dData->modoHierarchyFlag) ? TRUE : FALSE;
  m_ModoWithJoints = (at3dData->modoWithJointsFlag) ? TRUE : FALSE;

  m_ColladaUpAxis_Group = at3dData->colladaOutputUpAxisFlag;

  m_AlwaysWriteColladaTransparency = (at3dData->alwaysWriteColladaTransparencyFlag) ? TRUE : FALSE;

  m_MayaVersion = at3dData->mayaVersion;

  m_DirectxFramePrefix    = at3dData->directxFramePrefix;
  m_DirectxMaterialPrefix = at3dData->directxMaterialPrefix;

  m_UseDirectxFramePrefix    = (at3dData->useDirectxFramePrefixFlag) ? TRUE : FALSE;
  m_UseDirectxMaterialPrefix = (at3dData->useDirectxMaterialPrefixFlag) ? TRUE : FALSE;

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CWritePage::OnOutputquads() 
{
	UpdateData(TRUE);
	at3dData->quadFlag = (m_OutputQuads) ? 1 : 0;
}

void CWritePage::OnOutputuv() 
{
	UpdateData(TRUE);
	at3dData->uvFlag = (m_OutputUV) ? 1 : 0;
}

void CWritePage::OnVnormals() 
{
	UpdateData(TRUE);
	at3dData->vnormFlag = (m_OutputVNormals) ? 1 : 0;
}

void CWritePage::OnSave2dlines() 
{
	UpdateData(TRUE);
	at3dData->save2DFlag = (m_Save2DLines) ? 1 : 0;
}

void CWritePage::OnWrite() 
{
	at3dData->WriteFile();
}

void CWritePage::OnBufferwrite() 
{
	at3dData->bufferWriteFlag = 1;
  at3dData->WriteFile();
}

void CWritePage::OnClear() 
{
	at3dData->Clear_All_Objects();
}

void CWritePage::OnDeletelayer() 
{
	at3dData->DeleteLayer();
}

void CWritePage::OnMergevertices() 
{
	at3dData->MergeVertices();
}

void CWritePage::OnMergeobjects() 
{
	At3d_MergeObjects(1);
}

void CWritePage::OnSelchangeOutcombo() 
{
	if (m_OutCombo.GetCurSel() != CB_ERR)
	{
		at3dData->outIndex = m_OutCombo.GetCurSel();
	}
}

void CWritePage::OnShowsavemessages() 
{
	UpdateData(TRUE);
	at3dData->showSaveMessagesFlag = (m_ShowSaveMessages) ? 1 : 0;
}

void CWritePage::OnSavetexturepath() 
{
	UpdateData(TRUE);
	at3dData->saveTexturePathFlag = (m_SaveTexturePath) ? 1 : 0;
	At3d_WriteFlag(LIBFLAG_SAVE_TEXTUREPATH, at3dData->saveTexturePathFlag);
}

void CWritePage::OnSavepointclouds() 
{
	UpdateData(TRUE);
	at3dData->savePointCloudFlag = (m_SavePointClouds) ? 1 : 0;
}

void CWritePage::OnMergematerials() 
{
	At3d_MergeObjects(2);
}

void CWritePage::OnMesh3dmf() 
{
	at3dData->outType3dmf = SAVE_3DMF_MESH;
}

void CWritePage::OnTrimesh3dmf() 
{
	at3dData->outType3dmf = SAVE_3DMF_TRIMESH;
}

void CWritePage::OnTriangle3dmf() 
{
	at3dData->outType3dmf = SAVE_3DMF_TRIANGLE;
}

void CWritePage::OnQuad3dmf() 
{
	at3dData->outType3dmf = SAVE_3DMF_QUAD; 
}

void CWritePage::On3dmfpixel16() 
{
	at3dData->pixelFlag3dmf = PIXEL_3DMF_16;
}

void CWritePage::On3dmfpixel24() 
{
	at3dData->pixelFlag3dmf = PIXEL_3DMF_24;
}

void CWritePage::On3dmfpixel32() 
{
	at3dData->pixelFlag3dmf = PIXEL_3DMF_32;
}

void CWritePage::OnAutodividelayers() 
{
	UpdateData(TRUE);
	at3dData->autoDivideLayersFlag = (m_AutoDivideLayers) ? 1 : 0;
	At3d_WriteFlag(LIBFLAG_DIVIDE_LAYER_SAVE, at3dData->autoDivideLayersFlag);
}

void CWritePage::OnDemsealevel0() 
{
	at3dData->demSeaLevelFlag = 0;
}

void CWritePage::OnDemsealevel1() 
{
	at3dData->demSeaLevelFlag = 1;
}

void CWritePage::OnDemsealevel2() 
{
	at3dData->demSeaLevelFlag = 2;
}

void CWritePage::OnWritedemcontourmap() 
{
	UpdateData(TRUE);
	at3dData->demBelowFactor = (float)atof(m_DemBelowFactor);
	at3dData->demAboveFactor = (float)atof(m_DemAboveFactor);

	at3dData->WriteDemContourMap();
}

void CWritePage::OnVcolors() 
{
	UpdateData(TRUE);
	at3dData->vcolorFlag = (m_OutputVColors) ? 1 : 0;
}

void CWritePage::OnMultimaterial() 
{
	UpdateData(TRUE);
	at3dData->multiMaterialFlag = (m_MultiMaterial) ? 1 : 0;
}

void CWritePage::OnRelocateTextures() 
{
	UpdateData(TRUE);
	at3dData->relocateTexturesFlag = (m_RelocateTextures) ? 1 : 0;
}

void CWritePage::OnOutputavatar() 
{
	UpdateData(TRUE);
	at3dData->outputAvatarFlag = (m_OutputAvatar) ? 1 : 0;
}

void CWritePage::OnPartialtexturepath() 
{
	UpdateData(TRUE);
	at3dData->partialTexturePathFlag = (m_PartialTexturePath) ? 1 : 0;
	At3d_WriteFlag(LIBFLAG_PARTIAL_TEXTUREPATH, at3dData->partialTexturePathFlag);
}

void CWritePage::OnNoindent() 
{
	UpdateData(TRUE);
	at3dData->noIndentFlag = (m_NoIndent) ? 1 : 0;
	At3d_WriteFlag(LIBFLAG_NOINDENT_OUT, at3dData->noIndentFlag);
}

void CWritePage::OnOnelayerperfile() 
{
	UpdateData(TRUE);
	at3dData->oneLayerPerFileFlag = (m_OneLayerPerFile) ? 1 : 0;
}

void CWritePage::OnTextastext() 
{
	UpdateData(TRUE);
	at3dData->textAsTextFlag = (m_TextAsText) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_WRITE_TEXT_AS_TEXT, at3dData->textAsTextFlag);
}

void CWritePage::OnModocamerasunlight() 
{
	UpdateData(TRUE);
	at3dData->modoCameraSunlightFlag = (m_ModoCameraSunlight) ? 1 : 0;
}

void CWritePage::OnModohierarchy() 
{
	UpdateData(TRUE);
	at3dData->modoHierarchyFlag = (m_ModoHierarchy) ? 1 : 0;
}

void CWritePage::OnModowithjoints() 
{
	UpdateData(TRUE);
	at3dData->modoWithJointsFlag = (m_ModoWithJoints) ? 1 : 0;   
}

void CWritePage::OnConvert3dto2d() 
{
	At3d_Convert_3D_To_2D();  
}

void CWritePage::OnBnClickedOutputhierarchy()
{
  UpdateData(TRUE);
	at3dData->outputHierarchyFlag = (m_OutputHierarchy) ? 1 : 0;
}

void CWritePage::OnBnClickedSetwhiteforuvlayers()
{
  At3d_Set_White_For_UV_Layers();
}

void CWritePage::OnBnClickedColladaupaxisx()
{
  at3dData->colladaOutputUpAxisFlag = COLLADA_UP_AXIS_X;
}

void CWritePage::OnBnClickedColladaupaxisy()
{
  at3dData->colladaOutputUpAxisFlag = COLLADA_UP_AXIS_Y;
}

void CWritePage::OnBnClickedColladaupaxisz()
{
  at3dData->colladaOutputUpAxisFlag = COLLADA_UP_AXIS_Z;
}

void CWritePage::OnBnClickedAlwayswritecolladatransparency()
{
  UpdateData(TRUE);
  at3dData->alwaysWriteColladaTransparencyFlag = (m_AlwaysWriteColladaTransparency) ? 1 : 0;
}

void CWritePage::OnBnClickedSetmayaversion()
{
  UpdateData(TRUE);
	
	if (m_MayaVersion.IsEmpty())
  {
    at3dData->mayaVersion = _T("");
  }
  else
  {
    at3dData->mayaVersion = m_MayaVersion;
  }
	
	At3d_Set_Maya_Version((char*)LPCTSTR(at3dData->mayaVersion));
}

void CWritePage::OnBnClickedUsedirectxframeprefix()
{
  UpdateData(TRUE);

	at3dData->useDirectxFramePrefixFlag = (m_UseDirectxFramePrefix) ? 1 : 0;

  OnBnClickedSetdirectxframeprefix();	
}

void CWritePage::OnBnClickedSetdirectxframeprefix()
{
  UpdateData(TRUE);
	
	if (m_DirectxFramePrefix.IsEmpty())
  {
    at3dData->directxFramePrefix = _T("");
  }
  else
  {
    at3dData->directxFramePrefix = m_DirectxFramePrefix;
  }

  At3d_Set_DirectX_Frame_Prefix(at3dData->useDirectxFramePrefixFlag,
                                (char*)LPCTSTR(at3dData->directxFramePrefix));
}

void CWritePage::OnBnClickedUsedirectxmaterialprefix()
{
  UpdateData(TRUE);

	at3dData->useDirectxMaterialPrefixFlag = (m_UseDirectxMaterialPrefix) ? 1 : 0;

  OnBnClickedSetdirectxmaterialprefix();
}

void CWritePage::OnBnClickedSetdirectxmaterialprefix()
{
  UpdateData(TRUE);
	
	if (m_DirectxMaterialPrefix.IsEmpty())
  {
    at3dData->directxMaterialPrefix = _T("");
  }
  else
  {
    at3dData->directxMaterialPrefix = m_DirectxMaterialPrefix;
  }

  At3d_Set_DirectX_Material_Prefix(at3dData->useDirectxMaterialPrefixFlag,
                                   (char*)LPCTSTR(at3dData->directxMaterialPrefix));
}

void CWritePage::OnBnClicked_RenameEmbeddedTextures()
{
  UpdateData(TRUE);
	
  CString newName;

	if (m_NewEmbeddedName.IsEmpty())
  {
    newName = _T("");
  }
  else
  {
    newName = m_NewEmbeddedName;
  }
	
	At3d_Rename_Embedded_Textures((char*)LPCTSTR(newName));
}
