// ViewPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "ViewPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CViewPage property page

IMPLEMENT_DYNCREATE(CViewPage, CPropertyPage)

CViewPage::CViewPage() : CPropertyPage(CViewPage::IDD)
{
	//{{AFX_DATA_INIT(CViewPage)
	m_HiddenWireframe = FALSE;
	m_UseOpenGL = FALSE;
	m_UseWhiteBase = FALSE;
	m_OglReplace = FALSE;
	m_DisplayTextures = FALSE;
	m_CullBackFaces = FALSE;
	m_TwoSidedLighting = FALSE;
	m_CameraStepAngle = _T("");
	m_CameraStepPan = _T("");
	m_CameraXAngle = _T("");
	m_CameraXPan = _T("");
	m_CameraYAngle = _T("");
	m_CameraZAngle = _T("");
	m_CameraZPan = _T("");
	m_TriQuadNormalAngle = _T("");
	m_TriQuadEdgeAngle = _T("");
	m_DefaultTexture = FALSE;
	m_UseFilmstrip = FALSE;
	m_FilmstripTimer = FALSE;
	m_CameraXViewPoint = _T("");
	m_CameraYViewPoint = _T("");
	m_CameraZViewPoint = _T("");
	m_CameraRotateSpeed = _T("");
	m_CameraInitialDistance = _T("");
	m_CameraDistance = _T("");
	m_CameraZoomSpeed = _T("");
	m_CameraFieldOfView = _T("");
	m_CameraStepFOV = _T("");
	m_StageGridSpacing = _T("");
	m_StageWidth = _T("");
	m_StageDepth = _T("");
	m_StageOriginX = _T("");
	m_StageOriginY = _T("");
	m_StageUseOrigin = FALSE;
	m_StageUseSquares = FALSE;
	m_StageUseTexture = FALSE;
	m_DisplayStage = FALSE;
	m_ReverseZoomDirection = FALSE;
	m_ReversePanDirection = FALSE;
	//}}AFX_DATA_INIT

	if ( (!FrontButton.LoadBitmaps("FRONTU", "FRONTD", 0, 0)) ||
		 (!BackButton.LoadBitmaps("BACKU", "BACKD", 0, 0)) ||
		 (!RightButton.LoadBitmaps("RIGHTU", "RIGHTD", 0, 0)) ||
		 (!LeftButton.LoadBitmaps("LEFTU", "LEFTD", 0, 0)) ||
		 (!TopButton.LoadBitmaps("TOPU", "TOPD", 0, 0)) ||		 
		 (!BottomButton.LoadBitmaps("BOTTOMU", "BOTTOMD", 0, 0)) ||
		 (!SolidButton.LoadBitmaps("SOLIDU", "SOLIDD", 0, 0)) ||
		 (!ShadedButton.LoadBitmaps("SHADEDU", "SHADEDD", 0, 0)) ||
		 (!WireframeButton.LoadBitmaps("WIREFRAMEU", "WIREFRAMED", 0, 0)) ||
		 (!CenterXButton.LoadBitmaps("CENTERXU", "CENTERXD", 0, 0)) ||
		 (!CenterZButton.LoadBitmaps("CENTERZU", "CENTERZD", 0, 0)) ||
		 (!ZoomInButton.LoadBitmaps("ZOOMINU", "ZOOMIND", 0, 0)) ||
		 (!ZoomOutButton.LoadBitmaps("ZOOMOUTU", "ZOOMOUTD", 0, 0)) ||
		 (!ZoomResetButton.LoadBitmaps("ZOOMRESETU", "ZOOMRESETD", 0, 0)) )
	{
		TRACE0("Failed to load bitmaps for buttons\n");
	}
}

CViewPage::~CViewPage()
{
}

void CViewPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CViewPage)
	DDX_Control(pDX, IDC_DISPLAYCOMBO, m_DisplayCombo);
	DDX_Check(pDX, IDC_HIDDENWIREFRAME, m_HiddenWireframe);
	DDX_Check(pDX, IDC_USEOPENGL, m_UseOpenGL);
	DDX_Check(pDX, IDC_USEWHITEBASE, m_UseWhiteBase);
	DDX_Check(pDX, IDC_OGLREPLACE, m_OglReplace);
	DDX_Check(pDX, IDC_DISPLAYTEXTURES, m_DisplayTextures);
	DDX_Check(pDX, IDC_CULLBACKFACES, m_CullBackFaces);
	DDX_Check(pDX, IDC_TWOSIDEDLIGHTING, m_TwoSidedLighting);
	DDX_Text(pDX, IDC_CAMERASTEPANGLE, m_CameraStepAngle);
	DDX_Text(pDX, IDC_CAMERASTEPPAN, m_CameraStepPan);
	DDX_Text(pDX, IDC_CAMERAXANGLE, m_CameraXAngle);
	DDX_Text(pDX, IDC_CAMERAXPAN, m_CameraXPan);
	DDX_Text(pDX, IDC_CAMERAYANGLE, m_CameraYAngle);
	DDX_Text(pDX, IDC_CAMERAZANGLE, m_CameraZAngle);
	DDX_Text(pDX, IDC_CAMERAZPAN, m_CameraZPan);
	DDX_Text(pDX, IDC_TRIQUADNORMALANGLE, m_TriQuadNormalAngle);
	DDX_Text(pDX, IDC_TRIQUADEDGEANGLE, m_TriQuadEdgeAngle);
	DDX_Check(pDX, IDC_DEFAULTTEXTURE, m_DefaultTexture);
	DDX_Check(pDX, IDC_USEFILMSTRIP, m_UseFilmstrip);
	DDX_Check(pDX, IDC_FILMSTRIPTIMER, m_FilmstripTimer);
	DDX_Text(pDX, IDC_CAMERAXVIEWPOINT, m_CameraXViewPoint);
	DDX_Text(pDX, IDC_CAMERAYVIEWPOINT, m_CameraYViewPoint);
	DDX_Text(pDX, IDC_CAMERAZVIEWPOINT, m_CameraZViewPoint);
	DDX_Text(pDX, IDC_CAMERAROTATESPEED, m_CameraRotateSpeed);
	DDX_Text(pDX, IDC_CAMERAINITIALDISTANCE, m_CameraInitialDistance);
	DDX_Text(pDX, IDC_CAMERADISTANCE, m_CameraDistance);
	DDX_Text(pDX, IDC_CAMERAZOOMSPEED, m_CameraZoomSpeed);
	DDX_Text(pDX, IDC_CAMERAFIELDOFVIEW, m_CameraFieldOfView);
	DDX_Text(pDX, IDC_CAMERASTEPFOV, m_CameraStepFOV);
	DDX_Text(pDX, IDC_STAGEGRIDSPACING, m_StageGridSpacing);
	DDX_Text(pDX, IDC_STAGEWIDTH, m_StageWidth);
	DDX_Text(pDX, IDC_STAGEDEPTH, m_StageDepth);
	DDX_Text(pDX, IDC_STAGEORIGINX, m_StageOriginX);
	DDX_Text(pDX, IDC_STAGEORIGINY, m_StageOriginY);
	DDX_Check(pDX, IDC_STAGEUSEORIGIN, m_StageUseOrigin);
	DDX_Check(pDX, IDC_STAGEUSESQUARES, m_StageUseSquares);
	DDX_Check(pDX, IDC_STAGEUSETEXTURE, m_StageUseTexture);
	DDX_Check(pDX, IDC_DISPLAYSTAGE, m_DisplayStage);
	DDX_Check(pDX, IDC_REVERSEZOOMDIRECTION, m_ReverseZoomDirection);
	DDX_Check(pDX, IDC_REVERSEPANDIRECTION, m_ReversePanDirection);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CViewPage, CPropertyPage)
	//{{AFX_MSG_MAP(CViewPage)
	ON_BN_CLICKED(IDC_SHOWWINDOW, OnShowwindow)
	ON_BN_CLICKED(IDC_HIDEWINDOW, OnHidewindow)
	ON_BN_CLICKED(IDC_SIZEWINDOW1, OnSizewindow1)
	ON_BN_CLICKED(IDC_SIZEWINDOW2, OnSizewindow2)
	ON_BN_CLICKED(IDC_MOVEWINDOW1, OnMovewindow1)
	ON_BN_CLICKED(IDC_MOVEWINDOW2, OnMovewindow2)
	ON_BN_CLICKED(IDC_ONTOPYES, OnOntopyes)
	ON_BN_CLICKED(IDC_ONTOPNO, OnOntopno)
	ON_BN_CLICKED(IDC_USEWIRES, OnUsewires)
	ON_BN_CLICKED(IDC_USEBBOX, OnUsebbox)
	ON_BN_CLICKED(IDC_PARALLEL, OnParallel)
	ON_BN_CLICKED(IDC_PERSPECTIVE, OnPerspective)
	ON_BN_CLICKED(IDC_XYZON, OnXyzon)
	ON_BN_CLICKED(IDC_XYZOFF, OnXyzoff)
	ON_BN_CLICKED(IDC_MAKEQUADS, OnMakequads)
	ON_BN_CLICKED(IDC_DELETEQUADS, OnDeletequads)
	ON_BN_CLICKED(IDC_SHOWQUADS, OnShowquads)
	ON_BN_CLICKED(IDC_HIDEQUADS, OnHidequads)
	ON_BN_CLICKED(IDC_DEPTHBUFFERON, OnDepthbufferon)
	ON_BN_CLICKED(IDC_DEPTHBUFFEROFF, OnDepthbufferoff)
	ON_BN_CLICKED(IDC_FRONT, OnFront)
	ON_BN_CLICKED(IDC_BACK, OnBack)
	ON_BN_CLICKED(IDC_RIGHT, OnRight)
	ON_BN_CLICKED(IDC_LEFT, OnLeft)
	ON_BN_CLICKED(IDC_TOP, OnTop)
	ON_BN_CLICKED(IDC_BOTTOM, OnBottom)
	ON_BN_CLICKED(IDC_SOLID, OnSolid)
	ON_BN_CLICKED(IDC_SHADED, OnShaded)
	ON_BN_CLICKED(IDC_WIREFRAME, OnWireframe)
	ON_BN_CLICKED(IDC_CENTERX, OnCenterx)
	ON_BN_CLICKED(IDC_CENTERZ, OnCenterz)
	ON_BN_CLICKED(IDC_ZOOMIN, OnZoomin)
	ON_BN_CLICKED(IDC_ZOOMOUT, OnZoomout)
	ON_BN_CLICKED(IDC_ZOOMRESET, OnZoomreset)
	ON_BN_CLICKED(IDC_HIDDENWIREFRAME, OnHiddenwireframe)
	ON_BN_CLICKED(IDC_USEOPENGL, OnUseopengl)
	ON_BN_CLICKED(IDC_OGLLIGHTSMATERIALS, OnOgllightsmaterials)
	ON_BN_CLICKED(IDC_PARENTWINDOW, OnParentwindow)
	ON_BN_CLICKED(IDC_UNPARENTWINDOW, OnUnparentwindow)
	ON_BN_CLICKED(IDC_DISPLAYTEXTURES, OnDisplaytextures)
	ON_BN_CLICKED(IDC_OGLREPLACE, OnOglreplace)
	ON_BN_CLICKED(IDC_USEWHITEBASE, OnUsewhitebase)
	ON_BN_CLICKED(IDC_MAKESMOOTH1, OnMakesmooth1)
	ON_BN_CLICKED(IDC_MAKESMOOTH2, OnMakesmooth2)
	ON_BN_CLICKED(IDC_ERASESMOOTH1, OnErasesmooth1)
	ON_BN_CLICKED(IDC_ERASESMOOTH2, OnErasesmooth2)
	ON_BN_CLICKED(IDC_TWOSIDEDLIGHTING, OnTwosidedlighting)
	ON_BN_CLICKED(IDC_CULLBACKFACES, OnCullbackfaces)
	ON_CBN_SELCHANGE(IDC_DISPLAYCOMBO, OnSelchangeDisplaycombo)
	ON_BN_CLICKED(IDC_GETCAMERAANGLES, OnGetcameraangles)
	ON_BN_CLICKED(IDC_SETCAMERAANGLES, OnSetcameraangles)
	ON_BN_CLICKED(IDC_SETCAMERAXANGLE1, OnSetcameraxangle1)
	ON_BN_CLICKED(IDC_SETCAMERAXANGLE2, OnSetcameraxangle2)
	ON_BN_CLICKED(IDC_SETCAMERAYANGLE1, OnSetcamerayangle1)
	ON_BN_CLICKED(IDC_SETCAMERAYANGLE2, OnSetcamerayangle2)
	ON_BN_CLICKED(IDC_SETCAMERAZANGLE1, OnSetcamerazangle1)
	ON_BN_CLICKED(IDC_SETCAMERAZANGLE2, OnSetcamerazangle2)
	ON_BN_CLICKED(IDC_GETCAMERAPAN, OnGetcamerapan)
	ON_BN_CLICKED(IDC_SETCAMERAPAN, OnSetcamerapan)
	ON_BN_CLICKED(IDC_SETCAMERAXPAN1, OnSetcameraxpan1)
	ON_BN_CLICKED(IDC_SETCAMERAXPAN2, OnSetcameraxpan2)
	ON_BN_CLICKED(IDC_SETCAMERAZPAN1, OnSetcamerazpan1)
	ON_BN_CLICKED(IDC_SETCAMERAZPAN2, OnSetcamerazpan2)
	ON_BN_CLICKED(IDC_DEFAULTTEXTURE, OnDefaulttexture)
	ON_BN_CLICKED(IDC_USEFILMSTRIP, OnUsefilmstrip)
	ON_BN_CLICKED(IDC_FILMSTRIPTIMER, OnFilmstriptimer)
	ON_BN_CLICKED(IDC_GETCAMERAVIEWPOINT, OnGetcameraviewpoint)
	ON_BN_CLICKED(IDC_SETCAMERAVIEWPOINT, OnSetcameraviewpoint)
	ON_BN_CLICKED(IDC_SETCAMERAROTATESPEED1, OnSetcamerarotatespeed1)
	ON_BN_CLICKED(IDC_SETCAMERAROTATESPEED2, OnSetcamerarotatespeed2)
	ON_BN_CLICKED(IDC_GETCAMERAINITIALDISTANCE, OnGetcamerainitialdistance)
	ON_BN_CLICKED(IDC_SETCAMERAINITIALDISTANCE, OnSetcamerainitialdistance)
	ON_BN_CLICKED(IDC_GETCAMERADISTANCE, OnGetcameradistance)
	ON_BN_CLICKED(IDC_SETCAMERADISTANCE, OnSetcameradistance)
	ON_BN_CLICKED(IDC_GETCAMERAZOOMSPEED, OnGetcamerazoomspeed)
	ON_BN_CLICKED(IDC_SETCAMERAZOOMSPEED1, OnSetcamerazoomspeed1)
	ON_BN_CLICKED(IDC_SETCAMERAZOOMSPEED2, OnSetcamerazoomspeed2)
	ON_BN_CLICKED(IDC_SETCAMERAZOOMSPEED3, OnSetcamerazoomspeed3)
	ON_BN_CLICKED(IDC_SETCAMERAZOOMSPEED4, OnSetcamerazoomspeed4)
	ON_BN_CLICKED(IDC_SETCAMERAZOOMSPEED5, OnSetcamerazoomspeed5)
	ON_BN_CLICKED(IDC_SETCAMERAZOOMSPEED6, OnSetcamerazoomspeed6)
	ON_BN_CLICKED(IDC_GETCAMERAFIELDOFVIEW, OnGetcamerafieldofview)
	ON_BN_CLICKED(IDC_SETCAMERAFIELDOFVIEW, OnSetcamerafieldofview)
	ON_BN_CLICKED(IDC_SETCAMERAFOV1, OnSetcamerafov1)
	ON_BN_CLICKED(IDC_SETCAMERAFOV2, OnSetcamerafov2)	
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_DISPLAYSTAGE, OnDisplaystage)
	ON_BN_CLICKED(IDC_STAGEUSEORIGIN, OnStageuseorigin)
	ON_BN_CLICKED(IDC_STAGEUSESQUARES, OnStageusesquares)
	ON_BN_CLICKED(IDC_STAGEUSETEXTURE, OnStageusetexture)
	ON_BN_CLICKED(IDC_GETSTAGEIMAGE, OnGetstageimage)
	ON_BN_CLICKED(IDC_CHANGESTAGE, OnChangestage)
	ON_BN_CLICKED(IDC_REVERSEZOOMDIRECTION, OnReversezoomdirection)
	ON_BN_CLICKED(IDC_REVERSEPANDIRECTION, OnReversepandirection)
	//}}AFX_MSG_MAP
  ON_BN_CLICKED(IDC_INVERTALLLAYERTRANSPARENCIES, &CViewPage::OnBnClickedInvertalllayertransparencies)
  ON_BN_CLICKED(IDC_MAKEALLLAYERSOPAQUE, &CViewPage::OnBnClickedMakealllayersopaque)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CViewPage message handlers

BOOL CViewPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	FrontButton.AutoLoad(IDC_FRONT, this);
	BackButton.AutoLoad(IDC_BACK, this);
	RightButton.AutoLoad(IDC_RIGHT, this);
	LeftButton.AutoLoad(IDC_LEFT, this);
	TopButton.AutoLoad(IDC_TOP, this);	
	BottomButton.AutoLoad(IDC_BOTTOM, this);
	SolidButton.AutoLoad(IDC_SOLID, this);
	ShadedButton.AutoLoad(IDC_SHADED, this);
	WireframeButton.AutoLoad(IDC_WIREFRAME, this);
	CenterXButton.AutoLoad(IDC_CENTERX, this);
	CenterZButton.AutoLoad(IDC_CENTERZ, this);
	ZoomInButton.AutoLoad(IDC_ZOOMIN, this);
	ZoomOutButton.AutoLoad(IDC_ZOOMOUT, this);
	ZoomResetButton.AutoLoad(IDC_ZOOMRESET, this);

	m_UseOpenGL = (at3dData->useOglFlag) ? 1 : 0;
	m_TwoSidedLighting = (at3dData->twoSidedLightingFlag) ? 1 : 0;
	m_CullBackFaces = (at3dData->cullBackFacesFlag) ? 1 : 0;
	m_DisplayTextures = (at3dData->displayTexturesFlag) ? 1 : 0;
	m_DefaultTexture = (at3dData->defaultTextureFlag) ? 1 : 0;
	m_OglReplace = (at3dData->oglReplaceFlag) ? 1 : 0;
	m_UseWhiteBase = (at3dData->useWhiteBaseFlag) ? 1 : 0;
	m_TriQuadNormalAngle.Format("%.2f", at3dData->triQuadNormalAngle);
	m_TriQuadEdgeAngle.Format("%.2f", at3dData->triQuadEdgeAngle);
	
	m_CameraXViewPoint.Format("%f", at3dData->cameraXViewPoint);
  m_CameraYViewPoint.Format("%f", at3dData->cameraYViewPoint);
  m_CameraZViewPoint.Format("%f", at3dData->cameraZViewPoint);

  if (at3dData->cameraRotateSpeed == CAMERA_ROTATE_SPEED_1)
  {
    m_CameraRotateSpeed = "R1";
  }
  else
  {
    m_CameraRotateSpeed = "R2";
  }

  m_CameraXAngle.Format("%f", at3dData->cameraXAngle);
  m_CameraYAngle.Format("%f", at3dData->cameraYAngle);
  m_CameraZAngle.Format("%f", at3dData->cameraZAngle);

	m_CameraStepAngle.Format("%f", at3dData->cameraStepAngle);

	m_CameraInitialDistance.Format("%f", at3dData->cameraInitialDistance);
  m_CameraDistance.Format("%f", at3dData->cameraDistance);

  if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_1)
  {
    m_CameraZoomSpeed = "Z1";
  }
  else if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_2)
  {
    m_CameraZoomSpeed = "Z2";
  }
  else if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_3)
  {
    m_CameraZoomSpeed = "Z3";
  }
  else if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_4)
  {
    m_CameraZoomSpeed = "Z4";
  }
  else if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_5)
  {
    m_CameraZoomSpeed = "Z5";
  }
  else
  {
    m_CameraZoomSpeed = "Z6";
  }

	m_ReverseZoomDirection = (at3dData->reverseZoomDirectionFlag) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_REVERSE_ZOOM_DIRECTION, at3dData->reverseZoomDirectionFlag);

	m_ReversePanDirection = (at3dData->reversePanDirectionFlag) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_REVERSE_PAN_DIRECTION, at3dData->reversePanDirectionFlag);

  m_CameraFieldOfView.Format("%f", at3dData->cameraFieldOfView);
  m_CameraStepFOV.Format("%f", at3dData->cameraStepFOV);
      
  m_CameraXPan.Format("%d", at3dData->cameraXPan);
  m_CameraZPan.Format("%d", at3dData->cameraZPan);

	m_CameraStepPan.Format("%d", at3dData->cameraStepPan);
	
	for (int i=0; i<at3dData->oglRenderCount; i++)
	{
		m_DisplayCombo.AddString(at3dData->oglRenderLabel[i]);
	}
	m_DisplayCombo.SetCurSel(at3dData->oglRenderIndex);
	m_UseFilmstrip = (at3dData->useFilmstripFlag) ? 1 : 0;
	m_FilmstripTimer = (at3dData->filmstripTimerFlag) ? 1 : 0;

	m_DisplayStage    = (at3dData->stageUseFlag) ? 1 : 0;
  m_StageUseOrigin  = (at3dData->stageOriginFlag) ? 1 : 0;
  m_StageUseSquares = (at3dData->stageSquaresFlag) ? 1 : 0;
  m_StageUseTexture = (at3dData->stageImageFlag) ? 1 : 0;

	m_StageGridSpacing.Format("%f", at3dData->stageSpacing);
  m_StageWidth.Format("%f", at3dData->stageWidth);
  m_StageDepth.Format("%f", at3dData->stageDepth);
  m_StageOriginX.Format("%f", at3dData->stageOriginX);
  m_StageOriginY.Format("%f", at3dData->stageOriginY);

	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CViewPage::OnShowwindow() 
{
	At3d_Show();
}

void CViewPage::OnHidewindow() 
{
	At3d_Hide();
}

void CViewPage::OnSizewindow1() 
{
	At3d_Size(600, 500);
}

void CViewPage::OnSizewindow2() 
{
	At3d_Size(350, 250);
}

void CViewPage::OnMovewindow1() 
{
	At3d_Position(2, 2);
}

void CViewPage::OnMovewindow2() 
{
	At3d_Position(10, 40);
}

void CViewPage::OnOntopyes() 
{
	At3d_FormStyle(1);
}

void CViewPage::OnOntopno() 
{
	At3d_FormStyle(0);
}

void CViewPage::OnUsewires() 
{
	At3d_UseWireframe(1);
}

void CViewPage::OnUsebbox() 
{
	At3d_UseWireframe(0);
}

void CViewPage::OnParallel() 
{
	At3d_ViewType(1);
}

void CViewPage::OnPerspective() 
{
	At3d_ViewType(0);
}

void CViewPage::OnXyzon() 
{
	At3d_PlaneIndicator(1);
	At3d_WriteFlag(LIBFLAG_VIEW_AXES, 1);
}

void CViewPage::OnXyzoff() 
{
	At3d_PlaneIndicator(0);
	At3d_WriteFlag(LIBFLAG_VIEW_AXES, 0);
}

void CViewPage::OnMakequads() 
{
	UpdateData(TRUE);
	at3dData->triQuadNormalAngle = atof(m_TriQuadNormalAngle);
	at3dData->triQuadEdgeAngle = atof(m_TriQuadEdgeAngle);

	At3d_SetTriQuadAngle(at3dData->triQuadNormalAngle);
	At3d_SetTriQuadEdgeAngle(at3dData->triQuadEdgeAngle);
	At3d_MakeQuads();
}

void CViewPage::OnDeletequads() 
{
	At3d_DeleteQuads();
}

void CViewPage::OnShowquads() 
{
	At3d_WriteFlag(LIBFLAG_SHOW_QUADFACE, 1);
  At3d_DrawWireframe();
}

void CViewPage::OnHidequads() 
{
	At3d_WriteFlag(LIBFLAG_SHOW_QUADFACE, 0);
  At3d_DrawWireframe();
}

void CViewPage::OnDepthbufferon() 
{
	At3d_WriteFlag(LIBFLAG_FULL_WDW_DEPTH_BUFFER, 1);
}

void CViewPage::OnDepthbufferoff() 
{
	At3d_WriteFlag(LIBFLAG_FULL_WDW_DEPTH_BUFFER, 0);
}

void CViewPage::OnFront() 
{
	At3d_ViewFront();
}

void CViewPage::OnBack() 
{
	At3d_ViewBack(); 
}

void CViewPage::OnRight() 
{
	At3d_ViewRight(); 
}

void CViewPage::OnLeft() 
{
	At3d_ViewLeft();
}

void CViewPage::OnTop() 
{
	At3d_ViewTop();
}

void CViewPage::OnBottom() 
{
	At3d_ViewBottom(); 
}

void CViewPage::OnSolid() 
{
	At3d_PaintSolid();
}

void CViewPage::OnShaded() 
{
	At3d_PaintShaded(); 
}

void CViewPage::OnWireframe() 
{
	At3d_DrawWireframe(); 
}

void CViewPage::OnCenterx() 
{
	At3d_CenterX();
}

void CViewPage::OnCenterz() 
{
	At3d_CenterZ();
}

void CViewPage::OnZoomin() 
{
	At3d_ZoomIn(); 
}

void CViewPage::OnZoomout() 
{
	At3d_ZoomOut();
}

void CViewPage::OnZoomreset() 
{
	At3d_ZoomReset();

	OnGetcameraviewpoint();
  OnGetcameraangles();
  OnGetcameradistance();
  OnGetcamerafieldofview();
}

void CViewPage::OnHiddenwireframe() 
{
	UpdateData(TRUE);
  
	At3d_WriteFlag(LIBFLAG_HIDDEN_WIREFRAME, 
		             (m_HiddenWireframe) ? 1 : 0);
  At3d_DrawWireframe();
}

void CViewPage::OnUseopengl() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_USE_OPENGL, 
								at3dData->useOglFlag = (m_UseOpenGL) ? 1 : 0);
}

void CViewPage::OnOgllightsmaterials() 
{
	At3d_OglLightsMaterials();
}

void CViewPage::OnParentwindow() 
{
	At3d_SetParent(at3dData->hwnd);
}

void CViewPage::OnUnparentwindow() 
{
	At3d_SetParent(0);
}

void CViewPage::OnDisplaytextures() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_OGL_USE_TEXTURES, 
								 at3dData->displayTexturesFlag = (m_DisplayTextures) ? 1 : 0);
}

void CViewPage::OnOglreplace() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_OGL_REPLACE, 
								 at3dData->oglReplaceFlag = (m_OglReplace) ? 1 : 0);
}

void CViewPage::OnUsewhitebase() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_OGL_WHITE_BASE, 
								 at3dData->useWhiteBaseFlag = (m_UseWhiteBase) ? 1 : 0);
}

void CViewPage::OnMakesmooth1() 
{
	at3dData->MakeSmooth1();
}

void CViewPage::OnMakesmooth2() 
{
	at3dData->MakeSmooth2();
}

void CViewPage::OnErasesmooth1() 
{
	at3dData->EraseSmooth1();
}

void CViewPage::OnErasesmooth2() 
{
	at3dData->EraseSmooth2();
}

void CViewPage::OnTwosidedlighting() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_OGL_2SIDED_LIGHTING, 
								 at3dData->twoSidedLightingFlag = (m_TwoSidedLighting) ? 1 : 0);
}

void CViewPage::OnCullbackfaces() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_OGL_CULL_BACKFACES, 
								 at3dData->cullBackFacesFlag = (m_CullBackFaces) ? 1 : 0);
}

void CViewPage::OnSelchangeDisplaycombo() 
{
	if (m_DisplayCombo.GetCurSel() != CB_ERR)
	{
		at3dData->oglRenderIndex = m_DisplayCombo.GetCurSel();
		At3d_WriteFlag(LIBFLAG_OGL_RENDER, at3dData->oglRenderType[at3dData->oglRenderIndex]);
	}
}

void CViewPage::OnGetcameraangles() 
{
	At3d_GetCameraAngles(&at3dData->cameraXAngle, &at3dData->cameraYAngle,
                       &at3dData->cameraZAngle);
	
	m_CameraXAngle.Format("%f", at3dData->cameraXAngle);
	m_CameraYAngle.Format("%f", at3dData->cameraYAngle);
	m_CameraZAngle.Format("%f", at3dData->cameraZAngle);
	UpdateData(FALSE);
}

void CViewPage::OnSetcameraangles() 
{
	UpdateData(TRUE);
	at3dData->cameraXAngle = atof(m_CameraXAngle);
	at3dData->cameraYAngle = atof(m_CameraYAngle);
	at3dData->cameraZAngle = atof(m_CameraZAngle);

	At3d_RotateCamera(0, at3dData->cameraXAngle, at3dData->cameraYAngle,
                    at3dData->cameraZAngle);
  OnGetcameraangles();
}

void CViewPage::GetCameraStepAngle(void)
{
	  UpdateData(TRUE);
	  at3dData->cameraStepAngle = atof(m_CameraStepAngle);
}

void CViewPage::OnSetcameraxangle1() 
{
	GetCameraStepAngle();
  At3d_RotateCamera(1, -at3dData->cameraStepAngle, 0.0, 0.0);
  OnGetcameraangles();
}

void CViewPage::OnSetcameraxangle2() 
{
	GetCameraStepAngle();
  At3d_RotateCamera(1, at3dData->cameraStepAngle, 0.0, 0.0);
  OnGetcameraangles();
}

void CViewPage::OnSetcamerayangle1() 
{
	GetCameraStepAngle();
  At3d_RotateCamera(1, 0.0, -at3dData->cameraStepAngle, 0.0);
  OnGetcameraangles();
}

void CViewPage::OnSetcamerayangle2() 
{
	GetCameraStepAngle();
  At3d_RotateCamera(1, 0.0, at3dData->cameraStepAngle, 0.0);
  OnGetcameraangles();
}

void CViewPage::OnSetcamerazangle1() 
{
	GetCameraStepAngle();
  At3d_RotateCamera(1, 0.0, 0.0, -at3dData->cameraStepAngle);
  OnGetcameraangles();
}

void CViewPage::OnSetcamerazangle2() 
{
	GetCameraStepAngle();
  At3d_RotateCamera(1, 0.0, 0.0, at3dData->cameraStepAngle);
  OnGetcameraangles();
}

void CViewPage::OnGetcamerapan() 
{
	At3d_GetCameraPan(&at3dData->cameraXPan, &at3dData->cameraZPan);

	m_CameraXPan.Format("%d", at3dData->cameraXPan);
	m_CameraZPan.Format("%d", at3dData->cameraZPan);
	UpdateData(FALSE);
}

void CViewPage::OnSetcamerapan() 
{
	UpdateData(TRUE);
	at3dData->cameraXPan = atoi(m_CameraXPan);
	at3dData->cameraZPan = atoi(m_CameraZPan);

	At3d_PanCamera(0, at3dData->cameraXPan, at3dData->cameraZPan);
  OnGetcamerapan();
}

void CViewPage::GetCameraStepPan(void)
{
	  UpdateData(TRUE);
	  at3dData->cameraStepPan = atoi(m_CameraStepPan);
}

void CViewPage::OnSetcameraxpan1() 
{
	GetCameraStepPan();
  At3d_PanCamera(1, -at3dData->cameraStepPan, 0);
  OnGetcamerapan();
}

void CViewPage::OnSetcameraxpan2() 
{
	GetCameraStepPan();
  At3d_PanCamera(1, at3dData->cameraStepPan, 0);
  OnGetcamerapan();
}

void CViewPage::OnSetcamerazpan1() 
{
	GetCameraStepPan();
  At3d_PanCamera(1, 0, -at3dData->cameraStepPan);
	OnGetcamerapan();
}

void CViewPage::OnSetcamerazpan2() 
{
	GetCameraStepPan();
  At3d_PanCamera(1, 0, at3dData->cameraStepPan);
	OnGetcamerapan();
}

void CViewPage::OnDefaulttexture() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_OGL_USE_DEFAULT_TEXTURE, 
								 at3dData->defaultTextureFlag = (m_DefaultTexture) ? 1 : 0);
}

void CViewPage::OnUsefilmstrip() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_USE_AW_FILMSTRIP,
                 at3dData->useFilmstripFlag = (m_UseFilmstrip) ? 1 : 0);
}

void CViewPage::OnFilmstriptimer() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_AW_FILMSTRIP_TIMER,
                 at3dData->filmstripTimerFlag = (m_FilmstripTimer) ? 1 : 0);
}

void CViewPage::OnGetcameraviewpoint() 
{
	__int32 result = At3d_GetCameraViewPoint(&at3dData->cameraXViewPoint,
                                           &at3dData->cameraYViewPoint,
                                           &at3dData->cameraZViewPoint);
	
	if (result)
	{
	  m_CameraXViewPoint.Format("%f", at3dData->cameraXViewPoint);
	  m_CameraYViewPoint.Format("%f", at3dData->cameraYViewPoint);
	  m_CameraZViewPoint.Format("%f", at3dData->cameraZViewPoint);
	  UpdateData(FALSE);
	}
}

void CViewPage::OnSetcameraviewpoint() 
{
	UpdateData(TRUE);
	at3dData->cameraXViewPoint = atof(m_CameraXViewPoint);  
  at3dData->cameraYViewPoint = atof(m_CameraYViewPoint);  
  at3dData->cameraZViewPoint = atof(m_CameraZViewPoint);  
  
  At3d_SetCameraViewPoint(at3dData->cameraXViewPoint, at3dData->cameraYViewPoint,
                          at3dData->cameraZViewPoint);

  OnGetcameraviewpoint();
}

void CViewPage::GetCameraRotateSpeed(void)
{
	__int32 result = At3d_GetCameraRotateSpeed(&at3dData->cameraRotateSpeed);

  if (result)
  {
    if (at3dData->cameraRotateSpeed == CAMERA_ROTATE_SPEED_1)
    {
      m_CameraRotateSpeed = "R1";
    }
    else
    {
      m_CameraRotateSpeed = "R2";
    }

		UpdateData(FALSE);
  }
}

void CViewPage::OnSetcamerarotatespeed1() 
{
	__int32 result = At3d_SetCameraRotateSpeed(CAMERA_ROTATE_SPEED_1);

   if (result) GetCameraRotateSpeed();
}

void CViewPage::OnSetcamerarotatespeed2() 
{
	__int32 result = At3d_SetCameraRotateSpeed(CAMERA_ROTATE_SPEED_2);

   if (result) GetCameraRotateSpeed();
}

void CViewPage::OnGetcamerainitialdistance() 
{
	__int32 result = At3d_GetCameraInitialDistance(&at3dData->cameraInitialDistance);

  if (result)
  {
    m_CameraInitialDistance.Format("%f", at3dData->cameraInitialDistance);
		UpdateData(FALSE);
  }
}

void CViewPage::OnSetcamerainitialdistance() 
{
	UpdateData(TRUE);
  at3dData->cameraInitialDistance = atof(m_CameraInitialDistance);
  
  __int32 result = At3d_SetCameraInitialDistance(at3dData->cameraInitialDistance);

  if (result) OnGetcamerainitialdistance();
}

void CViewPage::OnGetcameradistance() 
{
	__int32 result = At3d_GetCameraDistance(&at3dData->cameraDistance);

  if (result)
  {
    m_CameraDistance.Format("%f", at3dData->cameraDistance);
		UpdateData(FALSE);
  }
}

void CViewPage::OnSetcameradistance() 
{
	UpdateData(TRUE);
	at3dData->cameraDistance = atof(m_CameraDistance);
  
  __int32 result = At3d_SetCameraDistance(at3dData->cameraDistance);

  if (result) OnGetcameradistance();
}

void CViewPage::OnGetcamerazoomspeed() 
{
	__int32 result = At3d_GetCameraZoomSpeed(&at3dData->cameraZoomSpeed);

  if (result)
  {
    if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_1)
    {
      m_CameraZoomSpeed = "Z1";
    }
    else if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_2)
    {
      m_CameraZoomSpeed = "Z2";
    }
    else if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_3)
    {
      m_CameraZoomSpeed = "Z3";
    }
    else if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_4)
    {
      m_CameraZoomSpeed = "Z4";
    }
    else if (at3dData->cameraZoomSpeed == CAMERA_ZOOM_SPEED_5)
    {
      m_CameraZoomSpeed = "Z5";
    }
    else
    {
      m_CameraZoomSpeed = "Z6";
    }

		UpdateData(FALSE);
  }
}

void CViewPage::OnSetcamerazoomspeed1() 
{
	__int32 result = At3d_SetCameraZoomSpeed(CAMERA_ZOOM_SPEED_1);

  if (result) OnGetcamerazoomspeed();
}

void CViewPage::OnSetcamerazoomspeed2() 
{
	__int32 result = At3d_SetCameraZoomSpeed(CAMERA_ZOOM_SPEED_2);

  if (result) OnGetcamerazoomspeed();
}

void CViewPage::OnSetcamerazoomspeed3() 
{
	__int32 result = At3d_SetCameraZoomSpeed(CAMERA_ZOOM_SPEED_3);

  if (result) OnGetcamerazoomspeed();
}

void CViewPage::OnSetcamerazoomspeed4() 
{
	__int32 result = At3d_SetCameraZoomSpeed(CAMERA_ZOOM_SPEED_4);

  if (result) OnGetcamerazoomspeed();
}

void CViewPage::OnSetcamerazoomspeed5() 
{
	__int32 result = At3d_SetCameraZoomSpeed(CAMERA_ZOOM_SPEED_5);

  if (result) OnGetcamerazoomspeed();
}

void CViewPage::OnSetcamerazoomspeed6() 
{
	__int32 result = At3d_SetCameraZoomSpeed(CAMERA_ZOOM_SPEED_6);

  if (result) OnGetcamerazoomspeed();
}

void CViewPage::OnGetcamerafieldofview() 
{
	__int32 result = At3d_GetCameraFieldOfView(&at3dData->cameraFieldOfView);

  if (result)
  {
    m_CameraFieldOfView.Format("%f", at3dData->cameraFieldOfView);
		UpdateData(FALSE);
  }
}

void CViewPage::OnSetcamerafieldofview() 
{
	UpdateData(TRUE);
	at3dData->cameraFieldOfView = atof(m_CameraFieldOfView);
  

  __int32 result = At3d_SetCameraFieldOfView(0, at3dData->cameraFieldOfView);

  if (result) OnGetcamerafieldofview();
}

void CViewPage::GetCameraStepFOV(void)
{
	UpdateData(TRUE);
	at3dData->cameraStepFOV = atof(m_CameraStepFOV);
}

void CViewPage::OnSetcamerafov1() 
{
	GetCameraStepFOV();
  At3d_SetCameraFieldOfView(1, -at3dData->cameraStepFOV);
  OnGetcamerafieldofview();
}

void CViewPage::OnSetcamerafov2() 
{
	GetCameraStepFOV();
  At3d_SetCameraFieldOfView(1, at3dData->cameraStepFOV);
  OnGetcamerafieldofview();
}

void CViewPage::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CPropertyPage::OnShowWindow(bShow, nStatus);
	
	// TODO: Add your message handler code here

	UpdateData(FALSE);
}


void CViewPage::OnDisplaystage() 
{
	UpdateData(TRUE);
	at3dData->stageUseFlag = m_DisplayStage;
  At3d_WriteFlag(LIBFLAG_STAGE_USE, at3dData->stageUseFlag);
}

void CViewPage::OnStageuseorigin() 
{
	UpdateData(TRUE);
	at3dData->stageOriginFlag = m_StageUseOrigin;
  At3d_WriteFlag(LIBFLAG_STAGE_ORIGIN, at3dData->stageOriginFlag);
}

void CViewPage::OnStageusesquares() 
{
	UpdateData(TRUE);
	at3dData->stageSquaresFlag = m_StageUseSquares;
  At3d_WriteFlag(LIBFLAG_STAGE_TYPE, at3dData->stageSquaresFlag);
}

void CViewPage::OnStageusetexture() 
{
	UpdateData(TRUE);
	at3dData->stageImageFlag = m_StageUseTexture;
  At3d_WriteFlag(LIBFLAG_STAGE_UV, at3dData->stageImageFlag);
}

void CViewPage::OnGetstageimage() 
{
	at3dData->GetStageImage();
}

void CViewPage::OnChangestage() 
{
	UpdateData(TRUE);
	
	at3dData->stageSpacing = atof(m_StageGridSpacing);
  
  at3dData->stageWidth = atof(m_StageWidth);
  
  at3dData->stageDepth = atof(m_StageDepth);
    
	at3dData->stageOriginX = atof(m_StageOriginX);
    
  at3dData->stageOriginY = atof(m_StageOriginY);
  

  At3d_SetStageGrid(at3dData->stageSpacing, at3dData->stageWidth,
                    at3dData->stageDepth, at3dData->stageOriginX,
                    at3dData->stageOriginY);
}

void CViewPage::OnReversezoomdirection() 
{
	UpdateData(TRUE);
	at3dData->reverseZoomDirectionFlag = (m_ReverseZoomDirection) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_REVERSE_ZOOM_DIRECTION, at3dData->reverseZoomDirectionFlag);
}

void CViewPage::OnReversepandirection() 
{
	UpdateData(TRUE);
	at3dData->reversePanDirectionFlag = (m_ReversePanDirection) ? 1 : 0;
	At3d_WriteFlag(LIBFLAG_REVERSE_PAN_DIRECTION, at3dData->reversePanDirectionFlag);
}

void CViewPage::OnBnClickedInvertalllayertransparencies()
{
  At3d_Invert_All_Layer_Transparencies();
}

void CViewPage::OnBnClickedMakealllayersopaque()
{
  At3d_Make_All_Layers_Opaque();
}
