// TransferPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "TransferPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTransferPage property page

IMPLEMENT_DYNCREATE(CTransferPage, CPropertyPage)

CTransferPage::CTransferPage() : CPropertyPage(CTransferPage::IDD)
{
	//{{AFX_DATA_INIT(CTransferPage)
	m_TypeFlagGroup = -1;
	m_UseAmbient1 = FALSE;
	m_UseDiffuse1 = FALSE;
	m_UseReflection1 = FALSE;
	m_UseSpecular1 = FALSE;
	m_UseTransparency1 = FALSE;
	m_UseVertexFloatTransfer = FALSE;
	m_LayerCloudVerts = _T("");
	m_LayerLines = _T("");
	m_LayerLineVerts = _T("");
	m_LayerMaxX = _T("");
	m_LayerMaxY = _T("");
	m_LayerMaxZ = _T("");
	m_LayerMeshVerts = _T("");
	m_LayerMinMaxName = _T("");
	m_LayerMinX = _T("");
	m_LayerMinY = _T("");
	m_LayerMinZ = _T("");
	m_LayerTriangles = _T("");
	//}}AFX_DATA_INIT
}

CTransferPage::~CTransferPage()
{
}

void CTransferPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTransferPage)
	DDX_Radio(pDX, IDC_TRANSFERFROMTYPEFLAG0, m_TypeFlagGroup);
	DDX_Check(pDX, IDC_USEAMBIENT1, m_UseAmbient1);
	DDX_Check(pDX, IDC_USEDIFFUSE1, m_UseDiffuse1);
	DDX_Check(pDX, IDC_USEREFLECTION1, m_UseReflection1);
	DDX_Check(pDX, IDC_USESPECULAR1, m_UseSpecular1);
	DDX_Check(pDX, IDC_USETRANSPARENCY1, m_UseTransparency1);
	DDX_Check(pDX, IDC_USEVERTEXFLOATTRANSFER, m_UseVertexFloatTransfer);
	DDX_Text(pDX, IDC_LAYERCLOUDVERTS, m_LayerCloudVerts);
	DDX_Text(pDX, IDC_LAYERLINES, m_LayerLines);
	DDX_Text(pDX, IDC_LAYERLINEVERTS, m_LayerLineVerts);
	DDX_Text(pDX, IDC_LAYERMAXX, m_LayerMaxX);
	DDX_Text(pDX, IDC_LAYERMAXY, m_LayerMaxY);
	DDX_Text(pDX, IDC_LAYERMAXZ, m_LayerMaxZ);
	DDX_Text(pDX, IDC_LAYERMESHVERTS, m_LayerMeshVerts);
	DDX_Text(pDX, IDC_LAYERMINMAXNAME, m_LayerMinMaxName);
	DDX_Text(pDX, IDC_LAYERMINX, m_LayerMinX);
	DDX_Text(pDX, IDC_LAYERMINY, m_LayerMinY);
	DDX_Text(pDX, IDC_LAYERMINZ, m_LayerMinZ);
	DDX_Text(pDX, IDC_LAYERTRIANGLES, m_LayerTriangles);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTransferPage, CPropertyPage)
	//{{AFX_MSG_MAP(CTransferPage)
	ON_BN_CLICKED(IDC_TRANSFERFROM, OnTransferfrom)
	ON_BN_CLICKED(IDC_FASTTRANSFERFROM, OnFasttransferfrom)
	ON_BN_CLICKED(IDC_TRANSFERCLEAR, OnTransferclear)
	ON_BN_CLICKED(IDC_TRANSFERTO, OnTransferto)
	ON_BN_CLICKED(IDC_FASTTRANSFERTO, OnFasttransferto)
	ON_BN_CLICKED(IDC_TRANSFERFREE, OnTransferfree)
	ON_BN_CLICKED(IDC_SPECIALTRANSFERFROM, OnSpecialtransferfrom)
	ON_BN_CLICKED(IDC_SPECIALFASTTRANSFERFROM, OnSpecialfasttransferfrom)
	ON_BN_CLICKED(IDC_SPECIALTRANSFERTO, OnSpecialtransferto)
	ON_BN_CLICKED(IDC_SPECIALFASTTRANSFERTO, OnSpecialfasttransferto)
	ON_BN_CLICKED(IDC_TRANSFERGREENKNIGHT, OnTransfergreenknight)
	ON_BN_CLICKED(IDC_TRANSFERTEXTURESQUARE1, OnTransfertexturesquare1)
	ON_BN_CLICKED(IDC_TRANSFERSQUARE2, OnTransfersquare2)
	ON_BN_CLICKED(IDC_TRANSFERSQUARE3, OnTransfersquare3)
	ON_BN_CLICKED(IDC_TRANSFERREDKNIGHT, OnTransferredknight)
	ON_BN_CLICKED(IDC_TRANSFERBLUEKNIGHT, OnTransferblueknight)
	ON_BN_CLICKED(IDC_TRANSFERFROMTYPEFLAG0, OnTransferfromtypeflag0)
	ON_BN_CLICKED(IDC_TRANSFERFROMTYPEFLAG1, OnTransferfromtypeflag1)
	ON_BN_CLICKED(IDC_TRANSFERFROMTYPEFLAG2, OnTransferfromtypeflag2)
	ON_BN_CLICKED(IDC_TRANSFERBLUEMONK, OnTransferbluemonk)
	ON_BN_CLICKED(IDC_TRANSFERGREENMONK, OnTransfergreenmonk)
	ON_BN_CLICKED(IDC_USEAMBIENT1, OnUseambient1)
	ON_BN_CLICKED(IDC_USEDIFFUSE1, OnUsediffuse1)
	ON_BN_CLICKED(IDC_USEREFLECTION1, OnUsereflection1)
	ON_BN_CLICKED(IDC_USESPECULAR1, OnUsespecular1)
	ON_BN_CLICKED(IDC_USETRANSPARENCY1, OnUsetransparency1)
	ON_BN_CLICKED(IDC_TRANSFERMULTIMATKNIGHT, OnTransfermultimatknight)
	ON_BN_CLICKED(IDC_USEVERTEXFLOATTRANSFER, OnUsevertexfloattransfer)
	ON_BN_CLICKED(IDC_SELECTFIRSTLAYER, OnSelectfirstlayer)
	ON_BN_CLICKED(IDC_SELECTNEXTLAYER, OnSelectnextlayer)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTransferPage message handlers

void CTransferPage::OnTransferfrom() 
{
	at3dData->TransferFromDll(0);
}

void CTransferPage::OnFasttransferfrom() 
{
	at3dData->TransferFromDll(1);
}

void CTransferPage::OnTransferclear() 
{
	at3dData->Clear_All_Objects();
}

void CTransferPage::OnTransferto() 
{
	at3dData->TransferToDll(0);
}

void CTransferPage::OnFasttransferto() 
{
	at3dData->TransferToDll(1);
}

void CTransferPage::OnTransferfree() 
{
	at3dData->ClearTransferData();
}

void CTransferPage::OnSpecialtransferfrom() 
{
	at3dData->SpecialTransferFromDll(0);
}

void CTransferPage::OnSpecialfasttransferfrom() 
{
	at3dData->SpecialTransferFromDll(1);
}

void CTransferPage::OnSpecialtransferto() 
{
	at3dData->SpecialTransferToDll(0);
}

void CTransferPage::OnSpecialfasttransferto() 
{
	at3dData->SpecialTransferToDll(1);
}

void CTransferPage::OnTransferredknight() 
{
	at3dData->TransferRedKnightToDll();
}

void CTransferPage::OnTransfergreenknight() 
{
	at3dData->TransferGreenKnightToDll();
}

void CTransferPage::OnTransfertexturesquare1() 
{
	at3dData->TransferTextureSquareToDll1();
}

void CTransferPage::OnTransfersquare2() 
{
	at3dData->TransferTextureSquareToDll2();
}

void CTransferPage::OnTransfersquare3() 
{
	at3dData->TransferTextureSquareToDll3();
}

void CTransferPage::OnTransferblueknight() 
{
	at3dData->TransferBlueKnightToDll();
}

void CTransferPage::OnTransferfromtypeflag0() 
{
	at3dData->transferFromTypeFlag = TRANSFERFROM_TYPE_BASIC;
}

void CTransferPage::OnTransferfromtypeflag1() 
{
	at3dData->transferFromTypeFlag = TRANSFERFROM_TYPE_ARRAYS;
}

void CTransferPage::OnTransferfromtypeflag2() 
{
	at3dData->transferFromTypeFlag = TRANSFERFROM_TYPE_XYZ_UV; 
}

BOOL CTransferPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_TypeFlagGroup = at3dData->transferFromTypeFlag;

	m_UseAmbient1 = at3dData->useAmbient1Flag;
	m_UseDiffuse1 = at3dData->useDiffuse1Flag;
	m_UseReflection1 = at3dData->useReflection1Flag;
	m_UseSpecular1 = at3dData->useSpecular1Flag;
	m_UseTransparency1 = at3dData->useTransparency1Flag;

	m_UseVertexFloatTransfer = at3dData->vertexFloatTransferFlag;

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTransferPage::OnTransferbluemonk() 
{
	at3dData->TransferBlueMonkToDll();
}

void CTransferPage::OnTransfergreenmonk() 
{
	at3dData->TransferGreenMonkToDll();
}

void CTransferPage::OnUseambient1() 
{
	UpdateData(TRUE);
	at3dData->useAmbient1Flag = (m_UseAmbient1) ? 1 : 0;
}

void CTransferPage::OnUsediffuse1() 
{
	UpdateData(TRUE);
	at3dData->useDiffuse1Flag = (m_UseDiffuse1) ? 1 : 0;
}

void CTransferPage::OnUsereflection1() 
{
	UpdateData(TRUE);
	at3dData->useReflection1Flag = (m_UseReflection1) ? 1 : 0;
}

void CTransferPage::OnUsespecular1() 
{
	UpdateData(TRUE);
	at3dData->useSpecular1Flag = (m_UseSpecular1) ? 1 : 0;
}

void CTransferPage::OnUsetransparency1() 
{
	UpdateData(TRUE);
	at3dData->useTransparency1Flag = (m_UseTransparency1) ? 1 : 0;
}

void CTransferPage::OnTransfermultimatknight() 
{
	at3dData->TransferMultiMatKnightToDll();
}

void CTransferPage::OnUsevertexfloattransfer() 
{
	UpdateData(TRUE);
	at3dData->vertexFloatTransferFlag = (m_UseVertexFloatTransfer) ? 1 : 0;
}

void CTransferPage::OnSelectfirstlayer() 
{
	at3dData->layerMinMaxNextLayer = 0;
	OnSelectnextlayer();
}

void CTransferPage::OnSelectnextlayer() 
{
	LAYER_MINMAX layerMinMax;

  // just select layers in order they are in list
  //
  at3dData->layerMinMaxNextLayer = At3d_GetNextLayer(at3dData->layerMinMaxNextLayer, at3dData->layerMinMaxName);
  __int32 result = At3d_Get_Layer_MinMax(at3dData->layerMinMaxName,
                                         &layerMinMax.cloudVertexCount,
                                         &layerMinMax.minX);

  if (result)
  {
    m_LayerMinMaxName = at3dData->layerMinMaxName;

    m_LayerCloudVerts.Format("%d", layerMinMax.cloudVertexCount);
    m_LayerLineVerts.Format("%d", layerMinMax.lineVertexCount);
    m_LayerMeshVerts.Format("%d", layerMinMax.meshVertexCount);

    m_LayerLines.Format("%d", layerMinMax.lineCount);
    m_LayerTriangles.Format("%d", layerMinMax.triangleCount);

    m_LayerMinX.Format("%f", layerMinMax.minX);
    m_LayerMinY.Format("%f", layerMinMax.minY);
    m_LayerMinZ.Format("%f", layerMinMax.minZ);

    m_LayerMaxX.Format("%f", layerMinMax.maxX);
    m_LayerMaxY.Format("%f", layerMinMax.maxY);
    m_LayerMaxZ.Format("%f", layerMinMax.maxZ);

		UpdateData(FALSE);
  }	
}
