// TextPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3dx_my_functions.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "TextPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextPage property page

IMPLEMENT_DYNCREATE(CTextPage, CPropertyPage)

CTextPage::CTextPage() : CPropertyPage(CTextPage::IDD)
, m_TextOnCurve(FALSE)
, m_TextOrigVerts(FALSE)
, m_TextAllChars(FALSE)
, m_TextReverseOutlines(FALSE)
, m_TextUnicodeEdit(_T(""))
{
	//{{AFX_DATA_INIT(CTextPage)
	m_TextCreateStencil = FALSE;
	m_TextPlusCore = FALSE;
	m_TextPoints = _T("");
	m_TextHeight = _T("");
	m_TextDepth = _T("");
	m_TextBorder = _T("");
	m_TextEdit = _T("");
	m_TextReduceVertices = FALSE;
	m_TextJoin = FALSE;
	m_TextFace = FALSE;
	m_TextExtrude = FALSE;
	m_TextFontName = _T("");
	m_LayerGroup = -1;
	m_TextLayerName = _T("");
	//}}AFX_DATA_INIT
}

CTextPage::~CTextPage()
{
}

void CTextPage::DoDataExchange(CDataExchange* pDX)
{
  CPropertyPage::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CTextPage)
  DDX_Check(pDX, IDC_TEXTCREATESTENCIL, m_TextCreateStencil);
  DDX_Check(pDX, IDC_TEXTPLUSCORE, m_TextPlusCore);
  DDX_Text(pDX, IDC_TEXTPOINTS, m_TextPoints);
  DDX_Text(pDX, IDC_TEXTHEIGHT, m_TextHeight);
  DDX_Text(pDX, IDC_TEXTDEPTH, m_TextDepth);
  DDX_Text(pDX, IDC_TEXTBORDER, m_TextBorder);
  DDX_Text(pDX, IDC_TEXTEDIT, m_TextEdit);
  DDX_Check(pDX, IDC_TEXTREDUCEVERTICES, m_TextReduceVertices);
  DDX_Check(pDX, IDC_TEXTJOIN, m_TextJoin);
  DDX_Check(pDX, IDC_TEXTFACE, m_TextFace);
  DDX_Check(pDX, IDC_TEXTEXTRUDE, m_TextExtrude);
  DDX_Text(pDX, IDC_TEXTFONTNAME, m_TextFontName);
  DDX_Radio(pDX, IDC_TEXTONELAYER, m_LayerGroup);
  DDX_Text(pDX, IDC_TEXTLAYERNAME, m_TextLayerName);
  //}}AFX_DATA_MAP
  DDX_Check(pDX, IDC_TEXTONCURVE, m_TextOnCurve);
  DDX_Check(pDX, IDC_TEXTORIGVERTS, m_TextOrigVerts);
  DDX_Check(pDX, IDC_TEXTALLCHARS, m_TextAllChars);
  DDX_Check(pDX, IDC_TEXTREVERSEOUTLINES, m_TextReverseOutlines);
  DDX_Text(pDX, IDC_TEXTUNICODEEDIT, m_TextUnicodeEdit);
}


BEGIN_MESSAGE_MAP(CTextPage, CPropertyPage)
	//{{AFX_MSG_MAP(CTextPage)
	ON_BN_CLICKED(IDC_TEXTSELECTFONT, OnTextselectfont)
	ON_BN_CLICKED(IDC_TEXTFONTDIRECTORY, OnTextfontdirectory)
	ON_BN_CLICKED(IDC_TEXTCREATESTENCIL, OnTextcreatestencil)
	ON_BN_CLICKED(IDC_TEXTPLUSCORE, OnTextpluscore)
	ON_BN_CLICKED(IDC_TEXTPOINTSDOWN, OnTextpointsdown)
	ON_BN_CLICKED(IDC_TEXTPOINTSUP, OnTextpointsup)
	ON_BN_CLICKED(IDC_TEXTREDUCEVERTICES, OnTextreducevertices)
	ON_BN_CLICKED(IDC_TEXTJOIN, OnTextjoin)
	ON_BN_CLICKED(IDC_TEXTFACE, OnTextface)
	ON_BN_CLICKED(IDC_TEXTEXTRUDE, OnTextextrude)
	ON_BN_CLICKED(IDC_CONVERTTEXT, OnConverttext)
	ON_BN_CLICKED(IDC_TEXTONELAYER, OnTextonelayer)
	ON_BN_CLICKED(IDC_TEXTMULTIPLELAYERS, OnTextmultiplelayers)
	ON_BN_CLICKED(IDC_APPLYBEVELS1, OnApplybevels1)
	ON_BN_CLICKED(IDC_APPLYBEVELS2, OnApplybevels2)
	ON_BN_CLICKED(IDC_APPLYBEVELS3, OnApplybevels3)
	ON_BN_CLICKED(IDC_TEXTMAKEBEVELSETS, OnTextmakebevelsets)
	ON_BN_CLICKED(IDC_TEXTSELECTLAYER, OnTextselectlayer)
  ON_BN_CLICKED(IDC_TRANSFEROUTLINES1, &CTextPage::OnTransferoutlines1)
  ON_BN_CLICKED(IDC_TRANSFEROUTLINES2, &CTextPage::OnTransferoutlines2)
  ON_BN_CLICKED(IDC_TRANSFEROUTLINES3, &CTextPage::OnTransferoutlines3)
	//}}AFX_MSG_MAP  
  ON_BN_CLICKED(IDC_TEXTPASTE, &CTextPage::OnBnClickedTextPaste)
  ON_BN_CLICKED(IDC_CONVERTUNICODETEXT, &CTextPage::OnBnClickedConvertUnicodeText)
  ON_BN_CLICKED(IDC_TEXTONCURVE, &CTextPage::OnBnClickedTextOnCurve)
  ON_BN_CLICKED(IDC_TEXTORIGVERTS, &CTextPage::OnBnClickedTextOrigVerts)
  ON_BN_CLICKED(IDC_TEXTALLCHARS, &CTextPage::OnBnClickedTextAllChars)
  ON_BN_CLICKED(IDC_TEXTREVERSEOUTLINES, &CTextPage::OnBnClickedTextReverseOutlines)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextPage message handlers

BOOL CTextPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	//
	m_TextFontName = at3dData->textFaceName;

	m_LayerGroup = (at3dData->textLayersFlag) ? 1 : 0;

	m_TextPoints.Format("%d", at3dData->textPoints);
	
	m_TextHeight.Format("%.2f", at3dData->textHeight);
	m_TextDepth.Format("%.2f", at3dData->textDepth);
	m_TextBorder.Format("%.2f", at3dData->textBorder);
	
  m_TextOnCurve   = (at3dData->textOnCurveFlag) ? 1 : 0;
  m_TextOrigVerts = (at3dData->textOrigVertsFlag) ? 1 : 0;
  m_TextAllChars  = (at3dData->textAllCharsFlag) ? 1 : 0;

  m_TextReverseOutlines = (at3dData->textReverseOutlinesFlag) ? 1 : 0;

	m_TextReduceVertices = (at3dData->textReduceFlag) ? 1 : 0;
	m_TextJoin = (at3dData->textJoinFlag) ? 1 : 0;
	m_TextFace = (at3dData->textFaceFlag) ? 1 : 0;
	m_TextExtrude = (at3dData->textExtrudeFlag) ? 1 : 0;
	
	m_TextEdit = at3dData->textText;
  m_TextUnicodeEdit = at3dData->textUnicodeText;
	
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTextPage::OnTextselectfont() 
{
	at3dData->SelectFont();
	m_TextFontName = at3dData->textFaceName;
	UpdateData(FALSE);
}

void CTextPage::OnTextfontdirectory() 
{
	at3dData->GetFontDirectory();
}

void CTextPage::OnTextcreatestencil() 
{
	UpdateData(TRUE);
	at3dData->textStencilFlag = (m_TextCreateStencil) ? 1 : 0;
}

void CTextPage::OnTextpluscore() 
{
	UpdateData(TRUE);
	at3dData->textPlusCoreFlag = (m_TextPlusCore) ? 1 : 0;
}

void CTextPage::OnTextpointsdown() 
{
	if (at3dData->textPoints > 3)
	{
		at3dData->textPoints--;
		m_TextPoints.Format("%d", at3dData->textPoints);
		UpdateData(FALSE);
	}
}

void CTextPage::OnTextpointsup() 
{
	at3dData->textPoints++;
  m_TextPoints.Format("%d", at3dData->textPoints);
	UpdateData(FALSE);
}

void CTextPage::OnTextreducevertices() 
{
	UpdateData(TRUE);
	at3dData->textReduceFlag = (m_TextReduceVertices) ? 1 : 0;
}

void CTextPage::OnTextjoin() 
{
	UpdateData(TRUE);
	at3dData->textJoinFlag = (m_TextJoin) ? 1 : 0;
}

void CTextPage::OnTextface() 
{
	UpdateData(TRUE);
	at3dData->textFaceFlag = (m_TextFace) ? 1 : 0;
}

void CTextPage::OnTextextrude() 
{
	UpdateData(TRUE);
	at3dData->textExtrudeFlag = (m_TextExtrude) ? 1 : 0;
}

void CTextPage::OnConverttext() 
{
	DoConvertText(0);
}

void CTextPage::OnBnClickedTextPaste()
{
  __int32 result = 0;

  if (OpenClipboard())
  {
    HANDLE hClipboardData = GetClipboardData(CF_UNICODETEXT);

    if (hClipboardData) 
    {  
      wchar_t* dataPtr = (wchar_t*)GlobalLock(hClipboardData);

      if (dataPtr)
      {
        my_wcscpy(at3dData->textUnicodeText, 256, dataPtr);
        result = 1;
      }
      
      GlobalUnlock(hClipboardData);
    }

    CloseClipboard();
  }

  if (result)
  {
    m_TextUnicodeEdit = at3dData->textUnicodeText;

    UpdateData(FALSE);
  }
}

void CTextPage::OnBnClickedConvertUnicodeText()
{
  DoConvertText(1);
}

void CTextPage::DoConvertText(__int32 unicodeFlag)
{
  UpdateData(TRUE);

  if (!unicodeFlag)
  {
    my_strncpy(at3dData->textText, 256, m_TextEdit, 255);
	  at3dData->textText[255] = '\0';
  }

  at3dData->textHeight = atof(m_TextHeight);
	at3dData->textDepth  = atof(m_TextDepth);
	at3dData->textBorder = atof(m_TextBorder);
	
	at3dData->ConvertText(unicodeFlag);
}

void CTextPage::OnTextonelayer() 
{
	at3dData->textLayersFlag = 0;
}

void CTextPage::OnTextmultiplelayers() 
{
	at3dData->textLayersFlag = 1;
}

void CTextPage::OnApplybevels1() 
{
	at3dData->ApplyBevels1();
}

void CTextPage::OnApplybevels2() 
{
	at3dData->ApplyBevels2();
}

void CTextPage::OnApplybevels3() 
{
	at3dData->ApplyBevels3();
}

void CTextPage::OnTextmakebevelsets() 
{
	at3dData->Text_MakeBevelSets();

  // display layer names with first layer in list selected first
  //
  if (at3dData->bevelSetsFlag)
  {
    at3dData->textNextLayer = At3d_GetNextLayer(0, at3dData->textName);
    m_TextLayerName = at3dData->textName;
		UpdateData(FALSE);
  }	
}

void CTextPage::OnTextselectlayer() 
{
	// get next layer in list
  //
  if (at3dData->bevelSetsFlag)
  {
    at3dData->textNextLayer = At3d_GetNextLayer(at3dData->textNextLayer, at3dData->textName);
    m_TextLayerName = at3dData->textName;
		UpdateData(FALSE);
  }
}

void CTextPage::OnTransferoutlines1()
{
  at3dData->Transfer_2D_Outlines(1);
}

void CTextPage::OnTransferoutlines2()
{
  at3dData->Transfer_2D_Outlines(2);
}

void CTextPage::OnTransferoutlines3()
{
  at3dData->Transfer_2D_Outlines(3);
}

void CTextPage::OnBnClickedTextOnCurve()
{
  UpdateData(TRUE);
  at3dData->textOnCurveFlag = (m_TextOnCurve) ? 1 : 0;

}

void CTextPage::OnBnClickedTextOrigVerts()
{
  UpdateData(TRUE);
  at3dData->textOrigVertsFlag = (m_TextOrigVerts) ? 1 : 0;
}

void CTextPage::OnBnClickedTextAllChars()
{
  UpdateData(TRUE);
  at3dData->textAllCharsFlag = (m_TextAllChars) ? 1 : 0;
}

void CTextPage::OnBnClickedTextReverseOutlines()
{
  UpdateData(TRUE);
  at3dData->textReverseOutlinesFlag = (m_TextReverseOutlines) ? 1 : 0;
}
