// Object: Redknight

#ifndef at3dTestData_H
#define at3dTestData_H

#define LEN_LAYER_NAME   80

typedef struct tag_TEST_XYZ {
  float x;
  float y;
  float z;
  } TEST_XYZ;

typedef struct tag_TEST_UV {
  float u;
  float v;
  } TEST_UV;

typedef struct tag_TEST_XYZ_UV {
  float x;
  float y;
  float z;
  float u;
  float v;
  } TEST_XYZ_UV;

typedef struct tag_TEST_NORMAL {
  float x;
  float y;
  float z;
  } TEST_NORMAL;

typedef struct tag_TEST_TRIANGLE1 {
  __int32 xyzIndex[3];
  TEST_UV uv[3];
  TEST_NORMAL normal[3];
  } TEST_TRIANGLE1;

typedef struct tag_TEST_TRIANGLE2 {
  __int32 xyzIndex[3];
  __int32 uvIndex[3];
  __int32 normalIndex[3];
  } TEST_TRIANGLE2;

typedef struct tag_TEST_TRIANGLE3 {
  __int32 xyz_uvIndex[3];
  __int32 normalIndex[3];
  } TEST_TRIANGLE3;

typedef struct tag_TEST_TRIANGLE4 {
  __int32 xyzIndex[3];
  __int32 uvIndex[3];
  __int32 normalIndex[3];
  __int32 materialIndex;
  } TEST_TRIANGLE4;
  
typedef struct tag_TEST_RGB {
  float red;
  float green;
  float blue; 
  } TEST_RGB;

typedef struct tag_TEST_MATERIAL {
  char name[LEN_LAYER_NAME];
  void* layerPtr;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_MATERIAL;
  
typedef struct tag_TEST_3D_DATA1 {
  char name[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_TRIANGLE1* triangle;
  __int32 uvFlag;
  __int32 normalFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA1;

typedef struct tag_TEST_3D_DATA2 {
  char name[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_UV* uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE2* triangle;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA2;

typedef struct tag_TEST_3D_DATA3 {
  char name[LEN_LAYER_NAME];
  __int32 xyz_uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ_UV* xyz_uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE3* triangle;
  __int32 uvFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA3;

  typedef struct tag_TEST_3D_DATA4 {
  char name[LEN_LAYER_NAME];
  float* matrix;
  __int32 xyz_uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ_UV* xyz_uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE3* triangle;
  __int32 uvFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA4;

typedef struct tag_TEST_3D_DATA5 {
  char name[LEN_LAYER_NAME];
  char parentName[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_UV* uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE4* triangle;
  __int32 tag;
  TEST_XYZ pivotPoint;
  } TEST_3D_DATA5;
  
#endif at3dTestData_H

__int32 Redknight_layerCount = 24;

TEST_XYZ Redknight_xyz_Head[8] = {
  { 0.03019f, -0.10915f, 0.35595f }, { 0.08019f, -0.00615f, 0.37595f },
  { -0.09181f, -0.00515f, 0.37595f }, { -0.04281f, -0.10915f, 0.35895f },
  { 0.04419f, -0.11315f, 0.57595f }, { 0.09519f, -0.00615f, 0.57595f },
  { -0.10681f, -0.00515f, 0.57595f }, { -0.05681f, -0.11215f, 0.57595f }
};

TEST_TRIANGLE1 Redknight_triangle1_Head[6] = {
  { { 0, 5, 1 }, { { 0.5977f, 0.3749f }, { 0.7753f, 0.6593f }, { 0.7339f, 0.4015f } },
    { { 0.902644f, -0.425031f, -0.067698f }, { 0.902644f, -0.425031f, -0.067698f }, { 0.902644f, -0.425031f, -0.067698f } } },
  { { 0, 4, 5 }, { { 0.5977f, 0.3749f }, { 0.6361f, 0.6593f }, { 0.7753f, 0.6593f } },
    { { 0.900788f, -0.429348f, -0.065129f }, { 0.900788f, -0.429348f, -0.065129f }, { 0.900788f, -0.429348f, -0.065129f } } },
  { { 7, 3, 2 }, { { 0.3613f, 0.6593f }, { 0.3997f, 0.3793f }, { 0.2661f, 0.4015f } },
    { { -0.906761f, -0.41672f, -0.064262f }, { -0.906761f, -0.41672f, -0.064262f }, { -0.906761f, -0.41672f, -0.064262f } } },
  { { 7, 2, 6 }, { { 0.3613f, 0.6593f }, { 0.2661f, 0.4015f }, { 0.2247f, 0.6593f } },
    { { -0.903883f, -0.422375f, -0.067791f }, { -0.903883f, -0.422375f, -0.067791f }, { -0.903883f, -0.422375f, -0.067791f } } },
  { { 3, 4, 0 }, { { 0.3997f, 0.3793f }, { 0.6361f, 0.6593f }, { 0.5977f, 0.3749f } },
    { { -0.000745f, -0.999835f, -0.018131f }, { -0.000745f, -0.999835f, -0.018131f }, { -0.000745f, -0.999835f, -0.018131f } } },
  { { 7, 4, 3 }, { { 0.3613f, 0.6593f }, { 0.6361f, 0.6593f }, { 0.3997f, 0.3793f } },
    { { -0.009899f, -0.999846f, -0.014461f }, { -0.009899f, -0.999846f, -0.014461f }, { -0.009899f, -0.999846f, -0.014461f } } }
};

TEST_XYZ Redknight_xyz_Head_1[24] = {
  { -0.02081f, 0.10756f, 0.66199f }, { -0.02081f, 0.08974f, 0.64286f },
  { -0.00712f, 0.13007f, 0.57459f }, { -0.00712f, 0.13401f, 0.57871f },
  { 0.01051f, 0.10756f, 0.66199f }, { 0.01051f, 0.08974f, 0.64286f },
  { -0.00318f, 0.13007f, 0.57459f }, { -0.00318f, 0.13401f, 0.57871f },
  { -0.018f, 0.03629f, 0.64042f }, { -0.018f, 0.04661f, 0.61622f },
  { -0.02081f, 0.12013f, 0.63817f }, { -0.02081f, 0.10981f, 0.66236f },
  { 0.0077f, 0.03629f, 0.64042f }, { 0.0077f, 0.04661f, 0.61622f },
  { 0.01051f, 0.12013f, 0.63817f }, { 0.01051f, 0.10981f, 0.66236f },
  { -0.01068f, 0.00159f, 0.56915f }, { -0.01068f, 0.00703f, 0.5639f },
  { -0.01725f, 0.0558f, 0.6226f }, { -0.01725f, 0.03666f, 0.64042f },
  { 0.00339f, 0.00159f, 0.56915f }, { 0.00339f, 0.00703f, 0.5639f },
  { 0.00976f, 0.0558f, 0.6226f }, { 0.00976f, 0.03666f, 0.64042f }
};

TEST_TRIANGLE1 Redknight_triangle1_Head_1[26] = {
  { { 1, 2, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.984178f, 0.129646f, -0.120768f }, { -0.984178f, 0.129646f, -0.120768f }, { -0.984178f, 0.129646f, -0.120768f } } },
  { { 0, 2, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.984432f, 0.12703f, -0.121481f }, { -0.984432f, 0.12703f, -0.121481f }, { -0.984432f, 0.12703f, -0.121481f } } },
  { { 5, 6, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -0.860989f, -0.508623f }, { 0.0f, -0.860989f, -0.508623f }, { 0.0f, -0.860989f, -0.508623f } } },
  { { 1, 6, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -0.860989f, -0.508623f }, { 0.0f, -0.860989f, -0.508623f }, { 0.0f, -0.860989f, -0.508623f } } },
  { { 2, 6, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 0.722717f, -0.691144f }, { 0.0f, 0.722717f, -0.691144f }, { 0.0f, 0.722717f, -0.691144f } } },
  { { 3, 2, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 0.722717f, -0.691144f }, { 0.0f, 0.722717f, -0.691144f }, { 0.0f, 0.722717f, -0.691144f } } },
  { { 3, 7, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 0.953085f, 0.302703f }, { 0.0f, 0.953085f, 0.302703f }, { 0.0f, 0.953085f, 0.302703f } } },
  { { 0, 3, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 0.953085f, 0.302703f }, { 0.0f, 0.953085f, 0.302703f }, { 0.0f, 0.953085f, 0.302703f } } },
  { { 7, 6, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.984432f, 0.12703f, -0.121481f }, { 0.984432f, 0.12703f, -0.121481f }, { 0.984432f, 0.12703f, -0.121481f } } },
  { { 6, 5, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.984178f, 0.129646f, -0.120768f }, { 0.984178f, 0.129646f, -0.120768f }, { 0.984178f, 0.129646f, -0.120768f } } },
  { { 10, 8, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999321f, -0.033881f, -0.014449f }, { -0.999321f, -0.033881f, -0.014449f }, { -0.999321f, -0.033881f, -0.014449f } } },
  { { 11, 8, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999321f, -0.033881f, -0.014455f }, { -0.999321f, -0.033881f, -0.014455f }, { -0.999321f, -0.033881f, -0.014455f } } },
  { { 14, 9, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 0.28608f, -0.958206f }, { 0.0f, 0.28608f, -0.958206f }, { 0.0f, 0.28608f, -0.958206f } } },
  { { 10, 9, 14 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 0.28608f, -0.958206f }, { 0.0f, 0.28608f, -0.958206f }, { 0.0f, 0.28608f, -0.958206f } } },
  { { 12, 11, 15 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -0.28596f, 0.958241f }, { 0.0f, -0.28596f, 0.958241f }, { 0.0f, -0.28596f, 0.958241f } } },
  { { 12, 8, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -0.28596f, 0.958241f }, { 0.0f, -0.28596f, 0.958241f }, { 0.0f, -0.28596f, 0.958241f } } },
  { { 12, 15, 14 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999321f, -0.033881f, -0.014455f }, { 0.999321f, -0.033881f, -0.014455f }, { 0.999321f, -0.033881f, -0.014455f } } },
  { { 14, 13, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999321f, -0.033881f, -0.014449f }, { 0.999321f, -0.033881f, -0.014449f }, { 0.999321f, -0.033881f, -0.014449f } } },
  { { 18, 16, 17 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.996294f, -0.059726f, -0.061888f }, { -0.996294f, -0.059726f, -0.061888f }, { -0.996294f, -0.059726f, -0.061888f } } },
  { { 19, 16, 18 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.99629f, -0.058642f, -0.062986f }, { -0.99629f, -0.058642f, -0.062986f }, { -0.99629f, -0.058642f, -0.062986f } } },
  { { 22, 17, 21 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 0.769166f, -0.639049f }, { 0.0f, 0.769166f, -0.639049f }, { 0.0f, 0.769166f, -0.639049f } } },
  { { 18, 17, 22 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 0.769166f, -0.639049f }, { 0.0f, 0.769166f, -0.639049f }, { 0.0f, 0.769166f, -0.639049f } } },
  { { 20, 19, 23 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -0.897254f, 0.441514f }, { 0.0f, -0.897254f, 0.441514f }, { 0.0f, -0.897254f, 0.441514f } } },
  { { 20, 16, 19 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -0.897254f, 0.441514f }, { 0.0f, -0.897254f, 0.441514f }, { 0.0f, -0.897254f, 0.441514f } } },
  { { 20, 23, 22 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.996511f, -0.05687f, -0.061082f }, { 0.996511f, -0.05687f, -0.061082f }, { 0.996511f, -0.05687f, -0.061082f } } },
  { { 22, 21, 20 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.996516f, -0.057921f, -0.060017f }, { 0.996516f, -0.057921f, -0.060017f }, { 0.996516f, -0.057921f, -0.060017f } } }
};

TEST_XYZ Redknight_xyz_Head_2[11] = {
  { 0.0799f, -0.00628f, 0.37615f }, { 0.04502f, 0.101f, 0.43748f },
  { -0.05589f, 0.10156f, 0.43748f }, { -0.09153f, -0.00516f, 0.37615f },
  { 0.04408f, -0.113f, 0.5759f }, { 0.0951f, -0.00628f, 0.5759f },
  { 0.04502f, 0.101f, 0.5759f }, { -0.05589f, 0.10156f, 0.5759f },
  { -0.10672f, -0.00516f, 0.5759f }, { -0.05664f, -0.11244f, 0.5759f },
  { -0.00581f, 0.01472f, 0.59297f }
};

TEST_TRIANGLE1 Redknight_triangle1_Head_2[12] = {
  { { 0, 6, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.950998f, 0.309198f, 0.0f }, { 0.950998f, 0.309198f, 0.0f }, { 0.950998f, 0.309198f, 0.0f } } },
  { { 5, 6, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.903985f, 0.421994f, -0.068789f }, { 0.903985f, 0.421994f, -0.068789f }, { 0.903985f, 0.421994f, -0.068789f } } },
  { { 1, 7, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.005549f, 0.999985f, 0.0f }, { 0.005549f, 0.999985f, 0.0f }, { 0.005549f, 0.999985f, 0.0f } } },
  { { 1, 6, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.005549f, 0.999985f, 0.0f }, { 0.005549f, 0.999985f, 0.0f }, { 0.005549f, 0.999985f, 0.0f } } },
  { { 2, 8, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.93315f, 0.352413f, -0.070961f }, { -0.93315f, 0.352413f, -0.070961f }, { -0.93315f, 0.352413f, -0.070961f } } },
  { { 2, 7, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.902825f, 0.430009f, 0.0f }, { -0.902825f, 0.430009f, 0.0f }, { -0.902825f, 0.430009f, 0.0f } } },
  { { 4, 10, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.151664f, -0.072507f, 0.985769f }, { 0.151664f, -0.072507f, 0.985769f }, { 0.151664f, -0.072507f, 0.985769f } } },
  { { 5, 10, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.183481f, 0.085652f, 0.979285f }, { 0.183481f, 0.085652f, 0.979285f }, { 0.183481f, 0.085652f, 0.979285f } } },
  { { 7, 6, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.001074f, 0.193473f, 0.981105f }, { 0.001074f, 0.193473f, 0.981105f }, { 0.001074f, 0.193473f, 0.981105f } } },
  { { 8, 7, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.18281f, 0.087071f, 0.979285f }, { -0.18281f, 0.087071f, 0.979285f }, { -0.18281f, 0.087071f, 0.979285f } } },
  { { 10, 9, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.152698f, -0.071282f, 0.985699f }, { -0.152698f, -0.071282f, 0.985699f }, { -0.152698f, -0.071282f, 0.985699f } } },
  { { 10, 4, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.000738f, -0.132757f, 0.991148f }, { -0.000738f, -0.132757f, 0.991148f }, { -0.000738f, -0.132757f, 0.991148f } } }
};

TEST_XYZ Redknight_xyz_Ll_arm[17] = {
  { 0.18372f, -0.02713f, -0.21774f }, { 0.18972f, 0.03187f, -0.21774f },
  { 0.23672f, 0.04387f, -0.21874f }, { 0.25872f, -0.00713f, -0.21974f },
  { 0.22672f, -0.04613f, -0.21874f }, { 0.15772f, -0.03313f, -0.04374f },
  { 0.17272f, 0.04887f, -0.04274f }, { 0.23672f, 0.06387f, -0.03774f },
  { 0.26772f, -0.00913f, -0.03574f }, { 0.22372f, -0.06313f, -0.05174f },
  { 0.16672f, -0.02713f, 0.02926f }, { 0.17372f, 0.03787f, 0.02926f },
  { 0.22572f, 0.04987f, 0.03526f }, { 0.25072f, -0.00713f, 0.03826f },
  { 0.21472f, -0.04913f, 0.03126f }, { 0.20872f, -0.00113f, 0.04826f },
  { 0.21872f, -0.00013f, -0.21874f }
};

TEST_TRIANGLE1 Redknight_triangle1_Ll_arm[30] = {
  { { 1, 6, 0 }, { { 0.4207f, 0.057f }, { 0.3746f, 0.3051f }, { 0.4038f, 0.057f } },
    { { -0.586319f, 0.499196f, -0.637992f }, { -0.715252f, 0.69862f, -0.018577f }, { -0.667489f, -0.388438f, -0.635275f } } },
  { { 0, 6, 5 }, { { 0.4038f, 0.057f }, { 0.3746f, 0.3051f }, { 0.3342f, 0.3035f } },
    { { -0.667489f, -0.388438f, -0.635275f }, { -0.715252f, 0.69862f, -0.018577f }, { -0.883702f, -0.467987f, -0.007708f } } },
  { { 2, 7, 1 }, { { 0.5482f, 0.0557f }, { 0.5492f, 0.312f }, { 0.4207f, 0.057f } },
    { { 0.354458f, 0.697712f, -0.622541f }, { 0.446169f, 0.8928f, 0.061986f }, { -0.586319f, 0.499196f, -0.637992f } } },
  { { 1, 7, 6 }, { { 0.4207f, 0.057f }, { 0.5492f, 0.312f }, { 0.3746f, 0.3051f } },
    { { -0.586319f, 0.499196f, -0.637992f }, { 0.446169f, 0.8928f, 0.061986f }, { -0.715252f, 0.69862f, -0.018577f } } },
  { { 3, 8, 2 }, { { 0.6101f, 0.0552f }, { 0.6336f, 0.3152f }, { 0.5482f, 0.0557f } },
    { { 0.763125f, -0.10543f, -0.637593f }, { 0.984388f, -0.14811f, 0.095098f }, { 0.354458f, 0.697712f, -0.622541f } } },
  { { 2, 8, 7 }, { { 0.5482f, 0.0557f }, { 0.6336f, 0.3152f }, { 0.5492f, 0.312f } },
    { { 0.354458f, 0.697712f, -0.622541f }, { 0.984388f, -0.14811f, 0.095098f }, { 0.446169f, 0.8928f, 0.061986f } } },
  { { 4, 9, 3 }, { { 0.5205f, 0.056f }, { 0.5139f, 0.2927f }, { 0.6101f, 0.0552f } },
    { { 0.183272f, -0.756948f, -0.627249f }, { 0.223661f, -0.97412f, 0.032635f }, { 0.763125f, -0.10543f, -0.637593f } } },
  { { 3, 9, 8 }, { { 0.6101f, 0.0552f }, { 0.5139f, 0.2927f }, { 0.6336f, 0.3152f } },
    { { 0.763125f, -0.10543f, -0.637593f }, { 0.223661f, -0.97412f, 0.032635f }, { 0.984388f, -0.14811f, 0.095098f } } },
  { { 0, 5, 4 }, { { 0.4038f, 0.057f }, { 0.3342f, 0.3035f }, { 0.5205f, 0.056f } },
    { { -0.667489f, -0.388438f, -0.635275f }, { -0.883702f, -0.467987f, -0.007708f }, { 0.183272f, -0.756948f, -0.627249f } } },
  { { 4, 5, 9 }, { { 0.5205f, 0.056f }, { 0.3342f, 0.3035f }, { 0.5139f, 0.2927f } },
    { { 0.183272f, -0.756948f, -0.627249f }, { -0.883702f, -0.467987f, -0.007708f }, { 0.223661f, -0.97412f, 0.032635f } } },
  { { 5, 6, 11 }, { { 0.3342f, 0.3035f }, { 0.3746f, 0.3051f }, { 0.3782f, 0.4069f } },
    { { -0.883702f, -0.467987f, -0.007708f }, { -0.715252f, 0.69862f, -0.018577f }, { -0.653475f, 0.539008f, 0.531452f } } },
  { { 5, 11, 10 }, { { 0.3342f, 0.3035f }, { 0.3782f, 0.4069f }, { 0.3593f, 0.4058f } },
    { { -0.883702f, -0.467987f, -0.007708f }, { -0.653475f, 0.539008f, 0.531452f }, { -0.734096f, -0.411962f, 0.539805f } } },
  { { 6, 7, 12 }, { { 0.3746f, 0.3051f }, { 0.5492f, 0.312f }, { 0.5195f, 0.4154f } },
    { { -0.715252f, 0.69862f, -0.018577f }, { 0.446169f, 0.8928f, 0.061986f }, { 0.305294f, 0.722051f, 0.620836f } } },
  { { 6, 12, 11 }, { { 0.3746f, 0.3051f }, { 0.5195f, 0.4154f }, { 0.3782f, 0.4069f } },
    { { -0.715252f, 0.69862f, -0.018577f }, { 0.305294f, 0.722051f, 0.620836f }, { -0.653475f, 0.539008f, 0.531452f } } },
  { { 7, 8, 13 }, { { 0.5492f, 0.312f }, { 0.6336f, 0.3152f }, { 0.5876f, 0.4194f } },
    { { 0.446169f, 0.8928f, 0.061986f }, { 0.984388f, -0.14811f, 0.095098f }, { 0.754278f, -0.134526f, 0.642626f } } },
  { { 7, 13, 12 }, { { 0.5492f, 0.312f }, { 0.5876f, 0.4194f }, { 0.5195f, 0.4154f } },
    { { 0.446169f, 0.8928f, 0.061986f }, { 0.754278f, -0.134526f, 0.642626f }, { 0.305294f, 0.722051f, 0.620836f } } },
  { { 8, 9, 14 }, { { 0.6336f, 0.3152f }, { 0.5139f, 0.2927f }, { 0.4893f, 0.4093f } },
    { { 0.984388f, -0.14811f, 0.095098f }, { 0.223661f, -0.97412f, 0.032635f }, { 0.125695f, -0.818616f, 0.560418f } } },
  { { 8, 14, 13 }, { { 0.6336f, 0.3152f }, { 0.4893f, 0.4093f }, { 0.5876f, 0.4194f } },
    { { 0.984388f, -0.14811f, 0.095098f }, { 0.125695f, -0.818616f, 0.560418f }, { 0.754278f, -0.134526f, 0.642626f } } },
  { { 5, 10, 9 }, { { 0.3342f, 0.3035f }, { 0.3593f, 0.4058f }, { 0.5139f, 0.2927f } },
    { { -0.883702f, -0.467987f, -0.007708f }, { -0.734096f, -0.411962f, 0.539805f }, { 0.223661f, -0.97412f, 0.032635f } } },
  { { 14, 9, 10 }, { { 0.4893f, 0.4093f }, { 0.5139f, 0.2927f }, { 0.3593f, 0.4058f } },
    { { 0.125695f, -0.818616f, 0.560418f }, { 0.223661f, -0.97412f, 0.032635f }, { -0.734096f, -0.411962f, 0.539805f } } },
  { { 1, 0, 16 }, { { 0.4207f, 0.057f }, { 0.4038f, 0.057f }, { 0.5005f, 0.0562f } },
    { { -0.586319f, 0.499196f, -0.637992f }, { -0.667489f, -0.388438f, -0.635275f }, { -0.026019f, 0.002915f, -0.999657f } } },
  { { 1, 16, 2 }, { { 0.4207f, 0.057f }, { 0.5005f, 0.0562f }, { 0.5482f, 0.0557f } },
    { { -0.586319f, 0.499196f, -0.637992f }, { -0.026019f, 0.002915f, -0.999657f }, { 0.354458f, 0.697712f, -0.622541f } } },
  { { 2, 16, 3 }, { { 0.5482f, 0.0557f }, { 0.5005f, 0.0562f }, { 0.6101f, 0.0552f } },
    { { 0.354458f, 0.697712f, -0.622541f }, { -0.026019f, 0.002915f, -0.999657f }, { 0.763125f, -0.10543f, -0.637593f } } },
  { { 3, 16, 4 }, { { 0.6101f, 0.0552f }, { 0.5005f, 0.0562f }, { 0.5205f, 0.056f } },
    { { 0.763125f, -0.10543f, -0.637593f }, { -0.026019f, 0.002915f, -0.999657f }, { 0.183272f, -0.756948f, -0.627249f } } },
  { { 4, 16, 0 }, { { 0.5205f, 0.056f }, { 0.5005f, 0.0562f }, { 0.4038f, 0.057f } },
    { { 0.183272f, -0.756948f, -0.627249f }, { -0.026019f, 0.002915f, -0.999657f }, { -0.667489f, -0.388438f, -0.635275f } } },
  { { 10, 11, 15 }, { { 0.3593f, 0.4058f }, { 0.3782f, 0.4069f }, { 0.4734f, 0.4334f } },
    { { -0.734096f, -0.411962f, 0.539805f }, { -0.653475f, 0.539008f, 0.531452f }, { -0.070711f, -0.032343f, 0.996972f } } },
  { { 11, 12, 15 }, { { 0.3782f, 0.4069f }, { 0.5195f, 0.4154f }, { 0.4734f, 0.4334f } },
    { { -0.653475f, 0.539008f, 0.531452f }, { 0.305294f, 0.722051f, 0.620836f }, { -0.070711f, -0.032343f, 0.996972f } } },
  { { 12, 13, 15 }, { { 0.5195f, 0.4154f }, { 0.5876f, 0.4194f }, { 0.4734f, 0.4334f } },
    { { 0.305294f, 0.722051f, 0.620836f }, { 0.754278f, -0.134526f, 0.642626f }, { -0.070711f, -0.032343f, 0.996972f } } },
  { { 13, 14, 15 }, { { 0.5876f, 0.4194f }, { 0.4893f, 0.4093f }, { 0.4734f, 0.4334f } },
    { { 0.754278f, -0.134526f, 0.642626f }, { 0.125695f, -0.818616f, 0.560418f }, { -0.070711f, -0.032343f, 0.996972f } } },
  { { 10, 15, 14 }, { { 0.3593f, 0.4058f }, { 0.4734f, 0.4334f }, { 0.4893f, 0.4093f } },
    { { -0.734096f, -0.411962f, 0.539805f }, { -0.070711f, -0.032343f, 0.996972f }, { 0.125695f, -0.818616f, 0.560418f } } }
};

TEST_XYZ Redknight_xyz_Ll_leg[12] = {
  { 0.03601f, 0.02635f, -0.6995f }, { 0.04089f, 0.02279f, -0.54008f },
  { 0.06714f, 0.08018f, -0.69613f }, { 0.06433f, 0.06349f, -0.53783f },
  { 0.12923f, 0.08018f, -0.69219f }, { 0.11103f, 0.06349f, -0.53483f },
  { 0.16017f, 0.02617f, -0.69125f }, { 0.13448f, 0.02279f, -0.53426f },
  { 0.12923f, -0.02766f, -0.69444f }, { 0.11103f, -0.0421f, -0.53558f },
  { 0.06714f, -0.02747f, -0.69856f }, { 0.06433f, -0.04192f, -0.53858f }
};

TEST_TRIANGLE1 Redknight_triangle1_Ll_leg[12] = {
  { { 0, 3, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999538f, -0.00131f, 0.030353f }, { -0.504395f, 0.859576f, 0.081943f }, { -0.997941f, 0.064087f, 0.002518f } } },
  { { 2, 3, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.502919f, 0.860456f, 0.081781f }, { -0.504395f, 0.859576f, 0.081943f }, { -0.999538f, -0.00131f, 0.030353f } } },
  { { 2, 5, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.502919f, 0.860456f, 0.081781f }, { 0.488918f, 0.859727f, 0.147747f }, { -0.504395f, 0.859576f, 0.081943f } } },
  { { 4, 5, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.490858f, 0.858653f, 0.14756f }, { 0.488918f, 0.859727f, 0.147747f }, { -0.502919f, 0.860456f, 0.081781f } } },
  { { 4, 7, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.490858f, 0.858653f, 0.14756f }, { 0.98296f, 0.084943f, 0.163017f }, { 0.488918f, 0.859727f, 0.147747f } } },
  { { 6, 7, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.991314f, 0.019255f, 0.130101f }, { 0.98296f, 0.084943f, 0.163017f }, { 0.490858f, 0.858653f, 0.14756f } } },
  { { 6, 9, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.991314f, 0.019255f, 0.130101f }, { 0.527797f, -0.849264f, 0.01343f }, { 0.98296f, 0.084943f, 0.163017f } } },
  { { 8, 9, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.521761f, -0.85291f, -0.017621f }, { 0.527797f, -0.849264f, 0.01343f }, { 0.991314f, 0.019255f, 0.130101f } } },
  { { 11, 9, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.544028f, -0.834736f, -0.085139f }, { 0.527797f, -0.849264f, 0.01343f }, { 0.521761f, -0.85291f, -0.017621f } } },
  { { 11, 8, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.544028f, -0.834736f, -0.085139f }, { 0.521761f, -0.85291f, -0.017621f }, { -0.539681f, -0.840341f, -0.050709f } } },
  { { 11, 10, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.544028f, -0.834736f, -0.085139f }, { -0.539681f, -0.840341f, -0.050709f }, { -0.997941f, 0.064087f, 0.002518f } } },
  { { 1, 10, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.997941f, 0.064087f, 0.002518f }, { -0.539681f, -0.840341f, -0.050709f }, { -0.999538f, -0.00131f, 0.030353f } } }
};

TEST_XYZ Redknight_xyz_Ll_leg_1[18] = {
  { 0.10878f, 0.03179f, -0.95139f }, { 0.07314f, 0.03179f, -0.95383f },
  { 0.03601f, 0.02635f, -0.6995f }, { 0.11178f, 0.03704f, -0.95121f },
  { 0.09396f, 0.06818f, -0.95158f }, { 0.06714f, 0.08018f, -0.69613f },
  { 0.11778f, 0.03704f, -0.95064f }, { 0.1356f, 0.06799f, -0.94895f },
  { 0.12923f, 0.08018f, -0.69219f }, { 0.12078f, 0.03179f, -0.95064f },
  { 0.15661f, 0.03179f, -0.9482f }, { 0.16017f, 0.02617f, -0.69125f },
  { 0.11778f, 0.02654f, -0.95102f }, { 0.1356f, -0.00422f, -0.95046f },
  { 0.12923f, -0.02766f, -0.69444f }, { 0.11178f, 0.02654f, -0.95139f },
  { 0.09396f, -0.00422f, -0.95327f }, { 0.06714f, -0.02748f, -0.69856f }
};

TEST_TRIANGLE1 Redknight_triangle1_Ll_leg_1[24] = {
  { { 0, 4, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.062213f, 0.028329f, -0.997661f }, { -0.343098f, 0.680558f, -0.647398f }, { -0.724555f, 0.014016f, -0.689075f } } },
  { { 3, 4, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.058559f, 0.01242f, -0.998207f }, { -0.343098f, 0.680558f, -0.647398f }, { 0.062213f, 0.028329f, -0.997661f } } },
  { { 1, 5, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.724555f, 0.014016f, -0.689075f }, { -0.492289f, 0.865477f, -0.092737f }, { -0.989519f, 0.003252f, -0.144365f } } },
  { { 1, 4, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.724555f, 0.014016f, -0.689075f }, { -0.343098f, 0.680558f, -0.647398f }, { -0.492289f, 0.865477f, -0.092737f } } },
  { { 3, 7, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.058559f, 0.01242f, -0.998207f }, { 0.425505f, 0.677144f, -0.600352f }, { -0.343098f, 0.680558f, -0.647398f } } },
  { { 6, 7, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.080423f, 0.013255f, -0.996673f }, { 0.425505f, 0.677144f, -0.600352f }, { 0.058559f, 0.01242f, -0.998207f } } },
  { { 5, 4, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.492289f, 0.865477f, -0.092737f }, { -0.343098f, 0.680558f, -0.647398f }, { 0.503058f, 0.863794f, -0.028148f } } },
  { { 8, 4, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.503058f, 0.863794f, -0.028148f }, { -0.343098f, 0.680558f, -0.647398f }, { 0.425505f, 0.677144f, -0.600352f } } },
  { { 6, 10, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.080423f, 0.013255f, -0.996673f }, { 0.809957f, 0.012607f, -0.586353f }, { 0.425505f, 0.677144f, -0.600352f } } },
  { { 9, 10, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.070204f, 0.031821f, -0.997025f }, { 0.809957f, 0.012607f, -0.586353f }, { 0.080423f, 0.013255f, -0.996673f } } },
  { { 8, 7, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.503058f, 0.863794f, -0.028148f }, { 0.425505f, 0.677144f, -0.600352f }, { 0.999897f, -0.000094f, -0.01433f } } },
  { { 11, 7, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999897f, -0.000094f, -0.01433f }, { 0.425505f, 0.677144f, -0.600352f }, { 0.809957f, 0.012607f, -0.586353f } } },
  { { 13, 10, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.424649f, -0.652087f, -0.628058f }, { 0.809957f, 0.012607f, -0.586353f }, { 0.070204f, 0.031821f, -0.997025f } } },
  { { 13, 9, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.424649f, -0.652087f, -0.628058f }, { 0.070204f, 0.031821f, -0.997025f }, { 0.071625f, 0.025047f, -0.997117f } } },
  { { 11, 10, 14 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999897f, -0.000094f, -0.01433f }, { 0.809957f, 0.012607f, -0.586353f }, { 0.502521f, -0.862051f, -0.065881f } } },
  { { 13, 14, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.424649f, -0.652087f, -0.628058f }, { 0.502521f, -0.862051f, -0.065881f }, { 0.809957f, 0.012607f, -0.586353f } } },
  { { 13, 12, 16 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.424649f, -0.652087f, -0.628058f }, { 0.071625f, 0.025047f, -0.997117f }, { -0.340245f, -0.651402f, -0.678166f } } },
  { { 16, 12, 15 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.340245f, -0.651402f, -0.678166f }, { 0.071625f, 0.025047f, -0.997117f }, { 0.064282f, 0.027583f, -0.997551f } } },
  { { 17, 14, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.49129f, -0.861146f, -0.130623f }, { 0.502521f, -0.862051f, -0.065881f }, { 0.424649f, -0.652087f, -0.628058f } } },
  { { 13, 16, 17 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.424649f, -0.652087f, -0.628058f }, { -0.340245f, -0.651402f, -0.678166f }, { -0.49129f, -0.861146f, -0.130623f } } },
  { { 16, 15, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.340245f, -0.651402f, -0.678166f }, { 0.064282f, 0.027583f, -0.997551f }, { -0.724555f, 0.014016f, -0.689075f } } },
  { { 1, 15, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.724555f, 0.014016f, -0.689075f }, { 0.064282f, 0.027583f, -0.997551f }, { 0.062213f, 0.028329f, -0.997661f } } },
  { { 17, 16, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.49129f, -0.861146f, -0.130623f }, { -0.340245f, -0.651402f, -0.678166f }, { -0.989519f, 0.003252f, -0.144365f } } },
  { { 2, 16, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.989519f, 0.003252f, -0.144365f }, { -0.340245f, -0.651402f, -0.678166f }, { -0.724555f, 0.014016f, -0.689075f } } }
};

TEST_XYZ Redknight_xyz_Lu_arm[27] = {
  { 0.17558f, -0.0397f, 0.03649f }, { 0.17058f, 0.0333f, 0.03649f },
  { 0.22258f, 0.0633f, 0.02449f }, { 0.25958f, 0.0053f, 0.03649f },
  { 0.23058f, -0.0447f, 0.03949f }, { 0.16958f, -0.0397f, 0.14749f },
  { 0.16058f, 0.0413f, 0.15349f }, { 0.22358f, 0.0733f, 0.15749f },
  { 0.27658f, 0.0063f, 0.14749f }, { 0.23258f, -0.0697f, 0.14149f },
  { 0.17558f, -0.0427f, 0.23149f }, { 0.17058f, 0.0333f, 0.23149f },
  { 0.22358f, 0.0633f, 0.23149f }, { 0.26058f, 0.0053f, 0.23149f },
  { 0.23158f, -0.0597f, 0.23149f }, { 0.16758f, -0.0517f, 0.28149f },
  { 0.16358f, 0.0403f, 0.28049f }, { 0.22458f, 0.0793f, 0.27649f },
  { 0.27258f, 0.0063f, 0.27649f }, { 0.23358f, -0.0697f, 0.27349f },
  { 0.17558f, -0.0467f, 0.31949f }, { 0.17558f, 0.0363f, 0.31949f },
  { 0.22358f, 0.0593f, 0.31949f }, { 0.26058f, 0.0063f, 0.31849f },
  { 0.23158f, -0.0557f, 0.31949f }, { 0.23758f, 0.0083f, 0.32749f },
  { 0.21758f, -0.0077f, 0.01249f }
};

TEST_TRIANGLE1 Redknight_triangle1_Lu_arm[50] = {
  { { 1, 6, 0 }, { { 0.3433f, 0.0332f }, { 0.3167f, 0.1965f }, { 0.3572f, 0.0332f } },
    { { -0.776577f, 0.385998f, -0.497929f }, { -0.876578f, 0.480634f, 0.024518f }, { -0.614542f, -0.623806f, -0.482912f } } },
  { { 0, 6, 5 }, { { 0.3572f, 0.0332f }, { 0.3167f, 0.1965f }, { 0.3408f, 0.1879f } },
    { { -0.614542f, -0.623806f, -0.482912f }, { -0.876578f, 0.480634f, 0.024518f }, { -0.813911f, -0.58022f, -0.029893f } } },
  { { 2, 7, 1 }, { { 0.4866f, 0.0157f }, { 0.4897f, 0.201f }, { 0.3433f, 0.0332f } },
    { { 0.161059f, 0.773151f, -0.613431f }, { 0.213476f, 0.976202f, 0.038175f }, { -0.776577f, 0.385998f, -0.497929f } } },
  { { 1, 7, 6 }, { { 0.3433f, 0.0332f }, { 0.4897f, 0.201f }, { 0.3167f, 0.1965f } },
    { { -0.776577f, 0.385998f, -0.497929f }, { 0.213476f, 0.976202f, 0.038175f }, { -0.876578f, 0.480634f, 0.024518f } } },
  { { 8, 2, 3 }, { { 0.6325f, 0.1879f }, { 0.4866f, 0.0157f }, { 0.5885f, 0.0332f } },
    { { 0.997343f, 0.0713f, 0.014909f }, { 0.161059f, 0.773151f, -0.613431f }, { 0.871544f, -0.010093f, -0.490213f } } },
  { { 8, 7, 2 }, { { 0.6325f, 0.1879f }, { 0.4897f, 0.201f }, { 0.4866f, 0.0157f } },
    { { 0.997343f, 0.0713f, 0.014909f }, { 0.213476f, 0.976202f, 0.038175f }, { 0.161059f, 0.773151f, -0.613431f } } },
  { { 9, 3, 4 }, { { 0.5148f, 0.1793f }, { 0.5885f, 0.0332f }, { 0.5086f, 0.0374f } },
    { { 0.290679f, -0.953197f, -0.083188f }, { 0.871544f, -0.010093f, -0.490213f }, { 0.380034f, -0.801082f, -0.46243f } } },
  { { 8, 3, 9 }, { { 0.6325f, 0.1879f }, { 0.5885f, 0.0332f }, { 0.5148f, 0.1793f } },
    { { 0.997343f, 0.0713f, 0.014909f }, { 0.871544f, -0.010093f, -0.490213f }, { 0.290679f, -0.953197f, -0.083188f } } },
  { { 0, 5, 4 }, { { 0.3572f, 0.0332f }, { 0.3408f, 0.1879f }, { 0.5086f, 0.0374f } },
    { { -0.614542f, -0.623806f, -0.482912f }, { -0.813911f, -0.58022f, -0.029893f }, { 0.380034f, -0.801082f, -0.46243f } } },
  { { 9, 4, 5 }, { { 0.5148f, 0.1793f }, { 0.5086f, 0.0374f }, { 0.3408f, 0.1879f } },
    { { 0.290679f, -0.953197f, -0.083188f }, { 0.380034f, -0.801082f, -0.46243f }, { -0.813911f, -0.58022f, -0.029893f } } },
  { { 5, 6, 11 }, { { 0.3408f, 0.1879f }, { 0.3167f, 0.1965f }, { 0.3454f, 0.305f } },
    { { -0.813911f, -0.58022f, -0.029893f }, { -0.876578f, 0.480634f, 0.024518f }, { -0.89516f, 0.444328f, -0.035524f } } },
  { { 5, 11, 10 }, { { 0.3408f, 0.1879f }, { 0.3454f, 0.305f }, { 0.3592f, 0.305f } },
    { { -0.813911f, -0.58022f, -0.029893f }, { -0.89516f, 0.444328f, -0.035524f }, { -0.790587f, -0.607362f, -0.077996f } } },
  { { 6, 7, 12 }, { { 0.3167f, 0.1965f }, { 0.4897f, 0.201f }, { 0.4887f, 0.305f } },
    { { -0.876578f, 0.480634f, 0.024518f }, { 0.213476f, 0.976202f, 0.038175f }, { 0.265434f, 0.957685f, -0.111282f } } },
  { { 6, 12, 11 }, { { 0.3167f, 0.1965f }, { 0.4887f, 0.305f }, { 0.3454f, 0.305f } },
    { { -0.876578f, 0.480634f, 0.024518f }, { 0.265434f, 0.957685f, -0.111282f }, { -0.89516f, 0.444328f, -0.035524f } } },
  { { 8, 13, 7 }, { { 0.6325f, 0.1879f }, { 0.591f, 0.305f }, { 0.4897f, 0.201f } },
    { { 0.997343f, 0.0713f, 0.014909f }, { 0.996072f, 0.076781f, -0.044111f }, { 0.213476f, 0.976202f, 0.038175f } } },
  { { 7, 13, 12 }, { { 0.4897f, 0.201f }, { 0.591f, 0.305f }, { 0.4887f, 0.305f } },
    { { 0.213476f, 0.976202f, 0.038175f }, { 0.996072f, 0.076781f, -0.044111f }, { 0.265434f, 0.957685f, -0.111282f } } },
  { { 8, 9, 14 }, { { 0.6325f, 0.1879f }, { 0.5148f, 0.1793f }, { 0.5107f, 0.305f } },
    { { 0.997343f, 0.0713f, 0.014909f }, { 0.290679f, -0.953197f, -0.083188f }, { 0.420901f, -0.905841f, -0.047899f } } },
  { { 14, 13, 8 }, { { 0.5107f, 0.305f }, { 0.591f, 0.305f }, { 0.6325f, 0.1879f } },
    { { 0.420901f, -0.905841f, -0.047899f }, { 0.996072f, 0.076781f, -0.044111f }, { 0.997343f, 0.0713f, 0.014909f } } },
  { { 5, 10, 9 }, { { 0.3408f, 0.1879f }, { 0.3592f, 0.305f }, { 0.5148f, 0.1793f } },
    { { -0.813911f, -0.58022f, -0.029893f }, { -0.790587f, -0.607362f, -0.077996f }, { 0.290679f, -0.953197f, -0.083188f } } },
  { { 9, 10, 14 }, { { 0.5148f, 0.1793f }, { 0.3592f, 0.305f }, { 0.5107f, 0.305f } },
    { { 0.290679f, -0.953197f, -0.083188f }, { -0.790587f, -0.607362f, -0.077996f }, { 0.420901f, -0.905841f, -0.047899f } } },
  { { 10, 11, 16 }, { { 0.3592f, 0.305f }, { 0.3454f, 0.305f }, { 0.3249f, 0.3724f } },
    { { -0.790587f, -0.607362f, -0.077996f }, { -0.89516f, 0.444328f, -0.035524f }, { -0.878782f, 0.472168f, 0.069274f } } },
  { { 10, 16, 15 }, { { 0.3592f, 0.305f }, { 0.3249f, 0.3724f }, { 0.3367f, 0.3743f } },
    { { -0.790587f, -0.607362f, -0.077996f }, { -0.878782f, 0.472168f, 0.069274f }, { -0.784438f, -0.619895f, 0.019691f } } },
  { { 11, 12, 17 }, { { 0.3454f, 0.305f }, { 0.4887f, 0.305f }, { 0.4907f, 0.3675f } },
    { { -0.89516f, 0.444328f, -0.035524f }, { 0.265434f, 0.957685f, -0.111282f }, { 0.19482f, 0.979976f, 0.04113f } } },
  { { 11, 17, 16 }, { { 0.3454f, 0.305f }, { 0.4907f, 0.3675f }, { 0.3249f, 0.3724f } },
    { { -0.89516f, 0.444328f, -0.035524f }, { 0.19482f, 0.979976f, 0.04113f }, { -0.878782f, 0.472168f, 0.069274f } } },
  { { 12, 13, 18 }, { { 0.4887f, 0.305f }, { 0.591f, 0.305f }, { 0.6222f, 0.3678f } },
    { { 0.265434f, 0.957685f, -0.111282f }, { 0.996072f, 0.076781f, -0.044111f }, { 0.998321f, 0.057683f, 0.00528f } } },
  { { 12, 18, 17 }, { { 0.4887f, 0.305f }, { 0.6222f, 0.3678f }, { 0.4907f, 0.3675f } },
    { { 0.265434f, 0.957685f, -0.111282f }, { 0.998321f, 0.057683f, 0.00528f }, { 0.19482f, 0.979976f, 0.04113f } } },
  { { 14, 19, 13 }, { { 0.5107f, 0.305f }, { 0.5173f, 0.3633f }, { 0.591f, 0.305f } },
    { { 0.420901f, -0.905841f, -0.047899f }, { 0.396933f, -0.917834f, -0.005111f }, { 0.996072f, 0.076781f, -0.044111f } } },
  { { 13, 19, 18 }, { { 0.591f, 0.305f }, { 0.5173f, 0.3633f }, { 0.6222f, 0.3678f } },
    { { 0.996072f, 0.076781f, -0.044111f }, { 0.396933f, -0.917834f, -0.005111f }, { 0.998321f, 0.057683f, 0.00528f } } },
  { { 10, 15, 14 }, { { 0.3592f, 0.305f }, { 0.3367f, 0.3743f }, { 0.5107f, 0.305f } },
    { { -0.790587f, -0.607362f, -0.077996f }, { -0.784438f, -0.619895f, 0.019691f }, { 0.420901f, -0.905841f, -0.047899f } } },
  { { 14, 15, 19 }, { { 0.5107f, 0.305f }, { 0.3367f, 0.3743f }, { 0.5173f, 0.3633f } },
    { { 0.420901f, -0.905841f, -0.047899f }, { -0.784438f, -0.619895f, 0.019691f }, { 0.396933f, -0.917834f, -0.005111f } } },
  { { 15, 16, 21 }, { { 0.3367f, 0.3743f }, { 0.3249f, 0.3724f }, { 0.3582f, 0.4276f } },
    { { -0.784438f, -0.619895f, 0.019691f }, { -0.878782f, 0.472168f, 0.069274f }, { -0.61469f, 0.395168f, 0.682641f } } },
  { { 15, 21, 20 }, { { 0.3367f, 0.3743f }, { 0.3582f, 0.4276f }, { 0.3572f, 0.4276f } },
    { { -0.784438f, -0.619895f, 0.019691f }, { -0.61469f, 0.395168f, 0.682641f }, { -0.57846f, -0.479419f, 0.659956f } } },
  { { 16, 17, 22 }, { { 0.3249f, 0.3724f }, { 0.4907f, 0.3675f }, { 0.4882f, 0.4276f } },
    { { -0.878782f, 0.472168f, 0.069274f }, { 0.19482f, 0.979976f, 0.04113f }, { 0.179629f, 0.69462f, 0.696589f } } },
  { { 16, 22, 21 }, { { 0.3249f, 0.3724f }, { 0.4882f, 0.4276f }, { 0.3582f, 0.4276f } },
    { { -0.878782f, 0.472168f, 0.069274f }, { 0.179629f, 0.69462f, 0.696589f }, { -0.61469f, 0.395168f, 0.682641f } } },
  { { 17, 18, 23 }, { { 0.4907f, 0.3675f }, { 0.6222f, 0.3678f }, { 0.5895f, 0.4258f } },
    { { 0.19482f, 0.979976f, 0.04113f }, { 0.998321f, 0.057683f, 0.00528f }, { 0.791271f, 0.061681f, 0.608347f } } },
  { { 17, 23, 22 }, { { 0.4907f, 0.3675f }, { 0.5895f, 0.4258f }, { 0.4882f, 0.4276f } },
    { { 0.19482f, 0.979976f, 0.04113f }, { 0.791271f, 0.061681f, 0.608347f }, { 0.179629f, 0.69462f, 0.696589f } } },
  { { 18, 19, 24 }, { { 0.6222f, 0.3678f }, { 0.5173f, 0.3633f }, { 0.5122f, 0.4276f } },
    { { 0.998321f, 0.057683f, 0.00528f }, { 0.396933f, -0.917834f, -0.005111f }, { 0.35779f, -0.653324f, 0.667199f } } },
  { { 18, 24, 23 }, { { 0.6222f, 0.3678f }, { 0.5122f, 0.4276f }, { 0.5895f, 0.4258f } },
    { { 0.998321f, 0.057683f, 0.00528f }, { 0.35779f, -0.653324f, 0.667199f }, { 0.791271f, 0.061681f, 0.608347f } } },
  { { 15, 20, 19 }, { { 0.3367f, 0.3743f }, { 0.3572f, 0.4276f }, { 0.5173f, 0.3633f } },
    { { -0.784438f, -0.619895f, 0.019691f }, { -0.57846f, -0.479419f, 0.659956f }, { 0.396933f, -0.917834f, -0.005111f } } },
  { { 19, 20, 24 }, { { 0.5173f, 0.3633f }, { 0.3572f, 0.4276f }, { 0.5122f, 0.4276f } },
    { { 0.396933f, -0.917834f, -0.005111f }, { -0.57846f, -0.479419f, 0.659956f }, { 0.35779f, -0.653324f, 0.667199f } } },
  { { 1, 0, 26 }, { { 0.3433f, 0.0332f }, { 0.3572f, 0.0332f }, { 0.4723f, 0.0f } },
    { { -0.776577f, 0.385998f, -0.497929f }, { -0.614542f, -0.623806f, -0.482912f }, { 0.069367f, -0.172595f, -0.982547f } } },
  { { 1, 26, 2 }, { { 0.3433f, 0.0332f }, { 0.4723f, 0.0f }, { 0.4866f, 0.0157f } },
    { { -0.776577f, 0.385998f, -0.497929f }, { 0.069367f, -0.172595f, -0.982547f }, { 0.161059f, 0.773151f, -0.613431f } } },
  { { 2, 26, 3 }, { { 0.4866f, 0.0157f }, { 0.4723f, 0.0f }, { 0.5885f, 0.0332f } },
    { { 0.161059f, 0.773151f, -0.613431f }, { 0.069367f, -0.172595f, -0.982547f }, { 0.871544f, -0.010093f, -0.490213f } } },
  { { 3, 26, 4 }, { { 0.5885f, 0.0332f }, { 0.4723f, 0.0f }, { 0.5086f, 0.0374f } },
    { { 0.871544f, -0.010093f, -0.490213f }, { 0.069367f, -0.172595f, -0.982547f }, { 0.380034f, -0.801082f, -0.46243f } } },
  { { 4, 26, 0 }, { { 0.5086f, 0.0374f }, { 0.4723f, 0.0f }, { 0.3572f, 0.0332f } },
    { { 0.380034f, -0.801082f, -0.46243f }, { 0.069367f, -0.172595f, -0.982547f }, { -0.614542f, -0.623806f, -0.482912f } } },
  { { 20, 21, 25 }, { { 0.3572f, 0.4276f }, { 0.3582f, 0.4276f }, { 0.526f, 0.4386f } },
    { { -0.57846f, -0.479419f, 0.659956f }, { -0.61469f, 0.395168f, 0.682641f }, { 0.169825f, 0.041908f, 0.984583f } } },
  { { 21, 22, 25 }, { { 0.3582f, 0.4276f }, { 0.4882f, 0.4276f }, { 0.526f, 0.4386f } },
    { { -0.61469f, 0.395168f, 0.682641f }, { 0.179629f, 0.69462f, 0.696589f }, { 0.169825f, 0.041908f, 0.984583f } } },
  { { 22, 23, 25 }, { { 0.4882f, 0.4276f }, { 0.5895f, 0.4258f }, { 0.526f, 0.4386f } },
    { { 0.179629f, 0.69462f, 0.696589f }, { 0.791271f, 0.061681f, 0.608347f }, { 0.169825f, 0.041908f, 0.984583f } } },
  { { 23, 24, 25 }, { { 0.5895f, 0.4258f }, { 0.5122f, 0.4276f }, { 0.526f, 0.4386f } },
    { { 0.791271f, 0.061681f, 0.608347f }, { 0.35779f, -0.653324f, 0.667199f }, { 0.169825f, 0.041908f, 0.984583f } } },
  { { 20, 25, 24 }, { { 0.3572f, 0.4276f }, { 0.526f, 0.4386f }, { 0.5122f, 0.4276f } },
    { { -0.57846f, -0.479419f, 0.659956f }, { 0.169825f, 0.041908f, 0.984583f }, { 0.35779f, -0.653324f, 0.667199f } } }
};

TEST_XYZ Redknight_xyz_Lu_leg[18] = {
  { -0.00713f, 0.01923f, -0.21841f }, { 0.03995f, 0.02504f, -0.54551f },
  { 0.01031f, 0.0211f, -0.32738f }, { 0.02907f, 0.08206f, -0.21485f },
  { 0.06339f, 0.06574f, -0.54326f }, { 0.04145f, 0.09463f, -0.32401f },
  { 0.10128f, 0.08206f, -0.21035f }, { 0.11009f, 0.06555f, -0.54007f },
  { 0.10334f, 0.09444f, -0.31988f }, { 0.13748f, 0.01904f, -0.20903f },
  { 0.13354f, 0.02485f, -0.53932f }, { 0.13448f, 0.0211f, -0.31913f },
  { 0.10128f, -0.04361f, -0.21241f }, { 0.10991f, -0.03985f, -0.54045f },
  { 0.10259f, -0.0588f, -0.30975f }, { 0.02907f, -0.04342f, -0.2171f },
  { 0.0632f, -0.03985f, -0.54345f }, { 0.04145f, -0.06499f, -0.32682f }
};

TEST_TRIANGLE1 Redknight_triangle1_Lu_leg[24] = {
  { { 1, 5, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.985105f, 0.08113f, -0.151611f }, { -0.523779f, 0.850052f, -0.055376f }, { -0.99043f, 0.040696f, -0.131882f } } },
  { { 4, 5, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.49642f, 0.852794f, -0.162204f }, { -0.523779f, 0.850052f, -0.055376f }, { -0.985105f, 0.08113f, -0.151611f } } },
  { { 2, 3, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.99043f, 0.040696f, -0.131882f }, { -0.547496f, 0.836808f, 0.000947f }, { -0.993019f, 0.039124f, -0.111273f } } },
  { { 2, 5, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.99043f, 0.040696f, -0.131882f }, { -0.523779f, 0.850052f, -0.055376f }, { -0.547496f, 0.836808f, 0.000947f } } },
  { { 4, 8, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.49642f, 0.852794f, -0.162204f }, { 0.524301f, 0.851516f, -0.005315f }, { -0.523779f, 0.850052f, -0.055376f } } },
  { { 7, 8, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.529175f, 0.845265f, -0.074168f }, { 0.524301f, 0.851516f, -0.005315f }, { -0.49642f, 0.852794f, -0.162204f } } },
  { { 3, 5, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.547496f, 0.836808f, 0.000947f }, { -0.523779f, 0.850052f, -0.055376f }, { 0.519017f, 0.848146f, 0.106159f } } },
  { { 5, 8, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.523779f, 0.850052f, -0.055376f }, { 0.524301f, 0.851516f, -0.005315f }, { 0.519017f, 0.848146f, 0.106159f } } },
  { { 7, 11, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.529175f, 0.845265f, -0.074168f }, { 0.999978f, 0.002355f, -0.006126f }, { 0.524301f, 0.851516f, -0.005315f } } },
  { { 10, 11, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.99618f, 0.087294f, 0.002092f }, { 0.999978f, 0.002355f, -0.006126f }, { 0.529175f, 0.845265f, -0.074168f } } },
  { { 6, 8, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.519017f, 0.848146f, 0.106159f }, { 0.524301f, 0.851516f, -0.005315f }, { 0.999691f, -0.024763f, 0.001932f } } },
  { { 9, 8, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999691f, -0.024763f, 0.001932f }, { 0.524301f, 0.851516f, -0.005315f }, { 0.999978f, 0.002355f, -0.006126f } } },
  { { 10, 14, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.99618f, 0.087294f, 0.002092f }, { 0.569615f, -0.819422f, 0.063918f }, { 0.999978f, 0.002355f, -0.006126f } } },
  { { 13, 14, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.591277f, -0.803951f, -0.063681f }, { 0.569615f, -0.819422f, 0.063918f }, { 0.99618f, 0.087294f, 0.002092f } } },
  { { 9, 11, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999691f, -0.024763f, 0.001932f }, { 0.999978f, 0.002355f, -0.006126f }, { 0.559479f, -0.823844f, 0.090914f } } },
  { { 12, 11, 14 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.559479f, -0.823844f, 0.090914f }, { 0.999978f, 0.002355f, -0.006126f }, { 0.569615f, -0.819422f, 0.063918f } } },
  { { 17, 14, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.498833f, -0.865719f, -0.041191f }, { 0.569615f, -0.819422f, 0.063918f }, { 0.591277f, -0.803951f, -0.063681f } } },
  { { 17, 13, 16 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.498833f, -0.865719f, -0.041191f }, { 0.591277f, -0.803951f, -0.063681f }, { -0.575683f, -0.803605f, -0.151027f } } },
  { { 12, 14, 15 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.559479f, -0.823844f, 0.090914f }, { 0.569615f, -0.819422f, 0.063918f }, { -0.535713f, -0.839444f, 0.091359f } } },
  { { 17, 15, 14 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.498833f, -0.865719f, -0.041191f }, { -0.535713f, -0.839444f, 0.091359f }, { 0.569615f, -0.819422f, 0.063918f } } },
  { { 17, 16, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.498833f, -0.865719f, -0.041191f }, { -0.575683f, -0.803605f, -0.151027f }, { -0.99043f, 0.040696f, -0.131882f } } },
  { { 2, 16, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.99043f, 0.040696f, -0.131882f }, { -0.575683f, -0.803605f, -0.151027f }, { -0.985105f, 0.08113f, -0.151611f } } },
  { { 15, 17, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.535713f, -0.839444f, 0.091359f }, { -0.498833f, -0.865719f, -0.041191f }, { -0.993019f, 0.039124f, -0.111273f } } },
  { { 0, 17, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.993019f, 0.039124f, -0.111273f }, { -0.498833f, -0.865719f, -0.041191f }, { -0.99043f, 0.040696f, -0.131882f } } }
};

TEST_XYZ Redknight_xyz_L_fingers[14] = {
  { 0.31784f, -0.15913f, -0.05273f }, { 0.26984f, -0.20213f, -0.29873f },
  { 0.26984f, -0.04113f, -0.65773f }, { 0.26984f, 0.05287f, -0.65973f },
  { 0.26984f, 0.20487f, -0.30473f }, { 0.26984f, 0.13687f, -0.05173f },
  { 0.32084f, -0.14613f, -0.05373f }, { 0.29384f, -0.20213f, -0.29873f },
  { 0.29384f, -0.04113f, -0.66073f }, { 0.29384f, 0.05987f, -0.65973f },
  { 0.29384f, 0.20487f, -0.30473f }, { 0.29384f, 0.13687f, -0.05173f },
  { 0.34284f, 0.00187f, -0.30173f }, { 0.31984f, 0.00187f, -0.30173f }
};

TEST_TRIANGLE1 Redknight_triangle1_L_fingers[24] = {
  { { 0, 7, 1 }, { { 0.6093f, 0.7846f }, { 0.5426f, 0.4669f }, { 0.4792f, 0.4669f } },
    { { -0.019797f, -0.819049f, 0.573382f }, { 0.553377f, -0.823884f, -0.122431f }, { -0.741897f, -0.670095f, -0.023703f } } },
  { { 7, 0, 6 }, { { 0.5426f, 0.4669f }, { 0.6093f, 0.7846f }, { 0.617f, 0.7828f } },
    { { 0.553377f, -0.823884f, -0.122431f }, { -0.019797f, -0.819049f, 0.573382f }, { 0.797365f, -0.070351f, 0.599382f } } },
  { { 1, 8, 2 }, { { 0.4792f, 0.4669f }, { 0.5426f, 0.0f }, { 0.4792f, 0.0044f } },
    { { -0.741897f, -0.670095f, -0.023703f }, { 0.518008f, -0.439322f, -0.733937f }, { -0.68011f, -0.420522f, -0.60051f } } },
  { { 1, 7, 8 }, { { 0.4792f, 0.4669f }, { 0.5426f, 0.4669f }, { 0.5426f, 0.0f } },
    { { -0.741897f, -0.670095f, -0.023703f }, { 0.553377f, -0.823884f, -0.122431f }, { 0.518008f, -0.439322f, -0.733937f } } },
  { { 2, 9, 3 }, { { 0.4792f, 0.0044f }, { 0.5426f, 0.0008f }, { 0.4792f, 0.0008f } },
    { { -0.68011f, -0.420522f, -0.60051f }, { 0.486445f, 0.524774f, -0.698559f }, { -0.687242f, 0.342016f, -0.640876f } } },
  { { 2, 8, 9 }, { { 0.4792f, 0.0044f }, { 0.5426f, 0.0f }, { 0.5426f, 0.0008f } },
    { { -0.68011f, -0.420522f, -0.60051f }, { 0.518008f, -0.439322f, -0.733937f }, { 0.486445f, 0.524774f, -0.698559f } } },
  { { 3, 10, 4 }, { { 0.4792f, 0.0008f }, { 0.5426f, 0.4594f }, { 0.4792f, 0.4594f } },
    { { -0.687242f, 0.342016f, -0.640876f }, { 0.56188f, 0.825301f, -0.056302f }, { -0.713053f, 0.699233f, -0.051273f } } },
  { { 3, 9, 10 }, { { 0.4792f, 0.0008f }, { 0.5426f, 0.0008f }, { 0.5426f, 0.4594f } },
    { { -0.687242f, 0.342016f, -0.640876f }, { 0.486445f, 0.524774f, -0.698559f }, { 0.56188f, 0.825301f, -0.056302f } } },
  { { 4, 11, 5 }, { { 0.4792f, 0.4594f }, { 0.5426f, 0.7854f }, { 0.4792f, 0.7854f } },
    { { -0.713053f, 0.699233f, -0.051273f }, { 0.527413f, 0.524688f, 0.668235f }, { -0.662404f, 0.429327f, 0.613921f } } },
  { { 4, 10, 11 }, { { 0.4792f, 0.4594f }, { 0.5426f, 0.4594f }, { 0.5426f, 0.7854f } },
    { { -0.713053f, 0.699233f, -0.051273f }, { 0.56188f, 0.825301f, -0.056302f }, { 0.527413f, 0.524688f, 0.668235f } } },
  { { 6, 0, 5 }, { { 0.617f, 0.7828f }, { 0.6093f, 0.7846f }, { 0.4792f, 0.7854f } },
    { { 0.797365f, -0.070351f, 0.599382f }, { -0.019797f, -0.819049f, 0.573382f }, { -0.662404f, 0.429327f, 0.613921f } } },
  { { 6, 5, 11 }, { { 0.617f, 0.7828f }, { 0.4792f, 0.7854f }, { 0.5426f, 0.7854f } },
    { { 0.797365f, -0.070351f, 0.599382f }, { -0.662404f, 0.429327f, 0.613921f }, { 0.527413f, 0.524688f, 0.668235f } } },
  { { 0, 1, 13 }, { { 0.6093f, 0.7846f }, { 0.4792f, 0.4669f }, { 0.6132f, 0.463f } },
    { { -0.019797f, -0.819049f, 0.573382f }, { -0.741897f, -0.670095f, -0.023703f }, { -0.998447f, -0.02883f, 0.047678f } } },
  { { 13, 1, 2 }, { { 0.6132f, 0.463f }, { 0.4792f, 0.4669f }, { 0.4792f, 0.0044f } },
    { { -0.998447f, -0.02883f, 0.047678f }, { -0.741897f, -0.670095f, -0.023703f }, { -0.68011f, -0.420522f, -0.60051f } } },
  { { 2, 3, 13 }, { { 0.4792f, 0.0044f }, { 0.4792f, 0.0008f }, { 0.6132f, 0.463f } },
    { { -0.68011f, -0.420522f, -0.60051f }, { -0.687242f, 0.342016f, -0.640876f }, { -0.998447f, -0.02883f, 0.047678f } } },
  { { 3, 4, 13 }, { { 0.4792f, 0.0008f }, { 0.4792f, 0.4594f }, { 0.6132f, 0.463f } },
    { { -0.687242f, 0.342016f, -0.640876f }, { -0.713053f, 0.699233f, -0.051273f }, { -0.998447f, -0.02883f, 0.047678f } } },
  { { 4, 5, 13 }, { { 0.4792f, 0.4594f }, { 0.4792f, 0.7854f }, { 0.6132f, 0.463f } },
    { { -0.713053f, 0.699233f, -0.051273f }, { -0.662404f, 0.429327f, 0.613921f }, { -0.998447f, -0.02883f, 0.047678f } } },
  { { 5, 0, 13 }, { { 0.4792f, 0.7854f }, { 0.6093f, 0.7846f }, { 0.6132f, 0.463f } },
    { { -0.662404f, 0.429327f, 0.613921f }, { -0.019797f, -0.819049f, 0.573382f }, { -0.998447f, -0.02883f, 0.047678f } } },
  { { 7, 6, 12 }, { { 0.5426f, 0.4669f }, { 0.617f, 0.7828f }, { 0.6772f, 0.463f } },
    { { 0.553377f, -0.823884f, -0.122431f }, { 0.797365f, -0.070351f, 0.599382f }, { 0.999547f, 0.015114f, -0.026039f } } },
  { { 7, 12, 8 }, { { 0.5426f, 0.4669f }, { 0.6772f, 0.463f }, { 0.5426f, 0.0f } },
    { { 0.553377f, -0.823884f, -0.122431f }, { 0.999547f, 0.015114f, -0.026039f }, { 0.518008f, -0.439322f, -0.733937f } } },
  { { 9, 8, 12 }, { { 0.5426f, 0.0008f }, { 0.5426f, 0.0f }, { 0.6772f, 0.463f } },
    { { 0.486445f, 0.524774f, -0.698559f }, { 0.518008f, -0.439322f, -0.733937f }, { 0.999547f, 0.015114f, -0.026039f } } },
  { { 9, 12, 10 }, { { 0.5426f, 0.0008f }, { 0.6772f, 0.463f }, { 0.5426f, 0.4594f } },
    { { 0.486445f, 0.524774f, -0.698559f }, { 0.999547f, 0.015114f, -0.026039f }, { 0.56188f, 0.825301f, -0.056302f } } },
  { { 11, 10, 12 }, { { 0.5426f, 0.7854f }, { 0.5426f, 0.4594f }, { 0.6772f, 0.463f } },
    { { 0.527413f, 0.524688f, 0.668235f }, { 0.56188f, 0.825301f, -0.056302f }, { 0.999547f, 0.015114f, -0.026039f } } },
  { { 6, 11, 12 }, { { 0.617f, 0.7828f }, { 0.5426f, 0.7854f }, { 0.6772f, 0.463f } },
    { { 0.797365f, -0.070351f, 0.599382f }, { 0.527413f, 0.524688f, 0.668235f }, { 0.999547f, 0.015114f, -0.026039f } } }
};

TEST_XYZ Redknight_xyz_L_foot[14] = {
  { 0.03938f, 0.11957f, -1.06037f }, { 0.03957f, -0.0121f, -1.06037f },
  { 0.06958f, -0.20265f, -1.06487f }, { 0.14817f, -0.20378f, -1.06281f },
  { 0.18174f, 0.04924f, -1.06356f }, { 0.14235f, 0.13214f, -1.06187f },
  { 0.0904f, 0.05168f, -0.94333f }, { 0.0904f, -0.00234f, -1.02811f },
  { 0.06752f, -0.20847f, -1.03674f }, { 0.12716f, -0.19478f, -1.03167f },
  { 0.14348f, 0.00422f, -0.94727f }, { 0.13766f, 0.0815f, -0.94221f },
  { 0.09077f, -0.00422f, -0.94446f }, { 0.09077f, -0.00272f, -1.06018f }
};

TEST_TRIANGLE1 Redknight_triangle1_L_foot[24] = {
  { { 7, 1, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.887518f, -0.041592f, 0.458891f }, { -0.959323f, 0.029322f, -0.280784f }, { -0.741688f, 0.584465f, -0.32909f } } },
  { { 7, 0, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.887518f, -0.041592f, 0.458891f }, { -0.741688f, 0.584465f, -0.32909f }, { -0.631856f, 0.233054f, 0.739219f } } },
  { { 8, 2, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.514587f, -0.78049f, 0.355015f }, { -0.461255f, -0.600215f, -0.653441f }, { -0.959323f, 0.029322f, -0.280784f } } },
  { { 8, 1, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.514587f, -0.78049f, 0.355015f }, { -0.959323f, 0.029322f, -0.280784f }, { -0.887518f, -0.041592f, 0.458891f } } },
  { { 2, 9, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.461255f, -0.600215f, -0.653441f }, { 0.333047f, -0.677363f, 0.655941f }, { 0.621241f, -0.683384f, -0.383466f } } },
  { { 8, 9, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.514587f, -0.78049f, 0.355015f }, { 0.333047f, -0.677363f, 0.655941f }, { -0.461255f, -0.600215f, -0.653441f } } },
  { { 3, 10, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.621241f, -0.683384f, -0.383466f }, { 0.607628f, -0.164665f, 0.776964f }, { 0.819555f, 0.117755f, -0.56077f } } },
  { { 3, 9, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.621241f, -0.683384f, -0.383466f }, { 0.333047f, -0.677363f, 0.655941f }, { 0.607628f, -0.164665f, 0.776964f } } },
  { { 4, 11, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.819555f, 0.117755f, -0.56077f }, { 0.308517f, 0.589258f, 0.746721f }, { 0.357252f, 0.83108f, -0.426236f } } },
  { { 4, 10, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.819555f, 0.117755f, -0.56077f }, { 0.607628f, -0.164665f, 0.776964f }, { 0.308517f, 0.589258f, 0.746721f } } },
  { { 6, 0, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.631856f, 0.233054f, 0.739219f }, { -0.741688f, 0.584465f, -0.32909f }, { 0.357252f, 0.83108f, -0.426236f } } },
  { { 6, 5, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.631856f, 0.233054f, 0.739219f }, { 0.357252f, 0.83108f, -0.426236f }, { 0.308517f, 0.589258f, 0.746721f } } },
  { { 0, 1, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.741688f, 0.584465f, -0.32909f }, { -0.959323f, 0.029322f, -0.280784f }, { -0.014613f, 0.00603f, -0.999875f } } },
  { { 1, 2, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.959323f, 0.029322f, -0.280784f }, { -0.461255f, -0.600215f, -0.653441f }, { -0.014613f, 0.00603f, -0.999875f } } },
  { { 2, 3, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.461255f, -0.600215f, -0.653441f }, { 0.621241f, -0.683384f, -0.383466f }, { -0.014613f, 0.00603f, -0.999875f } } },
  { { 3, 4, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.621241f, -0.683384f, -0.383466f }, { 0.819555f, 0.117755f, -0.56077f }, { -0.014613f, 0.00603f, -0.999875f } } },
  { { 4, 5, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.819555f, 0.117755f, -0.56077f }, { 0.357252f, 0.83108f, -0.426236f }, { -0.014613f, 0.00603f, -0.999875f } } },
  { { 5, 0, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.357252f, 0.83108f, -0.426236f }, { -0.741688f, 0.584465f, -0.32909f }, { -0.014613f, 0.00603f, -0.999875f } } },
  { { 7, 6, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.887518f, -0.041592f, 0.458891f }, { -0.631856f, 0.233054f, 0.739219f }, { -0.623464f, -0.16513f, 0.764215f } } },
  { { 8, 7, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.514587f, -0.78049f, 0.355015f }, { -0.887518f, -0.041592f, 0.458891f }, { -0.623464f, -0.16513f, 0.764215f } } },
  { { 8, 12, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.514587f, -0.78049f, 0.355015f }, { -0.623464f, -0.16513f, 0.764215f }, { 0.333047f, -0.677363f, 0.655941f } } },
  { { 9, 12, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.333047f, -0.677363f, 0.655941f }, { -0.623464f, -0.16513f, 0.764215f }, { 0.607628f, -0.164665f, 0.776964f } } },
  { { 11, 10, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.308517f, 0.589258f, 0.746721f }, { 0.607628f, -0.164665f, 0.776964f }, { -0.623464f, -0.16513f, 0.764215f } } },
  { { 6, 11, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.631856f, 0.233054f, 0.739219f }, { 0.308517f, 0.589258f, 0.746721f }, { -0.623464f, -0.16513f, 0.764215f } } }
};

TEST_XYZ Redknight_xyz_L_hand[18] = {
  { 0.24515f, -0.02706f, -0.43661f }, { 0.24815f, 0.03294f, -0.41861f },
  { 0.22415f, 0.03394f, -0.41361f }, { 0.22315f, -0.02806f, -0.43061f },
  { 0.26615f, -0.03206f, -0.34161f }, { 0.26615f, 0.05794f, -0.30361f },
  { 0.21815f, 0.02694f, -0.26761f }, { 0.23115f, -0.03306f, -0.34061f },
  { 0.22915f, -0.05506f, -0.35561f }, { 0.25715f, 0.04294f, -0.22961f },
  { 0.20715f, 0.04494f, -0.24061f }, { 0.21315f, -0.05406f, -0.35361f },
  { 0.23015f, -0.05906f, -0.33661f }, { 0.24915f, -0.00606f, -0.21661f },
  { 0.19915f, 0.00894f, -0.21761f }, { 0.21415f, -0.06006f, -0.33861f },
  { 0.22815f, -0.00606f, -0.22261f }, { 0.23515f, 0.00594f, -0.42761f }
};

TEST_TRIANGLE1 Redknight_triangle1_L_hand[32] = {
  { { 5, 1, 0 }, { { 0.6182f, 0.3086f }, { 0.5691f, 0.149f }, { 0.5599f, 0.1237f } },
    { { 0.507645f, 0.857106f, -0.087548f }, { 0.518069f, 0.649669f, -0.556358f }, { 0.42969f, -0.474768f, -0.76809f } } },
  { { 5, 0, 4 }, { { 0.6182f, 0.3086f }, { 0.5599f, 0.1237f }, { 0.6167f, 0.2558f } },
    { { 0.507645f, 0.857106f, -0.087548f }, { 0.42969f, -0.474768f, -0.76809f }, { 0.768653f, -0.637474f, 0.052921f } } },
  { { 1, 6, 2 }, { { 0.5691f, 0.149f }, { 0.4855f, 0.3588f }, { 0.5017f, 0.1557f } },
    { { 0.518069f, 0.649669f, -0.556358f }, { -0.628026f, 0.590754f, -0.506551f }, { -0.63583f, 0.679447f, -0.366159f } } },
  { { 5, 6, 1 }, { { 0.6182f, 0.3086f }, { 0.4855f, 0.3588f }, { 0.5691f, 0.149f } },
    { { 0.507645f, 0.857106f, -0.087548f }, { -0.628026f, 0.590754f, -0.506551f }, { 0.518069f, 0.649669f, -0.556358f } } },
  { { 2, 7, 3 }, { { 0.5017f, 0.1557f }, { 0.5217f, 0.2576f }, { 0.4988f, 0.1315f } },
    { { -0.63583f, 0.679447f, -0.366159f }, { -0.67554f, 0.199725f, -0.709757f }, { -0.658976f, -0.531113f, -0.532605f } } },
  { { 2, 6, 7 }, { { 0.5017f, 0.1557f }, { 0.4855f, 0.3588f }, { 0.5217f, 0.2576f } },
    { { -0.63583f, 0.679447f, -0.366159f }, { -0.628026f, 0.590754f, -0.506551f }, { -0.67554f, 0.199725f, -0.709757f } } },
  { { 4, 0, 3 }, { { 0.6167f, 0.2558f }, { 0.5599f, 0.1237f }, { 0.4988f, 0.1315f } },
    { { 0.768653f, -0.637474f, 0.052921f }, { 0.42969f, -0.474768f, -0.76809f }, { -0.658976f, -0.531113f, -0.532605f } } },
  { { 4, 3, 7 }, { { 0.6167f, 0.2558f }, { 0.4988f, 0.1315f }, { 0.5217f, 0.2576f } },
    { { 0.768653f, -0.637474f, 0.052921f }, { -0.658976f, -0.531113f, -0.532605f }, { -0.67554f, 0.199725f, -0.709757f } } },
  { { 5, 4, 9 }, { { 0.6182f, 0.3086f }, { 0.6167f, 0.2558f }, { 0.5929f, 0.4121f } },
    { { 0.507645f, 0.857106f, -0.087548f }, { 0.768653f, -0.637474f, 0.052921f }, { 0.620115f, 0.516709f, 0.590313f } } },
  { { 9, 4, 8 }, { { 0.5929f, 0.4121f }, { 0.6167f, 0.2558f }, { 0.5152f, 0.2369f } },
    { { 0.620115f, 0.516709f, 0.590313f }, { 0.768653f, -0.637474f, 0.052921f }, { 0.363112f, -0.405537f, -0.838862f } } },
  { { 10, 6, 5 }, { { 0.4573f, 0.3961f }, { 0.4855f, 0.3588f }, { 0.6182f, 0.3086f } },
    { { -0.658598f, 0.730659f, 0.17996f }, { -0.628026f, 0.590754f, -0.506551f }, { 0.507645f, 0.857106f, -0.087548f } } },
  { { 10, 5, 9 }, { { 0.4573f, 0.3961f }, { 0.6182f, 0.3086f }, { 0.5929f, 0.4121f } },
    { { -0.658598f, 0.730659f, 0.17996f }, { 0.507645f, 0.857106f, -0.087548f }, { 0.620115f, 0.516709f, 0.590313f } } },
  { { 7, 6, 11 }, { { 0.5217f, 0.2576f }, { 0.4855f, 0.3588f }, { 0.4726f, 0.2393f } },
    { { -0.67554f, 0.199725f, -0.709757f }, { -0.628026f, 0.590754f, -0.506551f }, { -0.617347f, -0.234048f, -0.751068f } } },
  { { 10, 11, 6 }, { { 0.4573f, 0.3961f }, { 0.4726f, 0.2393f }, { 0.4855f, 0.3588f } },
    { { -0.658598f, 0.730659f, 0.17996f }, { -0.617347f, -0.234048f, -0.751068f }, { -0.628026f, 0.590754f, -0.506551f } } },
  { { 4, 7, 8 }, { { 0.6167f, 0.2558f }, { 0.5217f, 0.2576f }, { 0.5152f, 0.2369f } },
    { { 0.768653f, -0.637474f, 0.052921f }, { -0.67554f, 0.199725f, -0.709757f }, { 0.363112f, -0.405537f, -0.838862f } } },
  { { 8, 7, 11 }, { { 0.5152f, 0.2369f }, { 0.5217f, 0.2576f }, { 0.4726f, 0.2393f } },
    { { 0.363112f, -0.405537f, -0.838862f }, { -0.67554f, 0.199725f, -0.709757f }, { -0.617347f, -0.234048f, -0.751068f } } },
  { { 9, 8, 13 }, { { 0.5929f, 0.4121f }, { 0.5152f, 0.2369f }, { 0.5718f, 0.4302f } },
    { { 0.620115f, 0.516709f, 0.590313f }, { 0.363112f, -0.405537f, -0.838862f }, { 0.548898f, -0.442242f, 0.709319f } } },
  { { 13, 8, 12 }, { { 0.5718f, 0.4302f }, { 0.5152f, 0.2369f }, { 0.5201f, 0.2629f } },
    { { 0.548898f, -0.442242f, 0.709319f }, { 0.363112f, -0.405537f, -0.838862f }, { 0.583991f, -0.81092f, 0.036924f } } },
  { { 10, 9, 14 }, { { 0.4573f, 0.3961f }, { 0.5929f, 0.4121f }, { 0.4345f, 0.428f } },
    { { -0.658598f, 0.730659f, 0.17996f }, { 0.620115f, 0.516709f, 0.590313f }, { -0.723487f, -0.08953f, 0.684508f } } },
  { { 14, 9, 13 }, { { 0.4345f, 0.428f }, { 0.5929f, 0.4121f }, { 0.5718f, 0.4302f } },
    { { -0.723487f, -0.08953f, 0.684508f }, { 0.620115f, 0.516709f, 0.590313f }, { 0.548898f, -0.442242f, 0.709319f } } },
  { { 15, 11, 10 }, { { 0.4767f, 0.2595f }, { 0.4726f, 0.2393f }, { 0.4573f, 0.3961f } },
    { { -0.561592f, -0.82741f, 0.002916f }, { -0.617347f, -0.234048f, -0.751068f }, { -0.658598f, 0.730659f, 0.17996f } } },
  { { 15, 10, 14 }, { { 0.4767f, 0.2595f }, { 0.4573f, 0.3961f }, { 0.4345f, 0.428f } },
    { { -0.561592f, -0.82741f, 0.002916f }, { -0.658598f, 0.730659f, 0.17996f }, { -0.723487f, -0.08953f, 0.684508f } } },
  { { 8, 11, 12 }, { { 0.5152f, 0.2369f }, { 0.4726f, 0.2393f }, { 0.5201f, 0.2629f } },
    { { 0.363112f, -0.405537f, -0.838862f }, { -0.617347f, -0.234048f, -0.751068f }, { 0.583991f, -0.81092f, 0.036924f } } },
  { { 15, 12, 11 }, { { 0.4767f, 0.2595f }, { 0.5201f, 0.2629f }, { 0.4726f, 0.2393f } },
    { { -0.561592f, -0.82741f, 0.002916f }, { 0.583991f, -0.81092f, 0.036924f }, { -0.617347f, -0.234048f, -0.751068f } } },
  { { 0, 1, 17 }, { { 0.5599f, 0.1237f }, { 0.5691f, 0.149f }, { 0.5314f, 0.1362f } },
    { { 0.42969f, -0.474768f, -0.76809f }, { 0.518069f, 0.649669f, -0.556358f }, { -0.205842f, 0.277594f, -0.938387f } } },
  { { 1, 2, 17 }, { { 0.5691f, 0.149f }, { 0.5017f, 0.1557f }, { 0.5314f, 0.1362f } },
    { { 0.518069f, 0.649669f, -0.556358f }, { -0.63583f, 0.679447f, -0.366159f }, { -0.205842f, 0.277594f, -0.938387f } } },
  { { 2, 3, 17 }, { { 0.5017f, 0.1557f }, { 0.4988f, 0.1315f }, { 0.5314f, 0.1362f } },
    { { -0.63583f, 0.679447f, -0.366159f }, { -0.658976f, -0.531113f, -0.532605f }, { -0.205842f, 0.277594f, -0.938387f } } },
  { { 3, 0, 17 }, { { 0.4988f, 0.1315f }, { 0.5599f, 0.1237f }, { 0.5314f, 0.1362f } },
    { { -0.658976f, -0.531113f, -0.532605f }, { 0.42969f, -0.474768f, -0.76809f }, { -0.205842f, 0.277594f, -0.938387f } } },
  { { 13, 12, 16 }, { { 0.5718f, 0.4302f }, { 0.5201f, 0.2629f }, { 0.5148f, 0.4224f } },
    { { 0.548898f, -0.442242f, 0.709319f }, { 0.583991f, -0.81092f, 0.036924f }, { -0.226198f, -0.797297f, 0.5596f } } },
  { { 14, 13, 16 }, { { 0.4345f, 0.428f }, { 0.5718f, 0.4302f }, { 0.5148f, 0.4224f } },
    { { -0.723487f, -0.08953f, 0.684508f }, { 0.548898f, -0.442242f, 0.709319f }, { -0.226198f, -0.797297f, 0.5596f } } },
  { { 15, 14, 16 }, { { 0.4767f, 0.2595f }, { 0.4345f, 0.428f }, { 0.5148f, 0.4224f } },
    { { -0.561592f, -0.82741f, 0.002916f }, { -0.723487f, -0.08953f, 0.684508f }, { -0.226198f, -0.797297f, 0.5596f } } },
  { { 12, 15, 16 }, { { 0.5201f, 0.2629f }, { 0.4767f, 0.2595f }, { 0.5148f, 0.4224f } },
    { { 0.583991f, -0.81092f, 0.036924f }, { -0.561592f, -0.82741f, 0.002916f }, { -0.226198f, -0.797297f, 0.5596f } } }
};

TEST_XYZ Redknight_xyz_Obj[8] = {
  { -0.26116f, 0.11703f, -0.29933f }, { -0.26105f, -0.04164f, -0.29295f },
  { -0.2615f, -0.04164f, -0.31864f }, { -0.26138f, 0.11703f, -0.31227f },
  { -0.25122f, 0.11703f, -0.2995f }, { -0.25111f, -0.04164f, -0.29312f },
  { -0.25156f, -0.04164f, -0.31882f }, { -0.25145f, 0.11703f, -0.31244f }
};

TEST_TRIANGLE1 Redknight_triangle1_Obj[8] = {
  { { 0, 1, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999847f, 0.000011f, 0.017514f }, { -0.999847f, 0.000011f, 0.017514f }, { -0.999847f, 0.000011f, 0.017514f } } },
  { { 0, 2, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999856f, 0.000074f, 0.016999f }, { -0.999856f, 0.000074f, 0.016999f }, { -0.999856f, 0.000074f, 0.016999f } } },
  { { 1, 0, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.017086f, 0.040183f, 0.999046f }, { 0.017086f, 0.040183f, 0.999046f }, { 0.017086f, 0.040183f, 0.999046f } } },
  { { 5, 0, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.017086f, 0.040183f, 0.999046f }, { 0.017086f, 0.040183f, 0.999046f }, { 0.017086f, 0.040183f, 0.999046f } } },
  { { 3, 2, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.017106f, 0.040121f, -0.999048f }, { -0.017106f, 0.040121f, -0.999048f }, { -0.017106f, 0.040121f, -0.999048f } } },
  { { 7, 2, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.018092f, 0.040183f, -0.999029f }, { -0.018092f, 0.040183f, -0.999029f }, { -0.018092f, 0.040183f, -0.999029f } } },
  { { 5, 4, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999847f, -0.000011f, -0.017508f }, { 0.999847f, -0.000011f, -0.017508f }, { 0.999847f, -0.000011f, -0.017508f } } },
  { { 6, 4, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999842f, 0.000021f, -0.017773f }, { 0.999842f, 0.000021f, -0.017773f }, { 0.999842f, 0.000021f, -0.017773f } } }
};

TEST_XYZ Redknight_xyz_Obj_1[10] = {
  { -0.26093f, -0.06959f, -0.28638f }, { -0.26093f, -0.47528f, -0.28638f },
  { -0.26123f, -1.11429f, -0.30364f }, { -0.26161f, -0.47528f, -0.3252f },
  { -0.26161f, -0.06959f, -0.3252f }, { -0.25099f, -0.06959f, -0.28656f },
  { -0.25099f, -0.47528f, -0.28656f }, { -0.25129f, -1.11429f, -0.30381f },
  { -0.25167f, -0.47528f, -0.32538f }, { -0.25167f, -0.06959f, -0.32538f }
};

TEST_TRIANGLE1 Redknight_triangle1_Obj_1[14] = {
  { { 1, 2, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999847f, -0.000004f, 0.017514f }, { -0.999847f, -0.000004f, 0.017514f }, { -0.999847f, -0.000004f, 0.017514f } } },
  { { 1, 3, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999847f, 0.0f, 0.017514f }, { -0.999847f, 0.0f, 0.017514f }, { -0.999847f, 0.0f, 0.017514f } } },
  { { 0, 3, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999847f, 0.0f, 0.017514f }, { -0.999847f, 0.0f, 0.017514f }, { -0.999847f, 0.0f, 0.017514f } } },
  { { 1, 0, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.018106f, 0.0f, 0.999836f }, { 0.018106f, 0.0f, 0.999836f }, { 0.018106f, 0.0f, 0.999836f } } },
  { { 6, 0, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.018106f, 0.0f, 0.999836f }, { 0.018106f, 0.0f, 0.999836f }, { 0.018106f, 0.0f, 0.999836f } } },
  { { 7, 2, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.017093f, -0.027005f, 0.999489f }, { 0.017093f, -0.027005f, 0.999489f }, { 0.017093f, -0.027005f, 0.999489f } } },
  { { 7, 1, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0181f, -0.026989f, 0.999472f }, { 0.0181f, -0.026989f, 0.999472f }, { 0.0181f, -0.026989f, 0.999472f } } },
  { { 3, 2, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.018096f, -0.033726f, -0.999267f }, { -0.018096f, -0.033726f, -0.999267f }, { -0.018096f, -0.033726f, -0.999267f } } },
  { { 8, 2, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.01709f, -0.033741f, -0.999285f }, { -0.01709f, -0.033741f, -0.999285f }, { -0.01709f, -0.033741f, -0.999285f } } },
  { { 4, 3, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.018106f, 0.0f, -0.999836f }, { -0.018106f, 0.0f, -0.999836f }, { -0.018106f, 0.0f, -0.999836f } } },
  { { 9, 3, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.018106f, 0.0f, -0.999836f }, { -0.018106f, 0.0f, -0.999836f }, { -0.018106f, 0.0f, -0.999836f } } },
  { { 7, 6, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999847f, 0.000003f, -0.017514f }, { 0.999847f, 0.000003f, -0.017514f }, { 0.999847f, 0.000003f, -0.017514f } } },
  { { 6, 5, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999847f, 0.0f, -0.017514f }, { 0.999847f, 0.0f, -0.017514f }, { 0.999847f, 0.0f, -0.017514f } } },
  { { 9, 8, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999847f, 0.0f, -0.017514f }, { 0.999847f, 0.0f, -0.017514f }, { 0.999847f, 0.0f, -0.017514f } } }
};

TEST_XYZ Redknight_xyz_Obj_2[36] = {
  { -0.26135f, 0.15585f, -0.31002f }, { -0.2612f, 0.15585f, -0.30158f },
  { -0.26094f, 0.12566f, -0.28639f }, { -0.26116f, 0.11703f, -0.29933f },
  { -0.26105f, -0.04165f, -0.29295f }, { -0.25929f, -0.05234f, -0.19225f },
  { -0.2585f, -0.08666f, -0.14705f }, { -0.25862f, -0.09097f, -0.15362f },
  { -0.25929f, -0.06959f, -0.19225f }, { -0.26094f, -0.06959f, -0.28639f },
  { -0.26162f, -0.06959f, -0.32521f }, { -0.26326f, -0.06959f, -0.41954f },
  { -0.26394f, -0.09097f, -0.45817f }, { -0.26405f, -0.08666f, -0.46473f },
  { -0.26326f, -0.05234f, -0.41954f }, { -0.2615f, -0.04165f, -0.31865f },
  { -0.26139f, 0.11703f, -0.31227f }, { -0.26162f, 0.12566f, -0.32521f },
  { -0.25141f, 0.15585f, -0.31019f }, { -0.25127f, 0.15585f, -0.30175f },
  { -0.251f, 0.12566f, -0.28656f }, { -0.25123f, 0.11703f, -0.2995f },
  { -0.25111f, -0.04165f, -0.29313f }, { -0.24936f, -0.05234f, -0.19242f },
  { -0.24857f, -0.08666f, -0.14723f }, { -0.24868f, -0.09097f, -0.15379f },
  { -0.24936f, -0.06959f, -0.19242f }, { -0.251f, -0.06959f, -0.28656f },
  { -0.25168f, -0.06959f, -0.32538f }, { -0.25332f, -0.06959f, -0.41971f },
  { -0.254f, -0.09097f, -0.45834f }, { -0.25411f, -0.08666f, -0.46491f },
  { -0.25332f, -0.05234f, -0.41971f }, { -0.25156f, -0.04165f, -0.31882f },
  { -0.25145f, 0.11703f, -0.31244f }, { -0.25168f, 0.12566f, -0.32538f }
};

TEST_TRIANGLE1 Redknight_triangle1_Obj_2[58] = {
  { { 14, 12, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999854f, 0.000504f, 0.017097f }, { -0.999854f, 0.000504f, 0.017097f }, { -0.999854f, 0.000504f, 0.017097f } } },
  { { 14, 11, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999845f, 0.0f, 0.0176f }, { -0.999845f, 0.0f, 0.0176f }, { -0.999845f, 0.0f, 0.0176f } } },
  { { 6, 7, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.99984f, 0.000554f, 0.017896f }, { -0.99984f, 0.000554f, 0.017896f }, { -0.99984f, 0.000554f, 0.017896f } } },
  { { 5, 7, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.99985f, 0.0f, 0.017342f }, { -0.99985f, 0.0f, 0.017342f }, { -0.99985f, 0.0f, 0.017342f } } },
  { { 5, 8, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999846f, 0.0f, 0.017524f }, { -0.999846f, 0.0f, 0.017524f }, { -0.999846f, 0.0f, 0.017524f } } },
  { { 5, 9, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999847f, 0.000171f, 0.017493f }, { -0.999847f, 0.000171f, 0.017493f }, { -0.999847f, 0.000171f, 0.017493f } } },
  { { 14, 10, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999849f, 0.0f, 0.017383f }, { -0.999849f, 0.0f, 0.017383f }, { -0.999849f, 0.0f, 0.017383f } } },
  { { 15, 10, 14 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999848f, 0.000204f, 0.017421f }, { -0.999848f, 0.000204f, 0.017421f }, { -0.999848f, 0.000204f, 0.017421f } } },
  { { 4, 9, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999847f, 0.000176f, 0.017514f }, { -0.999847f, 0.000176f, 0.017514f }, { -0.999847f, 0.000176f, 0.017514f } } },
  { { 4, 10, 15 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999847f, 0.000183f, 0.017508f }, { -0.999847f, 0.000183f, 0.017508f }, { -0.999847f, 0.000183f, 0.017508f } } },
  { { 2, 3, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999855f, -0.000044f, 0.017028f }, { -0.999855f, -0.000044f, 0.017028f }, { -0.999855f, -0.000044f, 0.017028f } } },
  { { 1, 3, 16 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999842f, 0.0f, 0.017773f }, { -0.999842f, 0.0f, 0.017773f }, { -0.999842f, 0.0f, 0.017773f } } },
  { { 1, 16, 17 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999842f, 0.0f, 0.01777f }, { -0.999842f, 0.0f, 0.01777f }, { -0.999842f, 0.0f, 0.01777f } } },
  { { 1, 17, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.999842f, 0.0f, 0.017769f }, { -0.999842f, 0.0f, 0.017769f }, { -0.999842f, 0.0f, 0.017769f } } },
  { { 1, 0, 19 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 1.0f, 0.0f }, { 0.0f, 1.0f, 0.0f }, { 0.0f, 1.0f, 0.0f } } },
  { { 19, 0, 18 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, 1.0f, 0.0f }, { 0.0f, 1.0f, 0.0f }, { 0.0f, 1.0f, 0.0f } } },
  { { 2, 1, 20 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.015274f, 0.449514f, 0.893143f }, { 0.015274f, 0.449514f, 0.893143f }, { 0.015274f, 0.449514f, 0.893143f } } },
  { { 20, 1, 19 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.01529f, 0.449518f, 0.89314f }, { 0.01529f, 0.449518f, 0.89314f }, { 0.01529f, 0.449518f, 0.89314f } } },
  { { 3, 2, 21 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.009496f, -0.831988f, 0.554712f }, { 0.009496f, -0.831988f, 0.554712f }, { 0.009496f, -0.831988f, 0.554712f } } },
  { { 21, 2, 20 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.009487f, -0.831992f, 0.554707f }, { 0.009487f, -0.831992f, 0.554707f }, { 0.009487f, -0.831992f, 0.554707f } } },
  { { 5, 4, 23 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.001807f, 0.994414f, 0.105532f }, { 0.001807f, 0.994414f, 0.105532f }, { 0.001807f, 0.994414f, 0.105532f } } },
  { { 23, 4, 22 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.001911f, 0.994415f, 0.10552f }, { 0.001911f, 0.994415f, 0.10552f }, { 0.001911f, 0.994415f, 0.10552f } } },
  { { 6, 5, 24 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.010959f, 0.796478f, 0.604568f }, { 0.010959f, 0.796478f, 0.604568f }, { 0.010959f, 0.796478f, 0.604568f } } },
  { { 24, 5, 23 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.010352f, 0.796414f, 0.604663f }, { 0.010352f, 0.796414f, 0.604663f }, { 0.010352f, 0.796414f, 0.604663f } } },
  { { 7, 6, 25 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.009378f, -0.836181f, 0.548373f }, { 0.009378f, -0.836181f, 0.548373f }, { 0.009378f, -0.836181f, 0.548373f } } },
  { { 25, 6, 24 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.009951f, -0.83579f, 0.548958f }, { 0.009951f, -0.83579f, 0.548958f }, { 0.009951f, -0.83579f, 0.548958f } } },
  { { 8, 7, 26 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.008288f, -0.874967f, -0.484112f }, { -0.008288f, -0.874967f, -0.484112f }, { -0.008288f, -0.874967f, -0.484112f } } },
  { { 26, 7, 25 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.008279f, -0.874968f, -0.48411f }, { -0.008279f, -0.874968f, -0.48411f }, { -0.008279f, -0.874968f, -0.48411f } } },
  { { 9, 8, 27 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -1.0f, 0.0f }, { 0.0f, -1.0f, 0.0f }, { 0.0f, -1.0f, 0.0f } } },
  { { 27, 8, 26 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -1.0f, 0.0f }, { 0.0f, -1.0f, 0.0f }, { 0.0f, -1.0f, 0.0f } } },
  { { 11, 10, 29 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -1.0f, 0.0f }, { 0.0f, -1.0f, 0.0f }, { 0.0f, -1.0f, 0.0f } } },
  { { 29, 10, 28 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.0f, -1.0f, 0.0f }, { 0.0f, -1.0f, 0.0f }, { 0.0f, -1.0f, 0.0f } } },
  { { 12, 11, 30 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.008279f, -0.874968f, 0.48411f }, { 0.008279f, -0.874968f, 0.48411f }, { 0.008279f, -0.874968f, 0.48411f } } },
  { { 30, 11, 29 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.008281f, -0.874968f, 0.484111f }, { 0.008281f, -0.874968f, 0.484111f }, { 0.008281f, -0.874968f, 0.484111f } } },
  { { 13, 12, 31 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.009941f, -0.83579f, -0.548959f }, { -0.009941f, -0.83579f, -0.548959f }, { -0.009941f, -0.83579f, -0.548959f } } },
  { { 31, 12, 30 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.009378f, -0.836175f, -0.548383f }, { -0.009378f, -0.836175f, -0.548383f }, { -0.009378f, -0.836175f, -0.548383f } } },
  { { 14, 13, 32 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.010343f, 0.796414f, -0.604664f }, { -0.010343f, 0.796414f, -0.604664f }, { -0.010343f, 0.796414f, -0.604664f } } },
  { { 32, 13, 31 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.010948f, 0.796478f, -0.604568f }, { -0.010948f, 0.796478f, -0.604568f }, { -0.010948f, 0.796478f, -0.604568f } } },
  { { 15, 14, 33 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.001801f, 0.994435f, -0.105336f }, { -0.001801f, 0.994435f, -0.105336f }, { -0.001801f, 0.994435f, -0.105336f } } },
  { { 33, 14, 32 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.001802f, 0.994435f, -0.105336f }, { -0.001802f, 0.994435f, -0.105336f }, { -0.001802f, 0.994435f, -0.105336f } } },
  { { 17, 16, 35 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.009487f, -0.831992f, -0.554706f }, { -0.009487f, -0.831992f, -0.554706f }, { -0.009487f, -0.831992f, -0.554706f } } },
  { { 35, 16, 34 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.009488f, -0.831992f, -0.554707f }, { -0.009488f, -0.831992f, -0.554707f }, { -0.009488f, -0.831992f, -0.554707f } } },
  { { 0, 17, 18 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.015274f, 0.449518f, -0.893141f }, { -0.015274f, 0.449518f, -0.893141f }, { -0.015274f, 0.449518f, -0.893141f } } },
  { { 18, 17, 35 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.015274f, 0.449518f, -0.893141f }, { -0.015274f, 0.449518f, -0.893141f }, { -0.015274f, 0.449518f, -0.893141f } } },
  { { 31, 30, 32 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999854f, -0.000519f, -0.017081f }, { 0.999854f, -0.000519f, -0.017081f }, { 0.999854f, -0.000519f, -0.017081f } } },
  { { 30, 29, 32 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999845f, 0.0f, -0.0176f }, { 0.999845f, 0.0f, -0.0176f }, { 0.999845f, 0.0f, -0.0176f } } },
  { { 24, 23, 25 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999854f, 0.000504f, -0.017097f }, { 0.999854f, 0.000504f, -0.017097f }, { 0.999854f, 0.000504f, -0.017097f } } },
  { { 25, 23, 26 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999845f, 0.0f, -0.0176f }, { 0.999845f, 0.0f, -0.0176f }, { 0.999845f, 0.0f, -0.0176f } } },
  { { 26, 23, 27 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999848f, 0.0f, -0.017418f }, { 0.999848f, 0.0f, -0.017418f }, { 0.999848f, 0.0f, -0.017418f } } },
  { { 23, 22, 27 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999849f, -0.000153f, -0.01739f }, { 0.999849f, -0.000153f, -0.01739f }, { 0.999849f, -0.000153f, -0.01739f } } },
  { { 29, 28, 32 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999849f, 0.0f, -0.017383f }, { 0.999849f, 0.0f, -0.017383f }, { 0.999849f, 0.0f, -0.017383f } } },
  { { 32, 28, 33 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999848f, -0.000204f, -0.017421f }, { 0.999848f, -0.000204f, -0.017421f }, { 0.999848f, -0.000204f, -0.017421f } } },
  { { 27, 22, 28 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999847f, -0.000182f, -0.017514f }, { 0.999847f, -0.000182f, -0.017514f }, { 0.999847f, -0.000182f, -0.017514f } } },
  { { 28, 22, 33 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999847f, -0.000181f, -0.017514f }, { 0.999847f, -0.000181f, -0.017514f }, { 0.999847f, -0.000181f, -0.017514f } } },
  { { 20, 19, 21 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999842f, 0.0f, -0.017773f }, { 0.999842f, 0.0f, -0.017773f }, { 0.999842f, 0.0f, -0.017773f } } },
  { { 21, 19, 34 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999856f, 0.000045f, -0.016999f }, { 0.999856f, 0.000045f, -0.016999f }, { 0.999856f, 0.000045f, -0.016999f } } },
  { { 34, 19, 35 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999845f, 0.000217f, -0.017625f }, { 0.999845f, 0.000217f, -0.017625f }, { 0.999845f, 0.000217f, -0.017625f } } },
  { { 35, 19, 18 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.999862f, -0.000596f, -0.016587f }, { 0.999862f, -0.000596f, -0.016587f }, { 0.999862f, -0.000596f, -0.016587f } } }
};

TEST_XYZ Redknight_xyz_Pelvis[12] = {
  { -0.099f, 0.0f, -0.022f }, { -0.099f, 0.0f, 0.022f },
  { -0.05f, 0.065f, -0.021f }, { -0.049f, 0.063f, 0.023f },
  { 0.05f, 0.065f, -0.021f }, { 0.049f, 0.063f, 0.023f },
  { 0.099f, 0.0f, -0.022f }, { 0.099f, 0.0f, 0.022f },
  { 0.05f, -0.064f, -0.023f }, { 0.049f, -0.065f, 0.021f },
  { -0.05f, -0.064f, -0.023f }, { -0.049f, -0.065f, 0.021f }
};

TEST_TRIANGLE1 Redknight_triangle1_Pelvis[12] = {
  { { 0, 3, 1 }, { { 0.0f, 0.024f }, { 0.2524f, 1.0f }, { 0.0028f, 0.9719f } },
    { { -0.999957f, -0.00144f, 0.009113f }, { -0.440597f, 0.896688f, 0.042717f }, { -0.999895f, 0.01446f, 0.000834f } } },
  { { 2, 3, 0 }, { { 0.2505f, 0.0561f }, { 0.2524f, 1.0f }, { 0.0f, 0.024f } },
    { { -0.447564f, 0.892811f, 0.050754f }, { -0.440597f, 0.896688f, 0.042717f }, { -0.999957f, -0.00144f, 0.009113f } } },
  { { 2, 5, 3 }, { { 0.2505f, 0.0561f }, { 0.7486f, 1.0f }, { 0.2524f, 1.0f } },
    { { -0.447564f, 0.892811f, 0.050754f }, { 0.432756f, 0.900082f, 0.050748f }, { -0.440597f, 0.896688f, 0.042717f } } },
  { { 4, 5, 2 }, { { 0.7505f, 0.0561f }, { 0.7486f, 1.0f }, { 0.2505f, 0.0561f } },
    { { 0.44017f, 0.896901f, 0.042656f }, { 0.432756f, 0.900082f, 0.050748f }, { -0.447564f, 0.892811f, 0.050754f } } },
  { { 4, 7, 5 }, { { 0.7505f, 0.0561f }, { 0.9972f, 0.9719f }, { 0.7486f, 1.0f } },
    { { 0.44017f, 0.896901f, 0.042656f }, { 0.999945f, 0.004963f, 0.009209f }, { 0.432756f, 0.900082f, 0.050748f } } },
  { { 6, 7, 4 }, { { 1.0f, 0.024f }, { 0.9972f, 0.9719f }, { 0.7505f, 0.0561f } },
    { { 0.999945f, -0.010502f, 0.000838f }, { 0.999945f, 0.004963f, 0.009209f }, { 0.44017f, 0.896901f, 0.042656f } } },
  { { 6, 9, 7 }, { { 1.0f, 0.024f }, { 0.7486f, 0.9398f }, { 0.9972f, 0.9719f } },
    { { 0.999945f, -0.010502f, 0.000838f }, { 0.436485f, -0.899641f, -0.011256f }, { 0.999945f, 0.004963f, 0.009209f } } },
  { { 8, 9, 6 }, { { 0.7505f, 0.0f }, { 0.7486f, 0.9398f }, { 1.0f, 0.024f } },
    { { 0.448716f, -0.893617f, -0.010111f }, { 0.436485f, -0.899641f, -0.011256f }, { 0.999945f, -0.010502f, 0.000838f } } },
  { { 11, 9, 8 }, { { 0.2524f, 0.9398f }, { 0.7486f, 0.9398f }, { 0.7505f, 0.0f } },
    { { -0.435797f, -0.899983f, -0.01055f }, { 0.436485f, -0.899641f, -0.011256f }, { 0.448716f, -0.893617f, -0.010111f } } },
  { { 11, 8, 10 }, { { 0.2524f, 0.9398f }, { 0.7505f, 0.0f }, { 0.2505f, 0.0f } },
    { { -0.435797f, -0.899983f, -0.01055f }, { 0.448716f, -0.893617f, -0.010111f }, { -0.448013f, -0.893961f, -0.010881f } } },
  { { 11, 10, 1 }, { { 0.2524f, 0.9398f }, { 0.2505f, 0.0f }, { 0.0028f, 0.9719f } },
    { { -0.435797f, -0.899983f, -0.01055f }, { -0.448013f, -0.893961f, -0.010881f }, { -0.999895f, 0.01446f, 0.000834f } } },
  { { 1, 10, 0 }, { { 0.0028f, 0.9719f }, { 0.2505f, 0.0f }, { 0.0f, 0.024f } },
    { { -0.999895f, 0.01446f, 0.000834f }, { -0.448013f, -0.893961f, -0.010881f }, { -0.999957f, -0.00144f, 0.009113f } } }
};

TEST_XYZ Redknight_xyz_Pelvis_1[18] = {
  { -0.176f, -0.03622f, -0.27764f }, { -0.133f, 0.00178f, -0.07664f },
  { -0.099f, 0.00078f, -0.02264f }, { -0.088f, 0.15878f, -0.28164f },
  { -0.067f, 0.11578f, -0.08564f }, { -0.05f, 0.06478f, -0.02064f },
  { 0.088f, 0.15778f, -0.28264f }, { 0.067f, 0.11578f, -0.08564f },
  { 0.05f, 0.06478f, -0.02064f }, { 0.176f, -0.03622f, -0.27764f },
  { 0.133f, 0.00178f, -0.07664f }, { 0.099f, 0.00078f, -0.02264f },
  { 0.089f, -0.15522f, -0.30064f }, { 0.067f, -0.09422f, -0.07864f },
  { 0.05f, -0.06322f, -0.02364f }, { -0.089f, -0.15222f, -0.29864f },
  { -0.067f, -0.09422f, -0.07864f }, { -0.05f, -0.06322f, -0.02364f }
};

TEST_TRIANGLE1 Redknight_triangle1_Pelvis_1[24] = {
  { { 0, 4, 1 }, { { 0.0f, 0.0831f }, { 0.3108f, 0.7681f }, { 0.121f, 0.7989f } },
    { { -0.949613f, -0.176164f, 0.259234f }, { -0.458987f, 0.792551f, 0.401489f }, { -0.932437f, 0.009327f, 0.361211f } } },
  { { 3, 4, 0 }, { { 0.2495f, 0.0677f }, { 0.3108f, 0.7681f }, { 0.0f, 0.0831f } },
    { { -0.512584f, 0.826023f, 0.234399f }, { -0.458987f, 0.792551f, 0.401489f }, { -0.949613f, -0.176164f, 0.259234f } } },
  { { 1, 5, 2 }, { { 0.121f, 0.7989f }, { 0.3593f, 1.0f }, { 0.218f, 0.9946f } },
    { { -0.932437f, 0.009327f, 0.361211f }, { -0.401027f, 0.679013f, 0.614914f }, { -0.838718f, 0.009083f, 0.544491f } } },
  { { 1, 4, 5 }, { { 0.121f, 0.7989f }, { 0.3108f, 0.7681f }, { 0.3593f, 1.0f } },
    { { -0.932437f, 0.009327f, 0.361211f }, { -0.458987f, 0.792551f, 0.401489f }, { -0.401027f, 0.679013f, 0.614914f } } },
  { { 3, 7, 4 }, { { 0.2495f, 0.0677f }, { 0.6892f, 0.7681f }, { 0.3108f, 0.7681f } },
    { { -0.512584f, 0.826023f, 0.234399f }, { 0.436678f, 0.8006f, 0.410306f }, { -0.458987f, 0.792551f, 0.401489f } } },
  { { 6, 7, 3 }, { { 0.7505f, 0.0644f }, { 0.6892f, 0.7681f }, { 0.2495f, 0.0677f } },
    { { 0.507249f, 0.836459f, 0.207447f }, { 0.436678f, 0.8006f, 0.410306f }, { -0.512584f, 0.826023f, 0.234399f } } },
  { { 5, 4, 8 }, { { 0.3593f, 1.0f }, { 0.3108f, 0.7681f }, { 0.6412f, 1.0f } },
    { { -0.401027f, 0.679013f, 0.614914f }, { -0.458987f, 0.792551f, 0.401489f }, { 0.371411f, 0.680809f, 0.631311f } } },
  { { 8, 4, 7 }, { { 0.6412f, 1.0f }, { 0.3108f, 0.7681f }, { 0.6892f, 0.7681f } },
    { { 0.371411f, 0.680809f, 0.631311f }, { -0.458987f, 0.792551f, 0.401489f }, { 0.436678f, 0.8006f, 0.410306f } } },
  { { 6, 10, 7 }, { { 0.7505f, 0.0644f }, { 0.879f, 0.7989f }, { 0.6892f, 0.7681f } },
    { { 0.507249f, 0.836459f, 0.207447f }, { 0.923882f, -0.009998f, 0.382547f }, { 0.436678f, 0.8006f, 0.410306f } } },
  { { 9, 10, 6 }, { { 1.0f, 0.0831f }, { 0.879f, 0.7989f }, { 0.7505f, 0.0644f } },
    { { 0.958871f, -0.176719f, 0.222121f }, { 0.923882f, -0.009998f, 0.382547f }, { 0.507249f, 0.836459f, 0.207447f } } },
  { { 8, 7, 11 }, { { 0.6412f, 1.0f }, { 0.6892f, 0.7681f }, { 0.782f, 0.9946f } },
    { { 0.371411f, 0.680809f, 0.631311f }, { 0.436678f, 0.8006f, 0.410306f }, { 0.834202f, -0.041952f, 0.549861f } } },
  { { 11, 7, 10 }, { { 0.782f, 0.9946f }, { 0.6892f, 0.7681f }, { 0.879f, 0.7989f } },
    { { 0.834202f, -0.041952f, 0.549861f }, { 0.436678f, 0.8006f, 0.410306f }, { 0.923882f, -0.009998f, 0.382547f } } },
  { { 9, 13, 10 }, { { 1.0f, 0.0831f }, { 0.6898f, 0.7922f }, { 0.879f, 0.7989f } },
    { { 0.958871f, -0.176719f, 0.222121f }, { 0.423155f, -0.810548f, 0.40491f }, { 0.923882f, -0.009998f, 0.382547f } } },
  { { 12, 13, 9 }, { { 0.7521f, 0.0f }, { 0.6898f, 0.7922f }, { 1.0f, 0.0831f } },
    { { 0.384422f, -0.880644f, 0.276923f }, { 0.423155f, -0.810548f, 0.40491f }, { 0.958871f, -0.176719f, 0.222121f } } },
  { { 11, 10, 14 }, { { 0.782f, 0.9946f }, { 0.879f, 0.7989f }, { 0.6412f, 0.9906f } },
    { { 0.834202f, -0.041952f, 0.549861f }, { 0.923882f, -0.009998f, 0.382547f }, { 0.38345f, -0.756413f, 0.52991f } } },
  { { 14, 10, 13 }, { { 0.6412f, 0.9906f }, { 0.879f, 0.7989f }, { 0.6898f, 0.7922f } },
    { { 0.38345f, -0.756413f, 0.52991f }, { 0.923882f, -0.009998f, 0.382547f }, { 0.423155f, -0.810548f, 0.40491f } } },
  { { 12, 16, 13 }, { { 0.7521f, 0.0f }, { 0.3108f, 0.7922f }, { 0.6898f, 0.7922f } },
    { { 0.384422f, -0.880644f, 0.276923f }, { -0.430177f, -0.814225f, 0.389852f }, { 0.423155f, -0.810548f, 0.40491f } } },
  { { 15, 16, 12 }, { { 0.2484f, 0.0054f }, { 0.3108f, 0.7922f }, { 0.7521f, 0.0f } },
    { { -0.397728f, -0.872694f, 0.283227f }, { -0.430177f, -0.814225f, 0.389852f }, { 0.384422f, -0.880644f, 0.276923f } } },
  { { 14, 13, 17 }, { { 0.6412f, 0.9906f }, { 0.6898f, 0.7922f }, { 0.3593f, 0.9906f } },
    { { 0.38345f, -0.756413f, 0.52991f }, { 0.423155f, -0.810548f, 0.40491f }, { -0.36446f, -0.75853f, 0.540186f } } },
  { { 17, 13, 16 }, { { 0.3593f, 0.9906f }, { 0.6898f, 0.7922f }, { 0.3108f, 0.7922f } },
    { { -0.36446f, -0.75853f, 0.540186f }, { 0.423155f, -0.810548f, 0.40491f }, { -0.430177f, -0.814225f, 0.389852f } } },
  { { 16, 15, 1 }, { { 0.3108f, 0.7922f }, { 0.2484f, 0.0054f }, { 0.121f, 0.7989f } },
    { { -0.430177f, -0.814225f, 0.389852f }, { -0.397728f, -0.872694f, 0.283227f }, { -0.932437f, 0.009327f, 0.361211f } } },
  { { 1, 15, 0 }, { { 0.121f, 0.7989f }, { 0.2484f, 0.0054f }, { 0.0f, 0.0831f } },
    { { -0.932437f, 0.009327f, 0.361211f }, { -0.397728f, -0.872694f, 0.283227f }, { -0.949613f, -0.176164f, 0.259234f } } },
  { { 17, 16, 2 }, { { 0.3593f, 0.9906f }, { 0.3108f, 0.7922f }, { 0.218f, 0.9946f } },
    { { -0.36446f, -0.75853f, 0.540186f }, { -0.430177f, -0.814225f, 0.389852f }, { -0.838718f, 0.009083f, 0.544491f } } },
  { { 2, 16, 1 }, { { 0.218f, 0.9946f }, { 0.3108f, 0.7922f }, { 0.121f, 0.7989f } },
    { { -0.838718f, 0.009083f, 0.544491f }, { -0.430177f, -0.814225f, 0.389852f }, { -0.932437f, 0.009327f, 0.361211f } } }
};

TEST_XYZ Redknight_xyz_Rl_arm[17] = {
  { -0.20559f, -0.02164f, -0.19734f }, { -0.21159f, 0.03736f, -0.19734f },
  { -0.25859f, 0.04936f, -0.19734f }, { -0.28159f, -0.00164f, -0.19734f },
  { -0.24859f, -0.04064f, -0.19734f }, { -0.17659f, -0.02764f, -0.02334f },
  { -0.19159f, 0.05436f, -0.02234f }, { -0.25559f, 0.06936f, -0.01634f },
  { -0.28659f, -0.00364f, -0.01334f }, { -0.24259f, -0.05764f, -0.03034f },
  { -0.18459f, -0.02164f, 0.04866f }, { -0.19159f, 0.04336f, 0.04966f },
  { -0.24359f, 0.05536f, 0.05666f }, { -0.26859f, -0.00164f, 0.05966f },
  { -0.23259f, -0.04364f, 0.05166f }, { -0.22659f, 0.00436f, 0.06866f },
  { -0.24059f, 0.00536f, -0.19734f }
};

TEST_TRIANGLE1 Redknight_triangle1_Rl_arm[30] = {
  { { 6, 1, 0 }, { { 0.6002f, 0.3554f }, { 0.5459f, 0.1079f }, { 0.5633f, 0.1079f } },
    { { 0.715047f, 0.698445f, -0.029706f }, { 0.572657f, 0.497378f, -0.651674f }, { 0.653665f, -0.388399f, -0.649514f } } },
  { { 6, 0, 5 }, { { 0.6002f, 0.3554f }, { 0.5633f, 0.1079f }, { 0.6406f, 0.3536f } },
    { { 0.715047f, 0.698445f, -0.029706f }, { 0.653665f, -0.388399f, -0.649514f }, { 0.883625f, -0.467753f, -0.020353f } } },
  { { 7, 2, 1 }, { { 0.4262f, 0.3639f }, { 0.4185f, 0.1079f }, { 0.5459f, 0.1079f } },
    { { -0.444684f, 0.89306f, 0.068558f }, { -0.361908f, 0.69718f, -0.61884f }, { 0.572657f, 0.497378f, -0.651674f } } },
  { { 7, 1, 6 }, { { 0.4262f, 0.3639f }, { 0.5459f, 0.1079f }, { 0.6002f, 0.3554f } },
    { { -0.444684f, 0.89306f, 0.068558f }, { 0.572657f, 0.497378f, -0.651674f }, { 0.715047f, 0.698445f, -0.029706f } } },
  { { 8, 3, 2 }, { { 0.3417f, 0.3679f }, { 0.3566f, 0.1079f }, { 0.4185f, 0.1079f } },
    { { -0.982435f, -0.14876f, 0.112657f }, { -0.780228f, -0.104904f, -0.616635f }, { -0.361908f, 0.69718f, -0.61884f } } },
  { { 8, 2, 7 }, { { 0.3417f, 0.3679f }, { 0.4185f, 0.1079f }, { 0.4262f, 0.3639f } },
    { { -0.982435f, -0.14876f, 0.112657f }, { -0.361908f, 0.69718f, -0.61884f }, { -0.444684f, 0.89306f, 0.068558f } } },
  { { 9, 4, 3 }, { { 0.461f, 0.3443f }, { 0.4461f, 0.1079f }, { 0.3566f, 0.1079f } },
    { { -0.219758f, -0.974834f, 0.037478f }, { -0.190365f, -0.756237f, -0.625992f }, { -0.780228f, -0.104904f, -0.616635f } } },
  { { 9, 3, 8 }, { { 0.461f, 0.3443f }, { 0.3566f, 0.1079f }, { 0.3417f, 0.3679f } },
    { { -0.219758f, -0.974834f, 0.037478f }, { -0.780228f, -0.104904f, -0.616635f }, { -0.982435f, -0.14876f, 0.112657f } } },
  { { 5, 0, 4 }, { { 0.6406f, 0.3536f }, { 0.5633f, 0.1079f }, { 0.4461f, 0.1079f } },
    { { 0.883625f, -0.467753f, -0.020353f }, { 0.653665f, -0.388399f, -0.649514f }, { -0.190365f, -0.756237f, -0.625992f } } },
  { { 5, 4, 9 }, { { 0.6406f, 0.3536f }, { 0.4461f, 0.1079f }, { 0.461f, 0.3443f } },
    { { 0.883625f, -0.467753f, -0.020353f }, { -0.190365f, -0.756237f, -0.625992f }, { -0.219758f, -0.974834f, 0.037478f } } },
  { { 6, 5, 11 }, { { 0.6002f, 0.3554f }, { 0.6406f, 0.3536f }, { 0.6002f, 0.4575f } },
    { { 0.715047f, 0.698445f, -0.029706f }, { 0.883625f, -0.467753f, -0.020353f }, { 0.661176f, 0.53514f, 0.525806f } } },
  { { 11, 5, 10 }, { { 0.6002f, 0.4575f }, { 0.6406f, 0.3536f }, { 0.6191f, 0.4562f } },
    { { 0.661176f, 0.53514f, 0.525806f }, { 0.883625f, -0.467753f, -0.020353f }, { 0.742399f, -0.413913f, 0.526801f } } },
  { { 7, 6, 12 }, { { 0.4262f, 0.3639f }, { 0.6002f, 0.3554f }, { 0.4595f, 0.467f } },
    { { -0.444684f, 0.89306f, 0.068558f }, { 0.715047f, 0.698445f, -0.029706f }, { -0.294965f, 0.718815f, 0.629524f } } },
  { { 12, 6, 11 }, { { 0.4595f, 0.467f }, { 0.6002f, 0.3554f }, { 0.6002f, 0.4575f } },
    { { -0.294965f, 0.718815f, 0.629524f }, { 0.715047f, 0.698445f, -0.029706f }, { 0.661176f, 0.53514f, 0.525806f } } },
  { { 8, 7, 13 }, { { 0.3417f, 0.3679f }, { 0.4262f, 0.3639f }, { 0.3914f, 0.4715f } },
    { { -0.982435f, -0.14876f, 0.112657f }, { -0.444684f, 0.89306f, 0.068558f }, { -0.742081f, -0.137407f, 0.656076f } } },
  { { 7, 12, 13 }, { { 0.4262f, 0.3639f }, { 0.4595f, 0.467f }, { 0.3914f, 0.4715f } },
    { { -0.444684f, 0.89306f, 0.068558f }, { -0.294965f, 0.718815f, 0.629524f }, { -0.742081f, -0.137407f, 0.656076f } } },
  { { 9, 8, 14 }, { { 0.461f, 0.3443f }, { 0.3417f, 0.3679f }, { 0.4891f, 0.4607f } },
    { { -0.219758f, -0.974834f, 0.037478f }, { -0.982435f, -0.14876f, 0.112657f }, { -0.114571f, -0.818986f, 0.562259f } } },
  { { 14, 8, 13 }, { { 0.4891f, 0.4607f }, { 0.3417f, 0.3679f }, { 0.3914f, 0.4715f } },
    { { -0.114571f, -0.818986f, 0.562259f }, { -0.982435f, -0.14876f, 0.112657f }, { -0.742081f, -0.137407f, 0.656076f } } },
  { { 5, 9, 10 }, { { 0.6406f, 0.3536f }, { 0.461f, 0.3443f }, { 0.6191f, 0.4562f } },
    { { 0.883625f, -0.467753f, -0.020353f }, { -0.219758f, -0.974834f, 0.037478f }, { 0.742399f, -0.413913f, 0.526801f } } },
  { { 10, 9, 14 }, { { 0.6191f, 0.4562f }, { 0.461f, 0.3443f }, { 0.4891f, 0.4607f } },
    { { 0.742399f, -0.413913f, 0.526801f }, { -0.219758f, -0.974834f, 0.037478f }, { -0.114571f, -0.818986f, 0.562259f } } },
  { { 0, 1, 16 }, { { 0.5633f, 0.1079f }, { 0.5459f, 0.1079f }, { 0.4661f, 0.1079f } },
    { { 0.653665f, -0.388399f, -0.649514f }, { 0.572657f, 0.497378f, -0.651674f }, { 0.0f, 0.0f, -1.0f } } },
  { { 1, 2, 16 }, { { 0.5459f, 0.1079f }, { 0.4185f, 0.1079f }, { 0.4661f, 0.1079f } },
    { { 0.572657f, 0.497378f, -0.651674f }, { -0.361908f, 0.69718f, -0.61884f }, { 0.0f, 0.0f, -1.0f } } },
  { { 2, 3, 16 }, { { 0.4185f, 0.1079f }, { 0.3566f, 0.1079f }, { 0.4661f, 0.1079f } },
    { { -0.361908f, 0.69718f, -0.61884f }, { -0.780228f, -0.104904f, -0.616635f }, { 0.0f, 0.0f, -1.0f } } },
  { { 3, 4, 16 }, { { 0.3566f, 0.1079f }, { 0.4461f, 0.1079f }, { 0.4661f, 0.1079f } },
    { { -0.780228f, -0.104904f, -0.616635f }, { -0.190365f, -0.756237f, -0.625992f }, { 0.0f, 0.0f, -1.0f } } },
  { { 4, 0, 16 }, { { 0.4461f, 0.1079f }, { 0.5633f, 0.1079f }, { 0.4661f, 0.1079f } },
    { { -0.190365f, -0.756237f, -0.625992f }, { 0.653665f, -0.388399f, -0.649514f }, { 0.0f, 0.0f, -1.0f } } },
  { { 11, 10, 15 }, { { 0.6002f, 0.4575f }, { 0.6191f, 0.4562f }, { 0.5065f, 0.4848f } },
    { { 0.661176f, 0.53514f, 0.525806f }, { 0.742399f, -0.413913f, 0.526801f }, { 0.08903f, -0.040503f, 0.995205f } } },
  { { 12, 11, 15 }, { { 0.4595f, 0.467f }, { 0.6002f, 0.4575f }, { 0.5065f, 0.4848f } },
    { { -0.294965f, 0.718815f, 0.629524f }, { 0.661176f, 0.53514f, 0.525806f }, { 0.08903f, -0.040503f, 0.995205f } } },
  { { 13, 12, 15 }, { { 0.3914f, 0.4715f }, { 0.4595f, 0.467f }, { 0.5065f, 0.4848f } },
    { { -0.742081f, -0.137407f, 0.656076f }, { -0.294965f, 0.718815f, 0.629524f }, { 0.08903f, -0.040503f, 0.995205f } } },
  { { 14, 13, 15 }, { { 0.4891f, 0.4607f }, { 0.3914f, 0.4715f }, { 0.5065f, 0.4848f } },
    { { -0.114571f, -0.818986f, 0.562259f }, { -0.742081f, -0.137407f, 0.656076f }, { 0.08903f, -0.040503f, 0.995205f } } },
  { { 15, 10, 14 }, { { 0.5065f, 0.4848f }, { 0.6191f, 0.4562f }, { 0.4891f, 0.4607f } },
    { { 0.08903f, -0.040503f, 0.995205f }, { 0.742399f, -0.413913f, 0.526801f }, { -0.114571f, -0.818986f, 0.562259f } } }
};

TEST_XYZ Redknight_xyz_Rl_leg[12] = {
  { -0.20482f, 0.03366f, -0.68825f }, { -0.16881f, 0.03029f, -0.53313f },
  { -0.17387f, 0.08768f, -0.69125f }, { -0.14555f, 0.07099f, -0.5352f },
  { -0.11217f, 0.08787f, -0.69931f }, { -0.09904f, 0.07117f, -0.54139f },
  { -0.08122f, 0.03404f, -0.70456f }, { -0.07578f, 0.03047f, -0.54533f },
  { -0.11217f, -0.01998f, -0.70175f }, { -0.09885f, -0.03442f, -0.54214f },
  { -0.17387f, -0.01998f, -0.6935f }, { -0.14536f, -0.03442f, -0.53595f }
};

TEST_TRIANGLE1 Redknight_triangle1_Rl_leg[12] = {
  { { 0, 3, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.974168f, -0.005446f, 0.225759f }, { -0.48111f, 0.858103f, 0.179422f }, { -0.978356f, 0.061205f, 0.19767f } } },
  { { 2, 3, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.480381f, 0.858613f, 0.178937f }, { -0.48111f, 0.858103f, 0.179422f }, { -0.974168f, -0.005446f, 0.225759f } } },
  { { 2, 5, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.480381f, 0.858613f, 0.178937f }, { 0.506153f, 0.861047f, 0.049064f }, { -0.48111f, 0.858103f, 0.179422f } } },
  { { 4, 5, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.505424f, 0.861453f, 0.04944f }, { 0.506153f, 0.861047f, 0.049064f }, { -0.480381f, 0.858613f, 0.178937f } } },
  { { 4, 7, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.505424f, 0.861453f, 0.04944f }, { 0.995611f, 0.087773f, -0.032475f }, { 0.506153f, 0.861047f, 0.049064f } } },
  { { 6, 7, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.997552f, 0.023636f, -0.065821f }, { 0.995611f, 0.087773f, -0.032475f }, { 0.505424f, 0.861453f, 0.04944f } } },
  { { 6, 9, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.997552f, 0.023636f, -0.065821f }, { 0.523332f, -0.847351f, -0.090112f }, { 0.995611f, 0.087773f, -0.032475f } } },
  { { 8, 9, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.510349f, -0.851604f, -0.119643f }, { 0.523332f, -0.847351f, -0.090112f }, { 0.997552f, 0.023636f, -0.065821f } } },
  { { 11, 9, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.5471f, -0.83677f, 0.02232f }, { 0.523332f, -0.847351f, -0.090112f }, { 0.510349f, -0.851604f, -0.119643f } } },
  { { 11, 8, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.5471f, -0.83677f, 0.02232f }, { 0.510349f, -0.851604f, -0.119643f }, { -0.535609f, -0.842637f, 0.055541f } } },
  { { 11, 10, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.5471f, -0.83677f, 0.02232f }, { -0.535609f, -0.842637f, 0.055541f }, { -0.978356f, 0.061205f, 0.19767f } } },
  { { 1, 10, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.978356f, 0.061205f, 0.19767f }, { -0.535609f, -0.842637f, 0.055541f }, { -0.974168f, -0.005446f, 0.225759f } } }
};

TEST_XYZ Redknight_xyz_Rl_leg_1[18] = {
  { -0.18231f, 0.03929f, -0.9497f }, { -0.21795f, 0.03929f, -0.94502f },
  { -0.20482f, 0.03366f, -0.68825f }, { -0.17931f, 0.04454f, -0.94989f },
  { -0.19713f, 0.07548f, -0.94689f }, { -0.17387f, 0.08768f, -0.69125f },
  { -0.17331f, 0.04454f, -0.95083f }, { -0.15568f, 0.07567f, -0.95252f },
  { -0.11216f, 0.08786f, -0.69931f }, { -0.17031f, 0.03947f, -0.9512f },
  { -0.13486f, 0.03947f, -0.95589f }, { -0.08121f, 0.03403f, -0.70456f },
  { -0.17331f, 0.03422f, -0.95102f }, { -0.15568f, 0.00327f, -0.95402f },
  { -0.11216f, -0.01998f, -0.70175f }, { -0.17931f, 0.03422f, -0.95027f },
  { -0.19713f, 0.00327f, -0.94858f }, { -0.17387f, -0.01998f, -0.6935f }
};

TEST_TRIANGLE1 Redknight_triangle1_Rl_leg_1[24] = {
  { { 0, 4, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.126897f, 0.030423f, -0.991449f }, { -0.464437f, 0.678624f, -0.569006f }, { -0.845696f, 0.011987f, -0.533531f } } },
  { { 3, 4, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.129361f, 0.027601f, -0.991213f }, { -0.464437f, 0.678624f, -0.569006f }, { -0.126897f, 0.030423f, -0.991449f } } },
  { { 1, 5, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.845696f, 0.011987f, -0.533531f }, { -0.504131f, 0.863614f, 0.004789f }, { -0.998699f, -0.002231f, 0.050954f } } },
  { { 1, 4, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.845696f, 0.011987f, -0.533531f }, { -0.464437f, 0.678624f, -0.569006f }, { -0.504131f, 0.863614f, 0.004789f } } },
  { { 3, 7, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.129361f, 0.027601f, -0.991213f }, { 0.295453f, 0.67995f, -0.6711f }, { -0.464437f, 0.678624f, -0.569006f } } },
  { { 6, 7, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.142062f, 0.021163f, -0.989632f }, { 0.295453f, 0.67995f, -0.6711f }, { -0.129361f, 0.027601f, -0.991213f } } },
  { { 5, 4, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.504131f, 0.863614f, 0.004789f }, { -0.464437f, 0.678624f, -0.569006f }, { 0.483321f, 0.866481f, -0.124945f } } },
  { { 8, 4, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.483321f, 0.866481f, -0.124945f }, { -0.464437f, 0.678624f, -0.569006f }, { 0.295453f, 0.67995f, -0.6711f } } },
  { { 6, 10, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.142062f, 0.021163f, -0.989632f }, { 0.679592f, 0.014671f, -0.733443f }, { 0.295453f, 0.67995f, -0.6711f } } },
  { { 9, 10, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.127493f, 0.010928f, -0.991779f }, { 0.679592f, 0.014671f, -0.733443f }, { -0.142062f, 0.021163f, -0.989632f } } },
  { { 8, 7, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.483321f, 0.866481f, -0.124945f }, { 0.295453f, 0.67995f, -0.6711f }, { 0.977986f, 0.004979f, -0.208613f } } },
  { { 11, 7, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.977986f, 0.004979f, -0.208613f }, { 0.295453f, 0.67995f, -0.6711f }, { 0.679592f, 0.014671f, -0.733443f } } },
  { { 13, 10, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.296198f, -0.650801f, -0.699089f }, { 0.679592f, 0.014671f, -0.733443f }, { -0.127493f, 0.010928f, -0.991779f } } },
  { { 13, 9, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.296198f, -0.650801f, -0.699089f }, { -0.127493f, 0.010928f, -0.991779f }, { -0.120814f, 0.025565f, -0.992346f } } },
  { { 11, 10, 14 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.977986f, 0.004979f, -0.208613f }, { 0.679592f, 0.014671f, -0.733443f }, { 0.481955f, -0.86102f, -0.162372f } } },
  { { 13, 14, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.296198f, -0.650801f, -0.699089f }, { 0.481955f, -0.86102f, -0.162372f }, { 0.679592f, 0.014671f, -0.733443f } } },
  { { 13, 12, 16 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.296198f, -0.650801f, -0.699089f }, { -0.120814f, 0.025565f, -0.992346f }, { -0.464086f, -0.652467f, -0.599091f } } },
  { { 16, 12, 15 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.464086f, -0.652467f, -0.599091f }, { -0.120814f, 0.025565f, -0.992346f }, { -0.127531f, 0.022219f, -0.991586f } } },
  { { 17, 14, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.505089f, -0.862452f, -0.032571f }, { 0.481955f, -0.86102f, -0.162372f }, { 0.296198f, -0.650801f, -0.699089f } } },
  { { 13, 16, 17 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.296198f, -0.650801f, -0.699089f }, { -0.464086f, -0.652467f, -0.599091f }, { -0.505089f, -0.862452f, -0.032571f } } },
  { { 16, 15, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.464086f, -0.652467f, -0.599091f }, { -0.127531f, 0.022219f, -0.991586f }, { -0.845696f, 0.011987f, -0.533531f } } },
  { { 1, 15, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.845696f, 0.011987f, -0.533531f }, { -0.127531f, 0.022219f, -0.991586f }, { -0.126897f, 0.030423f, -0.991449f } } },
  { { 17, 16, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.505089f, -0.862452f, -0.032571f }, { -0.464086f, -0.652467f, -0.599091f }, { -0.998699f, -0.002231f, 0.050954f } } },
  { { 2, 16, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.998699f, -0.002231f, 0.050954f }, { -0.464086f, -0.652467f, -0.599091f }, { -0.845696f, 0.011987f, -0.533531f } } }
};

TEST_XYZ Redknight_xyz_Ru_arm[27] = {
  { -0.17909f, -0.03805f, 0.03099f }, { -0.17509f, 0.03495f, 0.03099f },
  { -0.22709f, 0.06495f, 0.01899f }, { -0.26409f, 0.00695f, 0.03099f },
  { -0.23509f, -0.04305f, 0.03399f }, { -0.17409f, -0.03905f, 0.14199f },
  { -0.16509f, 0.04295f, 0.14799f }, { -0.22809f, 0.07395f, 0.15199f },
  { -0.28009f, 0.00795f, 0.14199f }, { -0.23709f, -0.06805f, 0.13599f },
  { -0.18009f, -0.04205f, 0.22599f }, { -0.17509f, 0.03495f, 0.22599f },
  { -0.22809f, 0.06495f, 0.22599f }, { -0.26509f, 0.00695f, 0.22599f },
  { -0.23609f, -0.05905f, 0.22599f }, { -0.17209f, -0.05105f, 0.27599f },
  { -0.16809f, 0.04095f, 0.27499f }, { -0.22909f, 0.07995f, 0.27099f },
  { -0.27709f, 0.00795f, 0.27099f }, { -0.23809f, -0.06805f, 0.26799f },
  { -0.18009f, -0.04505f, 0.31399f }, { -0.18009f, 0.03695f, 0.31399f },
  { -0.22809f, 0.05995f, 0.31399f }, { -0.26509f, 0.00695f, 0.31299f },
  { -0.23609f, -0.05405f, 0.31399f }, { -0.24109f, 0.00995f, 0.32199f },
  { -0.22209f, -0.00605f, 0.00699f }
};

TEST_TRIANGLE1 Redknight_triangle1_Ru_arm[50] = {
  { { 6, 1, 0 }, { { 0.6316f, 0.1993f }, { 0.6045f, 0.0337f }, { 0.5917f, 0.0337f } },
    { { 0.873395f, 0.486408f, 0.024263f }, { 0.773293f, 0.392536f, -0.497929f }, { 0.618741f, -0.617659f, -0.485444f } } },
  { { 6, 0, 5 }, { { 0.6316f, 0.1993f }, { 0.5917f, 0.0337f }, { 0.6075f, 0.1906f } },
    { { 0.873395f, 0.486408f, 0.024263f }, { 0.618741f, -0.617659f, -0.485444f }, { 0.809693f, -0.586147f, -0.028783f } } },
  { { 7, 2, 1 }, { { 0.4591f, 0.2038f }, { 0.4622f, 0.0159f }, { 0.6045f, 0.0337f } },
    { { -0.220483f, 0.974805f, 0.033794f }, { -0.161726f, 0.775355f, -0.610467f }, { 0.773293f, 0.392536f, -0.497929f } } },
  { { 7, 1, 6 }, { { 0.4591f, 0.2038f }, { 0.6045f, 0.0337f }, { 0.6316f, 0.1993f } },
    { { -0.220483f, 0.974805f, 0.033794f }, { 0.773293f, 0.392536f, -0.497929f }, { 0.873395f, 0.486408f, 0.024263f } } },
  { { 2, 8, 3 }, { { 0.4622f, 0.0159f }, { 0.3158f, 0.1906f }, { 0.3598f, 0.0337f } },
    { { -0.161726f, 0.775355f, -0.610467f }, { -0.997065f, 0.075287f, 0.013868f }, { -0.873236f, -0.008289f, -0.487227f } } },
  { { 7, 8, 2 }, { { 0.4591f, 0.2038f }, { 0.3158f, 0.1906f }, { 0.4622f, 0.0159f } },
    { { -0.220483f, 0.974805f, 0.033794f }, { -0.997065f, 0.075287f, 0.013868f }, { -0.161726f, 0.775355f, -0.610467f } } },
  { { 3, 9, 4 }, { { 0.3598f, 0.0337f }, { 0.4335f, 0.1818f }, { 0.4397f, 0.0382f } },
    { { -0.873236f, -0.008289f, -0.487227f }, { -0.299798f, -0.950169f, -0.085435f }, { -0.381652f, -0.799518f, -0.463802f } } },
  { { 3, 8, 9 }, { { 0.3598f, 0.0337f }, { 0.3158f, 0.1906f }, { 0.4335f, 0.1818f } },
    { { -0.873236f, -0.008289f, -0.487227f }, { -0.997065f, 0.075287f, 0.013868f }, { -0.299798f, -0.950169f, -0.085435f } } },
  { { 5, 0, 4 }, { { 0.6075f, 0.1906f }, { 0.5917f, 0.0337f }, { 0.4397f, 0.0382f } },
    { { 0.809693f, -0.586147f, -0.028783f }, { 0.618741f, -0.617659f, -0.485444f }, { -0.381652f, -0.799518f, -0.463802f } } },
  { { 5, 4, 9 }, { { 0.6075f, 0.1906f }, { 0.4397f, 0.0382f }, { 0.4335f, 0.1818f } },
    { { 0.809693f, -0.586147f, -0.028783f }, { -0.381652f, -0.799518f, -0.463802f }, { -0.299798f, -0.950169f, -0.085435f } } },
  { { 6, 5, 11 }, { { 0.6316f, 0.1993f }, { 0.6075f, 0.1906f }, { 0.6024f, 0.3093f } },
    { { 0.873395f, 0.486408f, 0.024263f }, { 0.809693f, -0.586147f, -0.028783f }, { 0.893551f, 0.447895f, -0.030924f } } },
  { { 11, 5, 10 }, { { 0.6024f, 0.3093f }, { 0.6075f, 0.1906f }, { 0.5891f, 0.3093f } },
    { { 0.893551f, 0.447895f, -0.030924f }, { 0.809693f, -0.586147f, -0.028783f }, { 0.789716f, -0.608212f, -0.080168f } } },
  { { 7, 6, 12 }, { { 0.4591f, 0.2038f }, { 0.6316f, 0.1993f }, { 0.4596f, 0.3093f } },
    { { -0.220483f, 0.974805f, 0.033794f }, { 0.873395f, 0.486408f, 0.024263f }, { -0.263505f, 0.958794f, -0.106207f } } },
  { { 6, 11, 12 }, { { 0.6316f, 0.1993f }, { 0.6024f, 0.3093f }, { 0.4596f, 0.3093f } },
    { { 0.873395f, 0.486408f, 0.024263f }, { 0.893551f, 0.447895f, -0.030924f }, { -0.263505f, 0.958794f, -0.106207f } } },
  { { 13, 8, 7 }, { { 0.3573f, 0.3093f }, { 0.3158f, 0.1906f }, { 0.4591f, 0.2038f } },
    { { -0.995743f, 0.078177f, -0.048839f }, { -0.997065f, 0.075287f, 0.013868f }, { -0.220483f, 0.974805f, 0.033794f } } },
  { { 13, 7, 12 }, { { 0.3573f, 0.3093f }, { 0.4591f, 0.2038f }, { 0.4596f, 0.3093f } },
    { { -0.995743f, 0.078177f, -0.048839f }, { -0.220483f, 0.974805f, 0.033794f }, { -0.263505f, 0.958794f, -0.106207f } } },
  { { 9, 8, 14 }, { { 0.4335f, 0.1818f }, { 0.3158f, 0.1906f }, { 0.4376f, 0.3093f } },
    { { -0.299798f, -0.950169f, -0.085435f }, { -0.997065f, 0.075287f, 0.013868f }, { -0.423812f, -0.904574f, -0.046139f } } },
  { { 13, 14, 8 }, { { 0.3573f, 0.3093f }, { 0.4376f, 0.3093f }, { 0.3158f, 0.1906f } },
    { { -0.995743f, 0.078177f, -0.048839f }, { -0.423812f, -0.904574f, -0.046139f }, { -0.997065f, 0.075287f, 0.013868f } } },
  { { 5, 9, 10 }, { { 0.6075f, 0.1906f }, { 0.4335f, 0.1818f }, { 0.5891f, 0.3093f } },
    { { 0.809693f, -0.586147f, -0.028783f }, { -0.299798f, -0.950169f, -0.085435f }, { 0.789716f, -0.608212f, -0.080168f } } },
  { { 10, 9, 14 }, { { 0.5891f, 0.3093f }, { 0.4335f, 0.1818f }, { 0.4376f, 0.3093f } },
    { { 0.789716f, -0.608212f, -0.080168f }, { -0.299798f, -0.950169f, -0.085435f }, { -0.423812f, -0.904574f, -0.046139f } } },
  { { 11, 10, 16 }, { { 0.6024f, 0.3093f }, { 0.5891f, 0.3093f }, { 0.6229f, 0.378f } },
    { { 0.893551f, 0.447895f, -0.030924f }, { 0.789716f, -0.608212f, -0.080168f }, { 0.879631f, 0.469921f, 0.073647f } } },
  { { 16, 10, 15 }, { { 0.6229f, 0.378f }, { 0.5891f, 0.3093f }, { 0.6111f, 0.3798f } },
    { { 0.879631f, 0.469921f, 0.073647f }, { 0.789716f, -0.608212f, -0.080168f }, { 0.778564f, -0.626902f, 0.028838f } } },
  { { 12, 11, 17 }, { { 0.4596f, 0.3093f }, { 0.6024f, 0.3093f }, { 0.4576f, 0.3729f } },
    { { -0.263505f, 0.958794f, -0.106207f }, { 0.893551f, 0.447895f, -0.030924f }, { -0.193719f, 0.979747f, 0.050676f } } },
  { { 17, 11, 16 }, { { 0.4576f, 0.3729f }, { 0.6024f, 0.3093f }, { 0.6229f, 0.378f } },
    { { -0.193719f, 0.979747f, 0.050676f }, { 0.893551f, 0.447895f, -0.030924f }, { 0.879631f, 0.469921f, 0.073647f } } },
  { { 13, 12, 18 }, { { 0.3573f, 0.3093f }, { 0.4596f, 0.3093f }, { 0.326f, 0.3729f } },
    { { -0.995743f, 0.078177f, -0.048839f }, { -0.263505f, 0.958794f, -0.106207f }, { -0.998048f, 0.061977f, 0.007735f } } },
  { { 18, 12, 17 }, { { 0.326f, 0.3729f }, { 0.4596f, 0.3093f }, { 0.4576f, 0.3729f } },
    { { -0.998048f, 0.061977f, 0.007735f }, { -0.263505f, 0.958794f, -0.106207f }, { -0.193719f, 0.979747f, 0.050676f } } },
  { { 19, 14, 13 }, { { 0.431f, 0.3684f }, { 0.4376f, 0.3093f }, { 0.3573f, 0.3093f } },
    { { -0.404402f, -0.914562f, 0.005995f }, { -0.423812f, -0.904574f, -0.046139f }, { -0.995743f, 0.078177f, -0.048839f } } },
  { { 19, 13, 18 }, { { 0.431f, 0.3684f }, { 0.3573f, 0.3093f }, { 0.326f, 0.3729f } },
    { { -0.404402f, -0.914562f, 0.005995f }, { -0.995743f, 0.078177f, -0.048839f }, { -0.998048f, 0.061977f, 0.007735f } } },
  { { 10, 14, 15 }, { { 0.5891f, 0.3093f }, { 0.4376f, 0.3093f }, { 0.6111f, 0.3798f } },
    { { 0.789716f, -0.608212f, -0.080168f }, { -0.423812f, -0.904574f, -0.046139f }, { 0.778564f, -0.626902f, 0.028838f } } },
  { { 15, 14, 19 }, { { 0.6111f, 0.3798f }, { 0.4376f, 0.3093f }, { 0.431f, 0.3684f } },
    { { 0.778564f, -0.626902f, 0.028838f }, { -0.423812f, -0.904574f, -0.046139f }, { -0.404402f, -0.914562f, 0.005995f } } },
  { { 16, 15, 21 }, { { 0.6229f, 0.378f }, { 0.6111f, 0.3798f }, { 0.5901f, 0.4339f } },
    { { 0.879631f, 0.469921f, 0.073647f }, { 0.778564f, -0.626902f, 0.028838f }, { 0.61526f, 0.395363f, 0.682014f } } },
  { { 21, 15, 20 }, { { 0.5901f, 0.4339f }, { 0.6111f, 0.3798f }, { 0.5912f, 0.4339f } },
    { { 0.61526f, 0.395363f, 0.682014f }, { 0.778564f, -0.626902f, 0.028838f }, { 0.577026f, -0.475625f, 0.663944f } } },
  { { 17, 16, 22 }, { { 0.4576f, 0.3729f }, { 0.6229f, 0.378f }, { 0.4601f, 0.4339f } },
    { { -0.193719f, 0.979747f, 0.050676f }, { 0.879631f, 0.469921f, 0.073647f }, { -0.179915f, 0.69529f, 0.695846f } } },
  { { 22, 16, 21 }, { { 0.4601f, 0.4339f }, { 0.6229f, 0.378f }, { 0.5901f, 0.4339f } },
    { { -0.179915f, 0.69529f, 0.695846f }, { 0.879631f, 0.469921f, 0.073647f }, { 0.61526f, 0.395363f, 0.682014f } } },
  { { 18, 17, 23 }, { { 0.326f, 0.3729f }, { 0.4576f, 0.3729f }, { 0.3588f, 0.4318f } },
    { { -0.998048f, 0.061977f, 0.007735f }, { -0.193719f, 0.979747f, 0.050676f }, { -0.788811f, 0.054392f, 0.612225f } } },
  { { 23, 17, 22 }, { { 0.3588f, 0.4318f }, { 0.4576f, 0.3729f }, { 0.4601f, 0.4339f } },
    { { -0.788811f, 0.054392f, 0.612225f }, { -0.193719f, 0.979747f, 0.050676f }, { -0.179915f, 0.69529f, 0.695846f } } },
  { { 19, 18, 24 }, { { 0.431f, 0.3684f }, { 0.326f, 0.3729f }, { 0.4366f, 0.4339f } },
    { { -0.404402f, -0.914562f, 0.005995f }, { -0.998048f, 0.061977f, 0.007735f }, { -0.357386f, -0.653615f, 0.66713f } } },
  { { 24, 18, 23 }, { { 0.4366f, 0.4339f }, { 0.326f, 0.3729f }, { 0.3588f, 0.4318f } },
    { { -0.357386f, -0.653615f, 0.66713f }, { -0.998048f, 0.061977f, 0.007735f }, { -0.788811f, 0.054392f, 0.612225f } } },
  { { 15, 19, 20 }, { { 0.6111f, 0.3798f }, { 0.431f, 0.3684f }, { 0.5912f, 0.4339f } },
    { { 0.778564f, -0.626902f, 0.028838f }, { -0.404402f, -0.914562f, 0.005995f }, { 0.577026f, -0.475625f, 0.663944f } } },
  { { 20, 19, 24 }, { { 0.5912f, 0.4339f }, { 0.431f, 0.3684f }, { 0.4366f, 0.4339f } },
    { { 0.577026f, -0.475625f, 0.663944f }, { -0.404402f, -0.914562f, 0.005995f }, { -0.357386f, -0.653615f, 0.66713f } } },
  { { 0, 1, 26 }, { { 0.5917f, 0.0337f }, { 0.6045f, 0.0337f }, { 0.476f, 0.0f } },
    { { 0.618741f, -0.617659f, -0.485444f }, { 0.773293f, 0.392536f, -0.497929f }, { -0.071281f, -0.172034f, -0.982509f } } },
  { { 1, 2, 26 }, { { 0.6045f, 0.0337f }, { 0.4622f, 0.0159f }, { 0.476f, 0.0f } },
    { { 0.773293f, 0.392536f, -0.497929f }, { -0.161726f, 0.775355f, -0.610467f }, { -0.071281f, -0.172034f, -0.982509f } } },
  { { 2, 3, 26 }, { { 0.4622f, 0.0159f }, { 0.3598f, 0.0337f }, { 0.476f, 0.0f } },
    { { -0.161726f, 0.775355f, -0.610467f }, { -0.873236f, -0.008289f, -0.487227f }, { -0.071281f, -0.172034f, -0.982509f } } },
  { { 3, 4, 26 }, { { 0.3598f, 0.0337f }, { 0.4397f, 0.0382f }, { 0.476f, 0.0f } },
    { { -0.873236f, -0.008289f, -0.487227f }, { -0.381652f, -0.799518f, -0.463802f }, { -0.071281f, -0.172034f, -0.982509f } } },
  { { 4, 0, 26 }, { { 0.4397f, 0.0382f }, { 0.5917f, 0.0337f }, { 0.476f, 0.0f } },
    { { -0.381652f, -0.799518f, -0.463802f }, { 0.618741f, -0.617659f, -0.485444f }, { -0.071281f, -0.172034f, -0.982509f } } },
  { { 21, 20, 25 }, { { 0.5901f, 0.4339f }, { 0.5912f, 0.4339f }, { 0.4223f, 0.4448f } },
    { { 0.61526f, 0.395363f, 0.682014f }, { 0.577026f, -0.475625f, 0.663944f }, { -0.1614f, 0.045254f, 0.985851f } } },
  { { 22, 21, 25 }, { { 0.4601f, 0.4339f }, { 0.5901f, 0.4339f }, { 0.4223f, 0.4448f } },
    { { -0.179915f, 0.69529f, 0.695846f }, { 0.61526f, 0.395363f, 0.682014f }, { -0.1614f, 0.045254f, 0.985851f } } },
  { { 23, 22, 25 }, { { 0.3588f, 0.4318f }, { 0.4601f, 0.4339f }, { 0.4223f, 0.4448f } },
    { { -0.788811f, 0.054392f, 0.612225f }, { -0.179915f, 0.69529f, 0.695846f }, { -0.1614f, 0.045254f, 0.985851f } } },
  { { 24, 23, 25 }, { { 0.4366f, 0.4339f }, { 0.3588f, 0.4318f }, { 0.4223f, 0.4448f } },
    { { -0.357386f, -0.653615f, 0.66713f }, { -0.788811f, 0.054392f, 0.612225f }, { -0.1614f, 0.045254f, 0.985851f } } },
  { { 20, 24, 25 }, { { 0.5912f, 0.4339f }, { 0.4366f, 0.4339f }, { 0.4223f, 0.4448f } },
    { { 0.577026f, -0.475625f, 0.663944f }, { -0.357386f, -0.653615f, 0.66713f }, { -0.1614f, 0.045254f, 0.985851f } } }
};

TEST_XYZ Redknight_xyz_Ru_leg[18] = {
  { -0.1553f, 0.02616f, -0.21222f }, { -0.17293f, 0.03179f, -0.54214f },
  { -0.15943f, 0.02804f, -0.32232f }, { -0.11929f, 0.08899f, -0.21579f },
  { -0.14949f, 0.07268f, -0.54439f }, { -0.12848f, 0.10156f, -0.32513f },
  { -0.04745f, 0.08918f, -0.22516f }, { -0.10297f, 0.07268f, -0.55058f },
  { -0.06696f, 0.10156f, -0.3332f }, { -0.01144f, 0.02635f, -0.23116f },
  { -0.07971f, 0.03198f, -0.55433f }, { -0.03601f, 0.02823f, -0.33864f },
  { -0.04745f, -0.03629f, -0.22741f }, { -0.10278f, -0.03273f, -0.55077f },
  { -0.06527f, -0.05168f, -0.32307f }, { -0.11929f, -0.03648f, -0.21804f },
  { -0.1493f, -0.03292f, -0.54476f }, { -0.12848f, -0.05805f, -0.32795f }
};

TEST_TRIANGLE1 Redknight_triangle1_Ru_leg[24] = {
  { { 1, 5, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.996167f, 0.076012f, 0.043293f }, { -0.527054f, 0.848471f, 0.048081f }, { -0.997262f, 0.03775f, 0.063585f } } },
  { { 4, 5, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.520695f, 0.851472f, -0.062226f }, { -0.527054f, 0.848471f, 0.048081f }, { -0.996167f, 0.076012f, 0.043293f } } },
  { { 2, 3, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.997262f, 0.03775f, 0.063585f }, { -0.538368f, 0.835759f, 0.108015f }, { -0.995759f, 0.036509f, 0.084448f } } },
  { { 2, 5, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.997262f, 0.03775f, 0.063585f }, { -0.527054f, 0.848471f, 0.048081f }, { -0.538368f, 0.835759f, 0.108015f } } },
  { { 4, 8, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.520695f, 0.851472f, -0.062226f }, { 0.510165f, 0.853369f, -0.107206f }, { -0.527054f, 0.848471f, 0.048081f } } },
  { { 7, 8, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.502454f, 0.846679f, -0.175143f }, { 0.510165f, 0.853369f, -0.107206f }, { -0.520695f, 0.851472f, -0.062226f } } },
  { { 3, 5, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.538368f, 0.835759f, 0.108015f }, { -0.527054f, 0.848471f, 0.048081f }, { 0.526928f, 0.849905f, 0.002805f } } },
  { { 6, 5, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.526928f, 0.849905f, 0.002805f }, { -0.527054f, 0.848471f, 0.048081f }, { 0.510165f, 0.853369f, -0.107206f } } },
  { { 7, 11, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.502454f, 0.846679f, -0.175143f }, { 0.979541f, 0.004638f, -0.201193f }, { 0.510165f, 0.853369f, -0.107206f } } },
  { { 10, 11, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.977381f, 0.090582f, -0.191106f }, { 0.979541f, 0.004638f, -0.201193f }, { 0.502454f, 0.846679f, -0.175143f } } },
  { { 6, 8, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.526928f, 0.849905f, 0.002805f }, { 0.510165f, 0.853369f, -0.107206f }, { 0.980826f, -0.020986f, -0.193752f } } },
  { { 9, 8, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.980826f, -0.020986f, -0.193752f }, { 0.510165f, 0.853369f, -0.107206f }, { 0.979541f, 0.004638f, -0.201193f } } },
  { { 10, 14, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.977381f, 0.090582f, -0.191106f }, { 0.57287f, -0.818226f, -0.048221f }, { 0.979541f, 0.004638f, -0.201193f } } },
  { { 13, 14, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.571114f, -0.801514f, -0.17721f }, { 0.57287f, -0.818226f, -0.048221f }, { 0.977381f, 0.090582f, -0.191106f } } },
  { { 9, 11, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.980826f, -0.020986f, -0.193752f }, { 0.979541f, 0.004638f, -0.201193f }, { 0.570087f, -0.82134f, -0.020044f } } },
  { { 11, 14, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.979541f, 0.004638f, -0.201193f }, { 0.57287f, -0.818226f, -0.048221f }, { 0.570087f, -0.82134f, -0.020044f } } },
  { { 17, 14, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.494756f, -0.867197f, 0.056448f }, { 0.57287f, -0.818226f, -0.048221f }, { 0.571114f, -0.801514f, -0.17721f } } },
  { { 17, 13, 16 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.494756f, -0.867197f, 0.056448f }, { 0.571114f, -0.801514f, -0.17721f }, { -0.590133f, -0.8065f, -0.036058f } } },
  { { 12, 14, 15 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.570087f, -0.82134f, -0.020044f }, { 0.57287f, -0.818226f, -0.048221f }, { -0.504205f, -0.841382f, 0.19456f } } },
  { { 17, 15, 14 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.494756f, -0.867197f, 0.056448f }, { -0.504205f, -0.841382f, 0.19456f }, { 0.57287f, -0.818226f, -0.048221f } } },
  { { 17, 16, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.494756f, -0.867197f, 0.056448f }, { -0.590133f, -0.8065f, -0.036058f }, { -0.997262f, 0.03775f, 0.063585f } } },
  { { 2, 16, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.997262f, 0.03775f, 0.063585f }, { -0.590133f, -0.8065f, -0.036058f }, { -0.996167f, 0.076012f, 0.043293f } } },
  { { 15, 17, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.504205f, -0.841382f, 0.19456f }, { -0.494756f, -0.867197f, 0.056448f }, { -0.995759f, 0.036509f, 0.084448f } } },
  { { 0, 17, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.995759f, 0.036509f, 0.084448f }, { -0.494756f, -0.867197f, 0.056448f }, { -0.997262f, 0.03775f, 0.063585f } } }
};

TEST_XYZ Redknight_xyz_R_foot[14] = {
  { -0.09641f, 0.10925f, -1.04724f }, { -0.09659f, -0.02242f, -1.04705f },
  { -0.1266f, -0.21298f, -1.05155f }, { -0.20519f, -0.2141f, -1.04968f },
  { -0.23876f, 0.03891f, -1.05024f }, { -0.19938f, 0.12181f, -1.04874f },
  { -0.14742f, 0.04135f, -0.9302f }, { -0.14742f, -0.01267f, -1.01498f },
  { -0.12454f, -0.21898f, -1.02361f }, { -0.18418f, -0.2051f, -1.01835f },
  { -0.2005f, -0.0061f, -0.93414f }, { -0.19469f, 0.07117f, -0.92908f },
  { -0.1478f, -0.01454f, -0.93133f }, { -0.1478f, -0.01304f, -1.04705f }
};

TEST_TRIANGLE1 Redknight_triangle1_R_foot[24] = {
  { { 1, 7, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.96031f, 0.02847f, -0.277478f }, { 0.887011f, -0.041425f, 0.459887f }, { 0.741623f, 0.584531f, -0.32912f } } },
  { { 0, 7, 6 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.741623f, 0.584531f, -0.32912f }, { 0.887011f, -0.041425f, 0.459887f }, { 0.631868f, 0.233038f, 0.739213f } } },
  { { 2, 8, 1 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.461349f, -0.599002f, -0.654487f }, { 0.513432f, -0.782836f, 0.351505f }, { 0.96031f, 0.02847f, -0.277478f } } },
  { { 1, 8, 7 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.96031f, 0.02847f, -0.277478f }, { 0.513432f, -0.782836f, 0.351505f }, { 0.887011f, -0.041425f, 0.459887f } } },
  { { 9, 2, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.334393f, -0.676866f, 0.65577f }, { 0.461349f, -0.599002f, -0.654487f }, { -0.620806f, -0.682956f, -0.384931f } } },
  { { 2, 9, 8 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.461349f, -0.599002f, -0.654487f }, { -0.334393f, -0.676866f, 0.65577f }, { 0.513432f, -0.782836f, 0.351505f } } },
  { { 10, 3, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.607545f, -0.16452f, 0.77706f }, { -0.620806f, -0.682956f, -0.384931f }, { -0.82052f, 0.117382f, -0.559436f } } },
  { { 9, 3, 10 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.334393f, -0.676866f, 0.65577f }, { -0.620806f, -0.682956f, -0.384931f }, { -0.607545f, -0.16452f, 0.77706f } } },
  { { 11, 4, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.308451f, 0.589222f, 0.746777f }, { -0.82052f, 0.117382f, -0.559436f }, { -0.35751f, 0.830821f, -0.426525f } } },
  { { 10, 4, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.607545f, -0.16452f, 0.77706f }, { -0.82052f, 0.117382f, -0.559436f }, { -0.308451f, 0.589222f, 0.746777f } } },
  { { 0, 6, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.741623f, 0.584531f, -0.32912f }, { 0.631868f, 0.233038f, 0.739213f }, { -0.35751f, 0.830821f, -0.426525f } } },
  { { 5, 6, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.35751f, 0.830821f, -0.426525f }, { 0.631868f, 0.233038f, 0.739213f }, { -0.308451f, 0.589222f, 0.746777f } } },
  { { 1, 0, 13 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.96031f, 0.02847f, -0.277478f }, { 0.741623f, 0.584531f, -0.32912f }, { 0.015435f, 0.005595f, -0.999865f } } },
  { { 1, 13, 2 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.96031f, 0.02847f, -0.277478f }, { 0.015435f, 0.005595f, -0.999865f }, { 0.461349f, -0.599002f, -0.654487f } } },
  { { 2, 13, 3 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.461349f, -0.599002f, -0.654487f }, { 0.015435f, 0.005595f, -0.999865f }, { -0.620806f, -0.682956f, -0.384931f } } },
  { { 3, 13, 4 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.620806f, -0.682956f, -0.384931f }, { 0.015435f, 0.005595f, -0.999865f }, { -0.82052f, 0.117382f, -0.559436f } } },
  { { 4, 13, 5 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.82052f, 0.117382f, -0.559436f }, { 0.015435f, 0.005595f, -0.999865f }, { -0.35751f, 0.830821f, -0.426525f } } },
  { { 5, 13, 0 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.35751f, 0.830821f, -0.426525f }, { 0.015435f, 0.005595f, -0.999865f }, { 0.741623f, 0.584531f, -0.32912f } } },
  { { 6, 7, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.631868f, 0.233038f, 0.739213f }, { 0.887011f, -0.041425f, 0.459887f }, { 0.623495f, -0.164872f, 0.764246f } } },
  { { 7, 8, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.887011f, -0.041425f, 0.459887f }, { 0.513432f, -0.782836f, 0.351505f }, { 0.623495f, -0.164872f, 0.764246f } } },
  { { 12, 8, 9 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.623495f, -0.164872f, 0.764246f }, { 0.513432f, -0.782836f, 0.351505f }, { -0.334393f, -0.676866f, 0.65577f } } },
  { { 9, 10, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.334393f, -0.676866f, 0.65577f }, { -0.607545f, -0.16452f, 0.77706f }, { 0.623495f, -0.164872f, 0.764246f } } },
  { { 10, 11, 12 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { -0.607545f, -0.16452f, 0.77706f }, { -0.308451f, 0.589222f, 0.746777f }, { 0.623495f, -0.164872f, 0.764246f } } },
  { { 6, 12, 11 }, { { 0.0f, 0.0f }, { 0.0f, 0.0f }, { 0.0f, 0.0f } },
    { { 0.631868f, 0.233038f, 0.739213f }, { 0.623495f, -0.164872f, 0.764246f }, { -0.308451f, 0.589222f, 0.746777f } } }
};

TEST_XYZ Redknight_xyz_R_hand[18] = {
  { -0.26295f, -0.01872f, -0.40868f }, { -0.26695f, 0.04128f, -0.39068f },
  { -0.24195f, 0.04228f, -0.38468f }, { -0.23995f, -0.01972f, -0.40168f },
  { -0.28695f, -0.02372f, -0.31468f }, { -0.28895f, 0.06628f, -0.27668f },
  { -0.24095f, 0.03628f, -0.23868f }, { -0.25195f, -0.02472f, -0.31168f },
  { -0.24895f, -0.04672f, -0.32668f }, { -0.28195f, 0.05128f, -0.20168f },
  { -0.23195f, 0.05328f, -0.21168f }, { -0.23395f, -0.04572f, -0.32468f },
  { -0.25195f, -0.05072f, -0.30768f }, { -0.27495f, 0.00228f, -0.18868f },
  { -0.22495f, 0.01728f, -0.18868f }, { -0.23595f, -0.05172f, -0.30968f },
  { -0.25395f, 0.00328f, -0.19368f }, { -0.25195f, 0.01428f, -0.39868f }
};

TEST_TRIANGLE1 Redknight_triangle1_R_hand[32] = {
  { { 1, 5, 0 }, { { 0.463f, 0.1645f }, { 0.4026f, 0.3232f }, { 0.474f, 0.1392f } },
    { { -0.500314f, 0.645062f, -0.577564f }, { -0.516981f, 0.850093f, -0.10036f }, { -0.402251f, -0.473853f, -0.783363f } } },
  { { 0, 5, 4 }, { { 0.474f, 0.1392f }, { 0.4026f, 0.3232f }, { 0.4079f, 0.2701f } },
    { { -0.402251f, -0.473853f, -0.783363f }, { -0.516981f, 0.850093f, -0.10036f }, { -0.766748f, -0.641502f, 0.02393f } } },
  { { 6, 1, 2 }, { { 0.5319f, 0.3756f }, { 0.463f, 0.1645f }, { 0.5294f, 0.1724f } },
    { { 0.667554f, 0.583118f, -0.462974f }, { -0.500314f, 0.645062f, -0.577564f }, { 0.64855f, 0.677097f, -0.347739f } } },
  { { 6, 5, 1 }, { { 0.5319f, 0.3756f }, { 0.4026f, 0.3232f }, { 0.463f, 0.1645f } },
    { { 0.667554f, 0.583118f, -0.462974f }, { -0.516981f, 0.850093f, -0.10036f }, { -0.500314f, 0.645062f, -0.577564f } } },
  { { 7, 2, 3 }, { { 0.5027f, 0.2739f }, { 0.5294f, 0.1724f }, { 0.5345f, 0.1481f } },
    { { 0.694917f, 0.203137f, -0.689801f }, { 0.64855f, 0.677097f, -0.347739f }, { 0.680063f, -0.52669f, -0.510012f } } },
  { { 6, 2, 7 }, { { 0.5319f, 0.3756f }, { 0.5294f, 0.1724f }, { 0.5027f, 0.2739f } },
    { { 0.667554f, 0.583118f, -0.462974f }, { 0.64855f, 0.677097f, -0.347739f }, { 0.694917f, 0.203137f, -0.689801f } } },
  { { 0, 4, 3 }, { { 0.474f, 0.1392f }, { 0.4079f, 0.2701f }, { 0.5345f, 0.1481f } },
    { { -0.402251f, -0.473853f, -0.783363f }, { -0.766748f, -0.641502f, 0.02393f }, { 0.680063f, -0.52669f, -0.510012f } } },
  { { 3, 4, 7 }, { { 0.5345f, 0.1481f }, { 0.4079f, 0.2701f }, { 0.5027f, 0.2739f } },
    { { 0.680063f, -0.52669f, -0.510012f }, { -0.766748f, -0.641502f, 0.02393f }, { 0.694917f, 0.203137f, -0.689801f } } },
  { { 4, 5, 9 }, { { 0.4079f, 0.2701f }, { 0.4026f, 0.3232f }, { 0.4205f, 0.427f } },
    { { -0.766748f, -0.641502f, 0.02393f }, { -0.516981f, 0.850093f, -0.10036f }, { -0.634778f, 0.51829f, 0.573091f } } },
  { { 4, 9, 8 }, { { 0.4079f, 0.2701f }, { 0.4205f, 0.427f }, { 0.5105f, 0.2533f } },
    { { -0.766748f, -0.641502f, 0.02393f }, { -0.634778f, 0.51829f, 0.573091f }, { -0.332941f, -0.404886f, -0.851597f } } },
  { { 6, 10, 5 }, { { 0.5319f, 0.3756f }, { 0.5571f, 0.4132f }, { 0.4026f, 0.3232f } },
    { { 0.667554f, 0.583118f, -0.462974f }, { 0.655062f, 0.726711f, 0.206845f }, { -0.516981f, 0.850093f, -0.10036f } } },
  { { 5, 10, 9 }, { { 0.4026f, 0.3232f }, { 0.5571f, 0.4132f }, { 0.4205f, 0.427f } },
    { { -0.516981f, 0.850093f, -0.10036f }, { 0.655062f, 0.726711f, 0.206845f }, { -0.634778f, 0.51829f, 0.573091f } } },
  { { 6, 7, 11 }, { { 0.5319f, 0.3756f }, { 0.5027f, 0.2739f }, { 0.5531f, 0.2563f } },
    { { 0.667554f, 0.583118f, -0.462974f }, { 0.694917f, 0.203137f, -0.689801f }, { 0.639351f, -0.23585f, -0.731851f } } },
  { { 11, 10, 6 }, { { 0.5531f, 0.2563f }, { 0.5571f, 0.4132f }, { 0.5319f, 0.3756f } },
    { { 0.639351f, -0.23585f, -0.731851f }, { 0.655062f, 0.726711f, 0.206845f }, { 0.667554f, 0.583118f, -0.462974f } } },
  { { 4, 8, 7 }, { { 0.4079f, 0.2701f }, { 0.5105f, 0.2533f }, { 0.5027f, 0.2739f } },
    { { -0.766748f, -0.641502f, 0.02393f }, { -0.332941f, -0.404886f, -0.851597f }, { 0.694917f, 0.203137f, -0.689801f } } },
  { { 7, 8, 11 }, { { 0.5027f, 0.2739f }, { 0.5105f, 0.2533f }, { 0.5531f, 0.2563f } },
    { { 0.694917f, 0.203137f, -0.689801f }, { -0.332941f, -0.404886f, -0.851597f }, { 0.639351f, -0.23585f, -0.731851f } } },
  { { 8, 9, 13 }, { { 0.5105f, 0.2533f }, { 0.4205f, 0.427f }, { 0.4407f, 0.4451f } },
    { { -0.332941f, -0.404886f, -0.851597f }, { -0.634778f, 0.51829f, 0.573091f }, { -0.568624f, -0.44851f, 0.689569f } } },
  { { 8, 13, 12 }, { { 0.5105f, 0.2533f }, { 0.4407f, 0.4451f }, { 0.5041f, 0.279f } },
    { { -0.332941f, -0.404886f, -0.851597f }, { -0.568624f, -0.44851f, 0.689569f }, { -0.625717f, -0.78005f, 0.000872f } } },
  { { 9, 10, 14 }, { { 0.4205f, 0.427f }, { 0.5571f, 0.4132f }, { 0.5777f, 0.4456f } },
    { { -0.634778f, 0.51829f, 0.573091f }, { 0.655062f, 0.726711f, 0.206845f }, { 0.70266f, -0.097595f, 0.704801f } } },
  { { 13, 9, 14 }, { { 0.4407f, 0.4451f }, { 0.4205f, 0.427f }, { 0.5777f, 0.4456f } },
    { { -0.568624f, -0.44851f, 0.689569f }, { -0.634778f, 0.51829f, 0.573091f }, { 0.70266f, -0.097595f, 0.704801f } } },
  { { 11, 15, 10 }, { { 0.5531f, 0.2563f }, { 0.5475f, 0.2767f }, { 0.5571f, 0.4132f } },
    { { 0.639351f, -0.23585f, -0.731851f }, { 0.54858f, -0.835726f, 0.024943f }, { 0.655062f, 0.726711f, 0.206845f } } },
  { { 10, 15, 14 }, { { 0.5571f, 0.4132f }, { 0.5475f, 0.2767f }, { 0.5777f, 0.4456f } },
    { { 0.655062f, 0.726711f, 0.206845f }, { 0.54858f, -0.835726f, 0.024943f }, { 0.70266f, -0.097595f, 0.704801f } } },
  { { 8, 12, 11 }, { { 0.5105f, 0.2533f }, { 0.5041f, 0.279f }, { 0.5531f, 0.2563f } },
    { { -0.332941f, -0.404886f, -0.851597f }, { -0.625717f, -0.78005f, 0.000872f }, { 0.639351f, -0.23585f, -0.731851f } } },
  { { 11, 12, 15 }, { { 0.5531f, 0.2563f }, { 0.5041f, 0.279f }, { 0.5475f, 0.2767f } },
    { { 0.639351f, -0.23585f, -0.731851f }, { -0.625717f, -0.78005f, 0.000872f }, { 0.54858f, -0.835726f, 0.024943f } } },
  { { 1, 0, 17 }, { { 0.463f, 0.1645f }, { 0.474f, 0.1392f }, { 0.5018f, 0.1523f } },
    { { -0.500314f, 0.645062f, -0.577564f }, { -0.402251f, -0.473853f, -0.783363f }, { 0.254357f, 0.279583f, -0.925816f } } },
  { { 1, 17, 2 }, { { 0.463f, 0.1645f }, { 0.5018f, 0.1523f }, { 0.5294f, 0.1724f } },
    { { -0.500314f, 0.645062f, -0.577564f }, { 0.254357f, 0.279583f, -0.925816f }, { 0.64855f, 0.677097f, -0.347739f } } },
  { { 2, 17, 3 }, { { 0.5294f, 0.1724f }, { 0.5018f, 0.1523f }, { 0.5345f, 0.1481f } },
    { { 0.64855f, 0.677097f, -0.347739f }, { 0.254357f, 0.279583f, -0.925816f }, { 0.680063f, -0.52669f, -0.510012f } } },
  { { 3, 17, 0 }, { { 0.5345f, 0.1481f }, { 0.5018f, 0.1523f }, { 0.474f, 0.1392f } },
    { { 0.680063f, -0.52669f, -0.510012f }, { 0.254357f, 0.279583f, -0.925816f }, { -0.402251f, -0.473853f, -0.783363f } } },
  { { 12, 13, 16 }, { { 0.5041f, 0.279f }, { 0.4407f, 0.4451f }, { 0.4981f, 0.4386f } },
    { { -0.625717f, -0.78005f, 0.000872f }, { -0.568624f, -0.44851f, 0.689569f }, { 0.220037f, -0.799011f, 0.559612f } } },
  { { 13, 14, 16 }, { { 0.4407f, 0.4451f }, { 0.5777f, 0.4456f }, { 0.4981f, 0.4386f } },
    { { -0.568624f, -0.44851f, 0.689569f }, { 0.70266f, -0.097595f, 0.704801f }, { 0.220037f, -0.799011f, 0.559612f } } },
  { { 14, 15, 16 }, { { 0.5777f, 0.4456f }, { 0.5475f, 0.2767f }, { 0.4981f, 0.4386f } },
    { { 0.70266f, -0.097595f, 0.704801f }, { 0.54858f, -0.835726f, 0.024943f }, { 0.220037f, -0.799011f, 0.559612f } } },
  { { 12, 16, 15 }, { { 0.5041f, 0.279f }, { 0.4981f, 0.4386f }, { 0.5475f, 0.2767f } },
    { { -0.625717f, -0.78005f, 0.000872f }, { 0.220037f, -0.799011f, 0.559612f }, { 0.54858f, -0.835726f, 0.024943f } } }
};

TEST_XYZ Redknight_xyz_Torso[40] = {
  { -0.00275f, -0.01041f, 0.42738f }, { -0.10275f, -0.00241f, -0.02962f },
  { -0.15275f, -0.00341f, 0.05238f }, { -0.18675f, -0.00541f, 0.15838f },
  { -0.18675f, -0.00841f, 0.31738f }, { -0.05675f, -0.00941f, 0.34738f },
  { -0.04675f, -0.01041f, 0.42238f }, { -0.00375f, -0.01141f, 0.42738f },
  { -0.05275f, 0.06159f, -0.02862f }, { -0.07775f, 0.09359f, 0.05338f },
  { -0.09475f, 0.12559f, 0.22138f }, { -0.09575f, 0.06359f, 0.31838f },
  { -0.02975f, 0.02759f, 0.34838f }, { -0.02575f, 0.01959f, 0.42338f },
  { 0.04525f, 0.06159f, -0.02862f }, { 0.07025f, 0.09359f, 0.05338f },
  { 0.08725f, 0.12559f, 0.21738f }, { 0.08825f, 0.09859f, 0.31838f },
  { 0.02225f, 0.02759f, 0.34838f }, { 0.01825f, 0.01959f, 0.42338f },
  { -0.00475f, -0.01041f, 0.42738f }, { 0.09525f, -0.00241f, -0.02962f },
  { 0.14525f, -0.00341f, 0.05238f }, { 0.17925f, -0.00541f, 0.15838f },
  { 0.17925f, -0.00841f, 0.31738f }, { 0.04925f, -0.00941f, 0.34738f },
  { 0.03925f, -0.01041f, 0.42238f }, { -0.00375f, -0.00941f, 0.42738f },
  { 0.04525f, -0.06641f, -0.03062f }, { 0.07025f, -0.10241f, 0.05038f },
  { 0.08825f, -0.12841f, 0.15638f }, { 0.08825f, -0.10141f, 0.31538f },
  { 0.02225f, -0.04541f, 0.34738f }, { 0.01825f, -0.04041f, 0.42238f },
  { -0.05275f, -0.06641f, -0.03062f }, { -0.07775f, -0.10241f, 0.05038f },
  { -0.09575f, -0.12841f, 0.15638f }, { -0.09575f, -0.10341f, 0.31538f },
  { -0.02975f, -0.04541f, 0.34738f }, { -0.02575f, -0.04041f, 0.42238f }
};

TEST_TRIANGLE1 Redknight_triangle1_Torso[70] = {
  { { 1, 9, 2 }, { { 0.2308f, 0.1814f }, { 0.2968f, 0.3303f }, { 0.0936f, 0.3273f } },
    { { -0.852774f, 0.004233f, -0.522263f }, { -0.424111f, 0.848679f, -0.316028f }, { -0.918997f, 0.018274f, -0.39384f } } },
  { { 8, 9, 1 }, { { 0.3654f, 0.1834f }, { 0.2968f, 0.3303f }, { 0.2308f, 0.1814f } },
    { { -0.368466f, 0.822483f, -0.433306f }, { -0.424111f, 0.848679f, -0.316028f }, { -0.852774f, 0.004233f, -0.522263f } } },
  { { 2, 10, 3 }, { { 0.0936f, 0.3273f }, { 0.2523f, 0.6302f }, { 0.0f, 0.5172f } },
    { { -0.918997f, 0.018274f, -0.39384f }, { -0.469166f, 0.87331f, 0.131201f }, { -0.991057f, 0.031682f, -0.129622f } } },
  { { 2, 9, 10 }, { { 0.0936f, 0.3273f }, { 0.2968f, 0.3303f }, { 0.2523f, 0.6302f } },
    { { -0.918997f, 0.018274f, -0.39384f }, { -0.424111f, 0.848679f, -0.316028f }, { -0.469166f, 0.87331f, 0.131201f } } },
  { { 3, 11, 4 }, { { 0.0f, 0.5172f }, { 0.2502f, 0.8043f }, { 0.0005f, 0.802f } },
    { { -0.991057f, 0.031682f, -0.129622f }, { -0.414441f, 0.633577f, 0.653314f }, { -0.850374f, 0.067535f, 0.521826f } } },
  { { 3, 10, 11 }, { { 0.0f, 0.5172f }, { 0.2523f, 0.6302f }, { 0.2502f, 0.8043f } },
    { { -0.991057f, 0.031682f, -0.129622f }, { -0.469166f, 0.87331f, 0.131201f }, { -0.414441f, 0.633577f, 0.653314f } } },
  { { 4, 12, 5 }, { { 0.0005f, 0.802f }, { 0.4283f, 0.8585f }, { 0.3567f, 0.8575f } },
    { { -0.850374f, 0.067535f, 0.521826f }, { -0.268997f, 0.739227f, 0.617402f }, { -0.603434f, -0.037645f, 0.796524f } } },
  { { 4, 11, 12 }, { { 0.0005f, 0.802f }, { 0.2502f, 0.8043f }, { 0.4283f, 0.8585f } },
    { { -0.850374f, 0.067535f, 0.521826f }, { -0.414441f, 0.633577f, 0.653314f }, { -0.268997f, 0.739227f, 0.617402f } } },
  { { 5, 13, 6 }, { { 0.3567f, 0.8575f }, { 0.4411f, 0.9929f }, { 0.3823f, 0.9919f } },
    { { -0.603434f, -0.037645f, 0.796524f }, { -0.362179f, 0.682137f, 0.635228f }, { -0.792093f, -0.013962f, 0.610241f } } },
  { { 5, 12, 13 }, { { 0.3567f, 0.8575f }, { 0.4283f, 0.8585f }, { 0.4411f, 0.9929f } },
    { { -0.603434f, -0.037645f, 0.796524f }, { -0.268997f, 0.739227f, 0.617402f }, { -0.362179f, 0.682137f, 0.635228f } } },
  { { 6, 7, 0 }, { { 0.3823f, 0.9919f }, { 0.501f, 0.9997f }, { 0.5026f, 0.9997f } },
    { { -0.792093f, -0.013962f, 0.610241f }, { 0.031914f, -0.105838f, -0.993871f }, { 0.092474f, -0.000913f, -0.995715f } } },
  { { 6, 13, 7 }, { { 0.3823f, 0.9919f }, { 0.4411f, 0.9929f }, { 0.501f, 0.9997f } },
    { { -0.792093f, -0.013962f, 0.610241f }, { -0.362179f, 0.682137f, 0.635228f }, { 0.031914f, -0.105838f, -0.993871f } } },
  { { 8, 15, 9 }, { { 0.3654f, 0.1834f }, { 0.7032f, 0.3303f }, { 0.2968f, 0.3303f } },
    { { -0.368466f, 0.822483f, -0.433306f }, { 0.418498f, 0.848951f, -0.32271f }, { -0.424111f, 0.848679f, -0.316028f } } },
  { { 14, 15, 8 }, { { 0.6346f, 0.1834f }, { 0.7032f, 0.3303f }, { 0.3654f, 0.1834f } },
    { { 0.37072f, 0.822213f, -0.431895f }, { 0.418498f, 0.848951f, -0.32271f }, { -0.368466f, 0.822483f, -0.433306f } } },
  { { 10, 9, 16 }, { { 0.2523f, 0.6302f }, { 0.2968f, 0.3303f }, { 0.7477f, 0.6241f } },
    { { -0.469166f, 0.87331f, 0.131201f }, { -0.424111f, 0.848679f, -0.316028f }, { 0.424981f, 0.905175f, 0.007011f } } },
  { { 16, 9, 15 }, { { 0.7477f, 0.6241f }, { 0.2968f, 0.3303f }, { 0.7032f, 0.3303f } },
    { { 0.424981f, 0.905175f, 0.007011f }, { -0.424111f, 0.848679f, -0.316028f }, { 0.418498f, 0.848951f, -0.32271f } } },
  { { 11, 10, 17 }, { { 0.2502f, 0.8043f }, { 0.2523f, 0.6302f }, { 0.7498f, 0.8054f } },
    { { -0.414441f, 0.633577f, 0.653314f }, { -0.469166f, 0.87331f, 0.131201f }, { 0.332816f, 0.700982f, 0.63076f } } },
  { { 10, 16, 17 }, { { 0.2523f, 0.6302f }, { 0.7477f, 0.6241f }, { 0.7498f, 0.8054f } },
    { { -0.469166f, 0.87331f, 0.131201f }, { 0.424981f, 0.905175f, 0.007011f }, { 0.332816f, 0.700982f, 0.63076f } } },
  { { 12, 11, 18 }, { { 0.4283f, 0.8585f }, { 0.2502f, 0.8043f }, { 0.5717f, 0.8585f } },
    { { -0.268997f, 0.739227f, 0.617402f }, { -0.414441f, 0.633577f, 0.653314f }, { 0.267447f, 0.664798f, 0.697507f } } },
  { { 18, 11, 17 }, { { 0.5717f, 0.8585f }, { 0.2502f, 0.8043f }, { 0.7498f, 0.8054f } },
    { { 0.267447f, 0.664798f, 0.697507f }, { -0.414441f, 0.633577f, 0.653314f }, { 0.332816f, 0.700982f, 0.63076f } } },
  { { 13, 12, 19 }, { { 0.4411f, 0.9929f }, { 0.4283f, 0.8585f }, { 0.5589f, 0.9929f } },
    { { -0.362179f, 0.682137f, 0.635228f }, { -0.268997f, 0.739227f, 0.617402f }, { 0.365102f, 0.681743f, 0.633977f } } },
  { { 19, 12, 18 }, { { 0.5589f, 0.9929f }, { 0.4283f, 0.8585f }, { 0.5717f, 0.8585f } },
    { { 0.365102f, 0.681743f, 0.633977f }, { -0.268997f, 0.739227f, 0.617402f }, { 0.267447f, 0.664798f, 0.697507f } } },
  { { 7, 13, 19 }, { { 0.499f, 0.9997f }, { 0.4411f, 0.9929f }, { 0.5589f, 0.9929f } },
    { { 0.031914f, -0.105838f, -0.993871f }, { -0.362179f, 0.682137f, 0.635228f }, { 0.365102f, 0.681743f, 0.633977f } } },
  { { 14, 22, 15 }, { { 0.6346f, 0.1834f }, { 0.9064f, 0.3273f }, { 0.7032f, 0.3303f } },
    { { 0.37072f, 0.822213f, -0.431895f }, { 0.91587f, 0.014521f, -0.401213f }, { 0.418498f, 0.848951f, -0.32271f } } },
  { { 21, 22, 14 }, { { 0.7692f, 0.1814f }, { 0.9064f, 0.3273f }, { 0.6346f, 0.1834f } },
    { { 0.851324f, 0.012826f, -0.524484f }, { 0.91587f, 0.014521f, -0.401213f }, { 0.37072f, 0.822213f, -0.431895f } } },
  { { 16, 15, 23 }, { { 0.7477f, 0.6241f }, { 0.7032f, 0.3303f }, { 1.0f, 0.5172f } },
    { { 0.424981f, 0.905175f, 0.007011f }, { 0.418498f, 0.848951f, -0.32271f }, { 0.990502f, -0.009657f, -0.137156f } } },
  { { 23, 15, 22 }, { { 1.0f, 0.5172f }, { 0.7032f, 0.3303f }, { 0.9064f, 0.3273f } },
    { { 0.990502f, -0.009657f, -0.137156f }, { 0.418498f, 0.848951f, -0.32271f }, { 0.91587f, 0.014521f, -0.401213f } } },
  { { 17, 16, 24 }, { { 0.7498f, 0.8054f }, { 0.7477f, 0.6241f }, { 0.9995f, 0.802f } },
    { { 0.332816f, 0.700982f, 0.63076f }, { 0.424981f, 0.905175f, 0.007011f }, { 0.848344f, -0.05871f, 0.52618f } } },
  { { 24, 16, 23 }, { { 0.9995f, 0.802f }, { 0.7477f, 0.6241f }, { 1.0f, 0.5172f } },
    { { 0.848344f, -0.05871f, 0.52618f }, { 0.424981f, 0.905175f, 0.007011f }, { 0.990502f, -0.009657f, -0.137156f } } },
  { { 18, 17, 25 }, { { 0.5717f, 0.8585f }, { 0.7498f, 0.8054f }, { 0.6433f, 0.8575f } },
    { { 0.267447f, 0.664798f, 0.697507f }, { 0.332816f, 0.700982f, 0.63076f }, { 0.601432f, -0.000761f, 0.798923f } } },
  { { 25, 17, 24 }, { { 0.6433f, 0.8575f }, { 0.7498f, 0.8054f }, { 0.9995f, 0.802f } },
    { { 0.601432f, -0.000761f, 0.798923f }, { 0.332816f, 0.700982f, 0.63076f }, { 0.848344f, -0.05871f, 0.52618f } } },
  { { 19, 18, 26 }, { { 0.5589f, 0.9929f }, { 0.5717f, 0.8585f }, { 0.6177f, 0.9919f } },
    { { 0.365102f, 0.681743f, 0.633977f }, { 0.267447f, 0.664798f, 0.697507f }, { 0.791236f, -0.006474f, 0.611477f } } },
  { { 26, 18, 25 }, { { 0.6177f, 0.9919f }, { 0.5717f, 0.8585f }, { 0.6433f, 0.8575f } },
    { { 0.791236f, -0.006474f, 0.611477f }, { 0.267447f, 0.664798f, 0.697507f }, { 0.601432f, -0.000761f, 0.798923f } } },
  { { 7, 19, 20 }, { { 0.499f, 0.9997f }, { 0.5589f, 0.9929f }, { 0.4974f, 0.9997f } },
    { { 0.031914f, -0.105838f, -0.993871f }, { 0.365102f, 0.681743f, 0.633977f }, { -0.072307f, 0.001864f, -0.997381f } } },
  { { 20, 19, 26 }, { { 0.4974f, 0.9997f }, { 0.5589f, 0.9929f }, { 0.6177f, 0.9919f } },
    { { -0.072307f, 0.001864f, -0.997381f }, { 0.365102f, 0.681743f, 0.633977f }, { 0.791236f, -0.006474f, 0.611477f } } },
  { { 29, 22, 21 }, { { 0.7032f, 0.3243f }, { 0.9064f, 0.3273f }, { 0.7692f, 0.1814f } },
    { { 0.414544f, -0.831977f, -0.368737f }, { 0.91587f, 0.014521f, -0.401213f }, { 0.851324f, 0.012826f, -0.524484f } } },
  { { 29, 21, 28 }, { { 0.7032f, 0.3243f }, { 0.7692f, 0.1814f }, { 0.6346f, 0.1794f } },
    { { 0.414544f, -0.831977f, -0.368737f }, { 0.851324f, 0.012826f, -0.524484f }, { 0.368034f, -0.802205f, -0.470126f } } },
  { { 22, 30, 23 }, { { 0.9064f, 0.3273f }, { 0.7498f, 0.5135f }, { 1.0f, 0.5172f } },
    { { 0.91587f, 0.014521f, -0.401213f }, { 0.444849f, -0.893249f, -0.064927f }, { 0.990502f, -0.009657f, -0.137156f } } },
  { { 29, 30, 22 }, { { 0.7032f, 0.3243f }, { 0.7498f, 0.5135f }, { 0.9064f, 0.3273f } },
    { { 0.414544f, -0.831977f, -0.368737f }, { 0.444849f, -0.893249f, -0.064927f }, { 0.91587f, 0.014521f, -0.401213f } } },
  { { 24, 23, 31 }, { { 0.9995f, 0.802f }, { 1.0f, 0.5172f }, { 0.7498f, 0.799f } },
    { { 0.848344f, -0.05871f, 0.52618f }, { 0.990502f, -0.009657f, -0.137156f }, { 0.369137f, -0.748237f, 0.551252f } } },
  { { 31, 23, 30 }, { { 0.7498f, 0.799f }, { 1.0f, 0.5172f }, { 0.7498f, 0.5135f } },
    { { 0.369137f, -0.748237f, 0.551252f }, { 0.990502f, -0.009657f, -0.137156f }, { 0.444849f, -0.893249f, -0.064927f } } },
  { { 25, 24, 32 }, { { 0.6433f, 0.8575f }, { 0.9995f, 0.802f }, { 0.5717f, 0.8561f } },
    { { 0.601432f, -0.000761f, 0.798923f }, { 0.848344f, -0.05871f, 0.52618f }, { 0.280854f, -0.690655f, 0.666421f } } },
  { { 32, 24, 31 }, { { 0.5717f, 0.8561f }, { 0.9995f, 0.802f }, { 0.7498f, 0.799f } },
    { { 0.280854f, -0.690655f, 0.666421f }, { 0.848344f, -0.05871f, 0.52618f }, { 0.369137f, -0.748237f, 0.551252f } } },
  { { 26, 25, 33 }, { { 0.6177f, 0.9919f }, { 0.6433f, 0.8575f }, { 0.5589f, 0.9909f } },
    { { 0.791236f, -0.006474f, 0.611477f }, { 0.601432f, -0.000761f, 0.798923f }, { 0.360354f, -0.704594f, 0.611303f } } },
  { { 33, 25, 32 }, { { 0.5589f, 0.9909f }, { 0.6433f, 0.8575f }, { 0.5717f, 0.8561f } },
    { { 0.360354f, -0.704594f, 0.611303f }, { 0.601432f, -0.000761f, 0.798923f }, { 0.280854f, -0.690655f, 0.666421f } } },
  { { 20, 26, 27 }, { { 0.4974f, 0.9997f }, { 0.6177f, 0.9919f }, { 0.499f, 1.0f } },
    { { -0.072307f, 0.001864f, -0.997381f }, { 0.791236f, -0.006474f, 0.611477f }, { -0.015996f, 0.079133f, -0.996736f } } },
  { { 27, 26, 33 }, { { 0.499f, 1.0f }, { 0.6177f, 0.9919f }, { 0.5589f, 0.9909f } },
    { { -0.015996f, 0.079133f, -0.996736f }, { 0.791236f, -0.006474f, 0.611477f }, { 0.360354f, -0.704594f, 0.611303f } } },
  { { 29, 28, 35 }, { { 0.7032f, 0.3243f }, { 0.6346f, 0.1794f }, { 0.2968f, 0.3243f } },
    { { 0.414544f, -0.831977f, -0.368737f }, { 0.368034f, -0.802205f, -0.470126f }, { -0.417293f, -0.830452f, -0.369075f } } },
  { { 35, 28, 34 }, { { 0.2968f, 0.3243f }, { 0.6346f, 0.1794f }, { 0.3654f, 0.1794f } },
    { { -0.417293f, -0.830452f, -0.369075f }, { 0.368034f, -0.802205f, -0.470126f }, { -0.373456f, -0.801679f, -0.466735f } } },
  { { 36, 30, 29 }, { { 0.2502f, 0.5135f }, { 0.7498f, 0.5135f }, { 0.7032f, 0.3243f } },
    { { -0.432872f, -0.897566f, -0.083648f }, { 0.444849f, -0.893249f, -0.064927f }, { 0.414544f, -0.831977f, -0.368737f } } },
  { { 29, 35, 36 }, { { 0.7032f, 0.3243f }, { 0.2968f, 0.3243f }, { 0.2502f, 0.5135f } },
    { { 0.414544f, -0.831977f, -0.368737f }, { -0.417293f, -0.830452f, -0.369075f }, { -0.432872f, -0.897566f, -0.083648f } } },
  { { 30, 37, 31 }, { { 0.7498f, 0.5135f }, { 0.2502f, 0.799f }, { 0.7498f, 0.799f } },
    { { 0.444849f, -0.893249f, -0.064927f }, { -0.341974f, -0.747752f, 0.56914f }, { 0.369137f, -0.748237f, 0.551252f } } },
  { { 36, 37, 30 }, { { 0.2502f, 0.5135f }, { 0.2502f, 0.799f }, { 0.7498f, 0.5135f } },
    { { -0.432872f, -0.897566f, -0.083648f }, { -0.341974f, -0.747752f, 0.56914f }, { 0.444849f, -0.893249f, -0.064927f } } },
  { { 32, 31, 38 }, { { 0.5717f, 0.8561f }, { 0.7498f, 0.799f }, { 0.4283f, 0.8561f } },
    { { 0.280854f, -0.690655f, 0.666421f }, { 0.369137f, -0.748237f, 0.551252f }, { -0.293374f, -0.68262f, 0.669299f } } },
  { { 38, 31, 37 }, { { 0.4283f, 0.8561f }, { 0.7498f, 0.799f }, { 0.2502f, 0.799f } },
    { { -0.293374f, -0.68262f, 0.669299f }, { 0.369137f, -0.748237f, 0.551252f }, { -0.341974f, -0.747752f, 0.56914f } } },
  { { 33, 32, 39 }, { { 0.5589f, 0.9909f }, { 0.5717f, 0.8561f }, { 0.4411f, 0.9909f } },
    { { 0.360354f, -0.704594f, 0.611303f }, { 0.280854f, -0.690655f, 0.666421f }, { -0.364981f, -0.704232f, 0.608971f } } },
  { { 39, 32, 38 }, { { 0.4411f, 0.9909f }, { 0.5717f, 0.8561f }, { 0.4283f, 0.8561f } },
    { { -0.364981f, -0.704232f, 0.608971f }, { 0.280854f, -0.690655f, 0.666421f }, { -0.293374f, -0.68262f, 0.669299f } } },
  { { 27, 33, 39 }, { { 0.501f, 1.0f }, { 0.5589f, 0.9909f }, { 0.4411f, 0.9909f } },
    { { -0.015996f, 0.079133f, -0.996736f }, { 0.360354f, -0.704594f, 0.611303f }, { -0.364981f, -0.704232f, 0.608971f } } },
  { { 35, 34, 2 }, { { 0.2968f, 0.3243f }, { 0.3654f, 0.1794f }, { 0.0936f, 0.3273f } },
    { { -0.417293f, -0.830452f, -0.369075f }, { -0.373456f, -0.801679f, -0.466735f }, { -0.918997f, 0.018274f, -0.39384f } } },
  { { 1, 2, 34 }, { { 0.2308f, 0.1814f }, { 0.0936f, 0.3273f }, { 0.3654f, 0.1794f } },
    { { -0.852774f, 0.004233f, -0.522263f }, { -0.918997f, 0.018274f, -0.39384f }, { -0.373456f, -0.801679f, -0.466735f } } },
  { { 36, 35, 3 }, { { 0.2502f, 0.5135f }, { 0.2968f, 0.3243f }, { 0.0f, 0.5172f } },
    { { -0.432872f, -0.897566f, -0.083648f }, { -0.417293f, -0.830452f, -0.369075f }, { -0.991057f, 0.031682f, -0.129622f } } },
  { { 3, 35, 2 }, { { 0.0f, 0.5172f }, { 0.2968f, 0.3243f }, { 0.0936f, 0.3273f } },
    { { -0.991057f, 0.031682f, -0.129622f }, { -0.417293f, -0.830452f, -0.369075f }, { -0.918997f, 0.018274f, -0.39384f } } },
  { { 37, 36, 4 }, { { 0.2502f, 0.799f }, { 0.2502f, 0.5135f }, { 0.0005f, 0.802f } },
    { { -0.341974f, -0.747752f, 0.56914f }, { -0.432872f, -0.897566f, -0.083648f }, { -0.850374f, 0.067535f, 0.521826f } } },
  { { 4, 36, 3 }, { { 0.0005f, 0.802f }, { 0.2502f, 0.5135f }, { 0.0f, 0.5172f } },
    { { -0.850374f, 0.067535f, 0.521826f }, { -0.432872f, -0.897566f, -0.083648f }, { -0.991057f, 0.031682f, -0.129622f } } },
  { { 38, 37, 5 }, { { 0.4283f, 0.8561f }, { 0.2502f, 0.799f }, { 0.3567f, 0.8575f } },
    { { -0.293374f, -0.68262f, 0.669299f }, { -0.341974f, -0.747752f, 0.56914f }, { -0.603434f, -0.037645f, 0.796524f } } },
  { { 5, 37, 4 }, { { 0.3567f, 0.8575f }, { 0.2502f, 0.799f }, { 0.0005f, 0.802f } },
    { { -0.603434f, -0.037645f, 0.796524f }, { -0.341974f, -0.747752f, 0.56914f }, { -0.850374f, 0.067535f, 0.521826f } } },
  { { 39, 38, 6 }, { { 0.4411f, 0.9909f }, { 0.4283f, 0.8561f }, { 0.3823f, 0.9919f } },
    { { -0.364981f, -0.704232f, 0.608971f }, { -0.293374f, -0.68262f, 0.669299f }, { -0.792093f, -0.013962f, 0.610241f } } },
  { { 6, 38, 5 }, { { 0.3823f, 0.9919f }, { 0.4283f, 0.8561f }, { 0.3567f, 0.8575f } },
    { { -0.792093f, -0.013962f, 0.610241f }, { -0.293374f, -0.68262f, 0.669299f }, { -0.603434f, -0.037645f, 0.796524f } } },
  { { 27, 39, 0 }, { { 0.501f, 1.0f }, { 0.4411f, 0.9909f }, { 0.5026f, 0.9997f } },
    { { -0.015996f, 0.079133f, -0.996736f }, { -0.364981f, -0.704232f, 0.608971f }, { 0.092474f, -0.000913f, -0.995715f } } },
  { { 0, 39, 6 }, { { 0.5026f, 0.9997f }, { 0.4411f, 0.9909f }, { 0.3823f, 0.9919f } },
    { { 0.092474f, -0.000913f, -0.995715f }, { -0.364981f, -0.704232f, 0.608971f }, { -0.792093f, -0.013962f, 0.610241f } } }
};

TEST_3D_DATA1 Redknight_3d_data1[24] = {
  { "Head",
    8, 6,
    Redknight_xyz_Head,
    Redknight_triangle1_Head, 
    1, 1, 16, 
    { 0.0f, 0.0f, 0.0f }, { 0.294118f, 0.0f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedHelm.bmp" },
  { "Head_1",
    24, 26,
    Redknight_xyz_Head_1,
    Redknight_triangle1_Head_1, 
    0, 1, 1, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.0f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Head_2",
    11, 12,
    Redknight_xyz_Head_2,
    Redknight_triangle1_Head_2, 
    0, 1, 16, 
    { 0.0f, 0.0f, 0.0f }, { 0.294118f, 0.0f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Ll_arm",
    17, 30,
    Redknight_xyz_Ll_arm,
    Redknight_triangle1_Ll_arm, 
    1, 1, 31, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.74902f, 0.494118f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChain.bmp" },
  { "Ll_leg",
    12, 12,
    Redknight_xyz_Ll_leg,
    Redknight_triangle1_Ll_leg, 
    0, 1, 231, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.501961f, 0.752941f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Ll_leg_1",
    18, 24,
    Redknight_xyz_Ll_leg_1,
    Redknight_triangle1_Ll_leg_1, 
    0, 1, 34, 
    { 0.0f, 0.0f, 0.0f }, { 0.545098f, 0.270588f, 0.07451f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Lu_arm",
    27, 50,
    Redknight_xyz_Lu_arm,
    Redknight_triangle1_Lu_arm, 
    1, 1, 31, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.74902f, 0.494118f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChain.bmp" },
  { "Lu_leg",
    18, 24,
    Redknight_xyz_Lu_leg,
    Redknight_triangle1_Lu_leg, 
    0, 1, 231, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.501961f, 0.752941f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "L_fingers",
    14, 24,
    Redknight_xyz_L_fingers,
    Redknight_triangle1_L_fingers, 
    1, 1, 6, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.0f, 1.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedHelm.bmp" },
  { "L_foot",
    14, 24,
    Redknight_xyz_L_foot,
    Redknight_triangle1_L_foot, 
    0, 1, 34, 
    { 0.0f, 0.0f, 0.0f }, { 0.545098f, 0.270588f, 0.07451f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "L_hand",
    18, 32,
    Redknight_xyz_L_hand,
    Redknight_triangle1_L_hand, 
    1, 1, 44, 
    { 0.0f, 0.0f, 0.0f }, { 0.494118f, 0.368627f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChrome.bmp" },
  { "Obj",
    8, 8,
    Redknight_xyz_Obj,
    Redknight_triangle1_Obj, 
    0, 1, 24, 
    { 0.0f, 0.0f, 0.0f }, { 0.494118f, 0.121569f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Obj_1",
    10, 14,
    Redknight_xyz_Obj_1,
    Redknight_triangle1_Obj_1, 
    0, 1, 7, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 1.0f, 1.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Obj_2",
    36, 58,
    Redknight_xyz_Obj_2,
    Redknight_triangle1_Obj_2, 
    0, 1, 2, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 1.0f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Pelvis",
    12, 12,
    Redknight_xyz_Pelvis,
    Redknight_triangle1_Pelvis, 
    1, 1, 62, 
    { 0.0f, 0.0f, 0.0f }, { 0.486275f, 0.647059f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChain.bmp" },
  { "Pelvis_1",
    18, 24,
    Redknight_xyz_Pelvis_1,
    Redknight_triangle1_Pelvis_1, 
    1, 1, 62, 
    { 0.0f, 0.0f, 0.0f }, { 0.486275f, 0.647059f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChain.bmp" },
  { "Rl_arm",
    17, 30,
    Redknight_xyz_Rl_arm,
    Redknight_triangle1_Rl_arm, 
    1, 1, 31, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.74902f, 0.494118f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChain.bmp" },
  { "Rl_leg",
    12, 12,
    Redknight_xyz_Rl_leg,
    Redknight_triangle1_Rl_leg, 
    0, 1, 231, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.501961f, 0.752941f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Rl_leg_1",
    18, 24,
    Redknight_xyz_Rl_leg_1,
    Redknight_triangle1_Rl_leg_1, 
    0, 1, 34, 
    { 0.0f, 0.0f, 0.0f }, { 0.545098f, 0.270588f, 0.07451f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Ru_arm",
    27, 50,
    Redknight_xyz_Ru_arm,
    Redknight_triangle1_Ru_arm, 
    1, 1, 31, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.74902f, 0.494118f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChain.bmp" },
  { "Ru_leg",
    18, 24,
    Redknight_xyz_Ru_leg,
    Redknight_triangle1_Ru_leg, 
    0, 1, 231, 
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.501961f, 0.752941f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "R_foot",
    14, 24,
    Redknight_xyz_R_foot,
    Redknight_triangle1_R_foot, 
    0, 1, 34, 
    { 0.0f, 0.0f, 0.0f }, { 0.545098f, 0.270588f, 0.07451f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "R_hand",
    18, 32,
    Redknight_xyz_R_hand,
    Redknight_triangle1_R_hand, 
    1, 1, 44, 
    { 0.0f, 0.0f, 0.0f }, { 0.494118f, 0.368627f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChrome.bmp" },
  { "Torso",
    40, 70,
    Redknight_xyz_Torso,
    Redknight_triangle1_Torso, 
    1, 1, 12, 
    { 0.0f, 0.0f, 0.0f }, { 0.647059f, 0.0f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\RedChain.bmp" },
};
