// ReadPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "ReadPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReadPage property page

IMPLEMENT_DYNCREATE(CReadPage, CPropertyPage)

CReadPage::CReadPage() : CPropertyPage(CReadPage::IDD)
, m_CheckFixTransparencies(FALSE)
, m_KmzInputModelFactors(FALSE)
, m_VrmlMiterJointExtrusion(FALSE)
{
	//{{AFX_DATA_INIT(CReadPage)
	m_RemoveFaces = FALSE;
	m_ShowReadMessages = FALSE;
	m_TextureMatch = FALSE;
	m_Red = _T("");
	m_Green = _T("");
	m_Blue = _T("");
	m_DxfRed = _T("");
	m_DxfPen = _T("");
	m_DxfGreen = _T("");
	m_DxfBlue = _T("");
	m_RemoveVertices = FALSE;
	m_DxfOn = FALSE;
	m_VrmlByChiefArchitect = FALSE;
	m_VrmlText_Group = -1;
	m_DxfText_Group = -1;
	m_DisplayBackgroundImage = FALSE;
	m_TextureSearch = FALSE;
	m_DisplayOglDebugMsgs = FALSE;
	m_RevolveCameraX = _T("");
	m_RevolveCameraY = _T("");
	m_RevolveCameraZ = _T("");
	m_RevolveCameraSeconds = _T("");
	m_TextureMatch = FALSE;
	m_AlwaysShowCameraCursor = FALSE;
	m_GrabKeyboardFocus = FALSE;
	m_RotateCameraSimulateX = _T("");
	m_RotateCameraSimulateY = _T("");
	m_RotateCameraSimulateSeconds = _T("");
  m_ShowDebugStopMessages = FALSE;
  m_PauseAtOglSnapshotMsg = FALSE;
	//}}AFX_DATA_INIT

	if (!ColorPickerButton.LoadBitmaps("COLORPICKERU", "COLORPICKERD", 0, 0))  
	{
		TRACE0("Failed to load bitmaps for buttons\n");
	}
}

CReadPage::~CReadPage()
{
}

void CReadPage::DoDataExchange(CDataExchange* pDX)
{
  CPropertyPage::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CReadPage)
  DDX_Control(pDX, IDC_INCOMBO, m_InCombo);
  DDX_Check(pDX, IDC_REMOVEFACES, m_RemoveFaces);
  DDX_Check(pDX, IDC_SHOWREADMESSAGES, m_ShowReadMessages);
  DDX_Check(pDX, IDC_TEXTUREMATCH, m_TextureMatch);
  DDX_Text(pDX, IDC_RED, m_Red);
  DDX_Text(pDX, IDC_GREEN, m_Green);
  DDX_Text(pDX, IDC_BLUE, m_Blue);
  DDX_Text(pDX, IDC_DXFRED, m_DxfRed);
  DDX_Text(pDX, IDC_DXFPEN, m_DxfPen);
  DDX_Text(pDX, IDC_DXFGREEN, m_DxfGreen);
  DDX_Text(pDX, IDC_DXFBLUE, m_DxfBlue);
  DDX_Check(pDX, IDC_REMOVEVERTICES, m_RemoveVertices);	
  DDX_Check(pDX, IDC_VRMLBYCHIEFARCHITECT, m_VrmlByChiefArchitect);
  DDX_Radio(pDX, IDC_VRMLTEXTNO, m_VrmlText_Group);
  DDX_Radio(pDX, IDC_DXFTEXTNO, m_DxfText_Group);
  DDX_Check(pDX, IDC_DISPLAYBACKGROUNDIMAGE, m_DisplayBackgroundImage);
  DDX_Check(pDX, IDC_TEXTURESEARCH, m_TextureSearch);
  DDX_Check(pDX, IDC_DISPLAYOGLDEBUGMSGS, m_DisplayOglDebugMsgs);
  DDX_Text(pDX, IDC_REVOLVECAMERAX, m_RevolveCameraX);
  DDX_Text(pDX, IDC_REVOLVECAMERAY, m_RevolveCameraY);
  DDX_Text(pDX, IDC_REVOLVECAMERAZ, m_RevolveCameraZ);
  DDX_Text(pDX, IDC_REVOLVECAMERASECONDS, m_RevolveCameraSeconds);
  DDX_Check(pDX, IDC_ALWAYSSHOWCAMERACURSOR, m_AlwaysShowCameraCursor);
  DDX_Check(pDX, IDC_GRABKEYBOARDFOCUS, m_GrabKeyboardFocus);
  DDX_Text(pDX, IDC_ROTATECAMERASIMULATEX, m_RotateCameraSimulateX);
  DDX_Text(pDX, IDC_ROTATECAMERASIMULATEY, m_RotateCameraSimulateY);
  DDX_Text(pDX, IDC_ROTATECAMERASIMULATESECONDS, m_RotateCameraSimulateSeconds);
  DDX_Check(pDX, IDC_SHOWDEBUGSTOPMESSAGES, m_ShowDebugStopMessages);
  DDX_Check(pDX, IDC_PAUSEATOGLSNAPSHOTMSG, m_PauseAtOglSnapshotMsg);
  //}}AFX_DATA_MAP
  DDX_Check(pDX, IDC_CHECKFIXTRANSPARECIES, m_CheckFixTransparencies);
  DDX_Check(pDX, IDC_KMZINPUTMODELFACTORS, m_KmzInputModelFactors);
  DDX_Check(pDX, IDC_VRML_MITER_JOINT_EXTRUSION, m_VrmlMiterJointExtrusion);
}


BEGIN_MESSAGE_MAP(CReadPage, CPropertyPage)
	//{{AFX_MSG_MAP(CReadPage)	
	ON_BN_CLICKED(IDC_REMOVEFACES, OnRemovefaces)
	ON_BN_CLICKED(IDC_READ, OnRead)
	ON_BN_CLICKED(IDC_BUFFERREAD, OnBufferread)
	ON_BN_CLICKED(IDC_SHOWSECURITY, OnShowsecurity)
	ON_CBN_SELCHANGE(IDC_INCOMBO, OnSelchangeIncombo)	
	ON_BN_CLICKED(IDC_SHOWREADMESSAGES, OnShowreadmessages)
	ON_BN_CLICKED(IDC_TEXTUREMATCH, OnTexturematch)
	ON_BN_CLICKED(IDC_COLORPICKER, OnColorpicker)
	ON_BN_CLICKED(IDC_GETDXFPEN, OnGetdxfpen)
	ON_BN_CLICKED(IDC_REMOVEVERTICES, OnRemovevertices)		
	ON_BN_CLICKED(IDC_VRMLBYCHIEFARCHITECT, OnVrmlbychiefarchitect)
	ON_BN_CLICKED(IDC_VRMLTEXTNO, OnVrmltextno)
	ON_BN_CLICKED(IDC_VRMLTEXTFLAT, OnVrmltextflat)
	ON_BN_CLICKED(IDC_VRMLTEXTEXTRUDED, OnVrmltextextruded)
	ON_BN_CLICKED(IDC_DXFTEXTNO, OnDxftextno)
	ON_BN_CLICKED(IDC_DXFTEXTFLAT, OnDxftextflat)
	ON_BN_CLICKED(IDC_DXFTEXTEXTRUDED, OnDxftextextruded)
	ON_BN_CLICKED(IDC_DISPLAYBACKGROUNDIMAGE, OnDisplaybackgroundimage)
	ON_BN_CLICKED(IDC_SELECTBACKGROUNDIMAGE, OnSelectbackgroundimage)
	ON_BN_CLICKED(IDC_READANDROTATE, OnReadandrotate)
	ON_BN_CLICKED(IDC_TEXTURESEARCH, OnTexturesearch)
	ON_BN_CLICKED(IDC_DISPLAYOGLDEBUGMSGS, OnDisplayogldebugmsgs)
	ON_BN_CLICKED(IDC_SHOWSTATUSBAR, OnShowstatusbar)
	ON_BN_CLICKED(IDC_HIDESTATUSBAR, OnHidestatusbar)
	ON_BN_CLICKED(IDC_REVOLVECAMERASTART, OnRevolvecamerastart)
	ON_BN_CLICKED(IDC_REVOLVECAMERASTOP, OnRevolvecamerastop)
	ON_BN_CLICKED(IDC_GRABKEYBOARDFOCUS, OnGrabkeyboardfocus)
	ON_BN_CLICKED(IDC_ALWAYSSHOWCAMERACURSOR, OnAlwaysshowcameracursor)
	ON_BN_CLICKED(IDC_ROTATECAMERASIMULATESTART, OnRotatecamerasimulatestart)
	ON_BN_CLICKED(IDC_ROTATECAMERASIMULATESTOP, OnRotatecamerasimulatestop)
	//}}AFX_MSG_MAP
  ON_BN_CLICKED(IDC_SHOWDEBUGSTOPMESSAGES, &CReadPage::OnBnClickedShowdebugstopmessages)
  ON_BN_CLICKED(IDC_PAUSEATOGLSNAPSHOTMSG, &CReadPage::OnBnClicked_PauseAtOglSnapshotMsg)
  ON_BN_CLICKED(IDC_CHECKFIXTRANSPARECIES, &CReadPage::OnBnClickedCheckfixtransparecies)
  ON_BN_CLICKED(IDC_KMZINPUTMODELFACTORS, &CReadPage::OnBnClickedKmzinputmodelfactors)
  ON_BN_CLICKED(IDC_VRML_MITER_JOINT_EXTRUSION, &CReadPage::OnBnClicked_VrmlMiterJointExtrusion)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CReadPage message handlers

BOOL CReadPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	//
	ColorPickerButton.AutoLoad(IDC_COLORPICKER, this);

	for (int i=0; i<at3dData->inCount; i++)
	{
		m_InCombo.AddString(at3dData->inLabel[i]);
	}
	m_InCombo.SetCurSel(at3dData->inIndex);

	m_RemoveVertices = (at3dData->removeVerticesFlag) ? TRUE : FALSE;
	At3d_WriteFlag(LIBFLAG_REMOVE_DUPLICATE_VERTICES, at3dData->removeVerticesFlag);

	m_RemoveFaces = (at3dData->removeFacesFlag) ? TRUE : FALSE;
	At3d_WriteFlag(LIBFLAG_REMOVE_DUPLICATE_FACES, at3dData->removeFacesFlag);

	m_TextureSearch = (at3dData->textureSearchFlag) ? TRUE : FALSE;
  
	m_TextureMatch = (at3dData->textureNameMatchFlag) ? TRUE : FALSE;
	At3d_WriteFlag(LIBFLAG_TEXTURENAME_MATCH, at3dData->textureNameMatchFlag);
	
	m_VrmlByChiefArchitect = (at3dData->vrmlByChiefArchitectFlag) ? TRUE : FALSE;
	At3d_WriteFlag(LIBFLAG_VRML_BY_CHIEF_ARCHITECT, at3dData->vrmlByChiefArchitectFlag);

  m_VrmlMiterJointExtrusion = (at3dData->vrmlMiterJointExtrusionFlag) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_VRML_MITER_JOINT_EXTRUSION, at3dData->vrmlMiterJointExtrusionFlag);

	m_DxfText_Group = at3dData->useDxfTextFlag;
	m_VrmlText_Group = at3dData->vrmlTextFlag;

	red = green = blue = 1.0f;
	SetEditRGB();
	
	m_DisplayBackgroundImage = (at3dData->backgroundImageUseFlag) ? TRUE : FALSE;

	m_RevolveCameraX.Format("%.2f", 0.0);
  m_RevolveCameraY.Format("%.2f", 0.0);
  m_RevolveCameraZ.Format("%.2f", 5.0);
  m_RevolveCameraSeconds.Format("%.3f", 0.05);

  m_DisplayOglDebugMsgs = (at3dData->oglDebugMsgFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_DISPLAY_OGL_DEBUG_MSGS, at3dData->oglDebugMsgFlag);

  m_PauseAtOglSnapshotMsg = (at3dData->pauseAtOglSnapshotMsgFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_DISPLAY_OGL_SNAPSHOT_DEBUG_MSGS, at3dData->pauseAtOglSnapshotMsgFlag);

	m_GrabKeyboardFocus = (at3dData->grabKeyboardFocusFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_GRAB_KEYBOARD_FOCUS, at3dData->grabKeyboardFocusFlag);

	m_AlwaysShowCameraCursor = (at3dData->alwaysShowCameraCursorFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_ALWAYS_SHOW_CAMERA_CURSOR, at3dData->alwaysShowCameraCursorFlag);

	m_RotateCameraSimulateX.Format("%d", 2);
  m_RotateCameraSimulateY.Format("%d", 0);
  m_RotateCameraSimulateSeconds.Format("%.3f", 0.025);

  m_ShowDebugStopMessages = (at3dData->debugStopMessagesFlag) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_DEBUG_STOP_MESSAGES, at3dData->debugStopMessagesFlag);

  m_CheckFixTransparencies = (at3dData->checkFixTransparenciesFlag) ? TRUE : FALSE;

  m_KmzInputModelFactors = (at3dData->kmzInputModelFactorsFlag) ? TRUE : FALSE;

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CReadPage::OnRemovefaces() 
{
	UpdateData(TRUE);
	at3dData->removeFacesFlag = (m_RemoveFaces) ? 1 : 0;
}

void CReadPage::OnRead() 
{	
	at3dData->ReadFile();
}

void CReadPage::OnBufferread() 
{
	at3dData->bufferReadFlag = 1;
  at3dData->ReadFile();
}

void CReadPage::OnShowsecurity() 
{
	At3d_ShowSecurity();
}


void CReadPage::OnSelchangeIncombo() 
{
	if (m_InCombo.GetCurSel() != CB_ERR)
	{
		at3dData->inIndex = m_InCombo.GetCurSel();
	}
}

void CReadPage::OnShowreadmessages() 
{
	UpdateData(TRUE);
	at3dData->showReadMessagesFlag = (m_ShowReadMessages) ? 1 : 0;
}

void CReadPage::OnTexturematch() 
{
	UpdateData(TRUE);
	at3dData->textureNameMatchFlag = (m_TextureMatch) ? 1 : 0;
	At3d_WriteFlag(LIBFLAG_TEXTURENAME_MATCH, at3dData->textureNameMatchFlag);
}

void CReadPage::GetEditRGB()
{
	UpdateData(TRUE);

	red   = (float)atof(m_Red);
	green = (float)atof(m_Green);
	blue  = (float)atof(m_Blue);

	// clamp RGB in range 0.0 to 1.0
	//
	if (red < 0.0) red = 0.0;
	if (red > 1.0) red = 1.0;
	
	if (green < 0.0) green = 0.0;
	if (green > 1.0) green = 1.0;
	
	if (blue < 0.0) blue = 0.0;
	if (blue > 1.0) blue = 1.0;
	
	SetEditRGB();
}

void CReadPage::SetEditRGB()
{ 
	m_Red.Format("%.4f", red);
  m_Green.Format("%.4f", green);
  m_Blue.Format("%.4f", blue);

	UpdateData(FALSE);
}

void CReadPage::OnColorpicker() 
{
	GetEditRGB();

	unsigned __int8 r = (unsigned __int8)(red * 255.0);
  unsigned __int8 g = (unsigned __int8)(green * 255.0);
  unsigned __int8 b = (unsigned __int8)(blue * 255.0);

	COLORREF inColor = ((r + (g << 8) + (b << 16)));
	//COLORREF outColor = 0;

  CColorDialog dlg(inColor, CC_FULLOPEN, NULL	);

	//dlg.m_cc.rgbResult = outColor;

	if (dlg.DoModal() == IDOK)
  {
		COLORREF outColor = dlg.GetColor();

    red   = ((float)(outColor & 0xFF)) / 255.0f;
    green = ((float)((outColor & 0xFF00) >> 8)) / 255.0f;
    blue  = ((float)((outColor & 0xFF0000) >> 16)) / 255.0f;

    SetEditRGB();
		OnGetdxfpen();
  }
	
}

void CReadPage::OnGetdxfpen() 
{
	GetEditRGB();
	
	// get DXF Pen that matches color
	//
	int dxfPen = At3d_FindDxfPen(red, green, blue);
	m_DxfPen.Format("%d", dxfPen);
	
	// get RGB color for DXF Pen
	//
	float dxfRGB[3];
	At3d_GetColorMap(dxfPen, dxfRGB);

	m_DxfRed.Format("%.4f", dxfRGB[0]);
  m_DxfGreen.Format("%.4f", dxfRGB[1]);
  m_DxfBlue.Format("%.4f", dxfRGB[2]);

	UpdateData(FALSE);
}

void CReadPage::OnRemovevertices() 
{
	UpdateData(TRUE);
	at3dData->removeVerticesFlag = (m_RemoveVertices) ? 1 : 0;	
}


void CReadPage::OnVrmlbychiefarchitect() 
{
	UpdateData(TRUE);
	at3dData->vrmlByChiefArchitectFlag = (m_VrmlByChiefArchitect) ? 1 : 0;
}

void CReadPage::OnVrmltextno() 
{
	at3dData->vrmlTextFlag = 0;
}

void CReadPage::OnVrmltextflat() 
{
	at3dData->vrmlTextFlag = 1;
}

void CReadPage::OnVrmltextextruded() 
{
	at3dData->vrmlTextFlag = 2;
}

void CReadPage::OnDxftextno() 
{
	at3dData->useDxfTextFlag = 0;
}

void CReadPage::OnDxftextflat() 
{
	at3dData->useDxfTextFlag = 1;
}

void CReadPage::OnDxftextextruded() 
{
	at3dData->useDxfTextFlag = 2;
}

void CReadPage::OnDisplaybackgroundimage() 
{
	UpdateData(TRUE);
	at3dData->backgroundImageUseFlag = (m_DisplayBackgroundImage) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_BACKGROUND_IMAGE_USE, at3dData->backgroundImageUseFlag);
}

void CReadPage::OnSelectbackgroundimage() 
{
	at3dData->GetBackgroundImage();
}

void CReadPage::OnReadandrotate() 
{
	at3dData->ReadAndRotateFile(); 
}

void CReadPage::OnTexturesearch() 
{
	// turn off this flag so texture search prompt message
  // is not displayed when textures are not found
  //
	UpdateData(TRUE);
  at3dData->textureSearchFlag = (m_TextureSearch) ? 1 : 0;  	
}

void CReadPage::OnDisplayogldebugmsgs() 
{
	UpdateData(TRUE);
	at3dData->oglDebugMsgFlag = (m_DisplayOglDebugMsgs) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_DISPLAY_OGL_DEBUG_MSGS, at3dData->oglDebugMsgFlag);
}

void CReadPage::OnShowstatusbar() 
{
	At3d_Show_Statusbar();	
}

void CReadPage::OnHidestatusbar() 
{
	At3d_Hide_Statusbar();	
}

void CReadPage::OnRevolvecamerastart() 
{
	UpdateData(TRUE);
	
  double xAngle = atof(m_RevolveCameraX);
  
  double yAngle = atof(m_RevolveCameraY);
  
  double zAngle = atof(m_RevolveCameraZ);
  
  double seconds = atof(m_RevolveCameraSeconds);

  At3d_Revolve_Camera_Start(xAngle, yAngle, zAngle, seconds);
}

void CReadPage::OnRevolvecamerastop() 
{
	At3d_Revolve_Camera_Stop();	
}

void CReadPage::OnGrabkeyboardfocus() 
{
	UpdateData(TRUE);
	at3dData->grabKeyboardFocusFlag = (m_GrabKeyboardFocus) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_GRAB_KEYBOARD_FOCUS, at3dData->grabKeyboardFocusFlag);
}

void CReadPage::OnAlwaysshowcameracursor() 
{
	UpdateData(TRUE);
	at3dData->alwaysShowCameraCursorFlag = (m_AlwaysShowCameraCursor) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_ALWAYS_SHOW_CAMERA_CURSOR, at3dData->alwaysShowCameraCursorFlag);
}

void CReadPage::OnRotatecamerasimulatestart() 
{
	UpdateData(TRUE);
	
	__int32 mouseX = atoi(m_RotateCameraSimulateX);  

  __int32 mouseY = atoi(m_RotateCameraSimulateY);

  double seconds = atof(m_RotateCameraSimulateSeconds);
  
  At3d_Rotate_Camera_Simulation_Start(mouseX, mouseY, seconds);
}

void CReadPage::OnRotatecamerasimulatestop() 
{
	At3d_Rotate_Camera_Simulation_Stop();
}

void CReadPage::OnBnClickedShowdebugstopmessages()
{
  UpdateData(TRUE);
  at3dData->debugStopMessagesFlag = (m_ShowDebugStopMessages) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_DEBUG_STOP_MESSAGES, at3dData->debugStopMessagesFlag);
}

void CReadPage::OnBnClicked_PauseAtOglSnapshotMsg()
{
  UpdateData(TRUE);
  at3dData->pauseAtOglSnapshotMsgFlag = (m_PauseAtOglSnapshotMsg) ? TRUE : FALSE;
  At3d_WriteFlag(LIBFLAG_DISPLAY_OGL_SNAPSHOT_DEBUG_MSGS, at3dData->pauseAtOglSnapshotMsgFlag);
}

void CReadPage::OnBnClickedCheckfixtransparecies()
{
  UpdateData(TRUE);
	at3dData->checkFixTransparenciesFlag = (m_CheckFixTransparencies) ? 1 : 0;
}

void CReadPage::OnBnClickedKmzinputmodelfactors()
{
  UpdateData(TRUE);
  at3dData->kmzInputModelFactorsFlag = (m_KmzInputModelFactors) ? 1 : 0;
}

void CReadPage::OnBnClicked_VrmlMiterJointExtrusion()
{
  UpdateData(TRUE);
  at3dData->vrmlMiterJointExtrusionFlag = (m_VrmlMiterJointExtrusion) ? 1 : 0;
}
