// ObjectPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "ObjectPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CObjectPage property page

IMPLEMENT_DYNCREATE(CObjectPage, CPropertyPage)

CObjectPage::CObjectPage() : CPropertyPage(CObjectPage::IDD)
{
	//{{AFX_DATA_INIT(CObjectPage)
	m_MaxXObject = _T("");
	m_MaxYObject = _T("");
	m_MaxZObject = _T("");
	m_MinXObject = _T("");
	m_MinYObject = _T("");
	m_MinZObject = _T("");
	m_Use2DObject = FALSE;
	m_EditXObject = _T("");
	m_EditYObject = _T("");
	m_EditZObject = _T("");
	m_BackgroundBlue = _T("");
	m_BackgroundGreen = _T("");
	m_BackgroundRed = _T("");
	m_TextureCenter0 = _T("");
	m_TextureCenter1 = _T("");
	m_TextureRotation = _T("");
	m_TextureScale0 = _T("");
	m_TextureScale1 = _T("");
	m_TextureTranslation0 = _T("");
	m_TextureTranslation1 = _T("");
	m_DrawObjectAxes = FALSE;
	m_RotateAboutOrigin = FALSE;
	m_ReducePolygonsName = _T("");
	m_ReducePolygonsStep = _T("");
	m_ReducePolygonsTriangle0 = _T("");
	m_ReducePolygonsTriangle1 = _T("");
	m_ReducePolygonsVertex0 = _T("");
	m_ReducePolygonsVertex1 = _T("");
	//}}AFX_DATA_INIT
}

CObjectPage::~CObjectPage()
{
}

void CObjectPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjectPage)
	DDX_Control(pDX, IDC_TEXTURETYPECOMBO, m_TextureTypeCombo);
	DDX_Control(pDX, IDC_BACKGROUNDCOMBO, m_BackgroundCombo);
	DDX_Text(pDX, IDC_MAXXOBJECT, m_MaxXObject);
	DDX_Text(pDX, IDC_MAXYOBJECT, m_MaxYObject);
	DDX_Text(pDX, IDC_MAXZOBJECT, m_MaxZObject);
	DDX_Text(pDX, IDC_MINXOBJECT, m_MinXObject);
	DDX_Text(pDX, IDC_MINYOBJECT, m_MinYObject);
	DDX_Text(pDX, IDC_MINZOBJECT, m_MinZObject);
	DDX_Check(pDX, IDC_USE2DOBJECT, m_Use2DObject);
	DDX_Text(pDX, IDC_EDITXOBJECT, m_EditXObject);
	DDX_Text(pDX, IDC_EDITYOBJECT, m_EditYObject);
	DDX_Text(pDX, IDC_EDITZOBJECT, m_EditZObject);
	DDX_Text(pDX, IDC_BACKGROUNDBLUE, m_BackgroundBlue);
	DDX_Text(pDX, IDC_BACKGROUNDGREEN, m_BackgroundGreen);
	DDX_Text(pDX, IDC_BACKGROUNDRED, m_BackgroundRed);
	DDX_Text(pDX, IDC_TEXTURECENTER0, m_TextureCenter0);
	DDX_Text(pDX, IDC_TEXTURECENTER1, m_TextureCenter1);
	DDX_Text(pDX, IDC_TEXTUREROTATION, m_TextureRotation);
	DDX_Text(pDX, IDC_TEXTURESCALE0, m_TextureScale0);
	DDX_Text(pDX, IDC_TEXTURESCALE1, m_TextureScale1);
	DDX_Text(pDX, IDC_TEXTURETRANSLATION0, m_TextureTranslation0);
	DDX_Text(pDX, IDC_TEXTURETRANSLATION1, m_TextureTranslation1);
	DDX_Check(pDX, IDC_DRAWOBJECTAXES, m_DrawObjectAxes);
	DDX_Check(pDX, IDC_ROTATEABOUTORIGIN, m_RotateAboutOrigin);
	DDX_Text(pDX, IDC_REDUCEPOLYGONSNAME, m_ReducePolygonsName);
	DDX_Text(pDX, IDC_REDUCEPOLYGONSSTEP, m_ReducePolygonsStep);
	DDX_Text(pDX, IDC_REDUCEPOLYGONSTRIANGLE0, m_ReducePolygonsTriangle0);
	DDX_Text(pDX, IDC_REDUCEPOLYGONSTRIANGLE1, m_ReducePolygonsTriangle1);
	DDX_Text(pDX, IDC_REDUCEPOLYGONSVERTEX0, m_ReducePolygonsVertex0);
	DDX_Text(pDX, IDC_REDUCEPOLYGONSVERTEX1, m_ReducePolygonsVertex1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjectPage, CPropertyPage)
	//{{AFX_MSG_MAP(CObjectPage)
	ON_BN_CLICKED(IDC_GETMINMAXOBJECT, OnGetminmaxobject)
	ON_BN_CLICKED(IDC_USE2DOBJECT, OnUse2dobject)
	ON_BN_CLICKED(IDC_COPYXTOYZOBJECT, OnCopyxtoyzobject)
	ON_BN_CLICKED(IDC_CALCCENTEROBJECT, OnCalccenterobject)
	ON_BN_CLICKED(IDC_SETCENTEROBJECT, OnSetcenterobject)
	ON_BN_CLICKED(IDC_SETMIN1OBJECT, OnSetmin1object)
	ON_BN_CLICKED(IDC_SETMIN2OBJECT, OnSetmin2object)
	ON_BN_CLICKED(IDC_SETMIN3OBJECT, OnSetmin3object)
	ON_BN_CLICKED(IDC_DOSCALEOBJECT, OnDoscaleobject)
	ON_BN_CLICKED(IDC_MIRRORXOBJECT, OnMirrorxobject)
	ON_BN_CLICKED(IDC_MIRRORYOBJECT, OnMirroryobject)
	ON_BN_CLICKED(IDC_MIRRORZOBJECT, OnMirrorzobject)
	ON_BN_CLICKED(IDC_ROTATEX1OBJECT, OnRotatex1object)
	ON_BN_CLICKED(IDC_ROTATEX2OBJECT, OnRotatex2object)
	ON_BN_CLICKED(IDC_ROTATEX3OBJECT, OnRotatex3object)
	ON_BN_CLICKED(IDC_ROTATEY1OBJECT, OnRotatey1object)
	ON_BN_CLICKED(IDC_ROTATEY2OBJECT, OnRotatey2object)
	ON_BN_CLICKED(IDC_ROTATEY3OBJECT, OnRotatey3object)
	ON_BN_CLICKED(IDC_ROTATEZ1OBJECT, OnRotatez1object)
	ON_BN_CLICKED(IDC_ROTATEZ2OBJECT, OnRotatez2object)
	ON_BN_CLICKED(IDC_ROTATEZ3OBJECT, OnRotatez3object)
	ON_BN_CLICKED(IDC_ROTATEXYZOBJECT, OnRotatexyzobject)
	ON_CBN_SELCHANGE(IDC_BACKGROUNDCOMBO, OnSelchangeBackgroundcombo)
	ON_BN_CLICKED(IDC_BACKGROUNDGET, OnBackgroundget)
	ON_BN_CLICKED(IDC_BACKGROUNDSET, OnBackgroundset)
	ON_CBN_SELCHANGE(IDC_TEXTURETYPECOMBO, OnSelchangeTexturetypecombo)
	ON_BN_CLICKED(IDC_CREATEUV, OnCreateuv)
	ON_BN_CLICKED(IDC_REMOVEUV, OnRemoveuv)
	ON_BN_CLICKED(IDC_UVDIALOG, OnUvdialog)
	ON_BN_CLICKED(IDC_ZEROALLZ, OnZeroallz)
	ON_BN_CLICKED(IDC_ERASELINES1, OnEraselines1)
	ON_BN_CLICKED(IDC_ERASELINES2, OnEraselines2)
	ON_BN_CLICKED(IDC_ERASECLOUDS1, OnEraseclouds1)
	ON_BN_CLICKED(IDC_ERASEClouds2, OnERASEClouds2)
	ON_BN_CLICKED(IDC_WaterTightCheck, OnWaterTightCheck)	
	ON_BN_CLICKED(IDC_ROTATEABOUTORIGIN, OnRotateaboutorigin)
	ON_BN_CLICKED(IDC_DRAWOBJECTAXES, OnDrawobjectaxes)
	ON_BN_CLICKED(IDC_REDUCEPOLYGONSSTART, OnReducepolygonsstart)
	ON_BN_CLICKED(IDC_REDUCEPOLYGONSOKAY, OnReducepolygonsokay)
	ON_BN_CLICKED(IDC_REDUCEPOLYGONSCANCEL, OnReducepolygonscancel)
	ON_BN_CLICKED(IDC_REDUCEPOLYGONSSELECTLAYER, OnReducepolygonsselectlayer)
	ON_BN_CLICKED(IDC_REDUCEPOLYGONSSET, OnReducepolygonsset)
	ON_BN_CLICKED(IDC_REDUCEPOLYGONSDECREASE, OnReducepolygonsdecrease)
	ON_BN_CLICKED(IDC_REDUCEPOLYGONSINCREASE, OnReducepolygonsincrease)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectPage message handlers

BOOL CObjectPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	//
	int i;
	for (i=0; i<at3dData->backgroundCount; i++)
	{
		m_BackgroundCombo.AddString(at3dData->backgroundLabel[i]);
	}
	m_BackgroundCombo.SetCurSel(at3dData->backgroundIndex);

	m_BackgroundRed.Format("%.4f", at3dData->backgroundColor.red);
	m_BackgroundGreen.Format("%.4f", at3dData->backgroundColor.green);
	m_BackgroundBlue.Format("%.4f", at3dData->backgroundColor.blue);

	for (i=0; i<at3dData->textureTypeCount; i++)
	{
		m_TextureTypeCombo.AddString(at3dData->textureTypeLabel[i]);
	}
	m_TextureTypeCombo.SetCurSel(at3dData->textureTypeIndex);

	SetEditTexture();

	m_RotateAboutOrigin = (at3dData->originRotateFlag) ? 1 : 0;
	m_DrawObjectAxes = (at3dData->drawObjectAxesFlag) ? 1 : 0;

	m_ReducePolygonsStep.Format("%d", at3dData->reducePolygonsStep);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CObjectPage::OnGetminmaxobject() 
{
	At3d_GetObjectMinMax(&at3dData->objectMinMax.minX);

	m_MinXObject.Format("%f", at3dData->objectMinMax.minX);
	m_MinYObject.Format("%f", at3dData->objectMinMax.minY);
	m_MinZObject.Format("%f", at3dData->objectMinMax.minZ);

	m_MaxXObject.Format("%f", at3dData->objectMinMax.maxX);
	m_MaxYObject.Format("%f", at3dData->objectMinMax.maxY);
	m_MaxZObject.Format("%f", at3dData->objectMinMax.maxZ);
	UpdateData(FALSE);
}

void CObjectPage::OnUse2dobject() 
{
	UpdateData(TRUE);
	At3d_WriteFlag(LIBFLAG_MIN_MAX_USE_2D, (m_Use2DObject) ? 1 : 0);
  OnGetminmaxobject();
}

void CObjectPage::OnCopyxtoyzobject() 
{
	UpdateData(TRUE);
	m_EditYObject = m_EditXObject;
	m_EditZObject = m_EditXObject;
	UpdateData(FALSE);
}

void CObjectPage::OnCalccenterobject() 
{
	At3d_GetObjectCenter(&at3dData->objectCenter.x);

  m_EditXObject.Format("%f", at3dData->objectCenter.x);
	m_EditYObject.Format("%f", at3dData->objectCenter.y);
	m_EditZObject.Format("%f", at3dData->objectCenter.z);
	UpdateData(FALSE);
}

void CObjectPage::GetEditXYZObject(void)
{
	UpdateData(TRUE);
	at3dData->objectEdit.x = atof(m_EditXObject);
	at3dData->objectEdit.y = atof(m_EditYObject);
	at3dData->objectEdit.z = atof(m_EditZObject);
}

void CObjectPage::OnSetcenterobject() 
{
	GetEditXYZObject();
  At3d_SetObjectCenter(&at3dData->objectEdit.x);
  OnGetminmaxobject();
}

void CObjectPage::OnSetmin1object() 
{
	At3d_SetObject_Min000();
	OnGetminmaxobject();
}

void CObjectPage::OnSetmin2object() 
{
	GetEditXYZObject();
  At3d_SetObject_MinXYZ(&at3dData->objectEdit.x);
	OnGetminmaxobject();
}

void CObjectPage::OnSetmin3object() 
{
	At3d_SetObject_XYCenter_Z0();
	OnGetminmaxobject();
}

void CObjectPage::OnDoscaleobject() 
{
	GetEditXYZObject();
  At3d_ScaleObject(&at3dData->objectEdit.x);
	OnGetminmaxobject();
}

void CObjectPage::OnMirrorxobject() 
{
	At3d_MirrorObjectX();
	OnGetminmaxobject();
}

void CObjectPage::OnMirroryobject() 
{
	At3d_MirrorObjectY();
	OnGetminmaxobject();
}

void CObjectPage::OnMirrorzobject() 
{
	At3d_MirrorObjectZ();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatex1object() 
{
	At3d_RotateObjectX_90Minus();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatex2object() 
{
	At3d_RotateObjectX_90Plus();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatex3object() 
{
	At3d_RotateObjectX_180();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatey1object() 
{
	At3d_RotateObjectY_90Minus();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatey2object() 
{
	At3d_RotateObjectY_90Plus();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatey3object() 
{
	At3d_RotateObjectY_180();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatez1object() 
{
	At3d_RotateObjectZ_90Minus();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatez2object() 
{
	At3d_RotateObjectZ_90Plus();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatez3object() 
{
	At3d_RotateObjectZ_180();
	OnGetminmaxobject();
}

void CObjectPage::OnRotatexyzobject() 
{
	At3d_RotateObjectXYZ();
	OnGetminmaxobject();
}

void CObjectPage::OnSelchangeBackgroundcombo() 
{
	if (m_BackgroundCombo.GetCurSel() != CB_ERR)
	{
		at3dData->backgroundIndex = m_BackgroundCombo.GetCurSel();
	}
}

void CObjectPage::OnBackgroundget() 
{
	if (at3dData->backgroundIndex == 4)
  {
    At3d_GetDemColorMap(at3dData->backgroundType[at3dData->backgroundIndex],
                        &at3dData->backgroundColor.red);
  }
  else
  {
    At3d_GetColorMap(at3dData->backgroundType[at3dData->backgroundIndex],
                     &at3dData->backgroundColor.red);
  }
	
	m_BackgroundRed.Format("%.4f", at3dData->backgroundColor.red);
	m_BackgroundGreen.Format("%.4f", at3dData->backgroundColor.green);
	m_BackgroundBlue.Format("%.4f", at3dData->backgroundColor.blue);

	UpdateData(FALSE);
}

void CObjectPage::OnBackgroundset() 
{
	UpdateData(TRUE);
	
	at3dData->backgroundColor.red = (float)atof(m_BackgroundRed);
	at3dData->backgroundColor.green = (float)atof(m_BackgroundGreen);
	at3dData->backgroundColor.blue = (float)atof(m_BackgroundBlue);

	if (at3dData->backgroundIndex == 4)
  {
    At3d_SetDemColorMap(at3dData->backgroundType[at3dData->backgroundIndex],
                        &at3dData->backgroundColor.red);
  }
  else
  {
    At3d_SetColorMap(at3dData->backgroundType[at3dData->backgroundIndex],
                     &at3dData->backgroundColor.red);
  }
}

void CObjectPage::GetEditTexture()
{
	UpdateData(TRUE);

	at3dData->textureCenter[0] = (float)atof(m_TextureCenter0);
	at3dData->textureCenter[1] = (float)atof(m_TextureCenter1);

	at3dData->textureRotation = (float)atof(m_TextureRotation);

	at3dData->textureScale[0] = (float)atof(m_TextureScale0);
	at3dData->textureScale[1] = (float)atof(m_TextureScale1);

	at3dData->textureTranslation[0] = (float)atof(m_TextureTranslation0);
	at3dData->textureTranslation[1] = (float)atof(m_TextureTranslation1);
	
	if (at3dData->textureScale[0] <= 0.0) at3dData->textureScale[0] = 1.0;
	if (at3dData->textureScale[1] <= 0.0) at3dData->textureScale[1] = 1.0;
	
	SetEditTexture();
}

void CObjectPage::SetEditTexture()
{
	m_TextureCenter0.Format("%.4f", at3dData->textureCenter[0]);
	m_TextureCenter1.Format("%.4f", at3dData->textureCenter[1]);

	m_TextureRotation.Format("%.4f", at3dData->textureRotation);

	m_TextureScale0.Format("%.4f", at3dData->textureScale[0]);
	m_TextureScale1.Format("%.4f", at3dData->textureScale[1]);

	m_TextureTranslation0.Format("%.4f", at3dData->textureTranslation[0]);
	m_TextureTranslation1.Format("%.4f", at3dData->textureTranslation[1]);

	UpdateData(FALSE);
}

void CObjectPage::OnSelchangeTexturetypecombo() 
{
	if (m_TextureTypeCombo.GetCurSel() != CB_ERR)
	{
		at3dData->textureTypeIndex = m_TextureTypeCombo.GetCurSel();
	}
}

void CObjectPage::OnCreateuv() 
{
	GetEditTexture();
  at3dData->Create_UV_Coordinates();
}

void CObjectPage::OnRemoveuv() 
{
	at3dData->Remove_UV_Coordinates();
}

void CObjectPage::OnUvdialog() 
{
	At3d_Create_UV_Dialog();
}

void CObjectPage::OnZeroallz() 
{
	At3d_ZeroAll_Z();
  OnGetminmaxobject();
}

void CObjectPage::OnEraselines1() 
{
	at3dData->EraseLines1();
}

void CObjectPage::OnEraselines2() 
{
	at3dData->EraseLines2();
}

void CObjectPage::OnEraseclouds1() 
{
	at3dData->EraseClouds1();
}

void CObjectPage::OnERASEClouds2() 
{
	at3dData->EraseClouds2();
}

void CObjectPage::OnWaterTightCheck() 
{
	at3dData->WatertightCheck();
}

void CObjectPage::OnRotateaboutorigin() 
{
	UpdateData(TRUE);
	at3dData->originRotateFlag = (m_RotateAboutOrigin) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_ORIGIN_ROTATE, at3dData->originRotateFlag);
}

void CObjectPage::OnDrawobjectaxes() 
{
	UpdateData(TRUE);
	at3dData->drawObjectAxesFlag = (m_DrawObjectAxes) ? 1 : 0;
  At3d_WriteFlag(LIBFLAG_DRAW_OBJECT_AXES, at3dData->drawObjectAxesFlag);
}

void CObjectPage::OnReducepolygonsstart() 
{
	at3dData->StartReducePolygons();

  ReducePolygonsDisplayData();
}

void CObjectPage::OnReducepolygonsokay() 
{
	At3d_StopReducePolygons(1);
}

void CObjectPage::OnReducepolygonscancel() 
{
	At3d_StopReducePolygons(0); 
}

void CObjectPage::OnReducepolygonsselectlayer() 
{
	at3dData->SelectReducePolygonsLayer();

  ReducePolygonsDisplayData();
}

void CObjectPage::OnReducepolygonsset() 
{
	ReducePolygonsGetVertices();

  at3dData->DoReducePolygons();

  ReducePolygonsDisplayData();
}

void CObjectPage::OnReducepolygonsdecrease() 
{
	ReducePolygonsGetVertices();
  ReducePolygonsGetStep();

  at3dData->reducePolygonsVertices1 -= at3dData->reducePolygonsStep;

  at3dData->DoReducePolygons();

  ReducePolygonsDisplayData();
}

void CObjectPage::OnReducepolygonsincrease() 
{
	ReducePolygonsGetVertices();
  ReducePolygonsGetStep();

  at3dData->reducePolygonsVertices1 += at3dData->reducePolygonsStep;

  at3dData->DoReducePolygons();

  ReducePolygonsDisplayData();
}

void CObjectPage::ReducePolygonsDisplayData(void)
{
	// display layer name in edit box
  //
  m_ReducePolygonsName = at3dData->reducePolygonsName;

  // display vertex and triangle counts
  //
  m_ReducePolygonsVertex0.Format("%d", at3dData->reducePolygonsVertices0);
  m_ReducePolygonsTriangle0.Format("%d", at3dData->reducePolygonsTriangles0);

  m_ReducePolygonsVertex1.Format("%d", at3dData->reducePolygonsVertices1);
  m_ReducePolygonsTriangle1.Format("%d", at3dData->reducePolygonsTriangles1);

	UpdateData(FALSE);
}

void CObjectPage::ReducePolygonsGetVertices(void)
{
	UpdateData(TRUE);

	at3dData->reducePolygonsVertices1 = atoi(m_ReducePolygonsVertex1);
}

void CObjectPage::ReducePolygonsGetStep(void)
{
	UpdateData(TRUE);

	at3dData->reducePolygonsStep = atoi(m_ReducePolygonsStep);

  if (at3dData->reducePolygonsStep < 1) at3dData->reducePolygonsStep = 1;
}
