// Object: Multimatknight

#ifndef at3dTestData_H
#define at3dTestData_H

#define LEN_LAYER_NAME   80

typedef struct tag_TEST_XYZ {
  float x;
  float y;
  float z;
  } TEST_XYZ;

typedef struct tag_TEST_UV {
  float u;
  float v;
  } TEST_UV;

typedef struct tag_TEST_XYZ_UV {
  float x;
  float y;
  float z;
  float u;
  float v;
  } TEST_XYZ_UV;

typedef struct tag_TEST_NORMAL {
  float x;
  float y;
  float z;
  } TEST_NORMAL;

typedef struct tag_TEST_TRIANGLE1 {
  __int32 xyzIndex[3];
  TEST_UV uv[3];
  TEST_NORMAL normal[3];
  } TEST_TRIANGLE1;

typedef struct tag_TEST_TRIANGLE2 {
  __int32 xyzIndex[3];
  __int32 uvIndex[3];
  __int32 normalIndex[3];
  } TEST_TRIANGLE2;

typedef struct tag_TEST_TRIANGLE3 {
  __int32 xyz_uvIndex[3];
  __int32 normalIndex[3];
  } TEST_TRIANGLE3;

typedef struct tag_TEST_TRIANGLE4 {
  __int32 xyzIndex[3];
  __int32 uvIndex[3];
  __int32 normalIndex[3];
  __int32 materialIndex;
  } TEST_TRIANGLE4;

typedef struct tag_TEST_RGB {
  float red;
  float green;
  float blue; 
  } TEST_RGB;

typedef struct tag_TEST_MATERIAL {
  char name[LEN_LAYER_NAME];
  void* layerPtr;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_MATERIAL;

typedef struct tag_TEST_3D_DATA1 {
  char name[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_TRIANGLE1* triangle;
  __int32 uvFlag;
  __int32 normalFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA1;

typedef struct tag_TEST_3D_DATA2 {
  char name[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_UV* uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE2* triangle;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA2;

typedef struct tag_TEST_3D_DATA3 {
  char name[LEN_LAYER_NAME];
  __int32 xyz_uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ_UV* xyz_uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE3* triangle;
  __int32 uvFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA3;

typedef struct tag_TEST_3D_DATA4 {
  char name[LEN_LAYER_NAME];
  float* matrix;
  __int32 xyz_uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ_UV* xyz_uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE3* triangle;
  __int32 uvFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA4;

typedef struct tag_TEST_3D_DATA5 {
  char name[LEN_LAYER_NAME];
  char parentName[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_UV* uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE4* triangle;
  __int32 tag;
  TEST_XYZ pivotPoint;
  } TEST_3D_DATA5;

#endif at3dTestData_H

__int32 Multimatknight_materialCount = 10;
__int32 Multimatknight_layerCount = 17;

TEST_MATERIAL Multimatknight_material[10] = {
  { "Mat0", 0,
    { 0.324706f, 0.324706f, 0.324706f }, { 0.811765f, 0.811765f, 0.811765f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenHelm.bmp" },
  { "Mat1", 0,
    { 0.4f, 0.4f, 0.0f }, { 1.0f, 1.0f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Mat2", 0,
    { 0.197647f, 0.048627f, 0.0f }, { 0.494118f, 0.121569f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Mat3", 0,
    { 0.324706f, 0.324706f, 0.324706f }, { 0.811765f, 0.811765f, 0.811765f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\BlueChain.bmp" },
  { "Mat4", 0,
    { 0.0f, 0.200784f, 0.0f }, { 0.0f, 0.501961f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Mat5", 0,
    { 0.218039f, 0.108235f, 0.029804f }, { 0.545098f, 0.270588f, 0.07451f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Mat6", 0,
    { 0.324706f, 0.324706f, 0.324706f }, { 0.811765f, 0.811765f, 0.811765f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\RedHelm.bmp" },
  { "Mat7", 0,
    { 0.324706f, 0.324706f, 0.324706f }, { 0.811765f, 0.811765f, 0.811765f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Mat8", 0,
    { 0.324706f, 0.324706f, 0.324706f }, { 0.811765f, 0.811765f, 0.811765f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenChrome.bmp" },
  { "Mat9", 0,
    { 0.324706f, 0.324706f, 0.324706f }, { 0.811765f, 0.811765f, 0.811765f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\RedChain.bmp" },
};

TEST_XYZ Multimatknight_xyz_Head[43] = {
  { 0.029573f, -0.110094f, 0.41371f }, { 0.079573f, -0.007094f, 0.43371f },
  { -0.092427f, -0.006094f, 0.43371f }, { -0.043427f, -0.110094f, 0.41671f },
  { 0.043573f, -0.114094f, 0.63371f }, { 0.094573f, -0.007094f, 0.63371f },
  { -0.107427f, -0.006094f, 0.63371f }, { -0.057427f, -0.113094f, 0.63371f },
  { 0.079283f, -0.007224f, 0.43391f }, { 0.044403f, 0.100056f, 0.49524f },
  { -0.056507f, 0.100616f, 0.49524f }, { -0.092147f, -0.006104f, 0.43391f },
  { 0.043463f, -0.113944f, 0.63366f }, { 0.094483f, -0.007224f, 0.63366f },
  { 0.044403f, 0.100056f, 0.63366f }, { -0.056507f, 0.100616f, 0.63366f },
  { -0.107337f, -0.006104f, 0.63366f }, { -0.057257f, -0.113384f, 0.63366f },
  { -0.006427f, 0.013776f, 0.65073f }, { -0.021427f, 0.137416f, 0.71475f },
  { -0.021427f, 0.117226f, 0.69562f }, { -0.007737f, 0.16292f, 0.49635f },
  { -0.007737f, 0.167384f, 0.50047f }, { 0.009893f, 0.137416f, 0.71475f },
  { 0.009893f, 0.117226f, 0.69562f }, { -0.003797f, 0.16292f, 0.49635f },
  { -0.003797f, 0.167384f, 0.50047f }, { -0.018617f, 0.039668f, 0.69818f },
  { -0.018617f, 0.05136f, 0.67398f }, { -0.021427f, 0.143658f, 0.69093f },
  { -0.021427f, 0.139966f, 0.71512f }, { 0.009083f, 0.037668f, 0.69818f },
  { 0.007083f, 0.05136f, 0.67398f }, { 0.009893f, 0.143658f, 0.69093f },
  { 0.009893f, 0.139966f, 0.71512f }, { -0.011297f, 0.000352f, 0.62691f },
  { -0.011297f, 0.006516f, 0.62166f }, { -0.017867f, 0.061772f, 0.68036f },
  { -0.017867f, 0.040087f, 0.69818f }, { 0.002773f, 0.000352f, 0.62691f },
  { 0.002773f, 0.006516f, 0.62166f }, { 0.009143f, 0.061772f, 0.68036f },
  { 0.009143f, 0.040087f, 0.69818f }
};

TEST_XYZ Multimatknight_xyz_Ll_arm[17] = {
  { 0.262071f, -0.030948f, -0.175305f }, { 0.268791f, 0.035132f, -0.175305f },
  { 0.321431f, 0.048572f, -0.176305f }, { 0.346071f, -0.008548f, -0.177305f },
  { 0.310231f, -0.052228f, -0.176305f }, { 0.232951f, -0.037668f, -0.001305f },
  { 0.249751f, 0.054172f, -0.000305f }, { 0.321431f, 0.070972f, 0.004695f },
  { 0.356151f, -0.010788f, 0.006695f }, { 0.306871f, -0.071268f, -0.009305f },
  { 0.243031f, -0.030948f, 0.071695f }, { 0.250871f, 0.041852f, 0.071695f },
  { 0.309111f, 0.055292f, 0.077695f }, { 0.337111f, -0.008548f, 0.080695f },
  { 0.296791f, -0.055588f, 0.073695f }, { 0.290071f, -0.001828f, 0.090695f },
  { 0.301271f, -0.000708f, -0.176305f }
};

TEST_XYZ Multimatknight_xyz_Ll_leg[30] = {
  { 0.040041f, -0.00365f, -0.7995f }, { 0.044921f, -0.00721f, -0.54008f },
  { 0.071171f, 0.05018f, -0.79613f }, { 0.068361f, 0.03349f, -0.53783f },
  { 0.133261f, 0.05018f, -0.79219f }, { 0.115061f, 0.03349f, -0.53483f },
  { 0.164201f, -0.00383f, -0.79125f }, { 0.138511f, -0.00721f, -0.53426f },
  { 0.133261f, -0.05766f, -0.79444f }, { 0.115061f, -0.0721f, -0.53558f },
  { 0.071171f, -0.05747f, -0.79856f }, { 0.068361f, -0.07192f, -0.53858f },
  { 0.112811f, 0.00179f, -0.95139f }, { 0.077171f, 0.00179f, -0.95383f },
  { 0.040041f, -0.00365f, -0.7995f }, { 0.115811f, 0.00704f, -0.95121f },
  { 0.097991f, 0.03818f, -0.95158f }, { 0.071171f, 0.05018f, -0.79613f },
  { 0.121811f, 0.00704f, -0.95064f }, { 0.139631f, 0.03799f, -0.94895f },
  { 0.133261f, 0.05018f, -0.79219f }, { 0.124811f, 0.00179f, -0.95064f },
  { 0.160641f, 0.00179f, -0.9482f }, { 0.164201f, -0.00383f, -0.79125f },
  { 0.121811f, -0.00346f, -0.95102f }, { 0.139631f, -0.03422f, -0.95046f },
  { 0.133261f, -0.05766f, -0.79444f }, { 0.115811f, -0.00346f, -0.95139f },
  { 0.097991f, -0.03422f, -0.95327f }, { 0.071171f, -0.05748f, -0.79856f }
};

TEST_XYZ Multimatknight_xyz_Lu_arm[27] = {
  { 0.237714f, -0.052585f, 0.078925f }, { 0.231159f, 0.043118f, 0.078925f },
  { 0.299331f, 0.082448f, 0.066925f }, { 0.347838f, 0.00641f, 0.078925f },
  { 0.309819f, -0.05914f, 0.081925f }, { 0.229848f, -0.052585f, 0.189925f },
  { 0.218049f, 0.053606f, 0.195925f }, { 0.300642f, 0.095558f, 0.199925f },
  { 0.370126f, 0.007721f, 0.189925f }, { 0.312441f, -0.091915f, 0.183925f },
  { 0.237714f, -0.056518f, 0.273925f }, { 0.231159f, 0.043118f, 0.273925f },
  { 0.300642f, 0.082448f, 0.273925f }, { 0.349149f, 0.00641f, 0.273925f },
  { 0.31113f, -0.078805f, 0.273925f }, { 0.227226f, -0.068317f, 0.323925f },
  { 0.221982f, 0.052295f, 0.322925f }, { 0.301953f, 0.103424f, 0.318925f },
  { 0.364881f, 0.007721f, 0.318925f }, { 0.313752f, -0.091915f, 0.315925f },
  { 0.237714f, -0.061762f, 0.361925f }, { 0.237714f, 0.047051f, 0.361925f },
  { 0.300642f, 0.077204f, 0.361925f }, { 0.349149f, 0.007721f, 0.360925f },
  { 0.31113f, -0.073561f, 0.361925f }, { 0.318996f, 0.010343f, 0.369925f },
  { 0.292776f, -0.010633f, 0.054925f }
};

TEST_XYZ Multimatknight_xyz_Lu_leg[18] = {
  { -0.017048f, -0.010851f, -0.21841f }, { 0.036624f, -0.004228f, -0.54551f },
  { 0.002834f, -0.008719f, -0.32738f }, { 0.02422f, 0.060775f, -0.21485f },
  { 0.063345f, 0.04217f, -0.54326f }, { 0.038334f, 0.075105f, -0.32401f },
  { 0.10654f, 0.060775f, -0.21035f }, { 0.116583f, 0.041954f, -0.54007f },
  { 0.108888f, 0.074888f, -0.31988f }, { 0.147808f, -0.011068f, -0.20903f },
  { 0.143316f, -0.004444f, -0.53932f }, { 0.144388f, -0.008719f, -0.31913f },
  { 0.10654f, -0.082489f, -0.21241f }, { 0.116378f, -0.078202f, -0.54045f },
  { 0.108033f, -0.099805f, -0.30975f }, { 0.02422f, -0.082272f, -0.2171f },
  { 0.063129f, -0.078202f, -0.54345f }, { 0.038334f, -0.106862f, -0.32682f }
};

TEST_XYZ Multimatknight_xyz_L_fingers[20] = {
  { 0.421579f, -0.15503f, 0.171205f }, { 0.384579f, -0.17263f, -0.253845f },
  { 0.384579f, -0.03578f, -0.793225f }, { 0.384579f, 0.05007f, -0.791735f },
  { 0.384579f, 0.17332f, -0.262785f }, { 0.384579f, 0.16552f, 0.174185f },
  { 0.433579f, 0.00077f, -0.258315f }, { 0.398579f, -0.15608f, 0.172695f },
  { 0.360579f, -0.17263f, -0.253845f }, { 0.360579f, -0.03578f, -0.788755f },
  { 0.360579f, 0.04412f, -0.791735f }, { 0.360579f, 0.17332f, -0.262785f },
  { 0.360579f, 0.16552f, 0.174185f }, { 0.421579f, -0.15503f, 0.171205f },
  { 0.384579f, -0.17263f, -0.253845f }, { 0.384579f, -0.03578f, -0.793225f },
  { 0.384579f, 0.05007f, -0.791735f }, { 0.384579f, 0.17332f, -0.262785f },
  { 0.384579f, 0.16552f, 0.174185f }, { 0.354579f, 0.00077f, -0.258315f }
};

TEST_XYZ Multimatknight_xyz_L_foot[14] = {
  { 0.043411f, 0.08957f, -1.06037f }, { 0.043601f, -0.0421f, -1.06037f },
  { 0.073611f, -0.23265f, -1.06487f }, { 0.152201f, -0.23378f, -1.06281f },
  { 0.185771f, 0.01924f, -1.06356f }, { 0.146381f, 0.10214f, -1.06187f },
  { 0.094431f, 0.02168f, -0.94333f }, { 0.049431f, -0.03234f, -1.02811f },
  { 0.071551f, -0.23847f, -1.03674f }, { 0.131191f, -0.22478f, -1.03167f },
  { 0.147511f, -0.02578f, -0.94727f }, { 0.141691f, 0.0515f, -0.94221f },
  { 0.094801f, -0.03422f, -0.94446f }, { 0.094801f, -0.03272f, -1.06018f }
};

TEST_XYZ Multimatknight_xyz_L_hand[18] = {
  { 0.331313f, -0.03163f, -0.394175f }, { 0.334733f, 0.03677f, -0.376175f },
  { 0.307373f, 0.03791f, -0.371175f }, { 0.306233f, -0.03277f, -0.388175f },
  { 0.355253f, -0.03733f, -0.299175f }, { 0.355253f, 0.06527f, -0.261175f },
  { 0.300533f, 0.02993f, -0.225175f }, { 0.315353f, -0.03847f, -0.298175f },
  { 0.313073f, -0.06355f, -0.313175f }, { 0.344993f, 0.04817f, -0.187175f },
  { 0.287993f, 0.05045f, -0.198175f }, { 0.294833f, -0.06241f, -0.311175f },
  { 0.314213f, -0.06811f, -0.294175f }, { 0.335873f, -0.00769f, -0.174175f },
  { 0.278873f, 0.00941f, -0.175175f }, { 0.295973f, -0.06925f, -0.296175f },
  { 0.311933f, -0.00769f, -0.180175f }, { 0.319913f, 0.00599f, -0.385175f }
};

TEST_XYZ Multimatknight_xyz_Obj[54] = {
  { -0.336259f, 0.132827f, -0.312733f }, { -0.336133f, -0.048057f, -0.305779f },
  { -0.336646f, -0.048057f, -0.333781f }, { -0.336509f, 0.132827f, -0.326838f },
  { -0.324927f, 0.132827f, -0.312919f }, { -0.324802f, -0.048057f, -0.305964f },
  { -0.325315f, -0.048057f, -0.333977f }, { -0.325189f, 0.132827f, -0.327023f },
  { -0.336475f, 0.177082f, -0.324385f }, { -0.336304f, 0.177082f, -0.315186f },
  { -0.336008f, 0.142665f, -0.298629f }, { -0.336259f, 0.132827f, -0.312733f },
  { -0.336133f, -0.048068f, -0.305779f }, { -0.334127f, -0.060255f, -0.196016f },
  { -0.333226f, -0.09938f, -0.146748f }, { -0.333363f, -0.104293f, -0.15391f },
  { -0.334127f, -0.07992f, -0.196016f }, { -0.336008f, -0.07992f, -0.298629f },
  { -0.336783f, -0.07992f, -0.340943f }, { -0.338653f, -0.07992f, -0.443762f },
  { -0.339428f, -0.104293f, -0.485869f }, { -0.339553f, -0.09938f, -0.493019f },
  { -0.338653f, -0.060255f, -0.443762f }, { -0.336646f, -0.048068f, -0.333792f },
  { -0.336521f, 0.132827f, -0.326838f }, { -0.336783f, 0.142665f, -0.340943f },
  { -0.325144f, 0.177082f, -0.324571f }, { -0.324984f, 0.177082f, -0.315371f },
  { -0.324676f, 0.142665f, -0.298814f }, { -0.324938f, 0.132827f, -0.312919f },
  { -0.324802f, -0.048068f, -0.305975f }, { -0.322807f, -0.060255f, -0.196202f },
  { -0.321906f, -0.09938f, -0.146944f }, { -0.322031f, -0.104293f, -0.154095f },
  { -0.322807f, -0.07992f, -0.196202f }, { -0.324676f, -0.07992f, -0.298814f },
  { -0.325451f, -0.07992f, -0.341128f }, { -0.327321f, -0.07992f, -0.443948f },
  { -0.328096f, -0.104293f, -0.486054f }, { -0.328222f, -0.09938f, -0.493216f },
  { -0.327321f, -0.060255f, -0.443948f }, { -0.325315f, -0.048068f, -0.333977f },
  { -0.325189f, 0.132827f, -0.327023f }, { -0.325451f, 0.142665f, -0.341128f },
  { -0.335996f, -0.081236f, -0.298618f }, { -0.335996f, -0.316536f, -0.298618f },
  { -0.336338f, -0.687162f, -0.317431f }, { -0.336772f, -0.316536f, -0.340932f },
  { -0.336772f, -0.081236f, -0.340932f }, { -0.324665f, -0.081236f, -0.298814f },
  { -0.324665f, -0.316536f, -0.298814f }, { -0.325007f, -0.687162f, -0.317617f },
  { -0.32544f, -0.316536f, -0.341128f }, { -0.32544f, -0.081236f, -0.341128f }
};

TEST_XYZ Multimatknight_xyz_Pelvis[30] = {
  { -0.099f, 0.0f, -0.022f }, { -0.099f, 0.0f, 0.072f },
  { -0.05f, 0.065f, -0.021f }, { -0.049f, 0.063f, 0.073f },
  { 0.05f, 0.065f, -0.021f }, { 0.049f, 0.063f, 0.073f },
  { 0.099f, 0.0f, -0.022f }, { 0.099f, 0.0f, 0.072f },
  { 0.05f, -0.064f, -0.023f }, { 0.049f, -0.065f, 0.071f },
  { -0.05f, -0.064f, -0.023f }, { -0.049f, -0.065f, 0.071f },
  { -0.224f, -0.03622f, -0.27764f }, { -0.145f, 0.00178f, -0.07664f },
  { -0.099f, 0.00078f, -0.02264f }, { -0.103f, 0.15878f, -0.28164f },
  { -0.067f, 0.11578f, -0.08564f }, { -0.05f, 0.06478f, -0.02064f },
  { 0.099f, 0.15778f, -0.28264f }, { 0.067f, 0.11578f, -0.08564f },
  { 0.05f, 0.06478f, -0.02064f }, { 0.193f, -0.03622f, -0.27764f },
  { 0.141f, 0.00178f, -0.07664f }, { 0.099f, 0.00078f, -0.02264f },
  { 0.105f, -0.17422f, -0.30064f }, { 0.067f, -0.10322f, -0.07864f },
  { 0.05f, -0.06322f, -0.02364f }, { -0.103f, -0.17522f, -0.29864f },
  { -0.067f, -0.10122f, -0.07864f }, { -0.05f, -0.06322f, -0.02364f }
};

TEST_XYZ Multimatknight_xyz_Rl_arm[17] = {
  { -0.272909f, -0.025257f, -0.201564f }, { -0.279749f, 0.042003f, -0.201564f },
  { -0.333329f, 0.055683f, -0.201564f }, { -0.359549f, -0.002457f, -0.201564f },
  { -0.321929f, -0.046917f, -0.201564f }, { -0.239849f, -0.032097f, -0.011904f },
  { -0.256949f, 0.061383f, -0.010814f }, { -0.329909f, 0.078483f, -0.004274f },
  { -0.365249f, -0.004737f, -0.001004f }, { -0.315089f, -0.066297f, -0.019534f },
  { -0.248969f, -0.025257f, 0.066576f }, { -0.256949f, 0.048843f, 0.067666f },
  { -0.316229f, 0.062523f, 0.075296f }, { -0.344729f, -0.002457f, 0.078566f },
  { -0.303689f, -0.050337f, 0.069846f }, { -0.296849f, 0.004383f, 0.088376f },
  { -0.312809f, 0.005523f, -0.201564f }
};

TEST_XYZ Multimatknight_xyz_Rl_leg[30] = {
  { -0.220403f, 0.00529f, -0.78825f }, { -0.179352f, 0.001448f, -0.53313f },
  { -0.18512f, 0.066872f, -0.79125f }, { -0.152836f, 0.047846f, -0.5352f },
  { -0.114782f, 0.067089f, -0.79931f }, { -0.099814f, 0.048051f, -0.54139f },
  { -0.079499f, 0.005723f, -0.80456f }, { -0.073298f, 0.001653f, -0.54533f },
  { -0.114782f, -0.05586f, -0.80175f }, { -0.099598f, -0.072322f, -0.54214f },
  { -0.18512f, -0.05586f, -0.7935f }, { -0.152619f, -0.072322f, -0.53595f },
  { -0.19016f, 0.010959f, -0.9497f }, { -0.2258f, 0.010959f, -0.94502f },
  { -0.21267f, 0.005329f, -0.78825f }, { -0.18716f, 0.016209f, -0.94989f },
  { -0.20498f, 0.047149f, -0.94689f }, { -0.18172f, 0.059349f, -0.79125f },
  { -0.18116f, 0.016209f, -0.95083f }, { -0.16353f, 0.047339f, -0.95252f },
  { -0.12001f, 0.059529f, -0.79931f }, { -0.17816f, 0.011139f, -0.9512f },
  { -0.14271f, 0.011139f, -0.95589f }, { -0.08906f, 0.005699f, -0.80456f },
  { -0.18116f, 0.005889f, -0.95102f }, { -0.16353f, -0.025061f, -0.95402f },
  { -0.12001f, -0.048311f, -0.80175f }, { -0.18716f, 0.005889f, -0.95027f },
  { -0.20498f, -0.025061f, -0.94858f }, { -0.18172f, -0.048311f, -0.7935f }
};

TEST_XYZ Multimatknight_xyz_Ru_arm[27] = {
  { -0.246234f, -0.051559f, 0.047315f }, { -0.24099f, 0.044144f, 0.047315f },
  { -0.309162f, 0.083474f, 0.034235f }, { -0.357669f, 0.007436f, 0.047315f },
  { -0.31965f, -0.058114f, 0.050585f }, { -0.239679f, -0.05287f, 0.168305f },
  { -0.22788f, 0.054632f, 0.174845f }, { -0.310473f, 0.095273f, 0.179205f },
  { -0.378645f, 0.008747f, 0.168305f }, { -0.322272f, -0.090889f, 0.161765f },
  { -0.247545f, -0.056803f, 0.259865f }, { -0.24099f, 0.044144f, 0.259865f },
  { -0.310473f, 0.083474f, 0.259865f }, { -0.35898f, 0.007436f, 0.259865f },
  { -0.320961f, -0.07909f, 0.259865f }, { -0.237057f, -0.068602f, 0.314365f },
  { -0.231813f, 0.05201f, 0.313275f }, { -0.311784f, 0.103139f, 0.308915f },
  { -0.374712f, 0.008747f, 0.308915f }, { -0.323583f, -0.090889f, 0.305645f },
  { -0.247545f, -0.060736f, 0.355785f }, { -0.247545f, 0.046766f, 0.355785f },
  { -0.310473f, 0.076919f, 0.355785f }, { -0.35898f, 0.007436f, 0.354695f },
  { -0.320961f, -0.072535f, 0.355785f }, { -0.327516f, 0.011369f, 0.364505f },
  { -0.302607f, -0.009607f, 0.021155f }
};

TEST_XYZ Multimatknight_xyz_Ru_leg[18] = {
  { -0.163951f, -0.00326f, -0.21222f }, { -0.184049f, 0.003158f, -0.54214f },
  { -0.168659f, -0.001117f, -0.32232f }, { -0.122899f, 0.068366f, -0.21579f },
  { -0.157327f, 0.049772f, -0.54439f }, { -0.133376f, 0.082696f, -0.32513f },
  { -0.041002f, 0.068582f, -0.22516f }, { -0.104294f, 0.049772f, -0.55058f },
  { -0.063243f, 0.082696f, -0.3332f }, { 0.00005f, -0.003044f, -0.23116f },
  { -0.077778f, 0.003374f, -0.55433f }, { -0.02796f, -0.000901f, -0.33864f },
  { -0.041002f, -0.074453f, -0.22741f }, { -0.104078f, -0.070395f, -0.55077f },
  { -0.061316f, -0.091998f, -0.32307f }, { -0.122899f, -0.07467f, -0.21804f },
  { -0.157111f, -0.070612f, -0.54476f }, { -0.133376f, -0.09926f, -0.32795f }
};

TEST_XYZ Multimatknight_xyz_R_foot[14] = {
  { -0.106951f, 0.08018f, -1.04724f }, { -0.107131f, -0.05149f, -1.04705f },
  { -0.137141f, -0.24205f, -1.05155f }, { -0.215731f, -0.24317f, -1.04968f },
  { -0.249301f, 0.00984f, -1.05024f }, { -0.209921f, 0.09274f, -1.04874f },
  { -0.157961f, 0.01228f, -0.9302f }, { -0.118961f, -0.04174f, -1.01498f },
  { -0.135081f, -0.24805f, -1.02361f }, { -0.194721f, -0.23417f, -1.01835f },
  { -0.211041f, -0.03517f, -0.93414f }, { -0.205231f, 0.0421f, -0.92908f },
  { -0.158341f, -0.04361f, -0.93133f }, { -0.158341f, -0.04211f, -1.04705f }
};

TEST_XYZ Multimatknight_xyz_R_hand[18] = {
  { -0.338299f, -0.021928f, -0.431925f }, { -0.342859f, 0.046472f, -0.412305f },
  { -0.314359f, 0.047612f, -0.405765f }, { -0.312079f, -0.023068f, -0.424295f },
  { -0.365659f, -0.027628f, -0.329465f }, { -0.367939f, 0.074972f, -0.288045f },
  { -0.313219f, 0.040772f, -0.246625f }, { -0.325759f, -0.028768f, -0.326195f },
  { -0.322339f, -0.053848f, -0.342545f }, { -0.359959f, 0.057872f, -0.206295f },
  { -0.302959f, 0.060152f, -0.217195f }, { -0.305239f, -0.052708f, -0.340365f },
  { -0.325759f, -0.058408f, -0.321835f }, { -0.351979f, 0.002012f, -0.192125f },
  { -0.294979f, 0.019112f, -0.192125f }, { -0.307519f, -0.059548f, -0.324015f },
  { -0.328039f, 0.003152f, -0.197575f }, { -0.325759f, 0.015692f, -0.421025f }
};

TEST_XYZ Multimatknight_xyz_Torso[40] = {
  { -0.00245f, -0.01167f, 0.4859f }, { -0.12241f, -0.00255f, 0.00492f },
  { -0.19739f, -0.00369f, 0.0584f }, { -0.241577f, -0.00597f, 0.17924f },
  { -0.241577f, -0.00939f, 0.3605f }, { -0.072629f, -0.01053f, 0.3947f },
  { -0.059633f, -0.01167f, 0.4802f }, { -0.00375f, -0.01281f, 0.4859f },
  { -0.06743f, 0.08641f, 0.00606f }, { -0.09992f, 0.10689f, 0.05954f },
  { -0.122014f, 0.14337f, 0.25106f }, { -0.123313f, 0.07269f, 0.36164f },
  { -0.03754f, 0.03165f, 0.40184f }, { -0.032341f, 0.02253f, 0.48134f },
  { 0.05993f, 0.08541f, 0.00606f }, { 0.09242f, 0.10689f, 0.05954f },
  { 0.114514f, 0.14337f, 0.2465f }, { 0.115813f, 0.11259f, 0.36164f },
  { 0.03004f, 0.03165f, 0.39584f }, { 0.024841f, 0.02253f, 0.48134f },
  { -0.00505f, -0.01167f, 0.4859f }, { 0.12491f, -0.00255f, 0.00492f },
  { 0.18989f, -0.00369f, 0.0584f }, { 0.234077f, -0.00597f, 0.17924f },
  { 0.234077f, -0.00939f, 0.3605f }, { 0.065129f, -0.01053f, 0.3947f },
  { 0.052133f, -0.01167f, 0.4802f }, { -0.00375f, -0.01053f, 0.4859f },
  { 0.05993f, -0.08351f, 0.00378f }, { 0.09242f, -0.11655f, 0.05612f },
  { 0.115813f, -0.14619f, 0.17696f }, { 0.115813f, -0.11541f, 0.35822f },
  { 0.03004f, -0.05157f, 0.3947f }, { 0.024841f, -0.04587f, 0.4802f },
  { -0.06743f, -0.08651f, 0.00378f }, { -0.09992f, -0.11655f, 0.05612f },
  { -0.123313f, -0.14619f, 0.17696f }, { -0.123313f, -0.11769f, 0.35822f },
  { -0.03754f, -0.05157f, 0.3947f }, { -0.032341f, -0.04587f, 0.4802f }
};

TEST_UV Multimatknight_uv_Head[8] = {
  { 0.2247f, 0.6593f }, { 0.2661f, 0.4015f }, { 0.3613f, 0.6593f },
  { 0.3997f, 0.3793f }, { 0.5977f, 0.3749f }, { 0.6361f, 0.6593f },
  { 0.7339f, 0.4015f }, { 0.7753f, 0.6593f }
};

TEST_UV Multimatknight_uv_Ll_arm[36] = {
  { 0.0f, 0.328358f }, { 0.38189f, 0.328358f }, { 0.040909f, 0.464552f },
  { 0.358268f, 0.464552f }, { 0.059055f, 0.330224f }, { 0.431818f, 0.330224f },
  { 0.102362f, 0.464552f }, { 0.427273f, 0.464552f }, { 0.118182f, 0.003731f },
  { 0.118182f, 0.358268f }, { 0.358268f, 0.003731f }, { 0.125984f, 0.003731f },
  { 0.145455f, 0.125984f }, { 0.354545f, 0.003731f }, { 0.231818f, 0.244094f },
  { 0.231818f, 0.5f }, { 0.255906f, 0.5f }, { 0.268182f, 0.5f },
  { 0.259091f, 0.468284f }, { 0.277273f, 0.251969f }, { 0.3f, 0.313433f },
  { 0.190909f, 0.475746f }, { 0.309091f, 0.444882f }, { 0.313636f, 0.001866f },
  { 0.313636f, 0.433071f }, { 0.140909f, 0.001866f }, { 0.359091f, 0.07874f },
  { 0.140909f, 0.339552f }, { 0.077273f, 0.481343f }, { 0.422727f, 0.220472f },
  { 0.422727f, 0.481343f }, { 0.040909f, 0.0f }, { 0.459091f, 0.0f },
  { 0.459091f, 0.279528f }, { 0.0f, 0.343284f }, { 0.5f, 0.343284f }
};

TEST_UV Multimatknight_uv_Lu_arm[57] = {
  { 0.127517f, 0.22381f }, { 0.5f, 0.22381f }, { 0.130872f, 0.425397f },
  { 0.487069f, 0.425397f }, { 0.030172f, 0.426984f }, { 0.439597f, 0.426984f },
  { 0.038793f, 0.214286f }, { 0.399329f, 0.214286f }, { 0.043103f, 0.154362f },
  { 0.154362f, 0.038095f }, { 0.456897f, 0.038095f }, { 0.154362f, 0.347619f },
  { 0.456897f, 0.347619f }, { 0.064655f, 0.077181f }, { 0.064655f, 0.487302f },
  { 0.422819f, 0.487302f }, { 0.064655f, 0.347619f }, { 0.409396f, 0.347619f },
  { 0.064655f, 0.038095f }, { 0.399329f, 0.038095f }, { 0.064655f, 0.355705f },
  { 0.144295f, 0.487302f }, { 0.435345f, 0.487302f }, { 0.208054f, 0.0f },
  { 0.24569f, 0.0f }, { 0.24569f, 0.291946f }, { 0.291946f, 0.0f },
  { 0.232759f, 0.019048f }, { 0.267241f, 0.053691f }, { 0.446309f, 0.019048f },
  { 0.228448f, 0.487302f }, { 0.271552f, 0.432886f }, { 0.432886f, 0.487302f },
  { 0.228448f, 0.347619f }, { 0.228448f, 0.230159f }, { 0.224138f, 0.419048f },
  { 0.301724f, 0.042857f }, { 0.306034f, 0.347619f }, { 0.04698f, 0.487302f },
  { 0.306034f, 0.04698f }, { 0.306034f, 0.487302f }, { 0.310345f, 0.204762f },
  { 0.314655f, 0.414286f }, { 0.261745f, 0.5f }, { 0.331896f, 0.261745f },
  { 0.073276f, 0.038095f }, { 0.251678f, 0.038095f }, { 0.426724f, 0.038095f },
  { 0.068966f, 0.347619f }, { 0.431034f, 0.347619f }, { 0.068966f, 0.485714f },
  { 0.255034f, 0.485714f }, { 0.431034f, 0.485714f }, { 0.017241f, 0.419048f },
  { 0.482759f, 0.419048f }, { 0.0f, 0.214286f }, { 0.5f, 0.214286f }
};

TEST_UV Multimatknight_uv_L_fingers[7] = {
  { 0.0f, 0.594417f }, { 0.395577f, 0.0f }, { 0.643735f, 0.001642f },
  { 0.977453f, 1.0f }, { 1.0f, 0.584565f }, { 0.050874f, 0.996716f },
  { 0.501229f, 0.589491f }
};

TEST_UV Multimatknight_uv_L_hand[48] = {
  { 0.0f, 0.292373f }, { 0.0f, 0.497727f }, { 0.207627f, 0.497727f },
  { 0.5f, 0.497727f }, { 0.055085f, 0.445455f }, { 0.440299f, 0.445455f },
  { 0.104478f, 0.188636f }, { 0.395522f, 0.188636f }, { 0.474576f, 0.188636f },
  { 0.11194f, 0.222727f }, { 0.5f, 0.222727f }, { 0.131356f, 0.384091f },
  { 0.358209f, 0.384091f }, { 0.179104f, 0.013636f }, { 0.179104f, 0.364407f },
  { 0.364407f, 0.013636f }, { 0.101695f, 0.052273f }, { 0.313433f, 0.052273f },
  { 0.216418f, 0.486364f }, { 0.021186f, 0.184091f }, { 0.223881f, 0.184091f },
  { 0.276119f, 0.184091f }, { 0.004237f, 0.227273f }, { 0.231343f, 0.227273f },
  { 0.238806f, 0.218182f }, { 0.261194f, 0.218182f }, { 0.385593f, 0.218182f },
  { 0.220339f, 0.020455f }, { 0.231343f, 0.020455f }, { 0.268657f, 0.220339f },
  { 0.13983f, 0.0f }, { 0.343284f, 0.0f }, { 0.343284f, 0.36017f },
  { 0.134328f, 0.040909f }, { 0.365672f, 0.105932f }, { 0.394068f, 0.040909f },
  { 0.228814f, 0.5f }, { 0.373134f, 0.228814f }, { 0.373134f, 0.5f },
  { 0.067164f, 0.470455f }, { 0.432836f, 0.436441f }, { 0.432836f, 0.470455f },
  { 0.436441f, 0.470455f }, { 0.0f, 0.215909f }, { 0.118644f, 0.215909f },
  { 0.5f, 0.215909f }, { 0.0f, 0.302273f }, { 0.5f, 0.302273f }
};

TEST_UV Multimatknight_uv_Pelvis[34] = {
  { 0.0f, 0.004348f }, { 0.5f, 0.004348f }, { 0.0f, 0.195652f },
  { 0.5f, 0.195652f }, { 0.123737f, 0.0f }, { 0.376263f, 0.008696f },
  { 0.126263f, 0.191304f }, { 0.373737f, 0.2f }, { 0.373737f, 0.191304f },
  { 0.126263f, 0.2f }, { 0.376263f, 0.0f }, { 0.123737f, 0.008696f },
  { 0.0f, 0.004348f }, { 0.5f, 0.004348f }, { 0.0f, 0.195652f },
  { 0.5f, 0.195652f }, { 0.0f, 0.0831f }, { 0.121f, 0.7989f },
  { 0.2484f, 0.0054f }, { 0.2495f, 0.0677f }, { 0.218f, 0.9946f },
  { 0.3108f, 0.7922f }, { 0.3108f, 0.7681f }, { 0.3593f, 0.9906f },
  { 0.3593f, 1.0f }, { 0.6412f, 0.9906f }, { 0.6412f, 1.0f },
  { 0.6898f, 0.7922f }, { 0.6892f, 0.7681f }, { 0.782f, 0.9946f },
  { 0.7505f, 0.0644f }, { 0.7521f, 0.0f }, { 0.879f, 0.7989f },
  { 1.0f, 0.0831f }
};

TEST_UV Multimatknight_uv_Rl_arm[36] = {
  { 0.0f, 0.345865f }, { 0.5f, 0.345865f }, { 0.022727f, 0.0f },
  { 0.022727f, 0.279528f }, { 0.477273f, 0.0f }, { 0.081818f, 0.220472f },
  { 0.081818f, 0.483083f }, { 0.418182f, 0.483083f }, { 0.127273f, 0.07874f },
  { 0.372727f, 0.0f }, { 0.359091f, 0.340226f }, { 0.172727f, 0.0f },
  { 0.172727f, 0.433071f }, { 0.195455f, 0.444882f }, { 0.304545f, 0.477444f },
  { 0.2f, 0.31391f }, { 0.209091f, 0.251969f }, { 0.245455f, 0.468045f },
  { 0.227273f, 0.5f }, { 0.244094f, 0.5f }, { 0.272727f, 0.244094f },
  { 0.272727f, 0.5f }, { 0.159091f, 0.0f }, { 0.340909f, 0.125984f },
  { 0.374016f, 0.0f }, { 0.141732f, 0.0f }, { 0.368182f, 0.0f },
  { 0.368182f, 0.358268f }, { 0.068182f, 0.464286f }, { 0.397638f, 0.464286f },
  { 0.068182f, 0.328947f }, { 0.440945f, 0.328947f }, { 0.141732f, 0.462406f },
  { 0.463636f, 0.462406f }, { 0.11811f, 0.327068f }, { 0.5f, 0.327068f }
};

TEST_UV Multimatknight_uv_Ru_arm[55] = {
  { 0.0f, 0.214286f }, { 0.5f, 0.214286f }, { 0.013043f, 0.419048f },
  { 0.486957f, 0.419048f }, { 0.065217f, 0.347619f }, { 0.434783f, 0.347619f },
  { 0.065217f, 0.485714f }, { 0.246622f, 0.485714f }, { 0.434783f, 0.485714f },
  { 0.069565f, 0.038095f }, { 0.246622f, 0.038095f }, { 0.430435f, 0.038095f },
  { 0.169565f, 0.263514f }, { 0.236486f, 0.5f }, { 0.182609f, 0.414286f },
  { 0.186956f, 0.204762f }, { 0.191304f, 0.347619f }, { 0.191304f, 0.047297f },
  { 0.191304f, 0.487302f }, { 0.452703f, 0.487302f }, { 0.195652f, 0.042857f },
  { 0.278261f, 0.419048f }, { 0.067568f, 0.487302f }, { 0.226087f, 0.432432f },
  { 0.273913f, 0.487302f }, { 0.273913f, 0.347619f }, { 0.273913f, 0.230159f },
  { 0.050676f, 0.019048f }, { 0.269565f, 0.019048f }, { 0.449324f, 0.019048f },
  { 0.209459f, 0.0f }, { 0.252174f, 0.0f }, { 0.290541f, 0.0f },
  { 0.077703f, 0.487302f }, { 0.434783f, 0.077703f }, { 0.434783f, 0.487302f },
  { 0.087838f, 0.347619f }, { 0.434783f, 0.347619f }, { 0.065217f, 0.487302f },
  { 0.35473f, 0.487302f }, { 0.434783f, 0.35473f }, { 0.101351f, 0.038095f },
  { 0.43913f, 0.038095f }, { 0.043478f, 0.038095f }, { 0.347973f, 0.038095f },
  { 0.043478f, 0.347619f }, { 0.347973f, 0.347619f }, { 0.097973f, 0.214286f },
  { 0.46087f, 0.214286f }, { 0.057432f, 0.426984f }, { 0.469565f, 0.426984f },
  { 0.013044f, 0.425397f }, { 0.368243f, 0.425397f }, { 0.0f, 0.22381f },
  { 0.375f, 0.22381f }
};

TEST_UV Multimatknight_uv_R_hand[46] = {
  { 0.0f, 0.3f }, { 0.5f, 0.3f }, { 0.015625f, 0.213636f },
  { 0.381356f, 0.213636f }, { 0.484375f, 0.213636f }, { 0.054687f, 0.436441f },
  { 0.054687f, 0.470455f }, { 0.063559f, 0.470455f }, { 0.445313f, 0.470455f },
  { 0.109375f, 0.228814f }, { 0.109375f, 0.5f }, { 0.271186f, 0.5f },
  { 0.105932f, 0.040909f }, { 0.328125f, 0.040909f }, { 0.139831f, 0.0f },
  { 0.203125f, 0.0f }, { 0.296875f, 0.0f }, { 0.36017f, 0.0f },
  { 0.273437f, 0.488636f }, { 0.289063f, 0.229545f }, { 0.495763f, 0.229545f },
  { 0.114407f, 0.220455f }, { 0.210937f, 0.220455f }, { 0.289063f, 0.220455f },
  { 0.210937f, 0.022727f }, { 0.279661f, 0.022727f }, { 0.1875f, 0.186364f },
  { 0.3125f, 0.186364f }, { 0.478814f, 0.186364f }, { 0.132813f, 0.054545f },
  { 0.398305f, 0.054545f }, { 0.125f, 0.386364f }, { 0.372881f, 0.386364f },
  { 0.135593f, 0.015909f }, { 0.382812f, 0.015909f }, { 0.0f, 0.225f },
  { 0.414063f, 0.225f }, { 0.025424f, 0.190909f }, { 0.070313f, 0.190909f },
  { 0.429687f, 0.190909f }, { 0.054687f, 0.447727f }, { 0.444915f, 0.447727f },
  { 0.0f, 0.5f }, { 0.292373f, 0.5f }, { 0.5f, 0.292373f },
  { 0.5f, 0.5f }
};

TEST_UV Multimatknight_uv_Torso[79] = {
  { 0.0f, 0.614173f }, { 0.0f, 0.961868f }, { 1.3f, 0.961868f },
  { 0.0f, 0.473115f }, { 1.3f, 0.473115f }, { 0.120765f, 0.147279f },
  { 0.660236f, 0.147279f }, { 1.179235f, 0.147279f }, { 0.323224f, 0.466967f },
  { 0.323224f, 0.127953f }, { 0.323224f, 0.955721f }, { 0.976776f, 0.964942f },
  { 0.655118f, 0.003074f }, { 0.919647f, 0.003074f }, { 0.973224f, 0.666772f },
  { 0.387158f, 0.141131f }, { 0.912841f, 0.150353f }, { 0.461749f, 0.609055f },
  { 0.461749f, 1.054086f }, { 0.838251f, 1.054086f }, { 0.475956f, 0.0f },
  { 0.942271f, 0.0f }, { 0.824044f, 0.006148f }, { 0.497268f, 0.603937f },
  { 0.497268f, 0.696063f }, { 0.497268f, 1.28463f }, { 0.802732f, 1.28463f },
  { 0.55765f, 0.424803f }, { 0.55765f, 1.054086f }, { 0.55765f, 0.798425f },
  { 0.74235f, 1.073339f }, { 0.571858f, 0.450394f }, { 0.571858f, 0.849606f },
  { 0.571858f, 1.28463f }, { 0.571858f, 0.75748f }, { 0.728142f, 1.287704f },
  { 0.646448f, 0.603937f }, { 0.646448f, 0.696063f }, { 0.65f, 0.598819f },
  { 0.65f, 0.701181f }, { 0.65f, 0.609055f }, { 0.65f, 0.690945f },
  { 0.653552f, 0.603937f }, { 0.653552f, 0.696063f }, { 0.728142f, 0.450394f },
  { 0.728142f, 1.28463f }, { 0.571858f, 1.287704f }, { 0.728142f, 0.54252f },
  { 0.728142f, 0.75748f }, { 0.74235f, 0.424803f }, { 0.74235f, 1.054086f },
  { 0.55765f, 1.05716f }, { 0.74235f, 0.798425f }, { 0.497268f, 1.28463f },
  { 0.802732f, 0.603937f }, { 0.802732f, 0.696063f }, { 0.802732f, 1.28463f },
  { 0.824044f, 0.0f }, { 0.475956f, 0.006148f }, { 0.461749f, 1.054086f },
  { 0.838251f, 0.609055f }, { 0.838251f, 1.054086f }, { 0.912841f, 0.141131f },
  { 0.387158f, 0.150353f }, { 0.326776f, 0.654476f }, { 0.976776f, 0.466967f },
  { 0.976776f, 0.138189f }, { 0.976776f, 0.955721f }, { 0.323224f, 0.964942f },
  { 0.976776f, 1.161811f }, { 0.353022f, 0.003074f }, { 0.946978f, 0.003074f },
  { 0.120765f, 0.147279f }, { 1.179235f, 0.147279f }, { 0.0f, 0.961868f },
  { 1.3f, 0.614173f }, { 1.3f, 0.961868f }, { 0.0f, 0.473115f },
  { 1.3f, 0.473115f }
};

TEST_NORMAL Multimatknight_normal_Head[39] = {
  { -0.905877f, -0.418469f, -0.065352f }, { -0.903883f, -0.422375f, -0.067791f },
  { -0.554279f, -0.830903f, -0.048724f }, { -0.492699f, -0.868993f, -0.045814f },
  { 0.495976f, -0.866996f, -0.048225f }, { 0.542169f, -0.838878f, -0.048345f },
  { 0.901357f, -0.428032f, -0.065913f }, { 0.902644f, -0.425031f, -0.067698f },
  { -0.93315f, 0.352413f, -0.070961f }, { -0.902825f, 0.430009f, 0.0f },
  { -0.18281f, 0.087071f, 0.979285f }, { -0.152698f, -0.071282f, 0.985699f },
  { -0.000738f, -0.132757f, 0.991148f }, { 0.001074f, 0.193473f, 0.981105f },
  { 0.005549f, 0.999985f, 0.0f }, { 0.151664f, -0.072507f, 0.985769f },
  { 0.183481f, 0.085652f, 0.979285f }, { 0.903985f, 0.421994f, -0.068789f },
  { 0.950998f, 0.309198f, 0.0f }, { -0.999619f, -0.027302f, -0.004168f },
  { -0.999518f, -0.02795f, -0.013504f }, { -0.997048f, 0.05207f, -0.056418f },
  { -0.996991f, 0.053314f, -0.056269f }, { -0.996687f, -0.052736f, -0.061912f },
  { -0.996669f, -0.051778f, -0.06301f }, { -0.012047f, -0.166854f, 0.985908f },
  { 0.0f, -0.974703f, -0.223506f }, { 0.0f, -0.873429f, 0.486952f },
  { 0.0f, -0.16337f, 0.986565f }, { 0.0f, 0.180624f, -0.983552f },
  { 0.0f, 0.678226f, -0.734853f }, { 0.0f, 0.728142f, -0.685426f },
  { 0.0f, 0.990362f, 0.138506f }, { 0.995838f, -0.013773f, -0.090093f },
  { 0.996868f, -0.050212f, -0.061104f }, { 0.996885f, -0.051141f, -0.060039f },
  { 0.996991f, 0.053314f, -0.056269f }, { 0.997048f, 0.05207f, -0.056418f },
  { 0.999969f, -0.007723f, -0.001179f }
};

TEST_NORMAL Multimatknight_normal_Ll_arm[17] = {
  { -0.883638f, -0.468099f, -0.008231f }, { -0.72331f, -0.406202f, 0.55841f },
  { -0.714204f, 0.699656f, -0.019821f }, { -0.661879f, -0.386459f, -0.642313f },
  { -0.645885f, 0.530707f, 0.548801f }, { -0.58176f, 0.495705f, -0.644851f },
  { -0.064754f, -0.029463f, 0.997466f }, { -0.023233f, 0.002602f, -0.999727f },
  { 0.122585f, -0.805459f, 0.579835f }, { 0.184602f, -0.753298f, -0.63124f },
  { 0.223575f, -0.973959f, 0.037663f }, { 0.300183f, 0.709988f, 0.63703f },
  { 0.355499f, 0.693466f, -0.626678f }, { 0.445475f, 0.892685f, 0.068303f },
  { 0.741652f, -0.131799f, 0.657709f }, { 0.762321f, -0.104985f, -0.638628f },
  { 0.983542f, -0.14764f, 0.104148f }
};

TEST_NORMAL Multimatknight_normal_Ll_leg[30] = {
  { -0.99982f, -0.003632f, 0.018607f }, { -0.99724f, 0.074245f, -0.000172f },
  { -0.550632f, -0.833103f, -0.052374f }, { -0.530207f, -0.847365f, -0.029188f },
  { -0.509094f, 0.859259f, 0.049978f }, { -0.496271f, 0.86668f, 0.050793f },
  { 0.491665f, 0.866045f, 0.09073f }, { 0.499608f, 0.861437f, 0.091202f },
  { 0.506145f, -0.862359f, -0.012436f }, { 0.550699f, -0.834596f, 0.01346f },
  { 0.99115f, 0.086753f, 0.100471f }, { 0.996963f, 0.010076f, 0.077223f },
  { -0.972281f, 0.001346f, -0.233812f }, { -0.693264f, 0.018364f, -0.72045f },
  { -0.49614f, 0.854798f, -0.152202f }, { -0.488003f, -0.846637f, -0.212271f },
  { -0.323167f, 0.670443f, -0.667884f }, { -0.318828f, -0.63168f, -0.706632f },
  { 0.058559f, 0.01244f, -0.998206f }, { 0.062213f, 0.028329f, -0.997661f },
  { 0.064282f, 0.027583f, -0.997551f }, { 0.070204f, 0.031821f, -0.997025f },
  { 0.071625f, 0.025047f, -0.997117f }, { 0.080423f, 0.013301f, -0.996672f },
  { 0.428355f, -0.635055f, -0.642819f }, { 0.429614f, 0.668772f, -0.606774f },
  { 0.49195f, -0.863787f, -0.108891f }, { 0.495966f, 0.867086f, -0.046685f },
  { 0.807376f, 0.016482f, -0.589807f }, { 0.999715f, -0.003956f, -0.023532f }
};

TEST_NORMAL Multimatknight_normal_Lu_arm[27] = {
  { -0.898547f, 0.43689f, -0.041712f }, { -0.87731f, 0.472949f, 0.081528f },
  { -0.875272f, 0.482601f, 0.031532f }, { -0.813818f, -0.580067f, -0.034968f },
  { -0.790292f, -0.603332f, -0.10691f }, { -0.784441f, -0.619879f, 0.020059f },
  { -0.749419f, 0.37742f, -0.543991f }, { -0.597456f, -0.614033f, -0.515761f },
  { -0.5792f, 0.379365f, 0.721533f }, { -0.555871f, -0.460956f, 0.691756f },
  { 0.061759f, -0.143486f, -0.987723f }, { 0.134496f, 0.033527f, 0.990347f },
  { 0.159103f, 0.764709f, -0.624425f }, { 0.174574f, 0.641621f, 0.746891f },
  { 0.191482f, 0.980334f, 0.04774f }, { 0.211388f, 0.976352f, 0.045294f },
  { 0.273025f, 0.950996f, -0.145136f }, { 0.289729f, -0.951833f, -0.100358f },
  { 0.349985f, -0.617541f, 0.704381f }, { 0.358881f, -0.767943f, -0.530536f },
  { 0.393645f, -0.919262f, 0.001177f }, { 0.424515f, -0.902974f, -0.066528f },
  { 0.744299f, 0.059854f, 0.665158f }, { 0.835618f, -0.006939f, -0.549267f },
  { 0.995355f, 0.077864f, -0.056623f }, { 0.997291f, 0.07072f, 0.020223f },
  { 0.998303f, 0.057821f, 0.006921f }
};

TEST_NORMAL Multimatknight_normal_Lu_leg[18] = {
  { -0.990642f, 0.04082f, -0.130241f }, { -0.987668f, 0.042203f, -0.15077f },
  { -0.981875f, 0.080488f, -0.17159f }, { -0.57087f, -0.802922f, -0.171531f },
  { -0.557827f, 0.829957f, 0.000748f }, { -0.543407f, -0.833137f, 0.102919f },
  { -0.520231f, 0.851786f, -0.061812f }, { -0.494997f, -0.867879f, -0.041991f },
  { -0.491298f, 0.851313f, -0.184101f }, { 0.518268f, 0.846647f, 0.120779f },
  { 0.520826f, 0.853645f, -0.005511f }, { 0.535595f, 0.840277f, -0.084102f },
  { 0.562503f, -0.819889f, 0.106645f }, { 0.566858f, -0.820849f, 0.069851f },
  { 0.596895f, -0.799152f, -0.071219f }, { 0.99616f, 0.087521f, 0.002176f },
  { 0.999593f, -0.02853f, -0.000239f }, { 0.999968f, 0.001472f, -0.007885f }
};

TEST_NORMAL Multimatknight_normal_L_fingers[24] = {
  { 0.959418f, -0.272942f, -0.070844f }, { 0.96179f, 0.272416f, -0.027369f },
  { 0.986641f, 0.154004f, 0.053117f }, { 0.994931f, 0.050977f, -0.086683f },
  { 0.994955f, -0.048482f, -0.087829f }, { 0.999143f, 0.010484f, -0.040051f },
  { 0.999222f, 0.018711f, 0.034704f }, { -0.999936f, -0.000421f, -0.011282f },
  { -0.999395f, 0.034767f, 0.000621f }, { -0.999368f, 0.034532f, -0.008435f },
  { -0.999354f, -0.034809f, -0.008905f }, { -0.99543f, -0.032126f, 0.089928f },
  { -0.99136f, -0.117409f, 0.058477f }, { -0.234704f, 0.946707f, -0.220591f },
  { -0.183074f, 0.017059f, -0.982951f }, { -0.046114f, -0.967767f, -0.247591f },
  { 0.0f, -0.999248f, 0.038771f }, { 0.0f, -0.969289f, -0.245925f },
  { 0.0f, -0.009296f, 0.999957f }, { 0.0f, 0.971441f, -0.237282f },
  { 0.0f, 0.999841f, 0.017847f }, { 0.00924f, -0.03727f, -0.999263f },
  { 0.047976f, -0.998157f, 0.037154f }, { 0.06451f, 0.002999f, 0.997913f }
};

TEST_NORMAL Multimatknight_normal_L_foot[14] = {
  { -0.939603f, -0.038287f, 0.340117f }, { -0.784828f, -0.046099f, -0.617996f },
  { -0.664512f, 0.659005f, -0.352329f }, { -0.516661f, 0.298815f, 0.802354f },
  { -0.498861f, -0.797664f, 0.338926f }, { -0.461255f, -0.600215f, -0.653441f },
  { -0.438271f, -0.189475f, 0.878645f }, { -0.014613f, 0.006028f, -0.999875f },
  { 0.308517f, 0.589258f, 0.746721f }, { 0.333047f, -0.677363f, 0.655941f },
  { 0.357252f, 0.83108f, -0.426236f }, { 0.607628f, -0.164665f, 0.776964f },
  { 0.621241f, -0.683384f, -0.383466f }, { 0.819555f, 0.117755f, -0.56077f }
};

TEST_NORMAL Multimatknight_normal_L_hand[18] = {
  { -0.733073f, -0.088225f, 0.674403f }, { -0.661059f, 0.727998f, 0.18171f },
  { -0.65597f, -0.531702f, -0.535721f }, { -0.645504f, 0.158075f, -0.747219f },
  { -0.630039f, 0.67343f, -0.386709f }, { -0.616046f, 0.569207f, -0.54451f },
  { -0.615236f, -0.240548f, -0.750747f }, { -0.552696f, -0.833365f, 0.005421f },
  { -0.216373f, -0.763898f, 0.607982f }, { -0.185914f, 0.24701f, -0.951011f },
  { 0.372024f, -0.418943f, -0.828303f }, { 0.432251f, -0.482946f, -0.761526f },
  { 0.509958f, 0.641087f, -0.573542f }, { 0.513233f, 0.852981f, -0.094952f },
  { 0.559904f, -0.434876f, 0.705259f }, { 0.575864f, -0.816427f, 0.042756f },
  { 0.611345f, 0.498785f, 0.614387f }, { 0.765419f, -0.640034f, 0.067006f }
};

TEST_NORMAL Multimatknight_normal_Obj[69] = {
  { -0.999842f, 0.0f, 0.01778f }, { -0.999832f, 0.0f, 0.018318f },
  { -0.017298f, 0.038423f, -0.999112f }, { -0.016356f, 0.038364f, -0.99913f },
  { 0.016337f, 0.038423f, 0.999128f }, { 0.016339f, 0.038423f, 0.999128f },
  { 0.999827f, 0.0f, -0.018587f }, { 0.999832f, 0.0f, -0.01831f },
  { -0.999841f, 0.0f, 0.017808f }, { -0.99984f, 0.000503f, 0.017882f },
  { -0.999835f, 0.0f, 0.018137f }, { -0.999835f, 0.0f, 0.01818f },
  { -0.999834f, 0.000203f, 0.018219f }, { -0.999833f, 0.00017f, 0.018295f },
  { -0.999832f, 0.000183f, 0.01831f }, { -0.999832f, 0.000175f, 0.018317f },
  { -0.999832f, 0.0f, 0.018328f }, { -0.999831f, 0.0f, 0.018408f },
  { -0.999827f, 0.0f, 0.018585f }, { -0.999827f, 0.0f, 0.018585f },
  { -0.999827f, 0.0f, 0.018589f }, { -0.999825f, 0.000552f, 0.018715f },
  { -0.014734f, 0.433581f, -0.900994f }, { -0.010764f, 0.78316f, -0.621728f },
  { -0.010171f, 0.783092f, -0.621822f }, { -0.009803f, -0.824217f, -0.566189f },
  { -0.009353f, -0.820233f, -0.571952f }, { -0.009353f, -0.820233f, -0.571952f },
  { -0.00925f, -0.824618f, -0.565614f }, { -0.008199f, -0.8655f, -0.500841f },
  { -0.00819f, -0.865501f, -0.500839f }, { -0.001801f, 0.993918f, -0.110111f },
  { -0.0018f, 0.993918f, -0.110111f }, { 0.0f, -1.0f, 0.0f },
  { 0.0f, 1.0f, 0.0f }, { 0.001806f, 0.993895f, 0.110316f },
  { 0.00191f, 0.993896f, 0.110303f }, { 0.00819f, -0.865502f, 0.500839f },
  { 0.008192f, -0.865501f, 0.500839f }, { 0.009249f, -0.824626f, 0.565602f },
  { 0.009352f, -0.820233f, 0.571952f }, { 0.009363f, -0.820229f, 0.571958f },
  { 0.009814f, -0.824217f, 0.566189f }, { 0.010179f, 0.783092f, 0.621822f },
  { 0.010777f, 0.78316f, 0.621727f }, { 0.014732f, 0.433577f, 0.900996f },
  { 0.014749f, 0.433582f, 0.900994f }, { 0.999827f, 0.0f, -0.018589f },
  { 0.99983f, 0.000218f, -0.018435f }, { 0.999831f, 0.0f, -0.018407f },
  { 0.999831f, 0.0f, -0.018407f }, { 0.999832f, -0.000182f, -0.018318f },
  { 0.999832f, -0.000182f, -0.018318f }, { 0.999834f, -0.000204f, -0.018219f },
  { 0.999834f, 0.0f, -0.018217f }, { 0.999835f, -0.000153f, -0.018188f },
  { 0.999835f, 0.0f, -0.01818f }, { 0.99984f, 0.000503f, -0.017881f },
  { 0.99984f, -0.000518f, -0.017865f }, { 0.999842f, 0.0f, -0.017778f },
  { 0.999849f, -0.000595f, -0.017348f }, { -0.999832f, 0.0f, 0.018317f },
  { -0.017313f, 0.0f, -0.99985f }, { -0.017279f, -0.063291f, -0.997846f },
  { -0.016318f, -0.06332f, -0.99786f }, { 0.01633f, -0.050704f, 0.99858f },
  { 0.017289f, -0.050675f, 0.998566f }, { 0.017311f, 0.0f, 0.99985f },
  { 0.999832f, 0.0f, -0.018317f }
};

TEST_NORMAL Multimatknight_normal_Pelvis[30] = {
  { -0.999964f, -0.004246f, 0.007319f }, { -0.999899f, 0.014204f, 0.000672f },
  { -0.447861f, 0.893787f, 0.023781f }, { -0.44416f, -0.895931f, -0.005408f },
  { -0.439873f, -0.898047f, -0.004874f }, { -0.438241f, 0.898692f, 0.01726f },
  { 0.433136f, 0.901015f, 0.023778f }, { 0.440335f, -0.897817f, -0.005459f },
  { 0.442859f, 0.896425f, 0.017237f }, { 0.444622f, -0.895706f, -0.004799f },
  { 0.999941f, 0.007894f, 0.007492f }, { 0.999947f, -0.010235f, 0.000681f },
  { -0.905432f, -0.149815f, 0.397176f }, { -0.878941f, 0.017302f, 0.476617f },
  { -0.760765f, -0.012192f, 0.648913f }, { -0.473132f, 0.83875f, 0.269526f },
  { -0.403419f, 0.808668f, 0.428145f }, { -0.39357f, -0.79477f, 0.462f },
  { -0.368072f, 0.680971f, 0.633089f }, { -0.361318f, -0.856922f, 0.367607f },
  { -0.360896f, -0.708984f, 0.605884f }, { 0.370205f, -0.69943f, 0.611348f },
  { 0.371411f, 0.680809f, 0.631311f }, { 0.396647f, -0.791745f, 0.464554f },
  { 0.406826f, 0.807315f, 0.427475f }, { 0.411409f, -0.843521f, 0.345274f },
  { 0.502029f, 0.834508f, 0.227075f }, { 0.786348f, -0.020336f, 0.617449f },
  { 0.897562f, 0.008117f, 0.440814f }, { 0.951259f, -0.140961f, 0.274293f }
};

TEST_NORMAL Multimatknight_normal_Rl_arm[17] = {
  { -0.981982f, -0.148522f, 0.116844f }, { -0.779844f, -0.104656f, -0.617164f },
  { -0.73716f, -0.13619f, 0.661852f }, { -0.444358f, 0.893013f, 0.071236f },
  { -0.362389f, 0.695653f, -0.620275f }, { -0.293032f, 0.714207f, 0.635642f },
  { -0.219625f, -0.974781f, 0.039593f }, { -0.190827f, -0.75491f, -0.627452f },
  { -0.113401f, -0.813766f, 0.570022f }, { 0.0f, 0.0f, -1.0f },
  { 0.086018f, -0.039054f, 0.995528f }, { 0.570985f, 0.496114f, -0.654101f },
  { 0.651601f, -0.387655f, -0.652028f }, { 0.658204f, 0.532044f, 0.532632f },
  { 0.714632f, 0.69883f, -0.030618f }, { 0.738218f, -0.411595f, 0.534438f },
  { 0.883572f, -0.467822f, -0.021057f }
};

TEST_NORMAL Multimatknight_normal_Rl_leg[30] = {
  { -0.988144f, 0.068892f, 0.137206f }, { -0.987326f, -0.005f, 0.158629f },
  { -0.560882f, -0.827702f, 0.017882f }, { -0.520135f, -0.853266f, 0.037389f },
  { -0.496189f, 0.858934f, 0.126602f }, { -0.485319f, 0.865294f, 0.125425f },
  { 0.497803f, 0.866577f, 0.035159f }, { 0.509239f, 0.859945f, 0.034197f },
  { 0.51433f, -0.853448f, -0.084203f }, { 0.534213f, -0.843115f, -0.061427f },
  { 0.995773f, 0.088987f, -0.022752f }, { 0.99869f, 0.015943f, -0.048631f },
  { -0.996515f, -0.007286f, 0.083096f }, { -0.853914f, 0.015183f, -0.520193f },
  { -0.486812f, 0.873495f, 0.004464f }, { -0.486712f, -0.871653f, -0.057728f },
  { -0.478983f, -0.637285f, -0.603692f }, { -0.478867f, 0.671442f, -0.565555f },
  { -0.142062f, 0.021163f, -0.989632f }, { -0.129361f, 0.027601f, -0.991213f },
  { -0.127531f, 0.022219f, -0.991586f }, { -0.127493f, 0.010928f, -0.991779f },
  { -0.126897f, 0.030423f, -0.991449f }, { -0.120814f, 0.025565f, -0.992346f },
  { 0.261279f, -0.630035f, -0.731293f }, { 0.26258f, 0.669044f, -0.695293f },
  { 0.47776f, -0.837795f, -0.26428f }, { 0.487497f, 0.848419f, -0.206233f },
  { 0.631201f, 0.01908f, -0.775385f }, { 0.942596f, 0.003914f, -0.333911f }
};

TEST_NORMAL Multimatknight_normal_Ru_arm[27] = {
  { -0.998009f, 0.06244f, 0.008917f }, { -0.997041f, 0.074925f, 0.017213f },
  { -0.995187f, 0.078777f, -0.05828f }, { -0.849647f, -0.005834f, -0.527319f },
  { -0.757678f, 0.052462f, 0.650516f }, { -0.42584f, -0.902978f, -0.05737f },
  { -0.402295f, -0.915435f, 0.011721f }, { -0.367668f, -0.77747f, -0.510256f },
  { -0.352319f, -0.629891f, 0.692177f }, { -0.298974f, -0.949246f, -0.097711f },
  { -0.268081f, 0.954893f, -0.12772f }, { -0.219131f, 0.974958f, 0.037925f },
  { -0.191617f, 0.979848f, 0.056396f }, { -0.176539f, 0.660111f, 0.730128f },
  { -0.160623f, 0.770145f, -0.617314f }, { -0.137826f, 0.038925f, 0.989691f },
  { -0.066204f, -0.15227f, -0.986119f }, { 0.561881f, -0.461878f, 0.686264f },
  { 0.591743f, 0.384893f, 0.708306f }, { 0.607378f, -0.610527f, -0.50828f },
  { 0.754708f, 0.386986f, -0.529772f }, { 0.778378f, -0.62707f, 0.030161f },
  { 0.789476f, -0.605718f, -0.099161f }, { 0.809413f, -0.586358f, -0.03217f },
  { 0.872556f, 0.487659f, 0.028889f }, { 0.878789f, 0.469981f, 0.082753f },
  { 0.895544f, 0.443651f, -0.034274f }
};

TEST_NORMAL Multimatknight_normal_Ru_leg[18] = {
  { -0.996686f, 0.038783f, 0.071505f }, { -0.995953f, 0.074605f, 0.05011f },
  { -0.994955f, 0.039028f, 0.092419f }, { -0.59948f, -0.799431f, -0.039168f },
  { -0.535358f, 0.835233f, 0.125611f }, { -0.529378f, 0.845567f, -0.069105f },
  { -0.523727f, 0.850249f, 0.052797f }, { -0.49702f, -0.839032f, 0.22135f },
  { -0.490012f, -0.869272f, 0.065227f }, { 0.494136f, 0.84625f, -0.199224f },
  { 0.505251f, 0.854875f, -0.117937f }, { 0.538316f, 0.842743f, -0.000132f },
  { 0.561636f, -0.802824f, -0.200097f }, { 0.568885f, -0.82062f, -0.054345f },
  { 0.584662f, -0.81088f, -0.025382f }, { 0.971905f, 0.091556f, -0.216839f },
  { 0.973507f, 0.003298f, -0.228635f }, { 0.974791f, -0.023712f, -0.221857f }
};

TEST_NORMAL Multimatknight_normal_R_foot[14] = {
  { -0.82052f, 0.117382f, -0.559436f }, { -0.620806f, -0.682956f, -0.384931f },
  { -0.607545f, -0.16452f, 0.77706f }, { -0.35751f, 0.830821f, -0.426525f },
  { -0.334393f, -0.676866f, 0.65577f }, { -0.308451f, 0.589222f, 0.746777f },
  { 0.015435f, 0.005595f, -0.999865f }, { 0.461082f, -0.18653f, 0.867531f },
  { 0.461349f, -0.599002f, -0.654487f }, { 0.499983f, -0.797575f, 0.337479f },
  { 0.53138f, 0.29154f, 0.795386f }, { 0.676124f, 0.648867f, -0.349038f },
  { 0.833708f, -0.038814f, -0.55084f }, { 0.919936f, -0.037489f, 0.390273f }
};

TEST_NORMAL Multimatknight_normal_R_hand[18] = {
  { -0.765784f, -0.642478f, 0.028223f }, { -0.63242f, 0.512026f, 0.581269f },
  { -0.623153f, -0.782098f, 0.001766f }, { -0.572729f, -0.446225f, 0.687652f },
  { -0.518666f, 0.848665f, -0.103697f }, { -0.497476f, 0.642108f, -0.583279f },
  { -0.403364f, -0.477132f, -0.780796f }, { -0.335219f, -0.409469f, -0.848506f },
  { 0.216798f, -0.78789f, 0.576393f }, { 0.245768f, 0.268972f, -0.931264f },
  { 0.545399f, -0.837768f, 0.026161f }, { 0.639379f, -0.238523f, -0.73096f },
  { 0.647042f, 0.674795f, -0.354948f }, { 0.655896f, 0.725559f, 0.208242f },
  { 0.663703f, 0.577269f, -0.475667f }, { 0.679268f, -0.526816f, -0.51094f },
  { 0.684827f, 0.188741f, -0.703839f }, { 0.705667f, -0.097339f, 0.701825f }
};

TEST_NORMAL Multimatknight_normal_Torso[40] = {
  { -0.989013f, 0.033344f, -0.144018f }, { -0.850083f, 0.066353f, 0.522452f },
  { -0.843097f, 0.027979f, -0.537033f }, { -0.789478f, -0.014351f, 0.613611f },
  { -0.606318f, 0.061398f, -0.792848f }, { -0.547781f, -0.106642f, 0.829798f },
  { -0.445252f, 0.885058f, 0.13573f }, { -0.414864f, 0.82263f, -0.388803f },
  { -0.407068f, -0.9092f, -0.087466f }, { -0.385697f, 0.65932f, 0.645396f },
  { -0.382034f, -0.808885f, -0.446939f }, { -0.339944f, -0.710804f, 0.615789f },
  { -0.337552f, 0.685828f, 0.644746f }, { -0.328721f, 0.796505f, -0.507466f },
  { -0.315368f, -0.752126f, 0.578661f }, { -0.270062f, -0.697356f, 0.663898f },
  { -0.263733f, -0.73704f, -0.622267f }, { -0.24109f, 0.800822f, 0.548234f },
  { -0.063159f, 0.001663f, -0.998002f }, { -0.01426f, 0.075776f, -0.997023f },
  { 0.028437f, -0.100235f, -0.994557f }, { 0.08104f, -0.00082f, -0.996711f },
  { 0.252554f, 0.677549f, 0.690756f }, { 0.25931f, -0.705125f, 0.659968f },
  { 0.280235f, 0.808222f, -0.517924f }, { 0.283571f, -0.726018f, -0.626487f },
  { 0.311346f, 0.704313f, 0.637971f }, { 0.335031f, -0.711058f, 0.618184f },
  { 0.341153f, 0.686724f, 0.641892f }, { 0.342689f, -0.753938f, 0.560483f },
  { 0.379605f, -0.801933f, -0.461306f }, { 0.397017f, 0.838338f, -0.373585f },
  { 0.398732f, 0.917049f, 0.005863f }, { 0.419945f, -0.905005f, -0.067915f },
  { 0.559439f, -0.000794f, 0.828871f }, { 0.64026f, -0.019995f, -0.767898f },
  { 0.788558f, -0.006145f, 0.614929f }, { 0.846617f, -0.060795f, 0.528718f },
  { 0.850671f, 0.011429f, -0.525573f }, { 0.988142f, -0.011051f, -0.153147f }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Head[44] = {
  { { 0, 5, 1 }, { 4, 7, 6 }, { 4, 6, 7 }, 0 }, { { 0, 4, 5 }, { 4, 5, 7 }, { 4, 5, 6 }, 0 },
  { { 7, 3, 2 }, { 2, 3, 1 }, { 2, 3, 0 }, 0 }, { { 7, 2, 6 }, { 2, 1, 0 }, { 2, 0, 1 }, 0 },
  { { 3, 4, 0 }, { 3, 5, 4 }, { 3, 5, 4 }, 0 }, { { 7, 4, 3 }, { 2, 5, 3 }, { 2, 5, 3 }, 0 },
  { { 8, 14, 9 }, { 0, 0, 0 }, { 18, 18, 18 }, 2 }, { { 13, 14, 8 }, { 0, 0, 0 }, { 17, 17, 17 }, 2 },
  { { 9, 15, 10 }, { 0, 0, 0 }, { 14, 14, 14 }, 2 }, { { 9, 14, 15 }, { 0, 0, 0 }, { 14, 14, 14 }, 2 },
  { { 10, 16, 11 }, { 0, 0, 0 }, { 8, 8, 8 }, 2 }, { { 10, 15, 16 }, { 0, 0, 0 }, { 9, 9, 9 }, 2 },
  { { 12, 18, 13 }, { 0, 0, 0 }, { 15, 15, 15 }, 2 }, { { 13, 18, 14 }, { 0, 0, 0 }, { 16, 16, 16 }, 2 },
  { { 15, 14, 18 }, { 0, 0, 0 }, { 13, 13, 13 }, 2 }, { { 16, 15, 18 }, { 0, 0, 0 }, { 10, 10, 10 }, 2 },
  { { 18, 17, 16 }, { 0, 0, 0 }, { 11, 11, 11 }, 2 }, { { 18, 12, 17 }, { 0, 0, 0 }, { 12, 12, 12 }, 2 },
  { { 20, 21, 19 }, { 0, 0, 0 }, { 22, 22, 22 }, 1 }, { { 19, 21, 22 }, { 0, 0, 0 }, { 21, 21, 21 }, 1 },
  { { 24, 25, 20 }, { 0, 0, 0 }, { 26, 26, 26 }, 1 }, { { 20, 25, 21 }, { 0, 0, 0 }, { 26, 26, 26 }, 1 },
  { { 21, 25, 26 }, { 0, 0, 0 }, { 30, 30, 30 }, 1 }, { { 22, 21, 26 }, { 0, 0, 0 }, { 30, 30, 30 }, 1 },
  { { 22, 26, 23 }, { 0, 0, 0 }, { 32, 32, 32 }, 1 }, { { 19, 22, 23 }, { 0, 0, 0 }, { 32, 32, 32 }, 1 },
  { { 26, 25, 23 }, { 0, 0, 0 }, { 37, 37, 37 }, 1 }, { { 25, 24, 23 }, { 0, 0, 0 }, { 36, 36, 36 }, 1 },
  { { 29, 27, 28 }, { 0, 0, 0 }, { 20, 20, 20 }, 1 }, { { 30, 27, 29 }, { 0, 0, 0 }, { 19, 19, 19 }, 1 },
  { { 33, 28, 32 }, { 0, 0, 0 }, { 29, 29, 29 }, 1 }, { { 29, 28, 33 }, { 0, 0, 0 }, { 29, 29, 29 }, 1 },
  { { 31, 30, 34 }, { 0, 0, 0 }, { 28, 28, 28 }, 1 }, { { 31, 27, 30 }, { 0, 0, 0 }, { 25, 25, 25 }, 1 },
  { { 31, 34, 33 }, { 0, 0, 0 }, { 38, 38, 38 }, 1 }, { { 33, 32, 31 }, { 0, 0, 0 }, { 33, 33, 33 }, 1 },
  { { 37, 35, 36 }, { 0, 0, 0 }, { 23, 23, 23 }, 1 }, { { 38, 35, 37 }, { 0, 0, 0 }, { 24, 24, 24 }, 1 },
  { { 41, 36, 40 }, { 0, 0, 0 }, { 31, 31, 31 }, 1 }, { { 37, 36, 41 }, { 0, 0, 0 }, { 31, 31, 31 }, 1 },
  { { 39, 38, 42 }, { 0, 0, 0 }, { 27, 27, 27 }, 1 }, { { 39, 35, 38 }, { 0, 0, 0 }, { 27, 27, 27 }, 1 },
  { { 39, 42, 41 }, { 0, 0, 0 }, { 34, 34, 34 }, 1 }, { { 41, 40, 39 }, { 0, 0, 0 }, { 35, 35, 35 }, 1 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Ll_arm[30] = {
  { { 1, 6, 0 }, { 11, 4, 10 }, { 5, 2, 3 }, 3 }, { { 0, 6, 5 }, { 10, 4, 1 }, { 3, 2, 0 }, 3 },
  { { 2, 7, 1 }, { 25, 27, 13 }, { 12, 13, 5 }, 3 }, { { 1, 7, 6 }, { 13, 27, 5 }, { 5, 13, 2 }, 3 },
  { { 3, 8, 2 }, { 31, 34, 25 }, { 15, 16, 12 }, 3 }, { { 2, 8, 7 }, { 25, 34, 27 }, { 12, 16, 13 }, 3 },
  { { 4, 9, 3 }, { 23, 20, 32 }, { 9, 10, 15 }, 3 }, { { 3, 9, 8 }, { 32, 20, 35 }, { 15, 10, 16 }, 3 },
  { { 0, 5, 4 }, { 8, 0, 23 }, { 3, 0, 9 }, 3 }, { { 4, 5, 9 }, { 23, 0, 20 }, { 9, 0, 10 }, 3 },
  { { 5, 6, 11 }, { 1, 4, 6 }, { 0, 2, 4 }, 3 }, { { 5, 11, 10 }, { 1, 6, 3 }, { 0, 4, 1 }, 3 },
  { { 6, 7, 12 }, { 5, 27, 21 }, { 2, 13, 11 }, 3 }, { { 6, 12, 11 }, { 5, 21, 7 }, { 2, 11, 4 }, 3 },
  { { 7, 8, 13 }, { 27, 34, 28 }, { 13, 16, 14 }, 3 }, { { 7, 13, 12 }, { 27, 28, 21 }, { 13, 14, 11 }, 3 },
  { { 8, 9, 14 }, { 35, 20, 18 }, { 16, 10, 8 }, 3 }, { { 8, 14, 13 }, { 35, 18, 30 }, { 16, 8, 14 }, 3 },
  { { 5, 10, 9 }, { 0, 2, 20 }, { 0, 1, 10 }, 3 }, { { 14, 9, 10 }, { 18, 20, 2 }, { 8, 10, 1 }, 3 },
  { { 1, 0, 16 }, { 12, 9, 19 }, { 5, 3, 7 }, 3 }, { { 1, 16, 2 }, { 12, 19, 26 }, { 5, 7, 12 }, 3 },
  { { 2, 16, 3 }, { 26, 19, 33 }, { 12, 7, 15 }, 3 }, { { 3, 16, 4 }, { 33, 19, 24 }, { 15, 7, 9 }, 3 },
  { { 4, 16, 0 }, { 24, 19, 9 }, { 9, 7, 3 }, 3 }, { { 10, 11, 15 }, { 3, 6, 16 }, { 1, 4, 6 }, 3 },
  { { 11, 12, 15 }, { 7, 21, 17 }, { 4, 11, 6 }, 3 }, { { 12, 13, 15 }, { 22, 29, 14 }, { 11, 14, 6 }, 3 },
  { { 13, 14, 15 }, { 30, 18, 15 }, { 14, 8, 6 }, 3 }, { { 10, 15, 14 }, { 2, 15, 18 }, { 1, 6, 8 }, 3 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Ll_leg[36] = {
  { { 0, 3, 1 }, { 0, 0, 0 }, { 0, 5, 1 }, 4 }, { { 2, 3, 0 }, { 0, 0, 0 }, { 4, 5, 0 }, 4 },
  { { 2, 5, 3 }, { 0, 0, 0 }, { 4, 7, 5 }, 4 }, { { 4, 5, 2 }, { 0, 0, 0 }, { 6, 7, 4 }, 4 },
  { { 4, 7, 5 }, { 0, 0, 0 }, { 6, 10, 7 }, 4 }, { { 6, 7, 4 }, { 0, 0, 0 }, { 11, 10, 6 }, 4 },
  { { 6, 9, 7 }, { 0, 0, 0 }, { 11, 9, 10 }, 4 }, { { 8, 9, 6 }, { 0, 0, 0 }, { 8, 9, 11 }, 4 },
  { { 11, 9, 8 }, { 0, 0, 0 }, { 2, 9, 8 }, 4 }, { { 11, 8, 10 }, { 0, 0, 0 }, { 2, 8, 3 }, 4 },
  { { 11, 10, 1 }, { 0, 0, 0 }, { 2, 3, 1 }, 4 }, { { 1, 10, 0 }, { 0, 0, 0 }, { 1, 3, 0 }, 4 },
  { { 12, 16, 13 }, { 0, 0, 0 }, { 19, 16, 13 }, 5 }, { { 15, 16, 12 }, { 0, 0, 0 }, { 18, 16, 19 }, 5 },
  { { 13, 17, 14 }, { 0, 0, 0 }, { 13, 14, 12 }, 5 }, { { 13, 16, 17 }, { 0, 0, 0 }, { 13, 16, 14 }, 5 },
  { { 15, 19, 16 }, { 0, 0, 0 }, { 18, 25, 16 }, 5 }, { { 18, 19, 15 }, { 0, 0, 0 }, { 23, 25, 18 }, 5 },
  { { 17, 16, 20 }, { 0, 0, 0 }, { 14, 16, 27 }, 5 }, { { 20, 16, 19 }, { 0, 0, 0 }, { 27, 16, 25 }, 5 },
  { { 18, 22, 19 }, { 0, 0, 0 }, { 23, 28, 25 }, 5 }, { { 21, 22, 18 }, { 0, 0, 0 }, { 21, 28, 23 }, 5 },
  { { 20, 19, 23 }, { 0, 0, 0 }, { 27, 25, 29 }, 5 }, { { 23, 19, 22 }, { 0, 0, 0 }, { 29, 25, 28 }, 5 },
  { { 25, 22, 21 }, { 0, 0, 0 }, { 24, 28, 21 }, 5 }, { { 25, 21, 24 }, { 0, 0, 0 }, { 24, 21, 22 }, 5 },
  { { 23, 22, 26 }, { 0, 0, 0 }, { 29, 28, 26 }, 5 }, { { 25, 26, 22 }, { 0, 0, 0 }, { 24, 26, 28 }, 5 },
  { { 25, 24, 28 }, { 0, 0, 0 }, { 24, 22, 17 }, 5 }, { { 28, 24, 27 }, { 0, 0, 0 }, { 17, 22, 20 }, 5 },
  { { 29, 26, 25 }, { 0, 0, 0 }, { 15, 26, 24 }, 5 }, { { 25, 28, 29 }, { 0, 0, 0 }, { 24, 17, 15 }, 5 },
  { { 28, 27, 13 }, { 0, 0, 0 }, { 17, 20, 13 }, 5 }, { { 13, 27, 12 }, { 0, 0, 0 }, { 13, 20, 19 }, 5 },
  { { 29, 28, 14 }, { 0, 0, 0 }, { 15, 17, 12 }, 5 }, { { 14, 28, 13 }, { 0, 0, 0 }, { 12, 17, 13 }, 5 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Lu_arm[50] = {
  { { 1, 6, 0 }, { 9, 0, 19 }, { 6, 2, 7 }, 3 }, { { 0, 6, 5 }, { 19, 0, 7 }, { 7, 2, 3 }, 3 },
  { { 2, 7, 1 }, { 27, 34, 10 }, { 12, 15, 6 }, 3 }, { { 1, 7, 6 }, { 10, 34, 1 }, { 6, 15, 2 }, 3 },
  { { 8, 2, 3 }, { 55, 27, 45 }, { 25, 12, 23 }, 3 }, { { 8, 7, 2 }, { 55, 34, 27 }, { 25, 15, 12 }, 3 },
  { { 9, 3, 4 }, { 41, 47, 36 }, { 17, 23, 19 }, 3 }, { { 8, 3, 9 }, { 56, 47, 41 }, { 25, 23, 17 }, 3 },
  { { 0, 5, 4 }, { 18, 6, 36 }, { 7, 3, 19 }, 3 }, { { 9, 4, 5 }, { 41, 36, 6 }, { 17, 19, 3 }, 3 },
  { { 5, 6, 11 }, { 7, 0, 11 }, { 3, 2, 0 }, 3 }, { { 5, 11, 10 }, { 7, 11, 17 }, { 3, 0, 4 }, 3 },
  { { 6, 7, 12 }, { 1, 34, 33 }, { 2, 15, 16 }, 3 }, { { 6, 12, 11 }, { 1, 33, 12 }, { 2, 16, 0 }, 3 },
  { { 8, 13, 7 }, { 55, 48, 34 }, { 25, 24, 15 }, 3 }, { { 7, 13, 12 }, { 34, 48, 33 }, { 15, 24, 16 }, 3 },
  { { 8, 9, 14 }, { 56, 41, 37 }, { 25, 17, 21 }, 3 }, { { 14, 13, 8 }, { 37, 49, 56 }, { 21, 24, 25 }, 3 },
  { { 5, 10, 9 }, { 6, 16, 41 }, { 3, 4, 17 }, 3 }, { { 9, 10, 14 }, { 41, 16, 37 }, { 17, 4, 21 }, 3 },
  { { 10, 11, 16 }, { 17, 11, 2 }, { 4, 0, 1 }, 3 }, { { 10, 16, 15 }, { 17, 2, 5 }, { 4, 1, 5 }, 3 },
  { { 11, 12, 17 }, { 12, 33, 35 }, { 0, 16, 14 }, 3 }, { { 11, 17, 16 }, { 12, 35, 3 }, { 0, 14, 1 }, 3 },
  { { 12, 13, 18 }, { 33, 48, 53 }, { 16, 24, 26 }, 3 }, { { 12, 18, 17 }, { 33, 53, 35 }, { 16, 26, 14 }, 3 },
  { { 14, 19, 13 }, { 37, 42, 49 }, { 21, 20, 24 }, 3 }, { { 13, 19, 18 }, { 49, 42, 54 }, { 24, 20, 26 }, 3 },
  { { 10, 15, 14 }, { 16, 4, 37 }, { 4, 5, 21 }, 3 }, { { 14, 15, 19 }, { 37, 4, 42 }, { 21, 5, 20 }, 3 },
  { { 15, 16, 21 }, { 5, 2, 21 }, { 5, 1, 8 }, 3 }, { { 15, 21, 20 }, { 5, 21, 15 }, { 5, 8, 9 }, 3 },
  { { 16, 17, 22 }, { 3, 35, 30 }, { 1, 14, 13 }, 3 }, { { 16, 22, 21 }, { 3, 30, 22 }, { 1, 13, 8 }, 3 },
  { { 17, 18, 23 }, { 35, 53, 50 }, { 14, 26, 22 }, 3 }, { { 17, 23, 22 }, { 35, 50, 30 }, { 14, 22, 13 }, 3 },
  { { 18, 19, 24 }, { 54, 42, 40 }, { 26, 20, 18 }, 3 }, { { 18, 24, 23 }, { 54, 40, 52 }, { 26, 18, 22 }, 3 },
  { { 15, 20, 19 }, { 4, 14, 42 }, { 5, 9, 20 }, 3 }, { { 19, 20, 24 }, { 42, 14, 40 }, { 20, 9, 18 }, 3 },
  { { 1, 0, 26 }, { 9, 19, 26 }, { 6, 7, 10 }, 3 }, { { 1, 26, 2 }, { 8, 25, 28 }, { 6, 10, 12 }, 3 },
  { { 2, 26, 3 }, { 29, 23, 46 }, { 12, 10, 23 }, 3 }, { { 3, 26, 4 }, { 47, 24, 36 }, { 23, 10, 19 }, 3 },
  { { 4, 26, 0 }, { 36, 24, 18 }, { 19, 10, 7 }, 3 }, { { 20, 21, 25 }, { 13, 20, 44 }, { 9, 8, 11 }, 3 },
  { { 21, 22, 25 }, { 20, 31, 44 }, { 8, 13, 11 }, 3 }, { { 22, 23, 25 }, { 32, 51, 43 }, { 13, 22, 11 }, 3 },
  { { 23, 24, 25 }, { 51, 38, 43 }, { 22, 18, 11 }, 3 }, { { 20, 25, 24 }, { 13, 44, 39 }, { 9, 11, 18 }, 3 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Lu_leg[24] = {
  { { 1, 5, 2 }, { 0, 0, 0 }, { 2, 6, 1 }, 4 }, { { 4, 5, 1 }, { 0, 0, 0 }, { 8, 6, 2 }, 4 },
  { { 2, 3, 0 }, { 0, 0, 0 }, { 1, 4, 0 }, 4 }, { { 2, 5, 3 }, { 0, 0, 0 }, { 1, 6, 4 }, 4 },
  { { 4, 8, 5 }, { 0, 0, 0 }, { 8, 10, 6 }, 4 }, { { 7, 8, 4 }, { 0, 0, 0 }, { 11, 10, 8 }, 4 },
  { { 3, 5, 6 }, { 0, 0, 0 }, { 4, 6, 9 }, 4 }, { { 5, 8, 6 }, { 0, 0, 0 }, { 6, 10, 9 }, 4 },
  { { 7, 11, 8 }, { 0, 0, 0 }, { 11, 17, 10 }, 4 }, { { 10, 11, 7 }, { 0, 0, 0 }, { 15, 17, 11 }, 4 },
  { { 6, 8, 9 }, { 0, 0, 0 }, { 9, 10, 16 }, 4 }, { { 9, 8, 11 }, { 0, 0, 0 }, { 16, 10, 17 }, 4 },
  { { 10, 14, 11 }, { 0, 0, 0 }, { 15, 13, 17 }, 4 }, { { 13, 14, 10 }, { 0, 0, 0 }, { 14, 13, 15 }, 4 },
  { { 9, 11, 12 }, { 0, 0, 0 }, { 16, 17, 12 }, 4 }, { { 12, 11, 14 }, { 0, 0, 0 }, { 12, 17, 13 }, 4 },
  { { 17, 14, 13 }, { 0, 0, 0 }, { 7, 13, 14 }, 4 }, { { 17, 13, 16 }, { 0, 0, 0 }, { 7, 14, 3 }, 4 },
  { { 12, 14, 15 }, { 0, 0, 0 }, { 12, 13, 5 }, 4 }, { { 17, 15, 14 }, { 0, 0, 0 }, { 7, 5, 13 }, 4 },
  { { 17, 16, 2 }, { 0, 0, 0 }, { 7, 3, 1 }, 4 }, { { 2, 16, 1 }, { 0, 0, 0 }, { 1, 3, 2 }, 4 },
  { { 15, 17, 0 }, { 0, 0, 0 }, { 5, 7, 0 }, 4 }, { { 0, 17, 2 }, { 0, 0, 0 }, { 0, 7, 1 }, 4 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_L_fingers[24] = {
  { { 1, 0, 6 }, { 0, 5, 6 }, { 0, 6, 5 }, 6 }, { { 1, 6, 2 }, { 0, 6, 1 }, { 0, 5, 4 }, 6 },
  { { 3, 2, 6 }, { 2, 1, 6 }, { 3, 4, 5 }, 6 }, { { 3, 6, 4 }, { 2, 6, 4 }, { 3, 5, 1 }, 6 },
  { { 5, 4, 6 }, { 3, 4, 6 }, { 2, 1, 5 }, 6 }, { { 0, 5, 6 }, { 5, 3, 6 }, { 6, 2, 5 }, 6 },
  { { 7, 14, 8 }, { 0, 0, 0 }, { 16, 16, 16 }, 7 }, { { 14, 7, 13 }, { 0, 0, 0 }, { 22, 22, 22 }, 7 },
  { { 8, 15, 9 }, { 0, 0, 0 }, { 15, 15, 15 }, 7 }, { { 8, 14, 15 }, { 0, 0, 0 }, { 17, 17, 17 }, 7 },
  { { 9, 16, 10 }, { 0, 0, 0 }, { 21, 21, 21 }, 7 }, { { 9, 15, 16 }, { 0, 0, 0 }, { 14, 14, 14 }, 7 },
  { { 10, 17, 11 }, { 0, 0, 0 }, { 19, 19, 19 }, 7 }, { { 10, 16, 17 }, { 0, 0, 0 }, { 13, 13, 13 }, 7 },
  { { 11, 18, 12 }, { 0, 0, 0 }, { 20, 20, 20 }, 7 }, { { 11, 17, 18 }, { 0, 0, 0 }, { 20, 20, 20 }, 7 },
  { { 13, 7, 12 }, { 0, 0, 0 }, { 23, 23, 23 }, 7 }, { { 13, 12, 18 }, { 0, 0, 0 }, { 18, 18, 18 }, 7 },
  { { 7, 8, 19 }, { 0, 0, 0 }, { 11, 11, 11 }, 7 }, { { 19, 8, 9 }, { 0, 0, 0 }, { 10, 10, 10 }, 7 },
  { { 9, 10, 19 }, { 0, 0, 0 }, { 7, 7, 7 }, 7 }, { { 10, 11, 19 }, { 0, 0, 0 }, { 9, 9, 9 }, 7 },
  { { 11, 12, 19 }, { 0, 0, 0 }, { 8, 8, 8 }, 7 }, { { 12, 7, 19 }, { 0, 0, 0 }, { 12, 12, 12 }, 7 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_L_foot[24] = {
  { { 7, 1, 0 }, { 0, 0, 0 }, { 0, 1, 2 }, 5 }, { { 7, 0, 6 }, { 0, 0, 0 }, { 0, 2, 3 }, 5 },
  { { 8, 2, 1 }, { 0, 0, 0 }, { 4, 5, 1 }, 5 }, { { 8, 1, 7 }, { 0, 0, 0 }, { 4, 1, 0 }, 5 },
  { { 2, 9, 3 }, { 0, 0, 0 }, { 5, 9, 12 }, 5 }, { { 8, 9, 2 }, { 0, 0, 0 }, { 4, 9, 5 }, 5 },
  { { 3, 10, 4 }, { 0, 0, 0 }, { 12, 11, 13 }, 5 }, { { 3, 9, 10 }, { 0, 0, 0 }, { 12, 9, 11 }, 5 },
  { { 4, 11, 5 }, { 0, 0, 0 }, { 13, 8, 10 }, 5 }, { { 4, 10, 11 }, { 0, 0, 0 }, { 13, 11, 8 }, 5 },
  { { 6, 0, 5 }, { 0, 0, 0 }, { 3, 2, 10 }, 5 }, { { 6, 5, 11 }, { 0, 0, 0 }, { 3, 10, 8 }, 5 },
  { { 0, 1, 13 }, { 0, 0, 0 }, { 2, 1, 7 }, 5 }, { { 1, 2, 13 }, { 0, 0, 0 }, { 1, 5, 7 }, 5 },
  { { 2, 3, 13 }, { 0, 0, 0 }, { 5, 12, 7 }, 5 }, { { 3, 4, 13 }, { 0, 0, 0 }, { 12, 13, 7 }, 5 },
  { { 4, 5, 13 }, { 0, 0, 0 }, { 13, 10, 7 }, 5 }, { { 5, 0, 13 }, { 0, 0, 0 }, { 10, 2, 7 }, 5 },
  { { 7, 6, 12 }, { 0, 0, 0 }, { 0, 3, 6 }, 5 }, { { 8, 7, 12 }, { 0, 0, 0 }, { 4, 0, 6 }, 5 },
  { { 8, 12, 9 }, { 0, 0, 0 }, { 4, 6, 9 }, 5 }, { { 9, 12, 10 }, { 0, 0, 0 }, { 9, 6, 11 }, 5 },
  { { 11, 10, 12 }, { 0, 0, 0 }, { 8, 11, 6 }, 5 }, { { 6, 11, 12 }, { 0, 0, 0 }, { 3, 8, 6 }, 5 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_L_hand[32] = {
  { { 5, 1, 0 }, { 47, 35, 30 }, { 13, 12, 11 }, 8 }, { { 5, 0, 4 }, { 47, 30, 44 }, { 13, 11, 17 }, 8 },
  { { 1, 6, 2 }, { 33, 12, 17 }, { 12, 5, 4 }, 8 }, { { 5, 6, 1 }, { 46, 12, 33 }, { 13, 5, 12 }, 8 },
  { { 2, 7, 3 }, { 16, 26, 15 }, { 4, 3, 2 }, 8 }, { { 2, 6, 7 }, { 16, 11, 26 }, { 4, 5, 3 }, 8 },
  { { 4, 0, 3 }, { 45, 31, 13 }, { 17, 11, 2 }, 8 }, { { 4, 3, 7 }, { 45, 13, 24 }, { 17, 2, 3 }, 8 },
  { { 5, 4, 9 }, { 47, 44, 42 }, { 13, 17, 16 }, 8 }, { { 9, 4, 8 }, { 41, 45, 20 }, { 16, 17, 10 }, 8 },
  { { 10, 6, 5 }, { 5, 12, 46 }, { 1, 5, 13 }, 8 }, { { 10, 5, 9 }, { 5, 46, 39 }, { 1, 13, 16 }, 8 },
  { { 7, 6, 11 }, { 25, 12, 7 }, { 3, 5, 6 }, 8 }, { { 10, 11, 6 }, { 5, 7, 12 }, { 1, 6, 5 }, 8 },
  { { 4, 7, 8 }, { 43, 25, 21 }, { 17, 3, 10 }, 8 }, { { 8, 7, 11 }, { 21, 25, 7 }, { 10, 3, 6 }, 8 },
  { { 9, 8, 13 }, { 42, 19, 36 }, { 16, 10, 14 }, 8 }, { { 13, 8, 12 }, { 36, 19, 22 }, { 14, 10, 15 }, 8 },
  { { 10, 9, 14 }, { 5, 39, 3 }, { 1, 16, 0 }, 8 }, { { 14, 9, 13 }, { 0, 40, 37 }, { 0, 16, 14 }, 8 },
  { { 15, 11, 10 }, { 10, 8, 4 }, { 7, 6, 1 }, 8 }, { { 15, 10, 14 }, { 10, 4, 2 }, { 7, 1, 0 }, 8 },
  { { 8, 11, 12 }, { 20, 6, 23 }, { 10, 6, 15 }, 8 }, { { 15, 12, 11 }, { 9, 23, 6 }, { 7, 15, 6 }, 8 },
  { { 0, 1, 17 }, { 32, 34, 29 }, { 11, 12, 9 }, 8 }, { { 1, 2, 17 }, { 33, 17, 28 }, { 12, 4, 9 }, 8 },
  { { 2, 3, 17 }, { 16, 15, 27 }, { 4, 2, 9 }, 8 }, { { 3, 0, 17 }, { 14, 32, 29 }, { 2, 11, 9 }, 8 },
  { { 13, 12, 16 }, { 38, 23, 18 }, { 14, 15, 8 }, 8 }, { { 14, 13, 16 }, { 1, 38, 18 }, { 0, 14, 8 }, 8 },
  { { 15, 14, 16 }, { 9, 1, 18 }, { 7, 0, 8 }, 8 }, { { 12, 15, 16 }, { 23, 9, 18 }, { 15, 7, 8 }, 8 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Obj[80] = {
  { { 0, 1, 2 }, { 0, 0, 0 }, { 1, 1, 1 }, 2 }, { { 0, 2, 3 }, { 0, 0, 0 }, { 0, 0, 0 }, 2 },
  { { 1, 0, 5 }, { 0, 0, 0 }, { 4, 4, 4 }, 2 }, { { 5, 0, 4 }, { 0, 0, 0 }, { 5, 5, 5 }, 2 },
  { { 3, 2, 7 }, { 0, 0, 0 }, { 3, 3, 3 }, 2 }, { { 7, 2, 6 }, { 0, 0, 0 }, { 2, 2, 2 }, 2 },
  { { 5, 4, 6 }, { 0, 0, 0 }, { 7, 7, 7 }, 2 }, { { 6, 4, 7 }, { 0, 0, 0 }, { 6, 6, 6 }, 2 },
  { { 22, 20, 21 }, { 0, 0, 0 }, { 9, 9, 9 }, 1 }, { { 22, 19, 20 }, { 0, 0, 0 }, { 17, 17, 17 }, 1 },
  { { 14, 15, 13 }, { 0, 0, 0 }, { 21, 21, 21 }, 1 }, { { 13, 15, 16 }, { 0, 0, 0 }, { 10, 10, 10 }, 1 },
  { { 13, 16, 17 }, { 0, 0, 0 }, { 16, 16, 16 }, 1 }, { { 13, 17, 12 }, { 0, 0, 0 }, { 13, 13, 13 }, 1 },
  { { 22, 18, 19 }, { 0, 0, 0 }, { 11, 11, 11 }, 1 }, { { 23, 18, 22 }, { 0, 0, 0 }, { 12, 12, 12 }, 1 },
  { { 12, 17, 18 }, { 0, 0, 0 }, { 15, 15, 15 }, 1 }, { { 12, 18, 23 }, { 0, 0, 0 }, { 14, 14, 14 }, 1 },
  { { 10, 11, 9 }, { 0, 0, 0 }, { 8, 8, 8 }, 1 }, { { 9, 11, 24 }, { 0, 0, 0 }, { 20, 20, 20 }, 1 },
  { { 9, 24, 25 }, { 0, 0, 0 }, { 18, 18, 18 }, 1 }, { { 9, 25, 8 }, { 0, 0, 0 }, { 19, 19, 19 }, 1 },
  { { 9, 8, 27 }, { 0, 0, 0 }, { 34, 34, 34 }, 1 }, { { 27, 8, 26 }, { 0, 0, 0 }, { 34, 34, 34 }, 1 },
  { { 10, 9, 28 }, { 0, 0, 0 }, { 45, 45, 45 }, 1 }, { { 28, 9, 27 }, { 0, 0, 0 }, { 46, 46, 46 }, 1 },
  { { 11, 10, 29 }, { 0, 0, 0 }, { 41, 41, 41 }, 1 }, { { 29, 10, 28 }, { 0, 0, 0 }, { 40, 40, 40 }, 1 },
  { { 13, 12, 31 }, { 0, 0, 0 }, { 35, 35, 35 }, 1 }, { { 31, 12, 30 }, { 0, 0, 0 }, { 36, 36, 36 }, 1 },
  { { 14, 13, 32 }, { 0, 0, 0 }, { 44, 44, 44 }, 1 }, { { 32, 13, 31 }, { 0, 0, 0 }, { 43, 43, 43 }, 1 },
  { { 15, 14, 33 }, { 0, 0, 0 }, { 39, 39, 39 }, 1 }, { { 33, 14, 32 }, { 0, 0, 0 }, { 42, 42, 42 }, 1 },
  { { 16, 15, 34 }, { 0, 0, 0 }, { 29, 29, 29 }, 1 }, { { 34, 15, 33 }, { 0, 0, 0 }, { 30, 30, 30 }, 1 },
  { { 17, 16, 35 }, { 0, 0, 0 }, { 33, 33, 33 }, 1 }, { { 35, 16, 34 }, { 0, 0, 0 }, { 33, 33, 33 }, 1 },
  { { 19, 18, 37 }, { 0, 0, 0 }, { 33, 33, 33 }, 1 }, { { 37, 18, 36 }, { 0, 0, 0 }, { 33, 33, 33 }, 1 },
  { { 20, 19, 38 }, { 0, 0, 0 }, { 37, 37, 37 }, 1 }, { { 38, 19, 37 }, { 0, 0, 0 }, { 38, 38, 38 }, 1 },
  { { 21, 20, 39 }, { 0, 0, 0 }, { 25, 25, 25 }, 1 }, { { 39, 20, 38 }, { 0, 0, 0 }, { 28, 28, 28 }, 1 },
  { { 22, 21, 40 }, { 0, 0, 0 }, { 24, 24, 24 }, 1 }, { { 40, 21, 39 }, { 0, 0, 0 }, { 23, 23, 23 }, 1 },
  { { 23, 22, 41 }, { 0, 0, 0 }, { 32, 32, 32 }, 1 }, { { 41, 22, 40 }, { 0, 0, 0 }, { 31, 31, 31 }, 1 },
  { { 25, 24, 43 }, { 0, 0, 0 }, { 26, 26, 26 }, 1 }, { { 43, 24, 42 }, { 0, 0, 0 }, { 27, 27, 27 }, 1 },
  { { 8, 25, 26 }, { 0, 0, 0 }, { 22, 22, 22 }, 1 }, { { 26, 25, 43 }, { 0, 0, 0 }, { 22, 22, 22 }, 1 },
  { { 39, 38, 40 }, { 0, 0, 0 }, { 58, 58, 58 }, 1 }, { { 38, 37, 40 }, { 0, 0, 0 }, { 49, 49, 49 }, 1 },
  { { 32, 31, 33 }, { 0, 0, 0 }, { 57, 57, 57 }, 1 }, { { 33, 31, 34 }, { 0, 0, 0 }, { 50, 50, 50 }, 1 },
  { { 34, 31, 35 }, { 0, 0, 0 }, { 54, 54, 54 }, 1 }, { { 31, 30, 35 }, { 0, 0, 0 }, { 55, 55, 55 }, 1 },
  { { 37, 36, 40 }, { 0, 0, 0 }, { 56, 56, 56 }, 1 }, { { 40, 36, 41 }, { 0, 0, 0 }, { 53, 53, 53 }, 1 },
  { { 35, 30, 36 }, { 0, 0, 0 }, { 52, 52, 52 }, 1 }, { { 36, 30, 41 }, { 0, 0, 0 }, { 51, 51, 51 }, 1 },
  { { 28, 27, 29 }, { 0, 0, 0 }, { 47, 47, 47 }, 1 }, { { 29, 27, 42 }, { 0, 0, 0 }, { 59, 59, 59 }, 1 },
  { { 42, 27, 43 }, { 0, 0, 0 }, { 48, 48, 48 }, 1 }, { { 43, 27, 26 }, { 0, 0, 0 }, { 60, 60, 60 }, 1 },
  { { 45, 46, 47 }, { 0, 0, 0 }, { 61, 61, 61 }, 7 }, { { 45, 47, 44 }, { 0, 0, 0 }, { 61, 61, 61 }, 7 },
  { { 44, 47, 48 }, { 0, 0, 0 }, { 61, 61, 61 }, 7 }, { { 45, 44, 50 }, { 0, 0, 0 }, { 67, 67, 67 }, 7 },
  { { 50, 44, 49 }, { 0, 0, 0 }, { 67, 67, 67 }, 7 }, { { 51, 46, 45 }, { 0, 0, 0 }, { 65, 65, 65 }, 7 },
  { { 51, 45, 50 }, { 0, 0, 0 }, { 66, 66, 66 }, 7 }, { { 47, 46, 52 }, { 0, 0, 0 }, { 63, 63, 63 }, 7 },
  { { 52, 46, 51 }, { 0, 0, 0 }, { 64, 64, 64 }, 7 }, { { 48, 47, 53 }, { 0, 0, 0 }, { 62, 62, 62 }, 7 },
  { { 53, 47, 52 }, { 0, 0, 0 }, { 62, 62, 62 }, 7 }, { { 51, 50, 52 }, { 0, 0, 0 }, { 68, 68, 68 }, 7 },
  { { 50, 49, 52 }, { 0, 0, 0 }, { 68, 68, 68 }, 7 }, { { 53, 52, 49 }, { 0, 0, 0 }, { 68, 68, 68 }, 7 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Pelvis[36] = {
  { { 0, 3, 1 }, { 1, 7, 3 }, { 0, 5, 1 }, 9 }, { { 2, 3, 0 }, { 5, 7, 1 }, { 2, 5, 0 }, 9 },
  { { 2, 5, 3 }, { 5, 9, 7 }, { 2, 6, 5 }, 9 }, { { 4, 5, 2 }, { 11, 9, 5 }, { 8, 6, 2 }, 9 },
  { { 4, 7, 5 }, { 11, 14, 9 }, { 8, 10, 6 }, 9 }, { { 6, 7, 4 }, { 12, 14, 11 }, { 11, 10, 8 }, 9 },
  { { 6, 9, 7 }, { 13, 8, 15 }, { 11, 7, 10 }, 9 }, { { 8, 9, 6 }, { 10, 8, 13 }, { 9, 7, 11 }, 9 },
  { { 11, 9, 8 }, { 6, 8, 10 }, { 4, 7, 9 }, 9 }, { { 11, 8, 10 }, { 6, 10, 4 }, { 4, 9, 3 }, 9 },
  { { 11, 10, 1 }, { 6, 4, 2 }, { 4, 3, 1 }, 9 }, { { 1, 10, 0 }, { 2, 4, 0 }, { 1, 3, 0 }, 9 },
  { { 12, 16, 13 }, { 16, 22, 17 }, { 12, 16, 13 }, 3 }, { { 15, 16, 12 }, { 19, 22, 16 }, { 15, 16, 12 }, 3 },
  { { 13, 17, 14 }, { 17, 24, 20 }, { 13, 18, 14 }, 3 }, { { 13, 16, 17 }, { 17, 22, 24 }, { 13, 16, 18 }, 3 },
  { { 15, 19, 16 }, { 19, 28, 22 }, { 15, 24, 16 }, 3 }, { { 18, 19, 15 }, { 30, 28, 19 }, { 26, 24, 15 }, 3 },
  { { 17, 16, 20 }, { 24, 22, 26 }, { 18, 16, 22 }, 3 }, { { 20, 16, 19 }, { 26, 22, 28 }, { 22, 16, 24 }, 3 },
  { { 18, 22, 19 }, { 30, 32, 28 }, { 26, 28, 24 }, 3 }, { { 21, 22, 18 }, { 33, 32, 30 }, { 29, 28, 26 }, 3 },
  { { 20, 19, 23 }, { 26, 28, 29 }, { 22, 24, 27 }, 3 }, { { 23, 19, 22 }, { 29, 28, 32 }, { 27, 24, 28 }, 3 },
  { { 21, 25, 22 }, { 33, 27, 32 }, { 29, 23, 28 }, 3 }, { { 24, 25, 21 }, { 31, 27, 33 }, { 25, 23, 29 }, 3 },
  { { 23, 22, 26 }, { 29, 32, 25 }, { 27, 28, 21 }, 3 }, { { 26, 22, 25 }, { 25, 32, 27 }, { 21, 28, 23 }, 3 },
  { { 24, 28, 25 }, { 31, 21, 27 }, { 25, 17, 23 }, 3 }, { { 27, 28, 24 }, { 18, 21, 31 }, { 19, 17, 25 }, 3 },
  { { 26, 25, 29 }, { 25, 27, 23 }, { 21, 23, 20 }, 3 }, { { 29, 25, 28 }, { 23, 27, 21 }, { 20, 23, 17 }, 3 },
  { { 28, 27, 13 }, { 21, 18, 17 }, { 17, 19, 13 }, 3 }, { { 13, 27, 12 }, { 17, 18, 16 }, { 13, 19, 12 }, 3 },
  { { 29, 28, 14 }, { 23, 21, 20 }, { 20, 17, 14 }, 3 }, { { 14, 28, 13 }, { 20, 21, 17 }, { 14, 17, 13 }, 3 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Rl_arm[30] = {
  { { 6, 1, 0 }, { 31, 24, 25 }, { 14, 11, 12 }, 3 }, { { 6, 0, 5 }, { 31, 25, 34 }, { 14, 12, 16 }, 3 },
  { { 7, 2, 1 }, { 10, 9, 22 }, { 3, 4, 11 }, 3 }, { { 7, 1, 6 }, { 10, 22, 30 }, { 3, 11, 14 }, 3 },
  { { 8, 3, 2 }, { 1, 4, 9 }, { 0, 1, 4 }, 3 }, { { 8, 2, 7 }, { 1, 9, 10 }, { 0, 4, 3 }, 3 },
  { { 9, 4, 3 }, { 15, 11, 2 }, { 6, 7, 1 }, 3 }, { { 9, 3, 8 }, { 15, 2, 0 }, { 6, 1, 0 }, 3 },
  { { 5, 0, 4 }, { 35, 26, 11 }, { 16, 12, 7 }, 3 }, { { 5, 4, 9 }, { 35, 11, 15 }, { 16, 7, 6 }, 3 },
  { { 6, 5, 11 }, { 31, 34, 29 }, { 14, 16, 13 }, 3 }, { { 11, 5, 10 }, { 29, 34, 32 }, { 13, 16, 15 }, 3 },
  { { 7, 6, 12 }, { 10, 30, 14 }, { 3, 14, 5 }, 3 }, { { 12, 6, 11 }, { 14, 30, 28 }, { 5, 14, 13 }, 3 },
  { { 8, 7, 13 }, { 1, 10, 7 }, { 0, 3, 2 }, 3 }, { { 7, 12, 13 }, { 10, 14, 7 }, { 3, 5, 2 }, 3 },
  { { 9, 8, 14 }, { 15, 0, 17 }, { 6, 0, 8 }, 3 }, { { 14, 8, 13 }, { 17, 0, 6 }, { 8, 0, 2 }, 3 },
  { { 5, 9, 10 }, { 35, 15, 33 }, { 16, 6, 15 }, 3 }, { { 10, 9, 14 }, { 33, 15, 17 }, { 15, 6, 8 }, 3 },
  { { 0, 1, 16 }, { 27, 23, 16 }, { 12, 11, 9 }, 3 }, { { 1, 2, 16 }, { 23, 8, 16 }, { 11, 4, 9 }, 3 },
  { { 2, 3, 16 }, { 8, 3, 16 }, { 4, 1, 9 }, 3 }, { { 3, 4, 16 }, { 3, 12, 16 }, { 1, 7, 9 }, 3 },
  { { 4, 0, 16 }, { 12, 27, 16 }, { 7, 12, 9 }, 3 }, { { 11, 10, 15 }, { 29, 32, 19 }, { 13, 15, 10 }, 3 },
  { { 12, 11, 15 }, { 14, 28, 18 }, { 5, 13, 10 }, 3 }, { { 13, 12, 15 }, { 5, 13, 20 }, { 2, 5, 10 }, 3 },
  { { 14, 13, 15 }, { 17, 6, 21 }, { 8, 2, 10 }, 3 }, { { 15, 10, 14 }, { 21, 33, 17 }, { 10, 15, 8 }, 3 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Rl_leg[36] = {
  { { 0, 3, 1 }, { 0, 0, 0 }, { 1, 4, 0 }, 4 }, { { 2, 3, 0 }, { 0, 0, 0 }, { 5, 4, 1 }, 4 },
  { { 2, 5, 3 }, { 0, 0, 0 }, { 5, 6, 4 }, 4 }, { { 4, 5, 2 }, { 0, 0, 0 }, { 7, 6, 5 }, 4 },
  { { 4, 7, 5 }, { 0, 0, 0 }, { 7, 10, 6 }, 4 }, { { 6, 7, 4 }, { 0, 0, 0 }, { 11, 10, 7 }, 4 },
  { { 6, 9, 7 }, { 0, 0, 0 }, { 11, 9, 10 }, 4 }, { { 8, 9, 6 }, { 0, 0, 0 }, { 8, 9, 11 }, 4 },
  { { 11, 9, 8 }, { 0, 0, 0 }, { 2, 9, 8 }, 4 }, { { 11, 8, 10 }, { 0, 0, 0 }, { 2, 8, 3 }, 4 },
  { { 11, 10, 1 }, { 0, 0, 0 }, { 2, 3, 0 }, 4 }, { { 1, 10, 0 }, { 0, 0, 0 }, { 0, 3, 1 }, 4 },
  { { 12, 16, 13 }, { 0, 0, 0 }, { 22, 17, 13 }, 5 }, { { 15, 16, 12 }, { 0, 0, 0 }, { 19, 17, 22 }, 5 },
  { { 13, 17, 14 }, { 0, 0, 0 }, { 13, 14, 12 }, 5 }, { { 13, 16, 17 }, { 0, 0, 0 }, { 13, 17, 14 }, 5 },
  { { 15, 19, 16 }, { 0, 0, 0 }, { 19, 25, 17 }, 5 }, { { 18, 19, 15 }, { 0, 0, 0 }, { 18, 25, 19 }, 5 },
  { { 17, 16, 20 }, { 0, 0, 0 }, { 14, 17, 27 }, 5 }, { { 20, 16, 19 }, { 0, 0, 0 }, { 27, 17, 25 }, 5 },
  { { 18, 22, 19 }, { 0, 0, 0 }, { 18, 28, 25 }, 5 }, { { 21, 22, 18 }, { 0, 0, 0 }, { 21, 28, 18 }, 5 },
  { { 20, 19, 23 }, { 0, 0, 0 }, { 27, 25, 29 }, 5 }, { { 23, 19, 22 }, { 0, 0, 0 }, { 29, 25, 28 }, 5 },
  { { 25, 22, 21 }, { 0, 0, 0 }, { 24, 28, 21 }, 5 }, { { 25, 21, 24 }, { 0, 0, 0 }, { 24, 21, 23 }, 5 },
  { { 23, 22, 26 }, { 0, 0, 0 }, { 29, 28, 26 }, 5 }, { { 25, 26, 22 }, { 0, 0, 0 }, { 24, 26, 28 }, 5 },
  { { 25, 24, 28 }, { 0, 0, 0 }, { 24, 23, 16 }, 5 }, { { 28, 24, 27 }, { 0, 0, 0 }, { 16, 23, 20 }, 5 },
  { { 29, 26, 25 }, { 0, 0, 0 }, { 15, 26, 24 }, 5 }, { { 25, 28, 29 }, { 0, 0, 0 }, { 24, 16, 15 }, 5 },
  { { 28, 27, 13 }, { 0, 0, 0 }, { 16, 20, 13 }, 5 }, { { 13, 27, 12 }, { 0, 0, 0 }, { 13, 20, 22 }, 5 },
  { { 29, 28, 14 }, { 0, 0, 0 }, { 15, 16, 12 }, 5 }, { { 14, 28, 13 }, { 0, 0, 0 }, { 12, 16, 13 }, 5 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Ru_arm[50] = {
  { { 6, 1, 0 }, { 54, 44, 41 }, { 24, 20, 19 }, 3 }, { { 6, 0, 5 }, { 54, 41, 47 }, { 24, 19, 23 }, 3 },
  { { 7, 2, 1 }, { 26, 28, 43 }, { 11, 14, 20 }, 3 }, { { 7, 1, 6 }, { 26, 43, 53 }, { 11, 20, 24 }, 3 },
  { { 2, 8, 3 }, { 28, 1, 11 }, { 14, 1, 3 }, 3 }, { { 7, 8, 2 }, { 26, 1, 28 }, { 11, 1, 14 }, 3 },
  { { 3, 9, 4 }, { 9, 15, 20 }, { 3, 9, 7 }, 3 }, { { 3, 8, 9 }, { 9, 0, 15 }, { 3, 1, 9 }, 3 },
  { { 5, 0, 4 }, { 48, 42, 20 }, { 23, 19, 7 }, 3 }, { { 5, 4, 9 }, { 48, 20, 15 }, { 23, 7, 9 }, 3 },
  { { 6, 5, 11 }, { 54, 47, 46 }, { 24, 23, 26 }, 3 }, { { 11, 5, 10 }, { 46, 47, 36 }, { 26, 23, 22 }, 3 },
  { { 7, 6, 12 }, { 26, 53, 25 }, { 11, 24, 10 }, 3 }, { { 6, 11, 12 }, { 53, 45, 25 }, { 24, 26, 10 }, 3 },
  { { 13, 8, 7 }, { 5, 1, 26 }, { 2, 1, 11 }, 3 }, { { 13, 7, 12 }, { 5, 26, 25 }, { 2, 11, 10 }, 3 },
  { { 9, 8, 14 }, { 15, 0, 16 }, { 9, 1, 5 }, 3 }, { { 13, 14, 8 }, { 4, 16, 0 }, { 2, 5, 1 }, 3 },
  { { 5, 9, 10 }, { 48, 15, 37 }, { 23, 9, 22 }, 3 }, { { 10, 9, 14 }, { 37, 15, 16 }, { 22, 9, 5 }, 3 },
  { { 11, 10, 16 }, { 46, 36, 52 }, { 26, 22, 25 }, 3 }, { { 16, 10, 15 }, { 52, 36, 49 }, { 25, 22, 21 }, 3 },
  { { 12, 11, 17 }, { 25, 45, 21 }, { 10, 26, 12 }, 3 }, { { 17, 11, 16 }, { 21, 45, 51 }, { 12, 26, 25 }, 3 },
  { { 13, 12, 18 }, { 5, 25, 3 }, { 2, 10, 0 }, 3 }, { { 18, 12, 17 }, { 3, 25, 21 }, { 0, 10, 12 }, 3 },
  { { 19, 14, 13 }, { 14, 16, 4 }, { 6, 5, 2 }, 3 }, { { 19, 13, 18 }, { 14, 4, 2 }, { 6, 2, 0 }, 3 },
  { { 10, 14, 15 }, { 37, 16, 50 }, { 22, 5, 21 }, 3 }, { { 15, 14, 19 }, { 50, 16, 14 }, { 21, 5, 6 }, 3 },
  { { 16, 15, 21 }, { 52, 49, 39 }, { 25, 21, 18 }, 3 }, { { 21, 15, 20 }, { 39, 49, 33 }, { 18, 21, 17 }, 3 },
  { { 17, 16, 22 }, { 21, 51, 24 }, { 12, 25, 13 }, 3 }, { { 22, 16, 21 }, { 24, 51, 38 }, { 13, 25, 18 }, 3 },
  { { 18, 17, 23 }, { 3, 21, 8 }, { 0, 12, 4 }, 3 }, { { 23, 17, 22 }, { 8, 21, 24 }, { 4, 12, 13 }, 3 },
  { { 19, 18, 24 }, { 14, 2, 18 }, { 6, 0, 8 }, 3 }, { { 24, 18, 23 }, { 18, 2, 6 }, { 8, 0, 4 }, 3 },
  { { 15, 19, 20 }, { 50, 14, 35 }, { 21, 6, 17 }, 3 }, { { 20, 19, 24 }, { 35, 14, 18 }, { 17, 6, 8 }, 3 },
  { { 0, 1, 26 }, { 41, 44, 30 }, { 19, 20, 16 }, 3 }, { { 1, 2, 26 }, { 44, 29, 30 }, { 20, 14, 16 }, 3 },
  { { 2, 3, 26 }, { 27, 10, 32 }, { 14, 3, 16 }, 3 }, { { 3, 4, 26 }, { 9, 20, 31 }, { 3, 7, 16 }, 3 },
  { { 4, 0, 26 }, { 20, 42, 31 }, { 7, 19, 16 }, 3 }, { { 21, 20, 25 }, { 40, 34, 12 }, { 18, 17, 15 }, 3 },
  { { 22, 21, 25 }, { 23, 40, 12 }, { 13, 18, 15 }, 3 }, { { 23, 22, 25 }, { 7, 22, 13 }, { 4, 13, 15 }, 3 },
  { { 24, 23, 25 }, { 19, 7, 13 }, { 8, 4, 15 }, 3 }, { { 20, 24, 25 }, { 34, 17, 12 }, { 17, 8, 15 }, 3 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Ru_leg[24] = {
  { { 1, 5, 2 }, { 0, 0, 0 }, { 1, 6, 0 }, 4 }, { { 4, 5, 1 }, { 0, 0, 0 }, { 5, 6, 1 }, 4 },
  { { 2, 3, 0 }, { 0, 0, 0 }, { 0, 4, 2 }, 4 }, { { 2, 5, 3 }, { 0, 0, 0 }, { 0, 6, 4 }, 4 },
  { { 4, 8, 5 }, { 0, 0, 0 }, { 5, 10, 6 }, 4 }, { { 7, 8, 4 }, { 0, 0, 0 }, { 9, 10, 5 }, 4 },
  { { 3, 5, 6 }, { 0, 0, 0 }, { 4, 6, 11 }, 4 }, { { 6, 5, 8 }, { 0, 0, 0 }, { 11, 6, 10 }, 4 },
  { { 7, 11, 8 }, { 0, 0, 0 }, { 9, 16, 10 }, 4 }, { { 10, 11, 7 }, { 0, 0, 0 }, { 15, 16, 9 }, 4 },
  { { 6, 8, 9 }, { 0, 0, 0 }, { 11, 10, 17 }, 4 }, { { 9, 8, 11 }, { 0, 0, 0 }, { 17, 10, 16 }, 4 },
  { { 10, 14, 11 }, { 0, 0, 0 }, { 15, 13, 16 }, 4 }, { { 13, 14, 10 }, { 0, 0, 0 }, { 12, 13, 15 }, 4 },
  { { 9, 11, 12 }, { 0, 0, 0 }, { 17, 16, 14 }, 4 }, { { 11, 14, 12 }, { 0, 0, 0 }, { 16, 13, 14 }, 4 },
  { { 17, 14, 13 }, { 0, 0, 0 }, { 8, 13, 12 }, 4 }, { { 17, 13, 16 }, { 0, 0, 0 }, { 8, 12, 3 }, 4 },
  { { 12, 14, 15 }, { 0, 0, 0 }, { 14, 13, 7 }, 4 }, { { 17, 15, 14 }, { 0, 0, 0 }, { 8, 7, 13 }, 4 },
  { { 17, 16, 2 }, { 0, 0, 0 }, { 8, 3, 0 }, 4 }, { { 2, 16, 1 }, { 0, 0, 0 }, { 0, 3, 1 }, 4 },
  { { 15, 17, 0 }, { 0, 0, 0 }, { 7, 8, 2 }, 4 }, { { 0, 17, 2 }, { 0, 0, 0 }, { 2, 8, 0 }, 4 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_R_foot[24] = {
  { { 1, 7, 0 }, { 0, 0, 0 }, { 12, 13, 11 }, 5 }, { { 0, 7, 6 }, { 0, 0, 0 }, { 11, 13, 10 }, 5 },
  { { 2, 8, 1 }, { 0, 0, 0 }, { 8, 9, 12 }, 5 }, { { 1, 8, 7 }, { 0, 0, 0 }, { 12, 9, 13 }, 5 },
  { { 9, 2, 3 }, { 0, 0, 0 }, { 4, 8, 1 }, 5 }, { { 2, 9, 8 }, { 0, 0, 0 }, { 8, 4, 9 }, 5 },
  { { 10, 3, 4 }, { 0, 0, 0 }, { 2, 1, 0 }, 5 }, { { 9, 3, 10 }, { 0, 0, 0 }, { 4, 1, 2 }, 5 },
  { { 11, 4, 5 }, { 0, 0, 0 }, { 5, 0, 3 }, 5 }, { { 10, 4, 11 }, { 0, 0, 0 }, { 2, 0, 5 }, 5 },
  { { 0, 6, 5 }, { 0, 0, 0 }, { 11, 10, 3 }, 5 }, { { 5, 6, 11 }, { 0, 0, 0 }, { 3, 10, 5 }, 5 },
  { { 1, 0, 13 }, { 0, 0, 0 }, { 12, 11, 6 }, 5 }, { { 1, 13, 2 }, { 0, 0, 0 }, { 12, 6, 8 }, 5 },
  { { 2, 13, 3 }, { 0, 0, 0 }, { 8, 6, 1 }, 5 }, { { 3, 13, 4 }, { 0, 0, 0 }, { 1, 6, 0 }, 5 },
  { { 4, 13, 5 }, { 0, 0, 0 }, { 0, 6, 3 }, 5 }, { { 5, 13, 0 }, { 0, 0, 0 }, { 3, 6, 11 }, 5 },
  { { 6, 7, 12 }, { 0, 0, 0 }, { 10, 13, 7 }, 5 }, { { 7, 8, 12 }, { 0, 0, 0 }, { 13, 9, 7 }, 5 },
  { { 12, 8, 9 }, { 0, 0, 0 }, { 7, 9, 4 }, 5 }, { { 9, 10, 12 }, { 0, 0, 0 }, { 4, 2, 7 }, 5 },
  { { 10, 11, 12 }, { 0, 0, 0 }, { 2, 5, 7 }, 5 }, { { 6, 12, 11 }, { 0, 0, 0 }, { 10, 7, 5 }, 5 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_R_hand[32] = {
  { { 1, 5, 0 }, { 12, 0, 17 }, { 5, 4, 6 }, 8 }, { { 0, 5, 4 }, { 17, 0, 3 }, { 6, 4, 0 }, 8 },
  { { 6, 1, 2 }, { 31, 13, 29 }, { 14, 5, 12 }, 8 }, { { 6, 5, 1 }, { 31, 1, 13 }, { 14, 4, 5 }, 8 },
  { { 7, 2, 3 }, { 21, 30, 33 }, { 16, 12, 15 }, 8 }, { { 6, 2, 7 }, { 32, 30, 21 }, { 14, 12, 16 }, 8 },
  { { 0, 4, 3 }, { 15, 2, 34 }, { 6, 0, 15 }, 8 }, { { 3, 4, 7 }, { 34, 2, 23 }, { 15, 0, 16 }, 8 },
  { { 4, 5, 9 }, { 3, 0, 7 }, { 0, 4, 1 }, 8 }, { { 4, 9, 8 }, { 2, 6, 27 }, { 0, 1, 7 }, 8 },
  { { 6, 10, 5 }, { 31, 40, 1 }, { 14, 13, 4 }, 8 }, { { 5, 10, 9 }, { 1, 40, 8 }, { 4, 13, 1 }, 8 },
  { { 6, 7, 11 }, { 31, 22, 38 }, { 14, 16, 11 }, 8 }, { { 11, 10, 6 }, { 38, 40, 31 }, { 11, 13, 14 }, 8 },
  { { 4, 8, 7 }, { 4, 26, 22 }, { 0, 7, 16 }, 8 }, { { 7, 8, 11 }, { 22, 26, 38 }, { 16, 7, 11 }, 8 },
  { { 8, 9, 13 }, { 28, 7, 11 }, { 7, 1, 3 }, 8 }, { { 8, 13, 12 }, { 28, 11, 20 }, { 7, 3, 2 }, 8 },
  { { 9, 10, 14 }, { 8, 40, 42 }, { 1, 13, 17 }, 8 }, { { 13, 9, 14 }, { 9, 5, 44 }, { 3, 1, 17 }, 8 },
  { { 11, 15, 10 }, { 37, 35, 41 }, { 11, 10, 13 }, 8 }, { { 10, 15, 14 }, { 41, 35, 43 }, { 13, 10, 17 }, 8 },
  { { 8, 12, 11 }, { 27, 19, 39 }, { 7, 2, 11 }, 8 }, { { 11, 12, 15 }, { 39, 19, 36 }, { 11, 2, 10 }, 8 },
  { { 1, 0, 17 }, { 13, 16, 24 }, { 5, 6, 9 }, 8 }, { { 1, 17, 2 }, { 13, 24, 29 }, { 5, 9, 12 }, 8 },
  { { 2, 17, 3 }, { 30, 25, 33 }, { 12, 9, 15 }, 8 }, { { 3, 17, 0 }, { 33, 25, 14 }, { 15, 9, 6 }, 8 },
  { { 12, 13, 16 }, { 19, 10, 18 }, { 2, 3, 8 }, 8 }, { { 13, 14, 16 }, { 10, 45, 18 }, { 3, 17, 8 }, 8 },
  { { 14, 15, 16 }, { 45, 36, 18 }, { 17, 10, 8 }, 8 }, { { 12, 16, 15 }, { 19, 18, 36 }, { 2, 8, 10 }, 8 }
};
TEST_TRIANGLE4 Multimatknight_triangle4_Torso[70] = {
  { { 1, 9, 2 }, { 13, 16, 7 }, { 4, 7, 2 }, 3 }, { { 8, 9, 1 }, { 22, 16, 13 }, { 13, 7, 4 }, 3 },
  { { 2, 10, 3 }, { 7, 14, 4 }, { 2, 6, 0 }, 3 }, { { 2, 9, 10 }, { 7, 16, 14 }, { 2, 7, 6 }, 3 },
  { { 3, 11, 4 }, { 4, 11, 2 }, { 0, 9, 1 }, 3 }, { { 3, 10, 11 }, { 4, 14, 11 }, { 0, 6, 9 }, 3 },
  { { 4, 12, 5 }, { 0, 29, 17 }, { 1, 17, 5 }, 3 }, { { 4, 11, 12 }, { 2, 11, 30 }, { 1, 9, 17 }, 3 },
  { { 5, 13, 6 }, { 19, 35, 26 }, { 5, 12, 3 }, 3 }, { { 5, 12, 13 }, { 19, 30, 35 }, { 5, 17, 12 }, 3 },
  { { 6, 7, 0 }, { 24, 39, 43 }, { 3, 20, 21 }, 3 }, { { 6, 13, 7 }, { 23, 34, 38 }, { 3, 12, 20 }, 3 },
  { { 8, 15, 9 }, { 22, 63, 16 }, { 13, 31, 7 }, 3 }, { { 14, 15, 8 }, { 58, 63, 22 }, { 24, 31, 13 }, 3 },
  { { 10, 9, 16 }, { 14, 16, 64 }, { 6, 7, 32 }, 3 }, { { 16, 9, 15 }, { 64, 16, 63 }, { 32, 7, 31 }, 3 },
  { { 11, 10, 17 }, { 11, 14, 68 }, { 9, 6, 26 }, 3 }, { { 10, 16, 17 }, { 14, 64, 68 }, { 6, 32, 26 }, 3 },
  { { 12, 11, 18 }, { 30, 11, 51 }, { 17, 9, 22 }, 3 }, { { 18, 11, 17 }, { 51, 11, 68 }, { 22, 9, 26 }, 3 },
  { { 13, 12, 19 }, { 35, 30, 46 }, { 12, 17, 28 }, 3 }, { { 19, 12, 18 }, { 46, 30, 51 }, { 28, 17, 22 }, 3 },
  { { 7, 13, 19 }, { 38, 34, 48 }, { 20, 12, 28 }, 3 }, { { 14, 22, 15 }, { 58, 72, 63 }, { 24, 38, 31 }, 3 },
  { { 21, 22, 14 }, { 70, 72, 58 }, { 35, 38, 24 }, 3 }, { { 16, 15, 23 }, { 64, 63, 77 }, { 32, 31, 39 }, 3 },
  { { 23, 15, 22 }, { 77, 63, 72 }, { 39, 31, 38 }, 3 }, { { 17, 16, 24 }, { 68, 64, 74 }, { 26, 32, 37 }, 3 },
  { { 24, 16, 23 }, { 74, 64, 77 }, { 37, 32, 39 }, 3 }, { { 18, 17, 25 }, { 52, 69, 60 }, { 22, 26, 34 }, 3 },
  { { 25, 17, 24 }, { 60, 69, 75 }, { 34, 26, 37 }, 3 }, { { 19, 18, 26 }, { 46, 51, 53 }, { 28, 22, 36 }, 3 },
  { { 26, 18, 25 }, { 53, 51, 59 }, { 36, 22, 34 }, 3 }, { { 7, 19, 20 }, { 39, 47, 37 }, { 20, 28, 18 }, 3 },
  { { 20, 19, 26 }, { 36, 48, 54 }, { 18, 28, 36 }, 3 }, { { 29, 22, 21 }, { 62, 73, 71 }, { 30, 38, 35 }, 3 },
  { { 29, 21, 28 }, { 62, 71, 57 }, { 30, 35, 25 }, 3 }, { { 22, 30, 23 }, { 73, 65, 78 }, { 38, 33, 39 }, 3 },
  { { 29, 30, 22 }, { 62, 65, 73 }, { 30, 33, 38 }, 3 }, { { 24, 23, 31 }, { 76, 78, 67 }, { 37, 39, 29 }, 3 },
  { { 31, 23, 30 }, { 67, 78, 65 }, { 29, 39, 33 }, 3 }, { { 25, 24, 32 }, { 60, 75, 49 }, { 34, 37, 23 }, 3 },
  { { 32, 24, 31 }, { 49, 75, 66 }, { 23, 37, 29 }, 3 }, { { 26, 25, 33 }, { 56, 61, 45 }, { 36, 34, 27 }, 3 },
  { { 33, 25, 32 }, { 45, 61, 50 }, { 27, 34, 23 }, 3 }, { { 20, 26, 27 }, { 37, 55, 41 }, { 18, 36, 19 }, 3 },
  { { 27, 26, 33 }, { 40, 54, 44 }, { 19, 36, 27 }, 3 }, { { 29, 28, 35 }, { 62, 57, 15 }, { 30, 25, 10 }, 3 },
  { { 35, 28, 34 }, { 15, 57, 20 }, { 10, 25, 16 }, 3 }, { { 36, 30, 29 }, { 8, 65, 62 }, { 8, 33, 30 }, 3 },
  { { 29, 35, 36 }, { 62, 15, 8 }, { 30, 10, 8 }, 3 }, { { 30, 37, 31 }, { 65, 10, 67 }, { 33, 14, 29 }, 3 },
  { { 36, 37, 30 }, { 8, 10, 65 }, { 8, 14, 33 }, 3 }, { { 32, 31, 38 }, { 50, 67, 28 }, { 23, 29, 15 }, 3 },
  { { 38, 31, 37 }, { 28, 67, 10 }, { 15, 29, 14 }, 3 }, { { 33, 32, 39 }, { 45, 50, 33 }, { 27, 23, 11 }, 3 },
  { { 39, 32, 38 }, { 33, 50, 28 }, { 11, 23, 15 }, 3 }, { { 27, 33, 39 }, { 40, 44, 31 }, { 19, 27, 11 }, 3 },
  { { 35, 34, 2 }, { 15, 20, 5 }, { 10, 16, 2 }, 3 }, { { 1, 2, 34 }, { 12, 6, 21 }, { 4, 2, 16 }, 3 },
  { { 36, 35, 3 }, { 8, 15, 3 }, { 8, 10, 0 }, 3 }, { { 3, 35, 2 }, { 3, 15, 5 }, { 0, 10, 2 }, 3 },
  { { 37, 36, 4 }, { 10, 8, 1 }, { 14, 8, 1 }, 3 }, { { 4, 36, 3 }, { 1, 8, 3 }, { 1, 8, 0 }, 3 },
  { { 38, 37, 5 }, { 27, 9, 17 }, { 15, 14, 5 }, 3 }, { { 5, 37, 4 }, { 17, 9, 0 }, { 5, 14, 1 }, 3 },
  { { 39, 38, 6 }, { 33, 28, 25 }, { 11, 15, 3 }, 3 }, { { 6, 38, 5 }, { 25, 28, 18 }, { 3, 15, 5 }, 3 },
  { { 27, 39, 0 }, { 41, 32, 43 }, { 19, 11, 21 }, 3 }, { { 0, 39, 6 }, { 42, 31, 23 }, { 21, 11, 3 }, 3 }
};

TEST_3D_DATA5 Multimatknight_3d_data5[17] = {
  { "Head",
    "Torso",
    43, 8, 39, 44,
    Multimatknight_xyz_Head,
    Multimatknight_uv_Head,
    Multimatknight_normal_Head,
    Multimatknight_triangle4_Head, 
    4, { -0.006427f, -0.009094f, 0.47971f } },
  { "Ll_arm",
    "Lu_arm",
    17, 36, 17, 30,
    Multimatknight_xyz_Ll_arm,
    Multimatknight_uv_Ll_arm,
    Multimatknight_normal_Ll_arm,
    Multimatknight_triangle4_Ll_arm, 
    12, { 0.301271f, -0.000708f, 0.073695f } },
  { "Ll_leg",
    "Lu_leg",
    30, 0, 30, 36,
    Multimatknight_xyz_Ll_leg,
    0,
    Multimatknight_normal_Ll_leg,
    Multimatknight_triangle4_Ll_leg, 
    20, { 0.096531f, -0.01019f, -0.53784f } },
  { "Lu_arm",
    "Torso",
    27, 57, 27, 50,
    Multimatknight_xyz_Lu_arm,
    Multimatknight_uv_Lu_arm,
    Multimatknight_normal_Lu_arm,
    Multimatknight_triangle4_Lu_arm, 
    11, { 0.305886f, 0.005099f, 0.354925f } },
  { "Lu_leg",
    "Pelvis",
    18, 0, 18, 24,
    Multimatknight_xyz_Lu_leg,
    0,
    Multimatknight_normal_Lu_leg,
    Multimatknight_triangle4_Lu_leg, 
    19, { 0.06371f, -0.01019f, -0.21675f } },
  { "L_fingers",
    "L_hand",
    20, 7, 24, 24,
    Multimatknight_xyz_L_fingers,
    Multimatknight_uv_L_fingers,
    Multimatknight_normal_L_fingers,
    Multimatknight_triangle4_L_fingers, 
    14, { 0.368579f, -0.00093f, -0.261295f } },
  { "L_foot",
    "Ll_leg",
    14, 0, 14, 24,
    Multimatknight_xyz_L_foot,
    0,
    Multimatknight_normal_L_foot,
    Multimatknight_triangle4_L_foot, 
    21, { 0.118671f, 0.00974f, -0.94308f } },
  { "L_hand",
    "Ll_arm",
    18, 48, 18, 32,
    Multimatknight_xyz_L_hand,
    Multimatknight_uv_L_hand,
    Multimatknight_normal_L_hand,
    Multimatknight_triangle4_L_hand, 
    13, { 0.306233f, 0.01169f, -0.183175f } },
  { "Obj",
    "R_hand",
    54, 0, 69, 80,
    Multimatknight_xyz_Obj,
    0,
    Multimatknight_normal_Obj,
    Multimatknight_triangle4_Obj, 
    28, { -0.330034f, 0.0248f, -0.320385f } },
  { "Pelvis",
    "",
    30, 34, 30, 36,
    Multimatknight_xyz_Pelvis,
    Multimatknight_uv_Pelvis,
    Multimatknight_normal_Pelvis,
    Multimatknight_triangle4_Pelvis, 
    1, { 0.0f, 0.0f, 0.0f } },
  { "Rl_arm",
    "Ru_arm",
    17, 36, 17, 30,
    Multimatknight_xyz_Rl_arm,
    Multimatknight_uv_Rl_arm,
    Multimatknight_normal_Rl_arm,
    Multimatknight_triangle4_Rl_arm, 
    7, { -0.299129f, 0.006663f, 0.030606f } },
  { "Rl_leg",
    "Ru_leg",
    30, 0, 30, 36,
    Multimatknight_xyz_Rl_leg,
    0,
    Multimatknight_normal_Rl_leg,
    Multimatknight_triangle4_Rl_leg, 
    16, { -0.131381f, -0.00041f, -0.54448f } },
  { "Ru_arm",
    "Torso",
    27, 55, 27, 50,
    Multimatknight_xyz_Ru_arm,
    Multimatknight_uv_Ru_arm,
    Multimatknight_normal_Ru_arm,
    Multimatknight_triangle4_Ru_arm, 
    6, { -0.290808f, 0.01268f, 0.337255f } },
  { "Ru_leg",
    "Pelvis",
    18, 0, 18, 24,
    Multimatknight_xyz_Ru_leg,
    0,
    Multimatknight_normal_Ru_leg,
    Multimatknight_triangle4_Ru_leg, 
    15, { -0.09351f, -0.00798f, -0.21675f } },
  { "R_foot",
    "Rl_leg",
    14, 0, 14, 24,
    Multimatknight_xyz_R_foot,
    0,
    Multimatknight_normal_R_foot,
    Multimatknight_triangle4_R_foot, 
    17, { -0.179341f, -0.00041f, -0.92979f } },
  { "R_hand",
    "Rl_arm",
    18, 46, 18, 32,
    Multimatknight_xyz_R_hand,
    Multimatknight_uv_R_hand,
    Multimatknight_normal_R_hand,
    Multimatknight_triangle4_R_hand, 
    8, { -0.326899f, 0.023672f, -0.213925f } },
  { "Torso",
    "Pelvis",
    40, 79, 40, 70,
    Multimatknight_xyz_Torso,
    Multimatknight_uv_Torso,
    Multimatknight_normal_Torso,
    Multimatknight_triangle4_Torso, 
    2, { -0.00375f, -0.00141f, 0.00938f } }
};
