// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "..\at3ddll.h"
#include "MainFrm.h"
#include "At3dData.h"

CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// create a class that has the variables and functions
	// for working with the DLL before creating the CPropertySheet
	//
  // decide what to do if the class is not created
  //
  try
  {
	  at3dData = new CAt3dData;
  }
  catch (...)
  {
    at3dData = 0;
  }

	// create a view to occupy the client area of the frame
	//
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}

	// create a CPropertySheet
	//
	m_PropBook = new CPropBook(this);
	if (!m_PropBook->Create(&m_wndView, WS_CHILD | WS_VISIBLE, 0))
	{
		delete m_PropBook;
		m_PropBook = NULL;
		return -1;
	}

	// Resize the mini frame so that it fits around the child property
	// sheet and leave room for the DLL window.
	//
	CRect rectClient, rectWindow;
	m_PropBook->GetWindowRect(rectClient);
	int width = rectClient.Width();
	rectClient.left = 0;

	// allow for a window width of 620
	//
	rectClient.right = width + 620;
	
	rectWindow = rectClient;

	// CMiniFrameWnd::CalcWindowRect adds the extra width and height
	// needed from the mini frame.
	//
	CalcWindowRect(rectWindow);
	SetWindowPos(NULL, rectWindow.left, rectWindow.top,
		rectWindow.Width(), rectWindow.Height(),
		SWP_NOZORDER | SWP_NOACTIVATE);
	m_PropBook->SetWindowPos(NULL, 620, 0,
		rectClient.Width() - 620, rectClient.Height(),
		SWP_NOZORDER | SWP_NOACTIVATE);

	// initialize the data structs in the DLL
	//
  if (at3dData) Start_DLL();
	
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	//
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
	// forward focus to the view window
	//
	m_PropBook->SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// let the view have first crack at the command
	//
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// otherwise, do default handling
	//
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CMainFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();
	
	// TODO: Add your message handler code here

	// free all memory used by the DLL
	//
	Stop_DLL();

	// free class used in working with the DLL
	//
	delete at3dData;

	// delete the CPropertySheet and CPropertyPages
	//
	delete m_PropBook;	
}

void CMainFrame::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	

	// Do not call CFrameWnd::OnPaint() for painting messages
}

void CMainFrame::Start_DLL(void)
{
  if ((!at3dData) || (at3dData->dllOpen)) return;

  at3dData->dllOpen = At3d_Start();

	if (!at3dData->dllOpen) return;
  
	// To detect mouse scroll wheel messages the DLL has to know the
  // handle to the main window of the application which
  // receives all the messages from the Windows Operating System
  //
  At3d_SetAppHandle(m_wndView.GetSafeHwnd());

  // Set size of DLL window
  //
  At3d_Size(600, 500);

	// Set position of DLL window
	//
  At3d_Position(2, 2);

	// Make DLL window a child of a window in the application
	//
  At3d_SetParent(at3dData->hwnd = m_wndView.GetSafeHwnd());

	// if the DLL window does not have a parent
  // At3d_SetParent(0);
  // a button will appear on the Windows Taskbar
  // use this function to set the name that will appear
  //
  At3d_SetCaption("DLL (at3d)");

	at3dData->useOglFlag = 1;
  At3d_WriteFlag(LIBFLAG_USE_OPENGL, at3dData->useOglFlag);

	// Make DLL window visible
	//
  At3d_Show();
}

void CMainFrame::Stop_DLL(void)
{
  // free all memory used by the DLL
	//
	if ((at3dData) && (at3dData->dllOpen)) 
  {
    At3d_Stop();
    at3dData->dllOpen = 0;
  }
}
