// KmlPage.cpp : implementation file
//

#include "stdafx.h"
#include "math.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "KmlPage.h"
#include "..\at3dx_my_functions.h"
#include "..\at3ddll.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CKmlPage property page

IMPLEMENT_DYNCREATE(CKmlPage, CPropertyPage)

CKmlPage::CKmlPage() : CPropertyPage(CKmlPage::IDD)
{
	//{{AFX_DATA_INIT(CKmlPage)
	m_KmlFolderName = _T("");
	m_KmlFolderDescription = _T("");
	m_KmlLookAtLatitudeDegrees = _T("");
	m_KmlLookAtLatitudeMinutes = _T("");
	m_KmlLookAtLatitudeSeconds = _T("");
	m_KmlLookAtLatitudeSign = FALSE;
	m_KmlLookAtLongitudeDegrees = _T("");
	m_KmlLookAtLongitudeMinutes = _T("");
	m_KmlLookAtLongitudeSeconds = _T("");
	m_KmlLookAtLongitudeSign = FALSE;
	m_KmlLookAtRange = _T("");
	m_KmlLookAtTilt = _T("");
	m_KmlLookAtAltitude = _T("");
	m_KmlLookAtHeading = _T("");
	m_KmlImagesFolderName = _T("");
	m_KmlModelsFolderName = _T("");
	m_KmlUseImagesFolder = FALSE;
	m_KmlUseModelsFolder = FALSE;
	m_KmlModelTilt = _T("");
	m_KmlModelRoll = _T("");
	m_KmlModelAltitude = _T("");
	m_KmlModelHeading = _T("");
	m_KmlModelLatitudeDegrees = _T("");
	m_KmlModelLatitudeMinutes = _T("");
	m_KmlModelLatitudeSeconds = _T("");
	m_KmlModelLatitudeSign = FALSE;
	m_KmlModelLongitudeDegrees = _T("");
	m_KmlModelLongitudeMinutes = _T("");
	m_KmlModelLongitudeSeconds = _T("");
	m_KmlModelLongitudeSign = FALSE;
	m_KmlPlacemarkName = _T("");
	m_KmlPlacemarkDescription = _T("");
  m_KmlModelScaleX = _T("");
  m_KmlModelScaleY = _T("");
  m_KmlModelScaleZ = _T("");
	//}}AFX_DATA_INIT
}

CKmlPage::~CKmlPage()
{
}

void CKmlPage::DoDataExchange(CDataExchange* pDX)
{
  CPropertyPage::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CKmlPage)
  DDX_Control(pDX, IDC_KMLLOOKATALTITUDEMODE, m_KmlLookAtAltitudeMode);
  DDX_Control(pDX, IDC_KMLMODELALTITUDEMODE, m_KmlModelAltitudeMode);
  DDX_Text(pDX, IDC_KMLFOLDERNAME, m_KmlFolderName);
  DDX_Text(pDX, IDC_KMLFOLDERDESCRIPTION, m_KmlFolderDescription);
  DDX_Text(pDX, IDC_KMLLOOKATLATITUDEDEGREES, m_KmlLookAtLatitudeDegrees);
  DDX_Text(pDX, IDC_KMLLOOKATLATITUDEMINUTES, m_KmlLookAtLatitudeMinutes);
  DDX_Text(pDX, IDC_KMLLOOKATLATITUDESECONDS, m_KmlLookAtLatitudeSeconds);
  DDX_Check(pDX, IDC_KMLLOOKATLATITUDESIGN, m_KmlLookAtLatitudeSign);
  DDX_Text(pDX, IDC_KMLLOOKATLONGITUDEDEGREES, m_KmlLookAtLongitudeDegrees);
  DDX_Text(pDX, IDC_KMLLOOKATLONGITUDEMINUTES, m_KmlLookAtLongitudeMinutes);
  DDX_Text(pDX, IDC_KMLLOOKATLONGITUDESECONDS, m_KmlLookAtLongitudeSeconds);
  DDX_Check(pDX, IDC_KMLLOOKATLONGITUDESIGN, m_KmlLookAtLongitudeSign);
  DDX_Text(pDX, IDC_KMLLOOKATRANGE, m_KmlLookAtRange);
  DDX_Text(pDX, IDC_KMLLOOKATTILT, m_KmlLookAtTilt);
  DDX_Text(pDX, IDC_KMLLOOKATALTITUDE, m_KmlLookAtAltitude);
  DDX_Text(pDX, IDC_KMLLOOKATHEADING, m_KmlLookAtHeading);
  DDX_Text(pDX, IDC_KMLIMAGESFOLDERNAME, m_KmlImagesFolderName);
  DDX_Text(pDX, IDC_KMLMODELSFOLDERNAME, m_KmlModelsFolderName);
  DDX_Check(pDX, IDC_KMLUSEIMAGESFOLDER, m_KmlUseImagesFolder);
  DDX_Check(pDX, IDC_KMLUSEMODELSFOLDER, m_KmlUseModelsFolder);
  DDX_Text(pDX, IDC_KMLMODELTILT, m_KmlModelTilt);
  DDX_Text(pDX, IDC_KMLMODELROLL, m_KmlModelRoll);
  DDX_Text(pDX, IDC_KMLMODELALTITUDE, m_KmlModelAltitude);
  DDX_Text(pDX, IDC_KMLMODELHEADING, m_KmlModelHeading);
  DDX_Text(pDX, IDC_KMLMODELLATITUDEDEGREES, m_KmlModelLatitudeDegrees);
  DDX_Text(pDX, IDC_KMLMODELLATITUDEMINUTES, m_KmlModelLatitudeMinutes);
  DDX_Text(pDX, IDC_KMLMODELLATITUDESECONDS, m_KmlModelLatitudeSeconds);
  DDX_Check(pDX, IDC_KMLMODELLATITUDESIGN, m_KmlModelLatitudeSign);
  DDX_Text(pDX, IDC_KMLMODELLONGITUDEDEGREES, m_KmlModelLongitudeDegrees);
  DDX_Text(pDX, IDC_KMLMODELLONGITUDEMINUTES, m_KmlModelLongitudeMinutes);
  DDX_Text(pDX, IDC_KMLMODELLONGITUDESECONDS, m_KmlModelLongitudeSeconds);
  DDX_Check(pDX, IDC_KMLMODELLONGITUDESIGN, m_KmlModelLongitudeSign);
  DDX_Text(pDX, IDC_KMLPLACEMARKNAME, m_KmlPlacemarkName);
  DDX_Text(pDX, IDC_KMLPLACEMARKDESCRIPTION, m_KmlPlacemarkDescription);
  DDX_Text(pDX, IDC_KMLMODELSCALEX, m_KmlModelScaleX);
  DDX_Text(pDX, IDC_KMLMODELSCALEY, m_KmlModelScaleY);
  DDX_Text(pDX, IDC_KMLMODELSCALEZ, m_KmlModelScaleZ);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CKmlPage, CPropertyPage)
	//{{AFX_MSG_MAP(CKmlPage)
	ON_BN_CLICKED(IDC_KMLCOPYLATITUDELONGITUDE, OnKmlCopylatitudelongitude)
	ON_BN_CLICKED(IDC_KMLLOOKATLATITUDESIGN, OnKmllookatlatitudesign)
	ON_BN_CLICKED(IDC_KMLLOOKATLONGITUDESIGN, OnKmllookatlongitudesign)
	ON_BN_CLICKED(IDC_KMLMODELLATITUDESIGN, OnKmlmodellatitudesign)
	ON_BN_CLICKED(IDC_KMLMODELLONGITUDESIGN, OnKmlmodellongitudesign)
	ON_CBN_SELCHANGE(IDC_KMLLOOKATALTITUDEMODE, OnSelchangeKmllookataltitudemode)
	ON_CBN_SELCHANGE(IDC_KMLMODELALTITUDEMODE, OnSelchangeKmlmodelaltitudemode)
	ON_BN_CLICKED(IDC_KMLUSEMODELSFOLDER, OnKmlusemodelsfolder)
	ON_BN_CLICKED(IDC_KMLUSEIMAGESFOLDER, OnKmluseimagesfolder)
	ON_BN_CLICKED(IDC_KMLGETDATAFORDLL, OnKmlgetdatafordll)
	//}}AFX_MSG_MAP
  ON_BN_CLICKED(IDC_KMLGETDATAFROMDLL, &CKmlPage::OnBnClickedKmlgetdatafromdll)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKmlPage message handlers

BOOL CKmlPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here    
	int i;
  for (i=0; i<KML_ALTITUDE_MODE_COUNT; i++)
  {
    m_KmlLookAtAltitudeMode.AddString(at3dData->kmlAltitudeModeLabels[i]);      
  }
  
  for (i=0; i<KML_ALTITUDE_MODE_COUNT; i++)
  {
    m_KmlModelAltitudeMode.AddString(at3dData->kmlAltitudeModeLabels[i]);        
  }
  
  Update_KML_Page();

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CKmlPage::Update_KML_Page(void)
{
	if (at3dData->kmlFolderName.IsEmpty())
  {
    m_KmlFolderName = _T("");
  }
  else
  {
    m_KmlFolderName = at3dData->kmlFolderName;
  }

  if (at3dData->kmlFolderDescription.IsEmpty())
  {
    m_KmlFolderDescription = _T("");
  }
  else
  {
    m_KmlFolderDescription = at3dData->kmlFolderDescription;
  }

	// --

  if (at3dData->kmlPlacemarkName.IsEmpty())
  {
    m_KmlPlacemarkName = _T("");
  }
  else
  {
    m_KmlPlacemarkName = at3dData->kmlPlacemarkName;
  }

  if (at3dData->kmlPlacemarkDescription.IsEmpty())
  {
    m_KmlPlacemarkDescription = _T("");
  }
  else
  {
    m_KmlPlacemarkDescription = at3dData->kmlPlacemarkDescription;
  }

	// --

  m_KmlUseModelsFolder = (at3dData->kmlUseModelsFolderFlag) ? 1 : 0;
  m_KmlUseImagesFolder = (at3dData->kmlUseImagesFolderFlag) ? 1 : 0;

  if (strlen(at3dData->kmlModelsFolderName))
  {
    m_KmlModelsFolderName = at3dData->kmlModelsFolderName;
  }
  else
  {
    m_KmlModelsFolderName =  _T("");
  }

  if (strlen(at3dData->kmlImagesFolderName))
  {
    m_KmlImagesFolderName = at3dData->kmlImagesFolderName;
  }
  else
  {
    m_KmlImagesFolderName =  _T("");
  }

  // --

  Display_LookAt_Latitude_Longitude();

  m_KmlLookAtAltitude.Format("%.2f", at3dData->kmlLookAt_Altitude);
  m_KmlLookAtHeading.Format("%.2f", at3dData->kmlLookAt_Heading);
  m_KmlLookAtTilt.Format("%.2f", at3dData->kmlLookAt_Tilt);
  m_KmlLookAtRange.Format("%.2f", at3dData->kmlLookAt_Range);

	// --

  Display_Model_Latitude_Longitude();

  m_KmlModelAltitude.Format("%.2f", at3dData->kmlModel_Altitude);
  m_KmlModelHeading.Format("%.2f", at3dData->kmlModel_Heading);
  m_KmlModelTilt.Format("%.2f", at3dData->kmlModel_Tilt);
  m_KmlModelRoll.Format("%.2f", at3dData->kmlModel_Roll);
	m_KmlModelScaleX.Format("%.2f", at3dData->kmlModel_Scale_X);
	m_KmlModelScaleY.Format("%.2f", at3dData->kmlModel_Scale_Y);
	m_KmlModelScaleZ.Format("%.2f", at3dData->kmlModel_Scale_Z);

	// --

  Display_Latitude_Longitude_Signs();

	// --

	m_KmlLookAtAltitudeMode.SetCurSel(at3dData->kmlLookAt_Altitude_Mode_Flag);

	m_KmlModelAltitudeMode.SetCurSel(at3dData->kmlModel_Altitude_Mode_Flag);

  UpdateData(FALSE);
}

void CKmlPage::Display_LookAt_Latitude_Longitude(void)
{
	m_KmlLookAtLatitudeDegrees.Format("%d", at3dData->kmlLookAt_Latitude_Degrees);
  m_KmlLookAtLatitudeMinutes.Format("%d", at3dData->kmlLookAt_Latitude_Minutes);
  m_KmlLookAtLatitudeSeconds.Format("%.2f", at3dData->kmlLookAt_Latitude_Seconds);

  m_KmlLookAtLongitudeDegrees.Format("%d", at3dData->kmlLookAt_Longitude_Degrees);
  m_KmlLookAtLongitudeMinutes.Format("%d", at3dData->kmlLookAt_Longitude_Minutes);
  m_KmlLookAtLongitudeSeconds.Format("%.2f", at3dData->kmlLookAt_Longitude_Seconds);

	UpdateData(FALSE);
}

void CKmlPage::Display_Model_Latitude_Longitude(void)
{
	m_KmlModelLatitudeDegrees.Format("%d", at3dData->kmlModel_Latitude_Degrees);
  m_KmlModelLatitudeMinutes.Format("%d", at3dData->kmlModel_Latitude_Minutes);
  m_KmlModelLatitudeSeconds.Format("%.2f", at3dData->kmlModel_Latitude_Seconds);

  m_KmlModelLongitudeDegrees.Format("%d", at3dData->kmlModel_Longitude_Degrees);
  m_KmlModelLongitudeMinutes.Format("%d", at3dData->kmlModel_Longitude_Minutes);
  m_KmlModelLongitudeSeconds.Format("%.2f", at3dData->kmlModel_Longitude_Seconds);

	UpdateData(FALSE);
}

void CKmlPage::Get_LookAt_Latitude_Longitude(void)
{
	UpdateData(TRUE);

	at3dData->kmlLookAt_Latitude_Degrees = abs(atoi(m_KmlLookAtLatitudeDegrees));
  
  at3dData->kmlLookAt_Latitude_Minutes = abs(atoi(m_KmlLookAtLatitudeMinutes));
  
	at3dData->kmlLookAt_Latitude_Seconds = fabs(atof(m_KmlLookAtLatitudeSeconds));
  
  // --

  at3dData->kmlLookAt_Longitude_Degrees = abs(atoi(m_KmlLookAtLongitudeDegrees));
  
  at3dData->kmlLookAt_Longitude_Minutes = abs(atoi(m_KmlLookAtLongitudeMinutes));
  
  at3dData->kmlLookAt_Longitude_Seconds = fabs(atof(m_KmlLookAtLongitudeSeconds));
}

void CKmlPage::Get_Model_Latitude_Longitude(void)
{
	UpdateData(TRUE);

	at3dData->kmlModel_Latitude_Degrees = abs(atoi(m_KmlModelLatitudeDegrees));
  
  at3dData->kmlModel_Latitude_Minutes = abs(atoi(m_KmlModelLatitudeMinutes));
  
  at3dData->kmlModel_Latitude_Seconds = fabs(atof(m_KmlModelLatitudeSeconds));
  
  // --

  at3dData->kmlModel_Longitude_Degrees = abs(atoi(m_KmlModelLongitudeDegrees));
  
  at3dData->kmlModel_Longitude_Minutes = abs(atoi(m_KmlModelLongitudeMinutes));
  
  at3dData->kmlModel_Longitude_Seconds = fabs(atof(m_KmlModelLongitudeSeconds));
}

void CKmlPage::Display_Latitude_Longitude_Signs(void)
{
	m_KmlLookAtLatitudeSign = (at3dData->kmlLookAt_Latitude_Sign) ? TRUE : FALSE;

  m_KmlLookAtLongitudeSign = (at3dData->kmlLookAt_Longitude_Sign) ? TRUE : FALSE;

  m_KmlModelLatitudeSign = (at3dData->kmlModel_Latitude_Sign) ? TRUE : FALSE;

  m_KmlModelLongitudeSign = (at3dData->kmlModel_Longitude_Sign) ? TRUE : FALSE;

	UpdateData(FALSE);

}

void CKmlPage::OnKmlCopylatitudelongitude() 
{
	Get_Model_Latitude_Longitude();

  at3dData->kmlLookAt_Latitude_Degrees = at3dData->kmlModel_Latitude_Degrees;
  at3dData->kmlLookAt_Latitude_Minutes = at3dData->kmlModel_Latitude_Minutes;
  at3dData->kmlLookAt_Latitude_Seconds = at3dData->kmlModel_Latitude_Seconds;
  at3dData->kmlLookAt_Latitude_Sign    = at3dData->kmlModel_Latitude_Sign;

  at3dData->kmlLookAt_Longitude_Degrees = at3dData->kmlModel_Longitude_Degrees;
  at3dData->kmlLookAt_Longitude_Minutes = at3dData->kmlModel_Longitude_Minutes;
  at3dData->kmlLookAt_Longitude_Seconds = at3dData->kmlModel_Longitude_Seconds;
  at3dData->kmlLookAt_Longitude_Sign    = at3dData->kmlModel_Longitude_Sign;

  Display_LookAt_Latitude_Longitude();
  Display_Latitude_Longitude_Signs();
}

void CKmlPage::OnKmllookatlatitudesign() 
{
	UpdateData(TRUE);
	at3dData->kmlLookAt_Latitude_Sign = (m_KmlLookAtLatitudeSign) ? 1 : 0;
}


void CKmlPage::OnKmllookatlongitudesign() 
{
	UpdateData(TRUE);
	at3dData->kmlLookAt_Longitude_Sign = (m_KmlLookAtLongitudeSign) ? 1 : 0;
}

void CKmlPage::OnKmlmodellatitudesign() 
{
	UpdateData(TRUE);
	at3dData->kmlModel_Latitude_Sign = (m_KmlModelLatitudeSign) ? 1 : 0;
}

void CKmlPage::OnKmlmodellongitudesign() 
{
	UpdateData(TRUE);
	at3dData->kmlModel_Longitude_Sign = (m_KmlModelLongitudeSign) ? 1 : 0;
}

void CKmlPage::OnKmlusemodelsfolder() 
{
	UpdateData(TRUE);
	at3dData->kmlUseModelsFolderFlag = (m_KmlUseModelsFolder) ? 1 : 0;
}

void CKmlPage::OnKmluseimagesfolder() 
{
	UpdateData(TRUE);
	at3dData->kmlUseImagesFolderFlag = (m_KmlUseImagesFolder) ? 1 : 0;
}

void CKmlPage::OnSelchangeKmllookataltitudemode() 
{
	if (m_KmlLookAtAltitudeMode.GetCurSel() != CB_ERR)
	{
		at3dData->kmlLookAt_Altitude_Mode_Flag = m_KmlLookAtAltitudeMode.GetCurSel();
	}	
}

void CKmlPage::OnSelchangeKmlmodelaltitudemode() 
{
	if (m_KmlModelAltitudeMode.GetCurSel() != CB_ERR)
	{
		at3dData->kmlModel_Altitude_Mode_Flag = m_KmlModelAltitudeMode.GetCurSel();
	}
}

void CKmlPage::OnKmlgetdatafordll() 
{
	UpdateData(TRUE);
	
	if (m_KmlFolderName.IsEmpty())
  {
    at3dData->kmlFolderName = _T("");
  }
  else
  {
    at3dData->kmlFolderName = m_KmlFolderName;
  }

  if (m_KmlFolderDescription.IsEmpty())
  {
    at3dData->kmlFolderDescription = _T("");
  }
  else
  {
    at3dData->kmlFolderDescription = m_KmlFolderDescription;
  }

  // --

  if (m_KmlPlacemarkName.IsEmpty())
  {
    at3dData->kmlPlacemarkName = _T("");
  }
  else
  {
    at3dData->kmlPlacemarkName = m_KmlPlacemarkName;
  }

  if (m_KmlPlacemarkDescription.IsEmpty())
  {
    at3dData->kmlPlacemarkDescription = _T("");
  }
  else
  {
    at3dData->kmlPlacemarkDescription = m_KmlPlacemarkDescription;
  }

  // --

  if (m_KmlModelsFolderName.IsEmpty())
  {
    at3dData->kmlModelsFolderName[0] = '\0';
  }
  else
  {
    my_strncpy(at3dData->kmlModelsFolderName, LEN_FILE_FNAME,
            (char*)LPCTSTR(m_KmlModelsFolderName), LEN_FILE_FNAME - 1);
    at3dData->kmlModelsFolderName[LEN_FILE_FNAME - 1] = '\0';
  }

  if (m_KmlImagesFolderName.IsEmpty())
  {
    at3dData->kmlImagesFolderName[0] = '\0';
  }
  else
  {
    my_strncpy(at3dData->kmlImagesFolderName, LEN_FILE_FNAME,
            (char*)LPCTSTR(m_KmlImagesFolderName), LEN_FILE_FNAME - 1);
    at3dData->kmlImagesFolderName[LEN_FILE_FNAME - 1] = '\0';
  }


  // --

  Get_LookAt_Latitude_Longitude();

  at3dData->kmlLookAt_Altitude = atof(m_KmlLookAtAltitude);
  
  at3dData->kmlLookAt_Heading = atof(m_KmlLookAtHeading);
  
  at3dData->kmlLookAt_Tilt = atof(m_KmlLookAtTilt);
  
  at3dData->kmlLookAt_Range = atof(m_KmlLookAtRange);
  
  // --

  Get_Model_Latitude_Longitude();

  at3dData->kmlModel_Altitude = atof(m_KmlModelAltitude);
  
  at3dData->kmlModel_Heading = atof(m_KmlModelHeading);
  
  at3dData->kmlModel_Tilt = atof(m_KmlModelTilt);
  
  at3dData->kmlModel_Roll = atof(m_KmlModelRoll);

  at3dData->kmlModel_Scale_X = atof(m_KmlModelScaleX);

  at3dData->kmlModel_Scale_Y = atof(m_KmlModelScaleY);

  at3dData->kmlModel_Scale_Z = atof(m_KmlModelScaleZ);
}

void CKmlPage::OnBnClickedKmlgetdatafromdll()
{
  at3dData->Get_KML_Data_From_DLL();
  Update_KML_Page();
}
