// Object: Greenmonk
// original monk.3ds file created by Dan White

#ifndef at3dTestData_H
#define at3dTestData_H

#define LEN_LAYER_NAME   80

typedef struct tag_TEST_XYZ {
  float x;
  float y;
  float z;
  } TEST_XYZ;

typedef struct tag_TEST_UV {
  float u;
  float v;
  } TEST_UV;

typedef struct tag_TEST_XYZ_UV {
  float x;
  float y;
  float z;
  float u;
  float v;
  } TEST_XYZ_UV;

typedef struct tag_TEST_NORMAL {
  float x;
  float y;
  float z;
  } TEST_NORMAL;

typedef struct tag_TEST_TRIANGLE1 {
  __int32 xyzIndex[3];
  TEST_UV uv[3];
  TEST_NORMAL normal[3];
  } TEST_TRIANGLE1;

typedef struct tag_TEST_TRIANGLE2 {
  __int32 xyzIndex[3];
  __int32 uvIndex[3];
  __int32 normalIndex[3];
  } TEST_TRIANGLE2;

typedef struct tag_TEST_TRIANGLE3 {
  __int32 xyz_uvIndex[3];
  __int32 normalIndex[3];
  } TEST_TRIANGLE3;

typedef struct tag_TEST_TRIANGLE4 {
  __int32 xyzIndex[3];
  __int32 uvIndex[3];
  __int32 normalIndex[3];
  __int32 materialIndex;
  } TEST_TRIANGLE4;

typedef struct tag_TEST_RGB {
  float red;
  float green;
  float blue; 
  } TEST_RGB;

typedef struct tag_TEST_MATERIAL {
  char name[LEN_LAYER_NAME];
  void* layerPtr;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_MATERIAL;

typedef struct tag_TEST_3D_DATA1 {
  char name[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_TRIANGLE1* triangle;
  __int32 uvFlag;
  __int32 normalFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA1;

typedef struct tag_TEST_3D_DATA2 {
  char name[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_UV* uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE2* triangle;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA2;

typedef struct tag_TEST_3D_DATA3 {
  char name[LEN_LAYER_NAME];
  __int32 xyz_uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ_UV* xyz_uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE3* triangle;
  __int32 uvFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA3;

typedef struct tag_TEST_3D_DATA4 {
  char name[LEN_LAYER_NAME];
  float* matrix;
  __int32 xyz_uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ_UV* xyz_uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE3* triangle;
  __int32 uvFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA4;

typedef struct tag_TEST_3D_DATA5 {
  char name[LEN_LAYER_NAME];
  char parentName[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_UV* uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE4* triangle;
  __int32 tag;
  TEST_XYZ pivotPoint;
  } TEST_3D_DATA5;
  
#endif at3dTestData_H

__int32 Greenmonk_materialCount = 11;
__int32 Greenmonk_xyzCount = 766;
__int32 Greenmonk_uvCount = 772;
__int32 Greenmonk_vnormCount = 742;
__int32 Greenmonk_triangleCount = 1380;

TEST_MATERIAL Greenmonk_material[11] = {
  { "Body", 0,
    { 0.0f, 0.0f, 0.0f }, { 0.588235f, 0.588235f, 0.588235f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenChain.bmp" },
  { "Head", 0,
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.72549f, 0.72549f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Hood", 0,
    { 0.0f, 0.0f, 0.0f }, { 0.588235f, 0.588235f, 0.588235f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenChain.bmp" },
  { "Lhand", 0,
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.72549f, 0.72549f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Llower_arm", 0,
    { 0.0f, 0.0f, 0.0f }, { 0.588235f, 0.588235f, 0.588235f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenChain.bmp" },
  { "Lupper_arm", 0,
    { 0.0f, 0.0f, 0.0f }, { 0.588235f, 0.588235f, 0.588235f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenChain.bmp" },
  { "Rhand", 0,
    { 0.0f, 0.0f, 0.0f }, { 1.0f, 0.72549f, 0.72549f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Rlower_arm", 0,
    { 0.0f, 0.0f, 0.0f }, { 0.588235f, 0.588235f, 0.588235f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenChain.bmp" },
  { "Rope_belt", 0,
    { 0.0f, 0.0f, 0.0f }, { 0.423529f, 0.211765f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Rupper_arm", 0,
    { 0.0f, 0.0f, 0.0f }, { 0.588235f, 0.588235f, 0.588235f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenChain.bmp" },
  { "Shawl", 0,
    { 0.0f, 0.0f, 0.0f }, { 0.588235f, 0.588235f, 0.588235f }, 
    { 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj1\\GreenChain.bmp" },
};

TEST_XYZ Greenmonk_xyz[766] = {
  { 0.464709f, 0.030434f, 0.799352f }, { 0.462105f, 0.055736f, 0.769584f },
  { 0.45627f, 0.055736f, 0.702886f }, { 0.456996f, 0.040962f, 0.632499f },
  { 0.464709f, 0.022615f, 0.799352f }, { 0.462105f, 0.018018f, 0.769584f },
  { 0.45627f, 0.018018f, 0.702886f }, { 0.456996f, 0.013093f, 0.632499f },
  { 0.464709f, -0.024298f, 0.799352f }, { 0.462105f, -0.0197f, 0.769584f },
  { 0.45627f, -0.0197f, 0.702886f }, { 0.456996f, -0.014776f, 0.632499f },
  { 0.464709f, -0.032117f, 0.799352f }, { 0.462105f, -0.057418f, 0.769584f },
  { 0.45627f, -0.057418f, 0.702886f }, { 0.456996f, -0.042644f, 0.632499f },
  { 0.495614f, 0.030434f, 0.796648f }, { 0.49301f, 0.055736f, 0.76688f },
  { 0.487174f, 0.055736f, 0.700182f }, { 0.483259f, 0.040962f, 0.62294f },
  { 0.495614f, 0.022615f, 0.796648f }, { 0.49301f, 0.018018f, 0.76688f },
  { 0.487174f, 0.018018f, 0.700182f }, { 0.483259f, 0.013093f, 0.62294f },
  { 0.495614f, -0.024298f, 0.796648f }, { 0.49301f, -0.0197f, 0.76688f },
  { 0.487174f, -0.0197f, 0.700182f }, { 0.483259f, -0.014776f, 0.62294f },
  { 0.495614f, -0.032117f, 0.796648f }, { 0.49301f, -0.057418f, 0.76688f },
  { 0.487174f, -0.057418f, 0.700182f }, { 0.483259f, -0.042644f, 0.62294f },
  { 0.457497f, -0.08645f, 0.671757f }, { 0.457651f, -0.103263f, 0.673516f },
  { 0.48056f, -0.08645f, 0.669739f }, { 0.480714f, -0.103263f, 0.671498f },
  { 0.420518f, 0.026202f, 0.599922f }, { 0.420518f, 0.008173f, 0.599922f },
  { 0.420518f, -0.009856f, 0.599922f }, { 0.420518f, -0.027884f, 0.599922f },
  { 0.432278f, 0.026202f, 0.583265f }, { 0.432278f, 0.008173f, 0.583265f },
  { 0.432278f, -0.009856f, 0.583265f }, { 0.432278f, -0.027884f, 0.583265f },
  { 0.419079f, 0.02988f, 0.884776f }, { 0.419079f, -0.031563f, 0.884776f },
  { 0.477001f, 0.02988f, 0.889844f }, { 0.477001f, -0.031563f, 0.889844f },
  { 0.341856f, 0.039877f, 1.176842f }, { 0.367016f, 0.038389f, 1.270968f },
  { 0.327473f, 0.049578f, 1.264223f }, { 0.289851f, 0.05043f, 1.486191f },
  { 0.249466f, 0.042888f, 1.479375f }, { 0.274625f, 0.0414f, 1.573501f },
  { 0.338205f, -0.04129f, 1.176535f }, { 0.322979f, -0.05032f, 1.263845f },
  { 0.283436f, -0.039131f, 1.2571f }, { 0.285357f, -0.049468f, 1.485813f },
  { 0.308433f, -0.038339f, 1.576934f }, { 0.270974f, -0.039768f, 1.573194f },
  { 0.341317f, -0.000736f, 1.169095f }, { 0.276039f, 0.001873f, 1.255688f },
  { 0.238417f, 0.002725f, 1.477656f }, { 0.232835f, 0.00264f, 1.566567f },
  { 0.312764f, -0.001008f, 1.580128f }, { 0.336791f, -0.001764f, 1.494347f },
  { 0.374413f, -0.002616f, 1.272379f }, { 0.378177f, 0.035082f, 1.18562f },
  { 0.301026f, -0.036475f, 1.172818f }, { 0.304397f, 0.038449f, 1.173102f },
  { 0.287088f, 0.042036f, 1.257407f }, { 0.238024f, 0.039952f, 1.564699f },
  { 0.300066f, 0.001117f, 1.169908f }, { 0.234653f, -0.034972f, 1.564415f },
  { 0.245814f, -0.038279f, 1.479067f }, { 0.311804f, 0.036585f, 1.577217f },
  { 0.329394f, 0.039241f, 1.492936f }, { 0.325742f, -0.041927f, 1.492629f },
  { 0.363364f, -0.042779f, 1.270661f }, { 0.379995f, -0.00253f, 1.183469f },
  { 0.374806f, -0.039842f, 1.185336f }, { 0.473144f, 0.150237f, 0.825339f },
  { 0.439039f, 0.093971f, 0.919042f }, { 0.413633f, 0.039784f, 1.107623f },
  { 0.375458f, 0.049159f, 1.093729f }, { 0.337283f, 0.039784f, 1.079834f },
  { 0.378525f, 0.036659f, 1.194945f }, { 0.342327f, 0.039784f, 1.184757f },
  { 0.473144f, -0.074501f, 0.825339f }, { 0.40129f, -0.058344f, 0.807464f },
  { 0.439039f, -0.0644f, 0.919042f }, { 0.375458f, -0.050841f, 1.093729f },
  { 0.342327f, -0.041466f, 1.184757f }, { 0.308048f, -0.038341f, 1.169294f },
  { 0.452859f, -0.000841f, 0.881073f }, { 0.378258f, -0.000841f, 0.896919f },
  { 0.328474f, -0.000841f, 1.076628f }, { 0.339446f, -0.000841f, 1.192671f },
  { 0.422443f, -0.000841f, 1.11083f }, { 0.499821f, -0.000841f, 0.941164f },
  { 0.539677f, 0.123574f, 0.857832f }, { 0.401291f, 0.123574f, 0.807464f },
  { 0.389654f, 0.078689f, 0.901067f }, { 0.395708f, -0.000841f, 0.804861f },
  { 0.337283f, -0.041466f, 1.079834f }, { 0.389654f, -0.049118f, 0.901067f },
  { 0.308048f, 0.036659f, 1.169294f }, { 0.304152f, -0.000841f, 1.170863f },
  { 0.488424f, 0.078689f, 0.937016f }, { 0.413633f, -0.041466f, 1.107623f },
  { 0.378525f, -0.038341f, 1.194945f }, { 0.380502f, -0.000841f, 1.198652f },
  { 0.488424f, -0.049118f, 0.937016f }, { 0.545627f, -0.000841f, 0.859427f },
  { 0.539677f, -0.058344f, 0.857832f }, { -0.488424f, 0.078689f, 0.937016f },
  { -0.439039f, 0.093971f, 0.919042f }, { -0.413633f, 0.039784f, 1.107623f },
  { -0.375458f, 0.049159f, 1.093729f }, { -0.378525f, 0.036659f, 1.194945f },
  { -0.342327f, 0.039784f, 1.184757f }, { -0.308048f, 0.036659f, 1.169294f },
  { -0.473144f, -0.074501f, 0.825339f }, { -0.488424f, -0.049118f, 0.937016f },
  { -0.439039f, -0.0644f, 0.919042f }, { -0.389654f, -0.049118f, 0.901067f },
  { -0.375458f, -0.050841f, 1.093729f }, { -0.342327f, -0.041466f, 1.184757f },
  { -0.545627f, -0.000841f, 0.859427f }, { -0.452859f, -0.000841f, 0.881073f },
  { -0.395708f, -0.000841f, 0.804861f }, { -0.378258f, -0.000841f, 0.896919f },
  { -0.328474f, -0.000841f, 1.076628f }, { -0.339446f, -0.000841f, 1.192671f },
  { -0.422443f, -0.000841f, 1.11083f }, { -0.499821f, -0.000841f, 0.941164f },
  { -0.473144f, 0.150237f, 0.825339f }, { -0.539677f, 0.123574f, 0.857832f },
  { -0.40129f, -0.058344f, 0.807464f }, { -0.401291f, 0.123574f, 0.807464f },
  { -0.389654f, 0.078689f, 0.901067f }, { -0.337283f, 0.039784f, 1.079834f },
  { -0.308048f, -0.038341f, 1.169294f }, { -0.337283f, -0.041466f, 1.079834f },
  { -0.304152f, -0.000841f, 1.170863f }, { -0.378525f, -0.038341f, 1.194945f },
  { -0.380502f, -0.000841f, 1.198652f }, { -0.413633f, -0.041466f, 1.107623f },
  { -0.539677f, -0.058344f, 0.857832f }, { -0.327473f, 0.049578f, 1.264223f },
  { -0.289851f, 0.05043f, 1.486191f }, { -0.249466f, 0.042888f, 1.479375f },
  { -0.311804f, 0.036585f, 1.577217f }, { -0.274625f, 0.0414f, 1.573501f },
  { -0.238024f, 0.039952f, 1.564699f }, { -0.363364f, -0.042779f, 1.270661f },
  { -0.322979f, -0.05032f, 1.263845f }, { -0.283436f, -0.039131f, 1.2571f },
  { -0.325742f, -0.041927f, 1.492629f }, { -0.285357f, -0.049468f, 1.485813f },
  { -0.245814f, -0.038279f, 1.479067f }, { -0.308433f, -0.038339f, 1.576934f },
  { -0.270974f, -0.039768f, 1.573194f }, { -0.379995f, -0.00253f, 1.183469f },
  { -0.341317f, -0.000736f, 1.169095f }, { -0.276039f, 0.001873f, 1.255688f },
  { -0.238417f, 0.002725f, 1.477656f }, { -0.232835f, 0.00264f, 1.566567f },
  { -0.312764f, -0.001008f, 1.580128f }, { -0.336791f, -0.001764f, 1.494347f },
  { -0.374413f, -0.002616f, 1.272379f }, { -0.341856f, 0.039877f, 1.176842f },
  { -0.378177f, 0.035082f, 1.18562f }, { -0.304397f, 0.038449f, 1.173102f },
  { -0.338205f, -0.04129f, 1.176535f }, { -0.374806f, -0.039842f, 1.185336f },
  { -0.287088f, 0.042036f, 1.257407f }, { -0.301026f, -0.036475f, 1.172818f },
  { -0.300066f, 0.001117f, 1.169908f }, { -0.234653f, -0.034972f, 1.564415f },
  { -0.367016f, 0.038389f, 1.270968f }, { -0.329394f, 0.039241f, 1.492936f },
  { -0.464709f, 0.030434f, 0.799352f }, { -0.462105f, 0.055736f, 0.769584f },
  { -0.45627f, 0.055736f, 0.702886f }, { -0.456996f, 0.040962f, 0.632499f },
  { -0.464709f, 0.022615f, 0.799352f }, { -0.462105f, 0.018018f, 0.769584f },
  { -0.45627f, 0.018018f, 0.702886f }, { -0.456996f, 0.013093f, 0.632499f },
  { -0.464709f, -0.024298f, 0.799352f }, { -0.462105f, -0.0197f, 0.769584f },
  { -0.45627f, -0.0197f, 0.702886f }, { -0.456996f, -0.014776f, 0.632499f },
  { -0.464709f, -0.032117f, 0.799352f }, { -0.462105f, -0.057418f, 0.769584f },
  { -0.45627f, -0.057418f, 0.702886f }, { -0.456996f, -0.042644f, 0.632499f },
  { -0.495614f, 0.030434f, 0.796648f }, { -0.49301f, 0.055736f, 0.766881f },
  { -0.487174f, 0.055736f, 0.700182f }, { -0.483259f, 0.040962f, 0.62294f },
  { -0.495614f, 0.022615f, 0.796648f }, { -0.49301f, 0.018018f, 0.766881f },
  { -0.487174f, 0.018018f, 0.700182f }, { -0.483259f, 0.013093f, 0.62294f },
  { -0.495614f, -0.024298f, 0.796648f }, { -0.49301f, -0.0197f, 0.766881f },
  { -0.487174f, -0.0197f, 0.700182f }, { -0.483259f, -0.014776f, 0.62294f },
  { -0.495614f, -0.032117f, 0.796648f }, { -0.49301f, -0.057418f, 0.766881f },
  { -0.487174f, -0.057418f, 0.700182f }, { -0.483259f, -0.042644f, 0.62294f },
  { -0.457497f, -0.08645f, 0.671757f }, { -0.457651f, -0.103263f, 0.673516f },
  { -0.48056f, -0.08645f, 0.669739f }, { -0.480714f, -0.103263f, 0.671498f },
  { -0.420518f, 0.026202f, 0.599922f }, { -0.420518f, 0.008173f, 0.599922f },
  { -0.420518f, -0.009856f, 0.599922f }, { -0.420518f, -0.027884f, 0.599922f },
  { -0.432278f, 0.026202f, 0.583265f }, { -0.432278f, 0.008173f, 0.583265f },
  { -0.432278f, -0.009856f, 0.583265f }, { -0.432278f, -0.027884f, 0.583265f },
  { -0.419079f, 0.02988f, 0.884776f }, { -0.419079f, -0.031563f, 0.884776f },
  { -0.477001f, 0.02988f, 0.889844f }, { -0.477001f, -0.031563f, 0.889844f },
  { 0.007742f, -0.111171f, 1.864964f }, { 0.007742f, -0.143263f, 1.864964f },
  { 0.007742f, -0.127217f, 1.897056f }, { 0.007742f, -0.111171f, 1.913102f },
  { -0.007742f, -0.111171f, 1.864964f }, { -0.007742f, -0.143263f, 1.864964f },
  { -0.007742f, -0.127217f, 1.897056f }, { -0.007742f, -0.111171f, 1.913102f },
  { -0.06341f, -0.055982f, 1.795288f }, { -0.021882f, -0.094279f, 1.772939f },
  { 0.021881f, -0.094279f, 1.772939f }, { 0.061533f, -0.055982f, 1.795288f },
  { -0.072938f, -0.099488f, 1.851141f }, { -0.029765f, -0.111171f, 1.843352f },
  { 0.029765f, -0.111171f, 1.843352f }, { 0.072938f, -0.099488f, 1.851141f },
  { -0.072938f, -0.099488f, 1.920605f }, { -0.029765f, -0.111171f, 1.928394f },
  { 0.029765f, -0.111171f, 1.928394f }, { 0.072938f, -0.099488f, 1.920605f },
  { -0.061534f, -0.082641f, 1.973778f }, { -0.021882f, -0.085577f, 1.989019f },
  { 0.021881f, -0.085577f, 1.989019f }, { 0.061533f, -0.082641f, 1.973778f },
  { -0.022882f, -0.057228f, 1.768654f }, { 0.022881f, -0.057228f, 1.768654f },
  { 0.079135f, -0.059726f, 1.84819f }, { 0.079135f, -0.059726f, 1.923556f },
  { 0.063409f, -0.055982f, 1.976458f }, { 0.022881f, -0.057228f, 1.993304f },
  { -0.022882f, -0.057228f, 1.993304f }, { -0.06341f, -0.055982f, 1.976458f },
  { -0.079135f, -0.059726f, 1.923556f }, { -0.079135f, -0.059726f, 1.84819f },
  { -0.070238f, 0.085704f, 1.749936f }, { 0.000000f, 0.085704f, 1.749936f },
  { 0.070237f, 0.085704f, 1.749936f }, { -0.060334f, 0.096672f, 1.80249f },
  { 0.000000f, 0.096672f, 1.80249f }, { 0.060334f, 0.096672f, 1.80249f },
  { -0.105099f, 0.080751f, 1.889016f }, { 0.008727f, 0.231903f, 1.844883f },
  { 0.105098f, 0.080751f, 1.889016f }, { -0.098119f, 0.080751f, 1.955367f },
  { -0.008145f, 0.231903f, 1.85692f }, { 0.000000f, 0.231903f, 1.857545f },
  { 0.008145f, 0.231903f, 1.85692f }, { 0.098119f, 0.080751f, 1.955367f },
  { -0.04831f, 0.080751f, 2.031727f }, { 0.000000f, 0.080751f, 2.04623f },
  { 0.048309f, 0.080751f, 2.031727f }, { 0.087244f, 0.080751f, 2.000605f },
  { -0.070238f, -0.058918f, 1.749936f }, { 0.000000f, -0.048466f, 1.749936f },
  { 0.070237f, -0.058918f, 1.749936f }, { 0.12075f, -0.102849f, 1.754623f },
  { 0.000000f, -0.04739f, 1.810873f }, { 0.000000f, -0.04739f, 1.885873f },
  { 0.054375f, -0.057841f, 1.885873f }, { 0.000000f, -0.057841f, 1.964769f },
  { -0.05f, -0.109458f, 2.019593f }, { 0.05f, -0.109458f, 2.019593f },
  { -0.126863f, 0.027262f, 1.749936f }, { 0.126862f, 0.027262f, 1.749936f },
  { 0.122475f, 0.023258f, 1.810873f }, { 0.10875f, 0.023258f, 1.885873f },
  { 0.1015f, 0.023258f, 1.954759f }, { 0.05f, 0.023258f, 2.033656f },
  { 0.000000f, 0.023258f, 2.048861f }, { -0.05f, 0.023258f, 2.033656f },
  { -0.1015f, 0.023258f, 1.954759f }, { -0.10875f, 0.023258f, 1.885873f },
  { -0.122475f, 0.023258f, 1.810873f }, { -0.126863f, -0.029285f, 1.749936f },
  { 0.126862f, -0.029285f, 1.749936f }, { 0.122475f, -0.029285f, 1.810873f },
  { 0.10875f, -0.029285f, 1.885873f }, { 0.1015f, -0.029285f, 1.954759f },
  { 0.05f, -0.029285f, 2.033656f }, { 0.000000f, -0.029285f, 2.048861f },
  { -0.05f, -0.029285f, 2.033656f }, { -0.090625f, -0.029285f, 2.001431f },
  { -0.1015f, -0.029285f, 1.954759f }, { -0.10875f, -0.029285f, 1.885873f },
  { -0.122475f, -0.029285f, 1.810873f }, { -0.126863f, -0.079285f, 1.749936f },
  { 0.126862f, -0.079285f, 1.749936f }, { 0.122475f, -0.079285f, 1.810873f },
  { 0.10875f, -0.079285f, 1.885873f }, { 0.1015f, -0.079285f, 1.954759f },
  { 0.05f, -0.079285f, 2.033656f }, { 0.000000f, -0.079285f, 2.048861f },
  { -0.05f, -0.079285f, 2.033656f }, { -0.1015f, -0.079285f, 1.954759f },
  { -0.10875f, -0.079285f, 1.885873f }, { -0.122475f, -0.079285f, 1.810873f },
  { -0.082516f, 0.130552f, 1.849411f }, { 0.082515f, 0.130552f, 1.849411f },
  { -0.084838f, 0.130552f, 1.896373f }, { 0.084837f, 0.130552f, 1.896373f },
  { -0.079214f, 0.130552f, 1.949849f }, { 0.079213f, 0.130552f, 1.949849f },
  { -0.027036f, 0.181364f, 1.847609f }, { 0.000000f, 0.181364f, 1.847609f },
  { 0.027036f, 0.181364f, 1.847609f }, { -0.048985f, 0.181364f, 1.881404f },
  { 0.048985f, 0.181364f, 1.881404f }, { -0.045701f, 0.181364f, 1.912589f },
  { 0.0457f, 0.181364f, 1.912589f }, { -0.041058f, 0.181364f, 1.933518f },
  { -0.02253f, 0.181364f, 1.948048f }, { 0.000000f, 0.181364f, 1.955031f },
  { 0.02253f, 0.181364f, 1.948048f }, { 0.041058f, 0.181364f, 1.933518f },
  { -0.012446f, 0.222528f, 1.839064f }, { 0.000000f, 0.222528f, 1.839064f },
  { 0.012446f, 0.222528f, 1.839064f }, { -0.020704f, 0.219403f, 1.881427f },
  { -0.010523f, 0.222528f, 1.881545f }, { 0.000000f, 0.222528f, 1.884398f },
  { 0.010522f, 0.222528f, 1.881545f }, { -0.008727f, 0.231903f, 1.844883f },
  { 0.024363f, 0.219403f, 1.841137f }, { 0.000000f, 0.231903f, 1.844883f },
  { -0.061238f, -0.057841f, 1.810873f }, { 0.061237f, -0.057841f, 1.810873f },
  { -0.054375f, -0.057841f, 1.885873f }, { 0.05075f, -0.068293f, 1.960873f },
  { -0.0875f, -0.116785f, 2.00082f }, { -0.05075f, -0.068293f, 1.960873f },
  { 0.0875f, -0.116785f, 2.00082f }, { 0.12075f, 0.079063f, 1.754623f },
  { 0.111225f, -0.109458f, 1.810873f }, { 0.098625f, -0.109458f, 1.885873f },
  { 0.092125f, -0.109458f, 1.954759f }, { 0.090625f, 0.023258f, 2.001431f },
  { 0.090625f, -0.079285f, 2.001431f }, { 0.090625f, -0.029285f, 2.001431f },
  { 0.000000f, -0.109458f, 2.030902f }, { -0.087244f, 0.080751f, 2.000605f },
  { -0.12075f, 0.079063f, 1.754623f }, { -0.109734f, 0.084659f, 1.815416f },
  { -0.090625f, 0.023258f, 2.001431f }, { -0.090625f, -0.079285f, 2.001431f },
  { -0.098625f, -0.109458f, 1.885873f }, { -0.092125f, -0.109458f, 1.954759f },
  { -0.111225f, -0.109458f, 1.810873f }, { -0.12075f, -0.102849f, 1.754623f },
  { 0.109734f, 0.084659f, 1.815416f }, { -0.048309f, 0.181364f, 1.853612f },
  { 0.000000f, 0.130552f, 1.837884f }, { -0.046791f, 0.130552f, 1.837884f },
  { 0.04679f, 0.130552f, 1.837884f }, { -0.0703f, 0.130552f, 1.986416f },
  { -0.038992f, 0.130552f, 2.011531f }, { 0.000000f, 0.130552f, 2.023167f },
  { 0.038992f, 0.130552f, 2.011531f }, { 0.0703f, 0.130552f, 1.986416f },
  { -0.021224f, 0.222528f, 1.852591f }, { -0.024363f, 0.219403f, 1.841137f },
  { 0.048309f, 0.181364f, 1.853612f }, { 0.021223f, 0.222528f, 1.852591f },
  { -0.019781f, 0.222528f, 1.867393f }, { 0.019781f, 0.222528f, 1.867393f },
  { 0.020703f, 0.219403f, 1.881427f }, { 0.05614f, -0.113848f, 1.020257f },
  { 0.074812f, -0.109944f, 1.026268f }, { 0.05614f, -0.232462f, 0.874329f },
  { 0.07614f, -0.130621f, 1.03115f }, { -0.148937f, 0.097909f, 1.039101f },
  { -0.148937f, 0.097909f, 1.019101f }, { -0.16505f, 0.113942f, 1.019101f },
  { -0.109821f, 0.109698f, 1.039101f }, { -0.109821f, 0.109698f, 1.019101f },
  { 0.109821f, 0.109698f, 1.039101f }, { 0.109821f, 0.109698f, 1.019101f },
  { 0.148937f, 0.097909f, 1.039101f }, { 0.148937f, 0.097909f, 1.019101f },
  { 0.160649f, 0.058339f, 1.039101f }, { 0.160649f, 0.058339f, 1.019101f },
  { 0.160649f, -0.058585f, 1.039101f }, { 0.160649f, -0.058585f, 1.019101f },
  { 0.165049f, -0.114188f, 1.039101f }, { 0.148937f, -0.098155f, 1.039101f },
  { 0.148937f, -0.098155f, 1.019101f }, { 0.109821f, -0.109944f, 1.039101f },
  { 0.109821f, -0.109944f, 1.019101f }, { -0.112769f, -0.129944f, 1.039101f },
  { -0.109821f, -0.109944f, 1.039101f }, { -0.109821f, -0.109944f, 1.019101f },
  { -0.112769f, -0.129944f, 1.019101f }, { -0.16505f, -0.114188f, 1.039101f },
  { -0.148937f, -0.098155f, 1.039101f }, { -0.148937f, -0.098155f, 1.019101f },
  { -0.160649f, -0.058585f, 1.039101f }, { -0.160649f, -0.058585f, 1.019101f },
  { -0.180649f, -0.061482f, 1.019101f }, { -0.160649f, 0.058339f, 1.039101f },
  { -0.160649f, 0.058339f, 1.019101f }, { 0.123151f, -0.225698f, 0.884745f },
  { 0.074812f, -0.126718f, 1.037161f }, { 0.141822f, -0.221794f, 0.890756f },
  { 0.141822f, -0.205021f, 0.879863f }, { 0.123151f, -0.208924f, 0.873852f },
  { 0.05614f, -0.130621f, 1.03115f }, { 0.07614f, -0.232462f, 0.874329f },
  { 0.07614f, -0.215688f, 0.863436f }, { 0.07614f, -0.113848f, 1.020257f },
  { 0.05614f, -0.215688f, 0.863436f }, { -0.11277f, 0.129698f, 1.039101f },
  { -0.11277f, 0.129698f, 1.019101f }, { 0.112769f, 0.129698f, 1.019101f },
  { 0.112769f, 0.129698f, 1.039101f }, { 0.165049f, 0.113942f, 1.039101f },
  { 0.180649f, 0.061236f, 1.039101f }, { 0.165049f, 0.113942f, 1.019101f },
  { 0.180649f, -0.061483f, 1.019101f }, { 0.180649f, 0.061236f, 1.019101f },
  { 0.180649f, -0.061483f, 1.039101f }, { 0.165049f, -0.114188f, 1.019101f },
  { 0.112769f, -0.129944f, 1.039101f }, { 0.112769f, -0.129944f, 1.019101f },
  { -0.16505f, -0.114188f, 1.019101f }, { -0.180649f, -0.061482f, 1.039101f },
  { -0.180649f, 0.061237f, 1.019101f }, { -0.180649f, 0.061237f, 1.039101f },
  { -0.16505f, 0.113942f, 1.039101f }, { 0.000000f, -0.169413f, 1.349213f },
  { 0.149603f, -0.169413f, 1.406816f }, { -0.14781f, -0.180646f, 1.514073f },
  { 0.000000f, -0.180646f, 1.496308f }, { 0.147809f, -0.180646f, 1.514073f },
  { 0.301061f, -0.169413f, 1.549228f }, { -0.132619f, -0.173733f, 1.624228f },
  { 0.000000f, -0.173733f, 1.624228f }, { 0.132618f, -0.173733f, 1.624228f },
  { 0.269995f, -0.162932f, 1.630305f }, { -0.106058f, -0.155217f, 1.705305f },
  { 0.000000f, -0.155217f, 1.705305f }, { 0.106057f, -0.155217f, 1.705305f },
  { 0.210912f, -0.145573f, 1.705305f }, { 0.000000f, -0.11482f, 1.757481f },
  { 0.095813f, -0.11482f, 1.757481f }, { -0.297491f, 0.163836f, 1.478338f },
  { -0.149603f, 0.16758f, 1.406816f }, { 0.149603f, 0.16758f, 1.406816f },
  { -0.14781f, 0.178813f, 1.514073f }, { 0.000000f, 0.178813f, 1.496308f },
  { 0.147809f, 0.178813f, 1.514073f }, { -0.132619f, 0.171901f, 1.624228f },
  { 0.000000f, 0.171901f, 1.624228f }, { 0.132618f, 0.171901f, 1.624228f },
  { -0.106058f, 0.153384f, 1.705305f }, { 0.000000f, 0.153384f, 1.705305f },
  { 0.106057f, 0.153384f, 1.705305f }, { 0.210912f, 0.143741f, 1.705305f },
  { -0.095813f, 0.112987f, 1.757481f }, { 0.095813f, 0.112987f, 1.757481f },
  { -0.149603f, -0.090781f, 1.392667f }, { 0.000000f, -0.090781f, 1.323377f },
  { 0.149603f, -0.090781f, 1.392667f }, { 0.323965f, -0.090781f, 1.555305f },
  { 0.226544f, -0.078067f, 1.705305f }, { 0.170501f, -0.061665f, 1.757481f },
  { 0.095813f, -0.061665f, 1.766856f }, { 0.000000f, -0.061665f, 1.766856f },
  { -0.095813f, -0.061665f, 1.766856f }, { -0.170501f, -0.061665f, 1.757481f },
  { -0.226544f, -0.078067f, 1.705305f }, { -0.323965f, -0.090781f, 1.555305f },
  { -0.149603f, -0.000916f, 1.392667f }, { 0.149603f, -0.000916f, 1.392667f },
  { 0.323965f, -0.000916f, 1.555305f }, { 0.226544f, -0.000916f, 1.705305f },
  { 0.170501f, -0.000916f, 1.757481f }, { 0.095813f, -0.000916f, 1.766856f },
  { 0.000000f, -0.000916f, 1.766856f }, { -0.095813f, -0.000916f, 1.766856f },
  { -0.170501f, -0.000916f, 1.757481f }, { -0.226544f, -0.000916f, 1.705305f },
  { -0.323965f, -0.000916f, 1.555305f }, { -0.149603f, 0.088948f, 1.392667f },
  { 0.000000f, 0.088948f, 1.323377f }, { 0.149603f, 0.088948f, 1.392667f },
  { 0.305125f, 0.088948f, 1.47883f }, { 0.323965f, 0.088948f, 1.555305f },
  { 0.290629f, 0.085492f, 1.630305f }, { 0.226544f, 0.076234f, 1.705305f },
  { 0.170501f, 0.059832f, 1.757481f }, { 0.095813f, 0.059832f, 1.766856f },
  { 0.000000f, 0.059832f, 1.766856f }, { -0.095813f, 0.059832f, 1.766856f },
  { -0.170501f, 0.059832f, 1.757481f }, { -0.226544f, 0.076234f, 1.705305f },
  { -0.323965f, 0.088948f, 1.555305f }, { -0.149603f, -0.169413f, 1.406816f },
  { 0.000000f, 0.16758f, 1.349213f }, { 0.29749f, 0.163836f, 1.478338f },
  { 0.29749f, -0.165669f, 1.478338f }, { 0.305125f, -0.090781f, 1.47883f },
  { 0.169484f, -0.112288f, 1.754356f }, { 0.290629f, -0.087325f, 1.630305f },
  { 0.305125f, -0.000916f, 1.47883f }, { 0.290629f, -0.000916f, 1.630305f },
  { 0.301061f, 0.16758f, 1.549228f }, { 0.269995f, 0.1611f, 1.630305f },
  { -0.095813f, -0.11482f, 1.757481f }, { 0.169484f, 0.110456f, 1.754356f },
  { 0.000000f, 0.112987f, 1.757481f }, { -0.169485f, 0.110456f, 1.754356f },
  { -0.169485f, -0.112288f, 1.754356f }, { -0.210912f, -0.145573f, 1.705305f },
  { -0.301062f, -0.169413f, 1.549228f }, { -0.269996f, -0.162932f, 1.630305f },
  { -0.297491f, -0.165669f, 1.478338f }, { -0.29063f, -0.087325f, 1.630305f },
  { -0.305125f, -0.090781f, 1.47883f }, { -0.305125f, -0.000916f, 1.47883f },
  { -0.29063f, -0.000916f, 1.630305f }, { -0.305125f, 0.088948f, 1.47883f },
  { -0.210912f, 0.143741f, 1.705305f }, { -0.269996f, 0.1611f, 1.630305f },
  { -0.29063f, 0.085492f, 1.630305f }, { -0.301062f, 0.16758f, 1.549228f },
  { 0.352677f, -0.227075f, 0.000000f }, { 0.117438f, -0.260577f, 0.000000f },
  { 0.000000f, -0.25678f, 0.000000f }, { 0.241885f, -0.244806f, 0.133606f },
  { 0.122792f, -0.244998f, 0.13332f }, { 0.000000f, -0.238763f, 0.142558f },
  { 0.328034f, -0.210503f, 0.361295f }, { 0.237591f, -0.242438f, 0.360249f },
  { 0.113851f, -0.242008f, 0.36049f }, { 0.000000f, -0.228829f, 0.367886f },
  { 0.212275f, -0.232544f, 0.609977f }, { 0.100555f, -0.229576f, 0.608526f },
  { 0.000000f, -0.215424f, 0.601607f }, { 0.066377f, -0.162145f, 0.883871f },
  { 0.000000f, -0.158535f, 0.875242f }, { 0.045976f, -0.119161f, 0.977613f },
  { 0.000000f, -0.118069f, 0.971819f }, { 0.156993f, -0.106048f, 1.062421f },
  { 0.111295f, -0.119821f, 1.062421f }, { 0.041948f, -0.119821f, 1.062421f },
  { 0.000000f, -0.119821f, 1.062421f }, { 0.138829f, -0.153745f, 1.257706f },
  { 0.056074f, -0.153745f, 1.257706f }, { 0.000000f, -0.153745f, 1.257706f },
  { 0.147432f, -0.1644f, 1.432073f }, { 0.058941f, -0.1644f, 1.432073f },
  { 0.000000f, -0.1644f, 1.432073f }, { 0.2138f, -0.14385f, 1.592073f },
  { 0.147432f, -0.1644f, 1.592073f }, { 0.058941f, -0.1644f, 1.592073f },
  { 0.000000f, -0.1644f, 1.592073f }, { 0.000000f, 0.25678f, 0.000000f },
  { 0.241885f, 0.244806f, 0.133605f }, { 0.122792f, 0.244999f, 0.13332f },
  { 0.000000f, 0.238763f, 0.142558f }, { 0.237591f, 0.242438f, 0.360249f },
  { 0.113851f, 0.242008f, 0.36049f }, { 0.000000f, 0.22883f, 0.367886f },
  { 0.212275f, 0.232544f, 0.609977f }, { 0.100555f, 0.229577f, 0.608526f },
  { 0.000000f, 0.215424f, 0.601607f }, { 0.066377f, 0.162145f, 0.883871f },
  { 0.000000f, 0.158535f, 0.875242f }, { 0.11403f, 0.120486f, 0.984643f },
  { 0.045976f, 0.119161f, 0.977613f }, { 0.000000f, 0.11807f, 0.971819f },
  { 0.111295f, 0.119821f, 1.062421f }, { 0.041948f, 0.119821f, 1.062421f },
  { 0.000000f, 0.119821f, 1.062421f }, { 0.138829f, 0.153746f, 1.257706f },
  { 0.056074f, 0.153746f, 1.257706f }, { 0.000000f, 0.153746f, 1.257706f },
  { 0.2138f, 0.143851f, 1.432073f }, { 0.147432f, 0.164401f, 1.432073f },
  { 0.058941f, 0.164401f, 1.432073f }, { 0.000000f, 0.164401f, 1.432073f },
  { 0.2138f, 0.143851f, 1.592073f }, { 0.147432f, 0.164401f, 1.592073f },
  { 0.058941f, 0.164401f, 1.592073f }, { 0.000000f, 0.164401f, 1.592073f },
  { 0.379773f, -0.131524f, 0.000000f }, { 0.115541f, -0.134273f, 0.342403f },
  { 0.000000f, -0.131524f, 0.342403f }, { 0.235923f, -0.0822f, 1.592073f },
  { 0.235923f, -0.0822f, 1.432073f }, { 0.221584f, -0.076872f, 1.257706f },
  { 0.170649f, -0.05991f, 1.062421f }, { 0.238879f, -0.084986f, 0.90258f },
  { 0.328235f, -0.128737f, 0.622164f }, { 0.363896f, -0.128307f, 0.352294f },
  { 0.362498f, -0.124722f, 0.126733f }, { 0.251682f, 0.0f, 0.342403f },
  { 0.235923f, 0.000000f, 1.592073f }, { 0.235923f, 0.000000f, 1.432073f },
  { 0.221584f, 0.000000f, 1.257706f }, { 0.170649f, 0.000000f, 1.062421f },
  { 0.344946f, 0.000000f, 0.63627f }, { 0.376588f, 0.000000f, 0.342403f },
  { 0.366315f, 0.0f, 0.119041f }, { 0.379773f, 0.131524f, 0.000000f },
  { 0.115541f, 0.134273f, 0.342403f }, { 0.000000f, 0.131524f, 0.342403f },
  { 0.235923f, 0.082201f, 1.592073f }, { 0.235923f, 0.082201f, 1.432073f },
  { 0.221584f, 0.076873f, 1.257706f }, { 0.170649f, 0.059911f, 1.062421f },
  { 0.328235f, 0.128737f, 0.622164f }, { 0.363896f, 0.128307f, 0.352294f },
  { 0.362498f, 0.124723f, 0.126733f }, { -0.335816f, -0.212787f, 0.136008f },
  { -0.241885f, -0.244806f, 0.133606f }, { -0.122792f, -0.244999f, 0.133321f },
  { -0.237591f, -0.242438f, 0.360249f }, { -0.113851f, -0.242008f, 0.360491f },
  { -0.212275f, -0.232544f, 0.609977f }, { -0.100555f, -0.229576f, 0.608526f },
  { -0.150816f, -0.164685f, 0.889942f }, { -0.066377f, -0.162145f, 0.883871f },
  { -0.114031f, -0.120486f, 0.984643f }, { -0.045977f, -0.119161f, 0.977613f },
  { -0.111295f, -0.119821f, 1.062421f }, { -0.041949f, -0.119821f, 1.062421f },
  { -0.138829f, -0.153745f, 1.257706f }, { -0.056074f, -0.153745f, 1.257706f },
  { -0.147432f, -0.1644f, 1.432073f }, { -0.058942f, -0.1644f, 1.432073f },
  { -0.147432f, -0.1644f, 1.592073f }, { -0.058942f, -0.1644f, 1.592073f },
  { -0.241885f, 0.244806f, 0.133606f }, { -0.122792f, 0.244999f, 0.13332f },
  { -0.237591f, 0.242438f, 0.360249f }, { -0.113851f, 0.242008f, 0.36049f },
  { -0.212275f, 0.232544f, 0.609977f }, { -0.100555f, 0.229577f, 0.608526f },
  { -0.066377f, 0.162146f, 0.883871f }, { -0.156757f, 0.10413f, 0.988432f },
  { -0.045977f, 0.119162f, 0.977613f }, { -0.156993f, 0.106049f, 1.062421f },
  { -0.111295f, 0.119821f, 1.062421f }, { -0.041949f, 0.119821f, 1.062421f },
  { -0.199462f, 0.133195f, 1.257706f }, { -0.138829f, 0.153746f, 1.257706f },
  { -0.056074f, 0.153746f, 1.257706f }, { -0.2138f, 0.143851f, 1.432073f },
  { -0.147432f, 0.164401f, 1.432073f }, { -0.058942f, 0.164401f, 1.432073f },
  { -0.147432f, 0.164401f, 1.592073f }, { -0.058942f, 0.164401f, 1.592073f },
  { -0.379773f, -0.131524f, 0.000000f }, { -0.115541f, -0.134273f, 0.342403f },
  { -0.235923f, -0.0822f, 1.592073f }, { -0.235923f, -0.0822f, 1.432073f },
  { -0.221584f, -0.076872f, 1.257706f }, { -0.170649f, -0.05991f, 1.062421f },
  { -0.173652f, -0.060943f, 0.992076f }, { -0.328236f, -0.128737f, 0.622164f },
  { -0.363896f, -0.128307f, 0.352294f }, { -0.362498f, -0.124722f, 0.126733f },
  { -0.251682f, 0.0f, 0.342403f }, { -0.235923f, 0.000000f, 1.592073f },
  { -0.235923f, 0.000000f, 1.432073f }, { -0.221584f, 0.000000f, 1.257706f },
  { -0.170649f, 0.000000f, 1.062421f }, { -0.344946f, 0.000000f, 0.63627f },
  { -0.376588f, 0.0f, 0.342403f }, { -0.366316f, 0.0f, 0.119041f },
  { -0.115541f, 0.134273f, 0.342403f }, { -0.235923f, 0.082201f, 1.592073f },
  { -0.235923f, 0.082201f, 1.432073f }, { -0.221584f, 0.076873f, 1.257706f },
  { -0.170649f, 0.059911f, 1.062421f }, { -0.328236f, 0.128737f, 0.622164f },
  { -0.363896f, 0.128307f, 0.352294f }, { -0.362498f, 0.124722f, 0.126733f },
  { 0.150816f, -0.164685f, 0.889942f }, { 0.214332f, -0.14413f, 0.893963f },
  { 0.156757f, -0.104129f, 0.988432f }, { 0.11403f, -0.120486f, 0.984643f },
  { 0.150816f, 0.164685f, 0.889942f }, { 0.156757f, 0.10413f, 0.988432f },
  { 0.248653f, -0.260466f, 0.000000f }, { 0.250754f, -0.13419f, 0.342403f },
  { 0.352677f, 0.227075f, 0.0f }, { 0.248653f, 0.260466f, 0.000000f },
  { 0.250754f, 0.13419f, 0.342403f }, { 0.117438f, 0.260577f, 0.000000f },
  { 0.2138f, -0.14385f, 1.432073f }, { 0.199461f, -0.133195f, 1.257706f },
  { 0.289359f, -0.20523f, 0.610957f }, { 0.335815f, -0.212787f, 0.136008f },
  { 0.173636f, 0.000000f, 0.993888f }, { 0.173652f, -0.060943f, 0.992076f },
  { 0.173652f, 0.060943f, 0.992076f }, { 0.239764f, 0.000000f, 0.908592f },
  { 0.238879f, 0.084986f, 0.90258f }, { 0.381792f, 0.0f, 0.000000f },
  { 0.199461f, 0.133195f, 1.257706f }, { 0.156993f, 0.106049f, 1.062421f },
  { 0.214332f, 0.14413f, 0.893963f }, { 0.289359f, 0.20523f, 0.610957f },
  { 0.328034f, 0.210503f, 0.361294f }, { 0.335815f, 0.212787f, 0.136007f },
  { -0.156757f, -0.104129f, 0.988432f }, { -0.150816f, 0.164685f, 0.889942f },
  { -0.214332f, 0.14413f, 0.893963f }, { -0.114031f, 0.120486f, 0.984643f },
  { -0.352677f, -0.227075f, 0.000000f }, { -0.248653f, -0.260466f, 0.000001f },
  { -0.117438f, -0.260577f, 0.000001f }, { -0.250755f, -0.13419f, 0.342403f },
  { -0.250755f, 0.13419f, 0.342403f }, { -0.248653f, 0.260466f, 0.000000f },
  { -0.352677f, 0.227075f, 0.0f }, { -0.117438f, 0.260577f, 0.000000f },
  { -0.2138f, -0.14385f, 1.592073f }, { -0.199462f, -0.133195f, 1.257706f },
  { -0.2138f, -0.14385f, 1.432073f }, { -0.156993f, -0.106048f, 1.062421f },
  { -0.214332f, -0.14413f, 0.893963f }, { -0.289359f, -0.20523f, 0.610957f },
  { -0.328034f, -0.210503f, 0.361295f }, { -0.23888f, -0.084986f, 0.90258f },
  { -0.381792f, 0.0f, 0.000000f }, { -0.173652f, 0.060943f, 0.992076f },
  { -0.173637f, 0.000000f, 0.993889f }, { -0.239764f, 0.000000f, 0.908592f },
  { -0.2138f, 0.143851f, 1.592073f }, { -0.23888f, 0.084986f, 0.90258f },
  { -0.289359f, 0.20523f, 0.610957f }, { -0.328034f, 0.210503f, 0.361295f },
  { -0.335816f, 0.212787f, 0.136007f }, { -0.379773f, 0.131524f, 0.000000f }
};


TEST_UV Greenmonk_uv[772] = {
  { 0.0f, 0.0f }, { 0.043074f, 0.352082f }, { 0.043074f, 0.449285f },
  { 0.043074f, 0.535235f }, { 0.051131f, 0.263036f }, { 0.051131f, 0.575742f },
  { 0.051131f, 0.575742f }, { 0.092431f, 0.051131f }, { 0.092431f, 0.051131f },
  { 0.111367f, 0.155635f }, { 0.124605f, 0.449285f }, { 0.124605f, 0.535235f },
  { 0.124605f, 0.358963f }, { 0.125657f, 0.599697f }, { 0.125657f, 0.599697f },
  { 0.126025f, 0.260134f }, { 0.144215f, 0.358963f }, { 0.144215f, 0.449285f },
  { 0.144215f, 0.535235f }, { 0.147825f, 0.358963f }, { 0.147825f, 0.449285f },
  { 0.147825f, 0.535235f }, { 0.147825f, 0.587103f }, { 0.147825f, 0.498374f },
  { 0.147825f, 0.587103f }, { 0.149587f, 0.599697f }, { 0.149588f, 0.474343f },
  { 0.150028f, 0.260134f }, { 0.150416f, 0.174525f }, { 0.155635f, 0.253416f },
  { 0.158156f, 0.174525f }, { 0.179155f, 0.174525f }, { 0.179155f, 0.449584f },
  { 0.179262f, 0.043074f }, { 0.179262f, 0.043074f }, { 0.194325f, 0.51634f },
  { 0.194733f, 0.147825f }, { 0.196286f, 0.133414f }, { 0.199848f, 0.02179f },
  { 0.20379f, 0.260134f }, { 0.204834f, 0.358963f }, { 0.204834f, 0.449285f },
  { 0.204834f, 0.535235f }, { 0.204834f, 0.587103f }, { 0.204834f, 0.587103f },
  { 0.206529f, 0.27675f }, { 0.212761f, 0.405675f }, { 0.213275f, 0.174525f },
  { 0.21405f, 0.358963f }, { 0.21405f, 0.449285f }, { 0.21405f, 0.535235f },
  { 0.21405f, 0.587103f }, { 0.21405f, 0.506615f }, { 0.214072f, 0.174525f },
  { 0.216956f, 0.260134f }, { 0.216957f, 0.087179f }, { 0.219538f, 0.016418f },
  { 0.219567f, 0.194258f }, { 0.219567f, 0.174525f }, { 0.221294f, 0.087179f },
  { 0.229422f, 0.358652f }, { 0.232973f, 0.174525f }, { 0.232973f, 0.492756f },
  { 0.241348f, 0.087179f }, { 0.244983f, 0.016418f }, { 0.253525f, 0.087179f },
  { 0.25812f, 0.199848f }, { 0.25812f, 0.02179f }, { 0.261271f, 0.383628f },
  { 0.262992f, 0.653449f }, { 0.262992f, 0.8f }, { 0.262992f, 0.946551f },
  { 0.263517f, 0.219538f }, { 0.26441f, 0.269107f }, { 0.265997f, 0.244983f },
  { 0.269068f, 0.087179f }, { 0.269107f, 0.02179f }, { 0.270144f, 0.808035f },
  { 0.270144f, 0.808035f }, { 0.276429f, 0.669515f }, { 0.276429f, 1.068676f },
  { 0.276429f, 0.531324f }, { 0.276429f, 0.669515f }, { 0.27675f, 0.358963f },
  { 0.27675f, 0.449285f }, { 0.27675f, 0.535235f }, { 0.27675f, 0.587103f },
  { 0.27675f, 0.498374f }, { 0.27675f, 0.587103f }, { 0.277325f, 0.087179f },
  { 0.278605f, 0.016418f }, { 0.281912f, 0.26931f }, { 0.282153f, 0.260134f },
  { 0.284999f, 0.206288f }, { 0.284999f, 0.000303f }, { 0.285999f, 0.22698f },
  { 0.288504f, 0.659086f }, { 0.288504f, 0.8f }, { 0.288504f, 0.940914f },
  { 0.294799f, 0.174525f }, { 0.3f, 0.174525f }, { 0.3f, 0.260134f },
  { 0.3f, 0.358963f }, { 0.3f, 0.449285f }, { 0.3f, 0.512758f },
  { 0.3f, 0.535235f }, { 0.3f, 0.587103f }, { 0.3f, 0.274214f },
  { 0.3f, 0.395633f }, { 0.3f, 0.133414f }, { 0.3f, 0.194258f },
  { 0.3f, 0.206288f }, { 0.3f, 0.228055f }, { 0.3f, 0.043074f },
  { 0.3f, 0.000303f }, { 0.3f, 0.016418f }, { 0.3f, 0.087179f },
  { 0.3f, 0.147825f }, { 0.3f, 0.174525f }, { 0.3f, 0.27675f },
  { 0.3f, 0.412373f }, { 0.3f, 0.526055f }, { 0.305201f, 0.174525f },
  { 0.314001f, 0.22698f }, { 0.315001f, 0.206288f }, { 0.315001f, 0.000303f },
  { 0.317847f, 0.260134f }, { 0.318088f, 0.26931f }, { 0.321395f, 0.016418f },
  { 0.322675f, 0.087179f }, { 0.32325f, 0.358963f }, { 0.32325f, 0.449285f },
  { 0.32325f, 0.535235f }, { 0.32325f, 0.587103f }, { 0.32325f, 0.498374f },
  { 0.32325f, 0.587103f }, { 0.324819f, 0.535786f }, { 0.324819f, 0.966458f },
  { 0.324819f, 0.966459f }, { 0.324819f, 1.064214f }, { 0.330893f, 0.02179f },
  { 0.330932f, 0.087179f }, { 0.334003f, 0.244983f }, { 0.33559f, 0.269107f },
  { 0.336483f, 0.219538f }, { 0.338729f, 0.383628f }, { 0.34188f, 0.199848f },
  { 0.34188f, 0.02179f }, { 0.346475f, 0.087179f }, { 0.355017f, 0.016418f },
  { 0.358652f, 0.087179f }, { 0.367027f, 0.174525f }, { 0.367027f, 0.492756f },
  { 0.370578f, 0.358652f }, { 0.378706f, 0.087179f }, { 0.380433f, 0.194258f },
  { 0.380433f, 0.174525f }, { 0.380462f, 0.016418f }, { 0.383043f, 0.087179f },
  { 0.383044f, 0.260134f }, { 0.385928f, 0.174525f }, { 0.38595f, 0.358963f },
  { 0.38595f, 0.449285f }, { 0.38595f, 0.535235f }, { 0.38595f, 0.587103f },
  { 0.38595f, 0.506615f }, { 0.386725f, 0.174525f }, { 0.387239f, 0.405675f },
  { 0.393471f, 0.27675f }, { 0.395166f, 0.358963f }, { 0.395166f, 0.449285f },
  { 0.395166f, 0.535235f }, { 0.395166f, 0.587103f }, { 0.395166f, 0.587103f },
  { 0.39621f, 0.260134f }, { 0.400152f, 0.02179f }, { 0.401292f, 0.674184f },
  { 0.401292f, 0.8f }, { 0.401292f, 0.925816f }, { 0.403714f, 0.133414f },
  { 0.405267f, 0.147825f }, { 0.405675f, 0.51634f }, { 0.420738f, 0.043074f },
  { 0.420738f, 0.043074f }, { 0.420845f, 0.174525f }, { 0.420845f, 0.449584f },
  { 0.428803f, 1.035905f }, { 0.428804f, 0.564095f }, { 0.428804f, 1.113009f },
  { 0.428804f, 1.113009f }, { 0.441844f, 0.214072f }, { 0.441844f, 0.174525f },
  { 0.444365f, 0.253416f }, { 0.449584f, 0.174525f }, { 0.449972f, 0.260134f },
  { 0.450412f, 0.599697f }, { 0.450413f, 0.474343f }, { 0.452175f, 0.358963f },
  { 0.452175f, 0.587103f }, { 0.452175f, 0.449285f }, { 0.452175f, 0.498374f },
  { 0.452175f, 0.535235f }, { 0.452175f, 0.587103f }, { 0.455784f, 0.358963f },
  { 0.455784f, 0.449285f }, { 0.455784f, 0.535235f }, { 0.473975f, 0.260134f },
  { 0.474343f, 0.599697f }, { 0.474343f, 0.599697f }, { 0.475395f, 0.358963f },
  { 0.475395f, 0.449285f }, { 0.475395f, 0.535235f }, { 0.488633f, 0.155635f },
  { 0.488633f, 0.253416f }, { 0.491196f, 0.147825f }, { 0.499925f, 0.899068f },
  { 0.499925f, 0.700932f }, { 0.499925f, 0.8f }, { 0.501714f, 0.618376f },
  { 0.501714f, 1.208856f }, { 0.501714f, 0.981624f }, { 0.501715f, 1.208856f },
  { 0.507569f, 0.051131f }, { 0.507569f, 0.051131f }, { 0.536704f, 0.8f },
  { 0.536704f, 0.946551f }, { 0.536704f, 0.529759f }, { 0.536704f, 1.074782f },
  { 0.536704f, 0.525218f }, { 0.536704f, 0.653449f }, { 0.536705f, 0.529759f },
  { 0.539861f, 0.739341f }, { 0.539861f, 0.739341f }, { 0.548869f, 0.263036f },
  { 0.548869f, 0.575742f }, { 0.556926f, 0.352082f }, { 0.556926f, 0.449285f },
  { 0.556926f, 0.535235f }, { 0.556926f, 0.500224f }, { 0.566597f, 0.954585f },
  { 0.566597f, 0.954585f }, { 0.609219f, 1.1f }, { 0.613343f, 1.113009f },
  { 0.613344f, 1.113009f }, { 0.615365f, 1.025f }, { 0.615365f, 1.175f },
  { 0.627656f, 1.1f }, { 0.631373f, 0.614248f }, { 0.631373f, 0.700932f },
  { 0.631373f, 0.8f }, { 0.631373f, 0.899068f }, { 0.631373f, 0.985752f },
  { 0.631373f, 1.214962f }, { 0.631373f, 1.214963f }, { 0.633541f, 0.535786f },
  { 0.633541f, 0.659086f }, { 0.633541f, 0.8f }, { 0.633541f, 0.940914f },
  { 0.633541f, 1.064214f }, { 0.633802f, 1.025f }, { 0.633802f, 1.175f },
  { 0.669515f, 0.531324f }, { 0.669515f, 1.068676f }, { 0.670475f, 0.653449f },
  { 0.670475f, 0.8f }, { 0.670475f, 0.946551f }, { 0.671332f, 1.543845f },
  { 0.671333f, 1.711028f }, { 0.671333f, 1.834873f }, { 0.671333f, 2.0f },
  { 0.671333f, 2.0f }, { 0.671333f, 2.165127f }, { 0.671333f, 1.73579f },
  { 0.671333f, 2.288972f }, { 0.671333f, 1.543845f }, { 0.671333f, 2.26421f },
  { 0.671333f, 2.456155f }, { 0.671333f, 2.0f }, { 0.671333f, 1.73579f },
  { 0.671333f, 2.456155f }, { 0.671333f, 2.26421f }, { 0.687941f, 1.177419f },
  { 0.689115f, 0.928588f }, { 0.689115f, 1.292424f }, { 0.690522f, 1.177419f },
  { 0.696668f, 1.102419f }, { 0.696668f, 1.252419f }, { 0.780092f, 0.653449f },
  { 0.780092f, 0.8f }, { 0.780092f, 0.946551f }, { 0.791965f, 0.525218f },
  { 0.791965f, 1.074782f }, { 0.8f, 0.417204f }, { 0.8f, 0.525218f },
  { 0.8f, 0.653449f }, { 0.8f, 0.946551f }, { 0.8f, 1.074782f },
  { 0.8f, 0.614248f }, { 0.8f, 0.700932f }, { 0.8f, 0.704629f },
  { 0.8f, 0.8f }, { 0.8f, 0.899068f }, { 0.8f, 0.985752f },
  { 0.8f, 1.113009f }, { 0.8f, 1.214962f }, { 0.8f, 0.704629f },
  { 0.8f, 0.954585f }, { 0.8f, 0.417204f }, { 0.8f, 1.113009f },
  { 0.8f, 1.214962f }, { 0.808035f, 0.525218f }, { 0.808035f, 1.074782f },
  { 0.819908f, 0.653449f }, { 0.819908f, 0.8f }, { 0.819908f, 0.946551f },
  { 0.821302f, 1.1f }, { 0.821302f, 1.01875f }, { 0.821302f, 1.18125f },
  { 0.83974f, 1.01875f }, { 0.83974f, 1.1f }, { 0.83974f, 1.18125f },
  { 0.870023f, 2.0f }, { 0.882863f, 1.749453f }, { 0.882863f, 2.250546f },
  { 0.890399f, 1.018358f }, { 0.890399f, 1.177419f }, { 0.890399f, 1.273973f },
  { 0.898343f, 1.572547f }, { 0.898343f, 2.427453f }, { 0.902606f, 1.096169f },
  { 0.902606f, 1.177419f }, { 0.902606f, 1.258669f }, { 0.929524f, 0.653449f },
  { 0.929524f, 0.8f }, { 0.929524f, 0.946551f }, { 0.930485f, 0.531324f },
  { 0.930485f, 1.068676f }, { 0.938389f, 1.711028f }, { 0.938389f, 1.834873f },
  { 0.938389f, 2.0f }, { 0.938389f, 2.165127f }, { 0.938389f, 2.288972f },
  { 0.940459f, 1.177419f }, { 0.952732f, 0.689115f }, { 0.952732f, 0.689115f },
  { 0.952732f, 0.928588f }, { 0.952732f, 1.292424f }, { 0.966458f, 0.535786f },
  { 0.966458f, 0.659086f }, { 0.966458f, 0.8f }, { 0.966458f, 0.940914f },
  { 0.966458f, 1.064214f }, { 0.968627f, 0.614248f }, { 0.968627f, 0.700932f },
  { 0.968627f, 0.8f }, { 0.968627f, 0.899068f }, { 0.968627f, 0.985752f },
  { 0.968627f, 1.214962f }, { 0.968627f, 1.214962f }, { 0.986657f, 1.113009f },
  { 0.986657f, 1.113009f }, { 0.994891f, 0.890399f }, { 0.994891f, 0.890399f },
  { 1.01875f, 1.1f }, { 1.01875f, 1.177419f }, { 1.01875f, 1.297394f },
  { 1.01875f, 0.83974f }, { 1.01875f, 1.378698f }, { 1.01875f, 0.83974f },
  { 1.01875f, 1.378698f }, { 1.01875f, 1.297394f }, { 1.025f, 0.633802f },
  { 1.025f, 1.025f }, { 1.025f, 1.102419f }, { 1.025f, 1.175f },
  { 1.025f, 1.252419f }, { 1.025f, 1.503332f }, { 1.025f, 1.584635f },
  { 1.025f, 0.633802f }, { 1.025f, 1.584635f }, { 1.025f, 1.503332f },
  { 1.033403f, 0.954585f }, { 1.033403f, 0.954585f }, { 1.060139f, 0.739341f },
  { 1.060139f, 0.739341f }, { 1.063295f, 0.8f }, { 1.063295f, 0.946551f },
  { 1.063295f, 0.525218f }, { 1.063295f, 0.529759f }, { 1.063295f, 0.653449f },
  { 1.063295f, 1.074782f }, { 1.063296f, 0.529759f }, { 1.098286f, 0.618376f },
  { 1.098286f, 0.981624f }, { 1.098286f, 1.208856f }, { 1.098286f, 1.208856f },
  { 1.1f, 1.096169f }, { 1.1f, 1.177419f }, { 1.1f, 1.258669f },
  { 1.1f, 1.509478f }, { 1.1f, 0.627656f }, { 1.1f, 0.83974f },
  { 1.1f, 0.890399f }, { 1.1f, 1.01875f }, { 1.1f, 1.1f },
  { 1.1f, 1.18125f }, { 1.1f, 1.297394f }, { 1.1f, 1.378698f },
  { 1.1f, 1.590781f }, { 1.1f, 0.672085f }, { 1.1f, 0.672085f },
  { 1.1f, 0.83974f }, { 1.1f, 0.875262f }, { 1.1f, 0.890399f },
  { 1.1f, 1.177419f }, { 1.1f, 1.324738f }, { 1.1f, 1.378698f },
  { 1.1f, 0.627656f }, { 1.1f, 1.297394f }, { 1.1f, 1.509478f },
  { 1.1f, 1.590781f }, { 1.100074f, 0.8f }, { 1.100075f, 0.700932f },
  { 1.100075f, 0.899068f }, { 1.171196f, 0.564095f }, { 1.171196f, 1.113009f },
  { 1.171197f, 1.035905f }, { 1.171197f, 1.113009f }, { 1.175f, 0.633802f },
  { 1.175f, 1.025f }, { 1.175f, 1.102419f }, { 1.175f, 1.175f },
  { 1.175f, 1.252419f }, { 1.175f, 1.503332f }, { 1.175f, 1.584635f },
  { 1.175f, 0.633802f }, { 1.175f, 1.584635f }, { 1.175f, 1.503332f },
  { 1.18125f, 1.1f }, { 1.18125f, 1.177419f }, { 1.18125f, 1.297394f },
  { 1.18125f, 0.83974f }, { 1.18125f, 1.378698f }, { 1.18125f, 0.83974f },
  { 1.18125f, 1.297394f }, { 1.18125f, 1.378698f }, { 1.198708f, 0.674184f },
  { 1.198708f, 0.8f }, { 1.198708f, 0.925816f }, { 1.19974f, 0.671332f },
  { 1.19974f, 0.671333f }, { 1.19974f, 0.671333f }, { 1.19974f, 0.671333f },
  { 1.205109f, 0.890399f }, { 1.229426f, 1.732433f }, { 1.229426f, 2.0f },
  { 1.229426f, 2.154424f }, { 1.229426f, 1.845575f }, { 1.229426f, 2.267567f },
  { 1.238f, 0.898343f }, { 1.238001f, 0.898343f }, { 1.242839f, 2.0f },
  { 1.242839f, 2.0f }, { 1.242839f, 1.730435f }, { 1.242839f, 2.269565f },
  { 1.247268f, 0.689115f }, { 1.247268f, 0.689115f }, { 1.247268f, 0.928588f },
  { 1.247268f, 1.292424f }, { 1.255657f, 1.27437f }, { 1.255657f, 1.274371f },
  { 1.259347f, 2.257748f }, { 1.259348f, 1.742252f }, { 1.259541f, 1.177419f },
  { 1.27437f, 1.577134f }, { 1.274371f, 2.422865f }, { 1.275181f, 0.535786f },
  { 1.275181f, 0.966458f }, { 1.275181f, 0.966459f }, { 1.275181f, 1.064214f },
  { 1.297394f, 1.096169f }, { 1.297394f, 1.177419f }, { 1.297394f, 1.258669f },
  { 1.309601f, 1.177419f }, { 1.309601f, 1.273973f }, { 1.309601f, 1.018358f },
  { 1.311496f, 0.659086f }, { 1.311496f, 0.8f }, { 1.311496f, 0.940914f },
  { 1.323571f, 0.531324f }, { 1.323571f, 0.669515f }, { 1.323571f, 0.669515f },
  { 1.323571f, 1.068676f }, { 1.329856f, 0.808035f }, { 1.329856f, 0.808035f },
  { 1.337007f, 0.8f }, { 1.337007f, 0.946551f }, { 1.337008f, 0.653449f },
  { 1.343415f, 1.691083f }, { 1.343415f, 1.691083f }, { 1.36026f, 1.1f },
  { 1.36026f, 1.18125f }, { 1.36026f, 1.01875f }, { 1.378698f, 1.01875f },
  { 1.378698f, 1.1f }, { 1.378698f, 1.18125f }, { 1.431012f, 1.242839f },
  { 1.431013f, 1.242839f }, { 1.435781f, 0.671333f }, { 1.435781f, 0.671333f },
  { 1.435781f, 0.671333f }, { 1.435781f, 0.671333f }, { 1.451138f, 0.894334f },
  { 1.451138f, 0.894334f }, { 1.455951f, 2.0f }, { 1.457958f, 1.829277f },
  { 1.457958f, 2.170723f }, { 1.460881f, 1.272626f }, { 1.460882f, 1.272626f },
  { 1.503332f, 1.102419f }, { 1.503332f, 1.252419f }, { 1.509478f, 1.177419f },
  { 1.510885f, 1.292424f }, { 1.510885f, 0.928588f }, { 1.512059f, 1.177419f },
  { 1.513659f, 1.710467f }, { 1.513659f, 2.163449f }, { 1.513659f, 2.289533f },
  { 1.513659f, 2.163449f }, { 1.514865f, 3.328667f }, { 1.514865f, 3.061611f },
  { 1.514866f, 3.061611f }, { 1.514866f, 3.328667f }, { 1.518326f, 1.689448f },
  { 1.518327f, 1.689448f }, { 1.547401f, 2.770574f }, { 1.547402f, 2.770574f },
  { 1.555376f, 1.786966f }, { 1.555376f, 1.879649f }, { 1.555376f, 2.0f },
  { 1.555376f, 2.12035f }, { 1.555376f, 2.213034f }, { 1.566198f, 1.025f },
  { 1.566198f, 1.175f }, { 1.572344f, 1.1f }, { 1.584635f, 1.025f },
  { 1.584635f, 1.175f }, { 1.590781f, 1.1f }, { 1.605966f, 1.877575f },
  { 1.605966f, 2.122425f }, { 1.606f, 2.0f }, { 1.643766f, 2.444624f },
  { 1.643767f, 2.444624f }, { 1.644302f, 1.790821f }, { 1.644302f, 2.209178f },
  { 1.644302f, 2.321129f }, { 1.644303f, 2.321129f }, { 1.657783f, 1.669175f },
  { 1.657783f, 2.156739f }, { 1.657783f, 2.330825f }, { 1.657784f, 2.156738f },
  { 1.665461f, 3.061611f }, { 1.665461f, 3.328667f }, { 1.665462f, 3.061611f },
  { 1.665462f, 3.328668f }, { 1.669764f, 2.0f }, { 1.67279f, 1.877575f },
  { 1.67279f, 2.122425f }, { 1.678871f, 1.790821f }, { 1.678871f, 2.209178f },
  { 1.684982f, 2.770574f }, { 1.684983f, 2.770574f }, { 1.691083f, 1.587726f },
  { 1.691083f, 2.412273f }, { 1.709789f, 1.741389f }, { 1.709789f, 2.258611f },
  { 1.721373f, 0.893858f }, { 1.721373f, 0.893858f }, { 1.733333f, 2.0f },
  { 1.733521f, 0.671333f }, { 1.733521f, 0.671333f }, { 1.733521f, 0.671333f },
  { 1.737826f, 1.242839f }, { 1.737826f, 1.242839f }, { 1.741253f, 1.757964f },
  { 1.741253f, 2.242036f }, { 1.741253f, 2.314805f }, { 1.741254f, 2.314805f },
  { 1.741661f, 1.273028f }, { 1.741661f, 1.273028f }, { 1.74746f, 2.444624f },
  { 1.74746f, 2.444624f }, { 1.771831f, 1.687026f }, { 1.771831f, 1.687026f },
  { 1.812133f, 2.0f }, { 1.822167f, 1.829277f }, { 1.822167f, 2.170723f },
  { 1.836551f, 1.710467f }, { 1.836551f, 2.289533f }, { 1.849383f, 2.146605f },
  { 1.849384f, 2.146605f }, { 1.866255f, 3.061611f }, { 1.866255f, 3.328668f },
  { 1.866256f, 3.061611f }, { 1.866256f, 3.328667f }, { 1.872762f, 2.770575f },
  { 1.872763f, 2.770574f }, { 1.895675f, 2.303071f }, { 1.895675f, 2.303071f },
  { 1.904814f, 2.444624f }, { 1.904815f, 2.444624f }, { 2.0f, 2.770574f },
  { 2.0f, 3.061611f }, { 2.0f, 3.328667f }, { 2.0f, 2.444624f },
  { 2.0f, 1.675478f }, { 2.0f, 2.132202f }, { 2.0f, 2.2934f },
  { 2.0f, 1.242839f }, { 2.0f, 1.285372f }, { 2.0f, 0.671333f },
  { 2.0f, 0.671333f }, { 2.0f, 0.909277f }, { 2.0f, 0.909277f },
  { 2.0f, 1.242839f }, { 2.0f, 1.285372f }, { 2.0f, 1.675478f },
  { 2.0f, 2.132202f }, { 2.0f, 2.2934f }, { 2.0f, 2.444624f },
  { 2.0f, 2.770574f }, { 2.0f, 3.061611f }, { 2.0f, 3.328667f },
  { 2.095185f, 2.444624f }, { 2.095186f, 2.444624f }, { 2.104325f, 2.303071f },
  { 2.104325f, 2.303071f }, { 2.127237f, 2.770574f }, { 2.127238f, 2.770575f },
  { 2.133744f, 3.061611f }, { 2.133744f, 3.328667f }, { 2.133745f, 3.061611f },
  { 2.133745f, 3.328668f }, { 2.150616f, 2.146605f }, { 2.150617f, 2.146605f },
  { 2.163449f, 1.710467f }, { 2.163449f, 2.289533f }, { 2.177832f, 1.829277f },
  { 2.177832f, 2.170723f }, { 2.187866f, 2.0f }, { 2.228168f, 1.687026f },
  { 2.228169f, 1.687026f }, { 2.25254f, 2.444624f }, { 2.25254f, 2.444624f },
  { 2.258339f, 1.273028f }, { 2.258339f, 1.273029f }, { 2.258746f, 1.757964f },
  { 2.258746f, 2.242036f }, { 2.258746f, 2.314805f }, { 2.258747f, 2.314805f },
  { 2.262174f, 1.242839f }, { 2.266479f, 0.671333f }, { 2.266479f, 0.671333f },
  { 2.266479f, 0.671333f }, { 2.266667f, 2.0f }, { 2.278627f, 0.893858f },
  { 2.278627f, 0.893858f }, { 2.29021f, 1.741389f }, { 2.290211f, 2.258611f },
  { 2.308917f, 2.412273f }, { 2.308917f, 1.587727f }, { 2.315017f, 2.770574f },
  { 2.315018f, 2.770574f }, { 2.321129f, 1.790821f }, { 2.321129f, 2.209178f },
  { 2.32721f, 1.877575f }, { 2.32721f, 2.122425f }, { 2.330235f, 2.0f },
  { 2.334538f, 3.061611f }, { 2.334538f, 3.328668f }, { 2.334539f, 3.061611f },
  { 2.334539f, 3.328667f }, { 2.342216f, 1.669175f }, { 2.342216f, 2.156739f },
  { 2.342216f, 2.330825f }, { 2.342217f, 2.156738f }, { 2.355697f, 1.790821f },
  { 2.355697f, 2.209178f }, { 2.355697f, 2.321129f }, { 2.355698f, 2.321129f },
  { 2.356234f, 2.444624f }, { 2.356234f, 2.444624f }, { 2.393999f, 2.0f },
  { 2.394034f, 1.877575f }, { 2.394034f, 2.122425f }, { 2.444624f, 1.786966f },
  { 2.444624f, 1.879649f }, { 2.444624f, 2.0f }, { 2.444624f, 2.12035f },
  { 2.444624f, 2.213034f }, { 2.452598f, 2.770575f }, { 2.452599f, 2.770574f },
  { 2.481673f, 1.689448f }, { 2.481674f, 1.689448f }, { 2.485134f, 3.061611f },
  { 2.485134f, 3.328667f }, { 2.485135f, 3.061611f }, { 2.485135f, 3.328667f },
  { 2.486341f, 1.710467f }, { 2.486341f, 2.163449f }, { 2.486341f, 2.289533f },
  { 2.486341f, 2.163449f }, { 2.539118f, 1.272626f }, { 2.539119f, 1.272626f },
  { 2.542042f, 2.170723f }, { 2.542042f, 1.829277f }, { 2.544048f, 2.0f },
  { 2.548862f, 0.894334f }, { 2.548862f, 0.894334f }, { 2.564219f, 0.671333f },
  { 2.564219f, 0.671333f }, { 2.564219f, 0.671333f }, { 2.568988f, 1.242838f },
  { 2.568988f, 1.242839f }, { 2.656585f, 1.691083f }, { 2.656585f, 1.691083f },
  { 2.725629f, 2.422865f }, { 2.725629f, 1.577134f }, { 2.740652f, 1.742252f },
  { 2.740653f, 2.257748f }, { 2.744343f, 1.274371f }, { 2.744343f, 1.274371f },
  { 2.757161f, 2.0f }, { 2.757162f, 1.730435f }, { 2.757162f, 2.0f },
  { 2.757162f, 2.269565f }, { 2.761999f, 0.898343f }, { 2.761999f, 0.898343f },
  { 2.770574f, 1.732433f }, { 2.770574f, 1.845575f }, { 2.770574f, 2.0f },
  { 2.770574f, 2.154424f }, { 2.770574f, 2.267566f }, { 2.80026f, 0.671333f },
  { 2.80026f, 0.671332f }, { 2.80026f, 0.671333f }, { 2.80026f, 0.671333f },
  { 3.061611f, 1.711028f }, { 3.061611f, 1.834873f }, { 3.061611f, 2.0f },
  { 3.061611f, 2.165127f }, { 3.061611f, 2.288972f }, { 3.101656f, 2.427453f },
  { 3.101657f, 1.572547f }, { 3.117136f, 1.749453f }, { 3.117136f, 2.250546f },
  { 3.129976f, 2.0f }, { 3.328667f, 2.26421f }, { 3.328667f, 1.73579f },
  { 3.328667f, 2.456155f }, { 3.328667f, 1.543845f }, { 3.328667f, 1.711028f },
  { 3.328667f, 1.73579f }, { 3.328667f, 1.834873f }, { 3.328667f, 2.0f },
  { 3.328667f, 2.0f }, { 3.328667f, 2.165127f }, { 3.328667f, 2.26421f },
  { 3.328667f, 2.288972f }, { 3.328667f, 2.456155f }, { 3.328667f, 2.0f },
  { 3.328668f, 1.543845f }
};

TEST_NORMAL Greenmonk_normal[742] = {
  { -1.0f, 0.0f, 0.0f }, { -0.99926f, -0.000001f, 0.038467f },
  { -0.99926f, 0.000001f, 0.038466f }, { -0.999249f, -0.00935f, 0.037607f },
  { -0.999159f, 0.0f, -0.041013f }, { -0.998608f, -0.006159f, 0.052385f },
  { -0.997623f, 0.0f, -0.068903f }, { -0.997623f, 0.0f, -0.068903f },
  { -0.997418f, 0.0f, 0.071814f }, { -0.996195f, 0.0f, 0.087155f },
  { -0.996195f, 0.0f, 0.087155f }, { -0.996195f, 0.0f, -0.087157f },
  { -0.996195f, 0.0f, -0.087156f }, { -0.9961f, 0.0f, 0.088236f },
  { -0.994397f, 0.00012f, -0.105714f }, { -0.994285f, 0.063433f, -0.085866f },
  { -0.99356f, -0.000001f, 0.113303f }, { -0.99356f, -0.000001f, 0.113304f },
  { -0.99217f, 0.075979f, 0.099126f }, { -0.992018f, 0.0f, 0.1261f },
  { -0.991322f, -0.036403f, 0.126316f }, { -0.991242f, -0.111109f, 0.07137f },
  { -0.990543f, 0.05372f, -0.12625f }, { -0.990154f, 0.0823f, 0.113233f },
  { -0.989803f, 0.0f, 0.142442f }, { -0.989321f, 0.027472f, 0.143138f },
  { -0.98662f, -0.136368f, 0.089356f }, { -0.986106f, 0.0f, 0.166119f },
  { -0.985942f, 0.123231f, 0.112843f }, { -0.985822f, 0.0f, -0.167797f },
  { -0.985638f, 0.028836f, 0.166392f }, { -0.985242f, 0.159806f, 0.061317f },
  { -0.985199f, -0.171414f, 0.0f }, { -0.985199f, 0.171414f, 0.0f },
  { -0.984441f, -0.158803f, 0.075213f }, { -0.984149f, -0.172096f, -0.04282f },
  { -0.983846f, -0.144147f, -0.106154f }, { -0.983792f, 0.173603f, -0.044889f },
  { -0.981716f, 0.147615f, -0.120179f }, { -0.978123f, -0.099715f, -0.182569f },
  { -0.977533f, 0.036091f, -0.207669f }, { -0.976963f, -0.162466f, 0.138373f },
  { -0.976888f, -0.167339f, 0.132995f }, { -0.976754f, -0.053408f, 0.207604f },
  { -0.975576f, -0.148926f, 0.161472f }, { -0.975123f, -0.062068f, -0.212799f },
  { -0.974271f, -0.163357f, -0.155276f }, { -0.974271f, -0.163357f, 0.155276f },
  { -0.971272f, 0.003148f, 0.23795f }, { -0.968769f, 0.225105f, 0.103995f },
  { -0.968738f, 0.181469f, -0.16916f }, { -0.968325f, 0.241658f, 0.062831f },
  { -0.967848f, -0.245026f, 0.056851f }, { -0.967416f, -0.182428f, -0.175573f },
  { -0.966968f, -0.062815f, 0.247037f }, { -0.964911f, 0.002957f, -0.262559f },
  { -0.96274f, 0.212571f, 0.167167f }, { -0.941992f, 0.003656f, 0.335616f },
  { -0.938718f, -0.123661f, -0.321738f }, { -0.935179f, 0.000868f, -0.354176f },
  { -0.926745f, -0.243639f, 0.285977f }, { -0.926697f, -0.006742f, 0.375749f },
  { -0.926244f, 0.243914f, 0.287363f }, { -0.924558f, -0.310914f, 0.220283f },
  { -0.920473f, 0.308418f, 0.240017f }, { -0.920247f, -0.183048f, 0.345889f },
  { -0.918241f, 0.191532f, 0.346625f }, { -0.914809f, 0.0f, 0.403887f },
  { -0.914809f, 0.0f, 0.403887f }, { -0.910956f, -0.008804f, 0.41241f },
  { -0.888054f, -0.425669f, 0.173685f }, { -0.886967f, 0.0f, -0.461833f },
  { -0.886967f, 0.0f, -0.461833f }, { -0.88686f, 0.426456f, 0.177807f },
  { -0.882741f, -0.031769f, 0.468785f }, { -0.874662f, -0.480928f, 0.060615f },
  { -0.874662f, 0.480929f, 0.060615f }, { -0.874518f, 0.010586f, 0.484877f },
  { -0.870242f, 0.490137f, 0.04944f }, { -0.856206f, 0.493029f, 0.154381f },
  { -0.856181f, -0.060989f, 0.513063f }, { -0.854631f, 0.221971f, 0.469397f },
  { -0.848668f, -0.227219f, 0.477633f }, { -0.845834f, 0.0f, 0.533446f },
  { -0.845762f, 0.028071f, 0.532821f }, { -0.844821f, 0.0f, 0.535049f },
  { -0.842089f, 0.119743f, 0.525877f }, { -0.841793f, -0.110921f, 0.528282f },
  { -0.838039f, -0.039957f, -0.544145f }, { -0.825685f, 0.009936f, -0.564044f },
  { -0.819344f, 0.224957f, 0.527323f }, { -0.816445f, 0.570986f, -0.085984f },
  { -0.815022f, 0.578413f, 0.034313f }, { -0.809595f, -0.064543f, -0.58343f },
  { -0.80565f, 0.534908f, -0.254559f }, { -0.795236f, 0.603922f, 0.053645f },
  { -0.794137f, 0.0f, -0.607738f }, { -0.792811f, 0.046409f, -0.607698f },
  { -0.780617f, 0.622901f, 0.051305f }, { -0.780065f, 0.612693f, 0.12691f },
  { -0.773955f, -0.48129f, -0.411525f }, { -0.756137f, -0.344848f, -0.55618f },
  { -0.753938f, 0.584992f, 0.298935f }, { -0.742383f, -0.669896f, -0.010338f },
  { -0.740684f, -0.65062f, -0.167574f }, { -0.740278f, -0.578458f, 0.342599f },
  { -0.739858f, 0.667492f, 0.084054f }, { -0.735662f, -0.134904f, 0.663778f },
  { -0.735385f, -0.658694f, 0.159156f }, { -0.732404f, -0.674103f, -0.09576f },
  { -0.729095f, -0.105633f, 0.676212f }, { -0.729094f, 0.105633f, 0.676212f },
  { -0.729093f, 0.105633f, -0.676214f }, { -0.729093f, -0.105634f, -0.676213f },
  { -0.724018f, 0.679334f, -0.119597f }, { -0.722006f, 0.0f, 0.691887f },
  { -0.72178f, -0.075917f, 0.687946f }, { -0.719634f, -0.687937f, 0.094173f },
  { -0.718868f, -0.673733f, -0.171207f }, { -0.715794f, 0.680315f, 0.157516f },
  { -0.714725f, 0.087398f, 0.693923f }, { -0.714511f, 0.694593f, 0.083752f },
  { -0.711666f, -0.617925f, 0.334216f }, { -0.711637f, 0.550271f, -0.436777f },
  { -0.711286f, 0.702181f, 0.031843f }, { -0.708246f, -0.695104f, -0.123362f },
  { -0.707107f, 0.0f, -0.707107f }, { -0.707107f, 0.59303f, -0.385118f },
  { -0.707106f, -0.59303f, 0.385118f }, { -0.704107f, 0.448446f, -0.550572f },
  { -0.700999f, 0.712175f, -0.03751f }, { -0.69751f, 0.688508f, 0.198586f },
  { -0.694196f, -0.71645f, 0.069213f }, { -0.69209f, 0.720102f, -0.049644f },
  { -0.691911f, 0.721034f, -0.036989f }, { -0.691289f, -0.722578f, 0.0f },
  { -0.691289f, 0.722578f, 0.0f }, { -0.691208f, 0.707695f, -0.146283f },
  { -0.691138f, 0.561281f, 0.455293f }, { -0.691092f, -0.721209f, -0.047426f },
  { -0.690624f, -0.711272f, -0.130885f }, { -0.685943f, 0.724219f, 0.070636f },
  { -0.684978f, -0.706284f, -0.178797f }, { -0.683835f, 0.710781f, -0.164804f },
  { -0.683615f, -0.709354f, -0.17172f }, { -0.683005f, 0.328811f, 0.652217f },
  { -0.683005f, -0.32881f, 0.652217f }, { -0.68163f, -0.60393f, -0.413097f },
  { -0.680272f, 0.604314f, -0.414771f }, { -0.676899f, 0.731851f, -0.078754f },
  { -0.675096f, 0.728336f, -0.117357f }, { -0.672768f, -0.600201f, 0.432599f },
  { -0.671737f, 0.626156f, -0.395852f }, { -0.669715f, -0.738264f, 0.080294f },
  { -0.668877f, -0.737854f, 0.090412f }, { -0.661668f, -0.604317f, -0.443842f },
  { -0.66014f, 0.455016f, -0.597641f }, { -0.66014f, -0.731044f, 0.172596f },
  { -0.659463f, -0.748147f, 0.073381f }, { -0.658728f, 0.749087f, 0.070326f },
  { -0.657922f, 0.723604f, 0.208652f }, { -0.655404f, -0.736841f, 0.165864f },
  { -0.655358f, 0.607085f, -0.449392f }, { -0.655285f, -0.736938f, 0.165901f },
  { -0.654845f, -0.610424f, -0.445602f }, { -0.651951f, 0.74969f, 0.113682f },
  { -0.651756f, 0.743016f, -0.152125f }, { -0.646368f, -0.479992f, 0.593141f },
  { -0.642818f, -0.617925f, 0.452718f }, { -0.640856f, 0.267026f, -0.719722f },
  { -0.637858f, -0.602411f, -0.479832f }, { -0.632421f, 0.760407f, 0.147736f },
  { -0.632203f, -0.74722f, 0.204893f }, { -0.631172f, 0.69741f, 0.339471f },
  { -0.630997f, -0.706603f, 0.320242f }, { -0.628795f, 0.409884f, -0.660766f },
  { -0.628549f, 0.689527f, 0.359831f }, { -0.6278f, 0.63589f, -0.448899f },
  { -0.627559f, 0.748578f, 0.214011f }, { -0.626857f, -0.636279f, -0.449666f },
  { -0.625113f, 0.613773f, -0.482199f }, { -0.62261f, -0.707169f, 0.335066f },
  { -0.615872f, 0.787728f, 0.013649f }, { -0.611881f, 0.034836f, -0.790182f },
  { -0.611695f, 0.723604f, 0.31973f }, { -0.610357f, -0.791867f, 0.020269f },
  { -0.604377f, -0.695456f, 0.388677f }, { -0.597962f, 0.591679f, 0.5407f },
  { -0.584929f, 0.682377f, 0.438429f }, { -0.579604f, -0.686184f, 0.439557f },
  { -0.57735f, 0.169759f, -0.798654f }, { -0.57735f, -0.798654f, -0.169759f },
  { -0.576042f, 0.742104f, 0.342721f }, { -0.572522f, -0.733082f, -0.367164f },
  { -0.564646f, 0.71311f, 0.415511f }, { -0.559412f, 0.556644f, -0.614171f },
  { -0.559412f, 0.556644f, 0.614171f }, { -0.559412f, -0.556644f, 0.61417f },
  { -0.559411f, -0.556645f, -0.614171f }, { -0.559373f, 0.328811f, 0.760911f },
  { -0.559372f, -0.32881f, 0.760911f }, { -0.55804f, -0.718231f, 0.415615f },
  { -0.556808f, -0.706586f, -0.436694f }, { -0.53349f, 0.803129f, 0.265276f },
  { -0.525229f, -0.571438f, -0.63055f }, { -0.506144f, 0.267026f, -0.82007f },
  { -0.500068f, -0.733082f, -0.461003f }, { -0.484618f, 0.0f, -0.874726f },
  { -0.482535f, -0.871948f, -0.082864f }, { -0.468364f, 0.006742f, 0.88351f },
  { -0.464428f, 0.022039f, 0.885337f }, { -0.464353f, 0.0f, 0.88565f },
  { -0.463799f, -0.884439f, -0.051559f }, { -0.45386f, -0.887557f, -0.079076f },
  { -0.453432f, -0.862698f, 0.223946f }, { -0.450542f, 0.646781f, 0.615375f },
  { -0.450454f, 0.225089f, 0.86396f }, { -0.449912f, -0.096985f, -0.887791f },
  { -0.447212f, -0.632458f, 0.632454f }, { -0.446745f, -0.655492f, 0.608892f },
  { -0.44484f, 0.120352f, -0.887487f }, { -0.437724f, 0.61474f, -0.656119f },
  { -0.437604f, 0.54782f, -0.713019f }, { -0.432249f, -0.847661f, -0.307622f },
  { -0.427238f, 0.040623f, 0.903226f }, { -0.423475f, 0.0f, 0.905908f },
  { -0.423442f, -0.168806f, 0.890057f }, { -0.413398f, -0.909629f, -0.040958f },
  { -0.409369f, -0.041494f, 0.911425f }, { -0.38384f, -0.600585f, 0.701402f },
  { -0.369568f, -0.337856f, -0.865605f }, { -0.367933f, 0.599334f, 0.710932f },
  { -0.36793f, 0.339638f, -0.865606f }, { -0.35677f, 0.404006f, 0.842315f },
  { -0.34552f, -0.480711f, -0.805936f }, { -0.344565f, 0.594314f, 0.726681f },
  { -0.34202f, 0.0f, 0.939693f }, { -0.339183f, 0.128543f, -0.931897f },
  { -0.3321f, -0.890455f, -0.311125f }, { -0.332099f, 0.077959f, -0.940017f },
  { -0.313307f, -0.4053f, 0.858819f }, { -0.312087f, -0.085488f, -0.9462f },
  { -0.310657f, 0.086116f, -0.946613f }, { -0.290782f, 0.716189f, -0.634444f },
  { -0.287218f, -0.727888f, -0.622643f }, { -0.287133f, -0.11769f, -0.950633f },
  { -0.28266f, -0.619455f, -0.732379f }, { -0.281031f, 0.949444f, 0.139919f },
  { -0.273634f, 0.810975f, 0.51715f }, { -0.273121f, -0.541778f, -0.79491f },
  { -0.269521f, -0.962917f, 0.012217f }, { -0.269241f, -0.046043f, -0.961972f },
  { -0.253075f, -0.003844f, -0.967439f }, { -0.252299f, 0.873202f, -0.41697f },
  { -0.235502f, -0.742296f, 0.627323f }, { -0.217765f, 0.896513f, 0.385802f },
  { -0.207753f, 0.797849f, -0.565928f }, { -0.202645f, 0.742019f, 0.639017f },
  { -0.195186f, -0.980742f, -0.006956f }, { -0.191498f, -0.147361f, 0.970368f },
  { -0.179451f, -0.983727f, 0.008871f }, { -0.168627f, -0.984965f, 0.037531f },
  { -0.168627f, 0.984965f, 0.037531f }, { -0.167108f, -0.003784f, -0.985931f },
  { -0.163344f, 0.978302f, -0.127454f }, { -0.163344f, -0.978302f, -0.127453f },
  { -0.160218f, 0.984513f, 0.071158f }, { -0.160218f, -0.984513f, 0.071158f },
  { -0.15808f, -0.483742f, -0.860816f }, { -0.158078f, 0.483744f, -0.860815f },
  { -0.156157f, -0.58837f, 0.79337f }, { -0.155108f, 0.974861f, 0.159961f },
  { -0.155108f, -0.974861f, 0.159961f }, { -0.152768f, 0.987613f, -0.035803f },
  { -0.152768f, -0.987613f, -0.035803f }, { -0.149575f, 0.98875f, 0.0f },
  { -0.149575f, -0.98875f, 0.0f }, { -0.146832f, 0.0f, -0.989161f },
  { -0.146831f, 0.000001f, -0.989162f }, { -0.146024f, -0.980692f, -0.13008f },
  { -0.14449f, -0.984907f, -0.095296f }, { -0.14449f, 0.984907f, -0.095297f },
  { -0.139979f, -0.969426f, 0.201542f }, { -0.138829f, 0.524795f, -0.839831f },
  { -0.138237f, 0.895583f, -0.422874f }, { -0.131817f, 0.029489f, -0.990835f },
  { -0.128872f, -0.961326f, 0.243401f }, { -0.128872f, 0.961326f, 0.243401f },
  { -0.124767f, 0.231605f, -0.964776f }, { -0.124421f, 0.928395f, 0.350147f },
  { -0.118853f, 0.733837f, -0.668848f }, { -0.113376f, -0.928574f, 0.353407f },
  { -0.113376f, 0.928574f, 0.353406f }, { -0.107509f, 0.729288f, -0.675707f },
  { -0.107509f, -0.729288f, -0.675707f }, { -0.107508f, 0.729288f, 0.675707f },
  { -0.107508f, -0.729288f, 0.675708f }, { -0.086332f, -0.311889f, -0.946188f },
  { -0.086234f, 0.311888f, -0.946198f }, { -0.084228f, -0.738181f, -0.669324f },
  { -0.081723f, 0.987747f, 0.132952f }, { -0.081723f, -0.987747f, 0.132952f },
  { -0.079427f, 0.978705f, -0.189283f }, { -0.068153f, 0.946442f, 0.3156f },
  { -0.068153f, -0.946442f, 0.3156f }, { -0.065219f, -0.950389f, 0.30415f },
  { -0.062394f, 0.0f, 0.998052f }, { -0.061949f, -0.086715f, 0.994305f },
  { -0.05953f, -0.99777f, 0.030199f }, { -0.05953f, 0.99777f, 0.030199f },
  { -0.050595f, 0.07647f, 0.995787f }, { -0.049215f, 0.994947f, 0.087514f },
  { -0.04655f, 0.997858f, 0.045951f }, { -0.04655f, -0.997858f, -0.045951f },
  { -0.043261f, 0.998326f, -0.03839f }, { -0.043261f, -0.998326f, 0.03839f },
  { -0.042683f, 0.988055f, 0.148076f }, { -0.042187f, -0.979159f, 0.198666f },
  { -0.042187f, 0.979159f, 0.198665f }, { -0.040752f, -0.508674f, 0.859994f },
  { -0.04036f, -0.99598f, 0.079972f }, { -0.038404f, -0.995593f, 0.085552f },
  { -0.037617f, 0.999112f, -0.019003f }, { -0.037617f, -0.999112f, -0.019003f },
  { -0.035045f, 0.900008f, 0.434462f }, { -0.035045f, -0.900008f, 0.434462f },
  { -0.03376f, 0.98778f, 0.152154f }, { -0.03376f, -0.98778f, 0.152155f },
  { -0.028457f, 0.517625f, 0.855134f }, { -0.02572f, 0.997135f, 0.07114f },
  { -0.02572f, -0.997135f, 0.07114f }, { -0.019848f, 0.292297f, -0.956122f },
  { -0.019137f, 0.720851f, -0.692825f }, { -0.018694f, -0.243113f, -0.969818f },
  { -0.015214f, 0.243654f, -0.969743f }, { -0.014175f, -0.997451f, 0.069936f },
  { -0.011742f, -0.938521f, -0.345023f }, { -0.010913f, 0.938178f, -0.34598f },
  { -0.005408f, -0.999911f, 0.012234f }, { -0.005026f, -0.999981f, 0.003664f },
  { -0.004428f, -0.997528f, -0.070131f }, { -0.002927f, 0.99983f, -0.018213f },
  { -0.002927f, -0.99983f, -0.018213f }, { -0.002076f, -0.996142f, -0.087736f },
  { -0.002076f, 0.996142f, -0.087736f }, { -0.000583f, 0.229079f, 0.973408f },
  { -0.000402f, 0.02233f, 0.999751f }, { -0.000024f, 0.609196f, 0.793019f },
  { -0.000001f, 0.000001f, 1.0f }, { 0.0f, -1.0f, 0.0f },
  { 0.0f, -0.999534f, -0.030512f }, { 0.0f, -0.999534f, -0.030512f },
  { 0.0f, -0.999534f, -0.030512f }, { 0.0f, -0.999221f, 0.039468f },
  { 0.0f, -0.996733f, 0.080765f }, { 0.0f, -0.995797f, -0.091588f },
  { 0.0f, -0.99322f, -0.116253f }, { 0.0f, -0.99322f, -0.116253f },
  { 0.0f, -0.99322f, -0.116253f }, { 0.0f, -0.992427f, 0.122838f },
  { 0.0f, -0.977904f, 0.209054f }, { 0.0f, -0.953838f, 0.30032f },
  { 0.0f, -0.939135f, -0.343548f }, { 0.0f, -0.904033f, 0.427463f },
  { 0.0f, -0.516934f, 0.856025f }, { 0.0f, -0.216466f, -0.97629f },
  { 0.0f, -0.087177f, 0.996193f }, { 0.0f, -0.007789f, -0.99997f },
  { 0.0f, -0.000001f, -1.0f }, { 0.0f, 0.0f, -1.0f },
  { 0.0f, 0.0f, 1.0f }, { 0.0f, 0.087177f, 0.996193f },
  { 0.0f, 0.17451f, -0.984655f }, { 0.0f, 0.217439f, -0.976074f },
  { 0.0f, 0.477824f, -0.878456f }, { 0.0f, 0.516934f, 0.856025f },
  { 0.0f, 0.873889f, -0.486126f }, { 0.0f, 0.884842f, -0.465892f },
  { 0.0f, 0.904033f, 0.427463f }, { 0.0f, 0.938422f, -0.345492f },
  { 0.0f, 0.953839f, 0.300319f }, { 0.0f, 0.977904f, 0.209054f },
  { 0.0f, 0.97891f, -0.204294f }, { 0.0f, 0.992427f, 0.122838f },
  { 0.0f, 0.99322f, -0.116254f }, { 0.0f, 0.99322f, -0.116254f },
  { 0.0f, 0.99322f, -0.116254f }, { 0.0f, 0.995797f, -0.091588f },
  { 0.0f, 0.996733f, 0.080764f }, { 0.0f, 0.999221f, 0.039468f },
  { 0.0f, 0.999534f, -0.030513f }, { 0.0f, 0.999534f, -0.030513f },
  { 0.0f, 0.999534f, -0.030513f }, { 0.0f, 1.0f, 0.0f },
  { 0.000418f, 0.829305f, 0.558797f }, { 0.000787f, 0.900101f, 0.43568f },
  { 0.000963f, -0.990195f, 0.139686f }, { 0.000963f, 0.990195f, 0.139685f },
  { 0.002076f, -0.996142f, -0.087736f }, { 0.002076f, 0.996142f, -0.087737f },
  { 0.004171f, -0.924442f, -0.3813f }, { 0.00439f, 0.983648f, 0.180049f },
  { 0.008584f, -0.245395f, 0.969385f }, { 0.010913f, 0.938178f, -0.34598f },
  { 0.011742f, -0.938521f, -0.345023f }, { 0.014175f, -0.997451f, 0.069936f },
  { 0.014921f, -0.720903f, -0.692875f }, { 0.015214f, 0.243654f, -0.969743f },
  { 0.018693f, -0.243114f, -0.969818f }, { 0.019848f, -0.292297f, -0.956122f },
  { 0.025451f, -0.515913f, 0.856263f }, { 0.02572f, -0.997135f, 0.07114f },
  { 0.02572f, 0.997135f, 0.07114f }, { 0.026243f, -0.954626f, 0.296647f },
  { 0.035602f, -0.902163f, 0.429923f }, { 0.035602f, 0.902163f, 0.429923f },
  { 0.037722f, 0.50697f, 0.861138f }, { 0.038404f, -0.995593f, 0.085552f },
  { 0.039467f, -0.987326f, 0.153718f }, { 0.039467f, 0.987326f, 0.153717f },
  { 0.04036f, -0.99598f, 0.079972f }, { 0.042188f, -0.979159f, 0.198666f },
  { 0.042188f, 0.979159f, 0.198665f }, { 0.042683f, 0.988055f, 0.148076f },
  { 0.043261f, -0.998326f, 0.03839f }, { 0.043262f, 0.998326f, -0.03839f },
  { 0.04655f, -0.997859f, -0.045951f }, { 0.04655f, 0.997859f, 0.045951f },
  { 0.04684f, 0.998784f, -0.015351f }, { 0.04684f, -0.998784f, -0.015351f },
  { 0.049215f, 0.994947f, 0.087514f }, { 0.050595f, -0.07647f, 0.995787f },
  { 0.05953f, 0.99777f, 0.030199f }, { 0.05953f, -0.99777f, 0.030199f },
  { 0.061949f, 0.086715f, 0.994305f }, { 0.062394f, 0.0f, 0.998052f },
  { 0.068153f, -0.946442f, 0.3156f }, { 0.068153f, 0.946442f, 0.3156f },
  { 0.081723f, -0.987747f, 0.132952f }, { 0.081723f, 0.987747f, 0.132952f },
  { 0.084228f, -0.738181f, -0.669324f }, { 0.086234f, 0.311888f, -0.946198f },
  { 0.086332f, -0.311889f, -0.946188f }, { 0.107508f, 0.729288f, -0.675708f },
  { 0.107508f, 0.729288f, 0.675708f }, { 0.107508f, -0.729288f, -0.675708f },
  { 0.107509f, -0.729288f, 0.675707f }, { 0.108497f, 0.982783f, -0.14955f },
  { 0.113376f, 0.928574f, 0.353406f }, { 0.113376f, -0.928574f, 0.353407f },
  { 0.118853f, 0.733837f, -0.668848f }, { 0.124421f, 0.928395f, 0.350147f },
  { 0.128872f, 0.961326f, 0.243401f }, { 0.128872f, -0.961326f, 0.243401f },
  { 0.131759f, 0.225686f, -0.965249f }, { 0.139979f, -0.969426f, 0.201541f },
  { 0.140847f, 0.040531f, -0.989201f }, { 0.141793f, -0.93795f, 0.316455f },
  { 0.14449f, 0.984907f, -0.095296f }, { 0.14449f, -0.984907f, -0.095296f },
  { 0.146024f, -0.980692f, -0.13008f }, { 0.146832f, 0.0f, -0.989161f },
  { 0.146832f, 0.0f, -0.989161f }, { 0.149574f, -0.98875f, 0.0f },
  { 0.149575f, 0.98875f, 0.0f }, { 0.152768f, -0.987613f, -0.035803f },
  { 0.152768f, 0.987613f, -0.035803f }, { 0.155108f, -0.974861f, 0.159961f },
  { 0.155108f, 0.974861f, 0.159961f }, { 0.15808f, 0.483742f, -0.860816f },
  { 0.15808f, -0.483742f, -0.860816f }, { 0.158289f, 0.516583f, -0.841479f },
  { 0.160108f, -0.586143f, 0.79423f }, { 0.160218f, -0.984513f, 0.071158f },
  { 0.160218f, 0.984513f, 0.071158f }, { 0.163343f, -0.978302f, -0.127453f },
  { 0.163343f, 0.978302f, -0.127454f }, { 0.167109f, -0.003784f, -0.985931f },
  { 0.167396f, 0.895035f, -0.41339f }, { 0.168627f, 0.984965f, 0.037531f },
  { 0.168627f, -0.984965f, 0.037531f }, { 0.173372f, -0.983981f, 0.041515f },
  { 0.189096f, 0.896771f, 0.400056f }, { 0.197836f, -0.153315f, 0.968171f },
  { 0.202644f, 0.74202f, 0.639017f }, { 0.207753f, 0.797849f, -0.565928f },
  { 0.219538f, -0.975529f, -0.012131f }, { 0.235502f, -0.742296f, 0.627324f },
  { 0.240379f, -0.968445f, -0.065813f }, { 0.253076f, -0.003843f, -0.967439f },
  { 0.254318f, 0.873736f, -0.414618f }, { 0.269241f, -0.046044f, -0.961971f },
  { 0.272225f, 0.809742f, 0.519819f }, { 0.273121f, -0.541778f, -0.79491f },
  { 0.283151f, 0.949309f, 0.136521f }, { 0.288862f, -0.617004f, -0.732027f },
  { 0.295864f, 0.724696f, -0.622318f }, { 0.297497f, -0.117602f, -0.947452f },
  { 0.299518f, -0.712948f, -0.63403f }, { 0.310657f, 0.086115f, -0.946613f },
  { 0.312087f, -0.085487f, -0.9462f }, { 0.317102f, 0.397299f, 0.861162f },
  { 0.339183f, 0.128544f, -0.931897f }, { 0.34202f, 0.0f, 0.939693f },
  { 0.344565f, 0.594314f, 0.726681f }, { 0.345519f, -0.480711f, -0.805936f },
  { 0.36031f, -0.395878f, 0.844664f }, { 0.367853f, 0.599436f, 0.710888f },
  { 0.367929f, 0.339638f, -0.865606f }, { 0.369568f, -0.337856f, -0.865605f },
  { 0.38384f, -0.600585f, 0.701402f }, { 0.392214f, -0.859188f, 0.328579f },
  { 0.409369f, 0.041494f, 0.911425f }, { 0.423475f, 0.0f, 0.905908f },
  { 0.427238f, -0.040623f, 0.903226f }, { 0.435978f, -0.203908f, 0.876553f },
  { 0.436176f, -0.844111f, -0.311812f }, { 0.436639f, -0.898591f, -0.043358f },
  { 0.437604f, 0.54782f, -0.713019f }, { 0.437723f, 0.614739f, -0.656121f },
  { 0.44484f, -0.120352f, -0.887487f }, { 0.445204f, 0.663897f, 0.600861f },
  { 0.447212f, -0.632458f, 0.632454f }, { 0.449073f, -0.65528f, 0.607406f },
  { 0.449912f, 0.096985f, -0.887791f }, { 0.451422f, -0.89063f, -0.054734f },
  { 0.451509f, 0.225083f, 0.86341f }, { 0.460546f, -0.887248f, -0.026258f },
  { 0.464353f, 0.0f, 0.88565f }, { 0.465159f, 0.022072f, 0.884952f },
  { 0.468364f, 0.006742f, 0.88351f }, { 0.484618f, 0.0f, -0.874726f },
  { 0.485359f, -0.868866f, -0.097467f }, { 0.500067f, -0.733083f, -0.461002f },
  { 0.506142f, 0.267025f, -0.820072f }, { 0.525229f, -0.571438f, -0.63055f },
  { 0.553601f, 0.723576f, 0.412268f }, { 0.556808f, -0.706586f, -0.436694f },
  { 0.559372f, -0.32881f, 0.760912f }, { 0.559373f, 0.32881f, 0.760911f },
  { 0.559411f, 0.556645f, -0.614171f }, { 0.559411f, 0.556645f, 0.61417f },
  { 0.559412f, -0.556644f, 0.614171f }, { 0.559412f, -0.556644f, -0.614171f },
  { 0.560249f, -0.7185f, 0.412163f }, { 0.572523f, -0.733082f, -0.367162f },
  { 0.57735f, -0.798654f, -0.169759f }, { 0.57735f, 0.169759f, -0.798654f },
  { 0.579105f, 0.771162f, 0.264473f }, { 0.579604f, -0.686184f, 0.439557f },
  { 0.582555f, 0.737756f, 0.341097f }, { 0.584929f, 0.682377f, 0.438429f },
  { 0.597962f, 0.591679f, 0.5407f }, { 0.604377f, -0.695456f, 0.388677f },
  { 0.610356f, -0.791868f, 0.020269f }, { 0.611696f, 0.723603f, 0.31973f },
  { 0.611881f, 0.034835f, -0.790182f }, { 0.613331f, 0.37571f, -0.694743f },
  { 0.615872f, 0.787728f, 0.013649f }, { 0.617365f, -0.623501f, -0.479694f },
  { 0.62261f, -0.707169f, 0.335066f }, { 0.626857f, -0.636279f, -0.449666f },
  { 0.627559f, 0.748578f, 0.214011f }, { 0.6278f, 0.63589f, -0.448899f },
  { 0.628549f, 0.689527f, 0.359831f }, { 0.630095f, -0.483858f, 0.60734f },
  { 0.630997f, -0.706603f, 0.320242f }, { 0.631172f, 0.69741f, 0.339471f },
  { 0.632203f, -0.74722f, 0.204893f }, { 0.637858f, -0.60241f, -0.479833f },
  { 0.640856f, 0.267026f, -0.719723f }, { 0.642819f, -0.617924f, 0.452718f },
  { 0.646832f, -0.754372f, 0.111944f }, { 0.651756f, 0.743016f, -0.152125f },
  { 0.654435f, 0.614276f, -0.440886f }, { 0.654844f, -0.610424f, -0.445602f },
  { 0.655285f, -0.736939f, 0.165901f }, { 0.655358f, 0.607085f, -0.449393f },
  { 0.655405f, -0.736841f, 0.165864f }, { 0.657923f, 0.723603f, 0.208652f },
  { 0.658728f, 0.749087f, 0.070326f }, { 0.659463f, -0.748147f, 0.073381f },
  { 0.66014f, -0.455016f, 0.597641f }, { 0.660142f, 0.731043f, -0.172595f },
  { 0.664668f, 0.743022f, 0.078321f }, { 0.668877f, -0.737854f, 0.090412f },
  { 0.672768f, -0.600201f, 0.432599f }, { 0.675096f, 0.728336f, -0.117358f },
  { 0.676899f, 0.731851f, -0.078754f }, { 0.677866f, 0.727818f, 0.103818f },
  { 0.680272f, 0.604313f, -0.414771f }, { 0.681631f, -0.603929f, -0.413097f },
  { 0.683005f, -0.32881f, 0.652218f }, { 0.683005f, 0.328811f, 0.652218f },
  { 0.683615f, -0.709354f, -0.17172f }, { 0.683835f, 0.710781f, -0.164803f },
  { 0.684978f, -0.706284f, -0.178797f }, { 0.685943f, 0.724219f, 0.070636f },
  { 0.690624f, -0.711272f, -0.130885f }, { 0.691092f, -0.721209f, -0.047426f },
  { 0.691097f, 0.561331f, 0.455294f }, { 0.691208f, 0.707696f, -0.146283f },
  { 0.691289f, -0.722578f, 0.0f }, { 0.691289f, 0.722578f, 0.0f },
  { 0.691911f, 0.721035f, -0.036989f }, { 0.69209f, 0.720102f, -0.049644f },
  { 0.694196f, -0.71645f, 0.069213f }, { 0.69751f, 0.688508f, 0.198586f },
  { 0.698185f, 0.714891f, 0.038319f }, { 0.700244f, 0.437655f, -0.564019f },
  { 0.70037f, 0.587421f, -0.405486f }, { 0.700999f, 0.712175f, -0.03751f },
  { 0.707107f, -0.59303f, 0.385118f }, { 0.707107f, 0.0f, -0.707107f },
  { 0.707108f, 0.593029f, -0.385118f }, { 0.708246f, -0.695104f, -0.123362f },
  { 0.711637f, 0.550271f, -0.436777f }, { 0.711667f, -0.617925f, 0.334215f },
  { 0.714511f, 0.694593f, 0.083752f }, { 0.714725f, -0.087397f, 0.693924f },
  { 0.715794f, 0.680314f, 0.157516f }, { 0.718868f, -0.673733f, -0.171207f },
  { 0.719634f, -0.687937f, 0.094173f }, { 0.72178f, 0.075917f, 0.687946f },
  { 0.722006f, 0.0f, 0.691887f }, { 0.722698f, -0.126267f, 0.679532f },
  { 0.724018f, 0.679333f, -0.119597f }, { 0.729094f, -0.105633f, 0.676213f },
  { 0.729094f, -0.105633f, -0.676213f }, { 0.729094f, 0.105633f, 0.676213f },
  { 0.729094f, 0.105634f, -0.676213f }, { 0.732404f, -0.674103f, -0.09576f },
  { 0.733606f, -0.661907f, 0.153954f }, { 0.739858f, 0.667492f, 0.084054f },
  { 0.740278f, -0.578457f, 0.342601f }, { 0.741966f, -0.647703f, -0.173111f },
  { 0.742383f, -0.669896f, -0.010338f }, { 0.745907f, 0.303334f, -0.592969f },
  { 0.745907f, -0.66508f, 0.035926f }, { 0.746927f, 0.663489f, 0.043382f },
  { 0.753938f, 0.584991f, 0.298937f }, { 0.759743f, -0.327322f, -0.561828f },
  { 0.773955f, -0.48129f, -0.411525f }, { 0.775001f, 0.618655f, 0.128995f },
  { 0.792811f, -0.046409f, -0.607698f }, { 0.794137f, 0.0f, -0.607738f },
  { 0.795236f, 0.603922f, 0.053645f }, { 0.80565f, 0.534909f, -0.254559f },
  { 0.807982f, 0.58538f, -0.067048f }, { 0.809594f, 0.064543f, -0.58343f },
  { 0.813622f, 0.580052f, 0.039485f }, { 0.818388f, 0.225191f, 0.528706f },
  { 0.825685f, 0.009936f, -0.564044f }, { 0.828164f, -0.06879f, 0.556249f },
  { 0.838041f, -0.039957f, -0.544143f }, { 0.841793f, 0.110921f, 0.528282f },
  { 0.84209f, -0.119742f, 0.525877f }, { 0.844821f, 0.0f, 0.535048f },
  { 0.845156f, 0.02766f, 0.533804f }, { 0.845834f, 0.0f, 0.533446f },
  { 0.848668f, -0.22722f, 0.477633f }, { 0.854631f, 0.221971f, 0.469398f },
  { 0.855114f, 0.49486f, 0.154573f }, { 0.874518f, 0.010586f, 0.484877f },
  { 0.874662f, 0.480928f, 0.060616f }, { 0.874662f, -0.480928f, 0.060616f },
  { 0.878057f, 0.477406f, 0.033149f }, { 0.882741f, -0.031769f, 0.468785f },
  { 0.88686f, 0.426456f, 0.177806f }, { 0.886967f, 0.0f, -0.461834f },
  { 0.886967f, 0.0f, -0.461833f }, { 0.888054f, -0.425669f, 0.173686f },
  { 0.910955f, -0.008804f, 0.412411f }, { 0.914809f, 0.0f, 0.403887f },
  { 0.914809f, 0.0f, 0.403887f }, { 0.918241f, 0.191532f, 0.346625f },
  { 0.920247f, -0.183048f, 0.345889f }, { 0.920473f, 0.308418f, 0.240017f },
  { 0.924558f, -0.310914f, 0.220283f }, { 0.926244f, 0.243914f, 0.287363f },
  { 0.926697f, -0.006743f, 0.375749f }, { 0.926745f, -0.243639f, 0.285978f },
  { 0.935179f, 0.000868f, -0.354176f }, { 0.938718f, -0.123662f, -0.321739f },
  { 0.941992f, 0.003656f, 0.335616f }, { 0.962823f, 0.21306f, 0.166065f },
  { 0.964911f, 0.002956f, -0.262559f }, { 0.966968f, -0.062815f, 0.247037f },
  { 0.967416f, -0.182428f, -0.175573f }, { 0.967848f, -0.245026f, 0.056851f },
  { 0.968325f, 0.241658f, 0.062831f }, { 0.968738f, 0.181469f, -0.16916f },
  { 0.970711f, 0.228982f, 0.072722f }, { 0.971272f, 0.003148f, 0.23795f },
  { 0.971431f, -0.164114f, -0.17143f }, { 0.975123f, -0.062068f, -0.212799f },
  { 0.976754f, -0.053409f, 0.207604f }, { 0.977399f, -0.173316f, 0.121049f },
  { 0.977425f, -0.158828f, 0.139335f }, { 0.977533f, 0.036091f, -0.207669f },
  { 0.978123f, -0.099714f, -0.18257f }, { 0.978216f, -0.15174f, 0.141661f },
  { 0.981716f, 0.147615f, -0.120179f }, { 0.98188f, -0.12653f, 0.141074f },
  { 0.983792f, 0.173603f, -0.044889f }, { 0.983846f, -0.144147f, -0.106154f },
  { 0.984149f, -0.172096f, -0.04282f }, { 0.984441f, -0.158802f, 0.075213f },
  { 0.985199f, -0.171414f, 0.0f }, { 0.985199f, 0.171414f, 0.0f },
  { 0.985242f, 0.159806f, 0.061317f }, { 0.985784f, 0.02807f, 0.165656f },
  { 0.985822f, 0.0f, -0.167797f }, { 0.985942f, -0.123231f, 0.112843f },
  { 0.986106f, 0.0f, 0.166119f }, { 0.98662f, 0.136368f, 0.089356f },
  { 0.987065f, 0.083276f, 0.136992f }, { 0.987825f, -0.125593f, 0.0918f },
  { 0.989803f, 0.0f, 0.142442f }, { 0.990543f, 0.053721f, -0.12625f },
  { 0.99097f, 0.044318f, 0.126549f }, { 0.991322f, -0.036403f, 0.126316f },
  { 0.992018f, 0.0f, 0.1261f }, { 0.99356f, 0.0f, 0.113304f },
  { 0.99356f, 0.0f, 0.113304f }, { 0.994285f, 0.063433f, -0.085866f },
  { 0.994397f, 0.00012f, -0.105714f }, { 0.995608f, 0.055579f, 0.075335f },
  { 0.9961f, 0.0f, 0.088236f }, { 0.996195f, 0.0f, -0.087156f },
  { 0.996195f, 0.0f, -0.087156f }, { 0.996195f, -0.000001f, 0.087155f },
  { 0.996195f, 0.000001f, 0.087155f }, { 0.997418f, 0.0f, 0.071814f },
  { 0.997623f, 0.0f, -0.068903f }, { 0.997623f, 0.0f, -0.068903f },
  { 0.998608f, -0.006159f, 0.052385f }, { 0.999159f, 0.0f, -0.041013f },
  { 0.999249f, -0.00935f, 0.037607f }, { 0.99926f, -0.000001f, 0.038467f },
  { 0.99926f, 0.0f, 0.038466f }, { 1.0f, 0.0f, 0.0f }
};

TEST_TRIANGLE4 Greenmonk_triangle4[1380] = {
  { { 0, 4, 5 }, { 0, 0, 0 }, { 199, 73, 9 }, 3 }, { { 5, 1, 0 }, { 0, 0, 0 }, { 9, 184, 199 }, 3 },
  { { 1, 5, 6 }, { 0, 0, 0 }, { 184, 9, 1 }, 3 }, { { 6, 2, 1 }, { 0, 0, 0 }, { 1, 130, 184 }, 3 },
  { { 2, 6, 7 }, { 0, 0, 0 }, { 130, 1, 68 }, 3 }, { { 7, 3, 2 }, { 0, 0, 0 }, { 68, 182, 130 }, 3 },
  { { 4, 8, 9 }, { 0, 0, 0 }, { 73, 70, 10 }, 3 }, { { 9, 5, 4 }, { 0, 0, 0 }, { 10, 9, 73 }, 3 },
  { { 5, 9, 10 }, { 0, 0, 0 }, { 9, 10, 2 }, 3 }, { { 10, 6, 5 }, { 0, 0, 0 }, { 2, 1, 9 }, 3 },
  { { 6, 10, 11 }, { 0, 0, 0 }, { 1, 2, 67 }, 3 }, { { 11, 7, 6 }, { 0, 0, 0 }, { 67, 68, 1 }, 3 },
  { { 8, 12, 13 }, { 0, 0, 0 }, { 70, 200, 168 }, 3 }, { { 13, 9, 8 }, { 0, 0, 0 }, { 168, 10, 70 }, 3 },
  { { 9, 13, 14 }, { 0, 0, 0 }, { 10, 168, 39 }, 3 }, { { 14, 10, 9 }, { 0, 0, 0 }, { 39, 2, 10 }, 3 },
  { { 10, 14, 15 }, { 0, 0, 0 }, { 2, 39, 185 }, 3 }, { { 15, 11, 10 }, { 0, 0, 0 }, { 185, 67, 2 }, 3 },
  { { 16, 17, 21 }, { 0, 0, 0 }, { 593, 579, 730 }, 3 }, { { 21, 20, 16 }, { 0, 0, 0 }, { 730, 679, 593 }, 3 },
  { { 17, 18, 22 }, { 0, 0, 0 }, { 579, 587, 735 }, 3 }, { { 22, 21, 17 }, { 0, 0, 0 }, { 735, 730, 579 }, 3 },
  { { 18, 19, 23 }, { 0, 0, 0 }, { 587, 577, 669 }, 3 }, { { 23, 22, 18 }, { 0, 0, 0 }, { 669, 735, 587 }, 3 },
  { { 20, 21, 25 }, { 0, 0, 0 }, { 679, 730, 729 }, 3 }, { { 25, 24, 20 }, { 0, 0, 0 }, { 729, 681, 679 }, 3 },
  { { 21, 22, 26 }, { 0, 0, 0 }, { 730, 735, 734 }, 3 }, { { 26, 25, 21 }, { 0, 0, 0 }, { 734, 729, 730 }, 3 },
  { { 22, 23, 27 }, { 0, 0, 0 }, { 735, 669, 670 }, 3 }, { { 27, 26, 22 }, { 0, 0, 0 }, { 670, 734, 735 }, 3 },
  { { 24, 25, 29 }, { 0, 0, 0 }, { 681, 729, 617 }, 3 }, { { 29, 28, 24 }, { 0, 0, 0 }, { 617, 592, 681 }, 3 },
  { { 25, 26, 30 }, { 0, 0, 0 }, { 729, 734, 683 }, 3 }, { { 30, 29, 25 }, { 0, 0, 0 }, { 683, 617, 729 }, 3 },
  { { 26, 27, 31 }, { 0, 0, 0 }, { 734, 670, 575 }, 3 }, { { 31, 30, 26 }, { 0, 0, 0 }, { 575, 683, 734 }, 3 },
  { { 0, 1, 17 }, { 0, 0, 0 }, { 199, 184, 579 }, 3 }, { { 17, 16, 0 }, { 0, 0, 0 }, { 579, 593, 199 }, 3 },
  { { 1, 2, 18 }, { 0, 0, 0 }, { 184, 130, 587 }, 3 }, { { 18, 17, 1 }, { 0, 0, 0 }, { 587, 579, 184 }, 3 },
  { { 2, 3, 19 }, { 0, 0, 0 }, { 130, 182, 577 }, 3 }, { { 19, 18, 2 }, { 0, 0, 0 }, { 577, 587, 130 }, 3 },
  { { 36, 37, 41 }, { 0, 0, 0 }, { 76, 16, 278 }, 3 }, { { 41, 40, 36 }, { 0, 0, 0 }, { 278, 269, 76 }, 3 },
  { { 37, 38, 42 }, { 0, 0, 0 }, { 16, 17, 277 }, 3 }, { { 42, 41, 37 }, { 0, 0, 0 }, { 277, 278, 16 }, 3 },
  { { 38, 39, 43 }, { 0, 0, 0 }, { 17, 75, 268 }, 3 }, { { 43, 42, 38 }, { 0, 0, 0 }, { 268, 277, 17 }, 3 },
  { { 15, 14, 30 }, { 0, 0, 0 }, { 185, 39, 683 }, 3 }, { { 30, 31, 15 }, { 0, 0, 0 }, { 683, 575, 185 }, 3 },
  { { 32, 33, 35 }, { 0, 0, 0 }, { 169, 193, 533 }, 3 }, { { 35, 34, 32 }, { 0, 0, 0 }, { 533, 534, 169 }, 3 },
  { { 13, 12, 28 }, { 0, 0, 0 }, { 168, 200, 592 }, 3 }, { { 28, 29, 13 }, { 0, 0, 0 }, { 592, 617, 168 }, 3 },
  { { 12, 8, 24 }, { 0, 0, 0 }, { 200, 70, 681 }, 3 }, { { 24, 28, 12 }, { 0, 0, 0 }, { 681, 592, 200 }, 3 },
  { { 4, 0, 16 }, { 0, 0, 0 }, { 73, 199, 593 }, 3 }, { { 16, 20, 4 }, { 0, 0, 0 }, { 593, 679, 73 }, 3 },
  { { 14, 13, 33 }, { 0, 0, 0 }, { 39, 168, 193 }, 3 }, { { 33, 32, 14 }, { 0, 0, 0 }, { 193, 169, 39 }, 3 },
  { { 30, 14, 32 }, { 0, 0, 0 }, { 683, 39, 169 }, 3 }, { { 32, 34, 30 }, { 0, 0, 0 }, { 169, 534, 683 }, 3 },
  { { 13, 29, 35 }, { 0, 0, 0 }, { 168, 617, 533 }, 3 }, { { 35, 33, 13 }, { 0, 0, 0 }, { 533, 193, 168 }, 3 },
  { { 35, 30, 34 }, { 0, 0, 0 }, { 533, 683, 534 }, 3 }, { { 30, 35, 29 }, { 0, 0, 0 }, { 683, 533, 617 }, 3 },
  { { 40, 3, 36 }, { 0, 0, 0 }, { 269, 182, 76 }, 3 }, { { 3, 40, 19 }, { 0, 0, 0 }, { 182, 269, 577 }, 3 },
  { { 3, 7, 37 }, { 0, 0, 0 }, { 182, 68, 16 }, 3 }, { { 37, 36, 3 }, { 0, 0, 0 }, { 16, 76, 182 }, 3 },
  { { 7, 11, 38 }, { 0, 0, 0 }, { 68, 67, 17 }, 3 }, { { 38, 37, 7 }, { 0, 0, 0 }, { 17, 16, 68 }, 3 },
  { { 11, 15, 39 }, { 0, 0, 0 }, { 67, 185, 75 }, 3 }, { { 39, 38, 11 }, { 0, 0, 0 }, { 75, 17, 67 }, 3 },
  { { 23, 19, 40 }, { 0, 0, 0 }, { 669, 577, 269 }, 3 }, { { 40, 41, 23 }, { 0, 0, 0 }, { 269, 278, 669 }, 3 },
  { { 27, 23, 41 }, { 0, 0, 0 }, { 670, 669, 278 }, 3 }, { { 41, 42, 27 }, { 0, 0, 0 }, { 278, 277, 670 }, 3 },
  { { 15, 31, 43 }, { 0, 0, 0 }, { 185, 575, 268 }, 3 }, { { 43, 39, 15 }, { 0, 0, 0 }, { 268, 75, 185 }, 3 },
  { { 31, 27, 42 }, { 0, 0, 0 }, { 575, 670, 277 }, 3 }, { { 42, 43, 31 }, { 0, 0, 0 }, { 277, 268, 575 }, 3 },
  { { 8, 4, 44 }, { 0, 0, 0 }, { 70, 73, 148 }, 3 }, { { 44, 45, 8 }, { 0, 0, 0 }, { 148, 147, 70 }, 3 },
  { { 20, 24, 47 }, { 0, 0, 0 }, { 679, 681, 581 }, 3 }, { { 47, 46, 20 }, { 0, 0, 0 }, { 581, 580, 679 }, 3 },
  { { 24, 8, 45 }, { 0, 0, 0 }, { 681, 70, 147 }, 3 }, { { 45, 47, 24 }, { 0, 0, 0 }, { 147, 581, 681 }, 3 },
  { { 4, 20, 46 }, { 0, 0, 0 }, { 73, 679, 580 }, 3 }, { { 46, 44, 4 }, { 0, 0, 0 }, { 580, 148, 73 }, 3 },
  { { 67, 49, 50 }, { 435, 443, 411 }, { 616, 633, 425 }, 5 }, { { 50, 48, 67 }, { 411, 417, 435 }, { 425, 450, 616 }, 5 },
  { { 48, 50, 70 }, { 417, 411, 368 }, { 450, 425, 166 }, 5 }, { { 70, 69, 48 }, { 368, 378, 417 }, { 166, 221, 450 }, 5 },
  { { 49, 76, 51 }, { 443, 442, 407 }, { 633, 620, 427 }, 5 }, { { 51, 50, 49 }, { 407, 411, 443 }, { 427, 425, 633 }, 5 },
  { { 50, 51, 52 }, { 411, 407, 367 }, { 425, 427, 149 }, 5 }, { { 52, 70, 50 }, { 367, 368, 411 }, { 149, 166, 425 }, 5 },
  { { 76, 75, 53 }, { 442, 434, 408 }, { 620, 607, 430 }, 5 }, { { 53, 51, 76 }, { 408, 407, 442 }, { 430, 427, 620 }, 5 },
  { { 51, 53, 71 }, { 407, 408, 377 }, { 427, 430, 134 }, 5 }, { { 71, 52, 51 }, { 377, 367, 407 }, { 134, 149, 427 }, 5 },
  { { 80, 54, 55 }, { 371, 400, 401 }, { 569, 440, 313 }, 5 }, { { 55, 78, 80 }, { 401, 366, 371 }, { 313, 585, 569 }, 5 },
  { { 54, 68, 56 }, { 400, 428, 441 }, { 440, 204, 118 }, 5 }, { { 56, 55, 54 }, { 441, 401, 400 }, { 118, 313, 440 }, 5 },
  { { 78, 55, 57 }, { 366, 401, 416 }, { 585, 313, 315 }, 5 }, { { 57, 77, 78 }, { 416, 369, 366 }, { 315, 578, 585 }, 5 },
  { { 55, 56, 74 }, { 401, 441, 445 }, { 313, 118, 109 }, 5 }, { { 74, 57, 55 }, { 445, 416, 401 }, { 109, 315, 313 }, 5 },
  { { 77, 57, 59 }, { 369, 416, 420 }, { 578, 315, 320 }, 5 }, { { 59, 58, 77 }, { 420, 379, 369 }, { 320, 576, 578 }, 5 },
  { { 57, 74, 73 }, { 416, 445, 436 }, { 315, 109, 103 }, 5 }, { { 73, 59, 57 }, { 436, 420, 416 }, { 103, 320, 315 }, 5 },
  { { 67, 48, 60 }, { 372, 403, 404 }, { 616, 450, 477 }, 5 }, { { 60, 79, 67 }, { 404, 363, 372 }, { 477, 654, 616 }, 5 },
  { { 48, 69, 72 }, { 403, 429, 438 }, { 450, 221, 183 }, 5 }, { { 72, 60, 48 }, { 438, 404, 403 }, { 183, 477, 450 }, 5 },
  { { 79, 60, 54 }, { 363, 404, 405 }, { 654, 477, 440 }, 5 }, { { 54, 80, 79 }, { 405, 374, 363 }, { 440, 569, 654 }, 5 },
  { { 60, 72, 68 }, { 404, 438, 431 }, { 477, 183, 204 }, 5 }, { { 68, 54, 60 }, { 431, 405, 404 }, { 204, 440, 477 }, 5 },
  { { 69, 70, 61 }, { 259, 318, 319 }, { 221, 166, 40 }, 5 }, { { 61, 72, 69 }, { 319, 246, 259 }, { 40, 183, 221 }, 5 },
  { { 70, 52, 62 }, { 318, 503, 504 }, { 166, 149, 22 }, 5 }, { { 62, 61, 70 }, { 504, 319, 318 }, { 22, 40, 166 }, 5 },
  { { 52, 71, 63 }, { 503, 545, 547 }, { 149, 134, 15 }, 5 }, { { 63, 62, 52 }, { 547, 504, 503 }, { 15, 22, 149 }, 5 },
  { { 72, 61, 56 }, { 246, 319, 320 }, { 183, 40, 118 }, 5 }, { { 56, 68, 72 }, { 320, 260, 246 }, { 118, 204, 183 }, 5 },
  { { 61, 62, 74 }, { 319, 504, 505 }, { 40, 22, 109 }, 5 }, { { 74, 56, 61 }, { 505, 320, 319 }, { 109, 118, 40 }, 5 },
  { { 62, 63, 73 }, { 504, 547, 546 }, { 22, 15, 103 }, 5 }, { { 73, 74, 62 }, { 546, 505, 504 }, { 103, 109, 22 }, 5 },
  { { 75, 76, 65 }, { 244, 316, 315 }, { 607, 620, 696 }, 5 }, { { 65, 64, 75 }, { 315, 241, 244 }, { 696, 687, 607 }, 5 },
  { { 76, 49, 66 }, { 316, 502, 500 }, { 620, 633, 721 }, 5 }, { { 66, 65, 76 }, { 500, 315, 316 }, { 721, 696, 620 }, 5 },
  { { 49, 67, 79 }, { 502, 542, 544 }, { 633, 616, 654 }, 5 }, { { 79, 66, 49 }, { 544, 500, 502 }, { 654, 721, 633 }, 5 },
  { { 64, 65, 77 }, { 241, 315, 317 }, { 687, 696, 578 }, 5 }, { { 77, 58, 64 }, { 317, 245, 241 }, { 578, 576, 687 }, 5 },
  { { 65, 66, 78 }, { 315, 500, 501 }, { 696, 721, 585 }, 5 }, { { 78, 77, 65 }, { 501, 317, 315 }, { 585, 578, 696 }, 5 },
  { { 66, 79, 80 }, { 500, 544, 543 }, { 721, 654, 569 }, 5 }, { { 80, 78, 66 }, { 543, 501, 500 }, { 569, 585, 721 }, 5 },
  { { 100, 108, 82 }, { 465, 453, 402 }, { 647, 552, 289 }, 4 }, { { 82, 81, 100 }, { 402, 410, 465 }, { 289, 485, 647 }, 4 },
  { { 81, 82, 102 }, { 410, 402, 361 }, { 485, 289, 95 }, 4 }, { { 102, 101, 81 }, { 361, 343, 410 }, { 95, 222, 485 }, 4 },
  { { 108, 83, 84 }, { 453, 440, 406 }, { 552, 564, 316 }, 4 }, { { 84, 82, 108 }, { 406, 402, 453 }, { 316, 289, 552 }, 4 },
  { { 82, 84, 85 }, { 402, 406, 365 }, { 289, 316, 114 }, 4 }, { { 85, 102, 82 }, { 365, 361, 402 }, { 114, 95, 289 }, 4 },
  { { 83, 86, 87 }, { 440, 433, 399 }, { 564, 504, 257 }, 4 }, { { 87, 84, 83 }, { 399, 406, 440 }, { 257, 316, 564 }, 4 },
  { { 84, 87, 106 }, { 406, 399, 376 }, { 316, 257, 102 }, 4 }, { { 106, 85, 84 }, { 376, 365, 406 }, { 102, 114, 316 }, 4 },
  { { 114, 88, 90 }, { 344, 409, 413 }, { 642, 493, 321 }, 4 }, { { 90, 112, 114 }, { 413, 362, 344 }, { 321, 553, 642 }, 4 },
  { { 88, 89, 105 }, { 409, 466, 453 }, { 493, 234, 125 }, 4 }, { { 105, 90, 88 }, { 453, 413, 409 }, { 125, 321, 493 }, 4 },
  { { 112, 90, 91 }, { 362, 413, 418 }, { 553, 321, 335 }, 4 }, { { 91, 109, 112 }, { 418, 370, 362 }, { 335, 566, 553 }, 4 },
  { { 90, 105, 104 }, { 413, 453, 444 }, { 321, 125, 142 }, 4 }, { { 104, 91, 90 }, { 444, 418, 413 }, { 142, 335, 321 }, 4 },
  { { 109, 91, 92 }, { 370, 418, 419 }, { 566, 335, 254 }, 4 }, { { 92, 110, 109 }, { 419, 380, 370 }, { 254, 510, 566 }, 4 },
  { { 91, 104, 93 }, { 418, 444, 437 }, { 335, 142, 105 }, 4 }, { { 93, 92, 91 }, { 437, 419, 418 }, { 105, 254, 335 }, 4 },
  { { 100, 81, 94 }, { 345, 412, 414 }, { 647, 485, 502 }, 4 }, { { 94, 113, 100 }, { 414, 342, 345 }, { 502, 652, 647 }, 4 },
  { { 94, 101, 103 }, { 414, 467, 473 }, { 502, 222, 251 }, 4 }, { { 101, 94, 81 }, { 467, 414, 412 }, { 222, 502, 485 }, 4 },
  { { 114, 94, 88 }, { 346, 414, 415 }, { 642, 502, 493 }, 4 }, { { 94, 114, 113 }, { 414, 346, 342 }, { 502, 642, 652 }, 4 },
  { { 94, 103, 89 }, { 414, 473, 468 }, { 502, 251, 234 }, 4 }, { { 89, 88, 94 }, { 468, 415, 414 }, { 234, 493, 502 }, 4 },
  { { 101, 102, 95 }, { 282, 324, 325 }, { 222, 95, 45 }, 4 }, { { 95, 103, 101 }, { 325, 281, 282 }, { 45, 251, 222 }, 4 },
  { { 102, 85, 96 }, { 324, 480, 481 }, { 95, 114, 55 }, 4 }, { { 96, 95, 102 }, { 481, 325, 324 }, { 55, 45, 95 }, 4 },
  { { 85, 106, 107 }, { 480, 519, 521 }, { 114, 102, 61 }, 4 }, { { 107, 96, 85 }, { 521, 481, 480 }, { 61, 55, 114 }, 4 },
  { { 103, 95, 105 }, { 281, 325, 326 }, { 251, 45, 125 }, 4 }, { { 105, 89, 103 }, { 326, 283, 281 }, { 125, 234, 251 }, 4 },
  { { 95, 96, 104 }, { 325, 481, 482 }, { 45, 55, 142 }, 4 }, { { 104, 105, 95 }, { 482, 326, 325 }, { 142, 125, 45 }, 4 },
  { { 96, 107, 93 }, { 481, 521, 520 }, { 55, 61, 105 }, 4 }, { { 93, 104, 96 }, { 520, 482, 481 }, { 105, 142, 55 }, 4 },
  { { 106, 87, 97 }, { 373, 396, 397 }, { 102, 257, 236 }, 4 }, { { 97, 107, 106 }, { 397, 364, 373 }, { 236, 61, 102 }, 4 },
  { { 87, 86, 111 }, { 396, 430, 439 }, { 257, 504, 530 }, 4 }, { { 111, 97, 87 }, { 439, 397, 396 }, { 530, 236, 257 }, 4 },
  { { 107, 97, 92 }, { 364, 397, 398 }, { 61, 236, 254 }, 4 }, { { 92, 93, 107 }, { 398, 375, 364 }, { 254, 105, 61 }, 4 },
  { { 97, 111, 110 }, { 397, 439, 432 }, { 236, 530, 510 }, 4 }, { { 110, 92, 97 }, { 432, 398, 397 }, { 510, 254, 236 }, 4 },
  { { 86, 83, 98 }, { 285, 329, 330 }, { 504, 564, 672 }, 4 }, { { 98, 111, 86 }, { 330, 284, 285 }, { 672, 530, 504 }, 4 },
  { { 83, 108, 99 }, { 329, 485, 483 }, { 564, 552, 667 }, 4 }, { { 99, 98, 83 }, { 483, 330, 329 }, { 667, 672, 564 }, 4 },
  { { 108, 100, 113 }, { 485, 523, 524 }, { 552, 647, 652 }, 4 }, { { 113, 99, 108 }, { 524, 483, 485 }, { 652, 667, 552 }, 4 },
  { { 111, 98, 109 }, { 284, 330, 331 }, { 530, 672, 566 }, 4 }, { { 109, 110, 111 }, { 331, 286, 284 }, { 566, 510, 530 }, 4 },
  { { 98, 99, 112 }, { 330, 483, 484 }, { 672, 667, 553 }, 4 }, { { 112, 109, 98 }, { 484, 331, 330 }, { 553, 566, 672 }, 4 },
  { { 99, 113, 114 }, { 483, 524, 522 }, { 667, 652, 642 }, 4 }, { { 114, 112, 99 }, { 522, 484, 483 }, { 642, 553, 667 }, 4 },
  { { 116, 115, 137 }, { 402, 453, 465 }, { 451, 187, 94 }, 7 }, { { 137, 136, 116 }, { 465, 410, 402 }, { 94, 256, 451 }, 7 },
  { { 140, 116, 136 }, { 361, 402, 410 }, { 646, 451, 256 }, 7 }, { { 136, 139, 140 }, { 410, 343, 361 }, { 256, 518, 646 }, 7 },
  { { 118, 117, 115 }, { 406, 440, 453 }, { 423, 176, 187 }, 7 }, { { 115, 116, 118 }, { 453, 402, 406 }, { 187, 451, 423 }, 7 },
  { { 141, 118, 116 }, { 365, 406, 402 }, { 626, 423, 451 }, 7 }, { { 116, 140, 141 }, { 402, 361, 365 }, { 451, 646, 626 }, 7 },
  { { 120, 119, 117 }, { 399, 433, 440 }, { 484, 235, 176 }, 7 }, { { 117, 118, 120 }, { 440, 406, 399 }, { 176, 423, 484 }, 7 },
  { { 121, 120, 118 }, { 376, 399, 406 }, { 640, 484, 423 }, 7 }, { { 118, 141, 121 }, { 406, 365, 376 }, { 423, 626, 640 }, 7 },
  { { 124, 122, 148 }, { 413, 409, 344 }, { 417, 249, 100 }, 7 }, { { 148, 123, 124 }, { 344, 362, 413 }, { 100, 186, 417 }, 7 },
  { { 125, 138, 122 }, { 453, 466, 409 }, { 615, 505, 249 }, 7 }, { { 122, 124, 125 }, { 409, 413, 453 }, { 249, 417, 615 }, 7 },
  { { 126, 124, 123 }, { 418, 413, 362 }, { 405, 417, 186 }, 7 }, { { 123, 147, 126 }, { 362, 370, 418 }, { 186, 174, 405 }, 7 },
  { { 143, 125, 124 }, { 444, 453, 413 }, { 596, 615, 417 }, 7 }, { { 124, 126, 143 }, { 413, 418, 444 }, { 417, 405, 596 }, 7 },
  { { 127, 126, 147 }, { 419, 418, 370 }, { 487, 405, 174 }, 7 }, { { 147, 145, 127 }, { 370, 380, 419 }, { 174, 229, 487 }, 7 },
  { { 142, 143, 126 }, { 437, 444, 418 }, { 634, 596, 405 }, 7 }, { { 126, 127, 142 }, { 418, 419, 437 }, { 405, 487, 634 }, 7 },
  { { 129, 136, 137 }, { 414, 412, 345 }, { 237, 256, 94 }, 7 }, { { 137, 128, 129 }, { 345, 342, 414 }, { 94, 89, 237 }, 7 },
  { { 130, 139, 129 }, { 473, 467, 414 }, { 491, 518, 237 }, 7 }, { { 136, 129, 139 }, { 412, 414, 467 }, { 256, 237, 518 }, 7 },
  { { 122, 129, 148 }, { 415, 414, 346 }, { 249, 237, 100 }, 7 }, { { 128, 148, 129 }, { 342, 346, 414 }, { 89, 100, 237 }, 7 },
  { { 138, 130, 129 }, { 468, 473, 414 }, { 505, 491, 237 }, 7 }, { { 129, 122, 138 }, { 414, 415, 468 }, { 237, 249, 505 }, 7 },
  { { 131, 140, 139 }, { 325, 324, 282 }, { 695, 646, 518 }, 7 }, { { 139, 130, 131 }, { 282, 281, 325 }, { 518, 491, 695 }, 7 },
  { { 132, 141, 140 }, { 481, 480, 324 }, { 686, 626, 646 }, 7 }, { { 140, 131, 132 }, { 324, 325, 481 }, { 646, 695, 686 }, 7 },
  { { 144, 121, 141 }, { 521, 519, 480 }, { 680, 640, 626 }, 7 }, { { 141, 132, 144 }, { 480, 481, 521 }, { 626, 686, 680 }, 7 },
  { { 125, 131, 130 }, { 326, 325, 281 }, { 615, 695, 491 }, 7 }, { { 130, 138, 125 }, { 281, 283, 326 }, { 491, 505, 615 }, 7 },
  { { 143, 132, 131 }, { 482, 481, 325 }, { 596, 686, 695 }, 7 }, { { 131, 125, 143 }, { 325, 326, 482 }, { 695, 615, 596 }, 7 },
  { { 142, 144, 132 }, { 520, 521, 481 }, { 634, 680, 686 }, 7 }, { { 132, 143, 142 }, { 481, 482, 520 }, { 686, 596, 634 }, 7 },
  { { 133, 120, 121 }, { 397, 396, 373 }, { 503, 484, 640 }, 7 }, { { 121, 144, 133 }, { 373, 364, 397 }, { 640, 680, 503 }, 7 },
  { { 146, 119, 120 }, { 439, 430, 396 }, { 209, 235, 484 }, 7 }, { { 120, 133, 146 }, { 396, 397, 439 }, { 484, 503, 209 }, 7 },
  { { 127, 133, 144 }, { 398, 397, 364 }, { 487, 503, 680 }, 7 }, { { 144, 142, 127 }, { 364, 375, 398 }, { 680, 634, 487 }, 7 },
  { { 145, 146, 133 }, { 432, 439, 397 }, { 229, 209, 503 }, 7 }, { { 133, 127, 145 }, { 397, 398, 432 }, { 503, 487, 229 }, 7 },
  { { 134, 117, 119 }, { 330, 329, 285 }, { 69, 176, 235 }, 7 }, { { 119, 146, 134 }, { 285, 284, 330 }, { 235, 209, 69 }, 7 },
  { { 135, 115, 117 }, { 483, 485, 329 }, { 74, 187, 176 }, 7 }, { { 117, 134, 135 }, { 329, 330, 483 }, { 176, 69, 74 }, 7 },
  { { 128, 137, 115 }, { 524, 523, 485 }, { 89, 94, 187 }, 7 }, { { 115, 135, 128 }, { 485, 483, 524 }, { 187, 74, 89 }, 7 },
  { { 147, 134, 146 }, { 331, 330, 284 }, { 174, 69, 209 }, 7 }, { { 146, 145, 147 }, { 284, 286, 331 }, { 209, 229, 174 }, 7 },
  { { 123, 135, 134 }, { 484, 483, 330 }, { 186, 74, 69 }, 7 }, { { 134, 147, 123 }, { 330, 331, 484 }, { 69, 174, 186 }, 7 },
  { { 148, 128, 135 }, { 522, 524, 483 }, { 100, 89, 74 }, 7 }, { { 135, 123, 148 }, { 483, 484, 522 }, { 74, 186, 100 }, 7 },
  { { 149, 180, 172 }, { 411, 443, 435 }, { 314, 106, 123 }, 9 }, { { 172, 171, 149 }, { 435, 417, 411 }, { 123, 290, 314 }, 9 },
  { { 176, 149, 171 }, { 368, 411, 417 }, { 573, 314, 290 }, 9 }, { { 171, 173, 176 }, { 417, 378, 368 }, { 290, 519, 573 }, 9 },
  { { 150, 181, 180 }, { 407, 442, 443 }, { 312, 119, 106 }, 9 }, { { 180, 149, 150 }, { 443, 411, 407 }, { 106, 314, 312 }, 9 },
  { { 151, 150, 149 }, { 367, 407, 411 }, { 588, 312, 314 }, 9 }, { { 149, 176, 151 }, { 411, 368, 367 }, { 314, 573, 588 }, 9 },
  { { 153, 152, 181 }, { 408, 434, 442 }, { 311, 131, 119 }, 9 }, { { 181, 150, 153 }, { 442, 407, 408 }, { 119, 312, 311 }, 9 },
  { { 154, 153, 150 }, { 377, 408, 407 }, { 604, 311, 312 }, 9 }, { { 150, 151, 154 }, { 407, 367, 377 }, { 312, 588, 604 }, 9 },
  { { 156, 174, 175 }, { 401, 400, 371 }, { 426, 299, 170 }, 9 }, { { 175, 155, 156 }, { 371, 366, 401 }, { 170, 154, 426 }, 9 },
  { { 157, 177, 174 }, { 441, 428, 400 }, { 621, 535, 299 }, 9 }, { { 174, 156, 157 }, { 400, 401, 441 }, { 299, 426, 621 }, 9 },
  { { 159, 156, 155 }, { 416, 401, 366 }, { 424, 426, 154 }, 9 }, { { 155, 158, 159 }, { 366, 369, 416 }, { 154, 161, 424 }, 9 },
  { { 160, 157, 156 }, { 445, 441, 401 }, { 631, 621, 426 }, 9 }, { { 156, 159, 160 }, { 401, 416, 445 }, { 426, 424, 631 }, 9 },
  { { 162, 159, 158 }, { 420, 416, 369 }, { 420, 424, 161 }, 9 }, { { 158, 161, 162 }, { 369, 379, 420 }, { 161, 163, 420 }, 9 },
  { { 179, 160, 159 }, { 436, 445, 416 }, { 636, 631, 424 }, 9 }, { { 159, 162, 179 }, { 416, 420, 436 }, { 424, 420, 636 }, 9 },
  { { 164, 171, 172 }, { 404, 403, 372 }, { 263, 290, 123 }, 9 }, { { 172, 163, 164 }, { 372, 363, 404 }, { 123, 88, 263 }, 9 },
  { { 178, 173, 171 }, { 438, 429, 403 }, { 556, 519, 290 }, 9 }, { { 171, 164, 178 }, { 403, 404, 438 }, { 290, 263, 556 }, 9 },
  { { 174, 164, 163 }, { 405, 404, 363 }, { 299, 263, 88 }, 9 }, { { 163, 175, 174 }, { 363, 374, 405 }, { 88, 170, 299 }, 9 },
  { { 177, 178, 164 }, { 431, 438, 404 }, { 535, 556, 263 }, 9 }, { { 164, 174, 177 }, { 404, 405, 431 }, { 263, 299, 535 }, 9 },
  { { 165, 176, 173 }, { 319, 318, 259 }, { 699, 573, 519 }, 9 }, { { 173, 178, 165 }, { 259, 246, 319 }, { 519, 556, 699 }, 9 },
  { { 166, 151, 176 }, { 504, 503, 318 }, { 719, 588, 573 }, 9 }, { { 176, 165, 166 }, { 318, 319, 504 }, { 573, 699, 719 }, 9 },
  { { 167, 154, 151 }, { 547, 545, 503 }, { 725, 604, 588 }, 9 }, { { 151, 166, 167 }, { 503, 504, 547 }, { 588, 719, 725 }, 9 },
  { { 157, 165, 178 }, { 320, 319, 246 }, { 621, 699, 556 }, 9 }, { { 178, 177, 157 }, { 246, 260, 320 }, { 556, 535, 621 }, 9 },
  { { 160, 166, 165 }, { 505, 504, 319 }, { 631, 719, 699 }, 9 }, { { 165, 157, 160 }, { 319, 320, 505 }, { 699, 621, 631 }, 9 },
  { { 179, 167, 166 }, { 546, 547, 504 }, { 636, 725, 719 }, 9 }, { { 166, 160, 179 }, { 504, 505, 546 }, { 719, 631, 636 }, 9 },
  { { 169, 181, 152 }, { 315, 316, 244 }, { 43, 119, 131 }, 9 }, { { 152, 168, 169 }, { 244, 241, 315 }, { 131, 54, 43 }, 9 },
  { { 170, 180, 181 }, { 500, 502, 316 }, { 20, 106, 119 }, 9 }, { { 181, 169, 170 }, { 316, 315, 500 }, { 119, 43, 20 }, 9 },
  { { 163, 172, 180 }, { 544, 542, 502 }, { 88, 123, 106 }, 9 }, { { 180, 170, 163 }, { 502, 500, 544 }, { 106, 20, 88 }, 9 },
  { { 158, 169, 168 }, { 317, 315, 241 }, { 161, 43, 54 }, 9 }, { { 168, 161, 158 }, { 241, 245, 317 }, { 54, 163, 161 }, 9 },
  { { 155, 170, 169 }, { 501, 500, 315 }, { 154, 20, 43 }, 9 }, { { 169, 158, 155 }, { 315, 317, 501 }, { 43, 161, 154 }, 9 },
  { { 175, 163, 170 }, { 543, 544, 500 }, { 170, 88, 20 }, 9 }, { { 170, 155, 175 }, { 500, 501, 543 }, { 20, 154, 170 }, 9 },
  { { 187, 186, 182 }, { 0, 0, 0 }, { 731, 668, 539 }, 6 }, { { 182, 183, 187 }, { 0, 0, 0 }, { 539, 555, 731 }, 6 },
  { { 188, 187, 183 }, { 0, 0, 0 }, { 739, 731, 555 }, 6 }, { { 183, 184, 188 }, { 0, 0, 0 }, { 555, 611, 739 }, 6 },
  { { 189, 188, 184 }, { 0, 0, 0 }, { 674, 739, 611 }, 6 }, { { 184, 185, 189 }, { 0, 0, 0 }, { 611, 558, 674 }, 6 },
  { { 191, 190, 186 }, { 0, 0, 0 }, { 732, 671, 668 }, 6 }, { { 186, 187, 191 }, { 0, 0, 0 }, { 668, 731, 732 }, 6 },
  { { 192, 191, 187 }, { 0, 0, 0 }, { 740, 732, 731 }, 6 }, { { 187, 188, 192 }, { 0, 0, 0 }, { 731, 739, 740 }, 6 },
  { { 193, 192, 188 }, { 0, 0, 0 }, { 673, 740, 739 }, 6 }, { { 188, 189, 193 }, { 0, 0, 0 }, { 739, 674, 673 }, 6 },
  { { 195, 194, 190 }, { 0, 0, 0 }, { 571, 538, 671 }, 6 }, { { 190, 191, 195 }, { 0, 0, 0 }, { 671, 732, 571 }, 6 },
  { { 196, 195, 191 }, { 0, 0, 0 }, { 700, 571, 732 }, 6 }, { { 191, 192, 196 }, { 0, 0, 0 }, { 732, 740, 700 }, 6 },
  { { 197, 196, 192 }, { 0, 0, 0 }, { 554, 700, 740 }, 6 }, { { 192, 193, 197 }, { 0, 0, 0 }, { 740, 673, 554 }, 6 },
  { { 203, 199, 198 }, { 0, 0, 0 }, { 11, 160, 145 }, 6 }, { { 198, 202, 203 }, { 0, 0, 0 }, { 145, 62, 11 }, 6 },
  { { 204, 200, 199 }, { 0, 0, 0 }, { 6, 150, 160 }, 6 }, { { 199, 203, 204 }, { 0, 0, 0 }, { 160, 11, 6 }, 6 },
  { { 205, 201, 200 }, { 0, 0, 0 }, { 71, 162, 150 }, 6 }, { { 200, 204, 205 }, { 0, 0, 0 }, { 150, 6, 71 }, 6 },
  { { 207, 203, 202 }, { 0, 0, 0 }, { 12, 11, 62 }, 6 }, { { 202, 206, 207 }, { 0, 0, 0 }, { 62, 60, 12 }, 6 },
  { { 208, 204, 203 }, { 0, 0, 0 }, { 7, 6, 11 }, 6 }, { { 203, 207, 208 }, { 0, 0, 0 }, { 11, 12, 7 }, 6 },
  { { 209, 205, 204 }, { 0, 0, 0 }, { 72, 71, 6 }, 6 }, { { 204, 208, 209 }, { 0, 0, 0 }, { 6, 7, 72 }, 6 },
  { { 211, 207, 206 }, { 0, 0, 0 }, { 122, 12, 60 }, 6 }, { { 206, 210, 211 }, { 0, 0, 0 }, { 60, 146, 122 }, 6 },
  { { 212, 208, 207 }, { 0, 0, 0 }, { 58, 7, 12 }, 6 }, { { 207, 211, 212 }, { 0, 0, 0 }, { 12, 122, 58 }, 6 },
  { { 213, 209, 208 }, { 0, 0, 0 }, { 164, 72, 7 }, 6 }, { { 208, 212, 213 }, { 0, 0, 0 }, { 7, 58, 164 }, 6 },
  { { 199, 183, 182 }, { 0, 0, 0 }, { 160, 555, 539 }, 6 }, { { 182, 198, 199 }, { 0, 0, 0 }, { 539, 145, 160 }, 6 },
  { { 200, 184, 183 }, { 0, 0, 0 }, { 150, 611, 555 }, 6 }, { { 183, 199, 200 }, { 0, 0, 0 }, { 555, 160, 150 }, 6 },
  { { 201, 185, 184 }, { 0, 0, 0 }, { 162, 558, 611 }, 6 }, { { 184, 200, 201 }, { 0, 0, 0 }, { 611, 150, 162 }, 6 },
  { { 223, 219, 218 }, { 0, 0, 0 }, { 461, 724, 664 }, 6 }, { { 218, 222, 223 }, { 0, 0, 0 }, { 664, 469, 461 }, 6 },
  { { 224, 220, 219 }, { 0, 0, 0 }, { 462, 723, 724 }, 6 }, { { 219, 223, 224 }, { 0, 0, 0 }, { 724, 461, 462 }, 6 },
  { { 225, 221, 220 }, { 0, 0, 0 }, { 470, 665, 723 }, 6 }, { { 220, 224, 225 }, { 0, 0, 0 }, { 723, 462, 470 }, 6 },
  { { 212, 196, 197 }, { 0, 0, 0 }, { 58, 700, 554 }, 6 }, { { 197, 213, 212 }, { 0, 0, 0 }, { 554, 164, 58 }, 6 },
  { { 217, 215, 214 }, { 0, 0, 0 }, { 206, 545, 570 }, 6 }, { { 214, 216, 217 }, { 0, 0, 0 }, { 570, 205, 206 }, 6 },
  { { 210, 194, 195 }, { 0, 0, 0 }, { 146, 538, 571 }, 6 }, { { 195, 211, 210 }, { 0, 0, 0 }, { 571, 122, 146 }, 6 },
  { { 206, 190, 194 }, { 0, 0, 0 }, { 60, 671, 538 }, 6 }, { { 194, 210, 206 }, { 0, 0, 0 }, { 538, 146, 60 }, 6 },
  { { 198, 182, 186 }, { 0, 0, 0 }, { 145, 539, 668 }, 6 }, { { 186, 202, 198 }, { 0, 0, 0 }, { 668, 62, 145 }, 6 },
  { { 215, 195, 196 }, { 0, 0, 0 }, { 545, 571, 700 }, 6 }, { { 196, 214, 215 }, { 0, 0, 0 }, { 700, 570, 545 }, 6 },
  { { 214, 196, 212 }, { 0, 0, 0 }, { 570, 700, 58 }, 6 }, { { 212, 216, 214 }, { 0, 0, 0 }, { 58, 205, 570 }, 6 },
  { { 217, 211, 195 }, { 0, 0, 0 }, { 206, 122, 571 }, 6 }, { { 195, 215, 217 }, { 0, 0, 0 }, { 571, 545, 206 }, 6 },
  { { 216, 212, 217 }, { 0, 0, 0 }, { 205, 58, 206 }, 6 }, { { 211, 217, 212 }, { 0, 0, 0 }, { 122, 206, 58 }, 6 },
  { { 218, 185, 222 }, { 0, 0, 0 }, { 664, 558, 469 }, 6 }, { { 201, 222, 185 }, { 0, 0, 0 }, { 162, 469, 558 }, 6 },
  { { 219, 189, 185 }, { 0, 0, 0 }, { 724, 674, 558 }, 6 }, { { 185, 218, 219 }, { 0, 0, 0 }, { 558, 664, 724 }, 6 },
  { { 220, 193, 189 }, { 0, 0, 0 }, { 723, 673, 674 }, 6 }, { { 189, 219, 220 }, { 0, 0, 0 }, { 674, 724, 723 }, 6 },
  { { 221, 197, 193 }, { 0, 0, 0 }, { 665, 554, 673 }, 6 }, { { 193, 220, 221 }, { 0, 0, 0 }, { 673, 723, 665 }, 6 },
  { { 222, 201, 205 }, { 0, 0, 0 }, { 469, 162, 71 }, 6 }, { { 205, 223, 222 }, { 0, 0, 0 }, { 71, 461, 469 }, 6 },
  { { 223, 205, 209 }, { 0, 0, 0 }, { 461, 71, 72 }, 6 }, { { 209, 224, 223 }, { 0, 0, 0 }, { 72, 462, 461 }, 6 },
  { { 225, 213, 197 }, { 0, 0, 0 }, { 470, 164, 554 }, 6 }, { { 197, 221, 225 }, { 0, 0, 0 }, { 554, 665, 470 }, 6 },
  { { 224, 209, 213 }, { 0, 0, 0 }, { 462, 72, 164 }, 6 }, { { 213, 225, 224 }, { 0, 0, 0 }, { 164, 470, 462 }, 6 },
  { { 226, 186, 190 }, { 0, 0, 0 }, { 590, 668, 671 }, 6 }, { { 190, 227, 226 }, { 0, 0, 0 }, { 671, 591, 590 }, 6 },
  { { 229, 206, 202 }, { 0, 0, 0 }, { 158, 60, 62 }, 6 }, { { 202, 228, 229 }, { 0, 0, 0 }, { 62, 159, 158 }, 6 },
  { { 227, 190, 206 }, { 0, 0, 0 }, { 591, 671, 60 }, 6 }, { { 206, 229, 227 }, { 0, 0, 0 }, { 60, 158, 591 }, 6 },
  { { 228, 202, 186 }, { 0, 0, 0 }, { 159, 62, 668 }, 6 }, { { 186, 226, 228 }, { 0, 0, 0 }, { 668, 590, 159 }, 6 },
  { { 235, 231, 230 }, { 0, 0, 0 }, { 202, 537, 613 }, 1 }, { { 234, 235, 230 }, { 0, 0, 0 }, { 126, 202, 613 }, 1 },
  { { 236, 232, 231 }, { 0, 0, 0 }, { 151, 586, 537 }, 1 }, { { 235, 236, 231 }, { 0, 0, 0 }, { 202, 151, 537 }, 1 },
  { { 237, 233, 232 }, { 0, 0, 0 }, { 218, 522, 586 }, 1 }, { { 236, 237, 232 }, { 0, 0, 0 }, { 151, 218, 586 }, 1 },
  { { 233, 230, 232 }, { 0, 0, 0 }, { 522, 613, 586 }, 1 }, { { 232, 230, 231 }, { 0, 0, 0 }, { 586, 613, 537 }, 1 },
  { { 234, 237, 236 }, { 0, 0, 0 }, { 126, 218, 151 }, 1 }, { { 234, 236, 235 }, { 0, 0, 0 }, { 126, 151, 202 }, 1 },
  { { 242, 239, 238 }, { 0, 0, 0 }, { 104, 246, 101 }, 1 }, { { 239, 242, 243 }, { 0, 0, 0 }, { 246, 104, 279 }, 1 },
  { { 244, 240, 239 }, { 0, 0, 0 }, { 460, 495, 246 }, 1 }, { { 239, 243, 244 }, { 0, 0, 0 }, { 246, 279, 460 }, 1 },
  { { 245, 241, 240 }, { 0, 0, 0 }, { 635, 641, 495 }, 1 }, { { 240, 244, 245 }, { 0, 0, 0 }, { 495, 460, 635 }, 1 },
  { { 247, 243, 242 }, { 0, 0, 0 }, { 282, 279, 104 }, 1 }, { { 242, 246, 247 }, { 0, 0, 0 }, { 104, 108, 282 }, 1 },
  { { 248, 244, 243 }, { 0, 0, 0 }, { 455, 460, 279 }, 1 }, { { 243, 247, 248 }, { 0, 0, 0 }, { 279, 282, 455 }, 1 },
  { { 249, 245, 244 }, { 0, 0, 0 }, { 632, 635, 460 }, 1 }, { { 244, 248, 249 }, { 0, 0, 0 }, { 460, 455, 632 }, 1 },
  { { 251, 247, 250 }, { 0, 0, 0 }, { 270, 282, 167 }, 1 }, { { 246, 250, 247 }, { 0, 0, 0 }, { 108, 167, 282 }, 1 },
  { { 252, 248, 247 }, { 0, 0, 0 }, { 472, 455, 282 }, 1 }, { { 247, 251, 252 }, { 0, 0, 0 }, { 282, 270, 472 }, 1 },
  { { 253, 248, 252 }, { 0, 0, 0 }, { 565, 455, 472 }, 1 }, { { 248, 253, 249 }, { 0, 0, 0 }, { 455, 565, 632 }, 1 },
  { { 239, 254, 238 }, { 0, 0, 0 }, { 246, 245, 101 }, 1 }, { { 240, 255, 254 }, { 0, 0, 0 }, { 495, 497, 245 }, 1 },
  { { 254, 239, 240 }, { 0, 0, 0 }, { 245, 246, 495 }, 1 }, { { 255, 240, 241 }, { 0, 0, 0 }, { 497, 495, 641 }, 1 },
  { { 245, 256, 241 }, { 0, 0, 0 }, { 635, 694, 641 }, 1 }, { { 249, 257, 256 }, { 0, 0, 0 }, { 632, 701, 694 }, 1 },
  { { 256, 245, 249 }, { 0, 0, 0 }, { 694, 635, 632 }, 1 }, { { 253, 258, 257 }, { 0, 0, 0 }, { 565, 625, 701 }, 1 },
  { { 257, 249, 253 }, { 0, 0, 0 }, { 701, 632, 565 }, 1 }, { { 252, 259, 258 }, { 0, 0, 0 }, { 472, 483, 625 }, 1 },
  { { 258, 253, 252 }, { 0, 0, 0 }, { 625, 565, 472 }, 1 }, { { 251, 260, 259 }, { 0, 0, 0 }, { 270, 259, 483 }, 1 },
  { { 259, 252, 251 }, { 0, 0, 0 }, { 483, 472, 270 }, 1 }, { { 250, 261, 260 }, { 0, 0, 0 }, { 167, 107, 259 }, 1 },
  { { 260, 251, 250 }, { 0, 0, 0 }, { 259, 270, 167 }, 1 }, { { 246, 262, 261 }, { 0, 0, 0 }, { 108, 47, 107 }, 1 },
  { { 261, 250, 246 }, { 0, 0, 0 }, { 107, 167, 108 }, 1 }, { { 242, 263, 262 }, { 0, 0, 0 }, { 104, 46, 47 }, 1 },
  { { 262, 246, 242 }, { 0, 0, 0 }, { 47, 108, 104 }, 1 }, { { 263, 242, 238 }, { 0, 0, 0 }, { 46, 104, 101 }, 1 },
  { { 267, 371, 370 }, { 179, 212, 223 }, { 284, 91, 98 }, 2 }, { { 370, 264, 267 }, { 223, 183, 179 }, { 98, 302, 284 }, 2 },
  { { 268, 267, 264 }, { 109, 179, 183 }, { 377, 284, 302 }, 2 }, { { 264, 265, 268 }, { 183, 113, 109 }, { 302, 382, 377 }, 2 },
  { { 269, 268, 265 }, { 37, 109, 113 }, { 478, 377, 382 }, 2 }, { { 265, 266, 269 }, { 113, 33, 37 }, { 382, 447, 478 }, 2 },
  { { 378, 269, 266 }, { 9, 37, 33 }, { 648, 478, 447 }, 2 }, { { 266, 361, 378 }, { 33, 7, 9 }, { 447, 639, 648 }, 2 },
  { { 351, 388, 389 }, { 124, 144, 146 }, { 253, 124, 175 }, 2 }, { { 389, 344, 351 }, { 67, 90, 94 }, { 175, 288, 253 }, 2 },
  { { 353, 351, 344 }, { 114, 94, 90 }, { 376, 253, 288 }, 2 }, { { 344, 345, 353 }, { 90, 115, 114 }, { 288, 372, 376 }, 2 },
  { { 271, 353, 345 }, { 125, 114, 115 }, { 490, 376, 372 }, 2 }, { { 345, 346, 271 }, { 115, 128, 125 }, { 372, 454, 490 }, 2 },
  { { 391, 271, 352 }, { 72, 93, 66 }, { 608, 490, 557 }, 2 }, { { 346, 352, 271 }, { 128, 147, 125 }, { 454, 557, 490 }, 2 },
  { { 274, 392, 388 }, { 123, 142, 144 }, { 247, 171, 124 }, 2 }, { { 388, 351, 274 }, { 144, 124, 123 }, { 124, 253, 247 }, 2 },
  { { 275, 274, 351 }, { 112, 123, 124 }, { 401, 247, 253 }, 2 }, { { 351, 353, 275 }, { 124, 111, 112 }, { 253, 376, 401 }, 2 },
  { { 276, 275, 353 }, { 95, 112, 111 }, { 494, 401, 376 }, 2 }, { { 353, 271, 276 }, { 111, 93, 95 }, { 376, 490, 494 }, 2 },
  { { 393, 276, 271 }, { 74, 95, 93 }, { 589, 494, 490 }, 2 }, { { 271, 391, 393 }, { 93, 72, 74 }, { 490, 608, 589 }, 2 },
  { { 348, 347, 392 }, { 127, 143, 142 }, { 255, 203, 171 }, 2 }, { { 392, 274, 348 }, { 142, 123, 127 }, { 171, 247, 255 }, 2 },
  { { 349, 348, 274 }, { 107, 127, 123 }, { 395, 255, 247 }, 2 }, { { 274, 275, 349 }, { 123, 112, 107 }, { 247, 401, 395 }, 2 },
  { { 350, 349, 275 }, { 91, 107, 112 }, { 482, 395, 401 }, 2 }, { { 275, 276, 350 }, { 112, 95, 91 }, { 401, 494, 482 }, 2 },
  { { 394, 350, 276 }, { 73, 91, 95 }, { 548, 482, 494 }, 2 }, { { 276, 393, 394 }, { 95, 74, 73 }, { 494, 589, 548 }, 2 },
  { { 354, 282, 377 }, { 36, 34, 8 }, { 525, 517, 227 }, 2 }, { { 377, 376, 354 }, { 6, 24, 23 }, { 227, 258, 525 }, 2 },
  { { 286, 283, 282 }, { 117, 113, 34 }, { 339, 338, 517 }, 2 }, { { 282, 354, 286 }, { 34, 36, 117 }, { 517, 525, 339 }, 2 },
  { { 355, 284, 283 }, { 180, 182, 113 }, { 212, 213, 338 }, 2 }, { { 283, 286, 355 }, { 113, 117, 180 }, { 338, 339, 212 }, 2 },
  { { 362, 285, 284 }, { 214, 222, 182 }, { 486, 527, 213 }, 2 }, { { 284, 355, 362 }, { 238, 200, 202 }, { 213, 212, 486 }, 2 },
  { { 356, 354, 376 }, { 87, 23, 24 }, { 532, 525, 258 }, 2 }, { { 376, 374, 356 }, { 24, 88, 87 }, { 258, 260, 532 }, 2 },
  { { 287, 286, 354 }, { 119, 117, 36 }, { 340, 339, 525 }, 2 }, { { 354, 356, 287 }, { 36, 45, 119 }, { 525, 532, 340 }, 2 },
  { { 288, 355, 286 }, { 168, 180, 117 }, { 208, 212, 339 }, 2 }, { { 286, 287, 288 }, { 117, 119, 168 }, { 339, 340, 208 }, 2 },
  { { 363, 362, 355 }, { 135, 202, 200 }, { 481, 486, 212 }, 2 }, { { 355, 288, 363 }, { 200, 134, 135 }, { 212, 208, 481 }, 2 },
  { { 359, 356, 374 }, { 181, 87, 88 }, { 516, 532, 260 }, 2 }, { { 374, 375, 359 }, { 88, 173, 181 }, { 260, 250, 516 }, 2 },
  { { 289, 287, 356 }, { 120, 119, 45 }, { 400, 340, 532 }, 2 }, { { 356, 359, 289 }, { 45, 46, 120 }, { 532, 516, 400 }, 2 },
  { { 357, 288, 287 }, { 167, 168, 119 }, { 223, 208, 340 }, 2 }, { { 287, 289, 357 }, { 119, 120, 167 }, { 340, 400, 223 }, 2 },
  { { 364, 363, 288 }, { 44, 135, 134 }, { 488, 481, 208 }, 2 }, { { 288, 357, 364 }, { 134, 35, 44 }, { 208, 223, 488 }, 2 },
  { { 290, 359, 358 }, { 52, 46, 26 }, { 305, 516, 214 }, 2 }, { { 375, 358, 359 }, { 173, 208, 181 }, { 250, 214, 516 }, 2 },
  { { 368, 289, 359 }, { 121, 120, 46 }, { 413, 400, 516 }, 2 }, { { 359, 290, 368 }, { 46, 52, 121 }, { 516, 305, 413 }, 2 },
  { { 291, 357, 289 }, { 165, 167, 120 }, { 457, 223, 400 }, 2 }, { { 289, 368, 291 }, { 120, 121, 165 }, { 400, 413, 457 }, 2 },
  { { 360, 364, 357 }, { 14, 44, 35 }, { 511, 488, 223 }, 2 }, { { 357, 291, 360 }, { 167, 165, 196 }, { 223, 457, 511 }, 2 },
  { { 294, 378, 361 }, { 19, 29, 4 }, { 716, 648, 639 }, 2 }, { { 361, 293, 294 }, { 4, 1, 19 }, { 639, 727, 716 }, 2 },
  { { 295, 272, 378 }, { 83, 92, 29 }, { 720, 692, 648 }, 2 }, { { 378, 294, 295 }, { 29, 19, 83 }, { 648, 716, 720 }, 2 },
  { { 296, 277, 272 }, { 169, 174, 92 }, { 711, 685, 692 }, 2 }, { { 272, 295, 296 }, { 92, 83, 169 }, { 692, 720, 711 }, 2 },
  { { 365, 281, 277 }, { 209, 206, 174 }, { 658, 651, 685 }, 2 }, { { 277, 296, 365 }, { 174, 169, 209 }, { 685, 711, 658 }, 2 },
  { { 305, 294, 293 }, { 20, 19, 1 }, { 722, 716, 727 }, 2 }, { { 293, 304, 305 }, { 1, 2, 20 }, { 727, 733, 722 }, 2 },
  { { 306, 295, 294 }, { 84, 83, 19 }, { 718, 720, 716 }, 2 }, { { 294, 305, 306 }, { 19, 20, 84 }, { 716, 722, 718 }, 2 },
  { { 307, 296, 295 }, { 170, 169, 83 }, { 714, 711, 720 }, 2 }, { { 295, 306, 307 }, { 83, 84, 170 }, { 720, 718, 714 }, 2 },
  { { 367, 365, 296 }, { 210, 209, 169 }, { 657, 658, 711 }, 2 }, { { 296, 307, 367 }, { 169, 170, 210 }, { 711, 714, 657 }, 2 },
  { { 317, 305, 304 }, { 21, 20, 2 }, { 697, 722, 733 }, 2 }, { { 304, 316, 317 }, { 2, 3, 21 }, { 733, 717, 697 }, 2 },
  { { 318, 306, 305 }, { 85, 84, 20 }, { 698, 718, 722 }, 2 }, { { 305, 317, 318 }, { 20, 21, 85 }, { 722, 697, 698 }, 2 },
  { { 319, 307, 306 }, { 171, 170, 84 }, { 703, 714, 718 }, 2 }, { { 306, 318, 319 }, { 84, 85, 171 }, { 718, 698, 703 }, 2 },
  { { 366, 367, 307 }, { 211, 210, 170 }, { 653, 657, 714 }, 2 }, { { 307, 319, 366 }, { 170, 171, 211 }, { 714, 703, 653 }, 2 },
  { { 362, 317, 316 }, { 22, 21, 3 }, { 486, 697, 717 }, 2 }, { { 316, 285, 362 }, { 3, 5, 22 }, { 717, 527, 486 }, 2 },
  { { 363, 318, 317 }, { 86, 85, 21 }, { 481, 698, 697 }, 2 }, { { 317, 362, 363 }, { 21, 22, 86 }, { 697, 486, 481 }, 2 },
  { { 364, 319, 318 }, { 172, 171, 85 }, { 488, 703, 698 }, 2 }, { { 318, 363, 364 }, { 85, 86, 172 }, { 698, 481, 488 }, 2 },
  { { 360, 366, 319 }, { 207, 211, 171 }, { 511, 653, 703 }, 2 }, { { 319, 364, 360 }, { 171, 172, 207 }, { 703, 488, 511 }, 2 },
  { { 297, 280, 281 }, { 48, 54, 27 }, { 529, 526, 651 }, 2 }, { { 281, 365, 297 }, { 27, 16, 48 }, { 651, 658, 529 }, 2 },
  { { 298, 279, 280 }, { 102, 101, 54 }, { 346, 345, 526 }, 2 }, { { 280, 297, 298 }, { 54, 48, 102 }, { 526, 529, 346 }, 2 },
  { { 299, 278, 279 }, { 161, 159, 101 }, { 210, 216, 345 }, 2 }, { { 279, 298, 299 }, { 101, 102, 161 }, { 345, 346, 210 }, 2 },
  { { 372, 369, 278 }, { 203, 194, 159 }, { 84, 90, 216 }, 2 }, { { 278, 299, 372 }, { 159, 161, 203 }, { 216, 210, 84 }, 2 },
  { { 308, 297, 365 }, { 49, 48, 16 }, { 528, 529, 658 }, 2 }, { { 365, 367, 308 }, { 16, 17, 49 }, { 658, 657, 528 }, 2 },
  { { 309, 298, 297 }, { 103, 102, 48 }, { 370, 346, 529 }, 2 }, { { 297, 308, 309 }, { 48, 49, 103 }, { 529, 528, 370 }, 2 },
  { { 310, 299, 298 }, { 162, 161, 102 }, { 211, 210, 346 }, 2 }, { { 298, 309, 310 }, { 102, 103, 162 }, { 346, 370, 211 }, 2 },
  { { 311, 372, 299 }, { 204, 203, 161 }, { 85, 84, 210 }, 2 }, { { 299, 310, 311 }, { 161, 162, 204 }, { 210, 211, 85 }, 2 },
  { { 320, 308, 367 }, { 50, 49, 17 }, { 515, 528, 657 }, 2 }, { { 367, 366, 320 }, { 17, 18, 50 }, { 657, 653, 515 }, 2 },
  { { 321, 309, 308 }, { 105, 103, 49 }, { 402, 370, 528 }, 2 }, { { 308, 320, 321 }, { 49, 50, 105 }, { 528, 515, 402 }, 2 },
  { { 322, 310, 309 }, { 163, 162, 103 }, { 226, 211, 370 }, 2 }, { { 309, 321, 322 }, { 103, 105, 163 }, { 370, 402, 226 }, 2 },
  { { 373, 311, 310 }, { 205, 204, 162 }, { 80, 85, 211 }, 2 }, { { 310, 322, 373 }, { 162, 163, 205 }, { 211, 226, 80 }, 2 },
  { { 291, 320, 366 }, { 51, 50, 18 }, { 457, 515, 653 }, 2 }, { { 366, 360, 291 }, { 18, 25, 51 }, { 653, 511, 457 }, 2 },
  { { 368, 321, 320 }, { 106, 105, 50 }, { 413, 402, 515 }, 2 }, { { 320, 291, 368 }, { 50, 51, 106 }, { 515, 457, 413 }, 2 },
  { { 290, 322, 321 }, { 164, 163, 105 }, { 305, 226, 402 }, 2 }, { { 321, 368, 290 }, { 105, 106, 164 }, { 402, 413, 305 }, 2 },
  { { 358, 373, 322 }, { 195, 205, 163 }, { 214, 80, 226 }, 2 }, { { 322, 290, 358 }, { 163, 164, 195 }, { 226, 305, 214 }, 2 },
  { { 300, 273, 369 }, { 40, 39, 15 }, { 30, 56, 90 }, 2 }, { { 369, 372, 300 }, { 15, 12, 40 }, { 90, 84, 30 }, 2 },
  { { 301, 270, 273 }, { 130, 126, 39 }, { 25, 49, 56 }, 2 }, { { 273, 300, 301 }, { 39, 40, 130 }, { 56, 30, 25 }, 2 },
  { { 302, 371, 270 }, { 197, 192, 126 }, { 23, 91, 49 }, 2 }, { { 270, 301, 302 }, { 126, 130, 197 }, { 49, 25, 23 }, 2 },
  { { 292, 370, 371 }, { 235, 233, 192 }, { 18, 98, 91 }, 2 }, { { 371, 302, 292 }, { 192, 197, 235 }, { 91, 23, 18 }, 2 },
  { { 312, 300, 372 }, { 41, 40, 12 }, { 27, 30, 84 }, 2 }, { { 372, 311, 312 }, { 12, 10, 41 }, { 84, 85, 27 }, 2 },
  { { 313, 301, 300 }, { 131, 130, 40 }, { 24, 25, 30 }, 2 }, { { 300, 312, 313 }, { 40, 41, 131 }, { 30, 27, 24 }, 2 },
  { { 314, 302, 301 }, { 199, 197, 130 }, { 19, 23, 25 }, 2 }, { { 301, 313, 314 }, { 130, 131, 199 }, { 25, 24, 19 }, 2 },
  { { 303, 292, 302 }, { 236, 235, 197 }, { 8, 18, 23 }, 2 }, { { 302, 314, 303 }, { 197, 199, 236 }, { 23, 19, 8 }, 2 },
  { { 323, 312, 311 }, { 42, 41, 10 }, { 44, 27, 85 }, 2 }, { { 311, 373, 323 }, { 10, 11, 42 }, { 85, 80, 44 }, 2 },
  { { 324, 313, 312 }, { 132, 131, 41 }, { 41, 24, 27 }, 2 }, { { 312, 323, 324 }, { 41, 42, 132 }, { 27, 44, 41 }, 2 },
  { { 325, 314, 313 }, { 201, 199, 131 }, { 42, 19, 24 }, 2 }, { { 313, 324, 325 }, { 131, 132, 201 }, { 24, 41, 42 }, 2 },
  { { 315, 303, 314 }, { 237, 236, 199 }, { 21, 8, 19 }, 2 }, { { 314, 325, 315 }, { 199, 201, 237 }, { 19, 42, 21 }, 2 },
  { { 375, 323, 373 }, { 43, 42, 11 }, { 250, 44, 80 }, 2 }, { { 373, 358, 375 }, { 11, 13, 43 }, { 80, 214, 250 }, 2 },
  { { 374, 324, 323 }, { 133, 132, 42 }, { 260, 41, 44 }, 2 }, { { 323, 375, 374 }, { 42, 43, 133 }, { 44, 250, 260 }, 2 },
  { { 376, 325, 324 }, { 198, 201, 132 }, { 258, 42, 41 }, 2 }, { { 324, 374, 376 }, { 132, 133, 198 }, { 41, 260, 258 }, 2 },
  { { 377, 315, 325 }, { 234, 237, 201 }, { 227, 21, 42 }, 2 }, { { 325, 376, 377 }, { 201, 198, 234 }, { 42, 258, 227 }, 2 },
  { { 326, 371, 267 }, { 190, 212, 179 }, { 152, 91, 284 }, 2 }, { { 267, 381, 326 }, { 179, 155, 190 }, { 284, 283, 152 }, 2 },
  { { 381, 267, 268 }, { 155, 179, 109 }, { 283, 284, 377 }, 2 }, { { 268, 380, 381 }, { 109, 110, 155 }, { 377, 374, 283 }, 2 },
  { { 380, 268, 269 }, { 110, 109, 37 }, { 374, 377, 478 }, 2 }, { { 269, 382, 380 }, { 37, 57, 110 }, { 478, 471, 374 }, 2 },
  { { 382, 269, 378 }, { 57, 37, 9 }, { 471, 478, 648 }, 2 }, { { 378, 327, 382 }, { 213, 191, 156 }, { 648, 610, 471 }, 2 },
  { { 328, 270, 371 }, { 122, 126, 192 }, { 78, 49, 91 }, 2 }, { { 371, 326, 328 }, { 192, 160, 122 }, { 91, 152, 78 }, 2 },
  { { 327, 378, 272 }, { 53, 29, 92 }, { 610, 648, 692 }, 2 }, { { 272, 329, 327 }, { 92, 99, 53 }, { 692, 666, 610 }, 2 },
  { { 330, 273, 270 }, { 47, 39, 126 }, { 79, 56, 49 }, 2 }, { { 270, 328, 330 }, { 126, 122, 47 }, { 49, 78, 79 }, 2 },
  { { 329, 272, 277 }, { 99, 92, 174 }, { 666, 692, 685 }, 2 }, { { 277, 331, 329 }, { 174, 166, 99 }, { 685, 662, 666 }, 2 },
  { { 383, 369, 273 }, { 28, 15, 39 }, { 138, 90, 56 }, 2 }, { { 273, 330, 383 }, { 39, 47, 28 }, { 56, 79, 138 }, 2 },
  { { 384, 278, 369 }, { 151, 159, 194 }, { 231, 216, 90 }, 2 }, { { 369, 383, 384 }, { 194, 184, 151 }, { 90, 138, 231 }, 2 },
  { { 385, 279, 278 }, { 100, 101, 159 }, { 347, 345, 216 }, 2 }, { { 278, 384, 385 }, { 159, 151, 100 }, { 216, 231, 347 }, 2 },
  { { 386, 280, 279 }, { 61, 54, 101 }, { 507, 526, 345 }, 2 }, { { 279, 385, 386 }, { 101, 100, 61 }, { 345, 347, 507 }, 2 },
  { { 387, 281, 280 }, { 31, 27, 54 }, { 600, 651, 526 }, 2 }, { { 280, 386, 387 }, { 54, 61, 31 }, { 526, 507, 600 }, 2 },
  { { 331, 277, 281 }, { 166, 174, 206 }, { 662, 685, 651 }, 2 }, { { 281, 387, 331 }, { 206, 193, 166 }, { 651, 600, 662 }, 2 },
  { { 335, 328, 326 }, { 141, 122, 160 }, { 92, 78, 152 }, 2 }, { { 326, 379, 335 }, { 160, 154, 141 }, { 152, 129, 92 }, 2 },
  { { 379, 326, 381 }, { 55, 30, 58 }, { 129, 152, 283 }, 2 }, { { 381, 332, 379 }, { 58, 65, 55 }, { 283, 285, 129 }, 2 },
  { { 332, 381, 380 }, { 65, 58, 118 }, { 285, 283, 374 }, 2 }, { { 380, 333, 332 }, { 118, 116, 65 }, { 374, 367, 285 }, 2 },
  { { 333, 380, 382 }, { 116, 118, 156 }, { 367, 374, 471 }, 2 }, { { 382, 334, 333 }, { 156, 148, 116 }, { 471, 456, 367 }, 2 },
  { { 390, 327, 329 }, { 59, 53, 99 }, { 609, 610, 666 }, 2 }, { { 329, 336, 390 }, { 99, 75, 59 }, { 666, 650, 609 }, 2 },
  { { 334, 382, 327 }, { 148, 156, 191 }, { 456, 471, 610 }, 2 }, { { 327, 390, 334 }, { 191, 158, 148 }, { 610, 609, 456 }, 2 },
  { { 337, 330, 328 }, { 89, 47, 122 }, { 99, 79, 78 }, 2 }, { { 328, 335, 337 }, { 122, 141, 89 }, { 78, 92, 99 }, 2 },
  { { 336, 329, 331 }, { 75, 99, 166 }, { 650, 666, 662 }, 2 }, { { 331, 338, 336 }, { 166, 129, 75 }, { 662, 643, 650 }, 2 },
  { { 339, 383, 330 }, { 63, 28, 47 }, { 192, 138, 79 }, 2 }, { { 330, 337, 339 }, { 47, 89, 63 }, { 79, 99, 192 }, 2 },
  { { 340, 384, 383 }, { 145, 152, 185 }, { 248, 231, 138 }, 2 }, { { 383, 339, 340 }, { 185, 153, 145 }, { 138, 192, 248 }, 2 },
  { { 341, 385, 384 }, { 108, 104, 152 }, { 394, 347, 231 }, 2 }, { { 384, 340, 341 }, { 152, 145, 108 }, { 231, 248, 394 }, 2 },
  { { 342, 386, 385 }, { 68, 62, 104 }, { 492, 507, 347 }, 2 }, { { 385, 341, 342 }, { 104, 108, 68 }, { 347, 394, 492 }, 2 },
  { { 343, 387, 386 }, { 60, 32, 62 }, { 550, 600, 507 }, 2 }, { { 386, 342, 343 }, { 62, 68, 60 }, { 507, 492, 550 }, 2 },
  { { 338, 331, 387 }, { 129, 166, 193 }, { 643, 662, 600 }, 2 }, { { 387, 343, 338 }, { 193, 150, 129 }, { 600, 550, 643 }, 2 },
  { { 388, 335, 379 }, { 157, 141, 154 }, { 124, 92, 129 }, 2 }, { { 379, 389, 388 }, { 154, 175, 157 }, { 129, 175, 124 }, 2 },
  { { 389, 379, 332 }, { 67, 55, 65 }, { 175, 129, 285 }, 2 }, { { 332, 344, 389 }, { 65, 90, 67 }, { 285, 288, 175 }, 2 },
  { { 344, 332, 333 }, { 90, 65, 116 }, { 288, 285, 367 }, 2 }, { { 333, 345, 344 }, { 116, 115, 90 }, { 367, 372, 288 }, 2 },
  { { 345, 333, 334 }, { 115, 116, 148 }, { 372, 367, 456 }, 2 }, { { 334, 346, 345 }, { 148, 128, 115 }, { 456, 454, 372 }, 2 },
  { { 352, 390, 336 }, { 38, 59, 75 }, { 557, 609, 650 }, 2 }, { { 336, 391, 352 }, { 75, 56, 38 }, { 650, 608, 557 }, 2 },
  { { 346, 334, 390 }, { 128, 148, 158 }, { 454, 456, 609 }, 2 }, { { 390, 352, 346 }, { 158, 147, 128 }, { 609, 557, 454 }, 2 },
  { { 392, 337, 335 }, { 149, 89, 141 }, { 171, 99, 92 }, 2 }, { { 335, 388, 392 }, { 141, 157, 149 }, { 92, 124, 171 }, 2 },
  { { 391, 336, 338 }, { 56, 75, 129 }, { 608, 650, 643 }, 2 }, { { 338, 393, 391 }, { 129, 64, 56 }, { 643, 589, 608 }, 2 },
  { { 347, 339, 337 }, { 140, 63, 89 }, { 203, 192, 99 }, 2 }, { { 337, 392, 347 }, { 89, 149, 140 }, { 99, 171, 203 }, 2 },
  { { 348, 340, 339 }, { 127, 145, 153 }, { 255, 248, 192 }, 2 }, { { 339, 347, 348 }, { 153, 143, 127 }, { 192, 203, 255 }, 2 },
  { { 349, 341, 340 }, { 107, 108, 145 }, { 395, 394, 248 }, 2 }, { { 340, 348, 349 }, { 145, 127, 107 }, { 248, 255, 395 }, 2 },
  { { 350, 342, 341 }, { 91, 68, 108 }, { 482, 492, 394 }, 2 }, { { 341, 349, 350 }, { 108, 107, 91 }, { 394, 395, 482 }, 2 },
  { { 394, 343, 342 }, { 73, 60, 68 }, { 548, 550, 492 }, 2 }, { { 342, 350, 394 }, { 68, 91, 73 }, { 492, 482, 548 }, 2 },
  { { 393, 338, 343 }, { 64, 129, 150 }, { 589, 643, 550 }, 2 }, { { 343, 394, 393 }, { 150, 76, 64 }, { 550, 548, 589 }, 2 },
  { { 432, 433, 429 }, { 0, 0, 0 }, { 637, 239, 238 }, 8 }, { { 429, 431, 432 }, { 0, 0, 0 }, { 238, 638, 637 }, 8 },
  { { 430, 431, 429 }, { 0, 0, 0 }, { 582, 638, 238 }, 8 }, { { 429, 434, 430 }, { 0, 0, 0 }, { 238, 157, 582 }, 8 },
  { { 396, 432, 431 }, { 0, 0, 0 }, { 583, 637, 638 }, 8 }, { { 431, 430, 396 }, { 0, 0, 0 }, { 638, 582, 583 }, 8 },
  { { 395, 433, 432 }, { 0, 0, 0 }, { 156, 239, 637 }, 8 }, { { 432, 396, 395 }, { 0, 0, 0 }, { 637, 583, 156 }, 8 },
  { { 434, 429, 433 }, { 0, 0, 0 }, { 157, 238, 239 }, 8 }, { { 433, 395, 434 }, { 0, 0, 0 }, { 239, 156, 157 }, 8 },
  { { 436, 438, 397 }, { 0, 0, 0 }, { 547, 190, 191 }, 8 }, { { 397, 435, 436 }, { 0, 0, 0 }, { 191, 546, 547 }, 8 },
  { { 398, 435, 397 }, { 0, 0, 0 }, { 612, 546, 191 }, 8 }, { { 397, 434, 398 }, { 0, 0, 0 }, { 191, 128, 612 }, 8 },
  { { 437, 436, 435 }, { 0, 0, 0 }, { 614, 547, 546 }, 8 }, { { 435, 398, 437 }, { 0, 0, 0 }, { 546, 612, 614 }, 8 },
  { { 395, 438, 436 }, { 0, 0, 0 }, { 127, 190, 547 }, 8 }, { { 436, 437, 395 }, { 0, 0, 0 }, { 547, 614, 127 }, 8 },
  { { 434, 397, 438 }, { 0, 0, 0 }, { 128, 191, 190 }, 8 }, { { 438, 395, 434 }, { 0, 0, 0 }, { 190, 127, 128 }, 8 },
  { { 402, 399, 456 }, { 0, 0, 0 }, { 370, 370, 196 }, 8 }, { { 456, 439, 402 }, { 0, 0, 0 }, { 196, 295, 370 }, 8 },
  { { 440, 401, 400 }, { 0, 0, 0 }, { 293, 195, 369 }, 8 }, { { 400, 403, 440 }, { 0, 0, 0 }, { 369, 369, 293 }, 8 },
  { { 439, 456, 401 }, { 0, 0, 0 }, { 295, 196, 195 }, 8 }, { { 401, 440, 439 }, { 0, 0, 0 }, { 195, 293, 295 }, 8 },
  { { 404, 402, 439 }, { 0, 0, 0 }, { 370, 370, 295 }, 8 }, { { 439, 442, 404 }, { 0, 0, 0 }, { 295, 444, 370 }, 8 },
  { { 441, 440, 403 }, { 0, 0, 0 }, { 443, 293, 369 }, 8 }, { { 403, 405, 441 }, { 0, 0, 0 }, { 369, 369, 443 }, 8 },
  { { 442, 439, 440 }, { 0, 0, 0 }, { 444, 295, 293 }, 8 }, { { 440, 441, 442 }, { 0, 0, 0 }, { 293, 443, 444 }, 8 },
  { { 406, 404, 442 }, { 0, 0, 0 }, { 370, 370, 444 }, 8 }, { { 442, 443, 406 }, { 0, 0, 0 }, { 444, 541, 370 }, 8 },
  { { 445, 441, 405 }, { 0, 0, 0 }, { 540, 443, 369 }, 8 }, { { 405, 407, 445 }, { 0, 0, 0 }, { 369, 369, 540 }, 8 },
  { { 443, 442, 441 }, { 0, 0, 0 }, { 541, 444, 443 }, 8 }, { { 441, 445, 443 }, { 0, 0, 0 }, { 443, 540, 541 }, 8 },
  { { 408, 406, 443 }, { 0, 0, 0 }, { 370, 370, 541 }, 8 }, { { 443, 444, 408 }, { 0, 0, 0 }, { 541, 629, 370 }, 8 },
  { { 447, 445, 407 }, { 0, 0, 0 }, { 630, 540, 369 }, 8 }, { { 407, 409, 447 }, { 0, 0, 0 }, { 369, 369, 630 }, 8 },
  { { 444, 443, 445 }, { 0, 0, 0 }, { 629, 541, 540 }, 8 }, { { 445, 447, 444 }, { 0, 0, 0 }, { 540, 630, 629 }, 8 },
  { { 410, 408, 444 }, { 0, 0, 0 }, { 370, 370, 629 }, 8 }, { { 444, 448, 410 }, { 0, 0, 0 }, { 629, 627, 370 }, 8 },
  { { 446, 447, 409 }, { 0, 0, 0 }, { 628, 630, 369 }, 8 }, { { 409, 411, 446 }, { 0, 0, 0 }, { 369, 369, 628 }, 8 },
  { { 448, 444, 447 }, { 0, 0, 0 }, { 627, 629, 630 }, 8 }, { { 447, 446, 448 }, { 0, 0, 0 }, { 630, 628, 627 }, 8 },
  { { 413, 410, 448 }, { 0, 0, 0 }, { 370, 370, 627 }, 8 }, { { 448, 412, 413 }, { 0, 0, 0 }, { 627, 542, 370 }, 8 },
  { { 449, 446, 411 }, { 0, 0, 0 }, { 543, 628, 369 }, 8 }, { { 411, 414, 449 }, { 0, 0, 0 }, { 369, 369, 543 }, 8 },
  { { 412, 448, 446 }, { 0, 0, 0 }, { 542, 627, 628 }, 8 }, { { 446, 449, 412 }, { 0, 0, 0 }, { 628, 543, 542 }, 8 },
  { { 415, 413, 412 }, { 0, 0, 0 }, { 370, 370, 542 }, 8 }, { { 412, 450, 415 }, { 0, 0, 0 }, { 542, 446, 370 }, 8 },
  { { 451, 449, 414 }, { 0, 0, 0 }, { 445, 543, 369 }, 8 }, { { 414, 416, 451 }, { 0, 0, 0 }, { 369, 369, 445 }, 8 },
  { { 450, 412, 449 }, { 0, 0, 0 }, { 446, 542, 543 }, 8 }, { { 449, 451, 450 }, { 0, 0, 0 }, { 543, 445, 446 }, 8 },
  { { 418, 415, 450 }, { 0, 0, 0 }, { 370, 370, 446 }, 8 }, { { 450, 417, 418 }, { 0, 0, 0 }, { 446, 296, 370 }, 8 },
  { { 420, 451, 416 }, { 0, 0, 0 }, { 294, 445, 369 }, 8 }, { { 416, 419, 420 }, { 0, 0, 0 }, { 369, 369, 294 }, 8 },
  { { 417, 450, 451 }, { 0, 0, 0 }, { 296, 446, 445 }, 8 }, { { 451, 420, 417 }, { 0, 0, 0 }, { 445, 294, 296 }, 8 },
  { { 422, 418, 417 }, { 0, 0, 0 }, { 348, 370, 296 }, 8 }, { { 417, 421, 422 }, { 0, 0, 0 }, { 296, 197, 348 }, 8 },
  { { 452, 420, 419 }, { 0, 0, 0 }, { 198, 294, 369 }, 8 }, { { 419, 423, 452 }, { 0, 0, 0 }, { 369, 369, 198 }, 8 },
  { { 421, 417, 420 }, { 0, 0, 0 }, { 197, 296, 294 }, 8 }, { { 420, 452, 421 }, { 0, 0, 0 }, { 294, 198, 197 }, 8 },
  { { 424, 422, 421 }, { 0, 0, 0 }, { 370, 348, 197 }, 8 }, { { 421, 453, 424 }, { 0, 0, 0 }, { 197, 110, 370 }, 8 },
  { { 426, 452, 423 }, { 0, 0, 0 }, { 113, 198, 369 }, 8 }, { { 423, 425, 426 }, { 0, 0, 0 }, { 369, 368, 113 }, 8 },
  { { 453, 421, 452 }, { 0, 0, 0 }, { 110, 197, 198 }, 8 }, { { 452, 426, 453 }, { 0, 0, 0 }, { 198, 113, 110 }, 8 },
  { { 427, 424, 453 }, { 0, 0, 0 }, { 370, 370, 110 }, 8 }, { { 453, 455, 427 }, { 0, 0, 0 }, { 110, 111, 370 }, 8 },
  { { 454, 426, 425 }, { 0, 0, 0 }, { 112, 113, 368 }, 8 }, { { 425, 428, 454 }, { 0, 0, 0 }, { 368, 369, 112 }, 8 },
  { { 455, 453, 426 }, { 0, 0, 0 }, { 111, 110, 113 }, 8 }, { { 426, 454, 455 }, { 0, 0, 0 }, { 113, 112, 111 }, 8 },
  { { 399, 427, 455 }, { 0, 0, 0 }, { 370, 370, 111 }, 8 }, { { 455, 456, 399 }, { 0, 0, 0 }, { 111, 196, 370 }, 8 },
  { { 401, 454, 428 }, { 0, 0, 0 }, { 195, 112, 369 }, 8 }, { { 428, 400, 401 }, { 0, 0, 0 }, { 369, 369, 195 }, 8 },
  { { 456, 455, 454 }, { 0, 0, 0 }, { 196, 111, 112 }, 8 }, { { 454, 401, 456 }, { 0, 0, 0 }, { 112, 195, 196 }, 8 },
  { { 459, 544, 542 }, { 231, 79, 77 }, { 323, 155, 153 }, 10 }, { { 544, 459, 525 }, { 79, 231, 226 }, { 155, 323, 244 }, 10 },
  { { 460, 525, 459 }, { 299, 226, 231 }, { 342, 244, 323 }, 10 }, { { 525, 460, 457 }, { 226, 299, 292 }, { 244, 342, 406 }, 10 },
  { { 461, 457, 460 }, { 383, 292, 299 }, { 429, 406, 342 }, 10 }, { { 457, 461, 458 }, { 292, 383, 388 }, { 406, 429, 498 }, 10 },
  { { 462, 458, 461 }, { 493, 388, 383 }, { 572, 498, 429 }, 10 }, { { 458, 462, 528 }, { 388, 493, 490 }, { 498, 572, 559 }, 10 },
  { { 463, 542, 543 }, { 240, 77, 138 }, { 327, 153, 201 }, 10 }, { { 542, 463, 459 }, { 77, 240, 231 }, { 153, 327, 323 }, 10 },
  { { 464, 459, 463 }, { 306, 231, 240 }, { 396, 323, 327 }, 10 }, { { 459, 464, 460 }, { 231, 306, 299 }, { 323, 396, 342 }, 10 },
  { { 465, 460, 464 }, { 381, 299, 306 }, { 418, 342, 396 }, 10 }, { { 460, 465, 461 }, { 299, 381, 383 }, { 342, 418, 429 }, 10 },
  { { 466, 461, 465 }, { 477, 383, 381 }, { 544, 429, 418 }, 10 }, { { 461, 466, 462 }, { 383, 477, 493 }, { 429, 544, 572 }, 10 },
  { { 467, 543, 541 }, { 243, 138, 189 }, { 325, 201, 219 }, 10 }, { { 543, 467, 463 }, { 138, 243, 240 }, { 201, 325, 327 }, 10 },
  { { 468, 463, 467 }, { 308, 240, 243 }, { 363, 327, 325 }, 10 }, { { 463, 468, 464 }, { 240, 308, 306 }, { 327, 363, 396 }, 10 },
  { { 469, 464, 468 }, { 359, 306, 308 }, { 414, 396, 363 }, 10 }, { { 464, 469, 465 }, { 306, 359, 381 }, { 396, 414, 418 }, 10 },
  { { 470, 465, 469 }, { 427, 381, 359 }, { 523, 418, 414 }, 10 }, { { 465, 470, 466 }, { 381, 427, 477 }, { 418, 523, 544 }, 10 },
  { { 536, 541, 540 }, { 253, 189, 221 }, { 319, 219, 240 }, 10 }, { { 541, 536, 467 }, { 189, 253, 243 }, { 219, 319, 325 }, 10 },
  { { 471, 467, 536 }, { 309, 243, 253 }, { 364, 325, 319 }, 10 }, { { 467, 471, 468 }, { 243, 309, 308 }, { 325, 364, 363 }, 10 },
  { { 472, 468, 471 }, { 358, 308, 309 }, { 410, 363, 364 }, 10 }, { { 468, 472, 469 }, { 308, 358, 359 }, { 363, 410, 414 }, 10 },
  { { 530, 469, 472 }, { 394, 359, 358 }, { 506, 414, 410 }, 10 }, { { 469, 530, 470 }, { 359, 394, 427 }, { 414, 506, 523 }, 10 },
  { { 476, 473, 474 }, { 384, 491, 391 }, { 322, 180, 243 }, 10 }, { { 473, 476, 553 }, { 491, 384, 494 }, { 180, 322, 165 }, 10 },
  { { 477, 474, 526 }, { 305, 391, 307 }, { 341, 243, 332 }, 10 }, { { 474, 477, 476 }, { 391, 305, 384 }, { 243, 341, 322 }, 10 },
  { { 478, 526, 475 }, { 232, 307, 230 }, { 428, 332, 496 }, 10 }, { { 526, 478, 477 }, { 307, 232, 305 }, { 332, 428, 341 }, 10 },
  { { 534, 475, 527 }, { 78, 230, 82 }, { 584, 496, 574 }, 10 }, { { 475, 534, 478 }, { 230, 78, 232 }, { 496, 584, 428 }, 10 },
  { { 479, 553, 476 }, { 382, 494, 384 }, { 326, 165, 322 }, 10 }, { { 553, 479, 551 }, { 494, 382, 478 }, { 165, 326, 194 }, 10 },
  { { 480, 476, 477 }, { 306, 384, 305 }, { 397, 322, 341 }, 10 }, { { 476, 480, 479 }, { 384, 306, 382 }, { 322, 397, 326 }, 10 },
  { { 481, 477, 478 }, { 239, 305, 232 }, { 419, 341, 428 }, 10 }, { { 477, 481, 480 }, { 305, 239, 306 }, { 341, 419, 397 }, 10 },
  { { 535, 478, 534 }, { 137, 232, 78 }, { 536, 428, 584 }, 10 }, { { 478, 535, 481 }, { 232, 137, 239 }, { 428, 536, 419 }, 10 },
  { { 482, 551, 479 }, { 360, 478, 382 }, { 324, 194, 326 }, 10 }, { { 551, 482, 550 }, { 478, 360, 425 }, { 194, 324, 215 }, 10 },
  { { 483, 479, 480 }, { 303, 382, 306 }, { 378, 326, 397 }, 10 }, { { 479, 483, 482 }, { 382, 303, 360 }, { 326, 378, 324 }, 10 },
  { { 484, 480, 481 }, { 242, 306, 239 }, { 415, 397, 419 }, 10 }, { { 480, 484, 483 }, { 306, 242, 303 }, { 397, 415, 378 }, 10 },
  { { 485, 481, 535 }, { 188, 239, 137 }, { 521, 419, 536 }, 10 }, { { 481, 485, 484 }, { 239, 188, 242 }, { 419, 521, 415 }, 10 },
  { { 486, 550, 482 }, { 357, 425, 360 }, { 328, 215, 324 }, 10 }, { { 550, 486, 539 }, { 425, 357, 395 }, { 215, 328, 233 }, 10 },
  { { 538, 482, 483 }, { 304, 360, 303 }, { 375, 324, 378 }, 10 }, { { 482, 538, 486 }, { 360, 304, 357 }, { 324, 375, 328 }, 10 },
  { { 487, 483, 484 }, { 252, 303, 242 }, { 416, 378, 415 }, 10 }, { { 483, 487, 538 }, { 303, 252, 304 }, { 378, 416, 375 }, 10 },
  { { 537, 484, 485 }, { 219, 242, 188 }, { 501, 415, 521 }, 10 }, { { 484, 537, 487 }, { 242, 219, 252 }, { 415, 501, 416 }, 10 },
  { { 488, 544, 525 }, { 225, 80, 227 }, { 217, 155, 244 }, 10 }, { { 544, 488, 546 }, { 80, 225, 71 }, { 155, 217, 93 }, 10 },
  { { 489, 525, 457 }, { 295, 227, 296 }, { 409, 244, 406 }, 10 }, { { 525, 489, 488 }, { 227, 295, 225 }, { 244, 409, 217 }, 10 },
  { { 490, 457, 458 }, { 386, 296, 390 }, { 520, 406, 498 }, 10 }, { { 457, 490, 489 }, { 296, 386, 295 }, { 406, 520, 409 }, 10 },
  { { 529, 458, 528 }, { 496, 390, 492 }, { 644, 498, 559 }, 10 }, { { 458, 529, 490 }, { 390, 496, 386 }, { 498, 644, 520 }, 10 },
  { { 500, 546, 488 }, { 224, 71, 225 }, { 207, 93, 217 }, 10 }, { { 546, 500, 547 }, { 71, 224, 70 }, { 93, 207, 96 }, 10 },
  { { 532, 490, 529 }, { 495, 386, 496 }, { 645, 520, 644 }, 10 }, { { 490, 532, 501 }, { 386, 495, 385 }, { 520, 645, 531 }, 10 },
  { { 511, 547, 500 }, { 229, 70, 224 }, { 220, 96, 207 }, 10 }, { { 547, 511, 549 }, { 70, 229, 69 }, { 96, 220, 97 }, 10 },
  { { 514, 501, 532 }, { 497, 385, 495 }, { 649, 531, 645 }, 10 }, { { 501, 514, 513 }, { 385, 497, 389 }, { 531, 649, 524 }, 10 },
  { { 474, 549, 511 }, { 228, 69, 229 }, { 243, 97, 220 }, 10 }, { { 549, 474, 473 }, { 69, 228, 81 }, { 97, 243, 180 }, 10 },
  { { 526, 511, 512 }, { 293, 229, 294 }, { 332, 220, 331 }, 10 }, { { 511, 526, 474 }, { 229, 293, 228 }, { 220, 332, 243 }, 10 },
  { { 475, 512, 513 }, { 387, 294, 389 }, { 496, 331, 524 }, 10 }, { { 512, 475, 526 }, { 294, 387, 293 }, { 331, 496, 332 }, 10 },
  { { 527, 513, 514 }, { 489, 389, 497 }, { 574, 524, 649 }, 10 }, { { 513, 527, 475 }, { 389, 489, 387 }, { 524, 574, 496 }, 10 },
  { { 491, 528, 462 }, { 314, 262, 311 }, { 713, 559, 572 }, 10 }, { { 528, 491, 529 }, { 262, 314, 265 }, { 559, 713, 644 }, 10 },
  { { 531, 462, 466 }, { 350, 311, 351 }, { 656, 572, 544 }, 10 }, { { 462, 531, 491 }, { 311, 350, 314 }, { 572, 656, 713 }, 10 },
  { { 492, 466, 470 }, { 178, 139, 186 }, { 619, 544, 523 }, 10 }, { { 466, 492, 531 }, { 139, 178, 98 }, { 544, 619, 656 }, 10 },
  { { 493, 470, 530 }, { 215, 186, 220 }, { 514, 523, 506 }, 10 }, { { 470, 493, 492 }, { 186, 215, 178 }, { 523, 514, 619 }, 10 },
  { { 502, 529, 491 }, { 313, 265, 314 }, { 728, 644, 713 }, 10 }, { { 529, 502, 532 }, { 265, 313, 264 }, { 644, 728, 645 }, 10 },
  { { 533, 491, 531 }, { 349, 314, 350 }, { 659, 713, 656 }, 10 }, { { 491, 533, 502 }, { 314, 349, 313 }, { 713, 659, 728 }, 10 },
  { { 503, 531, 492 }, { 177, 98, 178 }, { 624, 656, 619 }, 10 }, { { 531, 503, 533 }, { 98, 177, 97 }, { 656, 624, 659 }, 10 },
  { { 504, 492, 493 }, { 217, 178, 215 }, { 513, 619, 514 }, 10 }, { { 492, 504, 503 }, { 178, 217, 177 }, { 619, 513, 624 }, 10 },
  { { 515, 532, 502 }, { 312, 264, 313 }, { 715, 645, 728 }, 10 }, { { 532, 515, 514 }, { 264, 312, 263 }, { 645, 715, 649 }, 10 },
  { { 516, 502, 533 }, { 348, 313, 349 }, { 655, 728, 659 }, 10 }, { { 502, 516, 515 }, { 313, 348, 312 }, { 728, 655, 715 }, 10 },
  { { 517, 533, 503 }, { 176, 97, 177 }, { 623, 659, 624 }, 10 }, { { 533, 517, 516 }, { 97, 176, 96 }, { 659, 623, 655 }, 10 },
  { { 518, 503, 504 }, { 216, 177, 217 }, { 512, 624, 513 }, 10 }, { { 503, 518, 517 }, { 177, 216, 176 }, { 624, 512, 623 }, 10 },
  { { 534, 514, 515 }, { 310, 263, 312 }, { 584, 649, 715 }, 10 }, { { 514, 534, 527 }, { 263, 310, 261 }, { 649, 584, 574 }, 10 },
  { { 535, 515, 516 }, { 347, 312, 348 }, { 536, 715, 655 }, 10 }, { { 515, 535, 534 }, { 312, 347, 310 }, { 715, 536, 584 }, 10 },
  { { 485, 516, 517 }, { 187, 96, 176 }, { 521, 655, 623 }, 10 }, { { 516, 485, 535 }, { 96, 187, 136 }, { 655, 521, 536 }, 10 },
  { { 537, 517, 518 }, { 218, 176, 216 }, { 501, 623, 512 }, 10 }, { { 517, 537, 485 }, { 176, 218, 187 }, { 623, 501, 521 }, 10 },
  { { 494, 530, 472 }, { 250, 220, 251 }, { 431, 506, 410 }, 10 }, { { 530, 494, 493 }, { 220, 250, 215 }, { 506, 431, 514 }, 10 },
  { { 495, 472, 471 }, { 301, 251, 302 }, { 366, 410, 364 }, 10 }, { { 472, 495, 494 }, { 251, 301, 250 }, { 410, 366, 431 }, 10 },
  { { 496, 471, 536 }, { 355, 302, 356 }, { 307, 364, 319 }, 10 }, { { 471, 496, 495 }, { 302, 355, 301 }, { 364, 307, 366 }, 10 },
  { { 497, 536, 540 }, { 423, 356, 393 }, { 228, 319, 240 }, 10 }, { { 536, 497, 496 }, { 356, 423, 355 }, { 319, 228, 307 }, 10 },
  { { 505, 493, 494 }, { 249, 215, 250 }, { 435, 514, 431 }, 10 }, { { 493, 505, 504 }, { 215, 249, 217 }, { 514, 435, 513 }, 10 },
  { { 506, 494, 495 }, { 300, 250, 301 }, { 370, 431, 366 }, 10 }, { { 494, 506, 505 }, { 250, 300, 249 }, { 431, 370, 435 }, 10 },
  { { 507, 495, 496 }, { 354, 301, 355 }, { 306, 366, 307 }, 10 }, { { 495, 507, 506 }, { 301, 354, 300 }, { 366, 306, 370 }, 10 },
  { { 508, 496, 497 }, { 421, 355, 423 }, { 225, 307, 228 }, 10 }, { { 496, 508, 507 }, { 355, 421, 354 }, { 307, 225, 306 }, 10 },
  { { 519, 504, 505 }, { 248, 217, 249 }, { 434, 513, 435 }, 10 }, { { 504, 519, 518 }, { 217, 248, 216 }, { 513, 434, 512 }, 10 },
  { { 520, 505, 506 }, { 298, 249, 300 }, { 371, 435, 370 }, 10 }, { { 505, 520, 519 }, { 249, 298, 248 }, { 435, 371, 434 }, 10 },
  { { 521, 506, 507 }, { 353, 300, 354 }, { 310, 370, 306 }, 10 }, { { 506, 521, 520 }, { 300, 353, 298 }, { 370, 310, 371 }, 10 },
  { { 522, 507, 508 }, { 422, 354, 421 }, { 224, 306, 225 }, 10 }, { { 507, 522, 521 }, { 354, 422, 353 }, { 306, 224, 310 }, 10 },
  { { 487, 518, 519 }, { 247, 216, 248 }, { 416, 512, 434 }, 10 }, { { 518, 487, 537 }, { 216, 247, 218 }, { 512, 416, 501 }, 10 },
  { { 538, 519, 520 }, { 297, 248, 298 }, { 375, 434, 371 }, 10 }, { { 519, 538, 487 }, { 248, 297, 247 }, { 434, 375, 416 }, 10 },
  { { 486, 520, 521 }, { 352, 298, 353 }, { 328, 371, 310 }, 10 }, { { 520, 486, 538 }, { 298, 352, 297 }, { 371, 328, 375 }, 10 },
  { { 539, 521, 522 }, { 392, 353, 422 }, { 233, 310, 224 }, 10 }, { { 521, 539, 486 }, { 353, 392, 352 }, { 310, 233, 328 }, 10 },
  { { 498, 540, 541 }, { 448, 393, 426 }, { 116, 240, 219 }, 10 }, { { 540, 498, 497 }, { 393, 448, 423 }, { 240, 116, 228 }, 10 },
  { { 545, 541, 543 }, { 488, 426, 479 }, { 87, 219, 201 }, 10 }, { { 541, 545, 498 }, { 426, 488, 448 }, { 219, 87, 116 }, 10 },
  { { 499, 543, 542 }, { 289, 258, 291 }, { 26, 201, 153 }, 10 }, { { 543, 499, 545 }, { 258, 289, 257 }, { 201, 26, 87 }, 10 },
  { { 546, 542, 544 }, { 334, 291, 336 }, { 93, 153, 155 }, 10 }, { { 542, 546, 499 }, { 291, 334, 289 }, { 153, 93, 26 }, 10 },
  { { 509, 497, 498 }, { 447, 423, 448 }, { 115, 228, 116 }, 10 }, { { 497, 509, 508 }, { 423, 447, 421 }, { 228, 115, 225 }, 10 },
  { { 548, 498, 545 }, { 487, 448, 488 }, { 83, 116, 87 }, 10 }, { { 498, 548, 509 }, { 448, 487, 447 }, { 116, 83, 115 }, 10 },
  { { 510, 545, 499 }, { 288, 257, 289 }, { 13, 87, 26 }, 10 }, { { 545, 510, 548 }, { 257, 288, 256 }, { 87, 13, 83 }, 10 },
  { { 547, 499, 546 }, { 333, 289, 334 }, { 96, 26, 93 }, 10 }, { { 499, 547, 510 }, { 289, 333, 288 }, { 26, 96, 13 }, 10 },
  { { 523, 508, 509 }, { 446, 421, 447 }, { 120, 225, 115 }, 10 }, { { 508, 523, 522 }, { 421, 446, 422 }, { 225, 120, 224 }, 10 },
  { { 552, 509, 548 }, { 486, 447, 487 }, { 86, 115, 83 }, 10 }, { { 509, 552, 523 }, { 447, 486, 446 }, { 115, 86, 120 }, 10 },
  { { 524, 548, 510 }, { 287, 256, 288 }, { 28, 83, 13 }, 10 }, { { 548, 524, 552 }, { 256, 287, 255 }, { 83, 28, 86 }, 10 },
  { { 549, 510, 547 }, { 332, 288, 333 }, { 97, 13, 96 }, 10 }, { { 510, 549, 524 }, { 288, 332, 287 }, { 13, 97, 28 }, 10 },
  { { 550, 522, 523 }, { 424, 422, 446 }, { 215, 224, 120 }, 10 }, { { 522, 550, 539 }, { 422, 424, 392 }, { 224, 215, 233 }, 10 },
  { { 551, 523, 552 }, { 476, 446, 486 }, { 194, 120, 86 }, 10 }, { { 523, 551, 550 }, { 446, 476, 424 }, { 120, 194, 215 }, 10 },
  { { 553, 552, 524 }, { 290, 255, 287 }, { 165, 86, 28 }, 10 }, { { 552, 553, 551 }, { 255, 290, 254 }, { 86, 165, 194 }, 10 },
  { { 473, 524, 549 }, { 335, 287, 332 }, { 180, 28, 97 }, 10 }, { { 524, 473, 553 }, { 287, 335, 290 }, { 28, 180, 165 }, 10 },
  { { 723, 554, 557 }, { 460, 451, 513 }, { 622, 509, 473 }, 0 }, { { 714, 557, 554 }, { 510, 513, 451 }, { 442, 473, 509 }, 0 },
  { { 557, 714, 558 }, { 513, 510, 577 }, { 473, 442, 330 }, 0 }, { { 555, 558, 714 }, { 581, 577, 510 }, { 333, 330, 442 }, 0 },
  { { 558, 555, 559 }, { 577, 581, 623 }, { 330, 333, 354 }, 0 }, { { 556, 559, 555 }, { 621, 623, 581 }, { 365, 354, 333 }, 0 },
  { { 560, 723, 561 }, { 470, 460, 518 }, { 606, 622, 480 }, 0 }, { { 557, 561, 723 }, { 513, 518, 460 }, { 473, 480, 622 }, 0 },
  { { 561, 557, 562 }, { 518, 513, 589 }, { 480, 473, 308 }, 0 }, { { 558, 562, 557 }, { 577, 589, 513 }, { 330, 308, 473 }, 0 },
  { { 562, 558, 563 }, { 589, 577, 625 }, { 308, 330, 353 }, 0 }, { { 559, 563, 558 }, { 623, 625, 577 }, { 354, 353, 330 }, 0 },
  { { 722, 560, 564 }, { 499, 470, 534 }, { 568, 606, 467 }, 0 }, { { 561, 564, 560 }, { 518, 534, 470 }, { 480, 467, 606 }, 0 },
  { { 564, 561, 565 }, { 534, 518, 593 }, { 467, 480, 301 }, 0 }, { { 562, 565, 561 }, { 589, 593, 518 }, { 308, 301, 480 }, 0 },
  { { 565, 562, 566 }, { 593, 589, 626 }, { 301, 308, 359 }, 0 }, { { 563, 566, 562 }, { 625, 626, 589 }, { 353, 359, 308 }, 0 },
  { { 709, 722, 708 }, { 528, 499, 560 }, { 549, 568, 449 }, 0 }, { { 564, 708, 722 }, { 534, 560, 499 }, { 467, 449, 568 }, 0 },
  { { 708, 564, 567 }, { 560, 534, 600 }, { 449, 467, 304 }, 0 }, { { 565, 567, 564 }, { 593, 600, 534 }, { 301, 304, 467 }, 0 },
  { { 567, 565, 568 }, { 600, 593, 627 }, { 304, 301, 361 }, 0 }, { { 566, 568, 565 }, { 626, 627, 593 }, { 359, 361, 301 }, 0 },
  { { 710, 709, 711 }, { 687, 710, 657 }, { 560, 549, 453 }, 0 }, { { 708, 711, 709 }, { 684, 657, 710 }, { 449, 453, 549 }, 0 },
  { { 711, 708, 569 }, { 587, 560, 608 }, { 453, 449, 317 }, 0 }, { { 567, 569, 708 }, { 600, 608, 560 }, { 304, 317, 449 }, 0 },
  { { 569, 567, 570 }, { 608, 600, 628 }, { 317, 304, 360 }, 0 }, { { 568, 570, 567 }, { 627, 628, 600 }, { 361, 360, 304 }, 0 },
  { { 571, 710, 572 }, { 552, 556, 591 }, { 598, 560, 459 }, 0 }, { { 711, 572, 710 }, { 587, 591, 556 }, { 453, 459, 560 }, 0 },
  { { 572, 711, 573 }, { 591, 587, 610 }, { 459, 453, 343 }, 0 }, { { 569, 573, 711 }, { 608, 610, 587 }, { 317, 343, 453 }, 0 },
  { { 573, 569, 574 }, { 610, 608, 629 }, { 343, 317, 355 }, 0 }, { { 570, 574, 569 }, { 628, 629, 608 }, { 360, 355, 317 }, 0 },
  { { 721, 571, 575 }, { 536, 552, 571 }, { 594, 598, 475 }, 0 }, { { 572, 575, 571 }, { 591, 571, 552 }, { 459, 475, 598 }, 0 },
  { { 575, 572, 576 }, { 571, 591, 606 }, { 475, 459, 356 }, 0 }, { { 573, 576, 572 }, { 610, 606, 591 }, { 343, 356, 459 }, 0 },
  { { 576, 573, 577 }, { 606, 610, 630 }, { 356, 343, 358 }, 0 }, { { 574, 577, 573 }, { 629, 630, 610 }, { 355, 358, 343 }, 0 },
  { { 720, 721, 578 }, { 531, 536, 563 }, { 599, 594, 465 }, 0 }, { { 575, 578, 721 }, { 571, 563, 536 }, { 475, 465, 594 }, 0 },
  { { 578, 575, 579 }, { 563, 571, 603 }, { 465, 475, 351 }, 0 }, { { 576, 579, 575 }, { 606, 603, 571 }, { 356, 351, 475 }, 0 },
  { { 579, 576, 580 }, { 603, 606, 631 }, { 351, 356, 350 }, 0 }, { { 577, 580, 576 }, { 630, 631, 606 }, { 358, 350, 356 }, 0 },
  { { 581, 720, 582 }, { 532, 531, 564 }, { 602, 599, 463 }, 0 }, { { 578, 582, 720 }, { 563, 564, 531 }, { 465, 463, 599 }, 0 },
  { { 582, 578, 583 }, { 564, 563, 604 }, { 463, 465, 349 }, 0 }, { { 579, 583, 578 }, { 603, 604, 563 }, { 351, 349, 465 }, 0 },
  { { 583, 579, 584 }, { 604, 603, 632 }, { 349, 351, 349 }, 0 }, { { 580, 584, 579 }, { 631, 632, 603 }, { 350, 349, 351 }, 0 },
  { { 717, 716, 586 }, { 720, 745, 717 }, { 441, 508, 474 }, 0 }, { { 735, 586, 716 }, { 737, 717, 745 }, { 618, 474, 508 }, 0 },
  { { 719, 717, 587 }, { 662, 720, 665 }, { 334, 441, 329 }, 0 }, { { 586, 587, 717 }, { 717, 665, 720 }, { 474, 329, 441 }, 0 },
  { { 585, 719, 588 }, { 620, 662, 622 }, { 373, 334, 388 }, 0 }, { { 587, 588, 719 }, { 665, 622, 662 }, { 329, 388, 334 }, 0 },
  { { 586, 735, 589 }, { 717, 737, 712 }, { 474, 618, 479 }, 0 }, { { 734, 589, 735 }, { 731, 712, 737 }, { 597, 479, 618 }, 0 },
  { { 587, 586, 590 }, { 665, 717, 654 }, { 329, 474, 309 }, 0 }, { { 589, 590, 586 }, { 712, 654, 717 }, { 479, 309, 474 }, 0 },
  { { 588, 587, 591 }, { 622, 665, 619 }, { 388, 329, 389 }, 0 }, { { 590, 591, 587 }, { 654, 619, 665 }, { 309, 389, 329 }, 0 },
  { { 589, 734, 592 }, { 712, 731, 702 }, { 479, 597, 468 }, 0 }, { { 733, 592, 734 }, { 724, 702, 731 }, { 562, 468, 597 }, 0 },
  { { 590, 589, 593 }, { 654, 712, 650 }, { 309, 479, 300 }, 0 }, { { 592, 593, 589 }, { 702, 650, 712 }, { 468, 300, 479 }, 0 },
  { { 591, 590, 594 }, { 619, 654, 615 }, { 389, 309, 383 }, 0 }, { { 593, 594, 590 }, { 650, 615, 654 }, { 300, 383, 309 }, 0 },
  { { 592, 733, 712 }, { 702, 724, 683 }, { 468, 562, 448 }, 0 }, { { 732, 712, 733 }, { 709, 683, 724 }, { 551, 448, 562 }, 0 },
  { { 593, 592, 595 }, { 650, 702, 643 }, { 300, 468, 303 }, 0 }, { { 712, 595, 592 }, { 683, 643, 702 }, { 448, 303, 468 }, 0 },
  { { 594, 593, 596 }, { 615, 650, 616 }, { 383, 300, 380 }, 0 }, { { 595, 596, 593 }, { 643, 616, 650 }, { 303, 380, 300 }, 0 },
  { { 712, 732, 597 }, { 682, 708, 656 }, { 448, 551, 452 }, 0 }, { { 713, 597, 732 }, { 686, 656, 708 }, { 567, 452, 551 }, 0 },
  { { 595, 712, 598 }, { 643, 683, 635 }, { 303, 448, 318 }, 0 }, { { 597, 598, 712 }, { 658, 635, 683 }, { 452, 318, 448 }, 0 },
  { { 596, 595, 599 }, { 616, 643, 617 }, { 380, 303, 381 }, 0 }, { { 598, 599, 595 }, { 635, 617, 643 }, { 318, 381, 303 }, 0 },
  { { 597, 713, 600 }, { 658, 688, 652 }, { 452, 567, 458 }, 0 }, { { 731, 600, 713 }, { 690, 652, 688 }, { 601, 458, 567 }, 0 },
  { { 598, 597, 601 }, { 635, 658, 633 }, { 318, 452, 344 }, 0 }, { { 600, 601, 597 }, { 652, 633, 658 }, { 458, 344, 452 }, 0 },
  { { 599, 598, 602 }, { 617, 635, 614 }, { 381, 318, 387 }, 0 }, { { 601, 602, 598 }, { 633, 614, 635 }, { 344, 387, 318 }, 0 },
  { { 600, 731, 603 }, { 652, 690, 671 }, { 458, 601, 476 }, 0 }, { { 730, 603, 731 }, { 700, 671, 690 }, { 595, 476, 601 }, 0 },
  { { 601, 600, 604 }, { 633, 652, 637 }, { 344, 458, 385 }, 0 }, { { 603, 604, 600 }, { 671, 637, 652 }, { 476, 385, 458 }, 0 },
  { { 602, 601, 605 }, { 614, 633, 611 }, { 387, 344, 384 }, 0 }, { { 604, 605, 601 }, { 637, 611, 633 }, { 385, 384, 344 }, 0 },
  { { 603, 730, 607 }, { 671, 700, 678 }, { 476, 595, 466 }, 0 }, { { 606, 607, 730 }, { 704, 678, 700 }, { 605, 466, 595 }, 0 },
  { { 604, 603, 608 }, { 637, 671, 639 }, { 385, 476, 392 }, 0 }, { { 607, 608, 603 }, { 678, 639, 671 }, { 466, 392, 476 }, 0 },
  { { 605, 604, 609 }, { 611, 637, 612 }, { 384, 385, 390 }, 0 }, { { 608, 609, 604 }, { 639, 612, 637 }, { 392, 390, 385 }, 0 },
  { { 607, 606, 611 }, { 678, 704, 679 }, { 466, 605, 464 }, 0 }, { { 610, 611, 606 }, { 705, 679, 704 }, { 603, 464, 605 }, 0 },
  { { 608, 607, 612 }, { 639, 678, 640 }, { 392, 466, 393 }, 0 }, { { 611, 612, 607 }, { 679, 640, 678 }, { 464, 393, 466 }, 0 },
  { { 609, 608, 613 }, { 612, 639, 613 }, { 390, 392, 393 }, 0 }, { { 612, 613, 608 }, { 640, 613, 639 }, { 393, 393, 392 }, 0 },
  { { 714, 554, 715 }, { 721, 746, 723 }, { 442, 509, 177 }, 0 }, { { 614, 715, 554 }, { 280, 464, 279 }, { 500, 177, 509 }, 0 },
  { { 555, 714, 615 }, { 663, 721, 660 }, { 333, 442, 403 }, 0 }, { { 715, 615, 714 }, { 723, 660, 721 }, { 177, 403, 442 }, 0 },
  { { 556, 555, 616 }, { 621, 663, 618 }, { 365, 333, 379 }, 0 }, { { 615, 616, 555 }, { 660, 618, 663 }, { 403, 379, 333 }, 0 },
  { { 715, 614, 625 }, { 464, 280, 462 }, { 177, 500, 59 }, 0 }, { { 729, 625, 614 }, { 277, 462, 280 }, { 489, 59, 500 }, 0 },
  { { 625, 729, 718 }, { 462, 277, 463 }, { 59, 489, 179 }, 0 }, { { 633, 718, 729 }, { 278, 463, 277 }, { 499, 179, 489 }, 0 },
  { { 718, 633, 716 }, { 463, 278, 274 }, { 179, 499, 508 }, 0 }, { { 716, 717, 718 }, { 450, 509, 507 }, { 508, 441, 179 }, 0 },
  { { 634, 718, 719 }, { 583, 507, 580 }, { 404, 179, 334 }, 0 }, { { 717, 719, 718 }, { 509, 580, 507 }, { 441, 334, 179 }, 0 },
  { { 635, 634, 585 }, { 624, 583, 620 }, { 362, 404, 373 }, 0 }, { { 719, 585, 634 }, { 580, 620, 583 }, { 334, 373, 404 }, 0 },
  { { 720, 581, 618 }, { 341, 273, 340 }, { 599, 602, 706 }, 0 }, { { 617, 618, 581 }, { 271, 340, 273 }, { 708, 706, 602 }, 0 },
  { { 721, 720, 619 }, { 458, 341, 456 }, { 594, 599, 688 }, 0 }, { { 618, 619, 720 }, { 340, 456, 341 }, { 706, 688, 599 }, 0 },
  { { 571, 721, 620 }, { 541, 458, 540 }, { 598, 594, 705 }, 0 }, { { 619, 620, 721 }, { 456, 540, 458 }, { 688, 705, 594 }, 0 },
  { { 710, 571, 725 }, { 569, 541, 567 }, { 560, 598, 676 }, 0 }, { { 620, 725, 571 }, { 540, 567, 541 }, { 705, 676, 598 }, 0 },
  { { 709, 710, 621 }, { 710, 687, 714 }, { 549, 560, 660 }, 0 }, { { 725, 621, 710 }, { 694, 714, 687 }, { 676, 660, 560 }, 0 },
  { { 722, 709, 622 }, { 669, 598, 668 }, { 568, 549, 678 }, 0 }, { { 621, 622, 709 }, { 596, 668, 598 }, { 660, 678, 549 }, 0 },
  { { 560, 722, 623 }, { 726, 669, 729 }, { 606, 568, 689 }, 0 }, { { 622, 623, 722 }, { 668, 729, 669 }, { 678, 689, 568 }, 0 },
  { { 723, 560, 624 }, { 752, 726, 755 }, { 622, 606, 707 }, 0 }, { { 623, 624, 560 }, { 729, 755, 726 }, { 689, 707, 606 }, 0 },
  { { 554, 723, 614 }, { 759, 752, 757 }, { 509, 622, 500 }, 0 }, { { 624, 614, 723 }, { 755, 757, 752 }, { 707, 500, 622 }, 0 },
  { { 618, 617, 627 }, { 340, 271, 339 }, { 706, 708, 737 }, 0 }, { { 626, 627, 617 }, { 269, 339, 271 }, { 741, 737, 708 }, 0 },
  { { 619, 618, 628 }, { 456, 340, 455 }, { 688, 706, 712 }, 0 }, { { 627, 628, 618 }, { 339, 455, 340 }, { 737, 712, 706 }, 0 },
  { { 620, 619, 629 }, { 540, 456, 539 }, { 705, 688, 726 }, 0 }, { { 628, 629, 619 }, { 455, 539, 456 }, { 712, 726, 688 }, 0 },
  { { 725, 620, 724 }, { 567, 540, 565 }, { 676, 705, 684 }, 0 }, { { 629, 724, 620 }, { 539, 565, 540 }, { 726, 684, 705 }, 0 },
  { { 621, 725, 727 }, { 714, 694, 716 }, { 660, 676, 663 }, 0 }, { { 724, 727, 725 }, { 692, 716, 694 }, { 684, 663, 676 }, 0 },
  { { 622, 621, 630 }, { 668, 596, 664 }, { 678, 660, 693 }, 0 }, { { 727, 630, 621 }, { 594, 664, 596 }, { 663, 693, 660 }, 0 },
  { { 623, 622, 631 }, { 729, 668, 732 }, { 689, 678, 738 }, 0 }, { { 630, 631, 622 }, { 664, 732, 668 }, { 693, 738, 678 }, 0 },
  { { 624, 623, 632 }, { 755, 729, 756 }, { 707, 689, 736 }, 0 }, { { 631, 632, 623 }, { 732, 756, 729 }, { 738, 736, 689 }, 0 },
  { { 614, 624, 729 }, { 757, 755, 765 }, { 500, 707, 489 }, 0 }, { { 632, 729, 624 }, { 756, 765, 755 }, { 736, 489, 707 }, 0 },
  { { 627, 626, 637 }, { 339, 269, 338 }, { 737, 741, 704 }, 0 }, { { 636, 637, 626 }, { 268, 338, 269 }, { 709, 704, 741 }, 0 },
  { { 628, 627, 638 }, { 455, 339, 457 }, { 712, 737, 691 }, 0 }, { { 637, 638, 627 }, { 338, 457, 339 }, { 704, 691, 737 }, 0 },
  { { 629, 628, 639 }, { 539, 455, 538 }, { 726, 712, 702 }, 0 }, { { 638, 639, 628 }, { 457, 538, 455 }, { 691, 702, 712 }, 0 },
  { { 724, 629, 726 }, { 565, 539, 566 }, { 684, 726, 675 }, 0 }, { { 639, 726, 629 }, { 538, 566, 539 }, { 702, 675, 726 }, 0 },
  { { 727, 724, 728 }, { 716, 692, 715 }, { 663, 684, 661 }, 0 }, { { 726, 728, 724 }, { 693, 715, 692 }, { 675, 661, 684 }, 0 },
  { { 630, 727, 640 }, { 664, 594, 667 }, { 693, 663, 677 }, 0 }, { { 728, 640, 727 }, { 595, 667, 594 }, { 661, 677, 663 }, 0 },
  { { 631, 630, 641 }, { 732, 664, 728 }, { 738, 693, 690 }, 0 }, { { 640, 641, 630 }, { 667, 728, 664 }, { 677, 690, 693 }, 0 },
  { { 632, 631, 642 }, { 756, 732, 754 }, { 736, 738, 710 }, 0 }, { { 641, 642, 631 }, { 728, 754, 732 }, { 690, 710, 738 }, 0 },
  { { 729, 632, 633 }, { 765, 756, 758 }, { 489, 736, 499 }, 0 }, { { 642, 633, 632 }, { 754, 758, 756 }, { 710, 499, 736 }, 0 },
  { { 637, 636, 606 }, { 338, 268, 337 }, { 704, 709, 605 }, 0 }, { { 610, 606, 636 }, { 267, 337, 268 }, { 603, 605, 709 }, 0 },
  { { 638, 637, 730 }, { 457, 338, 454 }, { 691, 704, 595 }, 0 }, { { 606, 730, 637 }, { 337, 454, 338 }, { 605, 595, 704 }, 0 },
  { { 639, 638, 731 }, { 538, 457, 537 }, { 702, 691, 601 }, 0 }, { { 730, 731, 638 }, { 454, 537, 457 }, { 595, 601, 691 }, 0 },
  { { 726, 639, 713 }, { 566, 538, 568 }, { 675, 702, 567 }, 0 }, { { 731, 713, 639 }, { 537, 568, 538 }, { 601, 567, 702 }, 0 },
  { { 728, 726, 732 }, { 715, 693, 708 }, { 661, 675, 551 }, 0 }, { { 713, 732, 726 }, { 686, 708, 693 }, { 567, 551, 675 }, 0 },
  { { 640, 728, 733 }, { 667, 595, 670 }, { 677, 661, 562 }, 0 }, { { 732, 733, 728 }, { 597, 670, 595 }, { 551, 562, 661 }, 0 },
  { { 641, 640, 734 }, { 728, 667, 727 }, { 690, 677, 597 }, 0 }, { { 733, 734, 640 }, { 670, 727, 667 }, { 562, 597, 677 }, 0 },
  { { 642, 641, 735 }, { 754, 728, 753 }, { 710, 690, 618 }, 0 }, { { 734, 735, 641 }, { 727, 753, 728 }, { 597, 618, 690 }, 0 },
  { { 633, 642, 716 }, { 758, 754, 760 }, { 499, 710, 508 }, 0 }, { { 735, 716, 642 }, { 753, 760, 754 }, { 618, 508, 710 }, 0 },
  { { 643, 644, 740 }, { 736, 718, 743 }, { 117, 267, 230 }, 0 }, { { 741, 740, 644 }, { 721, 743, 718 }, { 297, 230, 267 }, 0 },
  { { 644, 645, 741 }, { 718, 666, 721 }, { 267, 411, 297 }, 0 }, { { 742, 741, 645 }, { 663, 721, 666 }, { 408, 297, 411 }, 0 },
  { { 645, 559, 742 }, { 666, 623, 663 }, { 411, 354, 408 }, 0 }, { { 556, 742, 559 }, { 621, 663, 623 }, { 365, 408, 354 }, 0 },
  { { 754, 646, 643 }, { 730, 713, 736 }, { 132, 261, 117 }, 0 }, { { 644, 643, 646 }, { 718, 736, 713 }, { 267, 117, 261 }, 0 },
  { { 646, 647, 644 }, { 713, 655, 718 }, { 261, 433, 267 }, 0 }, { { 645, 644, 647 }, { 666, 718, 655 }, { 411, 267, 433 }, 0 },
  { { 647, 563, 645 }, { 655, 625, 666 }, { 433, 353, 411 }, 0 }, { { 559, 645, 563 }, { 623, 666, 625 }, { 354, 411, 353 }, 0 },
  { { 753, 648, 754 }, { 725, 703, 730 }, { 172, 272, 132 }, 0 }, { { 646, 754, 648 }, { 713, 730, 703 }, { 261, 132, 272 }, 0 },
  { { 648, 649, 646 }, { 703, 651, 713 }, { 272, 438, 261 }, 0 }, { { 647, 646, 649 }, { 655, 713, 651 }, { 433, 261, 438 }, 0 },
  { { 649, 566, 647 }, { 651, 626, 655 }, { 438, 359, 433 }, 0 }, { { 563, 647, 566 }, { 625, 655, 626 }, { 353, 433, 359 }, 0 },
  { { 752, 650, 753 }, { 711, 685, 725 }, { 189, 291, 172 }, 0 }, { { 648, 753, 650 }, { 703, 725, 685 }, { 272, 172, 291 }, 0 },
  { { 650, 651, 648 }, { 685, 644, 703 }, { 291, 436, 272 }, 0 }, { { 649, 648, 651 }, { 651, 703, 644 }, { 438, 272, 436 }, 0 },
  { { 651, 568, 649 }, { 644, 627, 651 }, { 436, 361, 438 }, 0 }, { { 566, 649, 568 }, { 626, 651, 627 }, { 359, 438, 361 }, 0 },
  { { 736, 652, 752 }, { 554, 585, 527 }, { 181, 286, 189 }, 0 }, { { 650, 752, 652 }, { 559, 527, 585 }, { 291, 189, 286 }, 0 },
  { { 652, 653, 650 }, { 659, 636, 685 }, { 286, 421, 291 }, 0 }, { { 651, 650, 653 }, { 644, 685, 636 }, { 436, 291, 421 }, 0 },
  { { 653, 570, 651 }, { 636, 628, 644 }, { 421, 360, 436 }, 0 }, { { 568, 651, 570 }, { 627, 644, 628 }, { 361, 436, 360 }, 0 },
  { { 751, 654, 736 }, { 691, 653, 689 }, { 140, 280, 181 }, 0 }, { { 652, 736, 654 }, { 659, 689, 653 }, { 286, 181, 280 }, 0 },
  { { 654, 655, 652 }, { 653, 634, 659 }, { 280, 398, 286 }, 0 }, { { 653, 652, 655 }, { 636, 659, 634 }, { 421, 286, 398 }, 0 },
  { { 655, 574, 653 }, { 634, 629, 636 }, { 398, 355, 421 }, 0 }, { { 570, 653, 574 }, { 628, 636, 629 }, { 360, 421, 355 }, 0 },
  { { 749, 656, 751 }, { 701, 672, 691 }, { 144, 265, 140 }, 0 }, { { 654, 751, 656 }, { 653, 691, 672 }, { 280, 140, 265 }, 0 },
  { { 656, 657, 654 }, { 672, 638, 653 }, { 265, 357, 280 }, 0 }, { { 655, 654, 657 }, { 634, 653, 638 }, { 398, 280, 357 }, 0 },
  { { 657, 577, 655 }, { 638, 630, 634 }, { 357, 358, 398 }, 0 }, { { 574, 655, 577 }, { 629, 634, 630 }, { 355, 398, 358 }, 0 },
  { { 750, 658, 749 }, { 706, 680, 701 }, { 139, 274, 144 }, 0 }, { { 656, 749, 658 }, { 672, 701, 680 }, { 265, 144, 274 }, 0 },
  { { 658, 659, 656 }, { 680, 641, 672 }, { 274, 352, 265 }, 0 }, { { 657, 656, 659 }, { 638, 672, 641 }, { 357, 265, 352 }, 0 },
  { { 659, 580, 657 }, { 641, 631, 638 }, { 352, 350, 357 }, 0 }, { { 577, 657, 580 }, { 630, 638, 631 }, { 358, 357, 350 }, 0 },
  { { 748, 660, 750 }, { 707, 681, 706 }, { 135, 276, 139 }, 0 }, { { 658, 750, 660 }, { 680, 706, 681 }, { 274, 139, 276 }, 0 },
  { { 660, 661, 658 }, { 681, 642, 680 }, { 276, 349, 274 }, 0 }, { { 659, 658, 661 }, { 641, 680, 642 }, { 352, 274, 349 }, 0 },
  { { 661, 584, 659 }, { 642, 632, 641 }, { 349, 349, 352 }, 0 }, { { 580, 659, 584 }, { 631, 641, 632 }, { 350, 352, 349 }, 0 },
  { { 745, 662, 746 }, { 508, 512, 449 }, { 298, 266, 232 }, 0 }, { { 764, 746, 662 }, { 459, 449, 512 }, { 121, 232, 266 }, 0 },
  { { 747, 663, 745 }, { 579, 576, 508 }, { 407, 412, 298 }, 0 }, { { 662, 745, 663 }, { 512, 508, 576 }, { 266, 298, 412 }, 0 },
  { { 585, 588, 747 }, { 620, 622, 579 }, { 373, 388, 407 }, 0 }, { { 663, 747, 588 }, { 576, 579, 622 }, { 412, 407, 388 }, 0 },
  { { 662, 664, 764 }, { 512, 517, 459 }, { 266, 262, 121 }, 0 }, { { 763, 764, 664 }, { 469, 459, 517 }, { 141, 121, 262 }, 0 },
  { { 663, 665, 662 }, { 576, 588, 512 }, { 412, 432, 266 }, 0 }, { { 664, 662, 665 }, { 517, 512, 588 }, { 262, 266, 432 }, 0 },
  { { 588, 591, 663 }, { 622, 619, 576 }, { 388, 389, 412 }, 0 }, { { 665, 663, 591 }, { 588, 576, 619 }, { 432, 412, 389 }, 0 },
  { { 664, 666, 763 }, { 517, 533, 469 }, { 262, 271, 141 }, 0 }, { { 762, 763, 666 }, { 498, 469, 533 }, { 178, 141, 271 }, 0 },
  { { 665, 667, 664 }, { 588, 592, 517 }, { 432, 439, 262 }, 0 }, { { 666, 664, 667 }, { 533, 517, 592 }, { 271, 262, 439 }, 0 },
  { { 591, 594, 665 }, { 619, 615, 588 }, { 389, 383, 432 }, 0 }, { { 667, 665, 594 }, { 592, 588, 615 }, { 439, 432, 383 }, 0 },
  { { 666, 737, 762 }, { 533, 558, 498 }, { 271, 292, 178 }, 0 }, { { 738, 762, 737 }, { 526, 498, 558 }, { 188, 178, 292 }, 0 },
  { { 667, 668, 666 }, { 592, 599, 533 }, { 439, 437, 271 }, 0 }, { { 737, 666, 668 }, { 558, 533, 599 }, { 292, 271, 437 }, 0 },
  { { 594, 596, 667 }, { 615, 616, 592 }, { 383, 380, 439 }, 0 }, { { 668, 667, 596 }, { 599, 592, 616 }, { 437, 439, 380 }, 0 },
  { { 737, 739, 738 }, { 557, 584, 525 }, { 292, 287, 188 }, 0 }, { { 669, 738, 739 }, { 553, 525, 584 }, { 173, 188, 287 }, 0 },
  { { 668, 670, 737 }, { 599, 607, 558 }, { 437, 422, 292 }, 0 }, { { 739, 737, 670 }, { 586, 558, 607 }, { 287, 292, 422 }, 0 },
  { { 596, 599, 668 }, { 616, 617, 599 }, { 380, 381, 437 }, 0 }, { { 670, 668, 599 }, { 607, 599, 617 }, { 422, 437, 381 }, 0 },
  { { 739, 672, 669 }, { 586, 590, 555 }, { 287, 281, 173 }, 0 }, { { 671, 669, 672 }, { 551, 555, 590 }, { 137, 173, 281 }, 0 },
  { { 670, 673, 739 }, { 607, 609, 586 }, { 422, 399, 287 }, 0 }, { { 672, 739, 673 }, { 590, 586, 609 }, { 281, 287, 399 }, 0 },
  { { 599, 602, 670 }, { 617, 614, 607 }, { 381, 387, 422 }, 0 }, { { 673, 670, 602 }, { 609, 607, 614 }, { 399, 422, 387 }, 0 },
  { { 672, 675, 671 }, { 590, 570, 551 }, { 281, 264, 137 }, 0 }, { { 674, 671, 675 }, { 535, 551, 570 }, { 143, 137, 264 }, 0 },
  { { 673, 676, 672 }, { 609, 605, 590 }, { 399, 386, 281 }, 0 }, { { 675, 672, 676 }, { 570, 590, 605 }, { 264, 281, 386 }, 0 },
  { { 602, 605, 673 }, { 614, 611, 609 }, { 387, 384, 399 }, 0 }, { { 676, 673, 605 }, { 605, 609, 611 }, { 386, 399, 384 }, 0 },
  { { 675, 678, 674 }, { 570, 561, 535 }, { 264, 273, 143 }, 0 }, { { 677, 674, 678 }, { 530, 535, 561 }, { 133, 143, 273 }, 0 },
  { { 676, 679, 675 }, { 605, 601, 570 }, { 386, 391, 264 }, 0 }, { { 678, 675, 679 }, { 561, 570, 601 }, { 273, 264, 391 }, 0 },
  { { 605, 609, 676 }, { 611, 612, 605 }, { 384, 390, 386 }, 0 }, { { 679, 676, 609 }, { 601, 605, 612 }, { 391, 386, 390 }, 0 },
  { { 678, 680, 677 }, { 561, 562, 530 }, { 273, 275, 133 }, 0 }, { { 760, 677, 680 }, { 529, 530, 562 }, { 136, 133, 275 }, 0 },
  { { 679, 681, 678 }, { 601, 602, 561 }, { 391, 393, 273 }, 0 }, { { 680, 678, 681 }, { 562, 561, 602 }, { 275, 273, 393 }, 0 },
  { { 609, 613, 679 }, { 612, 613, 601 }, { 390, 393, 391 }, 0 }, { { 681, 679, 613 }, { 602, 601, 613 }, { 393, 391, 393 }, 0 },
  { { 741, 743, 740 }, { 511, 506, 452 }, { 297, 563, 230 }, 0 }, { { 682, 740, 743 }, { 767, 769, 735 }, { 241, 230, 563 }, 0 },
  { { 742, 683, 741 }, { 581, 582, 511 }, { 408, 337, 297 }, 0 }, { { 743, 741, 683 }, { 506, 511, 582 }, { 563, 297, 337 }, 0 },
  { { 556, 616, 742 }, { 621, 618, 581 }, { 365, 379, 408 }, 0 }, { { 683, 742, 616 }, { 582, 581, 618 }, { 337, 408, 379 }, 0 },
  { { 743, 692, 682 }, { 735, 734, 767 }, { 563, 682, 241 }, 0 }, { { 756, 682, 692 }, { 770, 767, 734 }, { 252, 241, 682 }, 0 },
  { { 692, 744, 756 }, { 734, 733, 770 }, { 682, 561, 252 }, 0 }, { { 765, 756, 744 }, { 762, 770, 733 }, { 242, 252, 561 }, 0 },
  { { 744, 745, 746 }, { 722, 719, 744 }, { 561, 298, 232 }, 0 }, { { 746, 765, 744 }, { 771, 762, 733 }, { 232, 242, 561 }, 0 },
  { { 700, 747, 744 }, { 660, 661, 722 }, { 336, 407, 561 }, 0 }, { { 745, 744, 747 }, { 719, 722, 661 }, { 298, 561, 407 }, 0 },
  { { 635, 585, 700 }, { 624, 620, 660 }, { 362, 373, 336 }, 0 }, { { 747, 700, 585 }, { 661, 660, 620 }, { 407, 336, 373 }, 0 },
  { { 750, 685, 748 }, { 751, 750, 768 }, { 139, 35, 135 }, 0 }, { { 684, 748, 685 }, { 766, 768, 750 }, { 32, 135, 35 }, 0 },
  { { 749, 686, 750 }, { 742, 741, 751 }, { 144, 53, 139 }, 0 }, { { 685, 750, 686 }, { 750, 751, 741 }, { 35, 139, 53 }, 0 },
  { { 751, 687, 749 }, { 699, 698, 742 }, { 140, 36, 144 }, 0 }, { { 686, 749, 687 }, { 741, 742, 698 }, { 53, 144, 36 }, 0 },
  { { 736, 688, 751 }, { 674, 676, 699 }, { 181, 65, 140 }, 0 }, { { 687, 751, 688 }, { 698, 699, 676 }, { 36, 140, 65 }, 0 },
  { { 752, 755, 736 }, { 527, 516, 554 }, { 189, 82, 181 }, 0 }, { { 688, 736, 755 }, { 549, 554, 516 }, { 65, 181, 82 }, 0 },
  { { 753, 689, 752 }, { 573, 575, 646 }, { 172, 63, 189 }, 0 }, { { 755, 752, 689 }, { 648, 646, 575 }, { 82, 189, 63 }, 0 },
  { { 754, 690, 753 }, { 475, 471, 573 }, { 132, 52, 172 }, 0 }, { { 689, 753, 690 }, { 575, 573, 471 }, { 63, 172, 52 }, 0 },
  { { 643, 691, 754 }, { 328, 323, 475 }, { 117, 34, 132 }, 0 }, { { 690, 754, 691 }, { 471, 475, 323 }, { 52, 132, 34 }, 0 },
  { { 740, 682, 643 }, { 276, 275, 328 }, { 230, 241, 117 }, 0 }, { { 691, 643, 682 }, { 323, 328, 275 }, { 34, 117, 241 }, 0 },
  { { 685, 694, 684 }, { 750, 749, 766 }, { 35, 4, 32 }, 0 }, { { 693, 684, 694 }, { 764, 766, 749 }, { 0, 32, 4 }, 0 },
  { { 686, 695, 685 }, { 741, 740, 750 }, { 53, 29, 35 }, 0 }, { { 694, 685, 695 }, { 749, 750, 740 }, { 4, 35, 29 }, 0 },
  { { 687, 696, 686 }, { 698, 697, 741 }, { 36, 14, 53 }, 0 }, { { 695, 686, 696 }, { 740, 741, 697 }, { 29, 53, 14 }, 0 },
  { { 688, 758, 687 }, { 676, 677, 698 }, { 65, 57, 36 }, 0 }, { { 696, 687, 758 }, { 697, 698, 677 }, { 14, 36, 57 }, 0 },
  { { 755, 759, 688 }, { 516, 514, 549 }, { 82, 77, 65 }, 0 }, { { 758, 688, 759 }, { 550, 549, 514 }, { 57, 65, 77 }, 0 },
  { { 689, 697, 755 }, { 575, 578, 648 }, { 63, 48, 82 }, 0 }, { { 759, 755, 697 }, { 649, 648, 578 }, { 77, 82, 48 }, 0 },
  { { 690, 698, 689 }, { 471, 461, 575 }, { 52, 3, 63 }, 0 }, { { 697, 689, 698 }, { 578, 575, 461 }, { 48, 63, 3 }, 0 },
  { { 691, 699, 690 }, { 323, 321, 471 }, { 34, 5, 52 }, 0 }, { { 698, 690, 699 }, { 461, 471, 321 }, { 3, 52, 5 }, 0 },
  { { 682, 756, 691 }, { 275, 270, 323 }, { 241, 252, 34 }, 0 }, { { 699, 691, 756 }, { 321, 323, 270 }, { 5, 34, 252 }, 0 },
  { { 694, 702, 693 }, { 749, 748, 764 }, { 4, 37, 0 }, 0 }, { { 701, 693, 702 }, { 763, 764, 748 }, { 33, 0, 37 }, 0 },
  { { 695, 703, 694 }, { 740, 739, 749 }, { 29, 50, 4 }, 0 }, { { 702, 694, 703 }, { 748, 749, 739 }, { 37, 4, 50 }, 0 },
  { { 696, 704, 695 }, { 697, 696, 740 }, { 14, 38, 29 }, 0 }, { { 703, 695, 704 }, { 739, 740, 696 }, { 50, 29, 38 }, 0 },
  { { 758, 757, 696 }, { 677, 675, 697 }, { 57, 66, 14 }, 0 }, { { 704, 696, 757 }, { 696, 697, 675 }, { 38, 14, 66 }, 0 },
  { { 759, 761, 758 }, { 514, 515, 550 }, { 77, 81, 57 }, 0 }, { { 757, 758, 761 }, { 548, 550, 515 }, { 66, 57, 81 }, 0 },
  { { 697, 705, 759 }, { 578, 574, 649 }, { 48, 64, 77 }, 0 }, { { 761, 759, 705 }, { 647, 649, 574 }, { 81, 77, 64 }, 0 },
  { { 698, 706, 697 }, { 461, 472, 578 }, { 3, 51, 48 }, 0 }, { { 705, 697, 706 }, { 574, 578, 472 }, { 64, 48, 51 }, 0 },
  { { 699, 707, 698 }, { 321, 322, 461 }, { 5, 31, 3 }, 0 }, { { 706, 698, 707 }, { 472, 461, 322 }, { 51, 3, 31 }, 0 },
  { { 756, 765, 699 }, { 270, 272, 321 }, { 252, 242, 5 }, 0 }, { { 707, 699, 765 }, { 322, 321, 272 }, { 31, 5, 242 }, 0 },
  { { 702, 677, 701 }, { 748, 747, 763 }, { 37, 133, 33 }, 0 }, { { 760, 701, 677 }, { 761, 763, 747 }, { 136, 33, 133 }, 0 },
  { { 703, 674, 702 }, { 739, 738, 748 }, { 50, 143, 37 }, 0 }, { { 677, 702, 674 }, { 747, 748, 738 }, { 133, 37, 143 }, 0 },
  { { 704, 671, 703 }, { 696, 695, 739 }, { 38, 137, 50 }, 0 }, { { 674, 703, 671 }, { 738, 739, 695 }, { 143, 50, 137 }, 0 },
  { { 757, 669, 704 }, { 675, 673, 696 }, { 66, 173, 38 }, 0 }, { { 671, 704, 669 }, { 695, 696, 673 }, { 137, 38, 173 }, 0 },
  { { 761, 738, 757 }, { 515, 525, 548 }, { 81, 188, 66 }, 0 }, { { 669, 757, 738 }, { 553, 548, 525 }, { 173, 66, 188 }, 0 },
  { { 705, 762, 761 }, { 574, 572, 647 }, { 64, 178, 81 }, 0 }, { { 738, 761, 762 }, { 645, 647, 572 }, { 188, 81, 178 }, 0 },
  { { 706, 763, 705 }, { 472, 474, 574 }, { 51, 141, 64 }, 0 }, { { 762, 705, 763 }, { 572, 574, 474 }, { 178, 64, 141 }, 0 },
  { { 707, 764, 706 }, { 322, 327, 472 }, { 31, 121, 51 }, 0 }, { { 763, 706, 764 }, { 474, 472, 327 }, { 141, 51, 121 }, 0 },
  { { 765, 746, 707 }, { 272, 266, 322 }, { 242, 232, 31 }, 0 }, { { 764, 707, 746 }, { 327, 322, 266 }, { 121, 31, 232 }, 0 }
};
