// Extrude2DPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "Extrude2DPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExtrude2DPage property page

IMPLEMENT_DYNCREATE(CExtrude2DPage, CPropertyPage)

CExtrude2DPage::CExtrude2DPage() : CPropertyPage(CExtrude2DPage::IDD)
{
	//{{AFX_DATA_INIT(CExtrude2DPage)
	m_Extrude2D_MaxX = _T("");
	m_Extrude2D_AdjustLocation = _T("");
	m_Extrude2D_MaxY = _T("");
	m_Extrude2D_MaxZ = _T("");
	m_Extrude2D_MinX = _T("");
	m_Extrude2D_MinY = _T("");
	m_Extrude2D_MinZ = _T("");
	m_Extrude2D_TypeFlag = -1;
	m_Extrude2D_StepAngle = _T("");
	m_Extrude2D_Thickness = _T("");
	m_Extrude2D_XRotation = _T("");
	m_Extrude2D_YRotation = _T("");
	m_Extrude2D_ZRotation = _T("");
	m_Extrude2D_LayerName = _T("");
	//}}AFX_DATA_INIT
}

CExtrude2DPage::~CExtrude2DPage()
{
}

void CExtrude2DPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExtrude2DPage)
	DDX_Text(pDX, IDC_EXTRUDE2D_MAXX, m_Extrude2D_MaxX);
	DDX_Text(pDX, IDC_EXTRUDE2D_ADJUSTLOCATION, m_Extrude2D_AdjustLocation);
	DDX_Text(pDX, IDC_EXTRUDE2D_MAXY, m_Extrude2D_MaxY);
	DDX_Text(pDX, IDC_EXTRUDE2D_MAXZ, m_Extrude2D_MaxZ);
	DDX_Text(pDX, IDC_EXTRUDE2D_MINX, m_Extrude2D_MinX);
	DDX_Text(pDX, IDC_EXTRUDE2D_MINY, m_Extrude2D_MinY);
	DDX_Text(pDX, IDC_EXTRUDE2D_MINZ, m_Extrude2D_MinZ);
	DDX_Radio(pDX, IDC_EXTRUDE2D_NORMAL, m_Extrude2D_TypeFlag);
	DDX_Text(pDX, IDC_EXTRUDE2D_STEPANGLE, m_Extrude2D_StepAngle);
	DDX_Text(pDX, IDC_EXTRUDE2D_THICKNESS, m_Extrude2D_Thickness);
	DDX_Text(pDX, IDC_EXTRUDE2D_XROTATION, m_Extrude2D_XRotation);
	DDX_Text(pDX, IDC_EXTRUDE2D_YROTATION, m_Extrude2D_YRotation);
	DDX_Text(pDX, IDC_EXTRUDE2D_ZROTATION, m_Extrude2D_ZRotation);
	DDX_Text(pDX, IDC_EXTRUDE2D_LAYERNAME, m_Extrude2D_LayerName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExtrude2DPage, CPropertyPage)
	//{{AFX_MSG_MAP(CExtrude2DPage)
	ON_BN_CLICKED(IDC_EXTRUDE2D_START, OnExtrude2dStart)
	ON_BN_CLICKED(IDC_EXTRUDE2D_GETNEXTLAYER, OnExtrude2dGetnextlayer)
	ON_BN_CLICKED(IDC_EXTRUDE2D_NORMAL, OnExtrude2dNormal)
	ON_BN_CLICKED(IDC_EXTRUDE2D_FLATTOP, OnExtrude2dFlattop)
	ON_BN_CLICKED(IDC_EXTRUDE2D_FLATBOTTOM, OnExtrude2dFlatbottom)
	ON_BN_CLICKED(IDC_EXTRUDE2D_MARKROTATIONS, OnExtrude2dMarkrotations)
	ON_BN_CLICKED(IDC_EXTRUDE2D_XROTATE1, OnExtrude2dXrotate1)
	ON_BN_CLICKED(IDC_EXTRUDE2D_XROTATE2, OnExtrude2dXrotate2)
	ON_BN_CLICKED(IDC_EXTRUDE2D_YROTATE1, OnExtrude2dYrotate1)
	ON_BN_CLICKED(IDC_EXTRUDE2D_YROTATE2, OnExtrude2dYrotate2)
	ON_BN_CLICKED(IDC_EXTRUDE2D_ZROTATE1, OnExtrude2dZrotate1)
	ON_BN_CLICKED(IDC_EXTRUDE2D_ZROTATE2, OnExtrude2dZrotate2)
	ON_BN_CLICKED(IDC_EXTRUDE2D_CLEARROTATIONS, OnExtrude2dClearrotations)
	ON_BN_CLICKED(IDC_EXTRUDE2D_EXTRUDE, OnExtrude2dExtrude)
	ON_BN_CLICKED(IDC_EXTRUDE2D_REDO, OnExtrude2dRedo)
	ON_BN_CLICKED(IDC_EXTRUDE2D_UNDO, OnExtrude2dUndo)
	ON_BN_CLICKED(IDC_EXTRUDE2D_STOP, OnExtrude2dStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExtrude2DPage message handlers

BOOL CExtrude2DPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CExtrude2DPage::OnExtrude2dStart() 
{
	if (at3dData->extrude2D_open) return;

	at3dData->extrude2D_open = At3d_ExtrudePseudo2D_Start();

  if (at3dData->extrude2D_open)
  {
    // start with first layer
    //
    at3dData->extrude2D_layerPtr = 0;
    OnExtrude2dGetnextlayer();
  }
}

void CExtrude2DPage::OnExtrude2dGetnextlayer() 
{
	if (!at3dData->extrude2D_open) return;

  // just select layers in order they are in list
  //
  at3dData->extrude2D_layerPtr = At3d_GetNextLayer(at3dData->extrude2D_layerPtr,
                                                   at3dData->extrude2D_layerName);

  if (at3dData->extrude2D_layerPtr)
  {
    m_Extrude2D_LayerName = at3dData->extrude2D_layerName;
		UpdateData(FALSE);

    if (At3d_ExtrudePseudo2D_SetLayer(at3dData->extrude2D_layerName)> 0)
    {
      Extrude2D_Display_Layer_Settings();
    }
  }
}

void CExtrude2DPage::Extrude2D_Display_Layer_Settings()
{
  if (!at3dData->extrude2D_open) return;

  Extrude2D_Display_Mesh_Size();
  Extrude2D_Display_Rotations();

  at3dData->extrude2D_typeFlag = At3d_ExtrudePseudo2D_GetTypeFlag();
   
  if (at3dData->extrude2D_typeFlag == EXTRUDE_PSEUDO2D_NORMAL)
  {
    m_Extrude2D_TypeFlag = 0;
  }
  else if (at3dData->extrude2D_typeFlag == EXTRUDE_PSEUDO2D_FLAT_TOP)
  {
    m_Extrude2D_TypeFlag = 1;
  }
  else
  {
    m_Extrude2D_TypeFlag = 2;
  }

  at3dData->extrude2D_thickness = At3d_ExtrudePseudo2D_GetThickness();
  at3dData->extrude2D_adjustLocation = At3d_ExtrudePseudo2D_GetAdjustLocation();

  m_Extrude2D_Thickness.Format("%f", at3dData->extrude2D_thickness);
  m_Extrude2D_AdjustLocation.Format("%f", at3dData->extrude2D_adjustLocation);
	UpdateData(FALSE);
}

void CExtrude2DPage::Extrude2D_Display_Mesh_Size(void)
{
  if (!at3dData->extrude2D_open) return;

  At3d_ExtrudePseudo2D_Get_Mesh_Size(at3dData->extrude2D_minMax);

  m_Extrude2D_MinX.Format("%f", at3dData->extrude2D_minMax[0]);
  m_Extrude2D_MinY.Format("%f", at3dData->extrude2D_minMax[1]);
  m_Extrude2D_MinZ.Format("%f", at3dData->extrude2D_minMax[2]);

  m_Extrude2D_MaxX.Format("%f", at3dData->extrude2D_minMax[3]);
  m_Extrude2D_MaxY.Format("%f", at3dData->extrude2D_minMax[4]);
  m_Extrude2D_MaxZ.Format("%f", at3dData->extrude2D_minMax[5]);
	UpdateData(FALSE);
}

void CExtrude2DPage::Extrude2D_Display_Rotations(void)
{
  if (!at3dData->extrude2D_open) return;

  At3d_ExtrudePseudo2D_GetRotateAngles(&at3dData->extrude2D_xRotation,
                                       &at3dData->extrude2D_yRotation,
                                       &at3dData->extrude2D_zRotation);

  m_Extrude2D_XRotation.Format("%f", at3dData->extrude2D_xRotation);
  m_Extrude2D_YRotation.Format("%f", at3dData->extrude2D_yRotation);
  m_Extrude2D_ZRotation.Format("%f", at3dData->extrude2D_zRotation);
	UpdateData(FALSE);
}

void CExtrude2DPage::OnExtrude2dNormal() 
{
	at3dData->extrude2D_typeFlag = EXTRUDE_PSEUDO2D_NORMAL;
}

void CExtrude2DPage::OnExtrude2dFlattop() 
{
	at3dData->extrude2D_typeFlag = EXTRUDE_PSEUDO2D_FLAT_TOP;
}

void CExtrude2DPage::OnExtrude2dFlatbottom() 
{
	at3dData->extrude2D_typeFlag = EXTRUDE_PSEUDO2D_FLAT_BOTTOM;
}

void CExtrude2DPage::OnExtrude2dMarkrotations() 
{
	if (!at3dData->extrude2D_open) return;

  At3d_ExtrudePseudo2D_Mark();
  Extrude2D_Display_Rotations();
}

void CExtrude2DPage::Extrude2D_GetStepAngle(void)
{
  UpdateData(TRUE);
  at3dData->extrude2D_stepAngle = atof(m_Extrude2D_StepAngle);  
}

void CExtrude2DPage::OnExtrude2dXrotate1() 
{
	if (!at3dData->extrude2D_open) return;

  Extrude2D_GetStepAngle();
  At3d_ExtrudePseudo2D_SetRotateAngles(1, -at3dData->extrude2D_stepAngle, 0.0, 0.0);
  Extrude2D_Display_Rotations();
}

void CExtrude2DPage::OnExtrude2dXrotate2() 
{
	if (!at3dData->extrude2D_open) return;

  Extrude2D_GetStepAngle();
  At3d_ExtrudePseudo2D_SetRotateAngles(1, at3dData->extrude2D_stepAngle, 0.0, 0.0);
  Extrude2D_Display_Rotations();
}

void CExtrude2DPage::OnExtrude2dYrotate1() 
{
	if (!at3dData->extrude2D_open) return;

  Extrude2D_GetStepAngle();
  At3d_ExtrudePseudo2D_SetRotateAngles(1, 0.0, -at3dData->extrude2D_stepAngle, 0.0);
  Extrude2D_Display_Rotations();
}

void CExtrude2DPage::OnExtrude2dYrotate2() 
{
	if (!at3dData->extrude2D_open) return;

  Extrude2D_GetStepAngle();
  At3d_ExtrudePseudo2D_SetRotateAngles(1, 0.0, at3dData->extrude2D_stepAngle, 0.0);
  Extrude2D_Display_Rotations();
}

void CExtrude2DPage::OnExtrude2dZrotate1() 
{
	if (!at3dData->extrude2D_open) return;

  Extrude2D_GetStepAngle();
  At3d_ExtrudePseudo2D_SetRotateAngles(1, 0.0, 0.0, -at3dData->extrude2D_stepAngle);
  Extrude2D_Display_Rotations();
}

void CExtrude2DPage::OnExtrude2dZrotate2() 
{
	if (!at3dData->extrude2D_open) return;

  Extrude2D_GetStepAngle();
  At3d_ExtrudePseudo2D_SetRotateAngles(1, 0.0, 0.0, at3dData->extrude2D_stepAngle);
  Extrude2D_Display_Rotations();
}

void CExtrude2DPage::OnExtrude2dClearrotations() 
{
	if (!at3dData->extrude2D_open) return;

  At3d_ExtrudePseudo2D_Clear();
  Extrude2D_Display_Rotations();
}

void CExtrude2DPage::Extrude2D_Get_Thickness_Adjust(void)
{
  UpdateData(TRUE);
  at3dData->extrude2D_thickness = atof(m_Extrude2D_Thickness);  
  at3dData->extrude2D_adjustLocation = atof(m_Extrude2D_AdjustLocation);  
}

void CExtrude2DPage::OnExtrude2dExtrude() 
{
	if (!at3dData->extrude2D_open) return;

  Extrude2D_Get_Thickness_Adjust();
  At3d_ExtrudePseudo2D_Extrude(at3dData->extrude2D_typeFlag,
                               at3dData->extrude2D_thickness,
                               at3dData->extrude2D_adjustLocation);
  Extrude2D_Display_Mesh_Size();
}

void CExtrude2DPage::OnExtrude2dRedo() 
{
	if (!at3dData->extrude2D_open) return;

  Extrude2D_Get_Thickness_Adjust();
  At3d_ExtrudePseudo2D_Redo(at3dData->extrude2D_typeFlag,
                            at3dData->extrude2D_thickness,
                            at3dData->extrude2D_adjustLocation);
  Extrude2D_Display_Mesh_Size();
}

void CExtrude2DPage::OnExtrude2dUndo() 
{
	if (!at3dData->extrude2D_open) return;

  At3d_ExtrudePseudo2D_Undo();
  Extrude2D_Display_Mesh_Size();
}

void CExtrude2DPage::OnExtrude2dStop() 
{
	if (!at3dData->extrude2D_open) return;

  if (At3d_ExtrudePseudo2D_Stop() > 0) at3dData->extrude2D_open = 0;
}
