// EditPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "EditPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditPage property page

IMPLEMENT_DYNCREATE(CEditPage, CPropertyPage)

CEditPage::CEditPage() : CPropertyPage(CEditPage::IDD)
{
	//{{AFX_DATA_INIT(CEditPage)
	m_EditUpperFaces = FALSE;
	m_EditUpperBevels = FALSE;
	m_EditLowerFaces = FALSE;
	m_EditLowerBevels = FALSE;
	m_EditRotateXAngle = _T("");
	m_EditRotateYAngle = _T("");
	m_EditRotateZAngle = _T("");
	m_EditRotateStepAngle = _T("");
	m_EditScaleStepFactor = _T("");
	m_EditScaleXFactor = _T("");
	m_EditScaleYFactor = _T("");
	m_EditScaleZFactor = _T("");
	m_EditAxisGroup = -1;
	m_EditGridSize = _T("");
	m_EditDisplayGrid = FALSE;
	m_EditSnapToGrid = FALSE;
	m_EditPickModeLabel = _T("");
	m_EditDivide = FALSE;
	m_EditSnapKeepRelative = FALSE;
	m_EditName = _T("");
	m_EditMoveVertexX = _T("");
	m_EditMoveVertexY = _T("");
	m_EditMoveVertexZ = _T("");
	m_EditMoveVertexStep = _T("");
	//}}AFX_DATA_INIT
}

CEditPage::~CEditPage()
{
}

void CEditPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditPage)
	DDX_Check(pDX, IDC_EDITUPPERFACES, m_EditUpperFaces);
	DDX_Check(pDX, IDC_EDITUPPERBEVELS, m_EditUpperBevels);
	DDX_Check(pDX, IDC_EDITLOWERFACES, m_EditLowerFaces);
	DDX_Check(pDX, IDC_EDITLOWERBEVELS, m_EditLowerBevels);
	DDX_Text(pDX, IDC_EDITROTATEXANGLE, m_EditRotateXAngle);
	DDX_Text(pDX, IDC_EDITROTATEYANGLE, m_EditRotateYAngle);
	DDX_Text(pDX, IDC_EDITROTATEZANGLE, m_EditRotateZAngle);
	DDX_Text(pDX, IDC_EDITROTATESTEPANGLE, m_EditRotateStepAngle);
	DDX_Text(pDX, IDC_EDITSCALESTEPFACTOR, m_EditScaleStepFactor);
	DDX_Text(pDX, IDC_EDITSCALEXFACTOR, m_EditScaleXFactor);
	DDX_Text(pDX, IDC_EDITSCALEYFACTOR, m_EditScaleYFactor);
	DDX_Text(pDX, IDC_EDITSCALEZFACTOR, m_EditScaleZFactor);
	DDX_Radio(pDX, IDC_EDITLOCALAXIS, m_EditAxisGroup);
	DDX_Text(pDX, IDC_EDITGRIDSIZE, m_EditGridSize);
	DDX_Check(pDX, IDC_EDITDISPLAYGRID, m_EditDisplayGrid);
	DDX_Check(pDX, IDC_EDITSNAPTOGRID, m_EditSnapToGrid);
	DDX_Text(pDX, IDC_EDITPICKMODELABEL, m_EditPickModeLabel);
	DDX_Check(pDX, IDC_EDITDIVIDE, m_EditDivide);
	DDX_Check(pDX, IDC_EDITSNAPKEEPRELATIVE, m_EditSnapKeepRelative);
	DDX_Text(pDX, IDC_EDITNAME, m_EditName);
	DDX_Text(pDX, IDC_EDITMOVEVERTEXX, m_EditMoveVertexX);
	DDX_Text(pDX, IDC_EDITMOVEVERTEXY, m_EditMoveVertexY);
	DDX_Text(pDX, IDC_EDITMOVEVERTEXZ, m_EditMoveVertexZ);
	DDX_Text(pDX, IDC_EDITMOVEVERTEXSTEP, m_EditMoveVertexStep);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditPage, CPropertyPage)
	//{{AFX_MSG_MAP(CEditPage)
	ON_BN_CLICKED(IDC_STARTEDITVERTICES, OnStarteditvertices)
	ON_BN_CLICKED(IDC_STOPEDITVERTICES, OnStopeditvertices)
	ON_BN_CLICKED(IDC_EDITEXTRUDESTART, OnEditextrudestart)
	ON_BN_CLICKED(IDC_EDITEXTRUDENOW, OnEditextrudenow)
	ON_BN_CLICKED(IDC_EDITDRAGBOX, OnEditdragbox)
	ON_BN_CLICKED(IDC_EDITPICKVERTEX, OnEditpickvertex)
	ON_BN_CLICKED(IDC_EDITPICKMODEFIRST, OnEditpickmodefirst)
	ON_BN_CLICKED(IDC_EDITPICKMODECONNECTED, OnEditpickmodeconnected)
	ON_BN_CLICKED(IDC_EDITPICKMODEANYWHERE, OnEditpickmodeanywhere)
	ON_BN_CLICKED(IDC_PICKMODEERASE, OnPickmodeerase)
	ON_BN_CLICKED(IDC_EDITPICKMODEDELETEALL, OnEditpickmodedeleteall)
	ON_BN_CLICKED(IDC_EDITPICKALLVERTICES, OnEditpickallvertices)
	ON_BN_CLICKED(IDC_EDITDRAGVERTEX, OnEditdragvertex)
	ON_BN_CLICKED(IDC_EDITPICKEDGE, OnEditpickedge)
	ON_BN_CLICKED(IDC_EDITNEWEDGE, OnEditnewedge)
	ON_BN_CLICKED(IDC_EDITDELETEVERTEX, OnEditdeletevertex)
	ON_BN_CLICKED(IDC_EDITDIVIDEEDGE, OnEditdivideedge)
	ON_BN_CLICKED(IDC_EDITROTATEGROUP, OnEditrotategroup)
	ON_BN_CLICKED(IDC_GETEDITROTATEANGLES, OnGeteditrotateangles)
	ON_BN_CLICKED(IDC_SETEDITROTATEANGLES, OnSeteditrotateangles)
	ON_BN_CLICKED(IDC_SETEDITROTATEXANGLE1, OnSeteditrotatexangle1)
	ON_BN_CLICKED(IDC_SETEDITROTATEXANGLE2, OnSeteditrotatexangle2)
	ON_BN_CLICKED(IDC_SETEDITROTATEYANGLE1, OnSeteditrotateyangle1)
	ON_BN_CLICKED(IDC_SETEDITROTATEYANGLE2, OnSeteditrotateyangle2)
	ON_BN_CLICKED(IDC_SETEDITROTATEZANGLE1, OnSeteditrotatezangle1)
	ON_BN_CLICKED(IDC_SETEDITROTATEZANGLE2, OnSeteditrotatezangle2)
	ON_BN_CLICKED(IDC_EDITROTATEOKAY, OnEditrotateokay)
	ON_BN_CLICKED(IDC_EDITROTATECANCEL, OnEditrotatecancel)
	ON_BN_CLICKED(IDC_EDITSCALEGROUP, OnEditscalegroup)
	ON_BN_CLICKED(IDC_GETEDITSCALEFACTORS, OnGeteditscalefactors)
	ON_BN_CLICKED(IDC_SETEDITSCALEFACTORS, OnSeteditscalefactors)
	ON_BN_CLICKED(IDC_SETEDITSCALEXFACTOR1, OnSeteditscalexfactor1)
	ON_BN_CLICKED(IDC_SETEDITSCALEXFACTOR2, OnSeteditscalexfactor2)
	ON_BN_CLICKED(IDC_SETEDITSCALEYFACTOR1, OnSeteditscaleyfactor1)
	ON_BN_CLICKED(IDC_SETEDITSCALEYFACTOR2, OnSeteditscaleyfactor2)
	ON_BN_CLICKED(IDC_SETEDITSCALEZFACTOR1, OnSeteditscalezfactor1)
	ON_BN_CLICKED(IDC_SETEDITSCALEZFACTOR2, OnSeteditscalezfactor2)
	ON_BN_CLICKED(IDC_SETEDITSCALEXYZFACTOR1, OnSeteditscalexyzfactor1)
	ON_BN_CLICKED(IDC_SETEDITSCALEXYZFACTOR2, OnSeteditscalexyzfactor2)
	ON_BN_CLICKED(IDC_EDITSCALEOKAY, OnEditscaleokay)
	ON_BN_CLICKED(IDC_EDITSCALECANCEL, OnEditscalecancel)
	ON_BN_CLICKED(IDC_EDITREDUCEVERTICES, OnEditreducevertices)
	ON_BN_CLICKED(IDC_EDITPICKGHOST, OnEditpickghost)
	ON_BN_CLICKED(IDC_EDITGHOSTOKAY, OnEditghostokay)
	ON_BN_CLICKED(IDC_EDITGHOSTCANCEL, OnEditghostcancel)
	ON_BN_CLICKED(IDC_EDITGHOSTON, OnEditghoston)
	ON_BN_CLICKED(IDC_EDITGHOSTOFF, OnEditghostoff)
	ON_BN_CLICKED(IDC_EDITLOCALAXIS, OnEditlocalaxis)
	ON_BN_CLICKED(IDC_EDITWORLDAXIS, OnEditworldaxis)
	ON_BN_CLICKED(IDC_EDITVERTEXSNAPSTART, OnEditvertexsnapstart)
	ON_BN_CLICKED(IDC_EDITVERTEXSNAPSHOWALL, OnEditvertexsnapshowall)
	ON_BN_CLICKED(IDC_EDITVERTEXSNAPOKAY, OnEditvertexsnapokay)
	ON_BN_CLICKED(IDC_EDITVERTEXSNAPCANCEL, OnEditvertexsnapcancel)
	ON_BN_CLICKED(IDC_EDITUPPERFACES, OnEditupperfaces)
	ON_BN_CLICKED(IDC_EDITUPPERBEVELS, OnEditupperbevels)
	ON_BN_CLICKED(IDC_EDITLOWERFACES, OnEditlowerfaces)
	ON_BN_CLICKED(IDC_EDITLOWERBEVELS, OnEditlowerbevels)
	ON_BN_CLICKED(IDC_EDITSWITCHUPPER, OnEditswitchupper)
	ON_BN_CLICKED(IDC_EDITSWITCHLOWER, OnEditswitchlower)
	ON_BN_CLICKED(IDC_EDITDISPLAYGRID, OnEditdisplaygrid)
	ON_BN_CLICKED(IDC_EDITSNAPTOGRID, OnEditsnaptogrid)
	ON_BN_CLICKED(IDC_EDITUNDOSELECTED, OnEditundoselected)
	ON_BN_CLICKED(IDC_EDITUNDOLAYER, OnEditundolayer)
	ON_BN_CLICKED(IDC_EDITUNDOALLLAYERS, OnEditundoalllayers)
	ON_BN_CLICKED(IDC_EDITFLIPX, OnEditflipx)
	ON_BN_CLICKED(IDC_EDITFLIPY, OnEditflipy)
	ON_BN_CLICKED(IDC_EDITFLIPZ, OnEditflipz)
	ON_BN_CLICKED(IDC_EDITMOVEBEVELZERO, OnEditmovebevelzero)
	ON_BN_CLICKED(IDC_EDITSWITCH, OnEditswitch)
	ON_BN_CLICKED(IDC_EDITOPENOUTLINE, OnEditopenoutline)
	ON_BN_CLICKED(IDC_EDITCLOSEOUTLINE, OnEditcloseoutline)
	ON_BN_CLICKED(IDC_EDITPICKSOLID, OnEditpicksolid)
	ON_BN_CLICKED(IDC_EDITPICKWIRE, OnEditpickwire)
	ON_BN_CLICKED(IDC_EDITOTHERSOLID, OnEditothersolid)
	ON_BN_CLICKED(IDC_EDITOTHERWIRE, OnEditotherwire)
	ON_BN_CLICKED(IDC_EDITGETUPPER, OnEditgetupper)
	ON_BN_CLICKED(IDC_EDITCLEARUPPER, OnEditclearupper)
	ON_BN_CLICKED(IDC_EDITSETUPPER, OnEditsetupper)
	ON_BN_CLICKED(IDC_EDITGETLOWER, OnEditgetlower)
	ON_BN_CLICKED(IDC_EDITCLEARLOWER, OnEditclearlower)
	ON_BN_CLICKED(IDC_EDITSETLOWER, OnEditsetlower)
	ON_BN_CLICKED(IDC_EDITDIVIDE, OnEditdivide)
	ON_BN_CLICKED(IDC_EDITSNAPKEEPRELATIVE, OnEditsnapkeeprelative)
	ON_BN_CLICKED(IDC_EDITSELECTLAYER, OnEditselectlayer)
	ON_BN_CLICKED(IDC_GETEDITMOVEVERTEX, OnGeteditmovevertex)
	ON_BN_CLICKED(IDC_SETEDITMOVEVERTEX, OnSeteditmovevertex)
	ON_BN_CLICKED(IDC_EDITMOVEVERTEXX1, OnEditmovevertexx1)
	ON_BN_CLICKED(IDC_EDITMOVEVERTEXY1, OnEditmovevertexy1)
	ON_BN_CLICKED(IDC_EDITMOVEVERTEXX2, OnEditmovevertexx2)
	ON_BN_CLICKED(IDC_EDITMOVEVERTEXY2, OnEditmovevertexy2)
	ON_BN_CLICKED(IDC_EDITMOVEVERTEXZ1, OnEditmovevertexz1)
	ON_BN_CLICKED(IDC_EDITMOVEVERTEXZ2, OnEditmovevertexz2)
	ON_BN_CLICKED(IDC_EDITMAKEBEVELSETS, OnEditmakebevelsets)
	//}}AFX_MSG_MAP
  ON_BN_CLICKED(IDC_EDITPICKMODESWITCHFIRST, &CEditPage::OnBnClickedEditpickmodeswitchfirst)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditPage message handlers

BOOL CEditPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	m_EditMoveVertexStep.Format("%.2f", at3dData->editMoveVertexStep);

	m_EditRotateXAngle.Format("%.2f", at3dData->editRotateXAngle);
	m_EditRotateYAngle.Format("%.2f", at3dData->editRotateYAngle);
	m_EditRotateZAngle.Format("%.2f", at3dData->editRotateZAngle);
	m_EditRotateStepAngle.Format("%.2f", at3dData->editRotateStepAngle);

	m_EditScaleXFactor.Format("%.2f", at3dData->editScaleXFactor);
	m_EditScaleYFactor.Format("%.2f", at3dData->editScaleYFactor);
	m_EditScaleZFactor.Format("%.2f", at3dData->editScaleZFactor);
	m_EditScaleStepFactor.Format("%.2f", at3dData->editScaleStepFactor);

	m_EditGridSize.Format("%.2f", at3dData->editGridSize);

	m_EditSnapKeepRelative = (at3dData->editSnapKeepRelativeFlag) ? 1 : 0;

  At3d_WriteFlag(LIBFLAG_SNAP_KEEP_RELATIVE, at3dData->editSnapKeepRelativeFlag);

	m_EditAxisGroup = 0;

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEditPage::OnStarteditvertices() 
{
	int result = At3d_Start_Edit_Vertices();

	if (result)
  {
    // first layer in list is selected first for edit vertices mode
    //
    at3dData->editNextLayer = At3d_GetNextLayer(0, at3dData->editName);
    m_EditName = at3dData->editName;
		UpdateData(FALSE);
  }
}

void CEditPage::OnStopeditvertices() 
{
	At3d_Stop_Edit_Vertices();
	m_EditName = "";
	UpdateData(FALSE);
}

void CEditPage::OnEditextrudestart() 
{
	__int32 result = At3d_Extrude_Mouse();

  if (result)
  {
    DisplayPickVertexMode();

    at3dData->extrudeModeFlag = 1;

    // first layer in list is selected first for edit vertices mode
    //
    at3dData->editNextLayer = At3d_GetNextLayer(0, at3dData->editName);
    m_EditName = at3dData->editName;

    if (at3dData->bevelSetsFlag) At3d_Edit_Select_Bevel_Set(at3dData->editName);

    DisplayExtrudeBevelFlags();

		UpdateData(FALSE);
  }
}

void CEditPage::DisplayExtrudeBevelFlags()
{
	int flag = At3d_Edit_Get_Extrude_Flag(EDIT_FLAG_UPPER_FACES);
  if (flag > -1)
  {
    m_EditUpperFaces = (flag) ? 1 : 0;
  }

  flag = At3d_Edit_Get_Extrude_Flag(EDIT_FLAG_UPPER_BEVELS);
  if (flag > -1)
  {
    m_EditUpperBevels = (flag) ? 1 : 0;
  }

  flag = At3d_Edit_Get_Extrude_Flag(EDIT_FLAG_LOWER_FACES);
  if (flag > -1)
  {
    m_EditLowerFaces = (flag) ? 1 : 0;
  }

  flag = At3d_Edit_Get_Extrude_Flag(EDIT_FLAG_LOWER_BEVELS);
  if (flag > -1)
  {
    m_EditLowerBevels = (flag) ? 1 : 0;
  }

	flag = At3d_Edit_Get_Divide_Flag();
  if (flag > -1)
  {
    m_EditDivide = (flag) ? 1 : 0;
  }

	UpdateData(FALSE);
}

void CEditPage::OnEditextrudenow() 
{
	At3d_Edit_Extrude_Now();

	m_EditDisplayGrid = 0;
  m_EditSnapToGrid = 0;

	UpdateData(FALSE);
}

void CEditPage::OnEditdragbox() 
{
	At3d_Edit_Drag_Box();
}

void CEditPage::OnEditpickvertex() 
{
	At3d_Edit_Pick_Vertex();
	DisplayPickVertexMode();
}

void CEditPage::OnEditpickmodefirst() 
{
	At3d_Edit_Set_Pick_Mode(EDIT_PICK_VERTEX_FIRST);
	DisplayPickVertexMode();
}

void CEditPage::OnEditpickmodeconnected() 
{
	At3d_Edit_Set_Pick_Mode(EDIT_PICK_VERTEX_CONNECTED);
	DisplayPickVertexMode();
}

void CEditPage::OnEditpickmodeanywhere() 
{
	At3d_Edit_Set_Pick_Mode(EDIT_PICK_VERTEX_ANYWHERE);
	DisplayPickVertexMode();
}

void CEditPage::OnPickmodeerase() 
{
	At3d_Edit_Set_Pick_Mode(EDIT_PICK_VERTEX_ERASE);
	DisplayPickVertexMode();
}

void CEditPage::OnEditpickmodedeleteall() 
{
	At3d_Edit_Set_Pick_Mode(EDIT_PICK_VERTEX_DELETE_ALL);
	DisplayPickVertexMode();
}

void CEditPage::DisplayPickVertexMode(void)
{
	__int32 flag = At3d_Edit_Get_Pick_Mode();

  char* ptr;
  switch(flag)
  {
    case EDIT_PICK_VERTEX_FIRST:
      ptr = "Pick Vertex: First";
      break;

    case EDIT_PICK_VERTEX_CONNECTED:
      ptr = "Pick Vertex: Connected";
      break;

    case EDIT_PICK_VERTEX_ANYWHERE:
      ptr = "Pick Vertex: Anywhere";
      break;

    case EDIT_PICK_VERTEX_ERASE:
      ptr = "Pick Vertex: Erase";
      break;

    case EDIT_PICK_VERTEX_DELETE_ALL:
      ptr = "Pick Vertex: Clear All";
      break;

    case EDIT_PICK_VERTEX_SWITCH_FIRST:
      ptr = "Pick Vertex: Switch First";
      break;

    default:
      ptr = "Pick Vertex: Unknown";
      break;
  }

  m_EditPickModeLabel.Format(ptr);

	UpdateData(FALSE);
}

void CEditPage::OnEditpickallvertices() 
{
	At3d_Edit_Pick_All_Vertices();
}

void CEditPage::OnEditdragvertex() 
{
	At3d_Edit_Drag_Vertex();
}

void CEditPage::OnEditpickedge() 
{
	At3d_Edit_Pick_Edge();
}

void CEditPage::OnEditnewedge() 
{
	At3d_Edit_New_Edge();
}

void CEditPage::OnEditdeletevertex() 
{
	At3d_Edit_Delete_Vertex();
}

void CEditPage::OnEditdivideedge() 
{
	At3d_Edit_Divide_Edge();
}

void CEditPage::OnEditflipx() 
{
	At3d_Edit_Mirror_Image_Flip_X();
}

void CEditPage::OnEditflipy() 
{
	At3d_Edit_Mirror_Image_Flip_Y();
}

void CEditPage::OnEditflipz() 
{
	At3d_Edit_Mirror_Image_Flip_Z(); 
}

void CEditPage::OnEditmovebevelzero() 
{
	At3d_Edit_Move_Bevel_Zero();
}

void CEditPage::OnEditswitch() 
{
	At3d_Edit_Switch_Bevels_Outlines();
}

void CEditPage::OnEditopenoutline() 
{
	At3d_Edit_Open_Outline();  
}

void CEditPage::OnEditcloseoutline() 
{
	At3d_Edit_Close_Outline();
}

void CEditPage::OnEditpicksolid() 
{
	At3d_Edit_Pick_Solid_Wire(0);
}

void CEditPage::OnEditpickwire() 
{
	At3d_Edit_Pick_Solid_Wire(1);
}

void CEditPage::OnEditothersolid() 
{
	At3d_Edit_Other_Solid_Wire(0);
}

void CEditPage::OnEditotherwire() 
{
	At3d_Edit_Other_Solid_Wire(1);
}

void CEditPage::OnEditrotategroup() 
{
	At3d_Edit_Rotate_Group();
	OnGeteditrotateangles();
}

void CEditPage::OnGeteditrotateangles() 
{
	At3d_Edit_GetRotateAngles(&at3dData->editRotateXAngle,
                            &at3dData->editRotateYAngle,
                            &at3dData->editRotateZAngle);

	m_EditRotateXAngle.Format("%.2f", at3dData->editRotateXAngle);
	m_EditRotateYAngle.Format("%.2f", at3dData->editRotateYAngle);
	m_EditRotateZAngle.Format("%.2f", at3dData->editRotateZAngle);

	UpdateData(FALSE);
}

void CEditPage::OnSeteditrotateangles() 
{
	UpdateData(TRUE);
	at3dData->editRotateXAngle = atof(m_EditRotateXAngle);
	at3dData->editRotateYAngle = atof(m_EditRotateYAngle);
	at3dData->editRotateZAngle = atof(m_EditRotateZAngle);

	At3d_Edit_SetRotateAngles(0, at3dData->editRotateXAngle,
                               at3dData->editRotateYAngle,
                               at3dData->editRotateZAngle);

	OnGeteditrotateangles();
}

void CEditPage::GetEditRotateStepAngle(void)
{
	UpdateData(TRUE);
	at3dData->editRotateStepAngle = atof(m_EditRotateStepAngle);
}

void CEditPage::OnSeteditrotatexangle1() 
{
	GetEditRotateStepAngle();
  At3d_Edit_SetRotateAngles(1, -at3dData->editRotateStepAngle, 0.0, 0.0);
	OnGeteditrotateangles();
}

void CEditPage::OnSeteditrotatexangle2() 
{
	GetEditRotateStepAngle();
  At3d_Edit_SetRotateAngles(1, at3dData->editRotateStepAngle, 0.0, 0.0);
	OnGeteditrotateangles();
}

void CEditPage::OnSeteditrotateyangle1() 
{
	GetEditRotateStepAngle();
  At3d_Edit_SetRotateAngles(1, 0.0, -at3dData->editRotateStepAngle, 0.0);
	OnGeteditrotateangles();
}

void CEditPage::OnSeteditrotateyangle2() 
{
	GetEditRotateStepAngle();
  At3d_Edit_SetRotateAngles(1, 0.0, at3dData->editRotateStepAngle, 0.0);
	OnGeteditrotateangles();
}

void CEditPage::OnSeteditrotatezangle1() 
{
	GetEditRotateStepAngle();
  At3d_Edit_SetRotateAngles(1, 0.0, 0.0, -at3dData->editRotateStepAngle);
	OnGeteditrotateangles();
}

void CEditPage::OnSeteditrotatezangle2() 
{
	GetEditRotateStepAngle();
  At3d_Edit_SetRotateAngles(1, 0.0, 0.0, at3dData->editRotateStepAngle);
	OnGeteditrotateangles();
}

void CEditPage::OnEditrotateokay() 
{
	At3d_Edit_Rotate_Okay();
}

void CEditPage::OnEditrotatecancel() 
{
	At3d_Edit_Rotate_Cancel();
}

void CEditPage::OnEditscalegroup() 
{
	At3d_Edit_Scale_Group();
	OnGeteditscalefactors();
}

void CEditPage::OnGeteditscalefactors() 
{
	At3d_Edit_GetScaleFactors(&at3dData->editScaleXFactor,
                            &at3dData->editScaleYFactor,
                            &at3dData->editScaleZFactor);

	m_EditScaleXFactor.Format("%.2f", at3dData->editScaleXFactor);
	m_EditScaleYFactor.Format("%.2f", at3dData->editScaleYFactor);
	m_EditScaleZFactor.Format("%.2f", at3dData->editScaleZFactor);

	UpdateData(FALSE);
}

void CEditPage::OnSeteditscalefactors() 
{
	UpdateData(TRUE);
	at3dData->editScaleXFactor = atof(m_EditScaleXFactor);
	at3dData->editScaleYFactor = atof(m_EditScaleYFactor);
	at3dData->editScaleZFactor = atof(m_EditScaleZFactor);

	At3d_Edit_SetScaleFactors(0, at3dData->editScaleXFactor,
                               at3dData->editScaleYFactor,
                               at3dData->editScaleZFactor);

	OnGeteditscalefactors();
}

void CEditPage::GetEditScaleStepFactor(void)
{
	UpdateData(TRUE);
	at3dData->editScaleStepFactor = atof(m_EditScaleStepFactor);
}

void CEditPage::OnSeteditscalexfactor1() 
{
	GetEditScaleStepFactor();
  At3d_Edit_SetScaleFactors(1, -at3dData->editScaleStepFactor, 0.0, 0.0);
	OnGeteditscalefactors();
}

void CEditPage::OnSeteditscalexfactor2() 
{
	GetEditScaleStepFactor();
  At3d_Edit_SetScaleFactors(1, at3dData->editScaleStepFactor, 0.0, 0.0);
	OnGeteditscalefactors();
}

void CEditPage::OnSeteditscaleyfactor1() 
{
	GetEditScaleStepFactor();
  At3d_Edit_SetScaleFactors(1, 0.0, -at3dData->editScaleStepFactor, 0.0);
	OnGeteditscalefactors();
}

void CEditPage::OnSeteditscaleyfactor2() 
{
	GetEditScaleStepFactor();
  At3d_Edit_SetScaleFactors(1, 0.0, at3dData->editScaleStepFactor, 0.0);
	OnGeteditscalefactors();
}

void CEditPage::OnSeteditscalezfactor1() 
{
	GetEditScaleStepFactor();
  At3d_Edit_SetScaleFactors(1, 0.0, 0.0, -at3dData->editScaleStepFactor);
	OnGeteditscalefactors();
}

void CEditPage::OnSeteditscalezfactor2() 
{
	GetEditScaleStepFactor();
  At3d_Edit_SetScaleFactors(1, 0.0, 0.0, at3dData->editScaleStepFactor);
	OnGeteditscalefactors();
}

void CEditPage::OnSeteditscalexyzfactor1() 
{
	GetEditScaleStepFactor();
  At3d_Edit_SetScaleFactors(1, -at3dData->editScaleStepFactor,
                               -at3dData->editScaleStepFactor,
                               -at3dData->editScaleStepFactor);
	OnGeteditscalefactors();
}

void CEditPage::OnSeteditscalexyzfactor2() 
{
	GetEditScaleStepFactor();
  At3d_Edit_SetScaleFactors(1, at3dData->editScaleStepFactor,
                               at3dData->editScaleStepFactor,
                               at3dData->editScaleStepFactor);
	OnGeteditscalefactors();
}

void CEditPage::OnEditscaleokay() 
{
	At3d_Edit_Scale_Okay();
}

void CEditPage::OnEditscalecancel() 
{
	At3d_Edit_Scale_Cancel();
}

void CEditPage::OnEditreducevertices() 
{
	At3d_Edit_Reduce_Vertices();
}

void CEditPage::OnEditpickghost() 
{
	At3d_Edit_Pick_Ghost_Outline();
}

void CEditPage::OnEditghostokay() 
{
	At3d_Edit_Pick_Ghost_Okay();
}

void CEditPage::OnEditghostcancel() 
{
	At3d_Edit_Pick_Ghost_Cancel();
}

void CEditPage::OnEditghoston() 
{
	At3d_Edit_Use_Ghost_Outline(1);
}

void CEditPage::OnEditghostoff() 
{
	At3d_Edit_Use_Ghost_Outline(0);
}

void CEditPage::OnEditlocalaxis() 
{
	m_EditAxisGroup = 0;
	At3d_Edit_Local_World_Axis_Switch(0);
}

void CEditPage::OnEditworldaxis() 
{
	m_EditAxisGroup = 1;
	At3d_Edit_Local_World_Axis_Switch(1);
}

void CEditPage::OnEditvertexsnapstart() 
{
	At3d_Edit_Vertex_Snap();
}

void CEditPage::OnEditvertexsnapshowall() 
{
	At3d_Edit_Snap_Show_Other();
}

void CEditPage::OnEditvertexsnapokay() 
{
	At3d_Edit_Snap_Okay();
}

void CEditPage::OnEditvertexsnapcancel() 
{
	At3d_Edit_Snap_Cancel();
}

void CEditPage::OnEditupperfaces() 
{
	UpdateData(TRUE);
	int flag = (m_EditUpperFaces) ? 1 : 0;
  At3d_Edit_Set_Extrude_Flag(EDIT_FLAG_UPPER_FACES, flag);
}

void CEditPage::OnEditupperbevels() 
{
	UpdateData(TRUE);
	int flag = (m_EditUpperBevels) ? 1 : 0;
  At3d_Edit_Set_Extrude_Flag(EDIT_FLAG_UPPER_BEVELS, flag);
}

void CEditPage::OnEditlowerfaces() 
{
	UpdateData(TRUE);
	int flag = (m_EditLowerFaces) ? 1 : 0;
  At3d_Edit_Set_Extrude_Flag(EDIT_FLAG_LOWER_FACES, flag);
}

void CEditPage::OnEditlowerbevels() 
{
	UpdateData(TRUE);
	int flag = (m_EditLowerBevels) ? 1 : 0;
  At3d_Edit_Set_Extrude_Flag(EDIT_FLAG_LOWER_BEVELS, flag);
}

void CEditPage::OnEditswitchupper() 
{
	At3d_Edit_Upper_Lower_Switch(0);
}

void CEditPage::OnEditswitchlower() 
{
	At3d_Edit_Upper_Lower_Switch(1);
}

void CEditPage::OnEditdisplaygrid() 
{
	UpdateData(TRUE);
	__int32 flag = (m_EditDisplayGrid) ? 1 : 0;

  at3dData->editGridSize = atof(m_EditGridSize);  

  At3d_Edit_Display_Grid(flag, at3dData->editGridSize);
}

void CEditPage::OnEditsnaptogrid() 
{
	UpdateData(TRUE);
	__int32 flag = (m_EditSnapToGrid) ? 1 : 0;
  
  At3d_Edit_Snap_To_Grid(flag);
}

void CEditPage::OnEditundoselected() 
{
	At3d_Edit_Undo_Vertices_Selected();
}

void CEditPage::OnEditundolayer() 
{
	At3d_Edit_Undo_Vertices_Layer();
}

void CEditPage::OnEditundoalllayers() 
{
	At3d_Edit_Undo_Vertices_All_Layers(); 
}


void CEditPage::OnEditgetupper() 
{
	at3dData->EditGetUpperBevels();
}

void CEditPage::OnEditclearupper() 
{
	At3d_Edit_Clear_Bevels(EDIT_BEVELS_UPPER);
}

void CEditPage::OnEditsetupper() 
{
	at3dData->EditSetUpperBevels();
}

void CEditPage::OnEditgetlower() 
{
	at3dData->EditGetLowerBevels();
}

void CEditPage::OnEditclearlower() 
{
	At3d_Edit_Clear_Bevels(EDIT_BEVELS_LOWER);
}

void CEditPage::OnEditsetlower() 
{
	at3dData->EditSetLowerBevels();
}

void CEditPage::OnEditdivide() 
{
	UpdateData(TRUE);
	int flag = (m_EditDivide) ? 1 : 0;
  At3d_Edit_Set_Divide_Flag(flag);
}

void CEditPage::OnEditsnapkeeprelative() 
{
	UpdateData(TRUE);
	at3dData->editSnapKeepRelativeFlag = (m_EditSnapKeepRelative) ? 1 : 0;

  At3d_WriteFlag(LIBFLAG_SNAP_KEEP_RELATIVE, at3dData->editSnapKeepRelativeFlag);
}

void CEditPage::OnEditselectlayer() 
{
	// just select layers in order they are in list
  //
  at3dData->editNextLayer = At3d_GetNextLayer(at3dData->editNextLayer, at3dData->editName);
  void* result = At3d_Edit_Select_Layer(at3dData->editName);

  if (result)
  {
    m_EditName = at3dData->editName;
    DisplayPickVertexMode();

    if ((at3dData->extrudeModeFlag) && (at3dData->bevelSetsFlag))
    {
      At3d_Edit_Select_Bevel_Set(at3dData->editName);

      DisplayExtrudeBevelFlags();
    }

		UpdateData(FALSE);
  }
}

void CEditPage::OnGeteditmovevertex() 
{
	At3d_Edit_Get_Vertex(&at3dData->editMoveVertexX,
                       &at3dData->editMoveVertexY,
                       &at3dData->editMoveVertexZ);

  m_EditMoveVertexX.Format("%.3f", at3dData->editMoveVertexX);
  m_EditMoveVertexY.Format("%.3f", at3dData->editMoveVertexY);
  m_EditMoveVertexZ.Format("%.3f", at3dData->editMoveVertexZ);

	UpdateData(FALSE);
}

void CEditPage::OnSeteditmovevertex() 
{
	UpdateData(TRUE);
	at3dData->editMoveVertexX = atof(m_EditMoveVertexX);
  at3dData->editMoveVertexY = atof(m_EditMoveVertexY);
  at3dData->editMoveVertexZ = atof(m_EditMoveVertexZ);
  
  At3d_Edit_Set_Vertex(at3dData->editMoveVertexX,
                       at3dData->editMoveVertexY,
                       at3dData->editMoveVertexZ);

  OnGeteditmovevertex();
}

void CEditPage::GetEditMoveVertexStep(void)
{
	UpdateData(TRUE);
	at3dData->editMoveVertexStep = atof(m_EditMoveVertexStep);
}

void CEditPage::OnEditmovevertexx1() 
{
	GetEditMoveVertexStep();
  At3d_Edit_Move_Vertex(-at3dData->editMoveVertexStep, 0.0, 0.0);
  OnGeteditmovevertex();
}

void CEditPage::OnEditmovevertexx2() 
{
	GetEditMoveVertexStep();
  At3d_Edit_Move_Vertex(at3dData->editMoveVertexStep, 0.0, 0.0);
  OnGeteditmovevertex();
}

void CEditPage::OnEditmovevertexy1() 
{
	GetEditMoveVertexStep();
  At3d_Edit_Move_Vertex(0.0, -at3dData->editMoveVertexStep, 0.0);
  OnGeteditmovevertex();
}

void CEditPage::OnEditmovevertexy2() 
{
	GetEditMoveVertexStep();
  At3d_Edit_Move_Vertex(0.0, at3dData->editMoveVertexStep, 0.0);
  OnGeteditmovevertex();
}

void CEditPage::OnEditmovevertexz1() 
{
	GetEditMoveVertexStep();
  At3d_Edit_Move_Vertex(0.0, 0.0, -at3dData->editMoveVertexStep);
  OnGeteditmovevertex();
}

void CEditPage::OnEditmovevertexz2() 
{
	GetEditMoveVertexStep();
  At3d_Edit_Move_Vertex(0.0, 0.0, at3dData->editMoveVertexStep);
  OnGeteditmovevertex();
}

void CEditPage::OnEditmakebevelsets() 
{
	at3dData->bevelSetsFlag = At3d_Edit_Make_Bevel_Sets();

  // display layer names with first layer in list selected first
  //
  if (at3dData->bevelSetsFlag)
  {
    at3dData->editNextLayer = At3d_GetNextLayer(0, at3dData->editName);
    m_EditName = at3dData->editName;

    At3d_Edit_Select_Bevel_Set(at3dData->editName);

    DisplayExtrudeBevelFlags();

		UpdateData(FALSE);
	}
}

void CEditPage::OnBnClickedEditpickmodeswitchfirst()
{
  At3d_Edit_Set_Pick_Mode(EDIT_PICK_VERTEX_SWITCH_FIRST);
	DisplayPickVertexMode();
}
