// DemPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "DemPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDemPage property page

IMPLEMENT_DYNCREATE(CDemPage, CPropertyPage)

CDemPage::CDemPage() : CPropertyPage(CDemPage::IDD)
{
	//{{AFX_DATA_INIT(CDemPage)
	m_DemColumns = _T("");
	m_DemMaxHeight = _T("");
	m_DemMinHeight = _T("");
	m_DemRows = _T("");
	m_DemXSpacing = _T("");
	m_DemYSpacing = _T("");
	m_DemEast = _T("");
	m_DemHeight = _T("");
	m_DemNorth = _T("");
	m_DemBitsGroup = -1;
	//}}AFX_DATA_INIT
}

CDemPage::~CDemPage()
{
}

void CDemPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemPage)
	DDX_Control(pDX, IDC_DEMSCROLLY, m_DemScrollY);
	DDX_Control(pDX, IDC_DEMSCROLLX, m_DemScrollX);
	DDX_Control(pDX, IDC_DEMPANEL, m_DemPanel);
	DDX_Text(pDX, IDC_DEMCOLUMNS, m_DemColumns);
	DDX_Text(pDX, IDC_DEMMAXHEIGHT, m_DemMaxHeight);
	DDX_Text(pDX, IDC_DEMMINHEIGHT, m_DemMinHeight);
	DDX_Text(pDX, IDC_DEMROWS, m_DemRows);
	DDX_Text(pDX, IDC_DEMXSPACING, m_DemXSpacing);
	DDX_Text(pDX, IDC_DEMYSPACING, m_DemYSpacing);
	DDX_Text(pDX, IDC_DEMEAST, m_DemEast);
	DDX_Text(pDX, IDC_DEMHEIGHT, m_DemHeight);
	DDX_Text(pDX, IDC_DEMNORTH, m_DemNorth);
	DDX_Radio(pDX, IDC_DEMBITS8, m_DemBitsGroup);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDemPage, CPropertyPage)
	//{{AFX_MSG_MAP(CDemPage)
	ON_BN_CLICKED(IDC_GETDEMINFO, OnGetdeminfo)
	ON_WM_PAINT()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_MOUSEMOVE()
	ON_BN_CLICKED(IDC_DEMBITS8, OnDembits8)
	ON_BN_CLICKED(IDC_DEMBITS24, OnDembits24)
	ON_BN_CLICKED(IDC_DEMBITS32, OnDembits32)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemPage message handlers

void CDemPage::OnGetdeminfo() 
{
	int result = 0;

  if (At3d_GetDemSize(&at3dData->demColumns, &at3dData->demRows) == 1)
  {
    if (At3d_GetDemSpacing(&at3dData->demXSpacing, &at3dData->demYSpacing) == 1)
    {
      if (At3d_GetDemMinMax(&at3dData->demMinHeight, &at3dData->demMaxHeight) == 1)
      {
				RECT rect;
				m_DemPanel.GetClientRect(&rect);

        if (At3d_CreateDemBitmap(at3dData->demBitsPerPixel, rect.right, rect.bottom) == 1)
        {
          result = 1;
        }
      }
    }
  }

  if (result)
  {
    at3dData->demXOffset = 0;
    at3dData->demYOffset = 0;

		m_DemColumns.Format("%d", at3dData->demColumns);
		m_DemRows.Format("%d", at3dData->demRows);

		m_DemXSpacing.Format("%.2f", at3dData->demXSpacing);
		m_DemYSpacing.Format("%.2f", at3dData->demYSpacing);

		m_DemMinHeight.Format("%.2f", at3dData->demMinHeight);

		m_DemMaxHeight.Format("%.2f", at3dData->demMaxHeight);

		UpdateData(FALSE);

		SCROLLINFO si;

		si.cbSize = sizeof(si); 
    si.fMask  = SIF_RANGE | SIF_POS; 
    si.nMin   = 0; 
    si.nMax   = at3dData->demColumns; 
    si.nPage  = 1; 
    si.nPos   = 1; 
		m_DemScrollX.SetScrollInfo(&si,1);

		si.cbSize = sizeof(si); 
    si.fMask  = SIF_RANGE | SIF_POS; 
    si.nMin   = 0; 
    si.nMax   = at3dData->demRows; 
    si.nPage  = 1; 
    si.nPos   = 1; 
		m_DemScrollY.SetScrollInfo(&si,1);

    GetDemClip();
  }
}

void CDemPage::GetDemClip()
{
	RECT rect;
	m_DemPanel.GetClientRect(&rect);

	At3d_GetDemClip(m_DemPanel.GetSafeHwnd(),
                  at3dData->demXOffset, at3dData->demYOffset);
}

void CDemPage::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Do not call CPropertyPage::OnPaint() for painting messages
	
}

void CDemPage::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if (pScrollBar == &m_DemScrollX) 
	{
		switch (nSBCode) 
		{ 
			// User clicked the shaft left of the scroll box.  
			//
			case SB_PAGEUP:
				at3dData->demXOffset--;
				break; 
 
			// User clicked the shaft right of the scroll box.  
			//
			case SB_PAGEDOWN: 
				at3dData->demXOffset++; 
				break; 
 
			// User clicked the left arrow.  
			//
			case SB_LINEUP: 
				at3dData->demXOffset--; 
				break; 
 
			// User clicked the right arrow.  
			//
			case SB_LINEDOWN: 
				at3dData->demXOffset++; 
				break; 
 
			// User dragged the scroll box.  
			// 
			case SB_THUMBPOSITION: 
				at3dData->demXOffset = nPos; 
				break; 
		} 

		if (at3dData->demXOffset < 0) at3dData->demXOffset = 0;
		if (at3dData->demXOffset > at3dData->demColumns) at3dData->demXOffset = at3dData->demColumns;

		pScrollBar->SetScrollPos(at3dData->demXOffset);

		GetDemClip();
	}

	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDemPage::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if (pScrollBar == &m_DemScrollY) 
	{
		switch (nSBCode) 
		{ 
			// User clicked the shaft left of the scroll box.  
			//
			case SB_PAGEUP:
				at3dData->demYOffset--;
				break; 
 
			// User clicked the shaft right of the scroll box.  
			//
			case SB_PAGEDOWN: 
				at3dData->demYOffset++; 
				break; 
 
			// User clicked the left arrow.  
			//
			case SB_LINEUP: 
			at3dData->demYOffset--; 
      break; 
 
			// User clicked the right arrow.  
			//
			case SB_LINEDOWN: 
				at3dData->demYOffset++; 
				break; 
 
			// User dragged the scroll box.  
			// 
			case SB_THUMBPOSITION: 
				at3dData->demYOffset = nPos; 
				break; 
		} 

		if (at3dData->demYOffset < 0) at3dData->demYOffset = 0;
		if (at3dData->demYOffset > at3dData->demRows) at3dData->demYOffset = at3dData->demRows;

		pScrollBar->SetScrollPos(at3dData->demYOffset);

		GetDemClip();
	}

	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDemPage::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	//
	int x = point.x;
	int y = point.y;

	RECT rect;
	m_DemPanel.GetWindowRect(&rect);
	CDemPage::ScreenToClient(&rect);
	if ((x >= rect.left) && (x <= rect.right) &&
		  (y >= rect.top) && (y <= rect.bottom))
	{
		if (!at3dData->fileLoaded)
		{
			m_DemEast = _T("");
			m_DemHeight = _T("");
			m_DemNorth = _T("");
		}
		else
		{
			x -= rect.left;
			y -= rect.top;

			int demX = x + at3dData->demXOffset;

			int demY = at3dData->demRows - 1 - y - at3dData->demYOffset;

			m_DemEast.Format("%.1f", demX * at3dData->demXSpacing);

			m_DemNorth.Format("%.1f", demY * at3dData->demYSpacing);

			float height;

			if (At3d_GetDemHeight(demX, demY, &height) == 1)
			{
				
				m_DemHeight.Format("%.1f", height);
			}
			else
			{
				m_DemHeight = _T("NoData");
			}
		}

		UpdateData(FALSE);
	}

	CPropertyPage::OnMouseMove(nFlags, point);
}

BOOL CDemPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	//
	if (at3dData->demBitsPerPixel == 8)
	{
		m_DemBitsGroup = 0;
	} 
	else if (at3dData->demBitsPerPixel == 24)
	{
		m_DemBitsGroup = 1;
	}
	else
	{
		m_DemBitsGroup = 2;
	}

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDemPage::OnDembits8() 
{
	m_DemBitsGroup = 0;
	at3dData->demBitsPerPixel = 8;
}

void CDemPage::OnDembits24() 
{
	m_DemBitsGroup = 1;
	at3dData->demBitsPerPixel = 24;
}

void CDemPage::OnDembits32() 
{
	m_DemBitsGroup = 2;
	at3dData->demBitsPerPixel = 32;
}
