// DefaultPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "DefaultPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDefaultPage property page

IMPLEMENT_DYNCREATE(CDefaultPage, CPropertyPage)

CDefaultPage::CDefaultPage() : CPropertyPage(CDefaultPage::IDD)
{
	//{{AFX_DATA_INIT(CDefaultPage)
	m_Ambient1 = _T("");
	m_AmbientBlue = _T("");
	m_AmbientGreen = _T("");
	m_AmbientRed = _T("");
	m_CreaseAngle = _T("");
	m_Diffuse1 = _T("");
	m_DiffuseBlue = _T("");
	m_DiffuseGreen = _T("");
	m_DiffuseRed = _T("");
	m_DoubleSided = _T("");
	m_DxfColor = _T("");
	m_EmissiveBlue = _T("");
	m_EmissiveGreen = _T("");
	m_EmissiveRed = _T("");
	m_IndexRefraction = _T("");
	m_Roughness = _T("");
	m_RwxGeometrySampling = _T("");
	m_RwxLightSampling = _T("");
	m_RwxTag = _T("");
	m_RwxTextureModes = _T("");
	m_Shininess = _T("");
	m_Specular1 = _T("");
	m_SpecularBlue = _T("");
	m_SpecularGreen = _T("");
	m_SpecularRed = _T("");
	m_Transparency1 = _T("");
	m_TransparencyBlue = _T("");
	m_TransparencyGreen = _T("");
	m_TransparencyRed = _T("");
	m_ColorRed = _T("");
	m_ColorGreen = _T("");
	m_ColorBlue = _T("");
	m_OglGlobalAmbientRed = _T("");
	m_OglGlobalAmbientGreen = _T("");
	m_OglGlobalAmbientBlue = _T("");
	m_OglGlobalAmbientAlpha = _T("");
	m_OglLightAmbientRed = _T("");
	m_OglLightAmbientGreen = _T("");
	m_OglLightAmbientBlue = _T("");
	m_OglLightAmbientAlpha = _T("");
	m_OglLightDiffuseRed = _T("");
	m_OglLightDiffuseGreen = _T("");
	m_OglLightDiffuseBlue = _T("");
	m_OglLightDiffuseAlpha = _T("");
	m_OglLightEnabled = FALSE;
	m_OglLightPositionX = _T("");
	m_OglLightPositionY = _T("");
	m_OglLightPositionZ = _T("");
	m_OglLightSpecularRed = _T("");
	m_OglLightSpecularGreen = _T("");
	m_OglLightSpecularBlue = _T("");
	m_OglLightSpecularAlpha = _T("");
	m_OglLight_Group = -1;
	//}}AFX_DATA_INIT
}

CDefaultPage::~CDefaultPage()
{
}

void CDefaultPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDefaultPage)
	DDX_Text(pDX, IDC_AMBIENT1, m_Ambient1);
	DDX_Text(pDX, IDC_AMBIENTBLUE, m_AmbientBlue);
	DDX_Text(pDX, IDC_AMBIENTGREEN, m_AmbientGreen);
	DDX_Text(pDX, IDC_AMBIENTRED, m_AmbientRed);
	DDX_Text(pDX, IDC_CREASEANGLE, m_CreaseAngle);
	DDX_Text(pDX, IDC_DIFFUSE1, m_Diffuse1);
	DDX_Text(pDX, IDC_DIFFUSEBLUE, m_DiffuseBlue);
	DDX_Text(pDX, IDC_DIFFUSEGREEN, m_DiffuseGreen);
	DDX_Text(pDX, IDC_DIFFUSERED, m_DiffuseRed);
	DDX_Text(pDX, IDC_DOUBLESIDED, m_DoubleSided);
	DDX_Text(pDX, IDC_DXFCOLOR, m_DxfColor);
	DDX_Text(pDX, IDC_EMISSIVEBLUE, m_EmissiveBlue);
	DDX_Text(pDX, IDC_EMISSIVEGREEN, m_EmissiveGreen);
	DDX_Text(pDX, IDC_EMISSIVERED, m_EmissiveRed);
	DDX_Text(pDX, IDC_INDEXREFRACTION, m_IndexRefraction);
	DDX_Text(pDX, IDC_ROUGHNESS, m_Roughness);
	DDX_Text(pDX, IDC_RWXGEOMETRYSAMPLING, m_RwxGeometrySampling);
	DDX_Text(pDX, IDC_RWXLIGHTSAMPLING, m_RwxLightSampling);
	DDX_Text(pDX, IDC_RWXTAG, m_RwxTag);
	DDX_Text(pDX, IDC_RWXTEXTUREMODES, m_RwxTextureModes);
	DDX_Text(pDX, IDC_SHININESS, m_Shininess);
	DDX_Text(pDX, IDC_SPECULAR1, m_Specular1);
	DDX_Text(pDX, IDC_SPECULARBLUE, m_SpecularBlue);
	DDX_Text(pDX, IDC_SPECULARGREEN, m_SpecularGreen);
	DDX_Text(pDX, IDC_SPECULARRED, m_SpecularRed);
	DDX_Text(pDX, IDC_TRANSPARENCY1, m_Transparency1);
	DDX_Text(pDX, IDC_TRANSPARENCYBLUE, m_TransparencyBlue);
	DDX_Text(pDX, IDC_TRANSPARENCYGREEN, m_TransparencyGreen);
	DDX_Text(pDX, IDC_TRANSPARENCYRED, m_TransparencyRed);
	DDX_Text(pDX, IDC_COLORRED, m_ColorRed);
	DDX_Text(pDX, IDC_COLORGREEN, m_ColorGreen);
	DDX_Text(pDX, IDC_COLORBLUE, m_ColorBlue);
	DDX_Text(pDX, IDC_OGLGLOBALAMBIENTRED, m_OglGlobalAmbientRed);
	DDX_Text(pDX, IDC_OGLGLOBALAMBIENTGREEN, m_OglGlobalAmbientGreen);
	DDX_Text(pDX, IDC_OGLGLOBALAMBIENTBLUE, m_OglGlobalAmbientBlue);
	DDX_Text(pDX, IDC_OGLGLOBALAMBIENTALPHA, m_OglGlobalAmbientAlpha);
	DDX_Text(pDX, IDC_OGLLIGHTAMBIENTRED, m_OglLightAmbientRed);
	DDX_Text(pDX, IDC_OGLLIGHTAMBIENTGREEN, m_OglLightAmbientGreen);
	DDX_Text(pDX, IDC_OGLLIGHTAMBIENTBLUE, m_OglLightAmbientBlue);
	DDX_Text(pDX, IDC_OGLLIGHTAMBIENTALPHA, m_OglLightAmbientAlpha);
	DDX_Text(pDX, IDC_OGLLIGHTDIFFUSERED, m_OglLightDiffuseRed);
	DDX_Text(pDX, IDC_OGLLIGHTDIFFUSEGREEN, m_OglLightDiffuseGreen);
	DDX_Text(pDX, IDC_OGLLIGHTDIFFUSEBLUE, m_OglLightDiffuseBlue);
	DDX_Text(pDX, IDC_OGLLIGHTDIFFUSEALPHA, m_OglLightDiffuseAlpha);
	DDX_Check(pDX, IDC_OGLLIGHTENABLED, m_OglLightEnabled);
	DDX_Text(pDX, IDC_OGLLIGHTPOSITIONX, m_OglLightPositionX);
	DDX_Text(pDX, IDC_OGLLIGHTPOSITIONY, m_OglLightPositionY);
	DDX_Text(pDX, IDC_OGLLIGHTPOSITIONZ, m_OglLightPositionZ);
	DDX_Text(pDX, IDC_OGLLIGHTSPECULARRED, m_OglLightSpecularRed);
	DDX_Text(pDX, IDC_OGLLIGHTSPECULARGREEN, m_OglLightSpecularGreen);
	DDX_Text(pDX, IDC_OGLLIGHTSPECULARBLUE, m_OglLightSpecularBlue);
	DDX_Text(pDX, IDC_OGLLIGHTSPECULARALPHA, m_OglLightSpecularAlpha);
	DDX_Radio(pDX, IDC_OGLLIGHT0, m_OglLight_Group);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDefaultPage, CPropertyPage)
	//{{AFX_MSG_MAP(CDefaultPage)
	ON_BN_CLICKED(IDC_GETDEFAULTMATERIALS, OnGetdefaultmaterials)
	ON_BN_CLICKED(IDC_CLEAREDITBOXES, OnCleareditboxes)
	ON_BN_CLICKED(IDC_GETOGLGLOBALAMBIENT, OnGetoglglobalambient)
	ON_BN_CLICKED(IDC_SETOGLGLOBALAMBIENT, OnSetoglglobalambient)
	ON_BN_CLICKED(IDC_OGLLIGHT0, OnOgllight0)
	ON_BN_CLICKED(IDC_OGLLIGHT1, OnOgllight1)
	ON_BN_CLICKED(IDC_OGLLIGHT2, OnOgllight2)
	ON_BN_CLICKED(IDC_OGLLIGHT3, OnOgllight3)
	ON_BN_CLICKED(IDC_OGLLIGHT4, OnOgllight4)
	ON_BN_CLICKED(IDC_OGLLIGHT5, OnOgllight5)
	ON_BN_CLICKED(IDC_OGLLIGHT6, OnOgllight6)
	ON_BN_CLICKED(IDC_OGLLIGHT7, OnOgllight7)
	ON_BN_CLICKED(IDC_SETOGLLIGHT, OnSetogllight)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDefaultPage message handlers

BOOL CDefaultPage::OnInitDialog()
{
  CPropertyPage::OnInitDialog();

  // TODO: Add extra initialization here

  m_OglLight_Group = at3dData->oglSelectedLight;
  GetOglLight();

  UpdateData(FALSE);

  return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDefaultPage::OnGetdefaultmaterials() 
{
	at3dData->GetDefaultMaterials();

	m_Ambient1.Format("%.3f", at3dData->defaultAmbient1);
  m_AmbientRed.Format("%.3f", at3dData->defaultAmbientRGB.red);
  m_AmbientGreen.Format("%.3f", at3dData->defaultAmbientRGB.green);
  m_AmbientBlue.Format("%.3f", at3dData->defaultAmbientRGB.blue);
  
	m_ColorRed.Format("%.3f", at3dData->defaultColorRGB.red);
  m_ColorGreen.Format("%.3f", at3dData->defaultColorRGB.green);
  m_ColorBlue.Format("%.3f", at3dData->defaultColorRGB.blue);

  m_Diffuse1.Format("%.3f", at3dData->defaultDiffuse1);
  m_DiffuseRed.Format("%.3f", at3dData->defaultDiffuseRGB.red);
  m_DiffuseGreen.Format("%.3f", at3dData->defaultDiffuseRGB.green);
  m_DiffuseBlue.Format("%.3f", at3dData->defaultDiffuseRGB.blue);
  
  m_Specular1.Format("%.3f", at3dData->defaultSpecular1);
  m_SpecularRed.Format("%.3f", at3dData->defaultSpecularRGB.red);
  m_SpecularGreen.Format("%.3f", at3dData->defaultSpecularRGB.green);
  m_SpecularBlue.Format("%.3f", at3dData->defaultSpecularRGB.blue);
  
  m_EmissiveRed.Format("%.3f", at3dData->defaultEmissiveRGB.red);
  m_EmissiveGreen.Format("%.3f", at3dData->defaultEmissiveRGB.green);
  m_EmissiveBlue.Format("%.3f", at3dData->defaultEmissiveRGB.blue);
  
  m_Roughness.Format("%.3f", at3dData->defaultRoughness);
  m_Shininess.Format("%.3f", at3dData->defaultShininess);
    
  m_Transparency1.Format("%.3f", at3dData->defaultTransparency1);
  m_TransparencyRed.Format("%.3f", at3dData->defaultTransparencyRGB.red);
  m_TransparencyGreen.Format("%.3f", at3dData->defaultTransparencyRGB.green);
  m_TransparencyBlue.Format("%.3f", at3dData->defaultTransparencyRGB.blue);
  
  m_IndexRefraction.Format("%.3f", at3dData->defaultIndexOfRefraction);
  m_CreaseAngle.Format("%.3f", at3dData->defaultCreaseAngle);

  
  m_DxfColor.Format("%d", at3dData->defaultDxfColor);
  m_DoubleSided.Format("%d", at3dData->defaultDoubleSided);
  m_RwxGeometrySampling.Format("%d", at3dData->defaultRwxGeometrySampling);
  m_RwxLightSampling.Format("%d", at3dData->defaultRwxLightSampling);
  m_RwxTextureModes.Format("%d", at3dData->defaultRwxTextureModes);
  m_RwxTag.Format("%d", at3dData->defaultRwxClumpTag);
  
	m_OglLight_Group = at3dData->oglSelectedLight;

	UpdateData(FALSE);
}

void CDefaultPage::OnCleareditboxes() 
{
	m_Ambient1 = _T("");
	m_AmbientBlue = _T("");
	m_AmbientGreen = _T("");
	m_AmbientRed = _T("");
	m_CreaseAngle = _T("");
	m_ColorBlue = _T("");
	m_ColorGreen = _T("");
	m_ColorRed = _T("");
	m_Diffuse1 = _T("");
	m_DiffuseBlue = _T("");
	m_DiffuseGreen = _T("");
	m_DiffuseRed = _T("");
	m_DoubleSided = _T("");
	m_DxfColor = _T("");
	m_EmissiveBlue = _T("");
	m_EmissiveGreen = _T("");
	m_EmissiveRed = _T("");
	m_IndexRefraction = _T("");
	m_Roughness = _T("");
	m_RwxGeometrySampling = _T("");
	m_RwxLightSampling = _T("");
	m_RwxTag = _T("");
	m_RwxTextureModes = _T("");
	m_Shininess = _T("");
	m_Specular1 = _T("");
	m_SpecularBlue = _T("");
	m_SpecularGreen = _T("");
	m_SpecularRed = _T("");
	m_Transparency1 = _T("");
	m_TransparencyBlue = _T("");
	m_TransparencyGreen = _T("");
	m_TransparencyRed = _T("");

	UpdateData(FALSE);
}

void CDefaultPage::OnGetoglglobalambient() 
{
	__int32 result = At3d_Get_OGL_Global_Ambient_Light(&at3dData->oglGlobalAmbient.red);

  if (result)
  { 
    m_OglGlobalAmbientRed.Format("%.3f", at3dData->oglGlobalAmbient.red);
    m_OglGlobalAmbientGreen.Format("%.3f", at3dData->oglGlobalAmbient.green);
    m_OglGlobalAmbientBlue.Format("%.3f", at3dData->oglGlobalAmbient.blue);
    m_OglGlobalAmbientAlpha.Format("%.3f", at3dData->oglGlobalAmbient.alpha);

		UpdateData(FALSE);
  }
}

void CDefaultPage::OnSetoglglobalambient() 
{
	UpdateData(TRUE);
	
	at3dData->oglGlobalAmbient.red   = (float)atof(m_OglGlobalAmbientRed);  
  at3dData->oglGlobalAmbient.green = (float)atof(m_OglGlobalAmbientGreen);  
  at3dData->oglGlobalAmbient.blue  = (float)atof(m_OglGlobalAmbientBlue);
  
  // DLL always sets Global Ambient Alpha to 1.0

  __int32 result = At3d_Set_OGL_Global_Ambient_Light(&at3dData->oglGlobalAmbient.red);

  // to update OpenGL light settings immediately do a redraw
  //
  if (result) At3d_DrawWireframe();
}

void CDefaultPage::OnOgllight0() 
{
	UpdateData(TRUE);
	at3dData->oglSelectedLight = 0;
  GetOglLight();
}

void CDefaultPage::OnOgllight1() 
{
	UpdateData(TRUE);
	at3dData->oglSelectedLight = 1;
  GetOglLight();
}

void CDefaultPage::OnOgllight2() 
{
	UpdateData(TRUE);
	at3dData->oglSelectedLight = 2;
  GetOglLight();
}

void CDefaultPage::OnOgllight3() 
{
	UpdateData(TRUE);
	at3dData->oglSelectedLight = 3;
  GetOglLight();
}

void CDefaultPage::OnOgllight4() 
{
	UpdateData(TRUE);
	at3dData->oglSelectedLight = 4;
  GetOglLight();
}

void CDefaultPage::OnOgllight5() 
{
	UpdateData(TRUE);
	at3dData->oglSelectedLight = 5;
  GetOglLight();
}

void CDefaultPage::OnOgllight6() 
{
	UpdateData(TRUE);
	at3dData->oglSelectedLight = 6;
  GetOglLight();
}

void CDefaultPage::OnOgllight7() 
{
	UpdateData(TRUE);
	at3dData->oglSelectedLight = 7;
  GetOglLight();
}

void CDefaultPage::GetOglLight(void)
{
  OGL_LIGHT* lightPtr = &at3dData->oglDirectionalLights[at3dData->oglSelectedLight];

  __int32 result = At3d_Get_OGL_Directional_Light(at3dData->oglSelectedLight,
                                                  &lightPtr->enabledFlag,
                                                  &lightPtr->ambient.red,
                                                  &lightPtr->diffuse.red,
                                                  &lightPtr->specular.red,
                                                  &lightPtr->position.x);

  if (result)
  {
    m_OglLightEnabled = (lightPtr->enabledFlag) ? 1 : 0;

    m_OglLightAmbientRed.Format("%.3f", lightPtr->ambient.red);
    m_OglLightAmbientGreen.Format("%.3f", lightPtr->ambient.green);
    m_OglLightAmbientBlue.Format("%.3f", lightPtr->ambient.blue);
    m_OglLightAmbientAlpha.Format("%.3f", lightPtr->ambient.alpha);

    m_OglLightDiffuseRed.Format("%.3f", lightPtr->diffuse.red);
    m_OglLightDiffuseGreen.Format("%.3f", lightPtr->diffuse.green);
    m_OglLightDiffuseBlue.Format("%.3f", lightPtr->diffuse.blue);
    m_OglLightDiffuseAlpha.Format("%.3f", lightPtr->diffuse.alpha);

    m_OglLightSpecularRed.Format("%.3f", lightPtr->specular.red);
    m_OglLightSpecularGreen.Format("%.3f", lightPtr->specular.green);
    m_OglLightSpecularBlue.Format("%.3f", lightPtr->specular.blue);
    m_OglLightSpecularAlpha.Format("%.3f", lightPtr->specular.alpha);

    m_OglLightPositionX.Format("%.3f", lightPtr->position.x);
    m_OglLightPositionY.Format("%.3f", lightPtr->position.y);
    m_OglLightPositionZ.Format("%.3f", lightPtr->position.z);

		UpdateData(FALSE);
  }
}

void CDefaultPage::OnSetogllight() 
{
	UpdateData(TRUE);

	OGL_LIGHT* lightPtr = &at3dData->oglDirectionalLights[at3dData->oglSelectedLight];

  lightPtr->enabledFlag = (m_OglLightEnabled) ? 1 : 0;

  lightPtr->ambient.red   = (float)atof(m_OglLightAmbientRed);
  lightPtr->ambient.green = (float)atof(m_OglLightAmbientGreen);  
  lightPtr->ambient.blue  = (float)atof(m_OglLightAmbientBlue);
  
  // DLL always sets Light Ambient Alpha to 1.0

  lightPtr->diffuse.red   = (float)atof(m_OglLightDiffuseRed);
  lightPtr->diffuse.green = (float)atof(m_OglLightDiffuseGreen);
  lightPtr->diffuse.blue  = (float)atof(m_OglLightDiffuseBlue);
  
  // DLL always sets Light Diffuse Alpha to 1.0

  lightPtr->specular.red   = (float)atof(m_OglLightSpecularRed);
  lightPtr->specular.green = (float)atof(m_OglLightSpecularGreen);
  lightPtr->specular.blue  = (float)atof(m_OglLightSpecularBlue);
  
  // DLL always sets Light Specular Alpha to 1.0

  lightPtr->position.x = (float)atof(m_OglLightPositionX);
  lightPtr->position.y = (float)atof(m_OglLightPositionY);
  lightPtr->position.z = (float)atof(m_OglLightPositionZ);
  
  __int32 result = At3d_Set_OGL_Directional_Light(at3dData->oglSelectedLight,
                                                 lightPtr->enabledFlag,
                                                 &lightPtr->ambient.red,
                                                 &lightPtr->diffuse.red,
                                                 &lightPtr->specular.red,
                                                 &lightPtr->position.x);

  // to update OpenGL light settings immediately do a redraw
  //
  if (result) At3d_DrawWireframe();
}
