// Convert1Page.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3dx_my_functions.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "Convert1Page.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConvert1Page property page

IMPLEMENT_DYNCREATE(CConvert1Page, CPropertyPage)

CConvert1Page::CConvert1Page() : CPropertyPage(CConvert1Page::IDD)
{
	//{{AFX_DATA_INIT(CConvert1Page)
	m_Convert1_AddBase = FALSE;
	m_Convert1_AddPointCloud = FALSE;
	m_Convert1_AddUV = FALSE;
	m_Convert1_BaseThickness = _T("");
	m_Convert1_DropElevation = _T("");
	m_Convert1_DropFaces = FALSE;
	m_Convert1_EditStretchX = _T("");
	m_Convert1_EditStretchY = _T("");
	m_Convert1_FlagStretchX = FALSE;
	m_Convert1_FlagStretchY = FALSE;
	m_Convert1_MaxX = _T("");
	m_Convert1_MaxY = _T("");
	m_Convert1_MaxZ = _T("");
	m_Convert1_MeshEdges = _T("");
	m_Convert1_MeshTriangles = _T("");
	m_Convert1_MeshVertices = _T("");
	m_Convert1_MinX = _T("");
	m_Convert1_MinY = _T("");
	m_Convert1_MinZ = _T("");
	m_Convert1_NewSizeX = _T("");
	m_Convert1_NewSizeY = _T("");
	m_Convert1_SizeX = _T("");
	m_Convert1_SizeY = _T("");
	m_Convert1_SizeZ = _T("");
	m_Convert1_VertCount = _T("");
	m_Convert1_XCount = _T("");
	m_Convert1_XSpacing = _T("");
	m_Convert1_YCount = _T("");
	m_Convert1_YSpacing = _T("");
	m_Convert1_ConvertGroup = -1;
	m_Convert1_WriteXYZ = FALSE;
	//}}AFX_DATA_INIT
}

CConvert1Page::~CConvert1Page()
{
}

void CConvert1Page::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConvert1Page)
	DDX_Check(pDX, IDC_CONVERT1_ADDBASE, m_Convert1_AddBase);
	DDX_Check(pDX, IDC_CONVERT1_ADDPOINTCLOUD, m_Convert1_AddPointCloud);
	DDX_Check(pDX, IDC_CONVERT1_ADDUV, m_Convert1_AddUV);
	DDX_Text(pDX, IDC_CONVERT1_BASETHICKNESS, m_Convert1_BaseThickness);
	DDX_Text(pDX, IDC_CONVERT1_DROPELEVATION, m_Convert1_DropElevation);
	DDX_Check(pDX, IDC_CONVERT1_DROPFACES, m_Convert1_DropFaces);
	DDX_Text(pDX, IDC_CONVERT1_EDITSTRETCHX, m_Convert1_EditStretchX);
	DDX_Text(pDX, IDC_CONVERT1_EDITSTRETCHY, m_Convert1_EditStretchY);
	DDX_Check(pDX, IDC_CONVERT1_FLAGSTRETCHX, m_Convert1_FlagStretchX);
	DDX_Check(pDX, IDC_CONVERT1_FLAGSTRETCHY, m_Convert1_FlagStretchY);
	DDX_Text(pDX, IDC_CONVERT1_MAXX, m_Convert1_MaxX);
	DDX_Text(pDX, IDC_CONVERT1_MAXY, m_Convert1_MaxY);
	DDX_Text(pDX, IDC_CONVERT1_MAXZ, m_Convert1_MaxZ);
	DDX_Text(pDX, IDC_CONVERT1_MESHEDGES, m_Convert1_MeshEdges);
	DDX_Text(pDX, IDC_CONVERT1_MESHTRIANGLES, m_Convert1_MeshTriangles);
	DDX_Text(pDX, IDC_CONVERT1_MESHVERTICES, m_Convert1_MeshVertices);
	DDX_Text(pDX, IDC_CONVERT1_MINX, m_Convert1_MinX);
	DDX_Text(pDX, IDC_CONVERT1_MINY, m_Convert1_MinY);
	DDX_Text(pDX, IDC_CONVERT1_MINZ, m_Convert1_MinZ);
	DDX_Text(pDX, IDC_CONVERT1_NEWSIZEX, m_Convert1_NewSizeX);
	DDX_Text(pDX, IDC_CONVERT1_NEWSIZEY, m_Convert1_NewSizeY);
	DDX_Text(pDX, IDC_CONVERT1_SIZEX, m_Convert1_SizeX);
	DDX_Text(pDX, IDC_CONVERT1_SIZEY, m_Convert1_SizeY);
	DDX_Text(pDX, IDC_CONVERT1_SIZEZ, m_Convert1_SizeZ);
	DDX_Text(pDX, IDC_CONVERT1_VERTCOUNT, m_Convert1_VertCount);
	DDX_Text(pDX, IDC_CONVERT1_XCOUNT, m_Convert1_XCount);
	DDX_Text(pDX, IDC_CONVERT1_XSPACING, m_Convert1_XSpacing);
	DDX_Text(pDX, IDC_CONVERT1_YCOUNT, m_Convert1_YCount);
	DDX_Text(pDX, IDC_CONVERT1_YSPACING, m_Convert1_YSpacing);
	DDX_Radio(pDX, IDC_CONVERT1_KEEPORIGINAL, m_Convert1_ConvertGroup);
	DDX_Check(pDX, IDC_CONVERT1_WRITEXYZ, m_Convert1_WriteXYZ);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConvert1Page, CPropertyPage)
	//{{AFX_MSG_MAP(CConvert1Page)
	ON_BN_CLICKED(IDC_CONVERT1_GETSIZE, OnConvert1Getsize)
	ON_BN_CLICKED(IDC_CONVERT1_CALCULATE, OnConvert1Calculate)
	ON_BN_CLICKED(IDC_CONVERT1_FLAGSTRETCHX, OnConvert1Flagstretchx)
	ON_BN_CLICKED(IDC_CONVERT1_FLAGSTRETCHY, OnConvert1Flagstretchy)
	ON_BN_CLICKED(IDC_CONVERT1_KEEPORIGINAL, OnConvert1Keeporiginal)
	ON_BN_CLICKED(IDC_CONVERT1_LANDSCAPE, OnConvert1Landscape)
	ON_BN_CLICKED(IDC_CONVERT1_MESH, OnConvert1Mesh)
	ON_BN_CLICKED(IDC_CONVERT1_ADDPOINTCLOUD, OnConvert1Addpointcloud)
	ON_BN_CLICKED(IDC_CONVERT1_DROPFACES, OnConvert1Dropfaces)
	ON_BN_CLICKED(IDC_CONVERT1_ADDBASE, OnConvert1Addbase)
	ON_BN_CLICKED(IDC_CONVERT1_ADDUV, OnConvert1Adduv)
	ON_BN_CLICKED(IDC_CONVERT1_WRITEXYZ, OnConvert1Writexyz)
	ON_BN_CLICKED(IDC_CONVERT1_MESHTOLANDSCAPE, OnConvert1Meshtolandscape)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConvert1Page message handlers

BOOL CConvert1Page::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_Convert1_FlagStretchX = (at3dData->meshToLandscape.stretchXFlag) ? 1 : 0;
  m_Convert1_FlagStretchY = (at3dData->meshToLandscape.stretchYFlag) ? 1 : 0;

  m_Convert1_ConvertGroup = at3dData->meshToLandscape.convertFlag;
   
  m_Convert1_AddPointCloud = (at3dData->meshToLandscape.addCloudFlag) ? 1 : 0;
  m_Convert1_DropFaces = (at3dData->meshToLandscape.dropFacesFlag) ? 1 : 0;
  m_Convert1_AddBase = (at3dData->meshToLandscape.addBaseFlag) ? 1 : 0;
  m_Convert1_AddUV = (at3dData->meshToLandscape.addUVFlag) ? 1 : 0;
  m_Convert1_WriteXYZ = (at3dData->meshToLandscape.writeXYZFlag) ? 1 : 0;

  m_Convert1_XSpacing.Format("%f", at3dData->meshToLandscape.xSpacing);
  m_Convert1_YSpacing.Format("%f", at3dData->meshToLandscape.ySpacing);

  m_Convert1_DropElevation.Format("%f", at3dData->meshToLandscape.dropElevation);
  m_Convert1_BaseThickness.Format("%f", at3dData->meshToLandscape.baseThickness);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConvert1Page::OnConvert1Getsize() 
{
	__int32 result = At3d_Get_Mesh_To_Landscape_Size(&at3dData->meshToLandscape.minX);

  if (result)
  {		
		m_Convert1_MinX.Format("%f", at3dData->meshToLandscape.minX);
		m_Convert1_MinY.Format("%f", at3dData->meshToLandscape.minY);
		m_Convert1_MinZ.Format("%f", at3dData->meshToLandscape.minZ);
		
		m_Convert1_MaxX.Format("%f", at3dData->meshToLandscape.maxX);
		m_Convert1_MaxY.Format("%f", at3dData->meshToLandscape.maxY);
		m_Convert1_MaxZ.Format("%f", at3dData->meshToLandscape.maxZ);

		m_Convert1_SizeX.Format("%f", at3dData->meshToLandscape.sizeX);
		m_Convert1_SizeY.Format("%f", at3dData->meshToLandscape.sizeY);
		m_Convert1_SizeZ.Format("%f", at3dData->meshToLandscape.sizeZ);
		UpdateData(FALSE);
  }
}

void CConvert1Page::OnConvert1Calculate() 
{
	UpdateData(TRUE);
	at3dData->meshToLandscape.xSpacing = atof(m_Convert1_XSpacing);
  
  at3dData->meshToLandscape.ySpacing = atof(m_Convert1_YSpacing);
  

  At3d_WriteFlag(LIBFLAG_MESH_TO_DEM_STRETCH_X,
                 at3dData->meshToLandscape.stretchXFlag);

  At3d_WriteFlag(LIBFLAG_MESH_TO_DEM_STRETCH_Y,
                 at3dData->meshToLandscape.stretchYFlag);

  __int32 result = At3d_Calculate_Mesh_To_Landscape(
                                            at3dData->meshToLandscape.xSpacing,
                                            at3dData->meshToLandscape.ySpacing,
                                            &at3dData->meshToLandscape.xCount,
                                            &at3dData->meshToLandscape.newSizeX);

  if (result)
  {
    m_Convert1_XCount.Format("%d", at3dData->meshToLandscape.xCount);
    m_Convert1_YCount.Format("%d", at3dData->meshToLandscape.yCount);
    m_Convert1_VertCount.Format("%d", at3dData->meshToLandscape.vertCount);

    m_Convert1_MeshVertices.Format("%d", at3dData->meshToLandscape.vertCount);
    m_Convert1_MeshEdges.Format("%d", at3dData->meshToLandscape.edgeCount);
    m_Convert1_MeshTriangles.Format("%d", at3dData->meshToLandscape.triangleCount);

    m_Convert1_NewSizeX.Format("%f", at3dData->meshToLandscape.newSizeX);
    m_Convert1_NewSizeY.Format("%f", at3dData->meshToLandscape.newSizeY);

    m_Convert1_EditStretchX.Format("%f", at3dData->meshToLandscape.lastXSpacing);
    m_Convert1_EditStretchY.Format("%f", at3dData->meshToLandscape.lastYSpacing);
		UpdateData(FALSE);
  }
}

void CConvert1Page::OnConvert1Flagstretchx() 
{
	UpdateData(TRUE);
	at3dData->meshToLandscape.stretchXFlag = (m_Convert1_FlagStretchX) ? 1 : 0;
  OnConvert1Calculate();
}

void CConvert1Page::OnConvert1Flagstretchy() 
{
	UpdateData(TRUE);
	at3dData->meshToLandscape.stretchYFlag = (m_Convert1_FlagStretchY) ? 1 : 0;
	OnConvert1Calculate();
}

void CConvert1Page::OnConvert1Keeporiginal() 
{
	at3dData->meshToLandscape.convertFlag = 0;
}

void CConvert1Page::OnConvert1Landscape() 
{
	at3dData->meshToLandscape.convertFlag = 1;
}

void CConvert1Page::OnConvert1Mesh() 
{
	at3dData->meshToLandscape.convertFlag = 2;
}

void CConvert1Page::OnConvert1Addpointcloud() 
{
	UpdateData(TRUE);
	at3dData->meshToLandscape.addCloudFlag = (m_Convert1_AddPointCloud) ? 1 : 0;
}

void CConvert1Page::OnConvert1Dropfaces() 
{
	UpdateData(TRUE);
	at3dData->meshToLandscape.dropFacesFlag = (m_Convert1_DropFaces) ? 1 : 0;
}

void CConvert1Page::OnConvert1Addbase() 
{
	UpdateData(TRUE);
	at3dData->meshToLandscape.addBaseFlag = (m_Convert1_AddBase) ? 1 : 0;
}

void CConvert1Page::OnConvert1Adduv() 
{
	UpdateData(TRUE);
	at3dData->meshToLandscape.addUVFlag = (m_Convert1_AddUV) ? 1 : 0;
}

void CConvert1Page::OnConvert1Writexyz() 
{
	UpdateData(TRUE);
	at3dData->meshToLandscape.writeXYZFlag = (m_Convert1_WriteXYZ) ? 1 : 0;
}

void CConvert1Page::OnConvert1Meshtolandscape() 
{
	// To write an XYZ file during the conversion process
  // a full file path and name are required
  //
  char drive0[_MAX_DRIVE];
	char dir0[_MAX_DIR];
	char name0[_MAX_FNAME];
  char ext0[_MAX_EXT];
  char xyzName[MAX_PATH];

  if (at3dData->inName[0] == '\0')
  {
    xyzName[0] = '\0';
  }
  else
  {
    my_splitpath(at3dData->inName, drive0, _MAX_DRIVE, dir0, _MAX_DIR, 
                 name0, _MAX_FNAME, ext0, _MAX_EXT);
    my_makepath(xyzName, MAX_PATH, drive0, dir0, name0, ".xyz");
  }

  at3dData->meshToLandscape.dropElevation = atof(m_Convert1_DropElevation);
  
  at3dData->meshToLandscape.baseThickness = atof(m_Convert1_BaseThickness);
  

  At3d_WriteFlag(LIBFLAG_MESH_TO_DEM_CONVERT,
                 at3dData->meshToLandscape.convertFlag);

  At3d_WriteFlag(LIBFLAG_MESH_TO_DEM_ADD_CLOUD,
                 at3dData->meshToLandscape.addCloudFlag);

  At3d_WriteFlag(LIBFLAG_MESH_TO_DEM_DROP_FACES,
                 at3dData->meshToLandscape.dropFacesFlag);

  At3d_WriteFlag(LIBFLAG_MESH_TO_DEM_ADD_BASE,
                 at3dData->meshToLandscape.addBaseFlag);

  At3d_WriteFlag(LIBFLAG_MESH_TO_DEM_ADD_UV,
                 at3dData->meshToLandscape.addUVFlag);

  At3d_WriteFlag(LIBFLAG_MESH_TO_DEM_WRITE_XYZ,
                 at3dData->meshToLandscape.writeXYZFlag);

  if (at3dData->meshToLandscape.writeXYZFlag)
  {
    // set the necessary flags that control writing XYZ files
    //
    // write ASCII file
    //
    At3d_WriteFlag(LIBFLAG_OUT_XYZ_BINARY, 0);

    // use CAD right hand axis system
    //
    At3d_WriteFlag(LIBFLAG_OUT_XYZ_AXIS, 0);

    // duplicates are already removed
    //
    At3d_WriteFlag(LIBFLAG_OUT_XYZ_REMOVE_DUPLICATES, 0);

    // separate coordinates with spaces
    //
    At3d_WriteFlag(LIBFLAG_OUT_XYZ_TAB, 0);

    // do  not add X, Y or Z prefix to coordinates
    //
    At3d_WriteFlag(LIBFLAG_OUT_XYZ_PREFIX, 0);
  }

  At3d_Convert_Mesh_To_Landscape(xyzName, at3dData->meshToLandscape.dropElevation,
                                 at3dData->meshToLandscape.baseThickness);
}
