// Object: Monk
// original monk.3ds file created by Dan White

#ifndef at3dTestData_H
#define at3dTestData_H

#define LEN_LAYER_NAME   80

typedef struct tag_TEST_XYZ {
  float x;
  float y;
  float z;
  } TEST_XYZ;

typedef struct tag_TEST_UV {
  float u;
  float v;
  } TEST_UV;

typedef struct tag_TEST_XYZ_UV {
  float x;
  float y;
  float z;
  float u;
  float v;
  } TEST_XYZ_UV;

typedef struct tag_TEST_NORMAL {
  float x;
  float y;
  float z;
  } TEST_NORMAL;

typedef struct tag_TEST_TRIANGLE1 {
  __int32 xyzIndex[3];
  TEST_UV uv[3];
  TEST_NORMAL normal[3];
  } TEST_TRIANGLE1;

typedef struct tag_TEST_TRIANGLE2 {
  __int32 xyzIndex[3];
  __int32 uvIndex[3];
  __int32 normalIndex[3];
  } TEST_TRIANGLE2;

typedef struct tag_TEST_TRIANGLE3 {
  __int32 xyz_uvIndex[3];
  __int32 normalIndex[3];
  } TEST_TRIANGLE3;

typedef struct tag_TEST_TRIANGLE4 {
  __int32 xyzIndex[3];
  __int32 uvIndex[3];
  __int32 normalIndex[3];
  __int32 materialIndex;
  } TEST_TRIANGLE4;
  
typedef struct tag_TEST_RGB {
  float red;
  float green;
  float blue; 
  } TEST_RGB;

  typedef struct tag_TEST_MATERIAL {
  char name[LEN_LAYER_NAME];
  void* layerPtr;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_MATERIAL;
  
typedef struct tag_TEST_3D_DATA1 {
  char name[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_TRIANGLE1* triangle;
  __int32 uvFlag;
  __int32 normalFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA1;

typedef struct tag_TEST_3D_DATA2 {
  char name[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_UV* uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE2* triangle;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA2;

typedef struct tag_TEST_3D_DATA3 {
  char name[LEN_LAYER_NAME];
  __int32 xyz_uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ_UV* xyz_uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE3* triangle;
  __int32 uvFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA3;

typedef struct tag_TEST_3D_DATA4 {
  char name[LEN_LAYER_NAME];
  float* matrix;
  __int32 xyz_uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ_UV* xyz_uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE3* triangle;
  __int32 uvFlag;
  __int32 dxfColor;
  TEST_RGB ambientRGB;
  TEST_RGB diffuseRGB;
  TEST_RGB specularRGB;
  TEST_RGB emissiveRGB;
  char texturePathName[MAX_PATH];
  } TEST_3D_DATA4;

typedef struct tag_TEST_3D_DATA5 {
  char name[LEN_LAYER_NAME];
  char parentName[LEN_LAYER_NAME];
  __int32 xyzCount;
  __int32 uvCount;
  __int32 normalCount;
  __int32 triangleCount;
  TEST_XYZ* xyz;
  TEST_UV* uv;
  TEST_NORMAL* normal;
  TEST_TRIANGLE4* triangle;
  __int32 tag;
  TEST_XYZ pivotPoint;
  } TEST_3D_DATA5;

#endif at3dTestData_H

__int32 Monk_layerCount = 11;

float Monk_matrix_Body[16] = {
  0.553066f, 0.0f, 0.0f, 3.635905f,
  0.0f, 0.0f, -0.624723f, -18.741668f,
  0.0f, 0.999999f, 0.0f, 95.207266f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Body[306] = {
  { -75.605902f, -95.207336f, -29.999975f, 0.671333f, 2.0f },
  { -75.605902f, -95.207336f, -29.999975f, 3.328667f, 2.0f },
  { -75.240832f, -95.207329f, -51.053157f, 0.671333f, 1.73579f },
  { -75.240832f, -95.207329f, -51.053157f, 3.328667f, 1.73579f },
  { -75.240825f, -95.207321f, -8.946799f, 0.671333f, 2.26421f },
  { -75.240825f, -95.207321f, -8.946799f, 3.328667f, 2.26421f },
  { -74.664924f, -60.96703f, -29.99999f, 1.242839f, 2.0f },
  { -72.807563f, -83.303283f, -29.999985f, 0.870023f, 2.0f },
  { -72.370125f, -59.977928f, -50.538268f, 1.259348f, 1.742252f },
  { -72.370125f, -59.977951f, -9.461707f, 1.259347f, 2.257748f },
  { -72.117393f, -82.534034f, -49.96442f, 0.882863f, 1.749453f },
  { -72.117393f, -82.534035f, -10.035553f, 0.882863f, 2.250546f },
  { -70.341586f, -95.207344f, -66.348022f, 0.671332f, 1.543845f },
  { -70.341586f, -95.207344f, -66.348022f, 1.19974f, 0.671332f },
  { -70.341586f, -95.207344f, -66.348022f, 2.80026f, 0.671332f },
  { -70.341586f, -95.207344f, -66.348022f, 3.328668f, 1.543845f },
  { -70.341579f, -95.207321f, 6.348058f, 0.671333f, 2.456155f },
  { -70.341579f, -95.207321f, 6.348058f, 1.19974f, 0.671333f },
  { -70.341579f, -95.207321f, 6.348058f, 2.80026f, 0.671333f },
  { -70.341579f, -95.207321f, 6.348058f, 3.328667f, 2.456155f },
  { -68.943816f, -31.580324f, -29.999994f, 1.733333f, 2.0f },
  { -67.292872f, -81.606598f, -64.060967f, 0.898343f, 1.572547f },
  { -67.292872f, -81.606598f, -64.060967f, 1.238f, 0.898343f },
  { -67.292872f, -81.606582f, 4.060995f, 0.898343f, 2.427453f },
  { -67.292872f, -81.606582f, 4.060995f, 2.761999f, 0.898343f },
  { -65.922347f, -32.990885f, -9.392978f, 1.709789f, 2.258611f },
  { -65.922341f, -32.990882f, -50.607002f, 1.709789f, 1.741389f },
  { -65.885936f, -59.077874f, -63.695392f, 1.255657f, 1.27437f },
  { -65.885936f, -59.077874f, -63.695392f, 1.27437f, 1.577134f },
  { -65.885922f, -59.077864f, 3.695423f, 1.274371f, 2.422865f },
  { -65.885922f, -59.077864f, 3.695423f, 2.744343f, 1.274371f },
  { -58.893098f, -34.111619f, -62.851387f, 1.343415f, 1.691083f },
  { -58.893098f, -34.111619f, -62.851387f, 1.691083f, 1.587726f },
  { -58.893098f, -34.111616f, 2.851403f, 1.691083f, 2.412273f },
  { -58.893098f, -34.111616f, 2.851403f, 2.656585f, 1.691083f },
  { -52.080723f, -60.967038f, -29.999979f, 2.757162f, 2.0f },
  { -51.91301f, -60.967038f, -8.520095f, 1.431012f, 1.242839f },
  { -51.91301f, -60.967038f, -8.520095f, 2.757162f, 2.269565f },
  { -51.913003f, -60.967038f, -51.479866f, 2.568988f, 1.242838f },
  { -51.913003f, -60.967038f, -51.479866f, 2.757162f, 1.730435f },
  { -51.533063f, -95.207329f, -71.693053f, 1.435781f, 0.671333f },
  { -51.533063f, -95.207329f, -71.693053f, 2.564219f, 0.671333f },
  { -51.533059f, -95.207306f, 11.693068f, 1.435781f, 0.671333f },
  { -51.533059f, -95.207306f, 11.693068f, 2.564219f, 0.671333f },
  { -50.309358f, -81.846795f, -69.186348f, 1.451138f, 0.894334f },
  { -50.309358f, -81.846786f, 9.186379f, 2.548862f, 0.894334f },
  { -49.925793f, -4.348133f, -29.999992f, 1.455951f, 2.0f },
  { -49.925793f, -4.348133f, -29.999992f, 2.187866f, 2.0f },
  { -49.765909f, -4.949289f, -43.603806f, 1.457958f, 1.829277f },
  { -49.765909f, -4.949289f, -43.603806f, 2.177832f, 1.829277f },
  { -49.765909f, -4.949287f, -16.396183f, 1.457958f, 2.170723f },
  { -49.765909f, -4.949287f, -16.396183f, 2.177832f, 2.170723f },
  { -49.53293f, -59.182411f, 8.807288f, 2.539119f, 1.272626f },
  { -49.532926f, -59.182411f, -68.807266f, 1.460881f, 1.272626f },
  { -49.231312f, 48.000008f, -43.157909f, 3.061611f, 1.834873f },
  { -49.231312f, 64.000016f, -43.157909f, 3.328667f, 1.834873f },
  { -49.231312f, 48.000006f, -30.000013f, 3.061611f, 2.0f },
  { -49.231312f, 64.000013f, -30.000013f, 3.328667f, 2.0f },
  { -49.231312f, 48.000003f, -16.842115f, 3.061611f, 2.165127f },
  { -49.231312f, 64.000011f, -16.84212f, 3.328667f, 2.165127f },
  { -46.63872f, 30.563308f, -42.305084f, 2.770574f, 1.845575f },
  { -46.63872f, 30.563314f, -30.00001f, 2.770574f, 2.0f },
  { -46.63872f, 30.563311f, -17.694942f, 2.770574f, 2.154424f },
  { -45.327426f, -5.811043f, -53.071007f, 1.513659f, 1.710467f },
  { -45.327426f, -5.811043f, -53.071007f, 1.513659f, 2.163449f },
  { -45.327426f, -5.811043f, -53.071007f, 2.163449f, 1.710467f },
  { -45.32742f, -5.811037f, -6.928982f, 1.513659f, 2.289533f },
  { -45.32742f, -5.811037f, -6.928982f, 2.163449f, 2.289533f },
  { -45.32742f, -5.811037f, -6.928982f, 2.486341f, 2.163449f },
  { -45.231312f, 48.00001f, -53.026332f, 1.514865f, 3.061611f },
  { -45.231312f, 48.00001f, -53.026332f, 3.061611f, 1.711028f },
  { -45.231312f, 64.000002f, -53.026332f, 1.514865f, 3.328667f },
  { -45.231312f, 64.000002f, -53.026332f, 3.328667f, 1.711028f },
  { -45.231312f, 48.000017f, -6.973693f, 2.485135f, 3.061611f },
  { -45.231312f, 48.000017f, -6.973693f, 3.061611f, 2.288972f },
  { -45.231312f, 64.000009f, -6.973693f, 2.485135f, 3.328667f },
  { -45.231312f, 64.000009f, -6.973693f, 3.328667f, 2.288972f },
  { -44.955511f, -34.209602f, -67.223573f, 1.518326f, 1.689448f },
  { -44.955511f, -34.209605f, 7.223591f, 2.481674f, 1.689448f },
  { -42.63872f, 30.563318f, -51.320672f, 1.547401f, 2.770574f },
  { -42.63872f, 30.563318f, -51.320672f, 2.770574f, 1.732433f },
  { -42.638717f, 30.56331f, -8.679347f, 2.452599f, 2.770574f },
  { -42.638717f, 30.56331f, -8.679347f, 2.770574f, 2.267566f },
  { -37.972095f, 4.000299f, -39.755226f, 1.605966f, 1.877575f },
  { -37.972095f, 4.000299f, -39.755226f, 2.32721f, 1.877575f },
  { -37.972095f, 4.000296f, -20.24477f, 1.605966f, 2.122425f },
  { -37.972095f, 4.000296f, -20.24477f, 2.32721f, 2.122425f },
  { -37.969325f, 4.181557f, -29.999996f, 1.606f, 2.0f },
  { -37.969325f, 4.181557f, -29.999996f, 2.330235f, 2.0f },
  { -37.429173f, 11.034848f, -39.589951f, 2.444624f, 1.879649f },
  { -37.429173f, 11.034847f, -29.999998f, 2.444624f, 2.0f },
  { -37.429173f, 11.034845f, -20.410057f, 2.444624f, 2.12035f },
  { -34.960041f, 11.03485f, -46.975304f, 1.643766f, 2.444624f },
  { -34.960041f, 11.03485f, -46.975304f, 2.444624f, 1.786966f },
  { -34.960041f, 11.034844f, -13.024696f, 2.356234f, 2.444624f },
  { -34.960041f, 11.034844f, -13.024696f, 2.444624f, 2.213034f },
  { -34.917294f, 3.635943f, -46.668094f, 1.644302f, 1.790821f },
  { -34.917294f, 3.635943f, -46.668094f, 1.644302f, 2.321129f },
  { -34.917294f, 3.635943f, -46.668094f, 2.321129f, 1.790821f },
  { -34.917294f, 3.635945f, -13.331905f, 1.644302f, 2.209178f },
  { -34.917294f, 3.635945f, -13.331905f, 2.321129f, 2.209178f },
  { -34.917294f, 3.635945f, -13.331905f, 2.355698f, 2.321129f },
  { -33.843118f, -6.213081f, -56.361289f, 1.657783f, 1.669175f },
  { -33.843118f, -6.213081f, -56.361289f, 1.657783f, 2.156739f },
  { -33.843112f, -6.213084f, -3.638685f, 1.657783f, 2.330825f },
  { -33.843112f, -6.213084f, -3.638685f, 2.342217f, 2.156738f },
  { -33.231312f, 48.00001f, -56.315808f, 1.665461f, 3.061611f },
  { -33.231312f, 64.000018f, -56.31581f, 1.665461f, 3.328667f },
  { -33.231308f, 48.000016f, -3.68422f, 2.334539f, 3.061611f },
  { -33.231308f, 64.000008f, -3.684219f, 2.334539f, 3.328667f },
  { -31.675755f, 30.563318f, -54.610154f, 1.684982f, 2.770574f },
  { -31.675755f, 30.563309f, -5.38987f, 2.315018f, 2.770574f },
  { -28.776054f, -81.875306f, -69.217148f, 1.721373f, 0.893858f },
  { -28.776054f, -81.875297f, 9.217164f, 2.278627f, 0.893858f },
  { -27.808082f, -95.207329f, -71.710853f, 1.733521f, 0.671333f },
  { -27.808082f, -95.207329f, -71.710853f, 2.266479f, 0.671333f },
  { -27.808082f, -95.207298f, 11.710886f, 1.733521f, 0.671333f },
  { -27.808082f, -95.207298f, 11.710886f, 2.266479f, 0.671333f },
  { -27.465042f, -60.96703f, -8.506831f, 1.737826f, 1.242839f },
  { -27.465041f, -60.967022f, -51.493122f, 2.262174f, 1.242839f },
  { -27.191921f, 3.257045f, -49.286294f, 1.741253f, 1.757964f },
  { -27.191921f, 3.257045f, -49.286294f, 1.741253f, 2.314805f },
  { -27.191921f, 3.257045f, -10.713707f, 1.741253f, 2.242036f },
  { -27.191921f, 3.257045f, -10.713707f, 2.258747f, 2.314805f },
  { -27.159457f, -59.158279f, 8.738453f, 2.258339f, 1.273029f },
  { -27.159452f, -59.158287f, -68.738419f, 1.741661f, 1.273028f },
  { -26.697355f, 11.034843f, -49.179886f, 1.74746f, 2.444624f },
  { -26.697355f, 11.034843f, -10.820108f, 2.25254f, 2.444624f },
  { -24.755375f, -34.354687f, -66.748536f, 1.771831f, 1.687026f },
  { -24.755375f, -34.354689f, 6.748551f, 2.228169f, 1.687026f },
  { -18.57575f, -6.820183f, -55.954749f, 1.849383f, 2.146605f },
  { -18.575747f, -6.820178f, -4.045234f, 2.150617f, 2.146605f },
  { -17.23131f, 48.00001f, -56.315808f, 1.866255f, 3.061611f },
  { -17.23131f, 64.000018f, -56.31581f, 1.866255f, 3.328668f },
  { -17.23131f, 48.000016f, -3.68422f, 2.133745f, 3.061611f },
  { -17.23131f, 64.000008f, -3.684219f, 2.133745f, 3.328668f },
  { -16.712791f, 30.563318f, -54.610154f, 1.872762f, 2.770575f },
  { -16.712791f, 30.563309f, -5.38987f, 2.127238f, 2.770575f },
  { -14.887071f, 2.554019f, -49.074257f, 1.895675f, 2.303071f },
  { -14.887071f, 2.554027f, -10.925743f, 2.104325f, 2.303071f },
  { -14.15881f, 11.034843f, -49.179886f, 1.904814f, 2.444624f },
  { -14.15881f, 11.034843f, -10.820108f, 2.095186f, 2.444624f },
  { -6.574082f, -95.207329f, -71.102936f, 2.0f, 0.671333f },
  { -6.574082f, -80.951523f, -68.219055f, 2.0f, 0.909277f },
  { -6.574082f, -58.418762f, -66.628936f, 2.0f, 1.285372f },
  { -6.574082f, -35.04659f, -64.483077f, 2.0f, 1.675478f },
  { -6.574082f, -7.683145f, -55.376846f, 2.0f, 2.132202f },
  { -6.574082f, -95.207321f, 11.102963f, 2.0f, 0.671333f },
  { -6.574082f, -80.951508f, 8.219099f, 2.0f, 0.909277f },
  { -6.574082f, -58.418761f, 6.628952f, 2.0f, 1.285372f },
  { -6.574082f, -35.046591f, 4.483094f, 2.0f, 1.675478f },
  { -6.574082f, -7.683131f, -4.623129f, 2.0f, 2.132202f },
  { -6.574081f, -60.96703f, -51.05317f, 2.0f, 1.242839f },
  { -6.574081f, 1.974627f, -48.899509f, 2.0f, 2.2934f },
  { -6.574081f, 1.974628f, -11.100488f, 2.0f, 2.2934f },
  { -6.574081f, 11.034835f, -49.179886f, 2.0f, 2.444624f },
  { -6.574081f, 11.034835f, -10.820106f, 2.0f, 2.444624f },
  { -6.574081f, 30.563309f, -5.389868f, 2.0f, 2.770574f },
  { -6.574081f, 30.563311f, -54.610142f, 2.0f, 2.770574f },
  { -6.574081f, 48.000001f, -3.684217f, 2.0f, 3.061611f },
  { -6.574081f, 48.00001f, -56.315802f, 2.0f, 3.061611f },
  { -6.574081f, 63.999993f, -3.684216f, 2.0f, 3.328667f },
  { -6.574081f, 64.000003f, -56.315804f, 2.0f, 3.328667f },
  { -6.57408f, -60.967038f, -8.946796f, 2.0f, 1.242839f },
  { 1.010649f, 11.034827f, -49.179878f, 2.095185f, 2.444624f },
  { 1.010649f, 11.034828f, -10.820106f, 1.904815f, 2.444624f },
  { 1.738909f, 2.554011f, -49.074245f, 2.104325f, 2.303071f },
  { 1.738909f, 2.554012f, -10.92574f, 1.895675f, 2.303071f },
  { 3.56463f, 30.563303f, -54.610142f, 2.127237f, 2.770574f },
  { 3.56463f, 30.563301f, -5.389867f, 1.872763f, 2.770574f },
  { 4.083148f, 48.00001f, -56.315796f, 2.133744f, 3.061611f },
  { 4.083148f, 64.000003f, -56.315792f, 2.133744f, 3.328667f },
  { 4.083148f, 48.000001f, -3.684214f, 1.866256f, 3.061611f },
  { 4.083148f, 64.000008f, -3.684213f, 1.866256f, 3.328667f },
  { 5.427586f, -6.820191f, -55.95474f, 2.150616f, 2.146605f },
  { 5.427588f, -6.820185f, -4.045234f, 1.849384f, 2.146605f },
  { 11.607212f, -34.354695f, -66.748536f, 2.228168f, 1.687026f },
  { 11.607215f, -34.354701f, 6.748545f, 1.771831f, 1.687026f },
  { 13.549193f, 11.034827f, -49.179878f, 2.25254f, 2.444624f },
  { 13.549193f, 11.034828f, -10.820106f, 1.74746f, 2.444624f },
  { 14.011291f, -59.158295f, -68.738419f, 2.258339f, 1.273028f },
  { 14.011295f, -59.158294f, 8.738447f, 1.741661f, 1.273028f },
  { 14.043759f, 3.25703f, -49.286286f, 2.258746f, 1.757964f },
  { 14.043759f, 3.25703f, -49.286286f, 2.258746f, 2.314805f },
  { 14.043759f, 3.257038f, -10.713707f, 1.741254f, 2.314805f },
  { 14.043759f, 3.257038f, -10.713707f, 2.258746f, 2.242036f },
  { 14.316879f, -60.96703f, -51.493134f, 1.737826f, 1.242839f },
  { 14.316884f, -60.967038f, -8.506842f, 2.262174f, 1.242839f },
  { 14.65992f, -95.207336f, -71.710853f, 1.733521f, 0.671333f },
  { 14.65992f, -95.207336f, -71.710853f, 2.266479f, 0.671333f },
  { 14.659922f, -95.207314f, 11.710877f, 1.733521f, 0.671333f },
  { 14.659922f, -95.207314f, 11.710877f, 2.266479f, 0.671333f },
  { 15.62789f, -81.875313f, -69.217148f, 2.278627f, 0.893858f },
  { 15.627895f, -81.875305f, 9.217154f, 1.721373f, 0.893858f },
  { 18.527591f, 30.563301f, -5.389865f, 1.684983f, 2.770574f },
  { 18.527593f, 30.563303f, -54.610142f, 2.315017f, 2.770574f },
  { 20.083146f, 48.000001f, -3.684214f, 1.665462f, 3.061611f },
  { 20.083146f, 64.000008f, -3.68421f, 1.665462f, 3.328668f },
  { 20.083151f, 48.00001f, -56.315796f, 2.334538f, 3.061611f },
  { 20.083151f, 64.000003f, -56.315792f, 2.334538f, 3.328668f },
  { 20.694954f, -6.213089f, -56.361289f, 2.342216f, 1.669175f },
  { 20.694954f, -6.213089f, -56.361289f, 2.342216f, 2.156739f },
  { 20.694955f, -6.213091f, -3.638685f, 1.657784f, 2.156738f },
  { 20.694955f, -6.213091f, -3.638685f, 2.342216f, 2.330825f },
  { 21.76913f, 3.635936f, -46.668091f, 1.678871f, 1.790821f },
  { 21.76913f, 3.635936f, -46.668091f, 2.355697f, 1.790821f },
  { 21.76913f, 3.635936f, -46.668091f, 2.355697f, 2.321129f },
  { 21.76913f, 3.635937f, -13.331904f, 1.644303f, 2.321129f },
  { 21.76913f, 3.635937f, -13.331904f, 1.678871f, 2.209178f },
  { 21.76913f, 3.635937f, -13.331904f, 2.355697f, 2.209178f },
  { 21.81188f, 11.034835f, -46.975296f, 1.555376f, 1.786966f },
  { 21.81188f, 11.034835f, -46.975296f, 2.356234f, 2.444624f },
  { 21.81188f, 11.034828f, -13.024693f, 1.555376f, 2.213034f },
  { 21.81188f, 11.034828f, -13.024693f, 1.643767f, 2.444624f },
  { 24.281012f, 11.034833f, -39.589939f, 1.555376f, 1.879649f },
  { 24.281012f, 11.034831f, -29.999994f, 1.555376f, 2.0f },
  { 24.281012f, 11.03483f, -20.410052f, 1.555376f, 2.12035f },
  { 24.821161f, 4.181549f, -29.999994f, 1.669764f, 2.0f },
  { 24.821161f, 4.181549f, -29.999994f, 2.393999f, 2.0f },
  { 24.823931f, 4.000292f, -39.755226f, 1.67279f, 1.877575f },
  { 24.823931f, 4.000292f, -39.755226f, 2.394034f, 1.877575f },
  { 24.823934f, 4.000288f, -20.244768f, 1.67279f, 2.122425f },
  { 24.823934f, 4.000288f, -20.244768f, 2.394034f, 2.122425f },
  { 29.490557f, 30.563302f, -8.679343f, 1.229426f, 2.267567f },
  { 29.490557f, 30.563302f, -8.679343f, 1.547402f, 2.770574f },
  { 29.49056f, 30.56331f, -51.320667f, 1.229426f, 1.732433f },
  { 29.49056f, 30.56331f, -51.320667f, 2.452598f, 2.770575f },
  { 31.80734f, -34.20961f, -67.223573f, 2.481673f, 1.689448f },
  { 31.807344f, -34.209612f, 7.223585f, 1.518327f, 1.689448f },
  { 32.083148f, 48.00001f, -53.026317f, 0.938389f, 1.711028f },
  { 32.083148f, 48.00001f, -53.026317f, 2.485134f, 3.061611f },
  { 32.083148f, 64.000002f, -53.026322f, 0.671333f, 1.711028f },
  { 32.083148f, 64.000002f, -53.026322f, 2.485134f, 3.328667f },
  { 32.083148f, 48.000001f, -6.973686f, 0.938389f, 2.288972f },
  { 32.083148f, 48.000001f, -6.973686f, 1.514866f, 3.061611f },
  { 32.083148f, 63.999994f, -6.973686f, 0.671333f, 2.288972f },
  { 32.083148f, 63.999994f, -6.973686f, 1.514866f, 3.328667f },
  { 32.179259f, -5.811052f, -6.928982f, 1.513659f, 2.163449f },
  { 32.179259f, -5.811052f, -6.928982f, 1.836551f, 2.289533f },
  { 32.179259f, -5.811052f, -6.928982f, 2.486341f, 2.289533f },
  { 32.179263f, -5.811051f, -53.071002f, 1.836551f, 1.710467f },
  { 32.179263f, -5.811051f, -53.071002f, 2.486341f, 1.710467f },
  { 32.179263f, -5.811051f, -53.071002f, 2.486341f, 2.163449f },
  { 33.490567f, 30.563301f, -42.305081f, 1.229426f, 1.845575f },
  { 33.490567f, 30.563306f, -30.000004f, 1.229426f, 2.0f },
  { 33.490567f, 30.563304f, -17.694935f, 1.229426f, 2.154424f },
  { 36.083148f, 48.000008f, -43.157898f, 0.938389f, 1.834873f },
  { 36.083148f, 64.0f, -43.157898f, 0.671333f, 1.834873f },
  { 36.083148f, 48.000006f, -30.000004f, 0.938389f, 2.0f },
  { 36.083148f, 63.999998f, -30.000004f, 0.671333f, 2.0f },
  { 36.083148f, 48.000003f, -16.842107f, 0.938389f, 2.165127f },
  { 36.083148f, 63.999996f, -16.842107f, 0.671333f, 2.165127f },
  { 36.384756f, -59.182411f, -68.807266f, 2.539118f, 1.272626f },
  { 36.384762f, -59.182418f, 8.807285f, 1.460882f, 1.272626f },
  { 36.617741f, -4.949294f, -16.396183f, 1.822167f, 2.170723f },
  { 36.617741f, -4.949294f, -16.396183f, 2.542042f, 2.170723f },
  { 36.617745f, -4.949297f, -43.603801f, 1.822167f, 1.829277f },
  { 36.617745f, -4.949297f, -43.603801f, 2.542042f, 1.829277f },
  { 36.777625f, -4.348141f, -29.999989f, 1.812133f, 2.0f },
  { 36.777625f, -4.348141f, -29.999989f, 2.544048f, 2.0f },
  { 37.161191f, -81.846802f, -69.186348f, 2.548862f, 0.894334f },
  { 37.161191f, -81.846801f, 9.18637f, 1.451138f, 0.894334f },
  { 38.384899f, -95.207321f, 11.693056f, 1.435781f, 0.671333f },
  { 38.384899f, -95.207321f, 11.693056f, 2.564219f, 0.671333f },
  { 38.384902f, -95.207329f, -71.693053f, 1.435781f, 0.671333f },
  { 38.384902f, -95.207329f, -71.693053f, 2.564219f, 0.671333f },
  { 38.764843f, -60.967038f, -51.479867f, 1.242839f, 1.730435f },
  { 38.764843f, -60.967038f, -51.479867f, 1.431013f, 1.242839f },
  { 38.764846f, -60.967038f, -8.520107f, 1.242839f, 2.269565f },
  { 38.764846f, -60.967038f, -8.520107f, 2.568988f, 1.242839f },
  { 38.932562f, -60.967045f, -29.999985f, 1.242839f, 2.0f },
  { 45.744931f, -34.111626f, -62.851378f, 2.308917f, 1.587727f },
  { 45.744931f, -34.111626f, -62.851378f, 2.656585f, 1.691083f },
  { 45.744935f, -34.111623f, 2.851396f, 1.343415f, 1.691083f },
  { 45.744935f, -34.111623f, 2.851396f, 2.308917f, 2.412273f },
  { 52.737759f, -59.077882f, -63.695392f, 2.725629f, 1.577134f },
  { 52.737759f, -59.077882f, -63.695392f, 2.744343f, 1.274371f },
  { 52.737766f, -59.077872f, 3.695417f, 1.255657f, 1.274371f },
  { 52.737766f, -59.077872f, 3.695417f, 2.725629f, 2.422865f },
  { 52.774177f, -32.990897f, -9.392983f, 2.290211f, 2.258611f },
  { 52.774184f, -32.990885f, -50.607003f, 2.29021f, 1.741389f },
  { 54.144709f, -81.606606f, -64.060967f, 2.761999f, 0.898343f },
  { 54.144709f, -81.606606f, -64.060967f, 3.101657f, 1.572547f },
  { 54.144716f, -81.60659f, 4.060985f, 1.238001f, 0.898343f },
  { 54.144716f, -81.60659f, 4.060985f, 3.101656f, 2.427453f },
  { 55.795652f, -31.580336f, -29.999996f, 2.266667f, 2.0f },
  { 57.193422f, -95.207352f, -66.348031f, 0.671333f, 1.543845f },
  { 57.193422f, -95.207352f, -66.348031f, 1.19974f, 0.671333f },
  { 57.193422f, -95.207352f, -66.348031f, 2.80026f, 0.671333f },
  { 57.193422f, -95.207352f, -66.348031f, 3.328667f, 1.543845f },
  { 57.193429f, -95.207336f, 6.348049f, 0.671333f, 2.456155f },
  { 57.193429f, -95.207336f, 6.348049f, 1.19974f, 0.671333f },
  { 57.193429f, -95.207336f, 6.348049f, 2.80026f, 0.671333f },
  { 57.193429f, -95.207336f, 6.348049f, 3.328667f, 2.456155f },
  { 58.969229f, -82.534042f, -49.964427f, 3.117136f, 1.749453f },
  { 58.969236f, -82.534043f, -10.035558f, 3.117136f, 2.250546f },
  { 59.221955f, -59.977936f, -50.538269f, 2.740652f, 1.742252f },
  { 59.221955f, -59.977959f, -9.461715f, 2.740653f, 2.257748f },
  { 59.659406f, -83.303291f, -29.999992f, 3.129976f, 2.0f },
  { 61.516767f, -60.967038f, -29.999996f, 2.757161f, 2.0f },
  { 62.092668f, -95.207336f, -51.053165f, 0.671333f, 1.73579f },
  { 62.092668f, -95.207336f, -51.053165f, 3.328667f, 1.73579f },
  { 62.092668f, -95.207329f, -8.946811f, 0.671333f, 2.26421f },
  { 62.092668f, -95.207329f, -8.946811f, 3.328667f, 2.26421f },
  { 62.457745f, -95.207344f, -29.999981f, 0.671333f, 2.0f },
  { 62.457745f, -95.207344f, -29.999981f, 3.328667f, 2.0f }
};


TEST_NORMAL Monk_normal_Body[208] = {
  { -1.0f, 0.0f, 0.0f }, { -0.997754f, -0.065314f, -0.014876f },
  { -0.997278f, 0.073735f, 0.0f }, { -0.996046f, -0.088269f, -0.01006f },
  { -0.983634f, 0.18018f, 0.000183f }, { -0.98152f, 0.0f, -0.19136f },
  { -0.98152f, 0.0f, 0.19136f }, { -0.978445f, 0.076269f, -0.191907f },
  { -0.97772f, 0.079356f, 0.194336f }, { -0.977345f, -0.110912f, 0.180267f },
  { -0.97489f, -0.131628f, -0.179622f }, { -0.969674f, 0.183836f, -0.161048f },
  { -0.964915f, 0.203243f, 0.166226f }, { -0.958082f, -0.109276f, 0.264835f },
  { -0.957589f, -0.100605f, -0.270002f }, { -0.957053f, 0.289913f, 0.0f },
  { -0.937249f, 0.2891f, 0.194898f }, { -0.934347f, 0.297901f, -0.195576f },
  { -0.921778f, -0.387711f, 0.002219f }, { -0.874217f, -0.485522f, 0.003758f },
  { -0.872223f, -0.364324f, -0.326336f }, { -0.863288f, -0.390607f, 0.319624f },
  { -0.843687f, -0.504657f, -0.183065f }, { -0.83838f, -0.508662f, 0.195915f },
  { -0.825002f, 0.565129f, 0.001181f }, { -0.719527f, -0.69433f, 0.013685f },
  { -0.715313f, -0.668407f, 0.203862f }, { -0.702591f, -0.67963f, -0.210874f },
  { -0.687063f, -0.162618f, -0.708166f }, { -0.679425f, -0.147238f, 0.71882f },
  { -0.669463f, -0.119248f, -0.733211f }, { -0.666357f, 0.083301f, 0.740965f },
  { -0.664762f, 0.07995f, -0.742764f }, { -0.664351f, 0.0f, -0.74742f },
  { -0.664351f, 0.0f, 0.747421f }, { -0.655365f, -0.120632f, 0.745617f },
  { -0.642884f, 0.220449f, -0.733554f }, { -0.642437f, 0.240719f, 0.72755f },
  { -0.641728f, 0.269942f, 0.717856f }, { -0.640253f, 0.279855f, -0.715372f },
  { -0.575278f, -0.325814f, -0.750267f }, { -0.5674f, -0.337263f, 0.751206f },
  { -0.553605f, -0.477479f, 0.682301f }, { -0.543406f, -0.468085f, -0.696855f },
  { -0.519483f, 0.642265f, 0.563589f }, { -0.518273f, 0.642757f, -0.564142f },
  { -0.479487f, -0.619926f, 0.621116f }, { -0.472255f, -0.621163f, -0.625405f },
  { -0.467925f, 0.876101f, -0.116156f }, { -0.466242f, 0.876944f, 0.116568f },
  { -0.429511f, 0.789853f, -0.437782f }, { -0.427861f, 0.78985f, 0.4394f },
  { -0.413809f, 0.910357f, -0.00362f }, { -0.152322f, -0.059633f, 0.98653f },
  { -0.152322f, -0.059633f, -0.98653f }, { -0.14527f, 0.201213f, -0.968716f },
  { -0.14527f, 0.201214f, 0.968715f }, { -0.140968f, -0.112071f, 0.98365f },
  { -0.140967f, -0.112071f, -0.983651f }, { -0.138434f, 0.056902f, 0.988736f },
  { -0.138433f, 0.056902f, -0.988736f }, { -0.136872f, -0.247303f, 0.959222f },
  { -0.136871f, -0.247303f, -0.959222f }, { -0.133377f, 0.0f, 0.991065f },
  { -0.133377f, 0.0f, -0.991065f }, { -0.125744f, 0.14629f, -0.981217f },
  { -0.125744f, 0.14629f, 0.981217f }, { -0.107103f, -0.350007f, -0.930604f },
  { -0.107103f, -0.350007f, 0.930604f }, { -0.09211f, 0.904454f, -0.416507f },
  { -0.092024f, 0.904466f, 0.416501f }, { -0.091254f, -0.511759f, -0.854269f },
  { -0.091254f, -0.511759f, 0.854269f }, { -0.068783f, -0.208694f, 0.975559f },
  { -0.068783f, -0.208694f, -0.975559f }, { -0.055063f, -0.466564f, 0.882772f },
  { -0.055063f, -0.466565f, -0.882771f }, { -0.053332f, -0.047876f, -0.997428f },
  { -0.053332f, -0.047876f, 0.997428f }, { -0.034667f, -0.293009f, -0.955481f },
  { -0.034667f, -0.293009f, 0.955481f }, { -0.024679f, -0.109967f, 0.993629f },
  { -0.024679f, -0.109968f, -0.993629f }, { -0.018127f, 0.932679f, -0.360251f },
  { -0.015119f, 0.932509f, 0.360829f }, { -0.009953f, 0.507304f, -0.86171f },
  { -0.008884f, 0.50833f, 0.861116f }, { -0.002499f, 0.139357f, 0.990239f },
  { -0.002499f, 0.139357f, -0.990239f }, { 0.0f, -0.448453f, -0.893806f },
  { 0.0f, -0.448452f, 0.893807f }, { 0.0f, -0.293383f, -0.955995f },
  { 0.0f, -0.293382f, 0.955995f }, { 0.0f, -0.197453f, -0.980312f },
  { 0.0f, -0.197453f, 0.980312f }, { 0.0f, -0.130586f, -0.991437f },
  { 0.0f, -0.130585f, 0.991437f }, { 0.0f, -0.067319f, -0.997732f },
  { 0.0f, -0.067319f, 0.997732f }, { 0.0f, 0.0f, -1.0f },
  { 0.0f, 0.0f, 1.0f }, { 0.0f, 0.048735f, -0.998812f },
  { 0.0f, 0.048735f, -0.998812f }, { 0.0f, 0.048735f, -0.998812f },
  { 0.0f, 0.048735f, 0.998812f }, { 0.0f, 0.048735f, 0.998812f },
  { 0.0f, 0.048736f, 0.998812f }, { 0.0f, 0.145876f, -0.989303f },
  { 0.0f, 0.145876f, 0.989303f }, { 0.0f, 0.18332f, -0.983053f },
  { 0.0f, 0.18332f, -0.983053f }, { 0.0f, 0.18332f, -0.983053f },
  { 0.0f, 0.183321f, 0.983053f }, { 0.0f, 0.183321f, 0.983053f },
  { 0.0f, 0.183321f, 0.983053f }, { 0.0f, 0.505304f, -0.862941f },
  { 0.0f, 0.507371f, 0.861728f }, { 0.0f, 0.939754f, 0.34185f },
  { 0.0f, 0.940152f, -0.340755f }, { 0.002499f, 0.139356f, -0.990239f },
  { 0.0025f, 0.139357f, 0.990239f }, { 0.008885f, 0.50833f, 0.861116f },
  { 0.009953f, 0.507304f, -0.86171f }, { 0.015119f, 0.932509f, 0.360829f },
  { 0.018127f, 0.93268f, -0.36025f }, { 0.024679f, -0.109968f, -0.993629f },
  { 0.024679f, -0.109967f, 0.993629f }, { 0.034667f, -0.293009f, 0.955481f },
  { 0.034667f, -0.293009f, -0.955481f }, { 0.053332f, -0.047876f, 0.997428f },
  { 0.053332f, -0.047876f, -0.997428f }, { 0.055063f, -0.466565f, -0.882771f },
  { 0.055063f, -0.466564f, 0.882772f }, { 0.068782f, -0.208694f, -0.975559f },
  { 0.068783f, -0.208694f, 0.975559f }, { 0.091254f, -0.511758f, 0.854269f },
  { 0.091254f, -0.511759f, -0.854269f }, { 0.092024f, 0.904466f, 0.416501f },
  { 0.09211f, 0.904454f, -0.416507f }, { 0.107103f, -0.350006f, 0.930604f },
  { 0.107103f, -0.350007f, -0.930604f }, { 0.125744f, 0.14629f, 0.981217f },
  { 0.125744f, 0.14629f, -0.981217f }, { 0.133377f, 0.0f, -0.991065f },
  { 0.133377f, 0.0f, 0.991065f }, { 0.136871f, -0.247303f, -0.959222f },
  { 0.136871f, -0.247303f, 0.959222f }, { 0.138433f, 0.056902f, -0.988736f },
  { 0.138434f, 0.056902f, 0.988736f }, { 0.140967f, -0.112071f, -0.983651f },
  { 0.140968f, -0.112071f, 0.98365f }, { 0.14527f, 0.201213f, -0.968716f },
  { 0.14527f, 0.201214f, 0.968715f }, { 0.152322f, -0.059633f, 0.98653f },
  { 0.152322f, -0.059633f, -0.98653f }, { 0.413809f, 0.910357f, -0.00362f },
  { 0.427861f, 0.78985f, 0.4394f }, { 0.42951f, 0.789853f, -0.437782f },
  { 0.466243f, 0.876943f, 0.116568f }, { 0.467925f, 0.876101f, -0.116156f },
  { 0.472255f, -0.621163f, -0.625405f }, { 0.479486f, -0.619926f, 0.621116f },
  { 0.518273f, 0.642757f, -0.564142f }, { 0.519483f, 0.642265f, 0.563589f },
  { 0.543406f, -0.468085f, -0.696854f }, { 0.553606f, -0.477479f, 0.682301f },
  { 0.5674f, -0.337263f, 0.751206f }, { 0.575277f, -0.325814f, -0.750268f },
  { 0.640253f, 0.279855f, -0.715372f }, { 0.641728f, 0.269943f, 0.717855f },
  { 0.642437f, 0.24072f, 0.72755f }, { 0.642884f, 0.220449f, -0.733554f },
  { 0.655366f, -0.120632f, 0.745616f }, { 0.664351f, 0.0f, -0.74742f },
  { 0.664351f, 0.0f, 0.74742f }, { 0.664762f, 0.07995f, -0.742764f },
  { 0.666357f, 0.083301f, 0.740965f }, { 0.669463f, -0.119248f, -0.733211f },
  { 0.679425f, -0.147237f, 0.718821f }, { 0.687063f, -0.162618f, -0.708166f },
  { 0.702591f, -0.679631f, -0.210874f }, { 0.715313f, -0.668407f, 0.203862f },
  { 0.719527f, -0.69433f, 0.013685f }, { 0.825002f, 0.565129f, 0.001181f },
  { 0.83838f, -0.508662f, 0.195915f }, { 0.843687f, -0.504657f, -0.183065f },
  { 0.863288f, -0.390608f, 0.319624f }, { 0.872223f, -0.364324f, -0.326336f },
  { 0.874216f, -0.485522f, 0.003758f }, { 0.921778f, -0.387711f, 0.002219f },
  { 0.934347f, 0.297901f, -0.195575f }, { 0.937249f, 0.2891f, 0.194898f },
  { 0.957053f, 0.289913f, 0.0f }, { 0.957589f, -0.100605f, -0.270003f },
  { 0.958082f, -0.109276f, 0.264835f }, { 0.964915f, 0.203243f, 0.166226f },
  { 0.969674f, 0.183836f, -0.161048f }, { 0.97489f, -0.131628f, -0.179622f },
  { 0.977345f, -0.110912f, 0.180267f }, { 0.97772f, 0.079356f, 0.194336f },
  { 0.978445f, 0.076269f, -0.191907f }, { 0.98152f, 0.0f, -0.19136f },
  { 0.98152f, 0.0f, 0.19136f }, { 0.983634f, 0.180179f, 0.000183f },
  { 0.996046f, -0.088268f, -0.010061f }, { 0.997278f, 0.073735f, 0.0f },
  { 0.997754f, -0.065314f, -0.014876f }, { 1.0f, 0.0f, 0.0f }
};

TEST_TRIANGLE3 Monk_triangle3_Body[392] = {
  { { 261, 291, 283 }, { 58, 50, 28 } }, { { 291, 261, 262 }, { 50, 58, 69 } },
  { { 193, 262, 261 }, { 125, 69, 58 } }, { { 262, 193, 190 }, { 69, 125, 124 } },
  { { 148, 190, 193 }, { 95, 124, 125 } }, { { 190, 148, 147 }, { 124, 95, 118 } },
  { { 253, 283, 277 }, { 54, 28, 30 } }, { { 283, 253, 261 }, { 28, 54, 58 } },
  { { 181, 261, 253 }, { 130, 58, 54 } }, { { 261, 181, 193 }, { 58, 130, 125 } },
  { { 149, 193, 181 }, { 97, 125, 130 } }, { { 193, 149, 148 }, { 125, 97, 95 } },
  { { 228, 277, 273 }, { 62, 30, 40 } }, { { 277, 228, 253 }, { 30, 62, 54 } },
  { { 177, 253, 228 }, { 133, 54, 62 } }, { { 253, 177, 181 }, { 54, 133, 130 } },
  { { 150, 181, 177 }, { 93, 130, 133 } }, { { 181, 150, 149 }, { 130, 93, 97 } },
  { { 202, 273, 237 }, { 71, 40, 47 } }, { { 273, 202, 228 }, { 40, 71, 62 } },
  { { 175, 228, 202 }, { 131, 62, 71 } }, { { 228, 175, 177 }, { 62, 131, 133 } },
  { { 151, 177, 175 }, { 89, 133, 131 } }, { { 177, 151, 150 }, { 133, 89, 93 } },
  { { 185, 239, 209 }, { 67, 47, 43 } }, { { 239, 185, 203 }, { 47, 67, 71 } },
  { { 167, 202, 184 }, { 128, 71, 67 } }, { { 202, 167, 175 }, { 71, 128, 131 } },
  { { 154, 175, 167 }, { 91, 131, 128 } }, { { 175, 154, 151 }, { 131, 91, 89 } },
  { { 179, 207, 213 }, { 65, 43, 36 } }, { { 207, 179, 184 }, { 43, 65, 67 } },
  { { 165, 184, 179 }, { 119, 67, 65 } }, { { 184, 165, 167 }, { 67, 119, 128 } },
  { { 156, 167, 165 }, { 107, 128, 119 } }, { { 167, 156, 154 }, { 128, 107, 91 } },
  { { 194, 213, 224 }, { 55, 36, 39 } }, { { 213, 194, 179 }, { 36, 55, 65 } },
  { { 169, 179, 194 }, { 111, 65, 55 } }, { { 179, 169, 165 }, { 65, 111, 119 } },
  { { 157, 165, 169 }, { 110, 119, 111 } }, { { 165, 157, 156 }, { 119, 110, 107 } },
  { { 196, 224, 234 }, { 60, 39, 32 } }, { { 224, 196, 194 }, { 39, 60, 55 } },
  { { 172, 194, 196 }, { 103, 55, 60 } }, { { 194, 172, 169 }, { 55, 103, 111 } },
  { { 159, 169, 172 }, { 102, 111, 103 } }, { { 169, 159, 157 }, { 111, 102, 110 } },
  { { 197, 234, 236 }, { 64, 32, 33 } }, { { 234, 197, 196 }, { 32, 64, 60 } },
  { { 173, 196, 197 }, { 99, 60, 64 } }, { { 196, 173, 172 }, { 60, 99, 103 } },
  { { 161, 172, 173 }, { 99, 103, 99 } }, { { 172, 161, 159 }, { 103, 99, 102 } },
  { { 260, 288, 265 }, { 57, 51, 70 } }, { { 288, 260, 281 }, { 51, 57, 29 } },
  { { 192, 265, 189 }, { 126, 70, 123 } }, { { 265, 192, 260 }, { 70, 126, 57 } },
  { { 143, 189, 142 }, { 96, 123, 117 } }, { { 189, 143, 192 }, { 123, 96, 126 } },
  { { 252, 281, 260 }, { 53, 29, 57 } }, { { 281, 252, 276 }, { 29, 53, 35 } },
  { { 180, 260, 192 }, { 129, 57, 126 } }, { { 260, 180, 252 }, { 57, 129, 53 } },
  { { 144, 192, 143 }, { 98, 126, 96 } }, { { 192, 144, 180 }, { 126, 98, 129 } },
  { { 227, 276, 252 }, { 61, 35, 53 } }, { { 276, 227, 272 }, { 35, 61, 41 } },
  { { 176, 252, 180 }, { 134, 53, 129 } }, { { 252, 176, 227 }, { 53, 134, 61 } },
  { { 145, 180, 144 }, { 94, 129, 98 } }, { { 180, 145, 176 }, { 129, 94, 134 } },
  { { 201, 272, 227 }, { 72, 41, 61 } }, { { 272, 201, 242 }, { 41, 72, 46 } },
  { { 174, 227, 176 }, { 132, 61, 134 } }, { { 227, 174, 201 }, { 61, 132, 72 } },
  { { 146, 176, 145 }, { 90, 134, 94 } }, { { 176, 146, 174 }, { 134, 90, 132 } },
  { { 182, 241, 200 }, { 68, 46, 72 } }, { { 241, 182, 205 }, { 46, 68, 42 } },
  { { 166, 201, 174 }, { 127, 72, 132 } }, { { 201, 166, 183 }, { 72, 127, 68 } },
  { { 153, 174, 146 }, { 92, 132, 90 } }, { { 174, 153, 166 }, { 132, 92, 127 } },
  { { 178, 206, 183 }, { 66, 42, 68 } }, { { 206, 178, 211 }, { 42, 66, 37 } },
  { { 164, 183, 166 }, { 120, 68, 127 } }, { { 183, 164, 178 }, { 68, 120, 66 } },
  { { 155, 166, 153 }, { 108, 127, 92 } }, { { 166, 155, 164 }, { 127, 108, 120 } },
  { { 195, 211, 178 }, { 56, 37, 66 } }, { { 211, 195, 226 }, { 37, 56, 38 } },
  { { 168, 178, 164 }, { 112, 66, 120 } }, { { 178, 168, 195 }, { 66, 112, 56 } },
  { { 158, 164, 155 }, { 114, 120, 108 } }, { { 164, 158, 168 }, { 120, 114, 112 } },
  { { 198, 226, 195 }, { 59, 38, 56 } }, { { 226, 198, 230 }, { 38, 59, 31 } },
  { { 170, 195, 168 }, { 104, 56, 112 } }, { { 195, 170, 198 }, { 56, 104, 59 } },
  { { 160, 168, 158 }, { 106, 112, 114 } }, { { 168, 160, 170 }, { 112, 106, 104 } },
  { { 199, 230, 198 }, { 63, 31, 59 } }, { { 230, 199, 232 }, { 31, 63, 34 } },
  { { 171, 198, 170 }, { 100, 59, 104 } }, { { 198, 171, 199 }, { 59, 100, 63 } },
  { { 162, 170, 160 }, { 100, 104, 106 } }, { { 170, 162, 171 }, { 104, 100, 100 } },
  { { 269, 292, 263 }, { 163, 50, 69 } }, { { 290, 268, 302 }, { 50, 163, 48 } },
  { { 187, 263, 191 }, { 86, 69, 124 } }, { { 263, 187, 269 }, { 69, 86, 163 } },
  { { 163, 191, 147 }, { 116, 124, 118 } }, { { 191, 163, 187 }, { 124, 116, 86 } },
  { { 270, 302, 268 }, { 183, 48, 163 } }, { { 302, 270, 304 }, { 48, 183, 52 } },
  { { 266, 304, 270 }, { 162, 52, 183 } }, { { 304, 266, 300 }, { 52, 162, 49 } },
  { { 286, 300, 266 }, { 51, 49, 162 } }, { { 267, 264, 287 }, { 162, 70, 51 } },
  { { 188, 267, 186 }, { 123, 162, 85 } }, { { 267, 188, 264 }, { 162, 123, 70 } },
  { { 142, 186, 152 }, { 117, 85, 115 } }, { { 186, 142, 188 }, { 85, 117, 123 } },
  { { 250, 235, 233 }, { 7, 33, 32 } }, { { 235, 250, 251 }, { 33, 7, 5 } },
  { { 245, 233, 223 }, { 17, 32, 39 } }, { { 233, 245, 250 }, { 32, 17, 7 } },
  { { 216, 223, 212 }, { 11, 39, 36 } }, { { 223, 216, 245 }, { 39, 11, 17 } },
  { { 221, 212, 208 }, { 22, 36, 43 } }, { { 212, 221, 216 }, { 36, 22, 11 } },
  { { 255, 209, 239 }, { 27, 43, 47 } }, { { 209, 255, 222 }, { 43, 27, 22 } },
  { { 279, 238, 274 }, { 20, 47, 40 } }, { { 238, 279, 254 }, { 47, 20, 27 } },
  { { 297, 274, 278 }, { 14, 40, 30 } }, { { 274, 297, 279 }, { 40, 14, 20 } },
  { { 295, 278, 284 }, { 10, 30, 28 } }, { { 278, 295, 297 }, { 30, 10, 14 } },
  { { 303, 284, 293 }, { 48, 28, 50 } }, { { 284, 303, 295 }, { 28, 48, 10 } },
  { { 248, 251, 250 }, { 2, 5, 7 } }, { { 251, 248, 249 }, { 5, 2, 0 } },
  { { 244, 250, 245 }, { 15, 7, 17 } }, { { 250, 244, 248 }, { 7, 15, 2 } },
  { { 215, 245, 216 }, { 4, 17, 11 } }, { { 245, 215, 244 }, { 17, 4, 15 } },
  { { 217, 216, 221 }, { 19, 11, 22 } }, { { 216, 217, 215 }, { 11, 19, 4 } },
  { { 259, 222, 255 }, { 25, 22, 27 } }, { { 222, 259, 218 }, { 22, 25, 19 } },
  { { 285, 254, 279 }, { 18, 27, 20 } }, { { 254, 285, 258 }, { 27, 18, 25 } },
  { { 299, 279, 297 }, { 1, 20, 14 } }, { { 279, 299, 285 }, { 20, 1, 18 } },
  { { 298, 297, 295 }, { 3, 14, 10 } }, { { 297, 298, 299 }, { 14, 3, 1 } },
  { { 305, 295, 303 }, { 52, 10, 48 } }, { { 295, 305, 298 }, { 10, 52, 3 } },
  { { 246, 249, 248 }, { 8, 0, 2 } }, { { 249, 246, 247 }, { 0, 8, 6 } },
  { { 243, 248, 244 }, { 16, 2, 15 } }, { { 248, 243, 246 }, { 2, 16, 8 } },
  { { 214, 244, 215 }, { 12, 15, 4 } }, { { 244, 214, 243 }, { 15, 12, 16 } },
  { { 219, 215, 217 }, { 23, 4, 19 } }, { { 215, 219, 214 }, { 4, 23, 12 } },
  { { 257, 218, 259 }, { 26, 19, 25 } }, { { 218, 257, 220 }, { 19, 26, 23 } },
  { { 280, 258, 285 }, { 21, 25, 18 } }, { { 258, 280, 256 }, { 25, 21, 26 } },
  { { 296, 285, 299 }, { 13, 18, 1 } }, { { 285, 296, 280 }, { 18, 13, 21 } },
  { { 294, 299, 298 }, { 9, 1, 3 } }, { { 299, 294, 296 }, { 1, 9, 13 } },
  { { 301, 298, 305 }, { 49, 3, 52 } }, { { 298, 301, 294 }, { 3, 49, 9 } },
  { { 229, 247, 246 }, { 31, 6, 8 } }, { { 247, 229, 231 }, { 6, 31, 34 } },
  { { 225, 246, 243 }, { 38, 8, 16 } }, { { 246, 225, 229 }, { 8, 38, 31 } },
  { { 210, 243, 214 }, { 37, 16, 12 } }, { { 243, 210, 225 }, { 16, 37, 38 } },
  { { 204, 214, 219 }, { 42, 12, 23 } }, { { 214, 204, 210 }, { 12, 42, 37 } },
  { { 241, 220, 257 }, { 46, 23, 26 } }, { { 220, 241, 205 }, { 23, 46, 42 } },
  { { 271, 256, 280 }, { 41, 26, 21 } }, { { 256, 271, 240 }, { 26, 41, 46 } },
  { { 275, 280, 296 }, { 35, 21, 13 } }, { { 280, 275, 271 }, { 21, 35, 41 } },
  { { 282, 296, 294 }, { 29, 13, 9 } }, { { 296, 282, 275 }, { 13, 29, 35 } },
  { { 289, 294, 301 }, { 51, 9, 49 } }, { { 294, 289, 282 }, { 9, 51, 29 } },
  { { 18, 45, 24 }, { 157, 149, 179 } }, { { 45, 18, 43 }, { 149, 157, 138 } },
  { { 43, 113, 45 }, { 138, 82, 149 } }, { { 113, 43, 117 }, { 82, 138, 83 } },
  { { 117, 148, 113 }, { 83, 95, 82 } }, { { 148, 117, 147 }, { 95, 83, 118 } },
  { { 24, 52, 30 }, { 179, 154, 177 } }, { { 52, 24, 45 }, { 154, 179, 149 } },
  { { 45, 124, 52 }, { 149, 77, 154 } }, { { 124, 45, 113 }, { 77, 149, 82 } },
  { { 113, 149, 124 }, { 82, 97, 77 } }, { { 149, 113, 148 }, { 97, 82, 95 } },
  { { 30, 78, 34 }, { 177, 145, 167 } }, { { 78, 30, 52 }, { 145, 177, 154 } },
  { { 52, 129, 78 }, { 154, 74, 145 } }, { { 129, 52, 124 }, { 74, 154, 77 } },
  { { 124, 150, 129 }, { 77, 93, 74 } }, { { 150, 124, 149 }, { 93, 77, 97 } },
  { { 34, 105, 68 }, { 167, 136, 160 } }, { { 105, 34, 78 }, { 136, 167, 145 } },
  { { 78, 131, 105 }, { 145, 76, 136 } }, { { 131, 78, 129 }, { 76, 145, 74 } },
  { { 129, 151, 131 }, { 74, 89, 76 } }, { { 151, 129, 150 }, { 89, 74, 93 } },
  { { 66, 122, 99 }, { 160, 140, 164 } }, { { 122, 66, 104 }, { 140, 160, 136 } },
  { { 105, 139, 123 }, { 136, 79, 140 } }, { { 139, 105, 131 }, { 79, 136, 76 } },
  { { 131, 154, 139 }, { 76, 91, 79 } }, { { 154, 131, 151 }, { 91, 76, 89 } },
  { { 101, 127, 94 }, { 164, 142, 171 } }, { { 127, 101, 123 }, { 142, 164, 140 } },
  { { 123, 141, 127 }, { 140, 88, 142 } }, { { 141, 123, 139 }, { 88, 140, 79 } },
  { { 139, 156, 141 }, { 79, 107, 88 } }, { { 156, 139, 154 }, { 107, 79, 91 } },
  { { 94, 111, 81 }, { 171, 151, 168 } }, { { 111, 94, 127 }, { 151, 171, 142 } },
  { { 127, 137, 111 }, { 142, 109, 151 } }, { { 137, 127, 141 }, { 109, 142, 88 } },
  { { 141, 157, 137 }, { 88, 110, 109 } }, { { 157, 141, 156 }, { 110, 88, 107 } },
  { { 81, 108, 73 }, { 168, 147, 175 } }, { { 108, 81, 111 }, { 147, 168, 151 } },
  { { 111, 134, 108 }, { 151, 101, 147 } }, { { 134, 111, 137 }, { 101, 151, 109 } },
  { { 137, 159, 134 }, { 109, 102, 101 } }, { { 159, 137, 157 }, { 102, 109, 110 } },
  { { 73, 109, 75 }, { 175, 143, 173 } }, { { 109, 73, 108 }, { 143, 175, 147 } },
  { { 108, 135, 109 }, { 147, 99, 143 } }, { { 135, 108, 134 }, { 99, 147, 101 } },
  { { 134, 161, 135 }, { 101, 99, 99 } }, { { 161, 134, 159 }, { 99, 101, 102 } },
  { { 13, 44, 40 }, { 156, 150, 137 } }, { { 44, 13, 22 }, { 150, 156, 178 } },
  { { 40, 112, 114 }, { 137, 81, 84 } }, { { 112, 40, 44 }, { 81, 137, 150 } },
  { { 114, 143, 142 }, { 84, 96, 117 } }, { { 143, 114, 112 }, { 96, 84, 81 } },
  { { 22, 53, 44 }, { 178, 153, 150 } }, { { 53, 22, 27 }, { 153, 178, 172 } },
  { { 44, 125, 112 }, { 150, 78, 81 } }, { { 125, 44, 53 }, { 78, 150, 153 } },
  { { 112, 144, 143 }, { 81, 98, 96 } }, { { 144, 112, 125 }, { 98, 81, 78 } },
  { { 27, 77, 53 }, { 172, 146, 153 } }, { { 77, 27, 31 }, { 146, 172, 166 } },
  { { 53, 128, 125 }, { 153, 73, 78 } }, { { 128, 53, 77 }, { 73, 153, 146 } },
  { { 125, 145, 144 }, { 78, 94, 98 } }, { { 145, 125, 128 }, { 94, 78, 73 } },
  { { 31, 103, 77 }, { 166, 135, 146 } }, { { 103, 31, 64 }, { 135, 166, 161 } },
  { { 77, 130, 128 }, { 146, 75, 73 } }, { { 130, 77, 103 }, { 75, 146, 135 } },
  { { 128, 146, 145 }, { 73, 90, 94 } }, { { 146, 128, 130 }, { 90, 73, 75 } },
  { { 63, 120, 102 }, { 161, 139, 135 } }, { { 120, 63, 96 }, { 139, 161, 165 } },
  { { 103, 138, 130 }, { 135, 80, 75 } }, { { 138, 103, 121 }, { 80, 135, 139 } },
  { { 130, 153, 146 }, { 75, 92, 90 } }, { { 153, 130, 138 }, { 92, 75, 80 } },
  { { 97, 126, 121 }, { 165, 141, 139 } }, { { 126, 97, 92 }, { 141, 165, 170 } },
  { { 121, 140, 138 }, { 139, 87, 80 } }, { { 140, 121, 126 }, { 87, 139, 141 } },
  { { 138, 155, 153 }, { 80, 108, 92 } }, { { 155, 138, 140 }, { 108, 80, 87 } },
  { { 92, 110, 126 }, { 170, 152, 141 } }, { { 110, 92, 79 }, { 152, 170, 169 } },
  { { 126, 136, 140 }, { 141, 113, 87 } }, { { 136, 126, 110 }, { 113, 141, 152 } },
  { { 140, 158, 155 }, { 87, 114, 108 } }, { { 158, 140, 136 }, { 114, 87, 113 } },
  { { 79, 106, 110 }, { 169, 148, 152 } }, { { 106, 79, 69 }, { 148, 169, 176 } },
  { { 110, 132, 136 }, { 152, 105, 113 } }, { { 132, 110, 106 }, { 105, 152, 148 } },
  { { 136, 160, 158 }, { 113, 106, 114 } }, { { 160, 136, 132 }, { 106, 113, 105 } },
  { { 69, 107, 106 }, { 176, 144, 148 } }, { { 107, 69, 71 }, { 144, 176, 174 } },
  { { 106, 133, 132 }, { 148, 100, 105 } }, { { 133, 106, 107 }, { 100, 148, 144 } },
  { { 132, 162, 160 }, { 105, 100, 106 } }, { { 162, 132, 133 }, { 100, 105, 100 } },
  { { 17, 36, 42 }, { 157, 44, 138 } }, { { 37, 19, 5 }, { 44, 157, 159 } },
  { { 42, 118, 116 }, { 138, 121, 83 } }, { { 118, 42, 36 }, { 121, 138, 44 } },
  { { 116, 163, 147 }, { 83, 116, 118 } }, { { 163, 116, 118 }, { 116, 83, 121 } },
  { { 5, 35, 37 }, { 159, 24, 44 } }, { { 35, 5, 1 }, { 24, 159, 155 } },
  { { 1, 39, 35 }, { 155, 45, 24 } }, { { 39, 1, 3 }, { 45, 155, 158 } },
  { { 14, 41, 38 }, { 156, 137, 45 } }, { { 39, 3, 15 }, { 45, 158, 156 } },
  { { 38, 115, 119 }, { 45, 84, 122 } }, { { 115, 38, 41 }, { 84, 45, 137 } },
  { { 119, 142, 152 }, { 122, 117, 115 } }, { { 142, 119, 115 }, { 117, 122, 84 } },
  { { 76, 58, 74 }, { 173, 200, 175 } }, { { 58, 76, 59 }, { 200, 173, 201 } },
  { { 74, 62, 82 }, { 175, 190, 168 } }, { { 62, 74, 58 }, { 190, 175, 200 } },
  { { 82, 91, 95 }, { 168, 196, 171 } }, { { 91, 82, 62 }, { 196, 168, 190 } },
  { { 95, 86, 100 }, { 171, 185, 164 } }, { { 86, 95, 91 }, { 185, 171, 196 } },
  { { 99, 50, 66 }, { 164, 180, 160 } }, { { 50, 99, 85 }, { 180, 164, 185 } },
  { { 67, 25, 33 }, { 160, 187, 167 } }, { { 25, 67, 51 }, { 187, 160, 180 } },
  { { 33, 9, 29 }, { 167, 193, 177 } }, { { 9, 33, 25 }, { 193, 167, 187 } },
  { { 29, 11, 23 }, { 177, 197, 179 } }, { { 11, 29, 9 }, { 197, 177, 193 } },
  { { 23, 4, 16 }, { 179, 159, 157 } }, { { 4, 23, 11 }, { 159, 179, 197 } },
  { { 59, 56, 58 }, { 201, 205, 200 } }, { { 56, 59, 57 }, { 205, 201, 207 } },
  { { 58, 61, 62 }, { 200, 192, 190 } }, { { 61, 58, 56 }, { 192, 200, 205 } },
  { { 62, 90, 91 }, { 190, 203, 196 } }, { { 90, 62, 61 }, { 203, 190, 192 } },
  { { 91, 88, 86 }, { 196, 188, 185 } }, { { 88, 91, 90 }, { 188, 196, 203 } },
  { { 85, 46, 50 }, { 185, 182, 180 } }, { { 46, 85, 87 }, { 182, 185, 188 } },
  { { 51, 20, 25 }, { 180, 189, 187 } }, { { 20, 51, 47 }, { 189, 180, 182 } },
  { { 25, 6, 9 }, { 187, 206, 193 } }, { { 6, 25, 20 }, { 206, 187, 189 } },
  { { 9, 7, 11 }, { 193, 204, 197 } }, { { 7, 9, 6 }, { 204, 193, 206 } },
  { { 11, 0, 4 }, { 197, 155, 159 } }, { { 0, 11, 7 }, { 155, 197, 204 } },
  { { 57, 54, 56 }, { 207, 199, 205 } }, { { 54, 57, 55 }, { 199, 207, 202 } },
  { { 56, 60, 61 }, { 205, 191, 192 } }, { { 60, 56, 54 }, { 191, 205, 199 } },
  { { 61, 89, 90 }, { 192, 195, 203 } }, { { 89, 61, 60 }, { 195, 192, 191 } },
  { { 90, 84, 88 }, { 203, 184, 188 } }, { { 84, 90, 89 }, { 184, 203, 195 } },
  { { 87, 48, 46 }, { 188, 181, 182 } }, { { 48, 87, 83 }, { 181, 188, 184 } },
  { { 47, 26, 20 }, { 182, 186, 189 } }, { { 26, 47, 49 }, { 186, 182, 181 } },
  { { 20, 8, 6 }, { 189, 194, 206 } }, { { 8, 20, 26 }, { 194, 189, 186 } },
  { { 6, 10, 7 }, { 206, 198, 204 } }, { { 10, 6, 8 }, { 198, 206, 194 } },
  { { 7, 2, 0 }, { 204, 158, 155 } }, { { 2, 7, 10 }, { 158, 204, 198 } },
  { { 55, 70, 54 }, { 202, 176, 199 } }, { { 70, 55, 72 }, { 176, 202, 174 } },
  { { 54, 80, 60 }, { 199, 169, 191 } }, { { 80, 54, 70 }, { 169, 199, 176 } },
  { { 60, 93, 89 }, { 191, 170, 195 } }, { { 93, 60, 80 }, { 170, 191, 169 } },
  { { 89, 98, 84 }, { 195, 165, 184 } }, { { 98, 89, 93 }, { 165, 195, 170 } },
  { { 83, 63, 48 }, { 184, 161, 181 } }, { { 63, 83, 96 }, { 161, 184, 165 } },
  { { 49, 32, 26 }, { 181, 166, 186 } }, { { 32, 49, 65 }, { 166, 181, 161 } },
  { { 26, 28, 8 }, { 186, 172, 194 } }, { { 28, 26, 32 }, { 172, 186, 166 } },
  { { 8, 21, 10 }, { 194, 178, 198 } }, { { 21, 8, 28 }, { 178, 194, 172 } },
  { { 10, 12, 2 }, { 198, 156, 158 } }, { { 12, 10, 21 }, { 156, 198, 178 } }
};

float Monk_matrix_Head[16] = {
  0.0f, 0.0f, -0.309686f, 0.774218f,
  -0.160459f, 0.0f, 0.0f, -12.32059f,
  0.0f, 0.160459f, 0.0f, 188.5021f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Head[34] = {
  { -7.500001f, -12.499862f, 0.000000f, 0.0f, 0.0f },
  { 12.499997f, -12.499863f, 0.000000f, 0.0f, 0.0f },
  { 2.500001f, 7.500088f, 0.000000f, 0.0f, 0.0f },
  { -7.499997f, 17.500112f, 0.000000f, 0.0f, 0.0f },
  { -7.500001f, -12.499863f, 4.999999f, 0.0f, 0.0f },
  { 12.499997f, -12.499864f, 5.0f, 0.0f, 0.0f },
  { 2.5f, 7.500087f, 5.0f, 0.0f, 0.0f },
  { -7.499998f, 17.500111f, 5.0f, 0.0f, 0.0f },
  { -41.894781f, -55.922876f, 22.975359f, 0.0f, 0.0f },
  { -18.027585f, -69.850768f, 9.565706f, 0.0f, 0.0f },
  { -18.027578f, -69.850765f, -4.565702f, 0.0f, 0.0f },
  { -41.894779f, -55.922867f, -17.369555f, 0.0f, 0.0f },
  { -14.780948f, -21.114937f, 26.052181f, 0.0f, 0.0f },
  { -7.499998f, -25.968928f, 12.111234f, 0.0f, 0.0f },
  { -7.500002f, -25.968923f, -7.111231f, 0.0f, 0.0f },
  { -14.780949f, -21.114926f, -21.052182f, 0.0f, 0.0f },
  { -14.780949f, 22.176179f, 26.052184f, 0.0f, 0.0f },
  { -7.500003f, 27.030176f, 12.111234f, 0.0f, 0.0f },
  { -7.500007f, 27.03018f, -7.111233f, 0.0f, 0.0f },
  { -14.78095f, 22.176095f, -21.052184f, 0.0f, 0.0f },
  { -25.28051f, 55.313886f, 22.369553f, 0.0f, 0.0f },
  { -23.450382f, 64.812289f, 9.565702f, 0.0f, 0.0f },
  { -23.450392f, 64.812292f, -4.565704f, 0.0f, 0.0f },
  { -25.280517f, 55.3138f, -17.369556f, 0.0f, 0.0f },
  { -41.118045f, -72.521205f, 9.888556f, 0.0f, 0.0f },
  { -41.118046f, -72.521202f, -4.888552f, 0.0f, 0.0f },
  { -39.561415f, -22.953953f, -23.053152f, 0.0f, 0.0f },
  { -39.561422f, 24.015125f, -23.053156f, 0.0f, 0.0f },
  { -41.894786f, 56.984037f, -17.975362f, 0.0f, 0.0f },
  { -41.118053f, 67.482732f, -4.888556f, 0.0f, 0.0f },
  { -41.118055f, 67.482728f, 9.888554f, 0.0f, 0.0f },
  { -41.894788f, 56.984123f, 22.975359f, 0.0f, 0.0f },
  { -39.561416f, 24.015209f, 28.053152f, 0.0f, 0.0f },
  { -39.561412f, -22.953964f, 28.053152f, 0.0f, 0.0f }
};


TEST_NORMAL Monk_normal_Head[34] = {
  { 0.0f, -0.707107f, -0.707107f }, { 0.0f, -0.707107f, 0.707107f },
  { 0.079808f, 0.076359f, -0.993881f }, { 0.08641f, 0.084246f, 0.992691f },
  { 0.08641f, -0.084246f, 0.992691f }, { 0.087036f, -0.093665f, -0.991792f },
  { 0.090705f, 0.507326f, 0.856967f }, { 0.091549f, 0.519655f, -0.849457f },
  { 0.109176f, -0.890645f, -0.441398f }, { 0.109595f, -0.895476f, 0.431406f },
  { 0.139874f, 0.935846f, 0.323462f }, { 0.146983f, 0.932584f, -0.32967f },
  { 0.194004f, -0.381798f, -0.903655f }, { 0.20547f, -0.383723f, 0.900299f },
  { 0.4226f, 0.466285f, 0.777166f }, { 0.423459f, 0.477941f, -0.769581f },
  { 0.544513f, -0.110112f, -0.831493f }, { 0.54627f, -0.107353f, 0.830702f },
  { 0.553651f, 0.111219f, 0.825289f }, { 0.555505f, 0.108754f, -0.824371f },
  { 0.564801f, 0.777968f, -0.275255f }, { 0.567742f, 0.77738f, 0.27083f },
  { 0.589362f, -0.692668f, -0.415768f }, { 0.591842f, -0.693554f, 0.410739f },
  { 0.6002f, 0.4326f, -0.672768f }, { 0.600201f, 0.4326f, 0.672768f },
  { 0.632456f, 0.632455f, -0.447213f }, { 0.632457f, 0.632455f, 0.447213f },
  { 0.706586f, -0.436694f, 0.556808f }, { 0.706586f, -0.436693f, -0.556808f },
  { 0.947651f, 0.198891f, -0.249798f }, { 0.947652f, 0.198891f, 0.249798f },
  { 0.958035f, -0.129432f, 0.255766f }, { 0.958035f, -0.129431f, -0.255766f }
};

TEST_TRIANGLE3 Monk_triangle3_Head[48] = {
  { { 5, 1, 0 }, { 28, 29, 0 } }, { { 4, 5, 0 }, { 1, 28, 0 } },
  { { 6, 2, 1 }, { 25, 24, 29 } }, { { 5, 6, 1 }, { 28, 25, 29 } },
  { { 7, 3, 2 }, { 27, 26, 24 } }, { { 6, 7, 2 }, { 25, 27, 24 } },
  { { 3, 0, 2 }, { 26, 0, 24 } }, { { 2, 0, 1 }, { 24, 0, 29 } },
  { { 4, 7, 6 }, { 1, 27, 25 } }, { { 4, 6, 5 }, { 1, 25, 28 } },
  { { 12, 9, 8 }, { 17, 23, 13 } }, { { 9, 12, 13 }, { 23, 17, 32 } },
  { { 14, 10, 9 }, { 33, 22, 23 } }, { { 9, 13, 14 }, { 23, 32, 33 } },
  { { 15, 11, 10 }, { 16, 12, 22 } }, { { 10, 14, 15 }, { 22, 33, 16 } },
  { { 17, 13, 12 }, { 31, 32, 17 } }, { { 12, 16, 17 }, { 17, 18, 31 } },
  { { 18, 14, 13 }, { 30, 33, 32 } }, { { 13, 17, 18 }, { 32, 31, 30 } },
  { { 19, 15, 14 }, { 19, 16, 33 } }, { { 14, 18, 19 }, { 33, 30, 19 } },
  { { 21, 17, 20 }, { 21, 31, 14 } }, { { 16, 20, 17 }, { 18, 14, 31 } },
  { { 22, 18, 17 }, { 20, 30, 31 } }, { { 17, 21, 22 }, { 31, 21, 20 } },
  { { 23, 18, 22 }, { 15, 30, 20 } }, { { 18, 23, 19 }, { 30, 15, 19 } },
  { { 9, 24, 8 }, { 23, 9, 13 } }, { { 10, 25, 24 }, { 22, 8, 9 } },
  { { 24, 9, 10 }, { 9, 23, 22 } }, { { 25, 10, 11 }, { 8, 22, 12 } },
  { { 15, 26, 11 }, { 16, 5, 12 } }, { { 19, 27, 26 }, { 19, 2, 5 } },
  { { 26, 15, 19 }, { 5, 16, 19 } }, { { 23, 28, 27 }, { 15, 7, 2 } },
  { { 27, 19, 23 }, { 2, 19, 15 } }, { { 22, 29, 28 }, { 20, 11, 7 } },
  { { 28, 23, 22 }, { 7, 15, 20 } }, { { 21, 30, 29 }, { 21, 10, 11 } },
  { { 29, 22, 21 }, { 11, 20, 21 } }, { { 20, 31, 30 }, { 14, 6, 10 } },
  { { 30, 21, 20 }, { 10, 21, 14 } }, { { 16, 32, 31 }, { 18, 3, 6 } },
  { { 31, 20, 16 }, { 6, 14, 18 } }, { { 12, 33, 32 }, { 17, 4, 3 } },
  { { 32, 16, 12 }, { 3, 18, 17 } }, { { 33, 12, 8 }, { 4, 17, 13 } }
};

float Monk_matrix_Hood[16] = {
  1.0f, 0.0f, 0.0f, 0.0f,
  0.0f, 0.0f, -1.0f, 7.071537f,
  0.0f, 1.0f, 0.0f, 188.5873f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Hood[200] = {
  { -12.686251f, -13.593765f, 4.345373f, 0.556926f, 0.352082f },
  { -12.686251f, -13.593765f, 10.0f, 0.556926f, 0.449285f },
  { -12.686251f, -13.593765f, 14.999999f, 0.556926f, 0.535235f },
  { -12.2475f, -7.500015f, 4.745705f, 0.452175f, 0.358963f },
  { -12.2475f, -7.500015f, 10.0f, 0.452175f, 0.449285f },
  { -12.2475f, -7.500015f, 15.000002f, 0.452175f, 0.535235f },
  { -12.075f, -13.125015f, -0.834731f, 0.507569f, 0.051131f },
  { -12.075f, -13.125015f, -0.834731f, 0.548869f, 0.263036f },
  { -12.075f, -13.125015f, 17.356451f, 0.051131f, 0.575742f },
  { -12.075f, -13.125015f, 17.356451f, 0.092431f, 0.051131f },
  { -12.075f, -13.125015f, 17.356451f, 0.548869f, 0.575742f },
  { -11.1225f, -7.500015f, 18.017338f, 0.147825f, 0.587103f },
  { -11.1225f, -7.500015f, 18.017338f, 0.452175f, 0.587103f },
  { -10.97341f, -7.045685f, -1.394344f, 0.444365f, 0.253416f },
  { -10.97341f, -7.045685f, -1.394344f, 0.488633f, 0.155635f },
  { -10.875f, -0.000015f, 4.745706f, 0.32325f, 0.358963f },
  { -10.874999f, -0.000015f, 10.000001f, 0.32325f, 0.449285f },
  { -10.874999f, -0.000015f, 15.000001f, 0.32325f, 0.535235f },
  { -10.509837f, 0.314316f, -1.003538f, 0.317847f, 0.260134f },
  { -10.15f, 6.888611f, 4.745706f, 0.204834f, 0.358963f },
  { -10.15f, 6.888626f, 10.000001f, 0.204834f, 0.449285f },
  { -10.15f, 6.888626f, 15.000001f, 0.204834f, 0.535235f },
  { -9.862501f, -0.000015f, 18.01734f, 0.27675f, 0.587103f },
  { -9.862501f, -0.000015f, 18.01734f, 0.32325f, 0.587103f },
  { -9.811886f, 6.949356f, -1.003537f, 0.20379f, 0.260134f },
  { -9.2125f, 6.888626f, 18.017338f, 0.204834f, 0.587103f },
  { -9.2125f, 6.888626f, 18.017338f, 0.395166f, 0.587103f },
  { -9.0625f, 11.555817f, 4.745706f, 0.124605f, 0.358963f },
  { -9.0625f, 11.555817f, 4.745706f, 0.455784f, 0.358963f },
  { -9.0625f, 11.555817f, 10.000001f, 0.124605f, 0.449285f },
  { -9.0625f, 11.555817f, 10.000001f, 0.455784f, 0.449285f },
  { -9.0625f, 11.555817f, 15.000001f, 0.124605f, 0.535235f },
  { -9.0625f, 11.555817f, 15.000001f, 0.455784f, 0.535235f },
  { -8.75f, 11.494644f, 18.750002f, 0.125657f, 0.599697f },
  { -8.75f, 11.494644f, 18.750002f, 0.149588f, 0.474343f },
  { -8.75f, 11.494644f, 18.750002f, 0.450412f, 0.599697f },
  { -8.75f, 11.494644f, 18.750002f, 0.474343f, 0.599697f },
  { -8.724386f, 11.473206f, -1.003537f, 0.126025f, 0.260134f },
  { -8.724386f, 11.473206f, -1.003537f, 0.449972f, 0.260134f },
  { -8.483761f, 1.049942f, -5.983692f, 0.305201f, 0.174525f },
  { -8.251538f, -3.646225f, -5.983693f, 0.158156f, 0.174525f },
  { -8.251538f, -3.646225f, -5.983693f, 0.385928f, 0.174525f },
  { -8.251538f, -3.646225f, -5.983693f, 0.441844f, 0.214072f },
  { -7.921363f, 6.397614f, -5.983692f, 0.213275f, 0.174525f },
  { -7.029969f, 10.054321f, -5.983692f, 0.150416f, 0.174525f },
  { -7.029969f, 10.054321f, -5.983692f, 0.420845f, 0.174525f },
  { -7.029969f, 10.054321f, -5.983692f, 0.420845f, 0.449584f },
  { -7.02375f, -13.593765f, -1.498884f, 0.420738f, 0.043074f },
  { -7.02375f, -13.593765f, 12.963342f, 0.179262f, 0.043074f },
  { -6.12375f, -7.500015f, 12.855682f, 0.147825f, 0.498374f },
  { -6.12375f, -7.500015f, 12.855682f, 0.194733f, 0.147825f },
  { -6.033381f, -8.338348f, -2.595666f, 0.403714f, 0.133414f },
  { -5.437499f, -0.000015f, 12.855683f, 0.206529f, 0.27675f },
  { -5.437499f, -0.000015f, 12.855683f, 0.27675f, 0.498374f },
  { -5.075f, 7.499985f, 13.900843f, 0.212761f, 0.405675f },
  { -5.075f, 7.499985f, 13.900843f, 0.405675f, 0.51634f },
  { -5.0f, 13.372009f, 18.01734f, 0.21405f, 0.506615f },
  { -5.0f, 13.372009f, 18.01734f, 0.38595f, 0.587103f },
  { -5.0f, 14.778259f, 4.745706f, 0.38595f, 0.358963f },
  { -5.0f, 14.778259f, 10.000001f, 0.38595f, 0.449285f },
  { -5.0f, 14.778259f, 15.000001f, 0.38595f, 0.535235f },
  { -4.898514f, -0.446915f, -11.064886f, 0.330932f, 0.087179f },
  { -4.830943f, 14.585403f, -1.003537f, 0.383044f, 0.260134f },
  { -4.830885f, -3.226074f, -11.064886f, 0.216957f, 0.087179f },
  { -4.830885f, -3.226074f, -11.064886f, 0.378706f, 0.087179f },
  { -4.679047f, -4.798874f, -5.983694f, 0.219567f, 0.174525f },
  { -4.679047f, -4.798874f, -5.983694f, 0.380433f, 0.194258f },
  { -4.570052f, 2.671585f, -11.064886f, 0.277325f, 0.087179f },
  { -4.105784f, 4.764496f, -11.064886f, 0.241348f, 0.087179f },
  { -4.105784f, 4.764496f, -11.064886f, 0.370578f, 0.358652f },
  { -3.899206f, 12.565796f, -5.983692f, 0.367027f, 0.174525f },
  { -3.899206f, 12.565796f, -5.983692f, 0.367027f, 0.492756f },
  { -2.703609f, -3.826416f, -11.064886f, 0.253525f, 0.087179f },
  { -2.436291f, -4.473648f, -14.868771f, 0.25812f, 0.02179f },
  { -2.436291f, -4.473648f, -14.868771f, 0.34188f, 0.199848f },
  { -2.436291f, -4.473648f, -14.868771f, 0.400152f, 0.02179f },
  { -2.253007f, 6.217438f, -11.064886f, 0.338729f, 0.383628f },
  { -2.122366f, -3.328247f, -15.181271f, 0.336483f, 0.219538f },
  { -2.122366f, -3.328247f, -15.181271f, 0.380462f, 0.016418f },
  { -2.070366f, -0.444626f, -14.868771f, 0.330893f, 0.02179f },
  { -2.070366f, -0.444626f, -14.868771f, 0.33559f, 0.269107f },
  { -1.978083f, -1.848022f, -15.181271f, 0.334003f, 0.244983f },
  { -1.978083f, -1.848022f, -15.181271f, 0.355017f, 0.016418f },
  { -1.244627f, -4.680908f, -15.181271f, 0.278605f, 0.016418f },
  { -1.052236f, -0.432831f, -15.181271f, 0.318088f, 0.26931f },
  { -0.872684f, -4.099014f, -16.118771f, 0.284999f, 0.000303f },
  { -0.872684f, -4.099014f, -16.118771f, 0.315001f, 0.206288f },
  { -0.814505f, -2.895325f, -16.118771f, 0.314001f, 0.22698f },
  { -0.000001f, -2.832779f, -16.118771f, 0.3f, 0.228055f },
  { -0.000001f, -4.099014f, -16.118771f, 0.3f, 0.206288f },
  { -0.000001f, -4.099014f, -16.118771f, 0.3f, 0.000303f },
  { -0.000001f, -0.147522f, -15.181271f, 0.3f, 0.274214f },
  { -0.000001f, -4.680908f, -15.181271f, 0.3f, 0.016418f },
  { -0.000001f, 6.915802f, -11.064886f, 0.3f, 0.395633f },
  { 0.000000f, -3.826416f, -11.064886f, 0.3f, 0.087179f },
  { 0.000000f, 13.729355f, -5.983692f, 0.3f, 0.174525f },
  { 0.000000f, 13.729355f, -5.983692f, 0.3f, 0.512758f },
  { 0.000000f, 16.03566f, -1.003538f, 0.3f, 0.260134f },
  { 0.000000f, -4.798874f, -5.983694f, 0.3f, 0.194258f },
  { 0.000000f, -4.798874f, -5.983694f, 0.3f, 0.174525f },
  { 0.0f, 16.298782f, 4.745706f, 0.3f, 0.358963f },
  { 0.0f, -8.338348f, -2.595666f, 0.3f, 0.133414f },
  { 0.0f, -13.593765f, 11.91818f, 0.3f, 0.043074f },
  { 0.0f, -7.500015f, 11.810521f, 0.3f, 0.147825f },
  { 0.0f, -0.000015f, 11.810521f, 0.3f, 0.27675f },
  { 0.0f, 7.889633f, 12.855682f, 0.3f, 0.412373f },
  { 0.0f, 14.502899f, 18.017342f, 0.3f, 0.587103f },
  { 0.0f, 14.502899f, 18.017342f, 0.3f, 0.526055f },
  { 0.0f, 16.298782f, 10.000001f, 0.3f, 0.449285f },
  { 0.0f, 16.298782f, 15.000001f, 0.3f, 0.535235f },
  { 0.0f, -13.593765f, -1.498884f, 0.3f, 0.043074f },
  { 0.814503f, -2.895325f, -16.118771f, 0.285999f, 0.22698f },
  { 0.872682f, -4.099014f, -16.118771f, 0.284999f, 0.206288f },
  { 0.872682f, -4.099014f, -16.118771f, 0.315001f, 0.000303f },
  { 1.052234f, -0.432831f, -15.181271f, 0.281912f, 0.26931f },
  { 1.244626f, -4.680908f, -15.181271f, 0.321395f, 0.016418f },
  { 1.978081f, -1.848022f, -15.181271f, 0.244983f, 0.016418f },
  { 1.978081f, -1.848022f, -15.181271f, 0.265997f, 0.244983f },
  { 2.070365f, -0.444626f, -14.868771f, 0.26441f, 0.269107f },
  { 2.070365f, -0.444626f, -14.868771f, 0.269107f, 0.02179f },
  { 2.122364f, -3.328247f, -15.181271f, 0.219538f, 0.016418f },
  { 2.122364f, -3.328247f, -15.181271f, 0.263517f, 0.219538f },
  { 2.253006f, 6.217438f, -11.064886f, 0.261271f, 0.383628f },
  { 2.436289f, -4.473648f, -14.868771f, 0.199848f, 0.02179f },
  { 2.436289f, -4.473648f, -14.868771f, 0.25812f, 0.199848f },
  { 2.436289f, -4.473648f, -14.868771f, 0.34188f, 0.02179f },
  { 2.703608f, -3.826416f, -11.064886f, 0.346475f, 0.087179f },
  { 3.899206f, 12.565796f, -5.983692f, 0.232973f, 0.174525f },
  { 3.899206f, 12.565796f, -5.983692f, 0.232973f, 0.492756f },
  { 4.105783f, 4.764496f, -11.064886f, 0.229422f, 0.358652f },
  { 4.105783f, 4.764496f, -11.064886f, 0.358652f, 0.087179f },
  { 4.570049f, 2.671585f, -11.064886f, 0.322675f, 0.087179f },
  { 4.679047f, -4.798874f, -5.983694f, 0.219567f, 0.194258f },
  { 4.679047f, -4.798874f, -5.983694f, 0.380433f, 0.174525f },
  { 4.830884f, -3.226074f, -11.064886f, 0.221294f, 0.087179f },
  { 4.830884f, -3.226074f, -11.064886f, 0.383043f, 0.087179f },
  { 4.830943f, 14.585403f, -1.003537f, 0.216956f, 0.260134f },
  { 4.898512f, -0.446915f, -11.064886f, 0.269068f, 0.087179f },
  { 5.0f, 13.372009f, 18.01734f, 0.21405f, 0.587103f },
  { 5.0f, 13.372009f, 18.01734f, 0.38595f, 0.506615f },
  { 5.0f, 14.778259f, 4.745706f, 0.21405f, 0.358963f },
  { 5.0f, 14.778259f, 10.000001f, 0.21405f, 0.449285f },
  { 5.0f, 14.778259f, 15.000001f, 0.21405f, 0.535235f },
  { 5.075f, 7.499985f, 13.900843f, 0.194325f, 0.51634f },
  { 5.075f, 7.499985f, 13.900843f, 0.387239f, 0.405675f },
  { 5.4375f, -0.000015f, 12.855683f, 0.32325f, 0.498374f },
  { 5.4375f, -0.000015f, 12.855683f, 0.393471f, 0.27675f },
  { 6.033381f, -8.338348f, -2.595666f, 0.196286f, 0.133414f },
  { 6.12375f, -7.500015f, 12.855681f, 0.405267f, 0.147825f },
  { 6.12375f, -7.500015f, 12.855681f, 0.452175f, 0.498374f },
  { 7.02375f, -13.593765f, -1.498884f, 0.179262f, 0.043074f },
  { 7.02375f, -13.593765f, 12.963342f, 0.420738f, 0.043074f },
  { 7.02375f, -13.593765f, 12.963342f, 0.556926f, 0.500224f },
  { 7.029968f, 10.054321f, -5.983692f, 0.179155f, 0.174525f },
  { 7.029968f, 10.054321f, -5.983692f, 0.179155f, 0.449584f },
  { 7.029968f, 10.054321f, -5.983692f, 0.449584f, 0.174525f },
  { 7.921362f, 6.397614f, -5.983692f, 0.386725f, 0.174525f },
  { 8.251537f, -3.646225f, -5.983694f, 0.214072f, 0.174525f },
  { 8.251537f, -3.646225f, -5.983694f, 0.441844f, 0.174525f },
  { 8.483759f, 1.049942f, -5.983692f, 0.294799f, 0.174525f },
  { 8.724385f, 11.473206f, -1.003537f, 0.150028f, 0.260134f },
  { 8.724385f, 11.473206f, -1.003537f, 0.473975f, 0.260134f },
  { 8.75f, 11.494644f, 18.750002f, 0.125657f, 0.599697f },
  { 8.75f, 11.494644f, 18.750002f, 0.149587f, 0.599697f },
  { 8.75f, 11.494644f, 18.750002f, 0.450413f, 0.474343f },
  { 8.75f, 11.494644f, 18.750002f, 0.474343f, 0.599697f },
  { 9.0625f, 11.555817f, 4.745706f, 0.144215f, 0.358963f },
  { 9.0625f, 11.555817f, 4.745706f, 0.475395f, 0.358963f },
  { 9.0625f, 11.555817f, 10.000001f, 0.144215f, 0.449285f },
  { 9.0625f, 11.555817f, 10.000001f, 0.475395f, 0.449285f },
  { 9.0625f, 11.555817f, 15.000001f, 0.144215f, 0.535235f },
  { 9.0625f, 11.555817f, 15.000001f, 0.475395f, 0.535235f },
  { 9.212499f, 6.888626f, 18.017338f, 0.204834f, 0.587103f },
  { 9.212499f, 6.888626f, 18.017338f, 0.395166f, 0.587103f },
  { 9.811884f, 6.949356f, -1.003538f, 0.39621f, 0.260134f },
  { 9.8625f, -0.000015f, 18.01734f, 0.27675f, 0.587103f },
  { 9.8625f, -0.000015f, 18.01734f, 0.32325f, 0.587103f },
  { 10.149999f, 6.888611f, 4.745706f, 0.395166f, 0.358963f },
  { 10.149999f, 6.888626f, 10.000001f, 0.395166f, 0.449285f },
  { 10.149999f, 6.888626f, 15.000001f, 0.395166f, 0.535235f },
  { 10.509836f, 0.314316f, -1.003538f, 0.282153f, 0.260134f },
  { 10.874999f, -0.000015f, 4.745706f, 0.27675f, 0.358963f },
  { 10.874999f, -0.000015f, 10.000001f, 0.27675f, 0.449285f },
  { 10.874999f, -0.000015f, 15.000001f, 0.27675f, 0.535235f },
  { 10.973409f, -7.045685f, -1.394344f, 0.111367f, 0.155635f },
  { 10.973409f, -7.045685f, -1.394344f, 0.155635f, 0.253416f },
  { 10.973409f, -7.045685f, -1.394344f, 0.488633f, 0.253416f },
  { 11.122499f, -7.500015f, 18.017338f, 0.147825f, 0.587103f },
  { 11.122499f, -7.500015f, 18.017338f, 0.452175f, 0.587103f },
  { 11.122499f, -7.500015f, 18.017338f, 0.491196f, 0.147825f },
  { 12.074999f, -13.125015f, -0.834731f, 0.051131f, 0.263036f },
  { 12.074999f, -13.125015f, -0.834731f, 0.092431f, 0.051131f },
  { 12.074999f, -13.125015f, 17.356451f, 0.051131f, 0.575742f },
  { 12.074999f, -13.125015f, 17.356451f, 0.507569f, 0.051131f },
  { 12.247499f, -7.500015f, 4.745705f, 0.147825f, 0.358963f },
  { 12.247499f, -7.500015f, 10.0f, 0.147825f, 0.449285f },
  { 12.247499f, -7.500015f, 15.000001f, 0.147825f, 0.535235f },
  { 12.68625f, -13.593765f, 4.345373f, 0.043074f, 0.352082f },
  { 12.68625f, -13.593765f, 10.0f, 0.043074f, 0.449285f },
  { 12.68625f, -13.593765f, 14.999999f, 0.043074f, 0.535235f }
};


TEST_NORMAL Monk_normal_Hood[131] = {
  { -0.997418f, 0.071814f, 0.0f }, { -0.99217f, 0.099126f, -0.075979f },
  { -0.992018f, 0.1261f, 0.0f }, { -0.991242f, 0.07137f, 0.111109f },
  { -0.990154f, 0.113233f, -0.0823f }, { -0.989803f, 0.142442f, 0.0f },
  { -0.989321f, 0.143138f, -0.027472f }, { -0.986106f, 0.166119f, 0.0f },
  { -0.985638f, 0.166392f, -0.028836f }, { -0.976963f, 0.138373f, 0.162466f },
  { -0.976888f, 0.132995f, 0.167339f }, { -0.975576f, 0.161472f, 0.148926f },
  { -0.968769f, 0.103995f, -0.225105f }, { -0.96274f, 0.167167f, -0.212571f },
  { -0.870242f, 0.04944f, -0.490137f }, { -0.856206f, 0.154381f, -0.493029f },
  { -0.856181f, 0.513064f, 0.06099f }, { -0.845762f, 0.532821f, -0.02807f },
  { -0.844821f, 0.535048f, 0.0f }, { -0.819344f, 0.527323f, -0.224957f },
  { -0.816445f, -0.085984f, -0.570985f }, { -0.815022f, 0.034313f, -0.578413f },
  { -0.780617f, 0.051305f, -0.622901f }, { -0.780065f, 0.12691f, -0.612693f },
  { -0.711286f, 0.031843f, -0.702181f }, { -0.704107f, -0.550571f, -0.448446f },
  { -0.691138f, 0.455293f, -0.561281f }, { -0.671736f, -0.395852f, -0.626157f },
  { -0.63242f, 0.147736f, -0.760407f }, { -0.628796f, -0.660765f, -0.409885f },
  { -0.576042f, 0.342721f, -0.742104f }, { -0.53349f, 0.265277f, -0.803129f },
  { -0.482535f, -0.082864f, 0.871948f }, { -0.464428f, 0.885336f, -0.022039f },
  { -0.464354f, 0.88565f, 0.0f }, { -0.463799f, -0.051559f, 0.884439f },
  { -0.45386f, -0.079075f, 0.887557f }, { -0.453432f, 0.223944f, 0.862699f },
  { -0.450454f, 0.863959f, -0.22509f }, { -0.43225f, -0.307622f, 0.847661f },
  { -0.423443f, 0.890056f, 0.168807f }, { -0.413397f, -0.040958f, 0.909629f },
  { -0.367933f, 0.710931f, -0.599335f }, { -0.281031f, 0.139918f, -0.949444f },
  { -0.273634f, 0.51715f, -0.810975f }, { -0.269521f, 0.012217f, 0.962917f },
  { -0.252299f, -0.41697f, -0.873202f }, { -0.217765f, 0.385801f, -0.896513f },
  { -0.195186f, -0.006956f, 0.980742f }, { -0.179451f, 0.008871f, 0.983727f },
  { -0.138826f, -0.839831f, -0.524796f }, { -0.138237f, -0.422873f, -0.895583f },
  { -0.131818f, -0.990835f, -0.029489f }, { -0.124768f, -0.964776f, -0.231605f },
  { -0.079427f, -0.189283f, -0.978705f }, { -0.06522f, 0.304149f, 0.950389f },
  { -0.005408f, 0.012234f, 0.999911f }, { -0.005026f, 0.003664f, 0.999981f },
  { -0.004428f, -0.070131f, 0.997528f }, { -0.000583f, 0.973407f, -0.22908f },
  { -0.000402f, 0.999751f, -0.022331f }, { -0.000024f, 0.793019f, -0.609197f },
  { 0.0f, -0.99997f, 0.007789f }, { 0.0f, -0.984655f, -0.17451f },
  { 0.0f, -0.878455f, -0.477825f }, { 0.0f, -0.486127f, -0.873888f },
  { 0.0f, -0.465891f, -0.884842f }, { 0.0f, -0.204294f, -0.97891f },
  { 0.0f, 1.0f, 0.0f }, { 0.000418f, 0.558797f, -0.829305f },
  { 0.000787f, 0.43568f, -0.900101f }, { 0.004171f, -0.381301f, 0.924442f },
  { 0.00439f, 0.18005f, -0.983648f }, { 0.008584f, 0.969385f, 0.245397f },
  { 0.026244f, 0.296645f, 0.954627f }, { 0.108497f, -0.14955f, -0.982783f },
  { 0.13176f, -0.965249f, -0.225685f }, { 0.140848f, -0.989201f, -0.040532f },
  { 0.141792f, 0.316454f, 0.937951f }, { 0.158287f, -0.841479f, -0.516583f },
  { 0.167396f, -0.413389f, -0.895035f }, { 0.173372f, 0.041515f, 0.983981f },
  { 0.189096f, 0.400056f, -0.896771f }, { 0.219538f, -0.012131f, 0.975529f },
  { 0.240379f, -0.065814f, 0.968445f }, { 0.254318f, -0.414619f, -0.873735f },
  { 0.272225f, 0.519819f, -0.809742f }, { 0.283152f, 0.13652f, -0.949309f },
  { 0.367853f, 0.710887f, -0.599436f }, { 0.392214f, 0.328576f, 0.859189f },
  { 0.435979f, 0.876552f, 0.203909f }, { 0.436176f, -0.311811f, 0.844111f },
  { 0.436639f, -0.043358f, 0.898591f }, { 0.451422f, -0.054734f, 0.89063f },
  { 0.45151f, 0.86341f, -0.225084f }, { 0.460545f, -0.026258f, 0.887248f },
  { 0.464354f, 0.88565f, 0.0f }, { 0.465159f, 0.884952f, -0.022072f },
  { 0.485359f, -0.097467f, 0.868865f }, { 0.579104f, 0.264474f, -0.771163f },
  { 0.582554f, 0.341097f, -0.737756f }, { 0.613332f, -0.694742f, -0.37571f },
  { 0.677866f, 0.103818f, -0.727819f }, { 0.691097f, 0.455294f, -0.561331f },
  { 0.698185f, 0.038319f, -0.714891f }, { 0.700244f, -0.564017f, -0.437657f },
  { 0.700368f, -0.405488f, -0.587421f }, { 0.746927f, 0.043382f, -0.663489f },
  { 0.775001f, 0.128995f, -0.618655f }, { 0.807982f, -0.067048f, -0.58538f },
  { 0.813622f, 0.039485f, -0.580052f }, { 0.818388f, 0.528706f, -0.225191f },
  { 0.828164f, 0.556249f, 0.068791f }, { 0.844821f, 0.535048f, 0.0f },
  { 0.845156f, 0.533804f, -0.02766f }, { 0.855114f, 0.154573f, -0.49486f },
  { 0.878057f, 0.033149f, -0.477406f }, { 0.962823f, 0.166065f, -0.21306f },
  { 0.970711f, 0.072722f, -0.228982f }, { 0.977399f, 0.121049f, 0.173316f },
  { 0.977425f, 0.139335f, 0.158828f }, { 0.98188f, 0.141074f, 0.12653f },
  { 0.985784f, 0.165656f, -0.02807f }, { 0.986106f, 0.166119f, 0.0f },
  { 0.987065f, 0.136993f, -0.083276f }, { 0.987825f, 0.0918f, 0.125593f },
  { 0.989803f, 0.142442f, 0.0f }, { 0.99097f, 0.126549f, -0.044318f },
  { 0.992018f, 0.1261f, 0.0f }, { 0.995608f, 0.075335f, -0.055579f },
  { 0.997418f, 0.071814f, 0.0f }
};

TEST_TRIANGLE3 Monk_triangle3_Hood[244] = {
  { { 51, 14, 6 }, { 51, 20, 22 } }, { { 6, 47, 51 }, { 22, 54, 51 } },
  { { 101, 51, 47 }, { 66, 51, 54 } }, { { 47, 110, 101 }, { 54, 67, 66 } },
  { { 147, 101, 110 }, { 80, 66, 67 } }, { { 110, 150, 147 }, { 67, 75, 80 } },
  { { 184, 147, 150 }, { 109, 80, 75 } }, { { 150, 191, 184 }, { 75, 107, 109 } },
  { { 86, 77, 74 }, { 46, 24, 29 } }, { { 73, 83, 85 }, { 29, 53, 46 } },
  { { 90, 85, 83 }, { 65, 46, 53 } }, { { 83, 92, 90 }, { 53, 63, 65 } },
  { { 113, 90, 92 }, { 85, 65, 63 } }, { { 92, 115, 113 }, { 63, 76, 85 } },
  { { 121, 112, 124 }, { 104, 85, 101 } }, { { 115, 125, 113 }, { 76, 101, 85 } },
  { { 87, 81, 77 }, { 43, 28, 24 } }, { { 77, 86, 87 }, { 24, 46, 43 } },
  { { 88, 87, 86 }, { 72, 43, 46 } }, { { 86, 89, 88 }, { 46, 65, 72 } },
  { { 111, 88, 89 }, { 87, 72, 65 } }, { { 89, 112, 111 }, { 65, 85, 87 } },
  { { 117, 111, 112 }, { 102, 87, 85 } }, { { 112, 121, 117 }, { 85, 104, 102 } },
  { { 84, 80, 81 }, { 47, 31, 28 } }, { { 81, 87, 84 }, { 28, 43, 47 } },
  { { 91, 84, 87 }, { 70, 47, 43 } }, { { 87, 88, 91 }, { 43, 72, 70 } },
  { { 114, 91, 88 }, { 82, 70, 72 } }, { { 88, 111, 114 }, { 72, 87, 82 } },
  { { 118, 114, 111 }, { 99, 82, 87 } }, { { 111, 117, 118 }, { 87, 102, 99 } },
  { { 50, 48, 9 }, { 93, 92, 41 } }, { { 8, 11, 49 }, { 41, 48, 93 } },
  { { 103, 102, 48 }, { 57, 56, 92 } }, { { 48, 50, 103 }, { 92, 93, 57 } },
  { { 148, 151, 102 }, { 35, 36, 56 } }, { { 102, 103, 148 }, { 56, 57, 35 } },
  { { 189, 193, 151 }, { 83, 95, 36 } }, { { 152, 149, 188 }, { 36, 35, 83 } },
  { { 53, 49, 11 }, { 98, 93, 48 } }, { { 11, 22, 53 }, { 48, 49, 98 } },
  { { 104, 103, 50 }, { 58, 57, 93 } }, { { 50, 52, 104 }, { 93, 98, 58 } },
  { { 146, 148, 103 }, { 32, 35, 57 } }, { { 103, 104, 146 }, { 57, 58, 32 } },
  { { 176, 188, 149 }, { 81, 83, 35 } }, { { 149, 145, 176 }, { 35, 32, 81 } },
  { { 55, 53, 22 }, { 91, 98, 49 } }, { { 22, 26, 55 }, { 49, 45, 91 } },
  { { 105, 104, 52 }, { 71, 58, 98 } }, { { 52, 54, 105 }, { 98, 91, 71 } },
  { { 144, 146, 104 }, { 39, 32, 58 } }, { { 104, 105, 144 }, { 58, 71, 39 } },
  { { 172, 176, 145 }, { 84, 81, 32 } }, { { 145, 143, 172 }, { 32, 39, 84 } },
  { { 56, 54, 34 }, { 55, 91, 37 } }, { { 26, 36, 55 }, { 45, 37, 91 } },
  { { 107, 105, 54 }, { 74, 71, 91 } }, { { 54, 56, 107 }, { 91, 55, 74 } },
  { { 139, 144, 105 }, { 78, 39, 71 } }, { { 105, 107, 139 }, { 71, 74, 78 } },
  { { 162, 172, 143 }, { 89, 84, 39 } }, { { 144, 139, 164 }, { 39, 78, 89 } },
  { { 194, 185, 190 }, { 124, 109, 107 } }, { { 190, 197, 194 }, { 107, 129, 124 } },
  { { 181, 180, 185 }, { 127, 118, 109 } }, { { 185, 194, 181 }, { 109, 124, 127 } },
  { { 177, 174, 180 }, { 122, 117, 118 } }, { { 180, 181, 177 }, { 118, 127, 122 } },
  { { 167, 161, 174 }, { 114, 111, 117 } }, { { 174, 177, 167 }, { 117, 122, 114 } },
  { { 195, 194, 197 }, { 128, 124, 129 } }, { { 197, 198, 195 }, { 129, 130, 128 } },
  { { 182, 181, 194 }, { 126, 127, 124 } }, { { 194, 195, 182 }, { 124, 128, 126 } },
  { { 178, 177, 181 }, { 123, 122, 127 } }, { { 181, 182, 178 }, { 127, 126, 123 } },
  { { 169, 167, 177 }, { 113, 114, 122 } }, { { 177, 178, 169 }, { 122, 123, 113 } },
  { { 196, 195, 198 }, { 119, 128, 130 } }, { { 198, 199, 196 }, { 130, 125, 119 } },
  { { 183, 182, 195 }, { 120, 126, 128 } }, { { 195, 196, 183 }, { 128, 119, 120 } },
  { { 179, 178, 182 }, { 121, 123, 126 } }, { { 182, 183, 179 }, { 126, 120, 121 } },
  { { 171, 169, 178 }, { 112, 113, 123 } }, { { 178, 179, 171 }, { 123, 121, 112 } },
  { { 187, 196, 199 }, { 83, 119, 125 } }, { { 199, 192, 187 }, { 125, 95, 83 } },
  { { 175, 183, 196 }, { 81, 120, 119 } }, { { 196, 187, 175 }, { 119, 83, 81 } },
  { { 173, 179, 183 }, { 84, 121, 120 } }, { { 183, 175, 173 }, { 120, 81, 84 } },
  { { 165, 171, 179 }, { 89, 112, 121 } }, { { 179, 173, 165 }, { 121, 84, 89 } },
  { { 140, 136, 160 }, { 97, 94, 111 } }, { { 160, 166, 140 }, { 111, 114, 97 } },
  { { 100, 97, 136 }, { 60, 59, 94 } }, { { 136, 140, 100 }, { 94, 97, 60 } },
  { { 58, 62, 97 }, { 33, 38, 59 } }, { { 97, 100, 58 }, { 59, 60, 33 } },
  { { 28, 38, 62 }, { 17, 19, 38 } }, { { 62, 58, 28 }, { 38, 33, 17 } },
  { { 141, 140, 166 }, { 96, 97, 114 } }, { { 166, 168, 141 }, { 114, 113, 96 } },
  { { 108, 100, 140 }, { 68, 60, 97 } }, { { 140, 141, 108 }, { 97, 96, 68 } },
  { { 59, 58, 100 }, { 34, 33, 60 } }, { { 100, 108, 59 }, { 60, 68, 34 } },
  { { 30, 28, 58 }, { 18, 17, 33 } }, { { 58, 59, 30 }, { 33, 34, 18 } },
  { { 142, 141, 168 }, { 90, 96, 113 } }, { { 168, 170, 142 }, { 113, 112, 90 } },
  { { 109, 108, 141 }, { 73, 68, 96 } }, { { 141, 142, 109 }, { 96, 90, 73 } },
  { { 60, 59, 108 }, { 40, 34, 68 } }, { { 108, 109, 60 }, { 68, 73, 40 } },
  { { 32, 30, 59 }, { 16, 18, 34 } }, { { 59, 60, 32 }, { 34, 40, 16 } },
  { { 138, 142, 170 }, { 78, 90, 112 } }, { { 170, 163, 138 }, { 112, 89, 78 } },
  { { 106, 109, 142 }, { 74, 73, 90 } }, { { 142, 138, 106 }, { 90, 78, 74 } },
  { { 57, 60, 109 }, { 55, 40, 73 } }, { { 109, 106, 57 }, { 73, 74, 55 } },
  { { 35, 32, 60 }, { 37, 16, 40 } }, { { 60, 57, 35 }, { 40, 55, 37 } },
  { { 19, 24, 37 }, { 8, 13, 19 } }, { { 37, 27, 19 }, { 19, 17, 8 } },
  { { 15, 18, 24 }, { 6, 12, 13 } }, { { 24, 19, 15 }, { 13, 8, 6 } },
  { { 3, 13, 18 }, { 4, 20, 12 } }, { { 18, 15, 3 }, { 12, 6, 4 } },
  { { 0, 7, 13 }, { 1, 22, 20 } }, { { 13, 3, 0 }, { 20, 4, 1 } },
  { { 20, 19, 27 }, { 7, 8, 17 } }, { { 27, 29, 20 }, { 17, 18, 7 } },
  { { 16, 15, 19 }, { 5, 6, 8 } }, { { 19, 20, 16 }, { 8, 7, 5 } },
  { { 4, 3, 15 }, { 2, 4, 6 } }, { { 15, 16, 4 }, { 6, 5, 2 } },
  { { 1, 0, 3 }, { 0, 1, 4 } }, { { 3, 4, 1 }, { 4, 2, 0 } },
  { { 21, 20, 29 }, { 11, 7, 18 } }, { { 29, 31, 21 }, { 18, 16, 11 } },
  { { 17, 16, 20 }, { 9, 5, 7 } }, { { 20, 21, 17 }, { 7, 11, 9 } },
  { { 5, 4, 16 }, { 10, 2, 5 } }, { { 16, 17, 5 }, { 5, 9, 10 } },
  { { 2, 1, 4 }, { 3, 0, 2 } }, { { 4, 5, 2 }, { 2, 10, 3 } },
  { { 25, 21, 31 }, { 45, 11, 16 } }, { { 31, 33, 25 }, { 16, 37, 45 } },
  { { 23, 17, 21 }, { 49, 9, 11 } }, { { 21, 25, 23 }, { 11, 45, 49 } },
  { { 12, 5, 17 }, { 48, 10, 9 } }, { { 17, 23, 12 }, { 9, 49, 48 } },
  { { 10, 2, 5 }, { 41, 3, 10 } }, { { 5, 12, 10 }, { 10, 48, 41 } },
  { { 42, 14, 51 }, { 27, 20, 51 } }, { { 51, 66, 42 }, { 51, 50, 27 } },
  { { 66, 51, 101 }, { 50, 51, 66 } }, { { 101, 98, 66 }, { 66, 64, 50 } },
  { { 98, 101, 147 }, { 64, 66, 80 } }, { { 147, 132, 98 }, { 80, 79, 64 } },
  { { 132, 147, 184 }, { 79, 80, 109 } }, { { 186, 158, 133 }, { 109, 106, 79 } },
  { { 39, 18, 13 }, { 14, 12, 20 } }, { { 13, 41, 39 }, { 20, 27, 14 } },
  { { 157, 185, 180 }, { 106, 109, 118 } }, { { 180, 159, 157 }, { 118, 116, 106 } },
  { { 43, 24, 18 }, { 15, 13, 12 } }, { { 18, 39, 43 }, { 12, 14, 15 } },
  { { 159, 180, 174 }, { 116, 118, 117 } }, { { 174, 156, 159 }, { 117, 115, 116 } },
  { { 44, 37, 24 }, { 26, 19, 13 } }, { { 24, 43, 44 }, { 13, 15, 26 } },
  { { 70, 62, 38 }, { 42, 38, 19 } }, { { 38, 45, 70 }, { 19, 26, 42 } },
  { { 95, 97, 62 }, { 61, 59, 38 } }, { { 62, 70, 95 }, { 38, 42, 61 } },
  { { 127, 136, 97 }, { 88, 94, 59 } }, { { 97, 95, 127 }, { 59, 61, 88 } },
  { { 153, 160, 136 }, { 103, 111, 94 } }, { { 136, 127, 153 }, { 94, 88, 103 } },
  { { 156, 174, 161 }, { 115, 117, 111 } }, { { 161, 155, 156 }, { 111, 103, 115 } },
  { { 61, 39, 41 }, { 21, 14, 27 } }, { { 41, 64, 61 }, { 27, 25, 21 } },
  { { 63, 40, 65 }, { 25, 27, 50 } }, { { 65, 72, 63 }, { 50, 52, 25 } },
  { { 72, 65, 99 }, { 52, 50, 64 } }, { { 99, 94, 72 }, { 64, 62, 52 } },
  { { 94, 99, 133 }, { 62, 64, 79 } }, { { 133, 126, 94 }, { 79, 77, 62 } },
  { { 134, 157, 159 }, { 105, 106, 116 } }, { { 159, 137, 134 }, { 116, 110, 105 } },
  { { 126, 133, 158 }, { 77, 79, 106 } }, { { 158, 135, 126 }, { 106, 105, 77 } },
  { { 67, 43, 39 }, { 23, 15, 14 } }, { { 39, 61, 67 }, { 14, 21, 23 } },
  { { 137, 159, 156 }, { 110, 116, 115 } }, { { 156, 131, 137 }, { 115, 108, 110 } },
  { { 68, 44, 43 }, { 30, 26, 15 } }, { { 43, 67, 68 }, { 15, 23, 30 } },
  { { 76, 71, 46 }, { 44, 42, 26 } }, { { 46, 69, 76 }, { 26, 30, 44 } },
  { { 93, 96, 71 }, { 69, 61, 42 } }, { { 71, 76, 93 }, { 42, 44, 69 } },
  { { 122, 128, 96 }, { 86, 88, 61 } }, { { 96, 93, 122 }, { 61, 69, 86 } },
  { { 129, 154, 128 }, { 100, 103, 88 } }, { { 128, 122, 129 }, { 88, 86, 100 } },
  { { 131, 156, 155 }, { 108, 115, 103 } }, { { 155, 130, 131 }, { 103, 100, 108 } },
  { { 78, 61, 64 }, { 24, 21, 25 } }, { { 64, 75, 78 }, { 25, 29, 24 } },
  { { 73, 63, 72 }, { 29, 25, 52 } }, { { 72, 83, 73 }, { 52, 53, 29 } },
  { { 83, 72, 94 }, { 53, 52, 62 } }, { { 94, 92, 83 }, { 62, 63, 53 } },
  { { 92, 94, 126 }, { 63, 62, 77 } }, { { 126, 115, 92 }, { 77, 76, 63 } },
  { { 123, 134, 137 }, { 101, 105, 110 } }, { { 137, 120, 123 }, { 110, 104, 101 } },
  { { 115, 126, 135 }, { 76, 77, 105 } }, { { 135, 125, 115 }, { 105, 101, 76 } },
  { { 82, 67, 61 }, { 28, 23, 21 } }, { { 61, 78, 82 }, { 21, 24, 28 } },
  { { 120, 137, 131 }, { 104, 110, 108 } }, { { 131, 116, 120 }, { 108, 102, 104 } },
  { { 79, 68, 67 }, { 31, 30, 23 } }, { { 67, 82, 79 }, { 23, 28, 31 } },
  { { 84, 76, 69 }, { 47, 44, 30 } }, { { 69, 80, 84 }, { 30, 31, 47 } },
  { { 91, 93, 76 }, { 70, 69, 44 } }, { { 76, 84, 91 }, { 44, 47, 70 } },
  { { 114, 122, 93 }, { 82, 86, 69 } }, { { 93, 91, 114 }, { 69, 70, 82 } },
  { { 118, 129, 122 }, { 99, 100, 86 } }, { { 122, 114, 118 }, { 86, 82, 99 } },
  { { 116, 131, 130 }, { 102, 108, 100 } }, { { 130, 119, 116 }, { 100, 99, 102 } }
};

float Monk_matrix_Rhand[16] = {
  -0.140259f, 0.0f, -0.927138f, -42.27917f,
  0.0f, -1.6093f, 0.0f, 0.041224f,
  -1.603176f, 0.0f, 0.081114f, 71.39645f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Rhand[48] = {
  { -5.058658f, -1.865513f, 5.286465f, 0.0f, 0.0f },
  { -3.230063f, -3.437729f, 4.728927f, 0.0f, 0.0f },
  { 0.867144f, -3.437729f, 3.479694f, 0.0f, 0.0f },
  { 5.2282f, -2.519689f, 2.898258f, 0.0f, 0.0f },
  { -5.058658f, -1.379661f, 5.286465f, 0.0f, 0.0f },
  { -3.230063f, -1.093981f, 4.728935f, 0.0f, 0.0f },
  { 0.867145f, -1.093981f, 3.479702f, 0.0f, 0.0f },
  { 5.2282f, -0.787967f, 2.898258f, 0.0f, 0.0f },
  { -5.058658f, 1.53545f, 5.286466f, 0.0f, 0.0f },
  { -3.230063f, 1.249768f, 4.728935f, 0.0f, 0.0f },
  { 0.867145f, 1.249768f, 3.479703f, 0.0f, 0.0f },
  { 5.2282f, 0.943754f, 2.898259f, 0.0f, 0.0f },
  { -5.058658f, 2.0213f, 5.286466f, 0.0f, 0.0f },
  { -3.230063f, 3.593516f, 4.728927f, 0.0f, 0.0f },
  { 0.867144f, 3.593516f, 3.479695f, 0.0f, 0.0f },
  { 5.2282f, 2.675476f, 2.898259f, 0.0f, 0.0f },
  { -4.723916f, -1.865513f, 8.569148f, 0.0f, 0.0f },
  { -2.895322f, -3.437729f, 8.011609f, 0.0f, 0.0f },
  { 1.201885f, -3.437729f, 6.762376f, 0.0f, 0.0f },
  { 5.962151f, -2.519689f, 5.619896f, 0.0f, 0.0f },
  { -4.723916f, -1.379661f, 8.569148f, 0.0f, 0.0f },
  { -2.895322f, -1.093981f, 8.011605f, 0.0f, 0.0f },
  { 1.201885f, -1.09398f, 6.762373f, 0.0f, 0.0f },
  { 5.962149f, -0.787967f, 5.619897f, 0.0f, 0.0f },
  { -4.723916f, 1.53545f, 8.569148f, 0.0f, 0.0f },
  { -2.895322f, 1.249768f, 8.011606f, 0.0f, 0.0f },
  { 1.201886f, 1.249768f, 6.762373f, 0.0f, 0.0f },
  { 5.962149f, 0.943754f, 5.619897f, 0.0f, 0.0f },
  { -4.723916f, 2.0213f, 8.569148f, 0.0f, 0.0f },
  { -2.895321f, 3.593516f, 8.01161f, 0.0f, 0.0f },
  { 1.201886f, 3.593516f, 6.762377f, 0.0f, 0.0f },
  { 5.962149f, 2.675476f, 5.619897f, 0.0f, 0.0f },
  { 2.800707f, 5.397537f, 3.31956f, 0.0f, 0.0f },
  { 2.69269f, 6.442284f, 3.352495f, 0.0f, 0.0f },
  { 3.050515f, 5.397538f, 5.769334f, 0.0f, 0.0f },
  { 2.942497f, 6.442284f, 5.802265f, 0.0f, 0.0f },
  { 7.047181f, -1.60252f, -1.311351f, 0.0f, 0.0f },
  { 7.047179f, -0.482245f, -1.31135f, 0.0f, 0.0f },
  { 7.047179f, 0.638031f, -1.31135f, 0.0f, 0.0f },
  { 7.047179f, 1.758306f, -1.31135f, 0.0f, 0.0f },
  { 8.141984f, -1.60252f, -0.208557f, 0.0f, 0.0f },
  { 8.141989f, -0.482245f, -0.208558f, 0.0f, 0.0f },
  { 8.141989f, 0.638031f, -0.208557f, 0.0f, 0.0f },
  { 8.141989f, 1.758306f, -0.208557f, 0.0f, 0.0f },
  { -10.593719f, -1.831116f, 1.202205f, 0.0f, 0.0f },
  { -10.593724f, 1.986904f, 1.202206f, 0.0f, 0.0f },
  { -10.593724f, -1.831117f, 7.449618f, 0.0f, 0.0f },
  { -10.593723f, 1.986904f, 7.449619f, 0.0f, 0.0f }
};


TEST_NORMAL Monk_normal_Rhand[48] = {
  { -0.821636f, 0.326217f, -0.467437f }, { -0.821635f, -0.326217f, -0.467438f },
  { -0.603382f, 0.0f, -0.797452f }, { -0.603382f, 0.0f, -0.797453f },
  { -0.564846f, 0.339498f, 0.752124f }, { -0.564846f, -0.339498f, 0.752124f },
  { -0.551579f, 0.598241f, -0.581265f }, { -0.407657f, -0.716613f, -0.565933f },
  { -0.291643f, 0.000002f, -0.956527f }, { -0.291642f, -0.000002f, -0.956527f },
  { -0.267746f, -0.464924f, -0.843895f }, { -0.263722f, 0.464316f, -0.845495f },
  { -0.21261f, 0.000002f, -0.977137f }, { -0.212609f, -0.000001f, -0.977137f },
  { -0.206905f, 0.648001f, 0.732998f }, { -0.185861f, 0.0f, -0.982576f },
  { -0.185861f, 0.0f, -0.982576f }, { -0.1705f, -0.254872f, 0.951825f },
  { -0.169473f, 0.254604f, 0.952079f }, { -0.14147f, 0.502707f, -0.852803f },
  { -0.141468f, -0.502707f, -0.852802f }, { -0.129804f, 0.838271f, -0.529578f },
  { -0.12556f, -0.835939f, -0.534267f }, { -0.104684f, -0.734684f, 0.670284f },
  { -0.080709f, -0.71006f, -0.6995f }, { -0.063389f, 0.765037f, 0.640859f },
  { -0.060705f, -0.766033f, 0.639929f }, { 0.019337f, 0.138547f, -0.990167f },
  { 0.239266f, -0.726089f, 0.644629f }, { 0.262629f, 0.0f, 0.964897f },
  { 0.262629f, 0.0f, 0.964897f }, { 0.291645f, 0.0f, 0.956527f },
  { 0.291645f, 0.0f, 0.956527f }, { 0.331389f, 0.725774f, -0.602855f },
  { 0.466743f, 0.138204f, 0.873528f }, { 0.498948f, 0.753738f, 0.427703f },
  { 0.534562f, 0.515345f, -0.669823f }, { 0.535589f, -0.515537f, -0.668854f },
  { 0.587545f, 0.577797f, 0.566518f }, { 0.590874f, -0.573806f, 0.567111f },
  { 0.662555f, 0.0f, 0.749013f }, { 0.662555f, 0.0f, 0.749013f },
  { 0.669132f, -0.267143f, -0.693467f }, { 0.824475f, -0.526549f, -0.207333f },
  { 0.824476f, 0.526547f, -0.207335f }, { 0.88582f, -0.26684f, 0.37963f },
  { 0.977625f, 0.0f, -0.210353f }, { 0.977626f, -0.000002f, -0.210353f }
};

TEST_TRIANGLE3 Monk_triangle3_Rhand[90] = {
  { { 5, 4, 0 }, { 8, 10, 1 } }, { { 0, 1, 5 }, { 1, 7, 8 } },
  { { 6, 5, 1 }, { 12, 8, 7 } }, { { 1, 2, 6 }, { 7, 24, 12 } },
  { { 7, 6, 2 }, { 3, 12, 24 } }, { { 2, 3, 7 }, { 24, 22, 3 } },
  { { 9, 8, 4 }, { 9, 11, 10 } }, { { 4, 5, 9 }, { 10, 8, 9 } },
  { { 10, 9, 5 }, { 13, 9, 8 } }, { { 5, 6, 10 }, { 8, 12, 13 } },
  { { 11, 10, 6 }, { 2, 13, 12 } }, { { 6, 7, 11 }, { 12, 3, 2 } },
  { { 13, 12, 8 }, { 6, 0, 11 } }, { { 8, 9, 13 }, { 11, 9, 6 } },
  { { 14, 13, 9 }, { 27, 6, 9 } }, { { 9, 10, 14 }, { 9, 13, 27 } },
  { { 15, 14, 10 }, { 21, 27, 13 } }, { { 10, 11, 15 }, { 13, 2, 21 } },
  { { 21, 17, 16 }, { 31, 23, 5 } }, { { 16, 20, 21 }, { 5, 17, 31 } },
  { { 22, 18, 17 }, { 29, 28, 23 } }, { { 17, 21, 22 }, { 23, 31, 29 } },
  { { 23, 19, 18 }, { 41, 39, 28 } }, { { 18, 22, 23 }, { 28, 29, 41 } },
  { { 25, 21, 20 }, { 32, 31, 17 } }, { { 20, 24, 25 }, { 17, 18, 32 } },
  { { 26, 22, 21 }, { 30, 29, 31 } }, { { 21, 25, 26 }, { 31, 32, 30 } },
  { { 27, 23, 22 }, { 40, 41, 29 } }, { { 22, 26, 27 }, { 29, 30, 40 } },
  { { 29, 25, 24 }, { 14, 32, 18 } }, { { 24, 28, 29 }, { 18, 4, 14 } },
  { { 30, 26, 25 }, { 34, 30, 32 } }, { { 25, 29, 30 }, { 32, 14, 34 } },
  { { 31, 27, 26 }, { 38, 40, 30 } }, { { 26, 30, 31 }, { 30, 34, 38 } },
  { { 17, 1, 0 }, { 23, 7, 1 } }, { { 0, 16, 17 }, { 1, 5, 23 } },
  { { 18, 2, 1 }, { 28, 24, 7 } }, { { 1, 17, 18 }, { 7, 23, 28 } },
  { { 19, 3, 2 }, { 39, 22, 24 } }, { { 2, 18, 19 }, { 24, 28, 39 } },
  { { 41, 37, 36 }, { 47, 15, 20 } }, { { 36, 40, 41 }, { 20, 43, 47 } },
  { { 42, 38, 37 }, { 46, 16, 15 } }, { { 37, 41, 42 }, { 15, 47, 46 } },
  { { 43, 39, 38 }, { 44, 19, 16 } }, { { 38, 42, 43 }, { 16, 46, 44 } },
  { { 30, 14, 15 }, { 34, 27, 21 } }, { { 15, 31, 30 }, { 21, 38, 34 } },
  { { 35, 33, 32 }, { 35, 33, 42 } }, { { 32, 34, 35 }, { 42, 45, 35 } },
  { { 28, 12, 13 }, { 4, 0, 6 } }, { { 13, 29, 28 }, { 6, 14, 4 } },
  { { 24, 8, 12 }, { 18, 11, 0 } }, { { 12, 28, 24 }, { 0, 4, 18 } },
  { { 16, 0, 4 }, { 5, 1, 10 } }, { { 4, 20, 16 }, { 10, 17, 5 } },
  { { 33, 13, 14 }, { 33, 6, 27 } }, { { 14, 32, 33 }, { 27, 42, 33 } },
  { { 32, 14, 30 }, { 42, 27, 34 } }, { { 30, 34, 32 }, { 34, 45, 42 } },
  { { 35, 29, 13 }, { 35, 14, 6 } }, { { 13, 33, 35 }, { 6, 33, 35 } },
  { { 34, 30, 35 }, { 45, 34, 35 } }, { { 29, 35, 30 }, { 14, 35, 34 } },
  { { 36, 3, 40 }, { 20, 22, 43 } }, { { 19, 40, 3 }, { 39, 43, 22 } },
  { { 37, 7, 3 }, { 15, 3, 22 } }, { { 3, 36, 37 }, { 22, 20, 15 } },
  { { 38, 11, 7 }, { 16, 2, 3 } }, { { 7, 37, 38 }, { 3, 15, 16 } },
  { { 39, 15, 11 }, { 19, 21, 2 } }, { { 11, 38, 39 }, { 2, 16, 19 } },
  { { 40, 19, 23 }, { 43, 39, 41 } }, { { 23, 41, 40 }, { 41, 47, 43 } },
  { { 41, 23, 27 }, { 47, 41, 40 } }, { { 27, 42, 41 }, { 40, 46, 47 } },
  { { 43, 31, 15 }, { 44, 38, 21 } }, { { 15, 39, 43 }, { 21, 19, 44 } },
  { { 42, 27, 31 }, { 46, 40, 38 } }, { { 31, 43, 42 }, { 38, 44, 46 } },
  { { 44, 4, 8 }, { 37, 10, 11 } }, { { 8, 45, 44 }, { 11, 36, 37 } },
  { { 47, 24, 20 }, { 25, 18, 17 } }, { { 20, 46, 47 }, { 17, 26, 25 } },
  { { 45, 8, 24 }, { 36, 11, 18 } }, { { 24, 47, 45 }, { 18, 25, 36 } },
  { { 46, 20, 4 }, { 26, 17, 10 } }, { { 4, 44, 46 }, { 10, 37, 26 } }
};

float Monk_matrix_Lhand[16] = {
  -0.140259f, 0.0f, 0.927137f, 42.2792f,
  0.0f, -1.609299f, 0.0f, 0.041222f,
  1.603176f, 0.0f, 0.081114f, 71.396445f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Lhand[48] = {
  { 5.058657f, -1.865513f, 5.286465f, 0.0f, 0.0f },
  { 3.230062f, -3.437729f, 4.728931f, 0.0f, 0.0f },
  { -0.867144f, -3.437729f, 3.479694f, 0.0f, 0.0f },
  { -5.228197f, -2.519689f, 2.898259f, 0.0f, 0.0f },
  { 5.058657f, -1.379661f, 5.286465f, 0.0f, 0.0f },
  { 3.230062f, -1.093981f, 4.728935f, 0.0f, 0.0f },
  { -0.867145f, -1.093981f, 3.479702f, 0.0f, 0.0f },
  { -5.228197f, -0.787967f, 2.898259f, 0.0f, 0.0f },
  { 5.058657f, 1.53545f, 5.286465f, 0.0f, 0.0f },
  { 3.230063f, 1.249768f, 4.728935f, 0.0f, 0.0f },
  { -0.867144f, 1.249768f, 3.479702f, 0.0f, 0.0f },
  { -5.228197f, 0.943754f, 2.898259f, 0.0f, 0.0f },
  { 5.058657f, 2.0213f, 5.286465f, 0.0f, 0.0f },
  { 3.230063f, 3.593516f, 4.72893f, 0.0f, 0.0f },
  { -0.867144f, 3.593516f, 3.479694f, 0.0f, 0.0f },
  { -5.228197f, 2.675476f, 2.898258f, 0.0f, 0.0f },
  { 4.723916f, -1.865513f, 8.569148f, 0.0f, 0.0f },
  { 2.895321f, -3.437729f, 8.011609f, 0.0f, 0.0f },
  { -1.201891f, -3.437729f, 6.76238f, 0.0f, 0.0f },
  { -5.962148f, -2.519688f, 5.619893f, 0.0f, 0.0f },
  { 4.723916f, -1.379661f, 8.569148f, 0.0f, 0.0f },
  { 2.895317f, -1.093981f, 8.011608f, 0.0f, 0.0f },
  { -1.20189f, -1.09398f, 6.762376f, 0.0f, 0.0f },
  { -5.962148f, -0.787967f, 5.619893f, 0.0f, 0.0f },
  { 4.723916f, 1.53545f, 8.569147f, 0.0f, 0.0f },
  { 2.895317f, 1.249768f, 8.011608f, 0.0f, 0.0f },
  { -1.20189f, 1.249768f, 6.762376f, 0.0f, 0.0f },
  { -5.962148f, 0.943754f, 5.619893f, 0.0f, 0.0f },
  { 4.723916f, 2.0213f, 8.569147f, 0.0f, 0.0f },
  { 2.895322f, 3.593516f, 8.011609f, 0.0f, 0.0f },
  { -1.20189f, 3.593516f, 6.762379f, 0.0f, 0.0f },
  { -5.962148f, 2.675476f, 5.619892f, 0.0f, 0.0f },
  { -2.800706f, 5.397538f, 3.319559f, 0.0f, 0.0f },
  { -2.692689f, 6.442284f, 3.352494f, 0.0f, 0.0f },
  { -3.050514f, 5.397538f, 5.769329f, 0.0f, 0.0f },
  { -2.942496f, 6.442284f, 5.802264f, 0.0f, 0.0f },
  { -7.047179f, -1.60252f, -1.31135f, 0.0f, 0.0f },
  { -7.047179f, -0.482245f, -1.31135f, 0.0f, 0.0f },
  { -7.047179f, 0.638031f, -1.311346f, 0.0f, 0.0f },
  { -7.047179f, 1.758306f, -1.311346f, 0.0f, 0.0f },
  { -8.141981f, -1.60252f, -0.20856f, 0.0f, 0.0f },
  { -8.141986f, -0.482244f, -0.208557f, 0.0f, 0.0f },
  { -8.141986f, 0.638031f, -0.208557f, 0.0f, 0.0f },
  { -8.141986f, 1.758306f, -0.208557f, 0.0f, 0.0f },
  { 10.593723f, -1.831117f, 1.202206f, 0.0f, 0.0f },
  { 10.593723f, 1.986904f, 1.202206f, 0.0f, 0.0f },
  { 10.593727f, -1.831116f, 7.449623f, 0.0f, 0.0f },
  { 10.593727f, 1.986904f, 7.449622f, 0.0f, 0.0f }
};


TEST_NORMAL Monk_normal_Lhand[48] = {
  { -0.821635f, -0.326217f, 0.467438f }, { -0.821635f, 0.326217f, 0.467438f },
  { -0.603382f, 0.0f, 0.797453f }, { -0.603382f, 0.0f, 0.797453f },
  { -0.564846f, 0.339498f, -0.752124f }, { -0.564846f, -0.339498f, -0.752124f },
  { -0.551579f, -0.598241f, 0.581265f }, { -0.407657f, 0.716614f, 0.565933f },
  { -0.291643f, 0.0f, 0.956527f }, { -0.291642f, 0.0f, 0.956527f },
  { -0.267746f, 0.464924f, 0.843895f }, { -0.263722f, -0.464316f, 0.845495f },
  { -0.21261f, -0.000002f, 0.977137f }, { -0.212609f, 0.000002f, 0.977137f },
  { -0.206906f, -0.648001f, -0.732997f }, { -0.185861f, -0.000002f, 0.982576f },
  { -0.18586f, -0.000001f, 0.982576f }, { -0.170501f, 0.254872f, -0.951824f },
  { -0.169474f, -0.254605f, -0.952079f }, { -0.14147f, -0.502707f, 0.852802f },
  { -0.141469f, 0.502707f, 0.852803f }, { -0.129804f, -0.838271f, 0.529578f },
  { -0.12556f, 0.835939f, 0.534267f }, { -0.104684f, 0.734685f, -0.670283f },
  { -0.080709f, 0.71006f, 0.6995f }, { -0.063389f, -0.765037f, -0.64086f },
  { -0.060705f, 0.766033f, -0.639929f }, { 0.019336f, -0.138547f, 0.990167f },
  { 0.239267f, 0.726088f, -0.64463f }, { 0.26263f, 0.0f, -0.964897f },
  { 0.26263f, 0.0f, -0.964897f }, { 0.291644f, 0.0f, -0.956527f },
  { 0.291644f, 0.0f, -0.956527f }, { 0.331388f, -0.725774f, 0.602855f },
  { 0.466744f, -0.138205f, -0.873527f }, { 0.498948f, -0.753738f, -0.427703f },
  { 0.534562f, -0.515345f, 0.669823f }, { 0.535588f, 0.515538f, 0.668854f },
  { 0.587545f, -0.577797f, -0.566517f }, { 0.590874f, 0.573806f, -0.56711f },
  { 0.662556f, 0.0f, -0.749012f }, { 0.662556f, 0.0f, -0.749012f },
  { 0.669132f, 0.267143f, 0.693468f }, { 0.824475f, 0.526548f, 0.207335f },
  { 0.824476f, -0.526547f, 0.207335f }, { 0.885822f, 0.266841f, -0.379626f },
  { 0.977625f, 0.0f, 0.210353f }, { 0.977626f, 0.000002f, 0.210352f }
};

TEST_TRIANGLE3 Monk_triangle3_Lhand[90] = {
  { { 5, 4, 0 }, { 9, 10, 1 } }, { { 0, 1, 5 }, { 1, 7, 9 } },
  { { 6, 5, 1 }, { 12, 9, 7 } }, { { 1, 2, 6 }, { 7, 24, 12 } },
  { { 7, 6, 2 }, { 3, 12, 24 } }, { { 2, 3, 7 }, { 24, 22, 3 } },
  { { 9, 8, 4 }, { 8, 11, 10 } }, { { 4, 5, 9 }, { 10, 9, 8 } },
  { { 10, 9, 5 }, { 13, 8, 9 } }, { { 5, 6, 10 }, { 9, 12, 13 } },
  { { 11, 10, 6 }, { 2, 13, 12 } }, { { 6, 7, 11 }, { 12, 3, 2 } },
  { { 13, 12, 8 }, { 6, 0, 11 } }, { { 8, 9, 13 }, { 11, 8, 6 } },
  { { 14, 13, 9 }, { 27, 6, 8 } }, { { 9, 10, 14 }, { 8, 13, 27 } },
  { { 15, 14, 10 }, { 21, 27, 13 } }, { { 10, 11, 15 }, { 13, 2, 21 } },
  { { 21, 17, 16 }, { 32, 23, 4 } }, { { 16, 20, 21 }, { 4, 17, 32 } },
  { { 22, 18, 17 }, { 29, 28, 23 } }, { { 17, 21, 22 }, { 23, 32, 29 } },
  { { 23, 19, 18 }, { 41, 39, 28 } }, { { 18, 22, 23 }, { 28, 29, 41 } },
  { { 25, 21, 20 }, { 31, 32, 17 } }, { { 20, 24, 25 }, { 17, 18, 31 } },
  { { 26, 22, 21 }, { 30, 29, 32 } }, { { 21, 25, 26 }, { 32, 31, 30 } },
  { { 27, 23, 22 }, { 40, 41, 29 } }, { { 22, 26, 27 }, { 29, 30, 40 } },
  { { 29, 25, 24 }, { 14, 31, 18 } }, { { 24, 28, 29 }, { 18, 5, 14 } },
  { { 30, 26, 25 }, { 34, 30, 31 } }, { { 25, 29, 30 }, { 31, 14, 34 } },
  { { 31, 27, 26 }, { 38, 40, 30 } }, { { 26, 30, 31 }, { 30, 34, 38 } },
  { { 17, 1, 0 }, { 23, 7, 1 } }, { { 0, 16, 17 }, { 1, 4, 23 } },
  { { 18, 2, 1 }, { 28, 24, 7 } }, { { 1, 17, 18 }, { 7, 23, 28 } },
  { { 19, 3, 2 }, { 39, 22, 24 } }, { { 2, 18, 19 }, { 24, 28, 39 } },
  { { 41, 37, 36 }, { 47, 16, 20 } }, { { 36, 40, 41 }, { 20, 43, 47 } },
  { { 42, 38, 37 }, { 46, 15, 16 } }, { { 37, 41, 42 }, { 16, 47, 46 } },
  { { 43, 39, 38 }, { 44, 19, 15 } }, { { 38, 42, 43 }, { 15, 46, 44 } },
  { { 30, 14, 15 }, { 34, 27, 21 } }, { { 15, 31, 30 }, { 21, 38, 34 } },
  { { 35, 33, 32 }, { 35, 33, 42 } }, { { 32, 34, 35 }, { 42, 45, 35 } },
  { { 28, 12, 13 }, { 5, 0, 6 } }, { { 13, 29, 28 }, { 6, 14, 5 } },
  { { 24, 8, 12 }, { 18, 11, 0 } }, { { 12, 28, 24 }, { 0, 5, 18 } },
  { { 16, 0, 4 }, { 4, 1, 10 } }, { { 4, 20, 16 }, { 10, 17, 4 } },
  { { 33, 13, 14 }, { 33, 6, 27 } }, { { 14, 32, 33 }, { 27, 42, 33 } },
  { { 32, 14, 30 }, { 42, 27, 34 } }, { { 30, 34, 32 }, { 34, 45, 42 } },
  { { 35, 29, 13 }, { 35, 14, 6 } }, { { 13, 33, 35 }, { 6, 33, 35 } },
  { { 34, 30, 35 }, { 45, 34, 35 } }, { { 29, 35, 30 }, { 14, 35, 34 } },
  { { 36, 3, 40 }, { 20, 22, 43 } }, { { 19, 40, 3 }, { 39, 43, 22 } },
  { { 37, 7, 3 }, { 16, 3, 22 } }, { { 3, 36, 37 }, { 22, 20, 16 } },
  { { 38, 11, 7 }, { 15, 2, 3 } }, { { 7, 37, 38 }, { 3, 16, 15 } },
  { { 39, 15, 11 }, { 19, 21, 2 } }, { { 11, 38, 39 }, { 2, 15, 19 } },
  { { 40, 19, 23 }, { 43, 39, 41 } }, { { 23, 41, 40 }, { 41, 47, 43 } },
  { { 41, 23, 27 }, { 47, 41, 40 } }, { { 27, 42, 41 }, { 40, 46, 47 } },
  { { 43, 31, 15 }, { 44, 38, 21 } }, { { 15, 39, 43 }, { 21, 19, 44 } },
  { { 42, 27, 31 }, { 46, 40, 38 } }, { { 31, 43, 42 }, { 38, 44, 46 } },
  { { 44, 4, 8 }, { 37, 10, 11 } }, { { 8, 45, 44 }, { 11, 36, 37 } },
  { { 47, 24, 20 }, { 25, 18, 17 } }, { { 20, 46, 47 }, { 17, 26, 25 } },
  { { 45, 8, 24 }, { 36, 11, 18 } }, { { 24, 47, 45 }, { 18, 25, 36 } },
  { { 46, 20, 4 }, { 26, 17, 10 } }, { { 4, 44, 46 }, { 10, 37, 26 } }
};

float Monk_matrix_Llower_arm[16] = {
  0.939692f, -0.31244f, 0.0f, 41.75566f,
  0.0f, 0.0f, -0.999999f, 4.915867f,
  0.342020f, 0.858423f, 0.0f, 97.80647f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Llower_arm[66] = {
  { -7.97703f, -16.998699f, 5.000002f, 0.687941f, 1.177419f },
  { -7.97703f, -16.998699f, 5.000002f, 1.259541f, 1.177419f },
  { -7.363418f, -16.940021f, 10.750242f, 0.689115f, 1.292424f },
  { -7.363418f, -16.940021f, 10.750242f, 1.247268f, 0.689115f },
  { -7.363418f, -16.940021f, 10.750242f, 1.247268f, 1.292424f },
  { -7.363411f, -16.940022f, -7.441553f, 0.689115f, 0.928588f },
  { -7.363411f, -16.940022f, -7.441553f, 0.952732f, 0.689115f },
  { -7.363411f, -16.940022f, -7.441553f, 1.247268f, 0.928588f },
  { -6.468254f, -6.875829f, 5.0f, 0.890399f, 1.177419f },
  { -5.255458f, -6.875818f, 9.827704f, 0.890399f, 1.273973f },
  { -5.255458f, -6.875818f, 9.827704f, 1.205109f, 0.890399f },
  { -5.255455f, -6.875819f, -2.953073f, 0.890399f, 1.018358f },
  { -5.255455f, -6.875819f, -2.953073f, 0.994891f, 0.890399f },
  { -4.999997f, 13.473956f, 5.0f, 1.297394f, 1.177419f },
  { -4.062499f, 24.078129f, 5.0f, 1.01875f, 1.177419f },
  { -4.062499f, 24.078129f, 5.0f, 1.509478f, 1.177419f },
  { -4.062498f, 13.473962f, 0.9375f, 1.01875f, 1.297394f },
  { -4.062498f, 13.473962f, 0.9375f, 1.297394f, 1.096169f },
  { -4.062498f, 13.473961f, 9.0625f, 1.18125f, 1.297394f },
  { -4.062498f, 13.473961f, 9.0625f, 1.297394f, 1.258669f },
  { -3.749997f, 23.770827f, 1.25f, 1.025f, 1.102419f },
  { -3.749997f, 23.770827f, 1.25f, 1.025f, 1.503332f },
  { -3.749997f, 23.770827f, 1.25f, 1.503332f, 1.102419f },
  { -3.749997f, 23.770826f, 8.75f, 1.025f, 1.252419f },
  { -3.749997f, 23.770826f, 8.75f, 1.175f, 1.503332f },
  { -3.749997f, 23.770826f, 8.75f, 1.503332f, 1.252419f },
  { -0.000001f, -6.87582f, -4.481199f, 1.1f, 0.890399f },
  { -0.000001f, -17.791527f, -10.107854f, 1.1f, 0.672085f },
  { -0.000001f, -17.791527f, -10.107854f, 1.1f, 0.875262f },
  { 0.000000f, 24.999996f, 5.0f, 1.1f, 1.177419f },
  { 0.000000f, -17.791528f, 12.365924f, 1.1f, 0.672085f },
  { 0.000000f, -17.791528f, 12.365924f, 1.1f, 1.324738f },
  { 0.000002f, 13.473963f, 0.000000f, 1.1f, 1.297394f },
  { 0.000002f, 13.473962f, 10.0f, 1.1f, 1.297394f },
  { 0.000002f, -11.298856f, 5.000004f, 1.1f, 1.177419f },
  { 0.000003f, -6.875822f, 11.355825f, 1.1f, 0.890399f },
  { 0.000003f, 24.078129f, 0.9375f, 1.1f, 1.096169f },
  { 0.000003f, 24.078129f, 0.9375f, 1.1f, 1.509478f },
  { 0.000004f, 24.078129f, 9.0625f, 1.1f, 1.258669f },
  { 0.000004f, 24.078129f, 9.0625f, 1.1f, 1.509478f },
  { 3.750002f, 23.770832f, 1.25f, 0.696668f, 1.102419f },
  { 3.750002f, 23.770832f, 1.25f, 1.175f, 1.102419f },
  { 3.750002f, 23.770832f, 1.25f, 1.175f, 1.503332f },
  { 3.750002f, 23.770831f, 8.75f, 0.696668f, 1.252419f },
  { 3.750002f, 23.770831f, 8.75f, 1.025f, 1.503332f },
  { 3.750002f, 23.770831f, 8.75f, 1.175f, 1.252419f },
  { 4.062498f, 24.078123f, 5.0f, 0.690522f, 1.177419f },
  { 4.062498f, 24.078123f, 5.0f, 1.18125f, 1.177419f },
  { 4.0625f, 13.473956f, 0.9375f, 0.902606f, 1.096169f },
  { 4.0625f, 13.473956f, 0.9375f, 1.18125f, 1.297394f },
  { 4.0625f, 13.473955f, 9.0625f, 0.902606f, 1.258669f },
  { 4.0625f, 13.473955f, 9.0625f, 1.01875f, 1.297394f },
  { 5.000002f, 13.47396f, 5.0f, 0.902606f, 1.177419f },
  { 5.255456f, -6.875823f, -2.953073f, 1.205109f, 0.890399f },
  { 5.255456f, -6.875823f, -2.953073f, 1.309601f, 1.018358f },
  { 5.255457f, -6.875823f, 9.827704f, 0.994891f, 0.890399f },
  { 5.255457f, -6.875823f, 9.827704f, 1.309601f, 1.273973f },
  { 6.468257f, -6.875823f, 5.0f, 1.309601f, 1.177419f },
  { 7.363411f, -16.940019f, -7.441552f, 0.952732f, 0.928588f },
  { 7.363411f, -16.940019f, -7.441552f, 1.247268f, 0.689115f },
  { 7.363411f, -16.940019f, -7.441552f, 1.510885f, 0.928588f },
  { 7.363411f, -16.94002f, 10.750242f, 0.952732f, 0.689115f },
  { 7.363411f, -16.94002f, 10.750242f, 0.952732f, 1.292424f },
  { 7.363411f, -16.94002f, 10.750242f, 1.510885f, 1.292424f },
  { 7.977029f, -16.998705f, 5.000002f, 0.940459f, 1.177419f },
  { 7.977029f, -16.998705f, 5.000002f, 1.512059f, 1.177419f }
};


TEST_NORMAL Monk_normal_Llower_arm[34] = {
  { -0.997571f, -0.069181f, -0.008127f }, { -0.991312f, -0.127338f, -0.032939f },
  { -0.749932f, -0.279178f, 0.599717f }, { -0.748497f, -0.663073f, 0.009294f },
  { -0.713393f, -0.112867f, 0.691615f }, { -0.703277f, -0.145114f, -0.695948f },
  { -0.703054f, -0.078333f, -0.706809f }, { -0.665518f, 0.534656f, 0.520797f },
  { -0.604442f, -0.518943f, -0.604441f }, { -0.577126f, 0.666452f, -0.471983f },
  { -0.576451f, -0.558182f, 0.596773f }, { -0.560405f, 0.828164f, 0.009533f },
  { -0.02876f, -0.662828f, 0.748219f }, { -0.009772f, -0.064198f, -0.997889f },
  { -0.009724f, -0.140444f, 0.990041f }, { -0.002668f, -0.343697f, 0.939077f },
  { -0.001588f, 0.62883f, 0.777542f }, { 0.0f, -1.0f, 0.0f },
  { 0.0f, 0.990898f, 0.134617f }, { 0.006405f, -0.08586f, -0.996287f },
  { 0.009295f, -0.663073f, -0.748497f }, { 0.014651f, 0.854442f, -0.519341f },
  { 0.559352f, 0.827728f, -0.044635f }, { 0.58203f, -0.567875f, -0.58203f },
  { 0.590472f, 0.654809f, -0.471771f }, { 0.609583f, -0.529429f, 0.590011f },
  { 0.650757f, 0.540347f, 0.533423f }, { 0.705145f, -0.060609f, -0.706468f },
  { 0.709454f, -0.114524f, -0.695384f }, { 0.720528f, -0.124113f, 0.682228f },
  { 0.733523f, -0.297349f, 0.611169f }, { 0.748497f, -0.663073f, -0.009294f },
  { 0.990498f, -0.123033f, -0.061445f }, { 0.997101f, -0.076044f, 0.002749f }
};

TEST_TRIANGLE3 Monk_triangle3_Llower_arm[64] = {
  { { 26, 53, 59 }, { 15, 2, 7 } }, { { 59, 27, 26 }, { 7, 16, 15 } },
  { { 12, 26, 27 }, { 30, 15, 16 } }, { { 27, 6, 12 }, { 16, 26, 30 } },
  { { 32, 49, 53 }, { 14, 4, 2 } }, { { 53, 26, 32 }, { 2, 15, 14 } },
  { { 16, 32, 26 }, { 29, 14, 15 } }, { { 26, 12, 16 }, { 15, 30, 29 } },
  { { 37, 42, 49 }, { 12, 10, 4 } }, { { 49, 32, 37 }, { 4, 14, 12 } },
  { { 21, 37, 32 }, { 25, 12, 14 } }, { { 32, 16, 21 }, { 14, 29, 25 } },
  { { 35, 30, 61 }, { 19, 21, 9 } }, { { 61, 55, 35 }, { 9, 5, 19 } },
  { { 10, 3, 30 }, { 28, 24, 21 } }, { { 30, 35, 10 }, { 21, 19, 28 } },
  { { 33, 35, 55 }, { 13, 19, 5 } }, { { 55, 51, 33 }, { 5, 6, 13 } },
  { { 18, 10, 35 }, { 27, 28, 19 } }, { { 35, 33, 18 }, { 19, 13, 27 } },
  { { 39, 33, 51 }, { 20, 13, 6 } }, { { 51, 44, 39 }, { 6, 8, 20 } },
  { { 24, 18, 33 }, { 23, 27, 13 } }, { { 33, 39, 24 }, { 13, 20, 23 } },
  { { 34, 28, 58 }, { 18, 16, 7 } }, { { 58, 64, 34 }, { 7, 11, 18 } },
  { { 1, 7, 34 }, { 22, 26, 18 } }, { { 28, 34, 7 }, { 16, 18, 26 } },
  { { 31, 34, 62 }, { 21, 18, 9 } }, { { 64, 62, 34 }, { 11, 9, 18 } },
  { { 4, 1, 34 }, { 24, 22, 18 } }, { { 34, 31, 4 }, { 18, 21, 24 } },
  { { 8, 11, 5 }, { 32, 30, 26 } }, { { 5, 0, 8 }, { 26, 22, 32 } },
  { { 13, 17, 11 }, { 33, 29, 30 } }, { { 11, 8, 13 }, { 30, 32, 33 } },
  { { 15, 22, 17 }, { 31, 25, 29 } }, { { 17, 13, 15 }, { 29, 33, 31 } },
  { { 9, 8, 0 }, { 28, 32, 22 } }, { { 0, 2, 9 }, { 22, 24, 28 } },
  { { 19, 13, 8 }, { 27, 33, 32 } }, { { 8, 9, 19 }, { 32, 28, 27 } },
  { { 25, 15, 13 }, { 23, 31, 33 } }, { { 13, 19, 25 }, { 33, 27, 23 } },
  { { 29, 36, 20 }, { 17, 12, 25 } }, { { 20, 14, 29 }, { 25, 31, 17 } },
  { { 47, 41, 36 }, { 3, 10, 12 } }, { { 36, 29, 47 }, { 12, 17, 3 } },
  { { 38, 29, 14 }, { 20, 17, 31 } }, { { 14, 23, 38 }, { 31, 23, 20 } },
  { { 45, 47, 29 }, { 8, 3, 17 } }, { { 29, 38, 45 }, { 17, 20, 8 } },
  { { 52, 48, 40 }, { 0, 4, 10 } }, { { 40, 46, 52 }, { 10, 3, 0 } },
  { { 57, 54, 48 }, { 1, 2, 4 } }, { { 48, 52, 57 }, { 4, 0, 1 } },
  { { 65, 60, 54 }, { 11, 7, 2 } }, { { 54, 57, 65 }, { 2, 1, 11 } },
  { { 50, 52, 46 }, { 6, 0, 3 } }, { { 46, 43, 50 }, { 3, 8, 6 } },
  { { 56, 57, 52 }, { 5, 1, 0 } }, { { 52, 50, 56 }, { 0, 6, 5 } },
  { { 63, 65, 57 }, { 9, 11, 1 } }, { { 57, 56, 63 }, { 1, 5, 9 } }
};

float Monk_matrix_Rlower_arm[16] = {
  0.939692f, 0.31244f, 0.0f, -41.75563f,
  0.0f, 0.0f, -0.999999f, 4.915868f,
  -0.34202f, 0.858423f, 0.0f, 97.80647f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Rlower_arm[66] = {
  { -7.977034f, -16.998699f, 5.000002f, 0.940459f, 1.177419f },
  { -7.977034f, -16.998699f, 5.000002f, 1.512059f, 1.177419f },
  { -7.363417f, -16.940021f, -7.441553f, 0.952732f, 0.928588f },
  { -7.363417f, -16.940021f, -7.441553f, 1.247268f, 0.689115f },
  { -7.363417f, -16.940021f, -7.441553f, 1.510885f, 0.928588f },
  { -7.363416f, -16.940014f, 10.750242f, 0.952732f, 0.689115f },
  { -7.363416f, -16.940014f, 10.750242f, 0.952732f, 1.292424f },
  { -7.363416f, -16.940014f, 10.750242f, 1.510885f, 1.292424f },
  { -6.468256f, -6.875823f, 5.0f, 1.309601f, 1.177419f },
  { -5.255462f, -6.875818f, 9.827704f, 0.994891f, 0.890399f },
  { -5.255462f, -6.875818f, 9.827704f, 1.309601f, 1.273973f },
  { -5.255459f, -6.875824f, -2.953073f, 1.205109f, 0.890399f },
  { -5.255459f, -6.875824f, -2.953073f, 1.309601f, 1.018358f },
  { -5.000003f, 13.47395f, 5.0f, 0.902606f, 1.177419f },
  { -4.062508f, 24.078127f, 5.0f, 0.690522f, 1.177419f },
  { -4.062508f, 24.078127f, 5.0f, 1.18125f, 1.177419f },
  { -4.062503f, 13.473953f, 9.062501f, 0.902606f, 1.258669f },
  { -4.062503f, 13.473953f, 9.062501f, 1.01875f, 1.297394f },
  { -4.062503f, 13.473954f, 0.937501f, 0.902606f, 1.096169f },
  { -4.062503f, 13.473954f, 0.937501f, 1.18125f, 1.297394f },
  { -3.750008f, 23.770837f, 1.25f, 0.696668f, 1.102419f },
  { -3.750008f, 23.770837f, 1.25f, 1.175f, 1.102419f },
  { -3.750008f, 23.770837f, 1.25f, 1.175f, 1.503332f },
  { -3.750005f, 23.770838f, 8.75f, 0.696668f, 1.252419f },
  { -3.750005f, 23.770838f, 8.75f, 1.025f, 1.503332f },
  { -3.750005f, 23.770838f, 8.75f, 1.175f, 1.252419f },
  { -0.000008f, 24.078126f, 9.0625f, 1.1f, 1.258669f },
  { -0.000008f, 24.078126f, 9.0625f, 1.1f, 1.509478f },
  { -0.000006f, 25.000002f, 5.0f, 1.1f, 1.177419f },
  { -0.000006f, -6.875822f, -4.481198f, 1.1f, 0.890399f },
  { -0.000006f, 13.473961f, 0.000000f, 1.1f, 1.297394f },
  { -0.000005f, -17.791522f, 12.365924f, 1.1f, 0.672085f },
  { -0.000005f, -17.791522f, 12.365924f, 1.1f, 1.324738f },
  { -0.000005f, 24.07812f, 0.9375f, 1.1f, 1.096169f },
  { -0.000005f, 24.07812f, 0.9375f, 1.1f, 1.509478f },
  { -0.000005f, -17.791519f, -10.107855f, 1.1f, 0.672085f },
  { -0.000005f, -17.791519f, -10.107855f, 1.1f, 0.875262f },
  { -0.000003f, 13.473952f, 10.000001f, 1.1f, 1.297394f },
  { -0.000003f, -6.875823f, 11.355825f, 1.1f, 0.890399f },
  { -0.000002f, -11.298856f, 5.000005f, 1.1f, 1.177419f },
  { 3.749995f, 23.770835f, 1.25f, 1.025f, 1.102419f },
  { 3.749995f, 23.770835f, 1.25f, 1.025f, 1.503332f },
  { 3.749995f, 23.770835f, 1.25f, 1.503332f, 1.102419f },
  { 3.749997f, 23.770835f, 8.75f, 1.025f, 1.252419f },
  { 3.749997f, 23.770835f, 8.75f, 1.175f, 1.503332f },
  { 3.749997f, 23.770835f, 8.75f, 1.503332f, 1.252419f },
  { 4.062496f, 24.078128f, 5.0f, 1.01875f, 1.177419f },
  { 4.062496f, 24.078128f, 5.0f, 1.509478f, 1.177419f },
  { 4.062497f, 13.473953f, 0.937501f, 1.01875f, 1.297394f },
  { 4.062497f, 13.473953f, 0.937501f, 1.297394f, 1.096169f },
  { 4.0625f, 13.473953f, 9.062501f, 1.18125f, 1.297394f },
  { 4.0625f, 13.473953f, 9.062501f, 1.297394f, 1.258669f },
  { 4.999996f, 13.473956f, 5.0f, 1.297394f, 1.177419f },
  { 5.255451f, -6.87582f, -2.953074f, 0.890399f, 1.018358f },
  { 5.255451f, -6.87582f, -2.953074f, 0.994891f, 0.890399f },
  { 5.255454f, -6.87582f, 9.827704f, 0.890399f, 1.273973f },
  { 5.255454f, -6.87582f, 9.827704f, 1.205109f, 0.890399f },
  { 6.468251f, -6.875821f, 5.0f, 0.890399f, 1.177419f },
  { 7.363411f, -16.940021f, -7.441554f, 0.689115f, 0.928588f },
  { 7.363411f, -16.940021f, -7.441554f, 0.952732f, 0.689115f },
  { 7.363411f, -16.940021f, -7.441554f, 1.247268f, 0.928588f },
  { 7.363412f, -16.940014f, 10.750242f, 0.689115f, 1.292424f },
  { 7.363412f, -16.940014f, 10.750242f, 1.247268f, 0.689115f },
  { 7.363412f, -16.940014f, 10.750242f, 1.247268f, 1.292424f },
  { 7.97703f, -16.998698f, 5.000002f, 0.687941f, 1.177419f },
  { 7.97703f, -16.998698f, 5.000002f, 1.259541f, 1.177419f }
};


TEST_NORMAL Monk_normal_Rlower_arm[34] = {
  { -0.997571f, 0.069181f, 0.008127f }, { -0.991312f, 0.127338f, 0.032938f },
  { -0.749932f, 0.279179f, -0.599717f }, { -0.748497f, 0.663072f, -0.009295f },
  { -0.713393f, 0.112867f, -0.691615f }, { -0.703277f, 0.145114f, 0.695948f },
  { -0.703054f, 0.078333f, 0.706809f }, { -0.665518f, -0.534656f, -0.520797f },
  { -0.604441f, 0.518943f, 0.604441f }, { -0.577126f, -0.666452f, 0.471983f },
  { -0.576449f, 0.558183f, -0.596773f }, { -0.560405f, -0.828164f, -0.009533f },
  { -0.028761f, 0.662826f, -0.748221f }, { -0.009772f, 0.064198f, 0.997889f },
  { -0.009724f, 0.140444f, -0.990041f }, { -0.002669f, 0.343697f, -0.939077f },
  { -0.001588f, -0.628829f, -0.777542f }, { 0.0f, -0.990898f, -0.134617f },
  { 0.0f, 1.0f, 0.0f }, { 0.006405f, 0.08586f, 0.996287f },
  { 0.009295f, 0.663072f, 0.748498f }, { 0.014652f, -0.854442f, 0.519341f },
  { 0.559352f, -0.827728f, 0.044636f }, { 0.582029f, 0.567877f, 0.582029f },
  { 0.590472f, -0.654809f, 0.471772f }, { 0.609583f, 0.52943f, -0.590011f },
  { 0.650757f, -0.540347f, -0.533424f }, { 0.705145f, 0.060609f, 0.706468f },
  { 0.709454f, 0.114524f, 0.695384f }, { 0.720528f, 0.124114f, -0.682228f },
  { 0.733523f, 0.297349f, -0.611169f }, { 0.748497f, 0.663073f, 0.009295f },
  { 0.990498f, 0.123033f, 0.061445f }, { 0.997101f, 0.076044f, -0.002749f }
};

TEST_TRIANGLE3 Monk_triangle3_Rlower_arm[64] = {
  { { 29, 11, 3 }, { 15, 2, 7 } }, { { 3, 35, 29 }, { 7, 16, 15 } },
  { { 54, 29, 35 }, { 30, 15, 16 } }, { { 35, 59, 54 }, { 16, 26, 30 } },
  { { 30, 19, 11 }, { 14, 4, 2 } }, { { 11, 29, 30 }, { 2, 15, 14 } },
  { { 48, 30, 29 }, { 29, 14, 15 } }, { { 29, 54, 48 }, { 15, 30, 29 } },
  { { 34, 22, 19 }, { 12, 10, 4 } }, { { 19, 30, 34 }, { 4, 14, 12 } },
  { { 41, 34, 30 }, { 25, 12, 14 } }, { { 30, 48, 41 }, { 14, 29, 25 } },
  { { 38, 31, 5 }, { 19, 21, 9 } }, { { 5, 9, 38 }, { 9, 5, 19 } },
  { { 56, 62, 31 }, { 28, 24, 21 } }, { { 31, 38, 56 }, { 21, 19, 28 } },
  { { 37, 38, 9 }, { 13, 19, 5 } }, { { 9, 17, 37 }, { 5, 6, 13 } },
  { { 50, 56, 38 }, { 27, 28, 19 } }, { { 38, 37, 50 }, { 19, 13, 27 } },
  { { 27, 37, 17 }, { 20, 13, 6 } }, { { 17, 24, 27 }, { 6, 8, 20 } },
  { { 44, 50, 37 }, { 23, 27, 13 } }, { { 37, 27, 44 }, { 13, 20, 23 } },
  { { 39, 36, 2 }, { 17, 16, 7 } }, { { 2, 0, 39 }, { 7, 11, 17 } },
  { { 65, 60, 39 }, { 22, 26, 17 } }, { { 36, 39, 60 }, { 16, 17, 26 } },
  { { 32, 39, 6 }, { 21, 17, 9 } }, { { 0, 6, 39 }, { 11, 9, 17 } },
  { { 63, 65, 39 }, { 24, 22, 17 } }, { { 39, 32, 63 }, { 17, 21, 24 } },
  { { 57, 53, 58 }, { 32, 30, 26 } }, { { 58, 64, 57 }, { 26, 22, 32 } },
  { { 52, 49, 53 }, { 33, 29, 30 } }, { { 53, 57, 52 }, { 30, 32, 33 } },
  { { 47, 42, 49 }, { 31, 25, 29 } }, { { 49, 52, 47 }, { 29, 33, 31 } },
  { { 55, 57, 64 }, { 28, 32, 22 } }, { { 64, 61, 55 }, { 22, 24, 28 } },
  { { 51, 52, 57 }, { 27, 33, 32 } }, { { 57, 55, 51 }, { 32, 28, 27 } },
  { { 45, 47, 52 }, { 23, 31, 33 } }, { { 52, 51, 45 }, { 33, 27, 23 } },
  { { 28, 33, 40 }, { 18, 12, 25 } }, { { 40, 46, 28 }, { 25, 31, 18 } },
  { { 15, 21, 33 }, { 3, 10, 12 } }, { { 33, 28, 15 }, { 12, 18, 3 } },
  { { 26, 28, 46 }, { 20, 18, 31 } }, { { 46, 43, 26 }, { 31, 23, 20 } },
  { { 25, 15, 28 }, { 8, 3, 18 } }, { { 28, 26, 25 }, { 18, 20, 8 } },
  { { 13, 18, 20 }, { 0, 4, 10 } }, { { 20, 14, 13 }, { 10, 3, 0 } },
  { { 8, 12, 18 }, { 1, 2, 4 } }, { { 18, 13, 8 }, { 4, 0, 1 } },
  { { 1, 4, 12 }, { 11, 7, 2 } }, { { 12, 8, 1 }, { 2, 1, 11 } },
  { { 16, 13, 14 }, { 6, 0, 3 } }, { { 14, 23, 16 }, { 3, 8, 6 } },
  { { 10, 8, 13 }, { 5, 1, 0 } }, { { 13, 16, 10 }, { 0, 6, 5 } },
  { { 7, 1, 8 }, { 9, 11, 1 } }, { { 8, 10, 7 }, { 1, 5, 9 } }
};

float Monk_matrix_Rope_belt[16] = {
  0.933580f, 0.0f, -0.358367f, 10.1313f,
  0.195181f, 0.83867f, 0.508464f, -17.11292f,
  0.300552f, -0.544639f, 0.782966f, 95.04119f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Rope_belt[120] = {
  { -22.118886f, 5.454729f, 21.057842f, 2.463346f, 3.849128f },
  { -22.118886f, 5.454729f, 21.057842f, 2.998413f, 1.536654f },
  { -21.691233f, 1.034451f, 17.818903f, 2.672261f, 1.091544f },
  { -21.691233f, 1.034451f, 17.818903f, 2.672261f, 3.806064f },
  { -21.691233f, 1.034451f, 17.818903f, 2.908456f, 3.806064f },
  { -21.517785f, 4.365454f, 22.623769f, 1.426966f, 3.788598f },
  { -21.517785f, 4.365454f, 22.623769f, 3.156098f, 1.426966f },
  { -21.090132f, -0.054824f, 19.38483f, 0.981856f, 3.745535f },
  { -21.090132f, -0.054824f, 19.38483f, 2.829946f, 0.981856f },
  { -21.090132f, -0.054824f, 19.38483f, 2.829946f, 3.745535f },
  { -20.195174f, 5.697726f, 20.488429f, 2.438877f, 3.655415f },
  { -19.874108f, 2.379075f, 18.056707f, 2.773056f, 3.623085f },
  { -19.723642f, 15.746793f, 27.297663f, 1.426963f, 3.607933f },
  { -19.723642f, 15.746793f, 27.297663f, 3.626747f, 2.573037f },
  { -19.594068f, 4.608448f, 22.054362f, 1.451436f, 3.594885f },
  { -19.273001f, 1.289797f, 19.62264f, 1.117256f, 3.562555f },
  { -19.122538f, 14.657514f, 28.863596f, 2.46335f, 3.547403f },
  { -19.122538f, 14.657514f, 28.863596f, 3.784432f, 2.46335f },
  { -17.913047f, 15.503749f, 26.433577f, 1.451437f, 3.425611f },
  { -17.311946f, 14.41447f, 27.999511f, 2.438876f, 3.365081f },
  { -17.238588f, 20.167029f, 29.418499f, 0.159691f, 3.357694f },
  { -17.238588f, 20.167029f, 29.418499f, 0.981857f, 3.357694f },
  { -17.238588f, 20.167029f, 29.418499f, 3.840309f, 3.018143f },
  { -17.117995f, -0.286973f, 15.144206f, 2.402926f, 3.345551f },
  { -17.117995f, -0.286973f, 15.144206f, 3.04152f, 3.345551f },
  { -16.637482f, 19.077749f, 30.984431f, 0.002005f, 3.297164f },
  { -16.637482f, 19.077749f, 30.984431f, 2.908456f, 3.297164f },
  { -16.637482f, 19.077749f, 30.984431f, 3.997994f, 2.908456f },
  { -16.51689f, -1.376251f, 16.710139f, 0.848792f, 3.285022f },
  { -16.51689f, -1.376251f, 16.710139f, 2.560611f, 3.285022f },
  { -16.452398f, 1.390374f, 16.055476f, 2.872617f, 3.278527f },
  { -16.047281f, 18.822432f, 28.025885f, 1.117254f, 3.237733f },
  { -15.85129f, 0.301095f, 17.621407f, 1.017696f, 3.217997f },
  { -15.446176f, 17.733152f, 29.591817f, 2.773058f, 3.177203f },
  { -12.165384f, 19.811126f, 27.2235f, 1.017696f, 2.846836f },
  { -12.050281f, 21.488461f, 28.346096f, 0.267679f, 2.835245f },
  { -12.050281f, 21.488461f, 28.346096f, 0.848792f, 2.835245f },
  { -11.564277f, 18.721844f, 28.789439f, 2.872617f, 2.786306f },
  { -11.449173f, 20.399184f, 29.912028f, 0.109994f, 2.774715f },
  { -11.449173f, 20.399184f, 29.912028f, 3.04152f, 2.774715f },
  { -7.701025f, 1.000002f, -7.456767f, 0.127068f, 1.088074f },
  { -7.701025f, 1.000002f, -7.456767f, 2.911926f, 2.397287f },
  { -7.701025f, 1.000002f, -7.456767f, 3.872932f, 2.397287f },
  { -7.701025f, -0.999997f, -7.456765f, 0.127068f, 0.88668f },
  { -7.701025f, -0.999997f, -7.456765f, 0.127068f, 2.397287f },
  { -7.701025f, -0.999997f, -7.456765f, 3.11332f, 2.397287f },
  { -5.833864f, 1.000002f, -8.173502f, 2.911926f, 2.209269f },
  { -5.833864f, 1.000002f, -8.173502f, 3.945105f, 1.088074f },
  { -5.833864f, 1.000002f, -8.173502f, 3.945105f, 2.209269f },
  { -5.833864f, -0.999997f, -8.173501f, 0.054895f, 2.209269f },
  { -5.833864f, -0.999997f, -8.173501f, 3.113321f, 2.209269f },
  { -5.833864f, -0.999997f, -8.173501f, 3.945105f, 0.886679f },
  { -1.000003f, -0.999996f, -8.698735f, 0.002005f, 0.886679f },
  { -1.000003f, -0.999996f, -8.698735f, 0.002005f, 1.722512f },
  { -1.000003f, -0.999996f, -8.698735f, 3.113321f, 1.722512f },
  { -1.000001f, 1.000001f, -8.69873f, 0.002005f, 1.088074f },
  { -1.000001f, 1.000001f, -8.69873f, 2.911926f, 1.722512f },
  { -1.000001f, 1.000001f, -8.69873f, 3.997994f, 1.722512f },
  { -1.000001f, 0.999999f, 10.000002f, 1.884918f, 1.088074f },
  { -1.000001f, 0.999999f, 10.000002f, 2.115082f, 1.722512f },
  { -1.0f, -1.000001f, 10.000003f, 1.884918f, 0.886679f },
  { -1.0f, -1.000001f, 10.000003f, 1.884918f, 1.722512f },
  { -0.999998f, 1.000002f, 10.000003f, 1.884919f, 1.088074f },
  { -0.999998f, 1.000002f, 10.000003f, 2.115081f, 1.722512f },
  { -0.999998f, -0.999999f, 10.000003f, 1.884919f, 0.886679f },
  { -0.999998f, -0.999999f, 10.000003f, 1.884919f, 1.722512f },
  { 0.867162f, 1.000002f, 9.283267f, 2.187255f, 1.088074f },
  { 0.867162f, 1.000002f, 9.283267f, 2.187255f, 1.534494f },
  { 0.867163f, -0.999999f, 9.283268f, 1.812745f, 1.534494f },
  { 0.867163f, -0.999999f, 9.283268f, 2.187255f, 0.886679f },
  { 0.999999f, 1.000002f, -8.69873f, 2.911926f, 1.521117f },
  { 0.999999f, 1.000002f, -8.69873f, 3.997994f, 1.088074f },
  { 0.999999f, 1.000002f, -8.69873f, 3.997994f, 1.521117f },
  { 0.999999f, 0.999999f, 10.000001f, 2.115082f, 1.088074f },
  { 0.999999f, 0.999999f, 10.000001f, 2.115082f, 1.521117f },
  { 0.999999f, -0.999999f, -8.698729f, 0.002005f, 1.521117f },
  { 0.999999f, -0.999999f, -8.698729f, 3.113321f, 1.521117f },
  { 0.999999f, -0.999999f, -8.698729f, 3.997994f, 0.886679f },
  { 1.0f, -1.000001f, 10.000002f, 1.884918f, 1.521117f },
  { 1.0f, -1.000001f, 10.000002f, 2.115082f, 0.886679f },
  { 3.937837f, -0.286964f, 7.061617f, 1.589031f, 1.225285f },
  { 3.937837f, -0.286964f, 7.061617f, 3.04152f, 1.225285f },
  { 4.052933f, 1.390375f, 8.184209f, 2.872616f, 1.213695f },
  { 4.538942f, -1.376242f, 8.627549f, 0.848793f, 1.164755f },
  { 4.538942f, -1.376242f, 8.627549f, 1.746716f, 1.164755f },
  { 4.654038f, 0.3011f, 9.750134f, 1.017696f, 1.153165f },
  { 7.934843f, 2.379066f, 7.381826f, 2.773058f, 0.822797f },
  { 8.339947f, 19.811124f, 19.35223f, 1.017696f, 0.782004f },
  { 8.535949f, 1.289787f, 8.947758f, 1.117254f, 0.762267f },
  { 8.941054f, 18.721846f, 20.918162f, 2.872617f, 0.721474f },
  { 9.005546f, 21.488468f, 20.263497f, 0.848792f, 0.714979f },
  { 9.005546f, 21.488468f, 20.263497f, 1.081574f, 0.714979f },
  { 9.126153f, 1.034471f, 5.989212f, 1.481042f, 0.702835f },
  { 9.126153f, 1.034471f, 5.989212f, 2.518958f, 1.091545f },
  { 9.126153f, 1.034471f, 5.989212f, 2.908455f, 0.702835f },
  { 9.606656f, 20.399187f, 21.829436f, 0.923889f, 0.654449f },
  { 9.606656f, 20.399187f, 21.829436f, 3.041521f, 0.654449f },
  { 9.727256f, -0.054808f, 7.555145f, 0.981857f, 0.642306f },
  { 9.727256f, -0.054808f, 7.555145f, 1.638728f, 0.642306f },
  { 9.727256f, -0.054808f, 7.555145f, 2.361273f, 0.981857f },
  { 9.800611f, 5.697749f, 8.974133f, 2.438875f, 0.634919f },
  { 10.401715f, 4.608471f, 10.540067f, 1.451437f, 0.574389f },
  { 11.611205f, 5.454709f, 8.11005f, 2.305395f, 1.536651f },
  { 11.611205f, 5.454709f, 8.11005f, 2.463349f, 0.452597f },
  { 11.761667f, 18.82242f, 17.351003f, 1.117256f, 0.437445f },
  { 12.08273f, 15.503775f, 14.919277f, 1.451435f, 0.405115f },
  { 12.21231f, 4.365429f, 9.675982f, 1.426964f, 0.392067f },
  { 12.21231f, 4.365429f, 9.675982f, 2.14771f, 1.426964f },
  { 12.362774f, 17.733145f, 18.916937f, 2.773057f, 0.376916f },
  { 12.683837f, 14.414497f, 16.485209f, 2.438878f, 0.344586f },
  { 13.578795f, 20.167044f, 17.588806f, 0.981856f, 0.254465f },
  { 13.578795f, 20.167044f, 17.588806f, 1.350909f, 0.254465f },
  { 13.578795f, 20.167044f, 17.588806f, 1.350909f, 3.018144f },
  { 14.006446f, 15.746775f, 14.349864f, 1.426965f, 0.211402f },
  { 14.006446f, 15.746775f, 14.349864f, 1.677062f, 2.573035f },
  { 14.179904f, 19.077767f, 19.154738f, 1.193224f, 0.193936f },
  { 14.179904f, 19.077767f, 19.154738f, 1.193224f, 2.908457f },
  { 14.179904f, 19.077767f, 19.154738f, 2.908457f, 0.193936f },
  { 14.607554f, 14.657497f, 15.915796f, 1.519377f, 2.463347f },
  { 14.607554f, 14.657497f, 15.915796f, 2.463347f, 0.150872f }
};


TEST_NORMAL Monk_normal_Rope_belt[58] = {
  { -0.904523f, 0.2797f, -0.32188f }, { -0.863288f, 0.456883f, -0.214458f },
  { -0.815493f, -0.13234f, -0.563434f }, { -0.745907f, -0.57735f, -0.332099f },
  { -0.745907f, 0.57735f, -0.332099f }, { -0.707107f, 0.707107f, 0.0f },
  { -0.707107f, -0.707107f, 0.0f }, { -0.660141f, 0.707107f, 0.253404f },
  { -0.660141f, -0.707107f, 0.253404f }, { -0.598201f, 0.801342f, 0.002635f },
  { -0.57735f, -0.577349f, -0.577351f }, { -0.57735f, 0.577351f, -0.57735f },
  { -0.49805f, -0.456883f, 0.737024f }, { -0.456813f, -0.279701f, 0.844446f },
  { -0.446313f, -0.801342f, 0.398315f }, { -0.445797f, -0.243618f, -0.861345f },
  { -0.300554f, 0.544636f, -0.782968f }, { -0.300554f, 0.544642f, -0.782964f },
  { -0.300553f, 0.544636f, -0.782968f }, { -0.300553f, 0.544639f, -0.782966f },
  { -0.300553f, 0.544639f, -0.782966f }, { -0.300553f, 0.544639f, -0.782966f },
  { -0.300553f, 0.544639f, -0.782967f }, { -0.300553f, 0.544639f, -0.782966f },
  { -0.300553f, 0.544639f, -0.782966f }, { -0.245061f, -0.243616f, -0.938401f },
  { -0.229019f, 0.132339f, 0.964384f }, { -0.161111f, 0.979649f, -0.11971f },
  { -0.039624f, -0.979649f, 0.196768f }, { 0.039624f, 0.979649f, -0.196769f },
  { 0.161111f, -0.979649f, 0.119713f }, { 0.22902f, -0.132339f, -0.964384f },
  { 0.245061f, 0.243616f, 0.938401f }, { 0.300549f, -0.544639f, 0.782968f },
  { 0.30055f, -0.544639f, 0.782967f }, { 0.300552f, -0.54464f, 0.782966f },
  { 0.300552f, -0.54464f, 0.782966f }, { 0.300553f, -0.544639f, 0.782966f },
  { 0.300553f, -0.544639f, 0.782966f }, { 0.300553f, -0.544639f, 0.782966f },
  { 0.300553f, -0.544636f, 0.782968f }, { 0.300555f, -0.544636f, 0.782968f },
  { 0.332099f, 0.57735f, -0.745907f }, { 0.332099f, -0.57735f, -0.745907f },
  { 0.445796f, 0.243616f, 0.861346f }, { 0.446311f, 0.801343f, -0.398316f },
  { 0.456812f, 0.279701f, -0.844446f }, { 0.498048f, 0.456884f, -0.737025f },
  { 0.577351f, 0.577351f, -0.57735f }, { 0.577351f, -0.577351f, -0.577349f },
  { 0.5982f, -0.801342f, -0.002634f }, { 0.660141f, -0.707107f, -0.253404f },
  { 0.660141f, 0.707107f, -0.253404f }, { 0.707107f, -0.707107f, 0.0f },
  { 0.707107f, 0.707107f, 0.0f }, { 0.815493f, 0.132341f, 0.563433f },
  { 0.863288f, -0.456883f, 0.214458f }, { 0.904523f, -0.2797f, 0.321878f }
};

TEST_TRIANGLE3 Monk_triangle3_Rope_belt[92] = {
  { { 70, 56, 54 }, { 48, 11, 10 } }, { { 54, 76, 70 }, { 10, 49, 48 } },
  { { 78, 75, 53 }, { 53, 49, 10 } }, { { 53, 61, 78 }, { 10, 6, 53 } },
  { { 73, 71, 77 }, { 54, 48, 49 } }, { { 77, 79, 73 }, { 49, 53, 54 } },
  { { 59, 57, 72 }, { 5, 11, 48 } }, { { 72, 74, 59 }, { 48, 54, 5 } },
  { { 60, 52, 55 }, { 6, 10, 11 } }, { { 55, 58, 60 }, { 11, 5, 6 } },
  { { 46, 41, 45 }, { 42, 4, 3 } }, { { 45, 50, 46 }, { 3, 43, 42 } },
  { { 68, 49, 44 }, { 51, 43, 3 } }, { { 44, 65, 68 }, { 3, 8, 51 } },
  { { 66, 47, 51 }, { 52, 42, 43 } }, { { 51, 69, 66 }, { 43, 51, 52 } },
  { { 63, 42, 48 }, { 7, 4, 42 } }, { { 48, 67, 63 }, { 42, 52, 7 } },
  { { 64, 43, 40 }, { 8, 3, 4 } }, { { 40, 62, 64 }, { 4, 7, 8 } },
  { { 37, 33, 26 }, { 39, 37, 26 } }, { { 26, 39, 37 }, { 26, 32, 39 } },
  { { 36, 21, 31 }, { 27, 9, 21 } }, { { 31, 34, 36 }, { 21, 17, 27 } },
  { { 38, 25, 20 }, { 32, 26, 9 } }, { { 20, 35, 38 }, { 9, 27, 32 } },
  { { 89, 37, 39 }, { 38, 39, 32 } }, { { 39, 96, 89 }, { 32, 44, 38 } },
  { { 90, 36, 34 }, { 29, 27, 17 } }, { { 34, 87, 90 }, { 17, 18, 29 } },
  { { 95, 38, 35 }, { 44, 32, 27 } }, { { 35, 91, 95 }, { 27, 29, 44 } },
  { { 108, 89, 96 }, { 37, 38, 44 } }, { { 96, 117, 108 }, { 44, 55, 37 } },
  { { 110, 90, 87 }, { 45, 29, 18 } }, { { 87, 104, 110 }, { 18, 23, 45 } },
  { { 115, 95, 91 }, { 55, 44, 29 } }, { { 91, 111, 115 }, { 29, 45, 55 } },
  { { 109, 108, 117 }, { 37, 37, 55 } }, { { 117, 119, 109 }, { 55, 57, 37 } },
  { { 113, 110, 104 }, { 47, 45, 23 } }, { { 104, 105, 113 }, { 23, 23, 47 } },
  { { 118, 116, 112 }, { 57, 55, 45 } }, { { 112, 114, 118 }, { 45, 47, 57 } },
  { { 101, 109, 119 }, { 37, 37, 57 } }, { { 119, 106, 101 }, { 57, 56, 37 } },
  { { 103, 113, 105 }, { 46, 47, 23 } }, { { 105, 100, 103 }, { 23, 23, 46 } },
  { { 107, 118, 114 }, { 56, 57, 47 } }, { { 114, 102, 107 }, { 47, 46, 56 } },
  { { 88, 101, 106 }, { 35, 37, 56 } }, { { 106, 97, 88 }, { 56, 50, 35 } },
  { { 94, 103, 100 }, { 31, 46, 23 } }, { { 100, 86, 94 }, { 23, 23, 31 } },
  { { 99, 107, 102 }, { 50, 56, 46 } }, { { 102, 93, 99 }, { 46, 31, 50 } },
  { { 85, 88, 97 }, { 40, 35, 50 } }, { { 97, 83, 85 }, { 50, 30, 40 } },
  { { 81, 94, 86 }, { 25, 31, 23 } }, { { 86, 82, 81 }, { 23, 19, 25 } },
  { { 84, 98, 92 }, { 30, 50, 31 } }, { { 92, 80, 84 }, { 31, 25, 30 } },
  { { 32, 85, 83 }, { 41, 40, 30 } }, { { 83, 28, 32 }, { 30, 28, 41 } },
  { { 24, 81, 82 }, { 15, 25, 19 } }, { { 82, 30, 24 }, { 19, 16, 15 } },
  { { 29, 84, 80 }, { 28, 30, 25 } }, { { 80, 23, 29 }, { 25, 15, 28 } },
  { { 15, 32, 28 }, { 34, 41, 28 } }, { { 28, 7, 15 }, { 28, 14, 34 } },
  { { 4, 24, 30 }, { 2, 15, 16 } }, { { 30, 11, 4 }, { 16, 20, 2 } },
  { { 9, 29, 23 }, { 14, 28, 15 } }, { { 23, 3, 9 }, { 15, 2, 14 } },
  { { 14, 15, 7 }, { 33, 34, 14 } }, { { 7, 5, 14 }, { 14, 12, 33 } },
  { { 0, 4, 11 }, { 0, 2, 20 } }, { { 11, 10, 0 }, { 20, 22, 0 } },
  { { 6, 8, 2 }, { 12, 14, 2 } }, { { 2, 1, 6 }, { 2, 0, 12 } },
  { { 19, 14, 5 }, { 36, 33, 12 } }, { { 5, 16, 19 }, { 12, 13, 36 } },
  { { 12, 0, 10 }, { 1, 0, 22 } }, { { 10, 18, 12 }, { 22, 24, 1 } },
  { { 17, 6, 1 }, { 13, 12, 0 } }, { { 1, 13, 17 }, { 0, 1, 13 } },
  { { 33, 19, 16 }, { 37, 36, 13 } }, { { 16, 26, 33 }, { 13, 26, 37 } },
  { { 21, 12, 18 }, { 9, 1, 24 } }, { { 18, 31, 21 }, { 24, 21, 9 } },
  { { 27, 17, 13 }, { 26, 13, 1 } }, { { 13, 22, 27 }, { 1, 9, 26 } }
};

float Monk_matrix_Lupper_arm[16] = {
  0.983734f, -0.139609f, -0.044945f, 30.866245f,
  -0.044892f, 0.003161f, -0.998982f, 5.000385f,
  0.166908f, 0.823691f, -0.003783f, 137.520657f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Lupper_arm[57] = {
  { -5.000004f, 13.473963f, 5.0f, 1.378698f, 1.1f },
  { -5.000002f, -13.473957f, 4.999999f, 0.83974f, 1.1f },
  { -4.062505f, -13.473956f, 9.0625f, 0.83974f, 1.18125f },
  { -4.062505f, -13.473956f, 9.0625f, 1.18125f, 0.83974f },
  { -4.062504f, -24.078128f, 4.999999f, 0.627656f, 1.1f },
  { -4.062504f, -24.078128f, 4.999999f, 1.18125f, 1.1f },
  { -4.062504f, -13.473961f, 0.937499f, 0.83974f, 1.01875f },
  { -4.062504f, -13.473961f, 0.937499f, 1.01875f, 0.83974f },
  { -4.062502f, 13.473954f, 9.062501f, 1.18125f, 1.378698f },
  { -4.062502f, 13.473954f, 9.062501f, 1.378698f, 1.18125f },
  { -4.062502f, 13.473958f, 0.9375f, 1.01875f, 1.378698f },
  { -4.062502f, 13.473958f, 0.9375f, 1.378698f, 1.01875f },
  { -4.062501f, 24.07814f, 5.0f, 1.590781f, 1.1f },
  { -3.750005f, -23.770835f, 8.75f, 0.633802f, 1.175f },
  { -3.750005f, -23.770835f, 8.75f, 1.175f, 0.633802f },
  { -3.750005f, -23.770835f, 8.75f, 1.175f, 1.175f },
  { -3.750003f, 23.770843f, 8.750001f, 1.175f, 1.584635f },
  { -3.750003f, 23.770843f, 8.750001f, 1.584635f, 1.175f },
  { -3.750003f, 23.770846f, 1.25f, 1.025f, 1.584635f },
  { -3.750003f, 23.770846f, 1.25f, 1.584635f, 1.025f },
  { -3.750003f, -23.770832f, 1.25f, 0.633802f, 1.025f },
  { -3.750003f, -23.770832f, 1.25f, 1.025f, 0.633802f },
  { -3.750003f, -23.770832f, 1.25f, 1.175f, 1.025f },
  { -0.000006f, -24.07812f, 0.9375f, 1.1f, 1.01875f },
  { -0.000006f, -24.07812f, 0.9375f, 1.1f, 0.627656f },
  { -0.000005f, 24.078136f, 9.062501f, 1.1f, 1.590781f },
  { -0.000004f, 13.473951f, 10.000001f, 1.1f, 1.378698f },
  { -0.000003f, -25.000003f, 5.000001f, 1.1f, 1.1f },
  { -0.000003f, 24.078121f, 0.9375f, 1.1f, 1.590781f },
  { -0.000003f, -13.473959f, 9.999998f, 1.1f, 0.83974f },
  { -0.000002f, -13.473964f, 0.000000f, 1.1f, 0.83974f },
  { -0.000002f, -24.078124f, 9.0625f, 1.1f, 0.627656f },
  { -0.000002f, -24.078124f, 9.0625f, 1.1f, 1.18125f },
  { -0.000002f, 13.473974f, 0.000001f, 1.1f, 1.378698f },
  { 3.749993f, -23.770827f, 1.25f, 1.025f, 1.025f },
  { 3.749993f, -23.770827f, 1.25f, 1.175f, 0.633802f },
  { 3.749993f, -23.770827f, 1.25f, 1.566198f, 1.025f },
  { 3.749996f, 23.770847f, 8.75f, 0.615365f, 1.175f },
  { 3.749996f, 23.770847f, 8.75f, 1.025f, 1.584635f },
  { 3.749997f, -23.770831f, 8.75f, 1.025f, 0.633802f },
  { 3.749997f, -23.770831f, 8.75f, 1.025f, 1.175f },
  { 3.749997f, -23.770831f, 8.75f, 1.566198f, 1.175f },
  { 3.749998f, 23.770832f, 1.25f, 0.615365f, 1.025f },
  { 3.749998f, 23.770832f, 1.25f, 1.175f, 1.584635f },
  { 4.062493f, -13.473957f, 0.9375f, 1.18125f, 0.83974f },
  { 4.062493f, -13.473957f, 0.9375f, 1.36026f, 1.01875f },
  { 4.062495f, -24.078125f, 5.0f, 1.01875f, 1.1f },
  { 4.062495f, -24.078125f, 5.0f, 1.572344f, 1.1f },
  { 4.062496f, 13.473953f, 0.9375f, 0.821302f, 1.01875f },
  { 4.062496f, 13.473953f, 0.9375f, 1.18125f, 1.378698f },
  { 4.062497f, 24.078116f, 5.0f, 0.609219f, 1.1f },
  { 4.062499f, 13.473948f, 9.0625f, 0.821302f, 1.18125f },
  { 4.062499f, 13.473948f, 9.0625f, 1.01875f, 1.378698f },
  { 4.062501f, -13.473963f, 9.0625f, 1.01875f, 0.83974f },
  { 4.062501f, -13.473963f, 9.0625f, 1.36026f, 1.18125f },
  { 4.999993f, -13.473956f, 5.0f, 1.36026f, 1.1f },
  { 4.999997f, 13.473963f, 5.0f, 0.821302f, 1.1f }
};


TEST_NORMAL Monk_normal_Lupper_arm[33] = {
  { -0.999392f, -0.034076f, -0.007415f }, { -0.999392f, 0.034076f, 0.007416f },
  { -0.99761f, -0.067336f, -0.015469f }, { -0.748498f, 0.663072f, -0.009294f },
  { -0.711854f, 0.03261f, 0.70157f }, { -0.706947f, 0.021292f, -0.706946f },
  { -0.706455f, -0.042881f, -0.706457f }, { -0.706421f, -0.044038f, -0.706421f },
  { -0.70157f, -0.03261f, 0.711854f }, { -0.692012f, -0.070043f, 0.71848f },
  { -0.609583f, 0.529429f, 0.590011f }, { -0.58203f, 0.567876f, -0.582029f },
  { -0.015469f, -0.067336f, 0.99761f }, { -0.015469f, -0.067336f, -0.99761f },
  { -0.009295f, 0.663072f, -0.748498f }, { -0.007416f, -0.034076f, 0.999392f },
  { -0.007416f, -0.034076f, -0.999392f }, { 0.0f, 1.0f, 0.0f },
  { 0.007415f, 0.034076f, 0.999392f }, { 0.007416f, 0.034076f, -0.999392f },
  { 0.02876f, 0.662826f, 0.748221f }, { 0.57645f, 0.558182f, 0.596773f },
  { 0.604441f, 0.518943f, -0.604441f }, { 0.70157f, 0.03261f, 0.711854f },
  { 0.703817f, -0.096351f, -0.703817f }, { 0.706421f, 0.044038f, -0.706421f },
  { 0.706946f, -0.021292f, -0.706947f }, { 0.711853f, -0.03261f, 0.701571f },
  { 0.718481f, -0.070043f, 0.692011f }, { 0.748497f, 0.663073f, 0.009295f },
  { 0.99761f, -0.067336f, 0.015469f }, { 0.999392f, -0.034076f, 0.007416f },
  { 0.999392f, 0.034076f, -0.007415f }
};

TEST_TRIANGLE3 Monk_triangle3_Lupper_arm[56] = {
  { { 30, 44, 35 }, { 18, 4, 10 } }, { { 35, 24, 30 }, { 10, 20, 18 } },
  { { 7, 30, 24 }, { 23, 18, 20 } }, { { 24, 21, 7 }, { 20, 21, 23 } },
  { { 33, 49, 44 }, { 15, 8, 4 } }, { { 44, 30, 33 }, { 4, 18, 15 } },
  { { 10, 33, 30 }, { 27, 15, 18 } }, { { 30, 7, 10 }, { 18, 23, 27 } },
  { { 28, 43, 49 }, { 12, 9, 8 } }, { { 49, 33, 28 }, { 8, 15, 12 } },
  { { 18, 28, 33 }, { 28, 12, 15 } }, { { 33, 10, 18 }, { 15, 27, 28 } },
  { { 29, 31, 39 }, { 19, 14, 11 } }, { { 39, 53, 29 }, { 11, 5, 19 } },
  { { 3, 14, 31 }, { 25, 22, 14 } }, { { 31, 29, 3 }, { 14, 19, 25 } },
  { { 26, 29, 53 }, { 16, 19, 5 } }, { { 53, 52, 26 }, { 5, 7, 16 } },
  { { 8, 3, 29 }, { 26, 25, 19 } }, { { 29, 26, 8 }, { 19, 16, 26 } },
  { { 25, 26, 52 }, { 13, 16, 7 } }, { { 52, 38, 25 }, { 7, 6, 13 } },
  { { 16, 8, 26 }, { 24, 26, 16 } }, { { 26, 25, 16 }, { 16, 13, 24 } },
  { { 27, 23, 34 }, { 17, 20, 10 } }, { { 34, 46, 27 }, { 10, 3, 17 } },
  { { 5, 22, 23 }, { 29, 21, 20 } }, { { 23, 27, 5 }, { 20, 17, 29 } },
  { { 32, 27, 46 }, { 14, 17, 3 } }, { { 46, 40, 32 }, { 3, 11, 14 } },
  { { 15, 5, 27 }, { 22, 29, 17 } }, { { 27, 32, 15 }, { 17, 14, 22 } },
  { { 1, 6, 20 }, { 32, 23, 21 } }, { { 20, 4, 1 }, { 21, 29, 32 } },
  { { 0, 11, 6 }, { 31, 27, 23 } }, { { 6, 1, 0 }, { 23, 32, 31 } },
  { { 12, 19, 11 }, { 30, 28, 27 } }, { { 11, 0, 12 }, { 27, 31, 30 } },
  { { 2, 1, 4 }, { 25, 32, 29 } }, { { 4, 13, 2 }, { 29, 22, 25 } },
  { { 9, 0, 1 }, { 26, 31, 32 } }, { { 1, 2, 9 }, { 32, 25, 26 } },
  { { 17, 12, 0 }, { 24, 30, 31 } }, { { 0, 9, 17 }, { 31, 26, 24 } },
  { { 56, 48, 42 }, { 0, 8, 9 } }, { { 42, 50, 56 }, { 9, 2, 0 } },
  { { 55, 45, 48 }, { 1, 4, 8 } }, { { 48, 56, 55 }, { 8, 0, 1 } },
  { { 47, 36, 45 }, { 3, 10, 4 } }, { { 45, 55, 47 }, { 4, 1, 3 } },
  { { 51, 56, 50 }, { 7, 0, 2 } }, { { 50, 37, 51 }, { 2, 6, 7 } },
  { { 54, 55, 56 }, { 5, 1, 0 } }, { { 56, 51, 54 }, { 0, 7, 5 } },
  { { 41, 47, 55 }, { 11, 3, 1 } }, { { 55, 54, 41 }, { 1, 5, 11 } }
};

float Monk_matrix_Rupper_arm[16] = {
  0.983734f, 0.139609f, 0.044945f, -30.86621f,
  0.044892f, 0.003161f, -0.998982f, 5.000384f,
  -0.166902f, 0.823692f, -0.003783f, 137.5207f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Rupper_arm[57] = {
  { -5.000001f, 13.473962f, 5.0f, 0.821302f, 1.1f },
  { -4.999996f, -13.473955f, 5.0f, 1.36026f, 1.1f },
  { -4.062502f, -13.473951f, 9.0625f, 1.01875f, 0.83974f },
  { -4.062502f, -13.473951f, 9.0625f, 1.36026f, 1.18125f },
  { -4.0625f, -13.473958f, 0.9375f, 1.18125f, 0.83974f },
  { -4.0625f, -13.473958f, 0.9375f, 1.36026f, 1.01875f },
  { -4.062499f, 13.473968f, 9.062499f, 0.821302f, 1.18125f },
  { -4.062499f, 13.473968f, 9.062499f, 1.01875f, 1.378698f },
  { -4.062498f, -24.078123f, 5.0f, 1.01875f, 1.1f },
  { -4.062498f, -24.078123f, 5.0f, 1.572344f, 1.1f },
  { -4.062498f, 24.078133f, 5.0f, 0.609219f, 1.1f },
  { -4.062496f, 13.473952f, 0.937501f, 0.821302f, 1.01875f },
  { -4.062496f, 13.473952f, 0.937501f, 1.18125f, 1.378698f },
  { -3.75f, 23.770847f, 8.75f, 0.615365f, 1.175f },
  { -3.75f, 23.770847f, 8.75f, 1.025f, 1.584635f },
  { -3.75f, -23.770828f, 8.750001f, 1.025f, 0.633802f },
  { -3.75f, -23.770828f, 8.750001f, 1.025f, 1.175f },
  { -3.75f, -23.770828f, 8.750001f, 1.566198f, 1.175f },
  { -3.75f, 23.770849f, 1.25f, 0.615365f, 1.025f },
  { -3.75f, 23.770849f, 1.25f, 1.175f, 1.584635f },
  { -3.749999f, -23.770826f, 1.25f, 1.025f, 1.025f },
  { -3.749999f, -23.770826f, 1.25f, 1.175f, 0.633802f },
  { -3.749999f, -23.770826f, 1.25f, 1.566198f, 1.025f },
  { -0.000002f, -13.473948f, 9.999998f, 1.1f, 0.83974f },
  { -0.000001f, 24.078137f, 0.9375f, 1.1f, 1.590781f },
  { -0.000001f, -24.999992f, 5.0f, 1.1f, 1.1f },
  { -0.000001f, 13.473973f, 0.000000f, 1.1f, 1.378698f },
  { 0.000001f, 24.078135f, 9.0625f, 1.1f, 1.590781f },
  { 0.000002f, -24.078111f, 9.0625f, 1.1f, 0.627656f },
  { 0.000002f, -24.078111f, 9.0625f, 1.1f, 1.18125f },
  { 0.000002f, -24.078109f, 0.9375f, 1.1f, 1.01875f },
  { 0.000002f, -24.078109f, 0.9375f, 1.1f, 0.627656f },
  { 0.000002f, -13.473954f, 0.000000f, 1.1f, 0.83974f },
  { 0.000003f, 13.473952f, 10.0f, 1.1f, 1.378698f },
  { 3.75f, 23.770844f, 1.25f, 1.025f, 1.584635f },
  { 3.75f, 23.770844f, 1.25f, 1.584635f, 1.025f },
  { 3.750001f, 23.770843f, 8.75f, 1.175f, 1.584635f },
  { 3.750001f, 23.770843f, 8.75f, 1.584635f, 1.175f },
  { 3.750002f, -23.770832f, 8.749999f, 0.633802f, 1.175f },
  { 3.750002f, -23.770832f, 8.749999f, 1.175f, 0.633802f },
  { 3.750002f, -23.770832f, 8.749999f, 1.175f, 1.175f },
  { 3.750002f, -23.77083f, 1.25f, 0.633802f, 1.025f },
  { 3.750002f, -23.77083f, 1.25f, 1.025f, 0.633802f },
  { 3.750002f, -23.77083f, 1.25f, 1.175f, 1.025f },
  { 4.0625f, -24.078117f, 5.0f, 0.627656f, 1.1f },
  { 4.0625f, -24.078117f, 5.0f, 1.18125f, 1.1f },
  { 4.0625f, 24.078139f, 5.0f, 1.590781f, 1.1f },
  { 4.062501f, -13.473951f, 0.937499f, 0.83974f, 1.01875f },
  { 4.062501f, -13.473951f, 0.937499f, 1.01875f, 0.83974f },
  { 4.062501f, 13.473957f, 0.9375f, 1.01875f, 1.378698f },
  { 4.062501f, 13.473957f, 0.9375f, 1.378698f, 1.01875f },
  { 4.062501f, 13.473956f, 9.062499f, 1.18125f, 1.378698f },
  { 4.062501f, 13.473956f, 9.062499f, 1.378698f, 1.18125f },
  { 4.062503f, -13.473953f, 9.062499f, 0.83974f, 1.18125f },
  { 4.062503f, -13.473953f, 9.062499f, 1.18125f, 0.83974f },
  { 5.000001f, -13.473955f, 5.0f, 0.83974f, 1.1f },
  { 5.000002f, 13.473963f, 5.0f, 1.378698f, 1.1f }
};


TEST_NORMAL Monk_normal_Rupper_arm[33] = {
  { -0.999392f, -0.034076f, -0.007416f }, { -0.999392f, 0.034076f, 0.007415f },
  { -0.99761f, 0.067337f, 0.015469f }, { -0.748497f, -0.663073f, 0.009295f },
  { -0.711854f, -0.03261f, -0.70157f }, { -0.706947f, -0.021292f, 0.706946f },
  { -0.706456f, 0.04288f, 0.706456f }, { -0.706421f, 0.044038f, 0.706421f },
  { -0.70157f, 0.03261f, -0.711854f }, { -0.692012f, 0.070043f, -0.71848f },
  { -0.609583f, -0.52943f, -0.590011f }, { -0.582029f, -0.567877f, 0.582029f },
  { -0.015469f, 0.067336f, -0.99761f }, { -0.015469f, 0.067336f, 0.99761f },
  { -0.009295f, -0.663072f, 0.748498f }, { -0.007416f, 0.034076f, -0.999392f },
  { -0.007415f, 0.034075f, 0.999392f }, { 0.0f, -1.0f, 0.0f },
  { 0.007416f, -0.034075f, 0.999392f }, { 0.007416f, -0.034076f, -0.999392f },
  { 0.028761f, -0.662826f, -0.748221f }, { 0.576449f, -0.558184f, -0.596772f },
  { 0.604441f, -0.518944f, 0.604441f }, { 0.70157f, -0.03261f, -0.711854f },
  { 0.703817f, 0.096351f, 0.703817f }, { 0.706421f, -0.044038f, 0.706421f },
  { 0.706947f, 0.021292f, 0.706946f }, { 0.711854f, 0.03261f, -0.70157f },
  { 0.71848f, 0.070043f, -0.692012f }, { 0.748497f, -0.663073f, -0.009295f },
  { 0.99761f, 0.067336f, -0.015469f }, { 0.999392f, -0.034076f, 0.007416f },
  { 0.999392f, 0.034076f, -0.007416f }
};

TEST_TRIANGLE3 Monk_triangle3_Rupper_arm[56] = {
  { { 32, 4, 21 }, { 19, 4, 10 } }, { { 21, 31, 32 }, { 10, 20, 19 } },
  { { 48, 32, 31 }, { 23, 19, 20 } }, { { 31, 42, 48 }, { 20, 21, 23 } },
  { { 26, 12, 4 }, { 15, 8, 4 } }, { { 4, 32, 26 }, { 4, 19, 15 } },
  { { 49, 26, 32 }, { 27, 15, 19 } }, { { 32, 48, 49 }, { 19, 23, 27 } },
  { { 24, 19, 12 }, { 12, 9, 8 } }, { { 12, 26, 24 }, { 8, 15, 12 } },
  { { 34, 24, 26 }, { 28, 12, 15 } }, { { 26, 49, 34 }, { 15, 27, 28 } },
  { { 23, 28, 15 }, { 18, 14, 11 } }, { { 15, 2, 23 }, { 11, 5, 18 } },
  { { 54, 39, 28 }, { 25, 22, 14 } }, { { 28, 23, 54 }, { 14, 18, 25 } },
  { { 33, 23, 2 }, { 16, 18, 5 } }, { { 2, 7, 33 }, { 5, 7, 16 } },
  { { 51, 54, 23 }, { 26, 25, 18 } }, { { 23, 33, 51 }, { 18, 16, 26 } },
  { { 27, 33, 7 }, { 13, 16, 7 } }, { { 7, 14, 27 }, { 7, 6, 13 } },
  { { 36, 51, 33 }, { 24, 26, 16 } }, { { 33, 27, 36 }, { 16, 13, 24 } },
  { { 25, 30, 20 }, { 17, 20, 10 } }, { { 20, 8, 25 }, { 10, 3, 17 } },
  { { 45, 43, 30 }, { 29, 21, 20 } }, { { 30, 25, 45 }, { 20, 17, 29 } },
  { { 29, 25, 8 }, { 14, 17, 3 } }, { { 8, 16, 29 }, { 3, 11, 14 } },
  { { 40, 45, 25 }, { 22, 29, 17 } }, { { 25, 29, 40 }, { 17, 14, 22 } },
  { { 55, 47, 41 }, { 31, 23, 21 } }, { { 41, 44, 55 }, { 21, 29, 31 } },
  { { 56, 50, 47 }, { 32, 27, 23 } }, { { 47, 55, 56 }, { 23, 31, 32 } },
  { { 46, 35, 50 }, { 30, 28, 27 } }, { { 50, 56, 46 }, { 27, 32, 30 } },
  { { 53, 55, 44 }, { 25, 31, 29 } }, { { 44, 38, 53 }, { 29, 22, 25 } },
  { { 52, 56, 55 }, { 26, 32, 31 } }, { { 55, 53, 52 }, { 31, 25, 26 } },
  { { 37, 46, 56 }, { 24, 30, 32 } }, { { 56, 52, 37 }, { 32, 26, 24 } },
  { { 0, 11, 18 }, { 1, 8, 9 } }, { { 18, 10, 0 }, { 9, 2, 1 } },
  { { 1, 5, 11 }, { 0, 4, 8 } }, { { 11, 0, 1 }, { 8, 1, 0 } },
  { { 9, 22, 5 }, { 3, 10, 4 } }, { { 5, 1, 9 }, { 4, 0, 3 } },
  { { 6, 0, 10 }, { 7, 1, 2 } }, { { 10, 13, 6 }, { 2, 6, 7 } },
  { { 3, 1, 0 }, { 5, 0, 1 } }, { { 0, 6, 3 }, { 1, 7, 5 } },
  { { 17, 9, 1 }, { 11, 3, 0 } }, { { 1, 3, 17 }, { 0, 5, 11 } }
};

float Monk_matrix_Shawl[16] = {
  0.792079f, 0.0f, 0.0f, 0.0f,
  0.0f, 0.0f, -1.198198f, -18.06461f,
  0.0f, 0.999999f, 0.0f, 163.7218f,
  0.0f, 0.0f, 0.0f, 1.0f
};

TEST_XYZ_UV Monk_xyz_uv_Shawl[149] = {
  { -40.900613f, -8.191438f, -7.5f, 0.780092f, 0.946551f },
  { -40.900613f, -8.191437f, -15.0f, 0.780092f, 0.8f },
  { -40.900613f, -8.191436f, -22.500002f, 0.780092f, 0.653449f },
  { -38.522038f, -15.838917f, -7.500001f, 0.262992f, 0.946551f },
  { -38.522038f, -15.838917f, -7.500001f, 0.929524f, 0.946551f },
  { -38.522038f, -15.838931f, -15.000001f, 0.262992f, 0.8f },
  { -38.522038f, -15.838931f, -15.000001f, 0.929524f, 0.8f },
  { -38.522038f, -15.83893f, -22.5f, 0.262992f, 0.653449f },
  { -38.522038f, -15.83893f, -22.5f, 0.929524f, 0.653449f },
  { -38.009032f, -8.799075f, -0.937501f, 0.270144f, 0.808035f },
  { -38.009032f, -8.799075f, -0.937501f, 0.791965f, 1.074782f },
  { -38.00903f, -8.799071f, -29.0625f, 0.791965f, 0.525218f },
  { -38.00903f, -8.799071f, -29.0625f, 1.329856f, 0.808035f },
  { -37.558182f, -15.888097f, -1.25f, 0.276429f, 0.669515f },
  { -37.558182f, -15.888097f, -1.25f, 0.276429f, 1.068676f },
  { -37.558182f, -15.888097f, -1.25f, 0.930485f, 1.068676f },
  { -37.558175f, -15.888093f, -28.75f, 0.276429f, 0.531324f },
  { -37.558175f, -15.888093f, -28.75f, 0.930485f, 0.531324f },
  { -37.558175f, -15.888093f, -28.75f, 1.323571f, 0.669515f },
  { -36.691983f, -0.691436f, -7.788462f, 0.633541f, 0.940914f },
  { -36.691983f, -0.691436f, -7.788462f, 1.311496f, 0.940914f },
  { -36.691976f, -0.691435f, -15.000002f, 0.633541f, 0.8f },
  { -36.691976f, -0.691435f, -15.000002f, 1.311496f, 0.8f },
  { -36.691976f, -0.691434f, -22.211537f, 0.633541f, 0.659086f },
  { -36.691976f, -0.691434f, -22.211537f, 1.311496f, 0.659086f },
  { -34.086952f, -0.691422f, -1.478367f, 0.324819f, 0.966459f },
  { -34.086952f, -0.691422f, -1.478367f, 0.633541f, 1.064214f },
  { -34.086952f, -0.691422f, -1.478367f, 1.275181f, 1.064214f },
  { -34.086945f, -0.691433f, -28.521636f, 0.633541f, 0.535786f },
  { -34.086945f, -0.691433f, -28.521636f, 1.275181f, 0.535786f },
  { -34.086945f, -0.691433f, -28.521636f, 1.275181f, 0.966459f },
  { -28.601152f, 6.808566f, -8.561126f, 1.198708f, 0.925816f },
  { -28.601152f, 6.808567f, -14.999999f, 1.198708f, 0.8f },
  { -28.601152f, 6.808568f, -21.438872f, 1.198708f, 0.674184f },
  { -26.627648f, 6.808566f, -2.927112f, 0.428804f, 1.113009f },
  { -26.627648f, 6.808566f, -2.927112f, 1.171197f, 1.035905f },
  { -26.627644f, 6.808569f, -27.072885f, 1.171196f, 0.564095f },
  { -26.627644f, 6.808569f, -27.072885f, 1.171196f, 1.113009f },
  { -21.525739f, 12.02622f, -9.930021f, 1.100075f, 0.899068f },
  { -21.525736f, 12.02622f, -15.0f, 1.100074f, 0.8f },
  { -21.525736f, 12.026221f, -20.069977f, 1.100075f, 0.700932f },
  { -21.39741f, 11.713722f, -24.294958f, 1.098286f, 0.618376f },
  { -21.39741f, 11.713722f, -24.294958f, 1.098286f, 1.208856f },
  { -21.397403f, 11.713719f, -5.705039f, 0.501715f, 1.208856f },
  { -21.397403f, 11.713719f, -5.705039f, 1.098286f, 0.981624f },
  { -18.88741f, -23.040336f, -0.937502f, 0.536704f, 0.529759f },
  { -18.88741f, -23.040336f, -0.937502f, 0.536704f, 1.074782f },
  { -18.88741f, -24.455191f, -7.500002f, 0.536704f, 0.946551f },
  { -18.88741f, -24.45519f, -15.000001f, 0.536704f, 0.8f },
  { -18.887406f, -24.455189f, -22.5f, 0.536704f, 0.653449f },
  { -18.887406f, -23.040332f, -29.0625f, 0.536704f, 0.525218f },
  { -18.887406f, -23.040332f, -29.0625f, 1.063296f, 0.529759f },
  { -18.660957f, -12.314609f, -0.000001f, 0.539861f, 0.739341f },
  { -18.660957f, -12.314605f, -30.000002f, 1.060139f, 0.739341f },
  { -16.743067f, -1.299068f, -29.423078f, 1.033403f, 0.954585f },
  { -16.743063f, -1.299073f, -0.576924f, 0.566597f, 0.954585f },
  { -13.38974f, 6.808569f, -27.877747f, 0.986657f, 1.113009f },
  { -13.389738f, 6.808566f, -2.122253f, 0.613344f, 1.113009f },
  { -12.096407f, 12.96372f, -9.930022f, 0.968627f, 0.899068f },
  { -12.096407f, 12.963721f, -20.069977f, 0.968627f, 0.700932f },
  { -12.096406f, 12.026219f, -5.493789f, 0.631373f, 1.214963f },
  { -12.096406f, 12.026219f, -5.493789f, 0.968627f, 0.985752f },
  { -12.096406f, 12.963721f, -15.0f, 0.968627f, 0.8f },
  { -12.096404f, 12.026222f, -24.50621f, 0.968627f, 0.614248f },
  { -12.096404f, 12.026222f, -24.50621f, 0.968627f, 1.214962f },
  { -0.000001f, 12.026222f, -24.506212f, 0.8f, 0.614248f },
  { -0.000001f, 12.026222f, -24.506212f, 0.8f, 1.214962f },
  { -0.000001f, 12.963721f, -20.069977f, 0.8f, 0.700932f },
  { -0.000001f, 6.808569f, -27.877747f, 0.8f, 1.113009f },
  { -0.000001f, 12.963721f, -15.0f, 0.8f, 0.8f },
  { -0.000001f, 12.96372f, -9.930022f, 0.8f, 0.899068f },
  { -0.000001f, -1.299068f, -29.423078f, 0.8f, 0.954585f },
  { -0.000001f, 6.808566f, -2.122253f, 0.8f, 1.113009f },
  { -0.000001f, 12.026219f, -5.493789f, 0.8f, 0.985752f },
  { -0.000001f, 12.026219f, -5.493789f, 0.8f, 1.214962f },
  { -0.000001f, -1.299073f, -0.576924f, 0.8f, 0.954585f },
  { -0.000001f, -14.091053f, -0.000001f, 0.8f, 0.704629f },
  { -0.000001f, -14.091064f, -30.0f, 0.8f, 0.704629f },
  { -0.000001f, -31.38424f, -7.500004f, 0.8f, 0.946551f },
  { -0.000001f, -28.800576f, -0.937503f, 0.8f, 0.417204f },
  { -0.000001f, -28.800576f, -0.937503f, 0.8f, 1.074782f },
  { -0.000001f, -31.384238f, -22.5f, 0.8f, 0.653449f },
  { -0.000001f, -28.800572f, -29.062501f, 0.8f, 0.525218f },
  { -0.000001f, -28.800572f, -29.062501f, 0.8f, 0.417204f },
  { 12.096398f, 12.96372f, -9.930021f, 0.631373f, 0.899068f },
  { 12.096402f, 12.026219f, -5.493791f, 0.631373f, 0.985752f },
  { 12.096402f, 12.026219f, -5.493791f, 0.968627f, 1.214962f },
  { 12.096402f, 12.963721f, -15.0f, 0.631373f, 0.8f },
  { 12.096402f, 12.963721f, -20.069977f, 0.631373f, 0.700932f },
  { 12.096402f, 12.026222f, -24.50621f, 0.631373f, 0.614248f },
  { 12.096402f, 12.026222f, -24.50621f, 0.631373f, 1.214962f },
  { 13.389734f, 6.808569f, -27.877747f, 0.613343f, 1.113009f },
  { 13.389738f, 6.808566f, -2.122253f, 0.986657f, 1.113009f },
  { 16.743059f, -1.299068f, -29.423078f, 0.566597f, 0.954585f },
  { 16.743065f, -1.299073f, -0.576924f, 1.033403f, 0.954585f },
  { 18.66095f, -12.314605f, -30.000002f, 0.539861f, 0.739341f },
  { 18.660952f, -12.314609f, -0.000001f, 1.060139f, 0.739341f },
  { 18.887402f, -23.040336f, -0.937502f, 1.063295f, 0.529759f },
  { 18.887402f, -23.040336f, -0.937502f, 1.063295f, 1.074782f },
  { 18.887402f, -24.455191f, -7.500002f, 1.063295f, 0.946551f },
  { 18.887402f, -24.45519f, -15.000001f, 1.063295f, 0.8f },
  { 18.887406f, -24.455189f, -22.5f, 1.063295f, 0.653449f },
  { 18.887406f, -23.040332f, -29.0625f, 0.536705f, 0.529759f },
  { 18.887406f, -23.040332f, -29.0625f, 1.063295f, 0.525218f },
  { 21.397395f, 11.713719f, -5.705039f, 0.501714f, 0.981624f },
  { 21.397395f, 11.713719f, -5.705039f, 1.098286f, 1.208856f },
  { 21.397405f, 11.713722f, -24.29496f, 0.501714f, 0.618376f },
  { 21.397405f, 11.713722f, -24.29496f, 0.501714f, 1.208856f },
  { 21.525731f, 12.02622f, -9.930021f, 0.499925f, 0.899068f },
  { 21.525731f, 12.02622f, -14.999999f, 0.499925f, 0.8f },
  { 21.525731f, 12.026221f, -20.069977f, 0.499925f, 0.700932f },
  { 26.627641f, 6.808566f, -2.927112f, 0.428803f, 1.035905f },
  { 26.627641f, 6.808566f, -2.927112f, 1.171197f, 1.113009f },
  { 26.627641f, 6.808569f, -27.072885f, 0.428804f, 0.564095f },
  { 26.627641f, 6.808569f, -27.072885f, 0.428804f, 1.113009f },
  { 28.601142f, 6.808566f, -8.561127f, 0.401292f, 0.925816f },
  { 28.601149f, 6.808567f, -15.000001f, 0.401292f, 0.8f },
  { 28.601149f, 6.808568f, -21.438872f, 0.401292f, 0.674184f },
  { 34.086937f, -0.691422f, -1.478365f, 0.324819f, 1.064214f },
  { 34.086937f, -0.691422f, -1.478365f, 0.966458f, 1.064214f },
  { 34.086937f, -0.691422f, -1.478365f, 1.275181f, 0.966458f },
  { 34.086949f, -0.691433f, -28.521636f, 0.324819f, 0.535786f },
  { 34.086949f, -0.691433f, -28.521636f, 0.324819f, 0.966458f },
  { 34.086949f, -0.691433f, -28.521636f, 0.966458f, 0.535786f },
  { 36.691975f, -0.691436f, -7.788463f, 0.288504f, 0.940914f },
  { 36.691975f, -0.691436f, -7.788463f, 0.966458f, 0.940914f },
  { 36.691975f, -0.691435f, -15.000002f, 0.288504f, 0.8f },
  { 36.691975f, -0.691435f, -15.000002f, 0.966458f, 0.8f },
  { 36.691975f, -0.691434f, -22.211541f, 0.288504f, 0.659086f },
  { 36.691975f, -0.691434f, -22.211541f, 0.966458f, 0.659086f },
  { 37.558167f, -15.888097f, -1.25f, 0.669515f, 1.068676f },
  { 37.558167f, -15.888097f, -1.25f, 1.323571f, 0.669515f },
  { 37.558167f, -15.888097f, -1.25f, 1.323571f, 1.068676f },
  { 37.558167f, -15.888093f, -28.75f, 0.276429f, 0.669515f },
  { 37.558167f, -15.888093f, -28.75f, 0.669515f, 0.531324f },
  { 37.558167f, -15.888093f, -28.75f, 1.323571f, 0.531324f },
  { 38.009022f, -8.799075f, -0.937501f, 0.808035f, 1.074782f },
  { 38.009022f, -8.799075f, -0.937501f, 1.329856f, 0.808035f },
  { 38.009034f, -8.799071f, -29.0625f, 0.270144f, 0.808035f },
  { 38.009034f, -8.799071f, -29.0625f, 0.808035f, 0.525218f },
  { 38.522031f, -15.838917f, -7.500001f, 0.670475f, 0.946551f },
  { 38.522031f, -15.838917f, -7.500001f, 1.337007f, 0.946551f },
  { 38.522031f, -15.838931f, -15.000001f, 0.670475f, 0.8f },
  { 38.522031f, -15.838931f, -15.000001f, 1.337007f, 0.8f },
  { 38.522031f, -15.83893f, -22.5f, 0.670475f, 0.653449f },
  { 38.522031f, -15.83893f, -22.5f, 1.337008f, 0.653449f },
  { 40.900606f, -8.191438f, -7.500001f, 0.819908f, 0.946551f },
  { 40.900606f, -8.191437f, -15.000002f, 0.819908f, 0.8f },
  { 40.900611f, -8.191436f, -22.499998f, 0.819908f, 0.653449f }
};


TEST_NORMAL Monk_normal_Shawl[97] = {
  { -0.994502f, 0.104719f, 0.0f }, { -0.97528f, 0.10381f, 0.195071f },
  { -0.975086f, 0.132404f, -0.177981f }, { -0.785483f, 0.618883f, 0.0f },
  { -0.781334f, 0.60203f, -0.164551f }, { -0.780291f, 0.606221f, 0.153761f },
  { -0.769265f, -0.632385f, 0.09122f }, { -0.747538f, -0.661334f, -0.06185f },
  { -0.74557f, -0.666427f, 0.0f }, { -0.637667f, 0.770312f, 0.0f },
  { -0.63751f, 0.763457f, 0.103514f }, { -0.631096f, 0.767198f, -0.114569f },
  { -0.62512f, 0.084335f, 0.775959f }, { -0.620669f, -0.475984f, 0.623065f },
  { -0.600101f, 0.129464f, -0.789378f }, { -0.570642f, -0.519869f, -0.635691f },
  { -0.494896f, 0.444176f, -0.74685f }, { -0.487634f, 0.443125f, 0.752232f },
  { -0.401841f, -0.915709f, 0.0f }, { -0.385815f, 0.61958f, -0.683569f },
  { -0.383647f, 0.609406f, 0.693858f }, { -0.368868f, -0.921258f, 0.123366f },
  { -0.365904f, 0.929316f, -0.049861f }, { -0.364193f, -0.92017f, -0.143701f },
  { -0.359054f, 0.933317f, 0.0f }, { -0.346f, 0.937044f, 0.047258f },
  { -0.296931f, 0.839966f, -0.45419f }, { -0.253522f, 0.852596f, 0.456953f },
  { -0.232493f, -0.635243f, -0.736488f }, { -0.229996f, -0.62449f, 0.746401f },
  { -0.049529f, 0.998773f, 0.0f }, { -0.049106f, 0.993418f, 0.103486f },
  { -0.038478f, 0.994751f, -0.094819f }, { -0.032809f, 0.828422f, 0.559142f },
  { -0.025027f, -0.015802f, -0.999562f }, { -0.025027f, -0.015802f, 0.999562f },
  { -0.023749f, 0.37854f, -0.92528f }, { -0.023749f, 0.37854f, 0.92528f },
  { -0.022635f, 0.127821f, -0.991539f }, { -0.022635f, 0.127821f, 0.991539f },
  { -0.021102f, 0.823816f, -0.566465f }, { -0.018509f, -0.936564f, -0.350008f },
  { -0.016719f, -0.653957f, -0.756347f }, { -0.002013f, -0.014006f, -0.9999f },
  { -0.002013f, -0.014006f, 0.9999f }, { 0.0f, 0.371861f, 0.928288f },
  { 0.0f, 0.371861f, -0.928288f }, { 0.0f, 0.823815f, 0.566859f },
  { 0.0f, 0.823815f, -0.566859f }, { 0.0f, 0.994583f, -0.103944f },
  { 0.0f, 0.994583f, 0.103944f }, { 0.0f, 1.0f, 0.0f },
  { 0.00071f, 0.117054f, 0.993125f }, { 0.00071f, 0.117054f, -0.993125f },
  { 0.013303f, -0.653991f, 0.756386f }, { 0.018509f, -0.936564f, 0.350007f },
  { 0.018855f, 0.824633f, 0.565353f }, { 0.023546f, 0.37508f, 0.926693f },
  { 0.023546f, 0.37508f, -0.926693f }, { 0.026915f, 0.129527f, 0.991211f },
  { 0.026915f, 0.129527f, -0.991211f }, { 0.030546f, 0.829253f, -0.558039f },
  { 0.031828f, -0.012896f, 0.99941f }, { 0.031828f, -0.012896f, -0.99941f },
  { 0.038478f, 0.994751f, 0.09482f }, { 0.049106f, 0.993418f, -0.103485f },
  { 0.049529f, 0.998773f, 0.0f }, { 0.236414f, -0.62426f, -0.744586f },
  { 0.238975f, -0.634967f, 0.734648f }, { 0.25695f, 0.855265f, -0.449998f },
  { 0.300127f, 0.842617f, 0.447124f }, { 0.345999f, 0.937044f, -0.047258f },
  { 0.359054f, 0.933317f, 0.0f }, { 0.364193f, -0.92017f, 0.143701f },
  { 0.365904f, 0.929316f, 0.049861f }, { 0.368868f, -0.921258f, -0.123366f },
  { 0.381969f, 0.602837f, -0.700491f }, { 0.384187f, 0.613094f, 0.690302f },
  { 0.401841f, -0.91571f, 0.0f }, { 0.484195f, 0.440179f, -0.756173f },
  { 0.491489f, 0.441235f, 0.750834f }, { 0.56508f, -0.51822f, 0.641975f },
  { 0.596231f, 0.127977f, 0.792547f }, { 0.615545f, -0.474017f, -0.629613f },
  { 0.621304f, 0.082635f, -0.7792f }, { 0.631096f, 0.767198f, 0.114569f },
  { 0.63751f, 0.763457f, -0.103514f }, { 0.637667f, 0.770312f, 0.0f },
  { 0.74557f, -0.666427f, 0.0f }, { 0.747538f, -0.661333f, 0.061849f },
  { 0.769264f, -0.632385f, -0.09122f }, { 0.780291f, 0.606221f, -0.153761f },
  { 0.781334f, 0.60203f, 0.164551f }, { 0.785483f, 0.618883f, 0.0f },
  { 0.975086f, 0.132404f, 0.177981f }, { 0.97528f, 0.103811f, -0.195071f },
  { 0.994502f, 0.104718f, 0.0f }
};

TEST_TRIANGLE3 Monk_triangle3_Shawl[184] = {
  { { 52, 13, 9 }, { 35, 13, 12 } }, { { 13, 52, 45 }, { 13, 35, 29 } },
  { { 76, 45, 52 }, { 44, 29, 35 } }, { { 45, 76, 79 }, { 29, 44, 54 } },
  { { 96, 79, 76 }, { 62, 54, 44 } }, { { 79, 96, 97 }, { 54, 62, 68 } },
  { { 137, 97, 96 }, { 82, 68, 62 } }, { { 97, 137, 131 }, { 68, 82, 81 } },
  { { 55, 9, 25 }, { 39, 12, 17 } }, { { 9, 55, 52 }, { 12, 39, 35 } },
  { { 75, 52, 55 }, { 52, 35, 39 } }, { { 52, 75, 76 }, { 35, 52, 44 } },
  { { 94, 76, 75 }, { 59, 44, 52 } }, { { 76, 94, 96 }, { 44, 59, 62 } },
  { { 120, 96, 94 }, { 80, 62, 59 } }, { { 96, 120, 137 }, { 62, 80, 82 } },
  { { 57, 25, 34 }, { 37, 17, 20 } }, { { 25, 57, 55 }, { 17, 37, 39 } },
  { { 72, 55, 57 }, { 45, 39, 37 } }, { { 55, 72, 75 }, { 39, 45, 52 } },
  { { 92, 75, 72 }, { 57, 52, 45 } }, { { 75, 92, 94 }, { 52, 57, 59 } },
  { { 112, 94, 92 }, { 77, 59, 57 } }, { { 94, 112, 120 }, { 59, 77, 80 } },
  { { 60, 34, 43 }, { 33, 20, 27 } }, { { 34, 60, 57 }, { 20, 33, 37 } },
  { { 74, 57, 60 }, { 47, 37, 33 } }, { { 57, 74, 72 }, { 37, 47, 45 } },
  { { 86, 72, 74 }, { 56, 45, 47 } }, { { 72, 86, 92 }, { 45, 56, 57 } },
  { { 105, 92, 86 }, { 70, 57, 56 } }, { { 92, 105, 112 }, { 57, 70, 77 } },
  { { 53, 18, 51 }, { 34, 15, 28 } }, { { 18, 53, 12 }, { 15, 34, 14 } },
  { { 77, 51, 83 }, { 43, 28, 42 } }, { { 51, 77, 53 }, { 28, 43, 34 } },
  { { 95, 83, 102 }, { 63, 42, 67 } }, { { 83, 95, 77 }, { 42, 63, 43 } },
  { { 138, 102, 133 }, { 84, 67, 83 } }, { { 102, 138, 95 }, { 67, 84, 63 } },
  { { 54, 12, 53 }, { 38, 14, 34 } }, { { 12, 54, 30 }, { 14, 38, 16 } },
  { { 71, 53, 77 }, { 53, 34, 43 } }, { { 53, 71, 54 }, { 34, 53, 38 } },
  { { 93, 77, 95 }, { 60, 43, 63 } }, { { 77, 93, 71 }, { 43, 60, 53 } },
  { { 122, 95, 138 }, { 79, 63, 84 } }, { { 95, 122, 93 }, { 63, 79, 60 } },
  { { 56, 30, 54 }, { 36, 16, 38 } }, { { 30, 56, 37 }, { 16, 36, 19 } },
  { { 68, 54, 71 }, { 46, 38, 53 } }, { { 54, 68, 56 }, { 38, 46, 36 } },
  { { 91, 71, 93 }, { 58, 53, 60 } }, { { 71, 91, 68 }, { 53, 58, 46 } },
  { { 114, 93, 122 }, { 76, 60, 79 } }, { { 93, 114, 91 }, { 60, 76, 58 } },
  { { 64, 37, 56 }, { 40, 19, 36 } }, { { 37, 64, 42 }, { 19, 40, 26 } },
  { { 66, 56, 68 }, { 48, 36, 46 } }, { { 56, 66, 64 }, { 36, 48, 40 } },
  { { 90, 68, 91 }, { 61, 46, 58 } }, { { 68, 90, 66 }, { 46, 61, 48 } },
  { { 107, 91, 114 }, { 69, 58, 76 } }, { { 91, 107, 90 }, { 58, 69, 61 } },
  { { 47, 14, 46 }, { 21, 13, 29 } }, { { 14, 47, 3 }, { 13, 21, 6 } },
  { { 78, 46, 80 }, { 55, 29, 54 } }, { { 46, 78, 47 }, { 29, 55, 21 } },
  { { 99, 80, 98 }, { 73, 54, 68 } }, { { 80, 99, 78 }, { 54, 73, 55 } },
  { { 141, 98, 132 }, { 89, 68, 81 } }, { { 98, 141, 99 }, { 68, 89, 73 } },
  { { 48, 3, 47 }, { 18, 6, 21 } }, { { 3, 48, 5 }, { 6, 18, 8 } },
  { { 143, 99, 141 }, { 88, 73, 89 } }, { { 99, 143, 100 }, { 73, 88, 78 } },
  { { 49, 5, 48 }, { 23, 8, 18 } }, { { 5, 49, 7 }, { 8, 23, 7 } },
  { { 145, 100, 143 }, { 90, 78, 88 } }, { { 100, 145, 101 }, { 78, 90, 75 } },
  { { 50, 7, 49 }, { 28, 7, 23 } }, { { 7, 50, 16 }, { 7, 28, 15 } },
  { { 82, 49, 81 }, { 42, 23, 41 } }, { { 49, 82, 50 }, { 23, 42, 28 } },
  { { 103, 81, 101 }, { 67, 41, 75 } }, { { 81, 103, 82 }, { 41, 67, 42 } },
  { { 135, 101, 145 }, { 83, 75, 90 } }, { { 101, 135, 103 }, { 75, 83, 67 } },
  { { 146, 130, 136 }, { 94, 81, 82 } }, { { 130, 146, 140 }, { 81, 94, 89 } },
  { { 125, 136, 119 }, { 92, 82, 80 } }, { { 136, 125, 146 }, { 82, 92, 94 } },
  { { 115, 118, 111 }, { 85, 80, 77 } }, { { 118, 115, 124 }, { 80, 85, 92 } },
  { { 108, 111, 104 }, { 74, 77, 70 } }, { { 111, 108, 115 }, { 77, 74, 85 } },
  { { 147, 140, 146 }, { 96, 89, 94 } }, { { 140, 147, 142 }, { 89, 96, 88 } },
  { { 127, 146, 125 }, { 93, 94, 92 } }, { { 146, 127, 147 }, { 94, 93, 96 } },
  { { 116, 124, 115 }, { 87, 92, 85 } }, { { 124, 116, 126 }, { 92, 87, 93 } },
  { { 109, 115, 108 }, { 72, 85, 74 } }, { { 115, 109, 116 }, { 85, 72, 87 } },
  { { 148, 142, 147 }, { 95, 88, 96 } }, { { 142, 148, 144 }, { 88, 95, 90 } },
  { { 129, 147, 127 }, { 91, 96, 93 } }, { { 147, 129, 148 }, { 96, 91, 95 } },
  { { 117, 126, 116 }, { 86, 93, 87 } }, { { 126, 117, 128 }, { 93, 86, 91 } },
  { { 110, 116, 109 }, { 71, 87, 72 } }, { { 116, 110, 117 }, { 87, 71, 86 } },
  { { 139, 144, 148 }, { 84, 90, 95 } }, { { 144, 139, 134 }, { 90, 84, 83 } },
  { { 123, 148, 129 }, { 79, 95, 91 } }, { { 148, 123, 139 }, { 95, 79, 84 } },
  { { 113, 128, 117 }, { 76, 91, 86 } }, { { 128, 113, 121 }, { 91, 76, 79 } },
  { { 106, 117, 110 }, { 69, 86, 71 } }, { { 117, 106, 113 }, { 86, 69, 76 } },
  { { 84, 104, 85 }, { 64, 70, 56 } }, { { 104, 84, 108 }, { 70, 64, 74 } },
  { { 70, 85, 73 }, { 50, 56, 47 } }, { { 85, 70, 84 }, { 56, 50, 64 } },
  { { 58, 73, 61 }, { 31, 47, 33 } }, { { 73, 58, 70 }, { 47, 31, 50 } },
  { { 38, 61, 44 }, { 25, 33, 27 } }, { { 61, 38, 58 }, { 33, 25, 31 } },
  { { 87, 108, 84 }, { 66, 74, 64 } }, { { 108, 87, 109 }, { 74, 66, 72 } },
  { { 69, 84, 70 }, { 51, 64, 50 } }, { { 84, 69, 87 }, { 64, 51, 66 } },
  { { 62, 70, 58 }, { 30, 50, 31 } }, { { 70, 62, 69 }, { 50, 30, 51 } },
  { { 39, 58, 38 }, { 24, 31, 25 } }, { { 58, 39, 62 }, { 31, 24, 30 } },
  { { 88, 109, 87 }, { 65, 72, 66 } }, { { 109, 88, 110 }, { 72, 65, 71 } },
  { { 67, 87, 69 }, { 49, 66, 51 } }, { { 87, 67, 88 }, { 66, 49, 65 } },
  { { 59, 69, 62 }, { 32, 51, 30 } }, { { 69, 59, 67 }, { 51, 32, 49 } },
  { { 40, 62, 39 }, { 22, 30, 24 } }, { { 62, 40, 59 }, { 30, 22, 32 } },
  { { 89, 110, 88 }, { 61, 71, 65 } }, { { 110, 89, 106 }, { 71, 61, 69 } },
  { { 65, 88, 67 }, { 48, 65, 49 } }, { { 88, 65, 89 }, { 65, 48, 61 } },
  { { 63, 67, 59 }, { 40, 49, 32 } }, { { 67, 63, 65 }, { 49, 40, 48 } },
  { { 41, 59, 40 }, { 26, 32, 22 } }, { { 59, 41, 63 }, { 32, 26, 40 } },
  { { 31, 44, 35 }, { 10, 27, 20 } }, { { 44, 31, 38 }, { 27, 10, 25 } },
  { { 20, 35, 27 }, { 5, 20, 17 } }, { { 35, 20, 31 }, { 20, 5, 10 } },
  { { 0, 26, 10 }, { 1, 17, 12 } }, { { 26, 0, 19 }, { 17, 1, 5 } },
  { { 4, 10, 15 }, { 6, 12, 13 } }, { { 10, 4, 0 }, { 12, 6, 1 } },
  { { 32, 38, 31 }, { 9, 25, 10 } }, { { 38, 32, 39 }, { 25, 9, 24 } },
  { { 22, 31, 20 }, { 3, 10, 5 } }, { { 31, 22, 32 }, { 10, 3, 9 } },
  { { 1, 19, 0 }, { 0, 5, 1 } }, { { 19, 1, 21 }, { 5, 0, 3 } },
  { { 6, 0, 4 }, { 8, 1, 6 } }, { { 0, 6, 1 }, { 1, 8, 0 } },
  { { 33, 39, 32 }, { 11, 24, 9 } }, { { 39, 33, 40 }, { 24, 11, 22 } },
  { { 24, 32, 22 }, { 4, 9, 3 } }, { { 32, 24, 33 }, { 9, 4, 11 } },
  { { 2, 21, 1 }, { 2, 3, 0 } }, { { 21, 2, 23 }, { 3, 2, 4 } },
  { { 8, 1, 6 }, { 7, 0, 8 } }, { { 1, 8, 2 }, { 0, 7, 2 } },
  { { 36, 40, 33 }, { 19, 22, 11 } }, { { 40, 36, 41 }, { 22, 19, 26 } },
  { { 29, 33, 24 }, { 16, 11, 4 } }, { { 33, 29, 36 }, { 11, 16, 19 } },
  { { 11, 23, 2 }, { 14, 4, 2 } }, { { 23, 11, 28 }, { 4, 14, 16 } },
  { { 17, 2, 8 }, { 15, 2, 7 } }, { { 2, 17, 11 }, { 2, 15, 14 } }
};

TEST_3D_DATA4 Monk_3d_data4[11] = {
  { "Body",
    Monk_matrix_Body,
    306, 208, 392,
    Monk_xyz_uv_Body,
    Monk_normal_Body,
    Monk_triangle3_Body, 
    1, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f }, 
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\BlueChain.bmp" },
  { "Head",
    Monk_matrix_Head,
    34, 34, 48,
    Monk_xyz_uv_Head,
    Monk_normal_Head,
    Monk_triangle3_Head,
    0, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Hood",
    Monk_matrix_Hood,
    200, 131, 244,
    Monk_xyz_uv_Hood,
    Monk_normal_Hood,
    Monk_triangle3_Hood,
    1, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\BlueChain.bmp" },
  { "Rhand",
    Monk_matrix_Rhand,
    48, 48, 90,
    Monk_xyz_uv_Rhand,
    Monk_normal_Rhand,
    Monk_triangle3_Rhand,
    0, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Lhand",
    Monk_matrix_Lhand,
    48, 48, 90,
    Monk_xyz_uv_Lhand,
    Monk_normal_Lhand,
    Monk_triangle3_Lhand,
    0, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "" },
  { "Llower_arm",
    Monk_matrix_Llower_arm,
    66, 34, 64,
    Monk_xyz_uv_Llower_arm,
    Monk_normal_Llower_arm,
    Monk_triangle3_Llower_arm,
    1, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\BlueChain.bmp" },
  { "Rlower_arm",
    Monk_matrix_Rlower_arm,
    66, 34, 64,
    Monk_xyz_uv_Rlower_arm,
    Monk_normal_Rlower_arm,
    Monk_triangle3_Rlower_arm,
    1, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\BlueChain.bmp" },
  { "Rope_belt",
    Monk_matrix_Rope_belt,
    120, 58, 92,
    Monk_xyz_uv_Rope_belt,
    Monk_normal_Rope_belt,
    Monk_triangle3_Rope_belt,
    1, 252,
    { 0.584314f, 0.584314f, 0.584314f }, { 0.584314f, 0.584314f, 0.584314f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\BlueChrome.bmp" },
  { "Lupper_arm",
    Monk_matrix_Lupper_arm,
    57, 33, 56,
    Monk_xyz_uv_Lupper_arm,
    Monk_normal_Lupper_arm,
    Monk_triangle3_Lupper_arm,
    1, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\BlueChain.bmp" },
  { "Rupper_arm",
    Monk_matrix_Rupper_arm,
    57, 33, 56,
    Monk_xyz_uv_Rupper_arm,
    Monk_normal_Rupper_arm,
    Monk_triangle3_Rupper_arm,
    1, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\BlueChain.bmp" },
  { "Shawl",
    Monk_matrix_Shawl,
    149, 97, 184,
    Monk_xyz_uv_Shawl,
    Monk_normal_Shawl,
    Monk_triangle3_Shawl,
    1, 252,
    { 0.588235f, 0.588235f, 0.588235f }, { 0.588235f, 0.588235f, 0.588235f },
    { 0.898039f, 0.898039f, 0.898039f }, { 0.0f, 0.0f, 0.0f },
    "D:\\Obj0\\BlueChain.bmp" },
};
