// BitmapPage.cpp : implementation file
//

#include "stdafx.h"
#include "..\at3ddll.h"
#include "MSVC_Test_At3dx_Dll.h"
#include "BitmapPage.h"
#include "At3dData.h"

extern CAt3dData* at3dData;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBitmapPage property page

IMPLEMENT_DYNCREATE(CBitmapPage, CPropertyPage)

CBitmapPage::CBitmapPage() : CPropertyPage(CBitmapPage::IDD)
{
	//{{AFX_DATA_INIT(CBitmapPage)
	m_BitmapTo3D_SkipDlg = FALSE;
	m_BitmapTo3D_AddFaces = FALSE;
	m_BitmapTo3D_Decode0 = FALSE;
	m_BitmapTo3D_Extrude = FALSE;
	m_BitmapTo3D_SaveOutlines = FALSE;
	m_BitmapToDem_MinHeight = _T("");
	m_BitmapToDem_Multiplier1 = _T("");
	m_BitmapToDem_Multiplier2 = _T("");
	m_BitmapToDem_SeaLevel = FALSE;
	m_BitmapToDem_SkipDlg = FALSE;
	m_BitmapToDem_Spacing = _T("");
	m_BitmapTo3D_ExtrudeHeight = _T("");
	m_BitmapTo3D_JoinOutlines = FALSE;
	//}}AFX_DATA_INIT
}

CBitmapPage::~CBitmapPage()
{
}

void CBitmapPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBitmapPage)
	DDX_Control(pDX, IDC_TEMPSNAPSHOTPANEL, m_TempSnapshotPanel);
	DDX_Check(pDX, IDC_BITMAPTO3D_SKIPDLG, m_BitmapTo3D_SkipDlg);
	DDX_Check(pDX, IDC_BITMAPTO3D_ADDFACES, m_BitmapTo3D_AddFaces);
	DDX_Check(pDX, IDC_BITMAPTO3D_DECODE0, m_BitmapTo3D_Decode0);
	DDX_Check(pDX, IDC_BITMAPTO3D_EXTRUDE, m_BitmapTo3D_Extrude);
	DDX_Check(pDX, IDC_BITMAPTO3D_SAVEOUTLINES, m_BitmapTo3D_SaveOutlines);
	DDX_Text(pDX, IDC_BITMAPTODEM_MINHEIGHT, m_BitmapToDem_MinHeight);
	DDX_Text(pDX, IDC_BITMAPTODEM_MULTIPLIER1, m_BitmapToDem_Multiplier1);
	DDX_Text(pDX, IDC_BITMAPTODEM_MULTIPLIER2, m_BitmapToDem_Multiplier2);
	DDX_Check(pDX, IDC_BITMAPTODEM_SEALEVEL, m_BitmapToDem_SeaLevel);
	DDX_Check(pDX, IDC_BITMAPTODEM_SKIPDLG, m_BitmapToDem_SkipDlg);
	DDX_Text(pDX, IDC_BITMAPTODEM_SPACING, m_BitmapToDem_Spacing);
	DDX_Text(pDX, IDC_BITMAPTO3D_EXTRUDEHEIGHT, m_BitmapTo3D_ExtrudeHeight);
	DDX_Check(pDX, IDC_BITMAPTO3D_JOINOUTLINES, m_BitmapTo3D_JoinOutlines);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBitmapPage, CPropertyPage)
	//{{AFX_MSG_MAP(CBitmapPage)
	ON_BN_CLICKED(IDC_BITMAPTO3D_SKIPDLG, OnBitmapto3dSkipdlg)
	ON_BN_CLICKED(IDC_BITMAPTO3D_DECODE0, OnBitmapto3dDecode0)
	ON_BN_CLICKED(IDC_BITMAPTO3D_SAVEOUTLINES, OnBitmapto3dSaveoutlines)
	ON_BN_CLICKED(IDC_BITMAPTO3D_ADDFACES, OnBitmapto3dAddfaces)
	ON_BN_CLICKED(IDC_BITMAPTO3D_EXTRUDE, OnBitmapto3dExtrude)
	ON_BN_CLICKED(IDC_BITMAPTODEM_SKIPDLG, OnBitmaptodemSkipdlg)
	ON_BN_CLICKED(IDC_BITMAPTODEM_SEALEVEL, OnBitmaptodemSealevel)
	ON_BN_CLICKED(IDC_GETOGLSNAPSHOT, OnGetoglsnapshot)	
	ON_BN_CLICKED(IDC_BITMAPTO3D_JOINOUTLINES, OnBitmapto3dJoinoutlines)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBitmapPage message handlers

BOOL CBitmapPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	m_BitmapTo3D_SkipDlg = (at3dData->bitmapTo3D_SkipDlg_Flag) ? TRUE : FALSE;
  m_BitmapTo3D_Decode0 = (at3dData->bitmapTo3D_Decode0_Flag) ? TRUE : FALSE;
  m_BitmapTo3D_SaveOutlines = (at3dData->bitmapTo3D_SaveOutlines_Flag) ? TRUE : FALSE;
  m_BitmapTo3D_JoinOutlines = (at3dData->bitmapTo3D_JoinOutlines_Flag) ? TRUE : FALSE;
	m_BitmapTo3D_AddFaces = (at3dData->bitmapTo3D_AddFaces_Flag) ? TRUE : FALSE;
  m_BitmapTo3D_Extrude = (at3dData->bitmapTo3D_Extrude_Flag) ? TRUE : FALSE;

	m_BitmapTo3D_ExtrudeHeight.Format("%.4f", at3dData->bitmapTo3D_ExtrudeHeight);

  m_BitmapToDem_SkipDlg = (at3dData->bitmapToDem_SkipDlg_Flag) ? TRUE : FALSE;
  m_BitmapToDem_SeaLevel = (at3dData->bitmapToDem_SeaLevel_Flag) ? TRUE : FALSE;

  m_BitmapToDem_Multiplier1.Format("%.4f", at3dData->bitmapToDem_BelowMultiplier);
  m_BitmapToDem_Multiplier2.Format("%.4f", at3dData->bitmapToDem_AboveMultiplier);
  m_BitmapToDem_MinHeight.Format("%.4f", at3dData->bitmapToDem_MinHeight);
  m_BitmapToDem_Spacing.Format("%.4f", at3dData->bitmapToDem_XY_Spacing);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CBitmapPage::OnBitmapto3dSkipdlg() 
{
	UpdateData(TRUE);
	at3dData->bitmapTo3D_SkipDlg_Flag = (m_BitmapTo3D_SkipDlg) ? 1 : 0; 
}

void CBitmapPage::OnBitmapto3dDecode0() 
{
	UpdateData(TRUE);
	at3dData->bitmapTo3D_Decode0_Flag = (m_BitmapTo3D_Decode0) ? 1 : 0;
}

void CBitmapPage::OnBitmapto3dSaveoutlines() 
{
	UpdateData(TRUE);
	at3dData->bitmapTo3D_SaveOutlines_Flag = (m_BitmapTo3D_SaveOutlines) ? 1 : 0;
}

void CBitmapPage::OnBitmapto3dAddfaces() 
{
	UpdateData(TRUE);
	at3dData->bitmapTo3D_AddFaces_Flag = (m_BitmapTo3D_AddFaces) ? 1 : 0;
}

void CBitmapPage::OnBitmapto3dExtrude() 
{
	UpdateData(TRUE);
	at3dData->bitmapTo3D_Extrude_Flag = (m_BitmapTo3D_Extrude) ? 1 : 0;
}

void CBitmapPage::Get_BitmapTo3D_Data(void)
{
  UpdateData(TRUE);
	
	at3dData->bitmapTo3D_ExtrudeHeight = atof(m_BitmapTo3D_ExtrudeHeight);
}

void CBitmapPage::OnBitmaptodemSkipdlg() 
{
	UpdateData(TRUE);
	at3dData->bitmapToDem_SkipDlg_Flag = (m_BitmapToDem_SkipDlg) ? 1 : 0; 
}

void CBitmapPage::OnBitmaptodemSealevel() 
{
	UpdateData(TRUE);
	at3dData->bitmapToDem_SeaLevel_Flag = (m_BitmapToDem_SeaLevel) ? 1 : 0;
}

void CBitmapPage::Get_BitmapToLandscape_Data(void)
{
  UpdateData(TRUE);
	
	at3dData->bitmapToDem_BelowMultiplier = atof(m_BitmapToDem_Multiplier1);
  
  at3dData->bitmapToDem_AboveMultiplier = atof(m_BitmapToDem_Multiplier2);
  
	at3dData->bitmapToDem_MinHeight = atof(m_BitmapToDem_MinHeight);
  
	at3dData->bitmapToDem_XY_Spacing = atof(m_BitmapToDem_Spacing);
}
  
BOOL CBitmapPage::OnKillActive() 
{
	// TODO: Add your specialized code here and/or call the base class
	Get_BitmapTo3D_Data();
	Get_BitmapToLandscape_Data();

	return CPropertyPage::OnKillActive();
}

void CBitmapPage::OnGetoglsnapshot() 
{
	RECT rect;
	m_TempSnapshotPanel.GetClientRect(&rect);
	
  __int32 width  = rect.right;
  __int32 height = rect.bottom;

	if ((at3dData->snapshotHbitmap) &&
		  (m_TempSnapshotPanel.GetBitmap() != at3dData->snapshotHbitmap))
	{
		m_TempSnapshotPanel.SetBitmap(at3dData->snapshotHbitmap);
	}

	at3dData->GetOglSnapshot(width, height, m_TempSnapshotPanel.GetSafeHwnd());	
}



void CBitmapPage::OnBitmapto3dJoinoutlines() 
{
	UpdateData(TRUE);
	at3dData->bitmapTo3D_JoinOutlines_Flag = (m_BitmapTo3D_JoinOutlines) ? 1 : 0;
}
