//----------------------------------------------------------------------------
//  Project Test_At3dx_Dll
//  MicroMouse Productions
//  Copyright  1999-2012. All Rights Reserved.
//  Author: Wayne Hogue
//
// this class was created for easily transferring code between
// Borland C++ Builder and Microsoft Visual C++
//
//----------------------------------------------------------------------------

#if !defined(at3dData_H)
#define at3dData_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#define LEN_LAYER_NAME       80
#define LEN_LAYER_LONGNAME   2 * LEN_LAYER_NAME + 8
#define LEN_XYZ_DELIMITERS   40
#define LEN_FILE_FNAME      200

typedef struct tag_XYZ {
  double x;
  double y;
  double z;
  } XYZ;

typedef struct tag_FLOAT_XYZ {
  float x;
  float y;
  float z;
  } FLOAT_XYZ;

typedef struct tag_XYZ_UV {
  double x;
  double y;
  double z;
  float u;
  float v;
  } XYZ_UV;

typedef struct tag_FLOAT_XYZ_UV {
  float x;
  float y;
  float z;
  float u;
  float v;
  } FLOAT_XYZ_UV;

typedef struct tag_EDGE {
  __int32 p0;
  __int32 p1;
  } EDGE;

typedef struct tag_TRIANGLE {
  __int32 p0;
  __int32 p1;
  __int32 p2;
  } TRIANGLE;

typedef struct tag_UV {
  float u;
  float v;
  } UV;

typedef struct tag_UV_TRI {
  float u0;
  float v0;
  float u1;
  float v1;
  float u2;
  float v2;
  } UV_TRI;

typedef struct tag_VNORMAL {
  float x;
  float y;
  float z;
  } VNORMAL;

typedef struct tag_VNORMAL_TRI {
  float x0;
  float y0;
  float z0;
  float x1;
  float y1;
  float z1;
  float x2;
  float y2;
  float z2;
  } VNORMAL_TRI;

typedef struct tag_VCOLOR {
  float red;
  float green;
  float blue;
  float alpha;
  } VCOLOR;

typedef struct tag_VCOLOR_TRI {
  float red0;
  float green0;
  float blue0;
  float alpha0;
  float red1;
  float green1;
  float blue1;
  float alpha1;
  float red2;
  float green2;
  float blue2;
  float alpha2;
  } VCOLOR_TRI;

typedef struct tag_RGB {
  float red;
  float green;
  float blue;
  } RGB;

typedef struct tag_RGBA {
  float red;
  float green;
  float blue;
  float alpha;
  } RGBA;

#define OGL_LIGHT_COUNT   8

typedef struct tag_OGL_LIGHT {
  __int32 enabledFlag;
  RGBA ambient;
  RGBA diffuse;
  RGBA specular;
  FLOAT_XYZ position;
  } OGL_LIGHT;

typedef struct tag_DATA_3D {
	struct tag_DATA_3D* lastData;
	struct tag_DATA_3D* nextData;
	char name[LEN_LAYER_NAME];
  char parentName[LEN_LAYER_NAME];
  //
  XYZ pivotPoint;
  //
	__int32 PCount3D;  // for 3D faces
	__int32 TCount;
	XYZ* xyz3D;
  FLOAT_XYZ* xyzFloat3D;
	TRIANGLE* xyzIndex;
	UV_TRI* uv_tri;
	VNORMAL_TRI* vnorm_tri;
  VCOLOR_TRI* vcolor_tri;
  RGB* rgb;
  //
  __int32 uvCount;
  __int32 vnormCount;
  __int32 vcolorCount;
  __int32 xyz_uvCount;
  __int32 uvPresentFlag;       // use with XYZ_UV
  UV* uv;
  VNORMAL* vnorm;
  VCOLOR* vcolor;
  XYZ_UV* xyz_uv;
  FLOAT_XYZ_UV* xyzFloat_uv;
  TRIANGLE* uvIndex;
  TRIANGLE* vnormIndex;
  TRIANGLE* vcolorIndex;
  //
  __int32 PCount2D;  // for 2D edges
  __int32 ECount2D;
  XYZ* xyz2D;
  FLOAT_XYZ* xyzFloat2D;
  EDGE* edge2D;
  //
  __int32 PCountCloud;  // for point cloud (no edges or faces)
  XYZ* xyzCloud;
  FLOAT_XYZ* xyzFloatCloud;
  //
	__int32 dxfColor;
	__int32 doubleSided;
	__int32 rwxGeometrySampling;
	__int32 rwxLightSampling;
	__int32 rwxTextureModes;
	__int32 rwxClumpTag;
  __int32 rwxFaceTag;
	float ambient1;
	RGB ambientRGB;
  RGB colorRGB;
	float diffuse1;
	RGB diffuseRGB;
  float reflection1;
  RGB reflectionRGB;
	float specular1;
	RGB specularRGB;
	RGB emissiveRGB;
	float roughness;
	float shininess;
	float transparency1;
	RGB transparencyRGB;
	float indexRefraction;
	float creaseAngle;
	char texturePathName[MAX_PATH];
  char maskPathName[MAX_PATH];
	} DATA_3D;


typedef struct tag_OBJECT_MINMAX {
  double minX;
  double maxX;
  double minY;
  double maxY;
  double minZ;
  double maxZ;
  } OBJECT_MINMAX;


typedef struct tag_LAYER_MINMAX {
  __int32 cloudVertexCount;
  __int32 lineVertexCount;
  __int32 meshVertexCount;
  __int32 lineCount;
  __int32 triangleCount;
  //
  double minX;
  double maxX;
  double minY;
  double maxY;
  double minZ;
  double maxZ;
  } LAYER_MINMAX;


typedef struct tag_MESH_TO_LANDSCAPE {
  __int32 stretchXFlag;
  __int32 stretchYFlag;
  __int32 convertFlag;
  __int32 addCloudFlag;
  __int32 dropFacesFlag;
  __int32 addBaseFlag;
  __int32 addUVFlag;
  __int32 writeXYZFlag;
  //
  double minX;
  double maxX;
  double sizeX;
  //
  double minY;
  double maxY;
  double sizeY;
  //
  double minZ;
  double maxZ;
  double sizeZ;
  //
  double xSpacing;
  double ySpacing;
  //
  __int32 xCount;
  __int32 yCount;
  __int32 vertCount;
  __int32 edgeCount;
  __int32 triangleCount;
  //
  double newSizeX;
  double newSizeY;
  double lastXSpacing;
  double lastYSpacing;
  //
  double dropElevation;
  double baseThickness;
  } MESH_TO_LANDSCAPE;


// values for transferFromTypeFlag
//
#define TRANSFERFROM_TYPE_BASIC     0
#define TRANSFERFROM_TYPE_ARRAYS    1
#define TRANSFERFROM_TYPE_XYZ_UV    2

#define BEVELS_ARRAY_TOTAL   20

class CAt3dData
{
public:
	CAt3dData();
	virtual ~CAt3dData();

  void Clear_All_Objects(void);
  void ReadFile(void);
  void ReadAndRotateFile(void);
  void WriteFile(void);
  DATA_3D* Allocate_Data_3D(void);
  __int32 Transfer_Face_Verts_FromDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_Verts_ToDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_UVs_FromDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_UVs_ToDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_VNormals_FromDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_VNormals_ToDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_VColors_FromDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_VColors_ToDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_Colors_FromDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_Face_Colors_ToDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_2DLines_FromDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_2DLines_ToDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_PointCloud_FromDll(__int32 fastFlag, DATA_3D* currentData);
  __int32 Transfer_PointCloud_ToDll(__int32 fastFlag, DATA_3D* currentData);
  void Transfer_Material_FromDll(DATA_3D* currentData);
  void Transfer_Material_ToDll(DATA_3D* currentData);
	void TransferFromDll(__int32 fastFlag);
	void TransferToDll(__int32 fastFlag);
	void ClearTransferData(void);
  void MergeVertices(void);
  void DeleteLayer(void);
  void MakeSmooth1(void);
  void MakeSmooth2(void);
  void EraseSmooth1(void);
  void EraseSmooth2(void);
  void SelectFont(void);
  void GetFontDirectory(void);
  void ConvertText(__int32 unicodeFlag);
  void GetDefaultMaterials(void);
  void StartStopAlign(void);
  void SelectAlignLayer(void);
  void FlipAlignLayer(void);
  void SpecialTransferFromDll(__int32 fastFlag);
	void SpecialTransferToDll(__int32 fastFlag);
  void TransferTextureSquareToDll1(void);
  void TransferTextureSquareToDll2(void);
  void TransferTextureSquareToDll3(void);
  void TransferRedKnightToDll(void);
  void TransferGreenKnightToDll(void);
  void TransferBlueKnightToDll(void);
  void TransferGreenMonkToDll(void);
  void TransferBlueMonkToDll(void);
  void TransferMultiMatKnightToDll(void);
  void Create_UV_Coordinates(void);
  void Remove_UV_Coordinates(void);
  void DivideTriangles(__int32 typeFlag);
  void WriteDemContourMap(void);
  void EraseLines1(void);
  void EraseLines2(void);
  void EraseClouds1(void);
  void EraseClouds2(void);
  void WatertightCheck(void);
  void EditGetUpperBevels(void);
  void EditSetUpperBevels(void);
  void EditGetLowerBevels(void);
  void EditSetLowerBevels(void);
  void ApplyBevels1(void);
  void ApplyBevels2(void);
  void ApplyBevels3(void);
  void Text_MakeBevelSets(void);  
  void GetStageImage(void);
  void StartReducePolygons(void);
  void SelectReducePolygonsLayer(void);
  void GetReducePolygonsLayerData(void);
  void DoReducePolygons(void);
  void GetBackgroundImage(void);
  void Create_snapshotRgbaArray(__int32 width, __int32 height);
  void Free_snapshotRgbaArray(void);
  void Create_snapshotDib(void);
  void Free_snapshotDib(void);
  void Transfer_Snapshot_To_Dib(void);
  void Display_snapshotDib(HWND destHwnd);
  void GetOglSnapshot( __int32 width, __int32 height, HWND destHwnd);
  void Calculate_DMS(double location, __int32* degreesPtr, __int32* minutesPtr,
                     double* secondsPtr, __int32* signPtr);
  double Combine_DMS(__int32 degrees, __int32 minutes, double seconds, __int32 sign);
  void Get_KML_Data_From_DLL(void);
  void Transfer_2D_Outlines(__int32 flag);
  //
	__int32 dllOpen;
  //
	HWND hwnd;  // used in MS VC++
  //
	__int32 dataCount;
	DATA_3D* parentData;
  //
	__int32 fileLoaded;
  char inName[MAX_PATH];
	char outName[MAX_PATH];
  //
	__int32 readType;
	__int32 writeType;
  //
  char alignName[LEN_LAYER_NAME];
	void* alignNextLayer;
  //
  char fontPath[MAX_PATH];
  char dxfFontName[LF_FACESIZE];
  char vrmlSerifFontName[LF_FACESIZE];
  char vrmlSansFontName[LF_FACESIZE];
  char vrmlTypewriterFontName[LF_FACESIZE];
  //
	char textText[256];
  wchar_t textUnicodeText[256];
	char textFaceName[LF_FACESIZE];
	__int32 textLayersFlag;
	__int32 textStencilFlag;
	__int32 textPlusCoreFlag;
  __int32 textReverseOutlinesFlag;
  __int32 textOnCurveFlag;
  __int32 textOrigVertsFlag;
  __int32 textAllCharsFlag;
	__int32 textReduceFlag;
	__int32 textJoinFlag;
	__int32 textFaceFlag;
	__int32 textExtrudeFlag;
	__int32 textBoldFlag;
	__int32 textItalicFlag;
	__int32 textPoints;
	double textHeight;
	double textDepth;
	double textBorder;
  //
	__int32 vrmlTextFlag;
  //
  __int32 outputAvatarFlag;
  __int32 outputHierarchyFlag;
  __int32 oneLayerPerFileFlag;
  __int32 multiMaterialFlag;
  __int32 quadFlag;
	__int32 uvFlag;
	__int32 vnormFlag;
  __int32 vcolorFlag;
  __int32 savePointCloudFlag;
  __int32 save2DFlag;
  __int32 autoDivideLayersFlag;
  __int32 noIndentFlag;
  __int32 textAsTextFlag;
  //
  __int32 bufferReadFlag;
	__int32 bufferWriteFlag;
  //
  __int32 transferFromTypeFlag;
  __int32 vertexFloatTransferFlag;
  //
  __int32 removeVerticesFlag;
  __int32 removeFacesFlag;
  //
  __int32 useDxfTextFlag;
  //
  __int32 outType3dmf;
  __int32 pixelFlag3dmf;
  //
  __int32 showReadMessagesFlag;
  __int32 showSaveMessagesFlag;
  //
  double triQuadNormalAngle;
  double triQuadEdgeAngle;
  //
  __int32 useOglFlag;
  __int32 oglDebugMsgFlag;
  __int32 pauseAtOglSnapshotMsgFlag;
  __int32 twoSidedLightingFlag;
  __int32 cullBackFacesFlag;
	__int32 displayTexturesFlag;
  __int32 defaultTextureFlag;
	__int32 oglReplaceFlag;
	__int32 useWhiteBaseFlag;
  __int32 textureSearchFlag;
  __int32 textureNameMatchFlag;
  __int32 relocateTexturesFlag;
  __int32 saveTexturePathFlag;
  __int32 partialTexturePathFlag;
  //
  double cameraXViewPoint;
  double cameraYViewPoint;
  double cameraZViewPoint;
  //
  __int32 cameraRotateSpeed;
  double cameraXAngle;
  double cameraYAngle;
  double cameraZAngle;
  double cameraStepAngle;
  //
  double cameraInitialDistance;
  double cameraDistance;
  __int32 cameraZoomSpeed;
  __int32 reverseZoomDirectionFlag;
  __int32 reversePanDirectionFlag;
  //
  double cameraFieldOfView;
  double cameraStepFOV;
  //
  __int32 cameraXPan;
  __int32 cameraZPan;
  __int32 cameraStepPan;
  //
  OBJECT_MINMAX objectMinMax;
  XYZ objectCenter;
  XYZ objectEdit;
  __int32 originRotateFlag;
  __int32 drawObjectAxesFlag;
  //
  float defaultAmbient1;
  RGB defaultAmbientRGB;
  RGB defaultColorRGB;
  float defaultDiffuse1;
  RGB defaultDiffuseRGB;
  float defaultSpecular1;
  RGB defaultSpecularRGB;
  RGB defaultEmissiveRGB;
  float defaultRoughness;
  float defaultShininess;
  float defaultTransparency1;
  RGB defaultTransparencyRGB;
  float defaultIndexOfRefraction;
  float defaultCreaseAngle;
  __int32 defaultDxfColor;
  __int32 defaultDoubleSided;
  __int32 defaultRwxGeometrySampling;
  __int32 defaultRwxLightSampling;
  __int32 defaultRwxTextureModes;
  __int32 defaultRwxClumpTag;
  __int32 defaultRwxFaceTag;
  //
  __int32 inCount;
  __int32 inIndex;
  __int32 inType[50];
  char* inLabel[50];
  char* inExt[50];
  //
  __int32 outCount;
  __int32 outIndex;
  __int32 outType[46];
  char* outLabel[46];
  char* outExt[46];
  //
  __int32 oglRenderCount;
  __int32 oglRenderIndex;
  __int32 oglRenderType[10];
  char* oglRenderLabel[10];
  //
  __int32 backgroundCount;
  __int32 backgroundIndex;
  __int32 backgroundType[5];
  char* backgroundLabel[5];
  RGB backgroundColor;
  //
  float textureCenter[2];
  float textureRotation;
  float textureScale[2];
  float textureTranslation[2];
  __int32 textureTypeIndex;
  __int32 textureTypeCount;
  __int32 textureType[3];
  char* textureTypeLabel[3];
  //
  __int32 useFilmstripFlag;
  __int32 filmstripTimerFlag;
  //
  __int32 useAmbient1Flag;
  __int32 useDiffuse1Flag;
  __int32 useReflection1Flag;
  __int32 useSpecular1Flag;
  __int32 useTransparency1Flag;
  //
  __int32 demBitsPerPixel;
  __int32 demColumns;
  __int32 demRows;
  double demXSpacing;
  double demYSpacing;
  double demMinHeight;
  double demMaxHeight;
  __int32 demXOffset;
  __int32 demYOffset;
  __int32 demSeaLevelFlag;
  float demBelowFactor;
  float demAboveFactor;
  //
  __int32 extrudeModeFlag;
  __int32 bevelSetsFlag;
  char textName[LEN_LAYER_NAME];
	void* textNextLayer;
  //
  char editName[LEN_LAYER_NAME];
	void* editNextLayer;
  //
  double editMoveVertexX;
  double editMoveVertexY;
  double editMoveVertexZ;
  double editMoveVertexStep;
  //
  double editRotateXAngle;
  double editRotateYAngle;
  double editRotateZAngle;
  double editRotateStepAngle;
  //
  double editScaleXFactor;
  double editScaleYFactor;
  double editScaleZFactor;
  double editScaleStepFactor;
  //
  double editGridSize;
  //
  __int32 editSnapKeepRelativeFlag;
  //
  __int32 upperBevelsCount;
  __int32 lowerBevelsCount;
  double upperBevelsWidth[BEVELS_ARRAY_TOTAL];
  double upperBevelsHeight[BEVELS_ARRAY_TOTAL];
  double lowerBevelsWidth[BEVELS_ARRAY_TOTAL];
  double lowerBevelsHeight[BEVELS_ARRAY_TOTAL];
  //
  MESH_TO_LANDSCAPE meshToLandscape;
  //
  __int32 extrude2D_open;
  __int32 extrude2D_typeFlag;
  double extrude2D_minMax[6];
  double extrude2D_xRotation;
  double extrude2D_yRotation;
  double extrude2D_zRotation;
  double extrude2D_thickness;
  double extrude2D_adjustLocation;
  double extrude2D_stepAngle;
  void* extrude2D_layerPtr;
  char extrude2D_layerName[LEN_LAYER_NAME];
  //
  __int32 vrmlByChiefArchitectFlag;
  __int32 vrmlMiterJointExtrusionFlag;
  //
  __int32 kerkytheaUseRadianceFlag;
  __int32 kerkytheaRadianceEmitterFlag;
  __int32 kerkytheaUsePngAlphaMasksFlag;
  __int32 kerkytheaDirectionalAsSpotFlag;
  __int32 kerkytheaPointAsSpotFlag;
  __int32 kerkytheaPointUpFlag;
  __int32 kerkytheaDirectionalAttenuationFlag;
  __int32 kerkytheaPointAttenuationFlag;
  __int32 kerkytheaSpotAttenuationFlag;
  __int32 kerkytheaSpotReplaceFlag;
  __int32 kerkytheaSpotUseHotFractionFlag;

  __int32 kerkytheaDirectionalShadowFlag;
  __int32 kerkytheaDirectionalSoftShadowFlag;
  __int32 kerkytheaDirectionalGlobalPhotonsFlag;
  __int32 kerkytheaDirectionalCausticPhotonsFlag;
  __int32 kerkytheaDirectionalNegativeFlag;

  __int32 kerkytheaPointShadowFlag;
  __int32 kerkytheaPointSoftShadowFlag;
  __int32 kerkytheaPointGlobalPhotonsFlag;
  __int32 kerkytheaPointCausticPhotonsFlag;
  __int32 kerkytheaPointNegativeFlag;

  __int32 kerkytheaSpotShadowFlag;
  __int32 kerkytheaSpotSoftShadowFlag;
  __int32 kerkytheaSpotGlobalPhotonsFlag;
  __int32 kerkytheaSpotCausticPhotonsFlag;
  __int32 kerkytheaSpotNegativeFlag;

  float kerkytheaDirectionalMultiplier;
  float kerkytheaPointMultiplier;
  float kerkytheaSpotMultiplier;
  float kerkytheaDirectionalFallOff;
  float kerkytheaPointFallOff;
  float kerkytheaSpotFallOff;
  float kerkytheaDirectionalHotSpot;
  float kerkytheaPointHotSpot;
  float kerkytheaSpotHotSpot;
  float kerkytheaSpotHotFraction;
  float kerkytheaDirectionalRadius;
  float kerkytheaPointRadius;
  float kerkytheaSpotRadius;
  //
  char xyzDelimiters[LEN_XYZ_DELIMITERS];
    __int32 xyzSkipDlgFlag;     // if set, do not use XyzDialog
    __int32 xyzScanFlag;        // 0 = row and column mesh, 1 = probe scan,
                                // 2 = double Z scan
    __int32 xyzBinaryFileFlag;  // 0 = ASCII, 1 = binary
    __int32 xyzMotorolaFlag;    // 0 = Intel, 1 = Motorola
    __int32 xyzDoubleFlag;      // 0 = float, 1 = double
    __int32 xyzRows;            // number of rows
    __int32 xyzColumns;         // number of columns
    __int32 xyzByColumnFlag;    // 0 = by row, 1 = by column    
    __int32 xyzClipFlag;
    __int32 xyzFromRow;
    __int32 xyzToRow;
    __int32 xyzFromColumn;
    __int32 xyzToColumn;
    __int32 xyzAxisFlag;        // axis system
    __int32 xyzSaveDxfFlag;
    __int32 xyzDxfReleaseFlag;  // 0 = R10 Flat 0, 1 = R10 Flag 1, 2 = R11+
    __int32 xyzNoDataFlag;
    double xyzNoDataValue;
    __int32 xyzNoDataReplaceFlag;
    double xyzNoDataReplaceValue;
    __int32 xyzScaleZFlag;
    double xyzScaleFactorZ;
    __int32 xyzHasIdFlag;
    __int32 xyzUseIdFlag;
  //
  char stageImageName[MAX_PATH];
  __int32 stageUseFlag;
  __int32 stageOriginFlag;
  __int32 stageSquaresFlag;
  __int32 stageImageFlag;
  double stageSpacing;
  double stageWidth;
  double stageDepth;
  double stageOriginX;
  double stageOriginY;
  //
  char reducePolygonsName[LEN_LAYER_NAME];
	void* reducePolygonsNextLayer;
  __int32 reducePolygonsVertices0;
  __int32 reducePolygonsVertices1;
  __int32 reducePolygonsTriangles0;
  __int32 reducePolygonsTriangles1;
  __int32 reducePolygonsStep;
  //
  char backgroundImageName[MAX_PATH];
  __int32 backgroundImageUseFlag;
  //
  __int32 bitmapTo3D_SkipDlg_Flag;        // if set do not use BitmapTo3dDlg
  __int32 bitmapTo3D_Decode0_Flag;
  __int32 bitmapTo3D_SaveOutlines_Flag;
  __int32 bitmapTo3D_JoinOutlines_Flag;
  __int32 bitmapTo3D_AddFaces_Flag;
  __int32 bitmapTo3D_Extrude_Flag;
  double bitmapTo3D_ExtrudeHeight;
  //
  __int32 bitmapToDem_SkipDlg_Flag;       // if set do not use DemMultDlg
  __int32 bitmapToDem_SeaLevel_Flag;
  double bitmapToDem_BelowMultiplier;
  double bitmapToDem_AboveMultiplier;
  double bitmapToDem_MinHeight;
  double bitmapToDem_XY_Spacing;
  //
  unsigned __int8* snapshotRgbaArray;
  __int32 snapshotWidth;
  __int32 snapshotHeight;
   BITMAPINFO* snapshotBmInfoPtr;
   unsigned __int8* snapshotImagePtr;
   HBITMAP snapshotHbitmap;
  //
  __int32 modoCameraSunlightFlag;
  __int32 modoHierarchyFlag;
  __int32 modoWithJointsFlag;
  //
  char layerMinMaxName[LEN_LAYER_NAME];
	void* layerMinMaxNextLayer;
  //
  RGBA oglGlobalAmbient;
  OGL_LIGHT oglDirectionalLights[OGL_LIGHT_COUNT];
  __int32 oglSelectedLight;
  //
  // KML values for doc.kml for Google Earth
  //
  __int32 kmlModel_Altitude_Mode_Flag;
  __int32 kmlLookAt_Altitude_Mode_Flag;
  //
  __int32 kmlModel_Latitude_Degrees;
  __int32 kmlModel_Latitude_Minutes;
  double  kmlModel_Latitude_Seconds;
  __int32 kmlModel_Latitude_Sign;
  __int32 kmlModel_Longitude_Degrees;
  __int32 kmlModel_Longitude_Minutes;
  double  kmlModel_Longitude_Seconds;
  __int32 kmlModel_Longitude_Sign;
  double  kmlModel_Altitude;
  double  kmlModel_Heading;
  double  kmlModel_Tilt;
  double  kmlModel_Roll;
  double  kmlModel_Scale_X;
  double  kmlModel_Scale_Y;
  double  kmlModel_Scale_Z;
  //
  __int32 kmlLookAt_Latitude_Degrees;
  __int32 kmlLookAt_Latitude_Minutes;
  double  kmlLookAt_Latitude_Seconds;
  __int32 kmlLookAt_Latitude_Sign;
  __int32 kmlLookAt_Longitude_Degrees;
  __int32 kmlLookAt_Longitude_Minutes;
  double  kmlLookAt_Longitude_Seconds;
  __int32 kmlLookAt_Longitude_Sign;
  double  kmlLookAt_Altitude;
  double  kmlLookAt_Heading;
  double  kmlLookAt_Tilt;
  double  kmlLookAt_Range;
  //
#ifdef USING_BCB
  AnsiString kmlFolderName;
  AnsiString kmlFolderDescription;
  AnsiString kmlPlacemarkName;
  AnsiString kmlPlacemarkDescription;
#else
	CString kmlFolderName;
  CString kmlFolderDescription;
  CString kmlPlacemarkName;
  CString kmlPlacemarkDescription;
#endif
  char kmlModelsFolderName[LEN_FILE_FNAME];
  char kmlImagesFolderName[LEN_FILE_FNAME];
  __int32 kmlUseModelsFolderFlag;
  __int32 kmlUseImagesFolderFlag;
  //
  char kmlAltitudeModeLabels[KML_ALTITUDE_MODE_COUNT][20];
  //
  __int32 colladaOutputUpAxisFlag;
  //
  __int32 grabKeyboardFocusFlag;
  __int32 alwaysShowCameraCursorFlag;
  __int32 debugStopMessagesFlag;
  //
  __int32 checkFixTransparenciesFlag;
  __int32 kmzInputModelFactorsFlag;
  __int32 alwaysWriteColladaTransparencyFlag;
  //
#ifdef USING_BCB
  AnsiString mayaVersion;
  AnsiString directxFramePrefix;
  AnsiString directxMaterialPrefix;
#else       
  CString mayaVersion;
  CString directxFramePrefix;
  CString directxMaterialPrefix;
#endif
  __int32 useDirectxFramePrefixFlag;
  __int32 useDirectxMaterialPrefixFlag;


}; // end class CAt3dData


#ifdef USING_BCB
class CMyImagePanel : public TPanel
{
  private:
    CAt3dData* at3dData;
  protected:
    virtual void __fastcall CreateParams(TCreateParams &Params);
    virtual void __fastcall Paint();
  public:
    __fastcall CMyImagePanel(CAt3dData* dataPtr, TComponent* Owner);
};
#endif

#endif // at3dData_H

